<?php

// Importar estilos del padre

function importar_estilos() {

    $parent_style = 'parent-style';

    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style ),
        wp_get_theme()->get('Version')
    );
}
add_action( 'wp_enqueue_scripts', 'importar_estilos' );

/*NOMBRE DE POST*/
function post_title_shortcode( $atts ) {
    $atts = shortcode_atts( array(
        'id' => get_the_ID(),
    ), $atts, 'post_title' );

    $post_title = get_the_title( $atts['id'] );
    return $post_title;
}
add_shortcode( 'post_title', 'post_title_shortcode' );
























// === FILTROS DE PRODUCTOS PERSONALIZADOS (Categoría, Material, Precio) ===
add_action('init', 'registrar_taxonomia_material');
function registrar_taxonomia_material() {
    register_taxonomy(
        'material',
        'product',
        [
            'label'             => 'Material',
            'hierarchical'      => true,
            'public'            => true,
            'rewrite'           => ['slug' => 'material'],
            'show_admin_column' => false,
        ]
    );
}

// Shortcode principal
add_shortcode('filtros_productos', 'mostrar_filtros_productos');
function mostrar_filtros_productos() {
    $base_url   = get_permalink( wc_get_page_id('shop') );
    $cat_act    = $_GET['product_cat'] ?? '';
    $mat_act    = $_GET['material']    ?? '';
    $ord_act    = $_GET['orden']       ?? '';

    $terms_cat  = get_terms([ 'taxonomy'=>'product_cat','hide_empty'=>false,'orderby'=>'name','order'=>'ASC' ]);
    $terms_mat  = get_terms([ 'taxonomy'=>'material','hide_empty'=>false,'orderby'=>'name','order'=>'ASC' ]);
    $ordenes    = [ 'precio-asc'=>'Menor a Mayor', 'precio-desc'=>'Mayor a Menor' ];

    ob_start(); ?>

    <style>
    .filtros-acordeon-container {
      color: #fff;
      font-family: inherit;
		padding: 20px;
    }
    .filtro-acordeon {
      margin-bottom: 16px;
      border: 1px solid rgba(255,255,255,0.15);
      border-radius: 8px;
      overflow: hidden;
    }
    .filtro-header {
      cursor: pointer;
      padding: 12px 16px;
      background: rgba(255,255,255,0.2);
      user-select: none;
      transition: background 0.2s ease;
    }
    .filtro-header:hover {
      background: rgba(255,255,255,0.1);
    }
    .filtro-titulo {
      font-weight: 600;
      letter-spacing: .2px;
    }
    .filtro-body {
      display: none;
      padding: 8px 0;
      background: rgba(255,255,255,0.04);
    }
    .filtro-acordeon.open .filtro-body {
      display: block;
    }
    .filtro-lista {
      padding: 0 12px;
    }
    .filtro-item {
      position: relative;
    }
    .filtro-item a {
      display: block;
      padding: 10px 4px;
      text-decoration: none;
      color: #fff;
      transition: opacity .2s ease;
    }
    .filtro-item::after {
      content: "";
      display: block;
      width: 100%;
      height: 1px;
      background: rgba(255,255,255,0.25);
    }
    .filtro-item.activo a {
      font-weight: 700;
      opacity: 1;
    }
    .filtro-item a:hover {
      opacity: .85;
    }
    .filtro-header:focus,
    .filtro-item a:focus {
      outline: 2px dashed rgba(255,255,255,0.6);
      outline-offset: 2px;
    }
    @media (max-width: 768px) {
      .filtro-header { padding: 12px; }
      .filtro-item a { padding: 10px 2px; }
    }
    </style>

    <script>
    function toggleFiltro(el){
      var card = el.closest('.filtro-acordeon');
      card.classList.toggle('open');
    }
    </script>

    <div class="filtros-acordeon-container">

      <?php if ( ! is_wp_error($terms_cat) ) : ?>
      <div class="filtro-acordeon open">
        <div class="filtro-header" onclick="toggleFiltro(this)">
          <span class="filtro-titulo">Categorías</span>
        </div>
        <div class="filtro-body">
          <div class="filtro-lista">
            <?php foreach($terms_cat as $t): 
              $url = add_query_arg([
                  'product_cat'=>$t->slug,
                  'material'   =>$mat_act?:null,
                  'orden'      =>$ord_act?:null
              ], $base_url);
              $sel = ($cat_act=== $t->slug)? ' activo':'';
              echo '<div class="filtro-item'.$sel.'"><a href="'.esc_url($url).'">'.esc_html($t->name).'</a></div>';
            endforeach; ?>
          </div>
        </div>
      </div>
      <?php endif; ?>

      <?php if ( ! is_wp_error($terms_mat) ) : ?>
      <div class="filtro-acordeon">
        <div class="filtro-header" onclick="toggleFiltro(this)">
          <span class="filtro-titulo">Material</span>
        </div>
        <div class="filtro-body">
          <div class="filtro-lista">
            <?php foreach($terms_mat as $t):
              $url = add_query_arg([
                  'material'   =>$t->slug,
                  'product_cat'=>$cat_act?:null,
                  'orden'      =>$ord_act?:null
              ], $base_url);
              $sel = ($mat_act=== $t->slug)? ' activo':'';
              echo '<div class="filtro-item'.$sel.'"><a href="'.esc_url($url).'">'.esc_html($t->name).'</a></div>';
            endforeach; ?>
          </div>
        </div>
      </div>
      <?php endif; ?>

      <div class="filtro-acordeon">
        <div class="filtro-header" onclick="toggleFiltro(this)">
          <span class="filtro-titulo">Precio</span>
        </div>
        <div class="filtro-body">
          <div class="filtro-lista">
            <?php foreach($ordenes as $slug=>$label):
              $url = add_query_arg([
                  'orden'      =>$slug,
                  'product_cat'=>$cat_act?:null,
                  'material'   =>$mat_act?:null
              ], $base_url);
              $sel = ($ord_act=== $slug)? ' activo':'';
              echo '<div class="filtro-item'.$sel.'"><a href="'.esc_url($url).'">'.$label.'</a></div>';
            endforeach; ?>
          </div>
        </div>
      </div>

    </div>

    <?php
    return ob_get_clean();
}

// === Orden personalizado ===
add_action('pre_get_posts', 'aplicar_orden_personalizado');
function aplicar_orden_personalizado($q) {
    if (!is_admin() && $q->is_main_query() && is_post_type_archive('product') && !empty($_GET['orden'])) {
        switch ($_GET['orden']) {
            case 'precio-asc':
                $q->set('orderby','meta_value_num');
                $q->set('meta_key','_price');
                $q->set('order','ASC');
                break;
            case 'precio-desc':
                $q->set('orderby','meta_value_num');
                $q->set('meta_key','_price');
                $q->set('order','DESC');
                break;
        }
    }
}
