/*! For license information please see trp-lang-switcher-configurator.js.LICENSE.txt */
(()=>{var e,t={54(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-color__wrapper[data-v-6f8cc29c]{align-items:center;display:flex;gap:8px;position:relative}.trp-color--picking[data-v-6f8cc29c]{-webkit-user-select:none;-moz-user-select:none;user-select:none}.trp-color-input[data-v-6f8cc29c]{border:1px solid #e2e2e4;border-radius:5px;cursor:pointer;height:29px;width:53px}.trp-color-input[data-v-6f8cc29c]:focus-visible{outline:2px solid var(--trp-settings-accent-color)}.trp-color__popover[data-v-6f8cc29c]{left:0;position:absolute;top:calc(100% + 4px);z-index:1000}.trp-color-code[data-v-6f8cc29c]{text-transform:uppercase}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/ColorField.vue"],names:[],mappings:"AAqFA,qCAGI,kBAAmB,CADnB,YAAa,CAEb,OAAQ,CAHR,iBAIJ,CAEA,qCACI,wBAAiB,CAAjB,qBAAiB,CAAjB,gBACJ,CAEA,kCAGI,wBAAyB,CACzB,iBAAkB,CAClB,cAAe,CAHf,WAAY,CADZ,UAKJ,CAEA,gDACI,kDACJ,CAEA,qCAGI,MAAO,CAFP,iBAAkB,CAClB,oBAAqB,CAErB,YACJ,CAEA,iCACI,wBACJ",sourcesContent:['<script setup>\r\nimport { ref, computed, onMounted, onBeforeUnmount } from \'vue\'\r\nimport \'vue-color/style.css\'\r\nimport { ChromePicker, tinycolor } from \'vue-color\'\r\n\r\nconst props = defineProps({\r\n    label      : { type: String, default: \'\' },\r\n    modelValue : { type: String, required: true }\r\n})\r\nconst emit = defineEmits([\'update:modelValue\'])\r\n\r\n// picker visibility + refs for click-outside\r\nconst showPicker = ref(false)\r\nconst swatchRef  = ref(null)\r\nconst pickerRef  = ref(null)\r\n\r\nfunction togglePicker() {\r\n    showPicker.value = !showPicker.value\r\n}\r\nfunction onClickOutside(e) {\r\n    if (\r\n        swatchRef.value && !swatchRef.value.contains(e.target) &&\r\n        pickerRef.value && !pickerRef.value.contains(e.target)\r\n    ) {\r\n        showPicker.value = false\r\n    }\r\n}\r\n\r\nonMounted(() => document.addEventListener(\'mousedown\', onClickOutside))\r\nonBeforeUnmount(() => document.removeEventListener(\'mousedown\', onClickOutside))\r\n\r\nconst tinyColorModel = computed({\r\n    get() {\r\n        return tinycolor(props.modelValue)\r\n    },\r\n    set(tc) {\r\n        // ensure we handle both hex-only and hex+alpha\r\n        const c = tinycolor(tc)\r\n        const hex  = c.toHexString().toUpperCase()\r\n        const alpha = Math.round(c.getAlpha() * 255)\r\n                          .toString(16)\r\n                          .padStart(2,\'0\')\r\n                          .toUpperCase()\r\n\r\n        const out = alpha === \'FF\' ? hex : `${hex}${alpha}`\r\n\r\n        emit(\'update:modelValue\', out)\r\n    }\r\n})\r\n<\/script>\r\n\r\n<template>\r\n    <div :class="{ \'trp-color--picking\': showPicker }">\r\n        <span v-if="label" class="trp-field__label trp-primary-text-bold">\r\n          {{ label }}\r\n        </span>\r\n        <div class="trp-color__wrapper">\r\n            <div\r\n                class="trp-color-input"\r\n                :style="{ background: modelValue }"\r\n                ref="swatchRef"\r\n                @click="togglePicker"\r\n                @keydown.enter.space="togglePicker"\r\n                role="button"\r\n                aria-label="Open colour picker"\r\n                tabindex="0"\r\n            />\r\n\r\n            <span class="trp-color-code trp-primary-text">\r\n                {{ modelValue.toUpperCase() }}\r\n            </span>\r\n\r\n            <div\r\n                v-if="showPicker"\r\n                class="trp-color__popover"\r\n                ref="pickerRef"\r\n                @mousedown.stop\r\n            >\r\n                <ChromePicker v-model:tinyColor="tinyColorModel" />\r\n            </div>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-color__wrapper {\r\n    position: relative;\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 8px;\r\n}\r\n\r\n.trp-color--picking {\r\n    user-select: none;\r\n}\r\n\r\n.trp-color-input {\r\n    width: 53px;\r\n    height: 29px;\r\n    border: 1px solid #E2E2E4;\r\n    border-radius: 5px;\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-color-input:focus-visible {\r\n    outline: 2px solid var(--trp-settings-accent-color);\r\n}\r\n\r\n.trp-color__popover {\r\n    position: absolute;\r\n    top: calc(100% + 4px);\r\n    left: 0;\r\n    z-index: 1000;\r\n}\r\n\r\n.trp-color-code {\r\n    text-transform: uppercase;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},72(e,t,n){"use strict";var r,i=function(){return void 0===r&&(r=Boolean(window&&document&&document.all&&!window.atob)),r},o=function(){var e={};return function(t){if(void 0===e[t]){var n=document.querySelector(t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}e[t]=n}return e[t]}}(),s=[];function a(e){for(var t=-1,n=0;n<s.length;n++)if(s[n].identifier===e){t=n;break}return t}function l(e,t){for(var n={},r=[],i=0;i<e.length;i++){var o=e[i],l=t.base?o[0]+t.base:o[0],c=n[l]||0,d="".concat(l," ").concat(c);n[l]=c+1;var h=a(d),u={css:o[1],media:o[2],sourceMap:o[3]};-1!==h?(s[h].references++,s[h].updater(u)):s.push({identifier:d,updater:m(u,t),references:1}),r.push(d)}return r}function c(e){var t=document.createElement("style"),r=e.attributes||{};if(void 0===r.nonce){var i=n.nc;i&&(r.nonce=i)}if(Object.keys(r).forEach(function(e){t.setAttribute(e,r[e])}),"function"==typeof e.insert)e.insert(t);else{var s=o(e.insert||"head");if(!s)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");s.appendChild(t)}return t}var d,h=(d=[],function(e,t){return d[e]=t,d.filter(Boolean).join("\n")});function u(e,t,n,r){var i=n?"":r.media?"@media ".concat(r.media," {").concat(r.css,"}"):r.css;if(e.styleSheet)e.styleSheet.cssText=h(t,i);else{var o=document.createTextNode(i),s=e.childNodes;s[t]&&e.removeChild(s[t]),s.length?e.insertBefore(o,s[t]):e.appendChild(o)}}function p(e,t,n){var r=n.css,i=n.media,o=n.sourceMap;if(i?e.setAttribute("media",i):e.removeAttribute("media"),o&&"undefined"!=typeof btoa&&(r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(o))))," */")),e.styleSheet)e.styleSheet.cssText=r;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(r))}}var f=null,g=0;function m(e,t){var n,r,i;if(t.singleton){var o=g++;n=f||(f=c(t)),r=u.bind(null,n,o,!1),i=u.bind(null,n,o,!0)}else n=c(t),r=p.bind(null,n,t),i=function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(n)};return r(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap)return;r(e=t)}else i()}}e.exports=function(e,t){(t=t||{}).singleton||"boolean"==typeof t.singleton||(t.singleton=i());var n=l(e=e||[],t);return function(e){if(e=e||[],"[object Array]"===Object.prototype.toString.call(e)){for(var r=0;r<n.length;r++){var i=a(n[r]);s[i].references--}for(var o=l(e,t),c=0;c<n.length;c++){var d=a(n[c]);0===s[d].references&&(s[d].updater(),s.splice(d,1))}n=o}}}},85(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-settings-separator[data-v-446a0a1f]{margin-bottom:8px}.trp-layout-customizer-field[data-v-446a0a1f]{display:flex;flex-direction:column;gap:16px}.trp-lc-mode-toggle[data-v-446a0a1f]{display:flex;gap:8px}.trp-lc-mode-button[data-v-446a0a1f]{background:none;border:none;cursor:pointer;display:flex;gap:4px;padding:0 8px 8px}.trp-lc-mode-button.active[data-v-446a0a1f]{border-bottom:2px solid var(--trp-settings-accent-color);color:var(--trp-settings-accent-color)}.trp-lc-mode-button.active svg path[data-v-446a0a1f]{fill:var(--trp-settings-accent-color)}.trp-lc-settings-panel[data-v-446a0a1f]{display:flex;flex-direction:column;gap:16px}.trp-lc-section[data-v-446a0a1f]{display:flex;flex-direction:column;gap:24px}.trp-lc-subfield[data-v-446a0a1f] .trp-radio-group__wrapper{display:flex;flex-direction:column;gap:8px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/LayoutCustomizerField.vue"],names:[],mappings:"AA4OA,yCACI,iBACJ,CAEA,8CACI,YAAa,CACb,qBAAsB,CACtB,QACJ,CAEA,qCACI,YAAa,CACb,OACJ,CAEA,qCAKI,eAAgB,CAChB,WAAY,CAFZ,cAAe,CAHf,YAAa,CACb,OAAQ,CACR,iBAIJ,CAEA,4CAEI,wDAAyD,CADzD,sCAEJ,CAEA,qDACI,qCACJ,CAGA,wCACI,YAAa,CACb,qBAAsB,CACtB,QACJ,CAEA,iCACI,YAAa,CACb,qBAAsB,CACtB,QACJ,CAEA,4DAAoD,YAAa,CAAE,qBAAsB,CAAE,OAAU",sourcesContent:['<script setup>\r\nimport { reactive, watch, computed } from \'vue\'\r\nimport { usePreviewViewport }        from "../../composables/usePreviewViewport"\r\n\r\nimport RadioGroupField from \'./RadioGroupField.vue\'\r\n\r\nconst positionOptions = [\r\n    { value: \'bottom-right\', label: \'Bottom Right\' },\r\n    { value: \'bottom-left\',  label: \'Bottom Left\'  },\r\n    { value: \'top-right\',    label: \'Top Right\'    },\r\n    { value: \'top-left\',     label: \'Top Left\'     }\r\n]\r\n\r\nconst flagIconOptions = [\r\n    { value: \'before\', label: \'Before Language\' },\r\n    { value: \'after\',  label: \'After Language\'  },\r\n    { value: \'hide\',   label: \'Hide Icons\'      }\r\n]\r\n\r\n// For menu scope\r\nconst flagShapeOptions = [\r\n    { value: \'rect\',     label: \'Rectangle 4:3\' },\r\n    { value: \'square\',   label: \'Square 1:1\'    },\r\n    { value: \'rounded\',  label: \'Rounded\'   }\r\n]\r\n\r\nconst languageNameOptions = [\r\n    { value: \'full\',  label: \'Full Names\'  },\r\n    { value: \'short\', label: \'Short Names\' },\r\n    { value: \'none\',  label: \'No Names\'    }\r\n]\r\n\r\nconst props = defineProps({\r\n    label:      { type: String, default: \'\' },\r\n    modelValue: {\r\n        type: Object,\r\n        default: () => ({\r\n            desktop: {},\r\n            mobile : {}\r\n        })\r\n    },\r\n    scope: {\r\n        type: String,\r\n        required: true\r\n    }\r\n})\r\nconst emit = defineEmits([\'update:modelValue\', \'update:customValue\'])\r\n\r\nconst local = reactive({\r\n    desktop: { ...props.modelValue.desktop },\r\n    mobile:  { ...props.modelValue.mobile  }\r\n})\r\n\r\nwatch(\r\n    () => local,\r\n    (val) => { emit(\'update:modelValue\', { desktop: { ...val.desktop }, mobile: { ...val.mobile } }) },\r\n    { deep: true }\r\n)\r\n\r\nwatch(\r\n    () => props.modelValue,\r\n    (val) => {\r\n        if (val.desktop) Object.assign(local.desktop, val.desktop)\r\n        if (val.mobile)  Object.assign(local.mobile,  val.mobile)\r\n    }\r\n)\r\n\r\nconst { selectedViewport: currentMode, setViewport } = usePreviewViewport(props.scope)\r\n\r\nconst isShortcode = props.scope === \'shortcode\'\r\nconst isMenu      = props.scope === \'menu\'\r\nconst isFloater   = props.scope === \'floater\'\r\n\r\n/** TODO: I think we should generate the fields dynamically in case further changes will be made to this component. */\r\n<\/script>\r\n\r\n<template>\r\n    <div class="trp-layout-customizer-field trp-field trp-field--column">\r\n    <span\r\n        v-if="label"\r\n        class="trp-field__label trp-primary-text-bold"\r\n    >{{ label }}</span>\r\n\r\n        <div v-if="scope === \'menu\'" class="trp-settings-separator"></div>\r\n\r\n        \x3c!-- viewport toggle --\x3e\r\n        <div class="trp-lc-mode-toggle">\r\n            <button\r\n                :class="[\'trp-lc-mode-button\', { active: currentMode === \'desktop\' }]"\r\n                @click="setViewport(\'desktop\')"\r\n                type="button"\r\n            >\r\n                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">\r\n                    <path fill-rule="evenodd" clip-rule="evenodd"\r\n                          d="M3 2H17C17.55 2 18 2.45 18 3V13C18 13.55 17.55 14 17 14H12V16H14\r\n                   C14.55 16 15 16.45 15 17V18H5V17C5 16.45 5.45 16 6 16H8V14H3\r\n                   C2.45 14 2 13.55 2 13V3C2 2.45 2.45 2 3 2ZM16 11V4H4V11H16Z" fill="#1D2327"/>\r\n                </svg>\r\n                <span>Desktop</span>\r\n            </button>\r\n\r\n            <button\r\n                :class="[\'trp-lc-mode-button\', { active: currentMode === \'mobile\' }]"\r\n                @click="setViewport(\'mobile\')"\r\n                type="button"\r\n            >\r\n                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">\r\n                    <path fill-rule="evenodd" clip-rule="evenodd"\r\n                          d="M6 2H14C14.55 2 15 2.45 15 3V17C15 17.55 14.55 18 14 18H6\r\n                   C5.45 18 5 17.55 5 17V3C5 2.45 5.45 2 6 2ZM13 14V4H7V14H13Z" fill="#1D2327"/>\r\n                </svg>\r\n                <span>Mobile</span>\r\n            </button>\r\n        </div>\r\n\r\n        <div class="trp-lc-settings-panel">\r\n            \x3c!-- DESKTOP --\x3e\r\n            <template v-if="currentMode === \'desktop\'">\r\n                <div class="trp-lc-section">\r\n                    \x3c!-- position / width / padding only when NOT shortcode --\x3e\r\n                    <template v-if="isFloater">\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Position"\r\n                                v-model="local.desktop.position"\r\n                                :options="positionOptions"\r\n                            />\r\n                        </div>\r\n\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Width"\r\n                                v-model="local.desktop.width"\r\n                                v-model:customValue="local.desktop.customWidth"\r\n                                :options="[ { value: \'default\', label: \'Default\' } ]"\r\n                            />\r\n                        </div>\r\n\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Padding"\r\n                                v-model="local.desktop.padding"\r\n                                v-model:customValue="local.desktop.customPadding"\r\n                                :options="[ { value: \'default\', label: \'Default\' } ]"\r\n                            />\r\n                        </div>\r\n                    </template>\r\n\r\n                    <div class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Flag Icons Position"\r\n                            v-model="local.desktop.flagIconPosition"\r\n                            :options="flagIconOptions"\r\n                        />\r\n                    </div>\r\n\r\n\r\n                    <div v-if="isMenu" class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Flag icons"\r\n                            v-model="local.desktop.flagShape"\r\n                            :options="flagShapeOptions"\r\n                        />\r\n                    </div>\r\n\r\n                    <div class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Language Names"\r\n                            v-model="local.desktop.languageNames"\r\n                            :options="languageNameOptions"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </template>\r\n\r\n            \x3c!-- MOBILE --\x3e\r\n            <template v-else>\r\n                <div class="trp-lc-section">\r\n                    <template v-if="isFloater">\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Position"\r\n                                v-model="local.mobile.position"\r\n                                :options="positionOptions"\r\n                            />\r\n                        </div>\r\n\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Width"\r\n                                v-model="local.mobile.width"\r\n                                v-model:customValue="local.mobile.customWidth"\r\n                                :options="[ { value: \'default\', label: \'Default\' } ]"\r\n                            />\r\n                        </div>\r\n\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Padding"\r\n                                v-model="local.mobile.padding"\r\n                                v-model:customValue="local.mobile.customPadding"\r\n                                :options="[ { value: \'default\', label: \'Default\' } ]"\r\n                            />\r\n                        </div>\r\n                    </template>\r\n\r\n                    <div class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Flag Icons Position"\r\n                            v-model="local.mobile.flagIconPosition"\r\n                            :options="flagIconOptions"\r\n                        />\r\n                    </div>\r\n\r\n                    <div v-if="isMenu" class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Flag icons"\r\n                            v-model="local.desktop.flagShape"\r\n                            :options="flagShapeOptions"\r\n                        />\r\n                    </div>\r\n\r\n                    <div class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Language Names"\r\n                            v-model="local.mobile.languageNames"\r\n                            :options="languageNameOptions"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </template>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-settings-separator {\r\n    margin-bottom: 8px;\r\n}\r\n\r\n.trp-layout-customizer-field {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 16px;\r\n}\r\n\r\n.trp-lc-mode-toggle {\r\n    display: flex;\r\n    gap: 8px;\r\n}\r\n\r\n.trp-lc-mode-button {\r\n    display: flex;\r\n    gap: 4px;\r\n    padding: 0 8px 8px 8px;\r\n    cursor: pointer;\r\n    background: none;\r\n    border: none;\r\n}\r\n\r\n.trp-lc-mode-button.active {\r\n    color: var(--trp-settings-accent-color);\r\n    border-bottom: 2px solid var(--trp-settings-accent-color);\r\n}\r\n\r\n.trp-lc-mode-button.active svg path {\r\n    fill: var(--trp-settings-accent-color);\r\n}\r\n\r\n/* panel & sections */\r\n.trp-lc-settings-panel {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 16px;\r\n}\r\n\r\n.trp-lc-section   {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 24px;\r\n}\r\n\r\n.trp-lc-subfield :deep(.trp-radio-group__wrapper) { display: flex; flex-direction: column; gap: 8px; }\r\n\r\n</style>\r\n'],sourceRoot:""}]);const a=s},130(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-menu-settings__wrapper[data-v-2d8b1892]{display:flex;flex-direction:column;gap:16px;max-width:640px;width:100%}","",{version:3,sources:["webpack://./assets/src/language-switcher/views/MenuConfig.vue"],names:[],mappings:"AA4DA,6CAGI,YAAa,CACb,qBAAsB,CACtB,QAAS,CAJT,eAAgB,CAChB,UAIJ",sourcesContent:["<script setup>\r\nimport { provide } from 'vue'\r\nimport { onBeforeRouteLeave } from 'vue-router'\r\n\r\nimport SettingsBox from '../components/SettingsBox.vue'\r\nimport SettingsActions from '../components/SettingsActions.vue'\r\n\r\nimport { useSwitcherConfig } from '../composables/useSwitcherConfig'\r\nimport { useSwitcherPersistence } from '../composables/useSwitcherPersistance'\r\n\r\nimport { __ } from '@wordpress/i18n'\nimport { sanitizeHtml }  from \"../composables/utils/sanitizeHtml\"\r\n\r\nconst scope = 'menu'\r\nconst cfg = useSwitcherConfig(scope)\r\n\r\nconst persistence = useSwitcherPersistence(scope)\r\nprovide('switcherPersistence', persistence)\r\n\r\nconst { isDirty, revert } = persistence\r\n\r\nconst T = {\r\n    menuSwitcherLayout: __('Menu Switcher Layout', 'translatepress-multilingual'),\n    unsavedChangesAlert: __('You have unsaved changes. Leave anyway?', 'translatepress-multilingual'),\n    //[utm4]\r\n    descriptionText: sanitizeHtml( __('Go to <a href=\"/wp-admin/nav-menus.php\">Appearance → Menus</a> to add languages to the Language Switcher in any menu.<br> <a href=\"https://translatepress.com/docs/settings/language-switcher/?utm_source=tp-language-switcher&utm_medium=client-site&utm_campaign=ls-menu-item#menu-switcher\" target=\"_blank\">Learn more in our documentation.</a>', 'translatepress-multilingual') )\n}\r\n\r\nonBeforeRouteLeave((_to, _from, next) => {\r\n    if (!isDirty.value) return next()\r\n    const ok = window.confirm(T.unsavedChangesAlert)\r\n    ok ? (revert(), next()) : next(false)\r\n})\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-menu-settings__wrapper\">\r\n        <SettingsBox\r\n            :title=\"T.menuSwitcherLayout\"\r\n            :scope=\"scope\"\r\n            :collapsible=\"false\"\r\n            :fields=\"[\r\n        {\r\n          key: 'layoutCustomizer',\r\n          type: 'lCustomizer',\r\n          label: ''\r\n        }\r\n      ]\"\r\n        >\r\n            <template #end>\r\n                <span class=\"trp-description-text\" v-html=\"T.descriptionText\" />\r\n            </template>\r\n        </SettingsBox>\r\n\r\n        <SettingsActions :scope=\"scope\" />\r\n    </div>\r\n</template>\r\n\r\n\r\n<style scoped>\r\n.trp-menu-settings__wrapper {\r\n    max-width: 640px;\r\n    width: 100%;\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 16px;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},139(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-radio-group[data-v-e2617dbe]{display:flex;gap:16px}.trp-radio-label[data-v-e2617dbe]{cursor:pointer}.trp-lc-custom-number[data-v-e2617dbe]{margin-left:8px}.trp-radio-option[data-v-e2617dbe]{align-items:center;cursor:pointer;display:flex;line-height:20px;min-width:140px}.trp-radio-option.is-disabled[data-v-e2617dbe]{opacity:.5}.trp-radio-option.is-disabled input[data-v-e2617dbe]{background:var(--trp-settings-disabled-color);pointer-events:none}.trp-radio-option input[data-v-e2617dbe]{border:1px solid var(--trp-settings-medium-gray-border-color);height:20px;position:relative;width:20px}.trp-radio-option input[data-v-e2617dbe]:checked:before{background-color:var(--trp-settings-accent-color);height:10px;left:50%;margin:0;position:absolute;top:50%;transform:translate(-50%,-50%);width:10px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/RadioGroupField.vue"],names:[],mappings:"AAmGA,kCACI,YAAY,CACZ,QACJ,CAEA,kCACI,cACJ,CAEA,uCACI,eACJ,CAEA,mCAKI,kBAAmB,CAJnB,cAAe,CAGf,YAAa,CAFb,gBAAiB,CACjB,eAGJ,CAEA,+CACI,UACJ,CAEA,qDAEI,6CAA8C,CAD9C,mBAEJ,CAEA,yCACI,6DAA8D,CAE9D,WAAY,CACZ,iBAAkB,CAFlB,UAGJ,CAEA,wDAQI,iDAAkD,CALlD,WAAY,CAEZ,QAAS,CAET,QAAS,CANT,iBAAkB,CAGlB,OAAQ,CAER,8BAAgC,CAJhC,UAOJ",sourcesContent:["<script setup>\r\nimport { computed, ref, watch } from 'vue'\r\n\r\nimport NumberField from './NumberField.vue'\r\n\r\nconst props = defineProps({\r\n    label:       { type: String, required: false, default: '' },\r\n    modelValue:  { type: String, required: true },\r\n    options:     {\r\n        type: Array,\r\n        required: true,\r\n        validator: arr => arr.every(o =>\r\n            'value' in o && 'label' in o &&\r\n            (o.disabled === undefined || typeof o.disabled === 'boolean') &&\r\n            (o.title    === undefined || typeof o.title    === 'string')\r\n        )\r\n    },\r\n    customValue: { type: [Number, String] }, // (optional) a number v-model. If parent binds this prop, then “Custom” is automatically injected as an extra option.\r\n})\r\n\r\nconst emit = defineEmits(['update:modelValue', 'update:customValue'])\r\n\r\nconst localCustom = ref(props.customValue)\r\n\r\n// Sync parent -> localCustom whenever customValue prop changes\r\nwatch(\r\n    () => props.customValue,\r\n    (newVal) => {\r\n        if (newVal !== localCustom.value) {\r\n            localCustom.value = newVal\r\n        }\r\n    }\r\n)\r\n\r\n// Sync localCustom -> parent via update:customValue\r\nwatch(localCustom, (newVal) => {\r\n    emit('update:customValue', newVal)\r\n})\r\n\r\nconst shouldShowCustom = computed(() => props.customValue !== undefined)\r\n\r\n/** Build the array of options we actually render.\r\n *  If shouldShowCustom is true, append { value: 'custom', label: 'Custom' }\r\n *  unless the user already provided an option whose value is \"custom\".\r\n */\r\nconst displayedOptions = computed(() => {\r\n    if (!shouldShowCustom.value)\r\n        return props.options\r\n\r\n    // If parent’s options already include value = 'custom', don’t duplicate\r\n    const hasCustomAlready = props.options.some(o => o.value === 'custom')\r\n\r\n    if (hasCustomAlready)\r\n        return props.options\r\n\r\n    return [\r\n        ...props.options,\r\n        { value: 'custom', label: 'Custom' }\r\n    ]\r\n})\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-radio-group__wrapper\">\r\n        <span v-if=\"label\" class=\"trp-field__label trp-primary-text-bold\">{{ label }}</span>\r\n\r\n        <div class=\"trp-radio-group\">\r\n            <div\r\n                v-for=\"opt in displayedOptions\"\r\n                :key=\"opt.value\"\r\n                :class=\"['trp-radio-option', { 'is-disabled': opt.disabled }]\"\r\n                :title=\"opt.title\"\r\n            >\r\n                <label class=\"trp-radio-label\">\r\n                    <input\r\n                        type=\"radio\"\r\n                        :name=\"label || 'radio-group'\"\r\n                        :value=\"opt.value\"\r\n                        :checked=\"modelValue === opt.value\"\r\n                        :disabled=\"opt.disabled\"\r\n                        @change=\"() => emit('update:modelValue', opt.value)\"\r\n                    />\r\n                    <span>{{ opt.label }}</span>\r\n                </label>\r\n\r\n                <NumberField\r\n                    v-if=\"shouldShowCustom && opt.value === 'custom' && modelValue === 'custom'\"\r\n                    class=\"trp-lc-custom-number\"\r\n                    v-model=\"localCustom\"\r\n                    :label=\"''\"\r\n                    :min=\"0\"\r\n                />\r\n            </div>\r\n\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-radio-group {\r\n    display:flex;\r\n    gap:16px;\r\n}\r\n\r\n.trp-radio-label {\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-lc-custom-number {\r\n    margin-left: 8px;\r\n}\r\n\r\n.trp-radio-option {\r\n    cursor: pointer;\r\n    line-height: 20px;\r\n    min-width: 140px;\r\n    display: flex;\r\n    align-items: center;\r\n}\r\n\r\n.trp-radio-option.is-disabled {\r\n    opacity: 0.5;\r\n}\r\n\r\n.trp-radio-option.is-disabled input {\r\n    pointer-events: none;\r\n    background: var(--trp-settings-disabled-color);\r\n}\r\n\r\n.trp-radio-option input {\r\n    border: 1px solid var(--trp-settings-medium-gray-border-color);\r\n    width: 20px;\r\n    height: 20px;\r\n    position: relative;\r\n}\r\n\r\n.trp-radio-option input:checked:before {\r\n    position: absolute;\r\n    width: 10px;\r\n    height: 10px;\r\n    top: 50%;\r\n    left: 50%;\r\n    transform: translate(-50%, -50%);\r\n    margin: 0;\r\n    background-color: var(--trp-settings-accent-color);\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},262(e,t){"use strict";t.A=(e,t)=>{const n=e.__vccOpts||e;for(const[e,r]of t)n[e]=r;return n}},268(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-toggle-status-field[data-v-63ef0d74]{align-items:center;display:flex;gap:10px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/ToggleStatusField.vue"],names:[],mappings:"AA8BA,0CAAyC,kBAAkB,CAAhC,YAAY,CAAsB,QAAU",sourcesContent:["<template>\r\n    <div class=\"trp-toggle-status-field\">\r\n        <ToggleField\r\n            v-model=\"inputValue\"\r\n            :label=\"''\"\r\n        />\r\n        <span class=\"trp-primary-text\">\r\n        {{ modelValue ? onText : offText }}\r\n        </span>\r\n    </div>\r\n</template>\r\n\r\n<script setup>\r\nimport ToggleField from './ToggleField.vue'\r\nimport { computed }  from \"vue\"\r\n\r\nconst props = defineProps({\r\n    modelValue: Boolean,\r\n    onText:  { type: String, default: 'Enabled' },\r\n    offText: { type: String, default: 'Disabled' }\r\n})\r\nconst emit = defineEmits(['update:modelValue'])\r\n\r\nconst inputValue = computed({\r\n    get: ()  => props.modelValue,\r\n    set: val => emit('update:modelValue', val)\r\n});\r\n<\/script>\r\n\r\n<style scoped>\r\n.trp-toggle-status-field { display:flex; align-items:center; gap:10px; }\r\n</style>\r\n"],sourceRoot:""}]);const a=s},392(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-floater-settings__wrapper[data-v-db97e920]{display:flex;flex-direction:row;gap:16px;max-width:1200px;width:100%}.trp-floater-settings__right[data-v-db97e920]{display:flex;flex-direction:column;gap:16px;max-width:641px;width:60%}.trp-floater-settings__left[data-v-db97e920]{width:40%}.trp-sticky-box[data-v-db97e920]{position:sticky;top:50px}","",{version:3,sources:["webpack://./assets/src/language-switcher/views/FloaterConfig.vue"],names:[],mappings:"AA2QA,gDACI,YAAa,CACb,kBAAmB,CACnB,QAAS,CACT,gBAAiB,CACjB,UACJ,CAEA,8CACI,YAAa,CACb,qBAAsB,CACtB,QAAS,CAET,eAAgB,CADhB,SAEJ,CAEA,6CACI,SACJ,CAEA,iCACI,eAAgB,CAChB,QACJ",sourcesContent:["<script setup>\r\nimport SettingsBox                         from '../components/SettingsBox.vue'\r\nimport PresetApplier                       from \"../components/PresetApplier.vue\"\r\nimport LanguageSwitcherPreview             from \"../components/LanguageSwitcherPreview.vue\"\r\nimport SettingsActions                     from \"../components/SettingsActions.vue\"\r\n\r\nimport { useLanguages, useSwitcherConfig } from \"../composables/useSwitcherConfig\"\r\nimport { useLayoutCustomizer }             from \"../composables/layoutCustomizer/useLayoutCustomizer\"\r\nimport { useSwitcherPersistence }          from '../composables/useSwitcherPersistance'\r\n\r\nimport { computed, provide, watch } from \"vue\"\r\nimport { onBeforeRouteLeave }       from 'vue-router'\r\n\r\nimport { __ } from \"@wordpress/i18n\"\n\r\nconst scope = \"floater\"\r\n\r\nconst cfg = useSwitcherConfig( scope )\r\n\r\nconst persistence = useSwitcherPersistence( scope )\r\n\r\nprovide( 'switcherPersistence', persistence )\r\n\r\nconst { isDirty, revert } = persistence\r\n\r\nconst { positioning, switcherPosition } = useLayoutCustomizer( scope )\r\n\r\nconst flagRatio = computed( () => cfg.flagShape )\r\n\r\nconst languageItemSettings = computed(() => ({\r\n    flagPos: positioning.value.flagPos,\r\n    nameMode: positioning.value.languageNames,\r\n    flagRatio: flagRatio\r\n}))\r\n\r\nconst invertRadius = ( r ) => {\r\n    if ( !Array.isArray( r ) || r.length !== 4 )\r\n        return r\r\n\r\n    const [tl, tr, br, bl] = r\r\n\r\n    return [bl, br, tr, tl]\r\n}\r\n\r\nconst getVertical = ( pos ) => {\r\n    if ( typeof pos !== 'string' )\r\n        return null\r\n\r\n    return pos.startsWith( 'top' ) ? 'top' : 'bottom'\r\n}\r\n\r\nwatch(\r\n    () => switcherPosition.value,\r\n    ( newPos, oldPos ) => {\r\n        const newVertical = getVertical( newPos )\r\n        const oldVertical = getVertical( oldPos )\r\n\r\n        if ( !newVertical || !oldVertical )\r\n            return\r\n\r\n        if ( newVertical === oldVertical )\r\n            return\r\n\r\n        cfg.borderRadius = invertRadius( cfg.borderRadius )\r\n    }\r\n)\r\nconst T = {\r\n    switcherPreview: __('Switcher Preview', 'translatepress-multilingual'),\n    enableFloating: __('Enable Floating Switcher', 'translatepress-multilingual'),\n    switcherEnabled: __('Switcher is enabled', 'translatepress-multilingual'),\n    switcherDisabled: __('Switcher is disabled', 'translatepress-multilingual'),\n    switcherType: __('Switcher Type', 'translatepress-multilingual'),\n    showAsDropdown: __('Show languages as dropdown', 'translatepress-multilingual'),\n    showSideBySide: __('Show languages side by side', 'translatepress-multilingual'),\n    applyPreset: __('Apply a preset', 'translatepress-multilingual'),\n    customizeDesign: __('Customize Design', 'translatepress-multilingual'),\n    backgroundColor: __('Background color', 'translatepress-multilingual'),\n    backgroundHoverColor: __('Background hover color', 'translatepress-multilingual'),\n    textColor: __('Text color', 'translatepress-multilingual'),\n    textHoverColor: __('Text hover color', 'translatepress-multilingual'),\n    borderColor: __('Switcher border color', 'translatepress-multilingual'),\n    borderWidth: __('Switcher border width', 'translatepress-multilingual'),\n    borderRadius: __('Switcher border radius', 'translatepress-multilingual'),\n    flagTextSize: __('Flag and text size', 'translatepress-multilingual'),\n    normal: __('Normal', 'translatepress-multilingual'),\n    large: __('Large', 'translatepress-multilingual'),\n    flagIconsShape: __('Flag icons shape', 'translatepress-multilingual'),\n    rectangle: __('Rectangle (4:3)', 'translatepress-multilingual'),\n    square: __('Square (1:1)', 'translatepress-multilingual'),\n    flagRadius: __('Flag icons border radius', 'translatepress-multilingual'),\n    enableCustomCss: __('Enable custom CSS', 'translatepress-multilingual'),\n    customizeLayout: __('Customize Layout', 'translatepress-multilingual'),\n    showOppositeLanguage: __('Show opposite language', 'translatepress-multilingual'),\n    showPoweredBy: __('Show \"Powered by TranslatePress\"', 'translatepress-multilingual'),\n    poweredByDesc: __('Show the small Powered by TranslatePress label in the language switcher.', 'translatepress-multilingual'),\n    leaveConfirm: __('You have unsaved changes. Leave anyway?', 'translatepress-multilingual'),\n    enableTransitions: __( 'Switcher animations', 'translatepress-multilingual' )\n}\n\r\nconst oppositeLanguageFieldDescription = __(\n    'Transforms the language switcher into a button showing the other available language, not the current one. <br> Only works when there are exactly two languages, the default one and a translation one.',\n    'translatepress-multilingual'\n)\n\r\nconst { published } = useLanguages()\r\n\r\nconst publishedLangCount = Object.keys(published).length\r\n\r\nconst aboveTwoLanguages = publishedLangCount > 2\r\n\r\nconst aboveTwoLanguagesTitle = aboveTwoLanguages\n    ? __('This option only works when exactly two languages are published.', 'translatepress-multilingual')\n    : ''\n\r\nonBeforeRouteLeave((to, from, next) => {\r\n    if (!isDirty.value) return next()\r\n\r\n    const ok = window.confirm(__('You have unsaved changes. Leave anyway?', 'translatepress-multilingual'))\n\r\n    if (ok) {\r\n        revert()\r\n        next()\r\n    }\r\n\r\n    else\r\n        next(false)\r\n})\r\n\r\nprovide('languageItemSettings', languageItemSettings)\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-floater-settings__wrapper\">\r\n        <div class=\"trp-floater-settings__left\">\r\n            <div class=\"trp-sticky-box\">\r\n                <SettingsBox\r\n                    :title=\"T.switcherPreview\"\r\n                    :scope=scope\r\n                >\r\n                    <LanguageSwitcherPreview :scope=\"scope\"/>\r\n                </SettingsBox>\r\n\r\n                <SettingsActions :scope=\"scope\" />\r\n            </div>\r\n        </div>\r\n        <div class=\"trp-floater-settings__right\">\r\n            <SettingsBox\r\n                :title=\"T.enableFloating\"\r\n                :scope=\"scope\"\r\n                :style=\"{ flexDirection: 'row', gap: '75px' }\"\r\n                :fields=\"[{\r\n                    key: 'enabled',\r\n                    type: 'toggleStatus',\r\n                    onText: T.switcherEnabled,\r\n                    offText: T.switcherDisabled\r\n                }]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                :title=\"T.switcherType\"\r\n                :scope=\"scope\"\r\n                :fields=\"[{\r\n                    key: 'type',\r\n                    type: 'radio',\r\n                    default: 'dropdown',\r\n                    options: [\r\n                        { value: 'dropdown', label: T.showAsDropdown },\r\n                        { value: 'side-by-side', label: T.showSideBySide, disabled: aboveTwoLanguages, title: aboveTwoLanguagesTitle },\r\n                    ]\r\n                }]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                :title=\"T.applyPreset\"\r\n                :scope=\"scope\"\r\n            >\r\n                <PresetApplier :scope=\"scope\" />\r\n            </SettingsBox>\r\n\r\n            <SettingsBox\r\n                :title=\"T.customizeDesign\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :style=\"{ '--trp-field-label-width': '190px' }\"\r\n                :fields=\"[\r\n                    { key:  'bgColor',        type: 'color',      label: T.backgroundColor,        default: '#ffffff' },\r\n                    { key:  'bgHoverColor',   type: 'color',      label: T.backgroundHoverColor,   default: '#f5f5f5' },\r\n                    { key:  'textColor',      type: 'color',      label: T.textColor,              default: '#000000' },\r\n                    { key:  'textHoverColor', type: 'color',      label: T.textHoverColor,         default: '#000000' },\r\n                    { key:  'borderColor',    type: 'color',      label: T.borderColor,            default: '#e2e2e4' },\r\n                    { key:  'borderWidth',    type: 'number',     label: T.borderWidth,            default: 1 },\r\n                    { key:  'borderRadius',   type: 'quadNumber', label: T.borderRadius,           default: [8, 8, 0 ,0], layout: 'column' },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'enableTransitions',\r\n                        type: 'toggle',\r\n                        label: T.enableTransitions,\r\n                        default: true\r\n                    },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'size',\r\n                        type: 'radio',\r\n                        label: T.flagTextSize,\r\n                        default: 'normal',\r\n                        options: [\r\n                            { value: 'normal', label: T.normal },\r\n                            { value: 'large',  label: T.large  }\r\n                        ],\r\n                        layout: 'column'\r\n                    },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'flagShape',\r\n                        type: 'radio',\r\n                        label: T.flagIconsShape,\r\n                        default: 'rect',\r\n                        options: [\r\n                            { value: 'rect',   label: T.rectangle },\r\n                            { value: 'square', label: T.square    }\r\n                        ],\r\n                        layout: 'column'\r\n                    },\r\n                    { key: 'flagRadius',      type: 'number', label: T.flagRadius, default: 2 },\r\n                    { type: 'separator' },\r\n                    { key: 'enableCustomCss', type: 'toggle', label: T.enableCustomCss, default: false },\r\n                    { key: 'customCss',       type: 'customCss', label: '', visible: cfg => cfg?.enableCustomCss === true }\r\n                ]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                :title=\"T.customizeLayout\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :fields=\"[{\r\n                    key: 'layoutCustomizer',\r\n                    type: 'lCustomizer',\r\n                    label: ''\r\n                }]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                title=\"Additional Settings\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :fields=\"[{\r\n                    key: 'oppositeLanguage',\r\n                    type: 'checkbox',\r\n                    default: false,\r\n                    label: T.showOppositeLanguage,\r\n                    description: oppositeLanguageFieldDescription,\r\n                    disabled: aboveTwoLanguages,\r\n                    title: aboveTwoLanguagesTitle\r\n                },\r\n                {\r\n                    key: 'showPoweredBy',\r\n                    type: 'checkbox',\r\n                    default: false,\r\n                    label: T.showPoweredBy,\r\n                    description: T.poweredByDesc\r\n                }]\"\r\n            />\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-floater-settings__wrapper {\r\n    display: flex;\r\n    flex-direction: row;\r\n    gap: 16px;\r\n    max-width: 1200px;\r\n    width: 100%;\r\n}\r\n\r\n.trp-floater-settings__right {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 16px;\r\n    width: 60%;\r\n    max-width: 641px;\r\n}\r\n\r\n.trp-floater-settings__left {\r\n    width: 40%;\r\n}\r\n\r\n.trp-sticky-box {\r\n    position: sticky;\r\n    top: 50px\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},419(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-quad-grid[data-v-44785c6b]{display:grid;gap:12px 24px;grid-template-columns:repeat(2,max-content)}.trp-quad-radius-corner[data-v-44785c6b]{align-items:center;display:flex;flex-direction:row;gap:8px}.trp-corner-label[data-v-44785c6b]{min-width:90px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/QuadRadiusField.vue"],names:[],mappings:"AAmDA,gCACI,YAAa,CAEb,aAAc,CADd,2CAEJ,CAEA,yCAGI,kBAAmB,CAFnB,YAAa,CACb,kBAAmB,CAEnB,OACJ,CAEA,mCACI,cACJ",sourcesContent:["<script setup>\r\nimport { computed }  from 'vue'\r\nimport NumberField from './NumberField.vue'\r\n\r\n/*\r\n  v-model expects an array: [ topLeft, topRight, bottomLeft, bottomRight ]\r\n*/\r\nconst props = defineProps( {\r\n    label      : { type : String, default : '' },\r\n    modelValue : { type : Array, required : true }\r\n})\r\nconst emit  = defineEmits( [ 'update:modelValue' ] )\r\n\r\n/* build four computed bindings that proxy into the array */\r\n// each binding is a ComputedRef<number>\r\nconst bindings = Array.from( { length : 4 }, ( _, i ) =>\r\n    computed( {\r\n        get : () => props.modelValue[ i ] ?? 0,\r\n        set : val => {\r\n            const next = [ ...props.modelValue ]\r\n\r\n            next[ i ]  = val\r\n            emit( 'update:modelValue', next )\r\n        }\r\n    })\r\n)\r\n\r\nconst cornerLabels = [ 'Top Left', 'Top Right', 'Bottom Left', 'Bottom Right' ]\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-field trp-field--column\">\r\n        <span class=\"trp-field__label trp-primary-text-bold\">{{ label }}</span>\r\n        <div class=\"trp-quad-grid\">\r\n            <div\r\n                v-for=\"(cornerLabel, idx) in cornerLabels\"\r\n                :key=\"idx\"\r\n                class=\"trp-quad-radius-corner\"\r\n            >\r\n                <span class=\"trp-primary-text trp-corner-label\">{{ cornerLabel }}</span>\r\n                <NumberField\r\n                    :modelValue=\"bindings[idx].value\"\r\n                    @update:modelValue=\"val => bindings[idx].value = val\"\r\n                    :label=\"''\"\r\n                />\r\n            </div>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-quad-grid {\r\n    display: grid;\r\n    grid-template-columns: repeat(2, max-content);\r\n    gap: 12px 24px;\r\n}\r\n\r\n.trp-quad-radius-corner {\r\n    display: flex;\r\n    flex-direction: row;\r\n    align-items: center;\r\n    gap: 8px;\r\n}\r\n\r\n.trp-corner-label{\r\n    min-width: 90px;\r\n}\r\n\r\n</style>\r\n"],sourceRoot:""}]);const a=s},427(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-shortcode-display[data-v-4d14b53c]{align-items:center;display:flex;gap:12px}.trp-shortcode-input[data-v-4d14b53c]{background:#fff;border:1px solid #c3c4c7;border-radius:5px;flex:1;font-family:monospace;height:40px;padding:12px}.trp-description-text[data-v-4d14b53c]{margin:0}.trp-copy-btn[data-v-4d14b53c]:focus-visible,.trp-shortcode-input[data-v-4d14b53c]:focus-visible{outline-color:var(--trp-settings-accent-color)}.trp-copy-btn[data-v-4d14b53c]{align-content:center;display:flex;gap:8px;justify-content:center}.trp-copy-btn:hover svg path[data-v-4d14b53c]{stroke:#fff}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/ShortcodeCopy.vue"],names:[],mappings:"AA+EA,wCAGI,kBAAkB,CAFlB,YAAY,CACZ,QAEJ,CAEA,sCAMI,eAAmB,CAFnB,wBAAyB,CACzB,iBAAkB,CAJlB,MAAO,CAMP,qBAAsB,CAJtB,WAAY,CADZ,YAMJ,CAEA,uCACI,QACJ,CAEA,iGACI,8CACJ,CAEA,+BAGI,oBAAqB,CAFrB,YAAa,CAGb,OAAQ,CAFR,sBAGJ,CAEA,8CACI,WACJ",sourcesContent:['<script setup>\r\nimport { ref, computed } from \'vue\'\r\nimport { __ }            from \'@wordpress/i18n\'\n\r\nconst SHORTCODE = \'[language-switcher]\'\r\nconst copiedFeedback = ref(false)\r\n\r\nconst copyButtonLabel = computed(() =>\r\n    copiedFeedback.value\n        ? __(\'Copied!\', \'translatepress-multilingual\')\n        : __(\'Copy\', \'translatepress-multilingual\')\n)\r\n\r\nfunction copyToClipboard() {\r\n    navigator.clipboard?.writeText(SHORTCODE)\r\n             .then(() => {\r\n                 copiedFeedback.value = true\r\n                 setTimeout(() => copiedFeedback.value = false, 2000)\r\n             })\r\n             .catch(() => {\r\n                 // Fallback for very old browsers\r\n                 const textarea = document.createElement(\'textarea\')\r\n                 textarea.value = SHORTCODE\r\n                 textarea.style.position = \'fixed\'\r\n                 textarea.style.opacity = \'0\'\r\n\r\n                 document.body.appendChild(textarea)\r\n                 textarea.select()\r\n\r\n                 try {\r\n                     document.execCommand(\'copy\')\r\n                 } finally {\r\n                     document.body.removeChild(textarea)\r\n                     copiedFeedback.value = true\r\n                     setTimeout(() => copiedFeedback.value = false, 2000)\r\n                 }\r\n             })\r\n}\r\n\r\nconst shortcodeDescription = __(\'Use shortcode on any page or widget. You can also add the Language Switcher Block in the WP Gutenberg Editor.\', \'translatepress-multilingual\')\n<\/script>\r\n\r\n<template>\r\n    <div class="trp-shortcode-display">\r\n        <input\r\n            class="trp-shortcode-input trp-primary-text"\r\n            :value="SHORTCODE"\r\n            readonly\r\n        />\r\n        <button\r\n            class="trp-copy-btn trp-button-secondary"\r\n            type="button"\r\n            @click="copyToClipboard"\r\n        >\r\n            <svg\r\n                width="22"\r\n                height="22"\r\n                viewBox="0 0 22 22"\r\n                fill="none"\r\n                xmlns="http://www.w3.org/2000/svg"\r\n            >\r\n                <path\r\n                    d="M14.666 7.33317V5.49984C14.666 5.01361 14.4729 4.54729 14.129 4.20347C13.7852 3.85966 13.3189 3.6665 12.8327 3.6665H5.49935C5.01312 3.6665 4.5468 3.85966 4.20299 4.20347C3.85917 4.54729 3.66602 5.01361 3.66602 5.49984V12.8332C3.66602 13.3194 3.85917 13.7857 4.20299 14.1295C4.5468 14.4733 5.01312 14.6665 5.49935 14.6665H7.33268M7.33268 9.1665C7.33268 8.68027 7.52584 8.21396 7.86965 7.87014C8.21347 7.52633 8.67979 7.33317 9.16602 7.33317H16.4993C16.9856 7.33317 17.4519 7.52633 17.7957 7.87014C18.1395 8.21396 18.3327 8.68027 18.3327 9.1665V16.4998C18.3327 16.9861 18.1395 17.4524 17.7957 17.7962C17.4519 18.14 16.9856 18.3332 16.4993 18.3332H9.16602C8.67979 18.3332 8.21347 18.14 7.86965 17.7962C7.52584 17.4524 7.33268 16.9861 7.33268 16.4998V9.1665Z"\r\n                    stroke="#2271B1"\r\n                    stroke-width="1.5"\r\n                    stroke-linecap="round"\r\n                    stroke-linejoin="round"\r\n                />\r\n            </svg>\r\n            {{ copyButtonLabel }}\r\n        </button>\r\n    </div>\r\n\r\n    <p class="trp-description-text">\r\n        {{ shortcodeDescription }}\r\n    </p>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-shortcode-display{\r\n    display:flex;\r\n    gap:12px;\r\n    align-items:center;\r\n}\r\n\r\n.trp-shortcode-input{\r\n    flex: 1;\r\n    padding: 12px;\r\n    height: 40px;\r\n    border: 1px solid #C3C4C7;\r\n    border-radius: 5px;\r\n    background: #ffffff;\r\n    font-family: monospace;\r\n}\r\n\r\n.trp-description-text {\r\n    margin: 0;\r\n}\r\n\r\n.trp-shortcode-input:focus-visible, .trp-copy-btn:focus-visible {\r\n    outline-color: var(--trp-settings-accent-color);\r\n}\r\n\r\n.trp-copy-btn  {\r\n    display: flex;\r\n    justify-content: center;\r\n    align-content: center;\r\n    gap: 8px;\r\n}\r\n\r\n.trp-copy-btn:hover svg path {\r\n    stroke: #ffffff;\r\n}\r\n\r\n</style>\r\n'],sourceRoot:""}]);const a=s},451(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-floater-settings__wrapper[data-v-ab1eeb76]{display:flex;flex-direction:row;gap:16px;max-width:1200px;width:100%}.trp-floater-settings__right[data-v-ab1eeb76]{display:flex;flex-direction:column;gap:16px;max-width:641px;width:60%}.trp-floater-settings__left[data-v-ab1eeb76]{width:40%}.trp-sticky-box[data-v-ab1eeb76]{position:sticky;top:50px}","",{version:3,sources:["webpack://./assets/src/language-switcher/views/ShortcodeConfig.vue"],names:[],mappings:"AA4LA,gDACI,YAAY,CACZ,kBAAkB,CAClB,QAAQ,CACR,gBAAgB,CAChB,UACJ,CAEA,8CACI,YAAY,CACZ,qBAAqB,CACrB,QAAQ,CAER,eAAe,CADf,SAEJ,CAEA,6CACI,SACJ,CAEA,iCACI,eAAe,CAAE,QACrB",sourcesContent:["<script setup>\r\nimport { computed, provide } from 'vue'\r\nimport { onBeforeRouteLeave } from 'vue-router'\r\n\r\nimport SettingsBox from '../components/SettingsBox.vue'\r\nimport SettingsActions from '../components/SettingsActions.vue'\r\nimport LanguageSwitcherPreview from '../components/LanguageSwitcherPreview.vue'\r\nimport ShortcodeCopy from '../components/ShortcodeCopy.vue'\r\n\r\nimport { useLanguages, useSwitcherConfig } from '../composables/useSwitcherConfig'\r\nimport { useSwitcherPersistence }          from '../composables/useSwitcherPersistance'\r\n\r\nimport { useLayoutCustomizer } from \"../composables/layoutCustomizer/useLayoutCustomizer\"\r\nimport { __ }                  from '@wordpress/i18n'\n\r\nconst scope = 'shortcode'\r\nconst cfg = useSwitcherConfig(scope)\r\nconst persistence = useSwitcherPersistence(scope)\r\nprovide('switcherPersistence', persistence)\r\n\r\nconst { isDirty, revert } = persistence\r\nconst { positioning } = useLayoutCustomizer(scope)\r\n\r\nconst flagRatio = computed(() => cfg.flagShape)\r\n\r\nconst languageItemSettings = computed(() => ({\r\n    flagPos: positioning.value.flagPos,\r\n    nameMode: positioning.value.languageNames,\r\n    flagRatio: flagRatio\r\n}))\r\nprovide('languageItemSettings', languageItemSettings)\r\n\r\nconst oppositeLanguageFieldDescription = __(\n    'Transforms the language switcher into a button showing the other available language, not the current one. <br> Only works when there are exactly two languages, the default one and a translation one.',\n    'translatepress-multilingual'\n)\n\r\nconst { published } = useLanguages()\r\n\r\nconst publishedLangCount = Object.keys(published).length\r\n\r\nconst aboveTwoLanguages = publishedLangCount > 2\r\n\r\nconst aboveTwoLanguagesTitle = aboveTwoLanguages\n    ? __('This option only works when exactly two languages are published.', 'translatepress-multilingual')\n    : ''\n\r\nconst T = {\r\n    confirmLeave: __('You have unsaved changes. Leave anyway?', 'translatepress-multilingual'),\n    switcherPreview: __('Switcher Preview', 'translatepress-multilingual'),\n    shortcode: __('Shortcode', 'translatepress-multilingual'),\n    customizeDesign: __('Customize Design', 'translatepress-multilingual'),\n    backgroundColor: __('Background color', 'translatepress-multilingual'),\n    backgroundHoverColor: __('Background hover color', 'translatepress-multilingual'),\n    textColor: __('Text color', 'translatepress-multilingual'),\n    textHoverColor: __('Text hover color', 'translatepress-multilingual'),\n    switcherBorderColor: __('Switcher border color', 'translatepress-multilingual'),\n    switcherBorderWidth: __('Switcher border width', 'translatepress-multilingual'),\n    switcherBorderRadius: __('Switcher border radius', 'translatepress-multilingual'),\n    flagTextSize: __('Flag and text size', 'translatepress-multilingual'),\n    normal: __('Normal', 'translatepress-multilingual'),\n    large: __('Large', 'translatepress-multilingual'),\n    flagIconsShape: __('Flag icons shape', 'translatepress-multilingual'),\n    rectangle: __('Rectangle (4:3)', 'translatepress-multilingual'),\n    square: __('Square (1:1)', 'translatepress-multilingual'),\n    flagRadius: __('Flag icons border radius', 'translatepress-multilingual'),\n    enableCustomCss: __('Enable custom CSS', 'translatepress-multilingual'),\n    customizeLayout: __('Customize Layout', 'translatepress-multilingual'),\n    additionalSettings: __('Additional Settings', 'translatepress-multilingual'),\n    openOnClick: __('Open language switcher only on click', 'translatepress-multilingual'),\n    clickLangDesc: __('Open the language switcher shortcode by clicking on it instead of hovering. <br> Close it by clicking on it, anywhere else on the screen or by pressing the escape key. <br> This will affect only the shortcode language switcher.', 'translatepress-multilingual'),\n    enableTransitions: __( 'Switcher animations', 'translatepress-multilingual' ),\n    showOppositeLanguage: __('Show opposite language', 'translatepress-multilingual'),\n}\n\r\nonBeforeRouteLeave((_to, _from, next) => {\r\n    if (!isDirty.value) return next()\r\n    const confirmLeave = window.confirm(T.confirmLeave)\r\n    confirmLeave ? (revert(), next()) : next(false)\r\n})\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-floater-settings__wrapper\">\r\n        <div class=\"trp-floater-settings__left\">\r\n            <div class=\"trp-sticky-box\">\r\n                <SettingsBox :title=\"T.switcherPreview\" :scope=\"scope\">\r\n                    <LanguageSwitcherPreview :scope=\"scope\" />\r\n                </SettingsBox>\r\n\r\n                <SettingsActions :scope=\"scope\" />\r\n            </div>\r\n        </div>\r\n\r\n        <div class=\"trp-floater-settings__right\">\r\n            <SettingsBox :title=\"T.shortcode\" :scope=\"scope\">\r\n                <ShortcodeCopy />\r\n            </SettingsBox>\r\n\r\n            <SettingsBox\r\n                :title=\"T.customizeDesign\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :style=\"{ '--trp-field-label-width': '190px' }\"\r\n                :fields=\"[\r\n                    { key: 'bgColor',        type: 'color', label: T.backgroundColor,       default: '#ffffff' },\r\n                    { key: 'bgHoverColor',   type: 'color', label: T.backgroundHoverColor,  default: '#f5f5f5' },\r\n                    { key: 'textColor',      type: 'color', label: T.textColor,             default: '#1D2327' },\r\n                    { key: 'textHoverColor', type: 'color', label: T.textHoverColor,        default: '#000000' },\r\n                    { key: 'borderColor',    type: 'color', label: T.switcherBorderColor,   default: '#1438521A' },\r\n                    { key: 'borderWidth',    type: 'number',label: T.switcherBorderWidth,   default: 1 },\r\n                    { key: 'borderRadius',   type: 'number',label: T.switcherBorderRadius,  default: 5 },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'enableTransitions',\r\n                        type: 'toggle',\r\n                        label: T.enableTransitions,\r\n                        default: true\r\n                    },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'size',\r\n                        type: 'radio',\r\n                        label: T.flagTextSize,\r\n                        default: 'normal',\r\n                        options: [\r\n                            { value: 'normal', label: T.normal },\r\n                            { value: 'large',  label: T.large  }\r\n                        ],\r\n                        layout: 'column'\r\n                    },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'flagShape',\r\n                        type: 'radio',\r\n                        label: T.flagIconsShape,\r\n                        default: 'rect',\r\n                        options: [\r\n                            { value: 'rect',   label: T.rectangle },\r\n                            { value: 'square', label: T.square    }\r\n                        ],\r\n                        layout: 'column'\r\n                    },\r\n                    { key: 'flagRadius', type: 'number', label: T.flagRadius, default: 2 },\r\n                    { type: 'separator' },\r\n                    { key: 'enableCustomCss', type: 'toggle', label: T.enableCustomCss, default: false },\r\n                    { key: 'customCss', type: 'customCss', label: '', visible: cfg => cfg?.enableCustomCss === true }\r\n                ]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                :title=\"T.customizeLayout\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :fields=\"[\r\n                    { key: 'layoutCustomizer', type: 'lCustomizer', label: '' }\r\n                ]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                :title=\"T.additionalSettings\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :fields=\"[\r\n                    {\r\n                        key: 'clickLanguage',\r\n                        type: 'checkbox',\r\n                        default: false,\r\n                        label: T.openOnClick,\r\n                        description: T.clickLangDesc\r\n                    },\r\n                    {\r\n                        key: 'oppositeLanguage',\r\n                        type: 'checkbox',\r\n                        default: false,\r\n                        label: T.showOppositeLanguage,\r\n                        description: oppositeLanguageFieldDescription,\r\n                        disabled: aboveTwoLanguages,\r\n                        title: aboveTwoLanguagesTitle\r\n                    }\r\n                ]\"\r\n            />\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n/* Re-use the same structural styles as the Floater view for consistency */\r\n.trp-floater-settings__wrapper {\r\n    display:flex;\r\n    flex-direction:row;\r\n    gap:16px;\r\n    max-width:1200px;\r\n    width:100%;\r\n}\r\n\r\n.trp-floater-settings__right {\r\n    display:flex;\r\n    flex-direction:column;\r\n    gap:16px;\r\n    width:60%;\r\n    max-width:641px;\r\n}\r\n\r\n.trp-floater-settings__left {\r\n    width:40%;\r\n}\r\n\r\n.trp-sticky-box {\r\n    position:sticky; top:50px;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},482(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-description-text[data-v-2e0e42ea]{line-height:150%}.trp-settings-checkbox input[data-v-2e0e42ea]:disabled{background:var(--trp-settings-disabled-color);border:none!important;pointer-events:none}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/CheckboxField.vue"],names:[],mappings:"AA6DA,uCACI,gBACJ,CACA,uDAEI,6CAA8C,CAC9C,qBAAuB,CAFvB,mBAGJ",sourcesContent:['<script setup>\r\nimport { computed } from \'vue\'\r\n\r\n/**\r\n * A simple checkbox field for the settings UI.\r\n *\r\n * Props\r\n *  - modelValue  (Boolean)  – bound value (true = checked)\r\n *  - label       (String)   – bold label text\r\n *  - description (String)   – secondary text (HTML allowed)\r\n *\r\n * Emits\r\n *  - update:modelValue\r\n */\r\nconst props = defineProps({\r\n    modelValue  : { type: Boolean, required: true },\r\n    label       : { type: String,  default: \'\' },\r\n    description : { type: String,  default: \'\' },\r\n    disabled    : { type: Boolean, default: false },\r\n    title       : { type: String, default: \'\' }\r\n})\r\n\r\nconst emit = defineEmits([\'update:modelValue\'])\r\n\r\n/* A stable unique ID so the <label> is associated with the <input>. */\r\nconst inputId = `trp-checkbox-${Math.random().toString(36).slice(2)}`\r\n\r\n/* Computed wrapper to keep SettingsBox’s two-way binding contract intact. */\r\nconst checked = computed({\r\n    get: () => props.modelValue === true,\r\n    set: (val) => emit(\'update:modelValue\', val)\r\n})\r\n\r\n<\/script>\r\n\r\n<template>\r\n    <div\r\n        class="trp-settings-checkbox trp-settings-options-item"\r\n        :title="props.title"\r\n    >\r\n        <input\r\n            type="checkbox"\r\n            :id="inputId"\r\n            v-model="checked"\r\n            :disabled="props.disabled"\r\n        />\r\n\r\n        <label :for="inputId" class="trp-checkbox-label">\r\n            <div class="trp-checkbox-content">\r\n                <span v-if="label" class="trp-primary-text-bold">{{ label }}</span>\r\n                <span\r\n                    v-if="description"\r\n                    class="trp-description-text"\r\n                    v-html="description"\r\n                />\r\n            </div>\r\n        </label>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-description-text {\r\n    line-height: 150%;\r\n}\r\n.trp-settings-checkbox input:disabled {\r\n    pointer-events: none;\r\n    background: var(--trp-settings-disabled-color);\r\n    border: none !important;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},548(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-language-switcher-preview__container[data-v-40a042e8]{display:flex;flex-direction:column;gap:24px}.trp-language-switcher-preview-box[data-v-40a042e8]{background-image:var(--v21e78ad8);background-repeat:no-repeat;background-size:cover;border:1px solid #e2e2e4;border-radius:var(--trp-settings-radius-small);height:220px;overflow:hidden;position:relative}.trp-language-switcher-preview-box .trp-floating-switcher:hover .trp-switcher-dropdown-list[data-v-40a042e8]{max-height:150px}.trp-floating-switcher[data-v-40a042e8]:hover{overflow-y:auto}.trp-language-switcher[data-v-40a042e8]{background:var(--bg);border-color:var(--border-color);border-radius:var(--border-radius);border-style:solid;border-width:var(--border-width);bottom:var(--bottom,unset);box-shadow:0 10px 20px 0 #0000000d;display:flex;flex-direction:column-reverse;left:var(--left,unset);overflow:hidden;padding:var(--switcher-padding);position:absolute;right:var(--right,unset);top:var(--top,unset);transition:.2s ease;width:var(--switcher-width)}.trp-switcher-position-top.trp-language-switcher[data-v-40a042e8]{flex-direction:column}.trp-language-switcher-inner[data-v-40a042e8]{display:flex;flex-direction:column-reverse}.trp-preview-ls-inline .trp-language-switcher-inner[data-v-40a042e8]{flex-direction:row;justify-content:space-between}.trp-switcher-position-top.trp-ls-dropdown .trp-language-switcher-inner[data-v-40a042e8],.trp-switcher-position-top.trp-ls-dropdown .trp-switcher-dropdown-list[data-v-40a042e8]{flex-direction:column}.trp-ls-dropdown:not(:hover) .trp-language-item[data-v-40a042e8]{pointer-events:none}.trp-switcher-dropdown-list[data-v-40a042e8]{max-height:0;overflow:hidden;scrollbar-color:var(--text) transparent;scrollbar-width:thin;transition:.2s ease-in-out;transition-duration:var(--transition-duration)}.trp-language-switcher.trp-shortcode-switcher[data-v-40a042e8]{border:var(--border-width) solid var(--border-color);flex-direction:column;left:50%;overflow-y:hidden;padding:10px 0;top:35%;transform:translateX(-50%);transition:none;width:auto}.trp-language-switcher.trp-shortcode-switcher .trp-language-switcher-inner[data-v-40a042e8]{flex-direction:column}.trp-current-language-item__wrapper[data-v-40a042e8]{align-items:center;display:flex;flex-direction:row;justify-content:space-between;padding-right:8px}.trp-shortcode-switcher.trp-dropdown-open .trp-shortcode-arrow[data-v-40a042e8]{transform:rotate(180deg)}.trp-language-switcher.trp-shortcode-switcher.trp-open-on-hover:hover .trp-switcher-dropdown-list[data-v-40a042e8],.trp-open-on-click.trp-dropdown-open .trp-switcher-dropdown-list[data-v-40a042e8]{max-height:75px;overflow-y:auto}.trp-open-on-click .trp-current-language-item__wrapper[data-v-40a042e8]{cursor:pointer}.trp-shortcode-arrow[data-v-40a042e8]{pointer-events:none}.trp-shortcode-switcher.trp-opposite-button[data-v-40a042e8]{border-radius:var(--border-radius);overflow:hidden;padding:var(--switcher-padding,10px 12px);transition:none;width:auto}.trp-shortcode-switcher.trp-opposite-button .trp-current-language-item__wrapper[data-v-40a042e8]{cursor:default}.trp-shortcode-switcher .trp-current-language-item__wrapper.trp-hide-arrow .trp-shortcode-arrow[data-v-40a042e8]{display:none}.trp-shortcode-switcher.trp-opposite-button .trp-switcher-dropdown-list[data-v-40a042e8]{display:none!important;max-height:0!important;overflow:hidden!important}.trp-shortcode-switcher.trp-opposite-button.trp-open-on-hover:hover .trp-switcher-dropdown-list[data-v-40a042e8]{display:none!important}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/LanguageSwitcherPreview.vue"],names:[],mappings:"AAkMI,2DACI,YAAa,CACb,qBAAsB,CACtB,QACJ,CAEA,oDACI,iCAA+B,CAC/B,2BAA4B,CAC5B,qBAAsB,CAItB,wBAAyB,CADzB,8CAA+C,CAF/C,YAAa,CAIb,eAAgB,CAHhB,iBAIJ,CAEA,6GACI,gBACJ,CAEA,8CACI,eACJ,CAEA,wCAcI,oBAAqB,CAFrB,gCAAiC,CADjC,kCAAmC,CAEnC,kBAAmB,CAHnB,gCAAiC,CANjC,0BAA4B,CAY5B,kCAAmC,CAfnC,YAAa,CACb,6BAA8B,CAI9B,sBAAwB,CAExB,eAAgB,CAChB,+BAAgC,CANhC,iBAAkB,CAIlB,wBAA0B,CAF1B,oBAAsB,CAYtB,mBAAqB,CAFrB,2BAGJ,CAEA,kEACI,qBACJ,CAEA,8CACI,YAAa,CACb,6BACJ,CAEA,qEACI,kBAAmB,CACnB,6BACJ,CAEA,iLACI,qBACJ,CAEA,iEACI,mBACJ,CAEA,6CACI,YAAa,CACb,eAAgB,CAGhB,uCAAwC,CADxC,oBAAqB,CADrB,0BAA4B,CAG5B,8CACJ,CAGA,+DAII,oDAAqD,CAKrD,qBAAsB,CAPtB,QAAS,CAGT,iBAAkB,CAElB,cAAe,CANf,OAAQ,CAER,0BAA2B,CAG3B,eAAgB,CAEhB,UAEJ,CAEA,4FACI,qBACJ,CAEA,qDAGI,kBAAmB,CAFnB,YAAa,CACb,kBAAmB,CAEnB,6BAA8B,CAC9B,iBACJ,CAEA,gFACI,wBACJ,CAOA,qMACI,eAAgB,CAChB,eACJ,CAEA,wEACI,cACJ,CAEA,sCACI,mBACJ,CAEA,6DAEI,kCAAmC,CAEnC,eAAgB,CAHhB,yCAA2C,CAI3C,eAAgB,CAFhB,UAGJ,CAGA,iGACI,cACJ,CAGA,iHACI,YACJ,CAGA,yFACI,sBAAwB,CACxB,sBAAwB,CACxB,yBACJ,CAGA,iHACI,sBACJ",sourcesContent:['<script setup>\r\nimport { useSwitcherPreview } from "../composables/useSwitcherPreview"\r\nimport { computed, ref }        from "vue"\r\n\r\nimport LanguageItem from "./LanguageItem.vue"\r\nimport PoweredBy    from "./PoweredBy.vue"\r\n\r\nimport { __ } from \'@wordpress/i18n\'\r\n\r\nconst bgUrl = `url(${window.tpLangSwitcherData.misc.pluginUrl}assets/images/switcher-preview-bg.png)`\r\n\r\nconst props = defineProps({\r\n    scope: {\r\n      type: String,\r\n      default: \'\',\r\n      validator: v => [\'floater\',\'shortcode\',\'menu\'].includes(v)\r\n    }\r\n})\r\n\r\nconst isOpen = ref(false)\r\n\r\nconst toggleDropdown = () => openOnClick.value && ( isOpen.value = !isOpen.value )\r\n\r\nconst isShortcode = computed(() => props.scope === \'shortcode\')\r\n\r\nconst previewBoxText = __( \'Hover over the language switcher to see it in action!\', \'translatepress-multilingual\')\r\n\r\nconst switcherEdgeClass = computed(() => {\r\n    if (props.scope !== \'floater\') return null\r\n\r\n    if (switcherPosition.value?.startsWith(\'top\')) return \'trp-switcher-position-top\'\r\n    if (switcherPosition.value?.startsWith(\'bottom\')) return \'trp-switcher-position-bottom\'\r\n\r\n    return null\r\n})\r\n\r\nconst {\r\n    displayedList,\r\n    isDropdown,\r\n    switcherStyles,\r\n    isOppositeMode,\r\n    showPoweredBy,\r\n    switcherPosition,\r\n    openOnClick\r\n} = useSwitcherPreview(props.scope)\r\n\r\nconst allowShortcodeToggle = computed(() => isShortcode.value && !isOppositeMode.value && openOnClick.value)\r\n\r\nconst shortcodeClasses = computed(() => {\r\n    if (!isShortcode.value) return []\r\n    return [\r\n        isOppositeMode.value ? \'trp-opposite-button\' : null,\r\n        allowShortcodeToggle.value ? \'trp-open-on-click\' : \'trp-open-on-hover\',\r\n        { \'trp-dropdown-open\': isOpen.value && !isOppositeMode.value }\r\n    ]\r\n})\r\n\r\nconst onShortcodeClick = () => {\r\n    if (!isShortcode.value || isOppositeMode.value) return\r\n    if (openOnClick.value) isOpen.value = !isOpen.value\r\n}\r\n<\/script>\r\n\r\n<template>\r\n    <div class="trp-language-switcher-preview__container">\r\n        <div class="trp-language-switcher-preview-box">\r\n            \x3c!-- Floater view, opposite mode --\x3e\r\n            <template v-if="isOppositeMode && !isShortcode">\r\n                <div\r\n                    class="trp-language-switcher trp-floating-switcher trp-opposite-button"\r\n                    :style="switcherStyles"\r\n                >\r\n                    <LanguageItem\r\n                        v-if="displayedList.length"\r\n                        :key="displayedList[0].code"\r\n                        :language="displayedList[0]"\r\n                    />\r\n\r\n                    <PoweredBy v-if="showPoweredBy" />\r\n                </div>\r\n            </template>\r\n\r\n            \x3c!-- Floater view, normal display --\x3e\r\n            <template v-else-if="!isShortcode">\r\n                <div\r\n                    v-if="isDropdown"\r\n                    class="trp-language-switcher trp-floating-switcher trp-ls-dropdown"\r\n                    :class="switcherEdgeClass"\r\n                    :style="switcherStyles"\r\n                >\r\n                    <PoweredBy v-if="showPoweredBy" />\r\n\r\n                    <div class="trp-language-switcher-inner">\r\n                        <LanguageItem\r\n                            v-if="displayedList.length"\r\n                            :key="displayedList[0].code"\r\n                            :language="displayedList[0]"\r\n                            :dropdown="false"\r\n                            class="trp-language-item__default"\r\n                        />\r\n\r\n                        <div class="trp-switcher-dropdown-list">\r\n                            <LanguageItem\r\n                                v-for="lang in displayedList.slice(1)"\r\n                                :key="lang.code"\r\n                                :language="lang"\r\n                                :dropdown="true"\r\n                            />\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div\r\n                    v-else\r\n                    class="trp-language-switcher trp-preview-ls-inline"\r\n                    :class="switcherEdgeClass"\r\n                    :style="switcherStyles"\r\n                >\r\n                    <PoweredBy v-if="showPoweredBy" />\r\n\r\n                    <div class="trp-language-switcher-inner">\r\n                        <LanguageItem\r\n                            v-for="lang in displayedList"\r\n                            :key="lang.code"\r\n                            :language="lang"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </template>\r\n\r\n            \x3c!-- Shortcode view --\x3e\r\n            <template v-else>\r\n                <div\r\n                    class="trp-language-switcher trp-ls-dropdown trp-shortcode-switcher"\r\n                    :class="shortcodeClasses"\r\n                    :style="switcherStyles"\r\n                    @click="onShortcodeClick"\r\n                >\r\n                    <div class="trp-language-switcher-inner">\r\n                        <div class="trp-current-language-item__wrapper" :class="{ \'trp-hide-arrow\': isOppositeMode }">\r\n                            <LanguageItem\r\n                                v-if="displayedList.length"\r\n                                :key="displayedList[0].code"\r\n                                :language="displayedList[0]"\r\n                                :dropdown="false"\r\n                                class="trp-language-item__default"\r\n                            />\r\n\r\n                            \x3c!-- Arrow is visually hidden in opposite mode via CSS --\x3e\r\n                            <svg\r\n                                class="trp-shortcode-arrow"\r\n                                width="20"\r\n                                height="20"\r\n                                viewBox="0 0 20 21"\r\n                                fill="none"\r\n                                xmlns="http://www.w3.org/2000/svg"\r\n                            >\r\n                                <path\r\n                                    d="M5 8L10 13L15 8"\r\n                                    stroke="var(--text)"\r\n                                    stroke-width="2"\r\n                                    stroke-linecap="round"\r\n                                    stroke-linejoin="round"\r\n                                />\r\n                            </svg>\r\n                        </div>\r\n\r\n                        \x3c!-- Dropdown list is removed in opposite mode --\x3e\r\n                        <div\r\n                            v-if="!isOppositeMode"\r\n                            class="trp-switcher-dropdown-list"\r\n                        >\r\n                            <LanguageItem\r\n                                v-for="lang in displayedList.slice(1)"\r\n                                :key="lang.code"\r\n                                :language="lang"\r\n                                :dropdown="true"\r\n                            />\r\n                        </div>\r\n                    </div>\r\n\r\n                    <PoweredBy v-if="showPoweredBy && isOppositeMode" />\r\n                </div>\r\n            </template>\r\n\r\n        </div>\r\n\r\n        <span class="trp-language-switcher-preview-text trp-description-text">\r\n            {{ previewBoxText }}\r\n        </span>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n    .trp-language-switcher-preview__container{\r\n        display: flex;\r\n        flex-direction: column;\r\n        gap: 24px;\r\n    }\r\n\r\n    .trp-language-switcher-preview-box {\r\n        background-image: v-bind(bgUrl);\r\n        background-repeat: no-repeat;\r\n        background-size: cover;\r\n        height: 220px;\r\n        position: relative;\r\n        border-radius: var(--trp-settings-radius-small);\r\n        border: 1px solid #E2E2E4;\r\n        overflow: hidden;\r\n    }\r\n\r\n    .trp-language-switcher-preview-box .trp-floating-switcher:hover .trp-switcher-dropdown-list {\r\n        max-height: 150px;\r\n    }\r\n\r\n    .trp-floating-switcher:hover {\r\n        overflow-y: auto;\r\n    }\r\n\r\n    .trp-language-switcher {\r\n        display: flex;\r\n        flex-direction: column-reverse;\r\n        position: absolute;\r\n        bottom: var(--bottom, unset);\r\n        top: var(--top, unset);\r\n        left: var(--left, unset);\r\n        right: var(--right, unset);\r\n        overflow: hidden;\r\n        padding: var(--switcher-padding);\r\n        border-width: var(--border-width);\r\n        border-radius: var(--border-radius);\r\n        border-color: var(--border-color);\r\n        border-style: solid;\r\n        background: var(--bg);\r\n        width: var(--switcher-width);\r\n        box-shadow: 0 10px 20px 0 #0000000D;\r\n        transition: 0.2s ease;\r\n    }\r\n\r\n    .trp-switcher-position-top.trp-language-switcher {\r\n        flex-direction: column;\r\n    }\r\n\r\n    .trp-language-switcher-inner {\r\n        display: flex;\r\n        flex-direction: column-reverse;\r\n    }\r\n\r\n    .trp-preview-ls-inline .trp-language-switcher-inner {\r\n        flex-direction: row;\r\n        justify-content: space-between;\r\n    }\r\n\r\n    .trp-switcher-position-top.trp-ls-dropdown .trp-language-switcher-inner, .trp-switcher-position-top.trp-ls-dropdown .trp-switcher-dropdown-list{\r\n        flex-direction: column;\r\n    }\r\n\r\n    .trp-ls-dropdown:not(:hover) .trp-language-item {\r\n        pointer-events: none;\r\n    }\r\n\r\n    .trp-switcher-dropdown-list {\r\n        max-height: 0;\r\n        overflow: hidden;\r\n        transition: 0.2s ease-in-out;\r\n        scrollbar-width: thin;\r\n        scrollbar-color: var(--text) transparent;\r\n        transition-duration: var(--transition-duration);\r\n    }\r\n\r\n    /* Shortcode styling */\r\n    .trp-language-switcher.trp-shortcode-switcher {\r\n        top: 35%;\r\n        left: 50%;\r\n        transform: translateX(-50%);\r\n        border: var(--border-width) solid var(--border-color);\r\n        overflow-y: hidden;\r\n        transition: none;\r\n        padding: 10px 0;\r\n        width: auto;\r\n        flex-direction: column;\r\n    }\r\n\r\n    .trp-language-switcher.trp-shortcode-switcher .trp-language-switcher-inner {\r\n        flex-direction: column;\r\n    }\r\n\r\n    .trp-current-language-item__wrapper {\r\n        display: flex;\r\n        flex-direction: row;\r\n        align-items: center;\r\n        justify-content: space-between;\r\n        padding-right: 8px;\r\n    }\r\n\r\n    .trp-shortcode-switcher.trp-dropdown-open .trp-shortcode-arrow {\r\n        transform: rotate(180deg);\r\n    }\r\n\r\n    .trp-language-switcher.trp-shortcode-switcher.trp-open-on-hover:hover .trp-switcher-dropdown-list {\r\n        max-height: 75px;\r\n        overflow-y: auto;\r\n    }\r\n\r\n    .trp-open-on-click.trp-dropdown-open .trp-switcher-dropdown-list {\r\n        max-height: 75px;\r\n        overflow-y: auto;\r\n    }\r\n\r\n    .trp-open-on-click .trp-current-language-item__wrapper {\r\n        cursor: pointer;\r\n    }\r\n\r\n    .trp-shortcode-arrow {\r\n        pointer-events: none;\r\n    }\r\n\r\n    .trp-shortcode-switcher.trp-opposite-button {\r\n        padding: var(--switcher-padding, 10px 12px);\r\n        border-radius: var(--border-radius);\r\n        width: auto;\r\n        overflow: hidden;     /* no inner scroll in opposite */\r\n        transition: none;     /* no hover expand */\r\n    }\r\n\r\n    /* Don’t treat current item like a toggle in opposite mode */\r\n    .trp-shortcode-switcher.trp-opposite-button .trp-current-language-item__wrapper {\r\n        cursor: default;\r\n    }\r\n\r\n    /* Hide the arrow when opposite */\r\n    .trp-shortcode-switcher .trp-current-language-item__wrapper.trp-hide-arrow .trp-shortcode-arrow {\r\n        display: none;\r\n    }\r\n\r\n    /* Ensure no dropdown animation space is reserved in opposite */\r\n    .trp-shortcode-switcher.trp-opposite-button .trp-switcher-dropdown-list {\r\n        display: none !important;\r\n        max-height: 0 !important;\r\n        overflow: hidden !important;\r\n    }\r\n\r\n    /* Prevent hover-expansion rules affecting opposite mode */\r\n    .trp-shortcode-switcher.trp-opposite-button.trp-open-on-hover:hover .trp-switcher-dropdown-list {\r\n        display: none !important;\r\n    }\r\n\r\n</style>'],sourceRoot:""}]);const a=s},565(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-number-input[data-v-4d5d37b0]::-webkit-inner-spin-button,.trp-number-input[data-v-4d5d37b0]::-webkit-outer-spin-button{-webkit-appearance:none;margin:0}.trp-number-input[type=number][data-v-4d5d37b0]{-moz-appearance:textfield}.trp-number__wrapper[data-v-4d5d37b0]{align-items:center;display:flex;flex-direction:row;gap:10px}.trp-number-input[data-v-4d5d37b0]{border:1px solid #c3c4c7;border-radius:5px;height:40px;text-align:center;width:53px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/NumberField.vue"],names:[],mappings:"AAiCA,4HAEI,uBAAwB,CACxB,QACJ,CAGA,gDACI,yBACJ,CAEA,sCAII,kBAAmB,CAHnB,YAAa,CACb,kBAAmB,CACnB,QAEJ,CAEA,mCAGI,wBAAyB,CACzB,iBAAkB,CAFlB,WAAY,CAGZ,iBAAkB,CAJlB,UAKJ",sourcesContent:['<script setup>\r\nconst props = defineProps({\r\n    label       : { type: String, default: \'\' },\r\n    modelValue  : { type: [Number, null], default: null },\r\n    min         : { type: Number, default: 0, required: false },\r\n})\r\n\r\nconst emit = defineEmits([\'update:modelValue\'])\r\n\r\nfunction onInput (e) {\r\n    const val = e.target.value\r\n    emit(\'update:modelValue\', val === \'\' ? props.min : Number(val))\r\n}\r\n<\/script>\r\n\r\n<template>\r\n    <div>\r\n        <span v-if="label" class="trp-field__label trp-primary-text-bold">{{ label }}</span>\r\n        <div class="trp-number__wrapper">\r\n            <input\r\n                type="number"\r\n                class="trp-number-input"\r\n                :value="modelValue ?? \'\'"\r\n                :min="min"\r\n                @input="onInput"\r\n            />\r\n            <span class="trp-primary-text">px</span>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n/* Remove arrows in Chrome, Safari, Edge */\r\n.trp-number-input::-webkit-outer-spin-button,\r\n.trp-number-input::-webkit-inner-spin-button {\r\n    -webkit-appearance: none;\r\n    margin: 0;\r\n}\r\n\r\n/* Remove arrows in Firefox */\r\n.trp-number-input[type=\'number\'] {\r\n    -moz-appearance: textfield;\r\n}\r\n\r\n.trp-number__wrapper {\r\n    display: flex;\r\n    flex-direction: row;\r\n    gap: 10px;\r\n    align-items: center;\r\n}\r\n\r\n.trp-number-input {\r\n    width: 53px;\r\n    height: 40px;\r\n    border: 1px solid #C3C4C7;\r\n    border-radius: 5px;\r\n    text-align: center;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},571(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-switcher-preview[data-v-2f8e6670]{background:var(--bg);border:1px solid var(--border-color);border-radius:var(--trp-settings-radius-medium);box-shadow:0 10px 20px 0 #0000000d;overflow:hidden;padding:5px 0;width:-moz-fit-content;width:fit-content}.trp-language-item[data-v-2f8e6670]{align-items:center;display:flex;flex-direction:row}.trp-dropdown-preview[data-v-2f8e6670] .trp-language-item-name{max-width:150px}.trp-preview-ls-inline[data-v-2f8e6670] .trp-language-item-name{width:75px}.trp-preview-ls-inline[data-v-2f8e6670]{display:flex;justify-content:space-between}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/PresetPreviewLanguageSwitcher.vue"],names:[],mappings:"AAsCA,uCAGI,oBAAqB,CAFrB,oCAAqC,CACrC,+CAAgD,CAGhD,kCAAmC,CACnC,eAAgB,CAChB,aAAc,CAHd,sBAAkB,CAAlB,iBAIJ,CAEA,oCAGI,kBAAmB,CAFnB,YAAa,CACb,kBAEJ,CAEA,+DACI,eACJ,CAEA,gEACI,UACJ,CAEA,wCACI,YAAa,CACb,6BACJ",sourcesContent:['<script setup>\r\nimport { useSwitcherPreview } from "../composables/useSwitcherPreview"\r\nimport LanguageItem           from "./LanguageItem.vue"\r\n\r\nconst props = defineProps({\r\n    scope: {\r\n        type: String,\r\n        required: true,\r\n        validator: v => [\'floater\',\'shortcode\',\'menu\'].includes(v)\r\n    }\r\n})\r\n\r\nconst { displayedList, isDropdown } = useSwitcherPreview(props.scope)\r\n<\/script>\r\n\r\n<template>\r\n    <div v-if="isDropdown" class="trp-switcher-preview trp-dropdown-preview">\r\n        <LanguageItem\r\n            v-for="lang in displayedList"\r\n            :key="lang.code"\r\n            :language="lang"\r\n            :dropdown="true"\r\n        />\r\n    </div>\r\n\r\n    <div v-else class="trp-switcher-preview trp-preview-ls-inline">\r\n        <LanguageItem\r\n            v-for="lang in displayedList"\r\n            :key="lang.code"\r\n            :language="lang"\r\n            :dropdown="false"\r\n        />\r\n    </div>\r\n</template>\r\n\r\n\r\n<style scoped>\r\n/* DROPDOWN PREVIEW */\r\n.trp-switcher-preview {\r\n    border: 1px solid var(--border-color);\r\n    border-radius: var(--trp-settings-radius-medium);\r\n    background: var(--bg);\r\n    width: fit-content;\r\n    box-shadow: 0 10px 20px 0 #0000000D;\r\n    overflow: hidden;\r\n    padding: 5px 0;\r\n}\r\n\r\n.trp-language-item{\r\n    display: flex;\r\n    flex-direction: row;\r\n    align-items: center;\r\n}\r\n\r\n.trp-dropdown-preview :deep(.trp-language-item-name) {\r\n    max-width: 150px;\r\n}\r\n\r\n.trp-preview-ls-inline :deep(.trp-language-item-name) {\r\n    width: 75px;\r\n}\r\n\r\n.trp-preview-ls-inline {\r\n    display: flex;\r\n    justify-content: space-between;\r\n}\r\n\r\n</style>\r\n'],sourceRoot:""}]);const a=s},606(e){var t,n,r=e.exports={};function i(){throw new Error("setTimeout has not been defined")}function o(){throw new Error("clearTimeout has not been defined")}function s(e){if(t===setTimeout)return setTimeout(e,0);if((t===i||!t)&&setTimeout)return t=setTimeout,setTimeout(e,0);try{return t(e,0)}catch(n){try{return t.call(null,e,0)}catch(n){return t.call(this,e,0)}}}!function(){try{t="function"==typeof setTimeout?setTimeout:i}catch(e){t=i}try{n="function"==typeof clearTimeout?clearTimeout:o}catch(e){n=o}}();var a,l=[],c=!1,d=-1;function h(){c&&a&&(c=!1,a.length?l=a.concat(l):d=-1,l.length&&u())}function u(){if(!c){var e=s(h);c=!0;for(var t=l.length;t;){for(a=l,l=[];++d<t;)a&&a[d].run();d=-1,t=l.length}a=null,c=!1,function(e){if(n===clearTimeout)return clearTimeout(e);if((n===o||!n)&&clearTimeout)return n=clearTimeout,clearTimeout(e);try{return n(e)}catch(t){try{return n.call(null,e)}catch(t){return n.call(this,e)}}}(e)}}function p(e,t){this.fun=e,this.array=t}function f(){}r.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];l.push(new p(e,t)),1!==l.length||c||s(u)},p.prototype.run=function(){this.fun.apply(null,this.array)},r.title="browser",r.browser=!0,r.env={},r.argv=[],r.version="",r.versions={},r.on=f,r.addListener=f,r.once=f,r.off=f,r.removeListener=f,r.removeAllListeners=f,r.emit=f,r.prependListener=f,r.prependOnceListener=f,r.listeners=function(e){return[]},r.binding=function(e){throw new Error("process.binding is not supported")},r.cwd=function(){return"/"},r.chdir=function(e){throw new Error("process.chdir is not supported")},r.umask=function(){return 0}},616(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,"#trp-floater-powered-by[data-v-fe637818]{color:var(--text,#b3b3b3)!important;font-size:12px;opacity:70%;padding:0 5px;text-align:center}#trp-floater-powered-by[data-v-fe637818] a{color:var(--text,#b3b3b3)}.trp-switcher-position-bottom #trp-floater-powered-by[data-v-fe637818]{border-top:1px solid var(--border-color,#747474);margin-top:5px;padding-top:5px}.trp-switcher-position-top #trp-floater-powered-by[data-v-fe637818]{border-bottom:1px solid var(--border-color,#747474);margin-bottom:5px;padding-bottom:5px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/PoweredBy.vue"],names:[],mappings:"AAYA,yCACI,mCAAsC,CACtC,cAAe,CAGf,WAAY,CADZ,aAAc,CADd,iBAGJ,CAEA,2CACI,yBACJ,CAEA,uEACI,gDAAkD,CAElD,cAAe,CADf,eAEJ,CAEA,oEACI,mDAAqD,CAErD,iBAAkB,CADlB,kBAEJ",sourcesContent:["<script setup>\r\nimport { __ } from '@wordpress/i18n'\n<\/script>\r\n\r\n<template>\r\n    <div id=\"trp-floater-powered-by\">\r\n    \x3c!-- [utm3] --\x3e\r\n        <span v-html=\"__('Powered by <a href=&quot;https://translatepress.com/?utm_source=frontend-ls&amp;utm_medium=client-site&amp;utm_campaign=powered-by-tp&quot; rel=&quot;nofollow&quot; target=&quot;_blank&quot; title=&quot;WordPress Translation Plugin&quot;>TranslatePress</a>', 'translatepress-multilingual')\"></span>\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n#trp-floater-powered-by {\r\n    color: var(--text, #b3b3b3) !important;\r\n    font-size: 12px;\r\n    text-align: center;\r\n    padding: 0 5px;\r\n    opacity: 70%;\r\n}\r\n\r\n#trp-floater-powered-by :deep(a) {\r\n    color: var(--text, #b3b3b3);\r\n}\r\n\r\n.trp-switcher-position-bottom #trp-floater-powered-by {\r\n    border-top: 1px solid var(--border-color, #747474);\r\n    padding-top: 5px;\r\n    margin-top: 5px;\r\n}\r\n\r\n.trp-switcher-position-top #trp-floater-powered-by {\r\n    border-bottom: 1px solid var(--border-color, #747474);\r\n    padding-bottom: 5px;\r\n    margin-bottom: 5px;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},627(e){"use strict";function t(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var n=e&&("undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"]);if(null==n)return;var r,i,o=[],s=!0,a=!1;try{for(n=n.call(e);!(s=(r=n.next()).done)&&(o.push(r.value),!t||o.length!==t);s=!0);}catch(e){a=!0,i=e}finally{try{s||null==n.return||n.return()}finally{if(a)throw i}}return o}(e,t)||function(e,t){if(!e)return;if("string"==typeof e)return n(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return n(e,t)}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function n(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}e.exports=function(e){var n=t(e,4),r=n[1],i=n[3];if(!i)return r;if("function"==typeof btoa){var o=btoa(unescape(encodeURIComponent(JSON.stringify(i)))),s="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(o),a="/*# ".concat(s," */"),l=i.sources.map(function(e){return"/*# sourceURL=".concat(i.sourceRoot||"").concat(e," */")});return[r].concat(l).concat([a]).join("\n")}return[r].join("\n")}},693(e,t,n){"use strict";var r={};function i(e){const t=Object.create(null);for(const n of e.split(","))t[n]=1;return e=>e in t}n.r(r),n.d(r,{BaseTransition:()=>Nr,BaseTransitionPropsValidators:()=>Dr,Comment:()=>Bs,DeprecationTypes:()=>za,EffectScope:()=>be,ErrorCodes:()=>On,ErrorTypeStrings:()=>Ia,Fragment:()=>Ss,KeepAlive:()=>bi,ReactiveEffect:()=>ke,Static:()=>_s,Suspense:()=>bs,Teleport:()=>Sr,Text:()=>Os,TrackOpTypes:()=>un,Transition:()=>el,TransitionGroup:()=>Kl,TriggerOpTypes:()=>pn,VueElement:()=>Wl,assertNumber:()=>Sn,callWithAsyncErrorHandling:()=>Tn,callWithErrorHandling:()=>_n,camelize:()=>D,capitalize:()=>I,cloneVNode:()=>Gs,compatUtils:()=>Va,computed:()=>_a,createApp:()=>Ec,createBlock:()=>Qs,createCommentVNode:()=>Js,createElementBlock:()=>Ls,createElementVNode:()=>Hs,createHydrationRenderer:()=>ls,createPropsRestProxy:()=>mo,createRenderer:()=>as,createSSRApp:()=>Mc,createSlots:()=>Ui,createStaticVNode:()=>Xs,createTextVNode:()=>Ys,createVNode:()=>js,customRef:()=>on,defineAsyncComponent:()=>gi,defineComponent:()=>$r,defineCustomElement:()=>Fl,defineEmits:()=>ro,defineExpose:()=>io,defineModel:()=>ao,defineOptions:()=>oo,defineProps:()=>no,defineSSRCustomElement:()=>Vl,defineSlots:()=>so,devtools:()=>Na,effect:()=>Le,effectScope:()=>ye,getCurrentInstance:()=>aa,getCurrentScope:()=>xe,getCurrentWatcher:()=>vn,getTransitionRawChildren:()=>Wr,guardReactiveProps:()=>Us,h:()=>Ta,handleError:()=>En,hasInjectionContext:()=>sr,hydrate:()=>Tc,hydrateOnIdle:()=>di,hydrateOnInteraction:()=>pi,hydrateOnMediaQuery:()=>ui,hydrateOnVisible:()=>hi,initCustomFormatter:()=>Ea,initDirectivesForSSR:()=>Ic,inject:()=>or,isMemoSame:()=>Da,isProxy:()=>Wt,isReactive:()=>Ft,isReadonly:()=>Vt,isRef:()=>Ut,isRuntimeOnly:()=>ba,isShallow:()=>zt,isVNode:()=>Fs,markRaw:()=>Ht,mergeDefaults:()=>fo,mergeModels:()=>go,mergeProps:()=>ta,nextTick:()=>Qn,nodeOps:()=>Ua,normalizeClass:()=>X,normalizeProps:()=>J,normalizeStyle:()=>j,onActivated:()=>xi,onBeforeMount:()=>Ti,onBeforeUnmount:()=>Pi,onBeforeUpdate:()=>Mi,onDeactivated:()=>wi,onErrorCaptured:()=>Qi,onMounted:()=>Ei,onRenderTracked:()=>Li,onRenderTriggered:()=>Ni,onScopeDispose:()=>we,onServerPrefetch:()=>Ii,onUnmounted:()=>Ri,onUpdated:()=>Di,onWatcherCleanup:()=>An,openBlock:()=>Ms,patchProp:()=>Ll,popScopeId:()=>Zn,provide:()=>ir,proxyRefs:()=>nn,pushScopeId:()=>Kn,queuePostFlushCb:()=>zn,reactive:()=>Rt,readonly:()=>Nt,ref:()=>Gt,registerRuntimeCompiler:()=>Aa,render:()=>_c,renderList:()=>qi,renderSlot:()=>Gi,resolveComponent:()=>Vi,resolveDirective:()=>$i,resolveDynamicComponent:()=>Wi,resolveFilter:()=>Fa,resolveTransitionHooks:()=>Qr,setBlockTracking:()=>Is,setDevtoolsHook:()=>La,setTransitionHooks:()=>zr,shallowReactive:()=>It,shallowReadonly:()=>Lt,shallowRef:()=>Yt,ssrContextKey:()=>ar,ssrUtils:()=>Qa,stop:()=>Qe,toDisplayString:()=>pe,toHandlerKey:()=>N,toHandlers:()=>Xi,toRaw:()=>$t,toRef:()=>cn,toRefs:()=>sn,toValue:()=>en,transformVNodeArgs:()=>zs,triggerRef:()=>Kt,unref:()=>Zt,useAttrs:()=>ho,useCssModule:()=>jl,useCssVars:()=>bl,useHost:()=>$l,useId:()=>Hr,useModel:()=>Ro,useSSRContext:()=>lr,useShadowRoot:()=>Hl,useSlots:()=>co,useTemplateRef:()=>qr,useTransitionState:()=>Er,vModelCheckbox:()=>lc,vModelDynamic:()=>gc,vModelRadio:()=>dc,vModelSelect:()=>hc,vModelText:()=>ac,vShow:()=>ml,version:()=>Pa,warn:()=>Ra,watch:()=>ur,watchEffect:()=>cr,watchPostEffect:()=>dr,watchSyncEffect:()=>hr,withAsyncContext:()=>vo,withCtx:()=>tr,withDefaults:()=>lo,withDirectives:()=>nr,withKeys:()=>wc,withMemo:()=>Ma,withModifiers:()=>yc,withScopeId:()=>er});const o={},s=[],a=()=>{},l=()=>!1,c=e=>111===e.charCodeAt(0)&&110===e.charCodeAt(1)&&(e.charCodeAt(2)>122||e.charCodeAt(2)<97),d=e=>e.startsWith("onUpdate:"),h=Object.assign,u=(e,t)=>{const n=e.indexOf(t);n>-1&&e.splice(n,1)},p=Object.prototype.hasOwnProperty,f=(e,t)=>p.call(e,t),g=Array.isArray,m=e=>"[object Map]"===S(e),v=e=>"[object Set]"===S(e),A=e=>"[object Date]"===S(e),b=e=>"function"==typeof e,y=e=>"string"==typeof e,x=e=>"symbol"==typeof e,w=e=>null!==e&&"object"==typeof e,C=e=>(w(e)||b(e))&&b(e.then)&&b(e.catch),k=Object.prototype.toString,S=e=>k.call(e),O=e=>"[object Object]"===S(e),B=e=>y(e)&&"NaN"!==e&&"-"!==e[0]&&""+parseInt(e,10)===e,_=i(",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"),T=i("bind,cloak,else-if,else,for,html,if,model,on,once,pre,show,slot,text,memo"),E=e=>{const t=Object.create(null);return n=>t[n]||(t[n]=e(n))},M=/-\w/g,D=E(e=>e.replace(M,e=>e.slice(1).toUpperCase())),P=/\B([A-Z])/g,R=E(e=>e.replace(P,"-$1").toLowerCase()),I=E(e=>e.charAt(0).toUpperCase()+e.slice(1)),N=E(e=>e?`on${I(e)}`:""),L=(e,t)=>!Object.is(e,t),Q=(e,...t)=>{for(let n=0;n<e.length;n++)e[n](...t)},F=(e,t,n,r=!1)=>{Object.defineProperty(e,t,{configurable:!0,enumerable:!1,writable:r,value:n})},V=e=>{const t=parseFloat(e);return isNaN(t)?e:t},z=e=>{const t=y(e)?Number(e):NaN;return isNaN(t)?e:t};let W;const $=()=>W||(W="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self?self:"undefined"!=typeof window?window:void 0!==n.g?n.g:{});const H=i("Infinity,undefined,NaN,isFinite,isNaN,parseFloat,parseInt,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,Math,Number,Date,Array,Object,Boolean,String,RegExp,Map,Set,JSON,Intl,BigInt,console,Error,Symbol");function j(e){if(g(e)){const t={};for(let n=0;n<e.length;n++){const r=e[n],i=y(r)?Y(r):j(r);if(i)for(const e in i)t[e]=i[e]}return t}if(y(e)||w(e))return e}const q=/;(?![^(]*\))/g,U=/:([^]+)/,G=/\/\*[^]*?\*\//g;function Y(e){const t={};return e.replace(G,"").split(q).forEach(e=>{if(e){const n=e.split(U);n.length>1&&(t[n[0].trim()]=n[1].trim())}}),t}function X(e){let t="";if(y(e))t=e;else if(g(e))for(let n=0;n<e.length;n++){const r=X(e[n]);r&&(t+=r+" ")}else if(w(e))for(const n in e)e[n]&&(t+=n+" ");return t.trim()}function J(e){if(!e)return null;let{class:t,style:n}=e;return t&&!y(t)&&(e.class=X(t)),n&&(e.style=j(n)),e}const K=i("html,body,base,head,link,meta,style,title,address,article,aside,footer,header,hgroup,h1,h2,h3,h4,h5,h6,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,summary,template,blockquote,iframe,tfoot"),Z=i("svg,animate,animateMotion,animateTransform,circle,clipPath,color-profile,defs,desc,discard,ellipse,feBlend,feColorMatrix,feComponentTransfer,feComposite,feConvolveMatrix,feDiffuseLighting,feDisplacementMap,feDistantLight,feDropShadow,feFlood,feFuncA,feFuncB,feFuncG,feFuncR,feGaussianBlur,feImage,feMerge,feMergeNode,feMorphology,feOffset,fePointLight,feSpecularLighting,feSpotLight,feTile,feTurbulence,filter,foreignObject,g,hatch,hatchpath,image,line,linearGradient,marker,mask,mesh,meshgradient,meshpatch,meshrow,metadata,mpath,path,pattern,polygon,polyline,radialGradient,rect,set,solidcolor,stop,switch,symbol,text,textPath,title,tspan,unknown,use,view"),ee=i("annotation,annotation-xml,maction,maligngroup,malignmark,math,menclose,merror,mfenced,mfrac,mfraction,mglyph,mi,mlabeledtr,mlongdiv,mmultiscripts,mn,mo,mover,mpadded,mphantom,mprescripts,mroot,mrow,ms,mscarries,mscarry,msgroup,msline,mspace,msqrt,msrow,mstack,mstyle,msub,msubsup,msup,mtable,mtd,mtext,mtr,munder,munderover,none,semantics"),te=i("area,base,br,col,embed,hr,img,input,link,meta,param,source,track,wbr"),ne="itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly",re=i(ne),ie=i(ne+",async,autofocus,autoplay,controls,default,defer,disabled,hidden,inert,loop,open,required,reversed,scoped,seamless,checked,muted,multiple,selected");function oe(e){return!!e||""===e}const se=i("accept,accept-charset,accesskey,action,align,allow,alt,async,autocapitalize,autocomplete,autofocus,autoplay,background,bgcolor,border,buffered,capture,challenge,charset,checked,cite,class,code,codebase,color,cols,colspan,content,contenteditable,contextmenu,controls,coords,crossorigin,csp,data,datetime,decoding,default,defer,dir,dirname,disabled,download,draggable,dropzone,enctype,enterkeyhint,for,form,formaction,formenctype,formmethod,formnovalidate,formtarget,headers,height,hidden,high,href,hreflang,http-equiv,icon,id,importance,inert,integrity,ismap,itemprop,keytype,kind,label,lang,language,loading,list,loop,low,manifest,max,maxlength,minlength,media,min,multiple,muted,name,novalidate,open,optimum,pattern,ping,placeholder,poster,preload,radiogroup,readonly,referrerpolicy,rel,required,reversed,rows,rowspan,sandbox,scope,scoped,selected,shape,size,sizes,slot,span,spellcheck,src,srcdoc,srclang,srcset,start,step,style,summary,tabindex,target,title,translate,type,usemap,value,width,wrap"),ae=i("xmlns,accent-height,accumulate,additive,alignment-baseline,alphabetic,amplitude,arabic-form,ascent,attributeName,attributeType,azimuth,baseFrequency,baseline-shift,baseProfile,bbox,begin,bias,by,calcMode,cap-height,class,clip,clipPathUnits,clip-path,clip-rule,color,color-interpolation,color-interpolation-filters,color-profile,color-rendering,contentScriptType,contentStyleType,crossorigin,cursor,cx,cy,d,decelerate,descent,diffuseConstant,direction,display,divisor,dominant-baseline,dur,dx,dy,edgeMode,elevation,enable-background,end,exponent,fill,fill-opacity,fill-rule,filter,filterRes,filterUnits,flood-color,flood-opacity,font-family,font-size,font-size-adjust,font-stretch,font-style,font-variant,font-weight,format,from,fr,fx,fy,g1,g2,glyph-name,glyph-orientation-horizontal,glyph-orientation-vertical,glyphRef,gradientTransform,gradientUnits,hanging,height,href,hreflang,horiz-adv-x,horiz-origin-x,id,ideographic,image-rendering,in,in2,intercept,k,k1,k2,k3,k4,kernelMatrix,kernelUnitLength,kerning,keyPoints,keySplines,keyTimes,lang,lengthAdjust,letter-spacing,lighting-color,limitingConeAngle,local,marker-end,marker-mid,marker-start,markerHeight,markerUnits,markerWidth,mask,maskContentUnits,maskUnits,mathematical,max,media,method,min,mode,name,numOctaves,offset,opacity,operator,order,orient,orientation,origin,overflow,overline-position,overline-thickness,panose-1,paint-order,path,pathLength,patternContentUnits,patternTransform,patternUnits,ping,pointer-events,points,pointsAtX,pointsAtY,pointsAtZ,preserveAlpha,preserveAspectRatio,primitiveUnits,r,radius,referrerPolicy,refX,refY,rel,rendering-intent,repeatCount,repeatDur,requiredExtensions,requiredFeatures,restart,result,rotate,rx,ry,scale,seed,shape-rendering,slope,spacing,specularConstant,specularExponent,speed,spreadMethod,startOffset,stdDeviation,stemh,stemv,stitchTiles,stop-color,stop-opacity,strikethrough-position,strikethrough-thickness,string,stroke,stroke-dasharray,stroke-dashoffset,stroke-linecap,stroke-linejoin,stroke-miterlimit,stroke-opacity,stroke-width,style,surfaceScale,systemLanguage,tabindex,tableValues,target,targetX,targetY,text-anchor,text-decoration,text-rendering,textLength,to,transform,transform-origin,type,u1,u2,underline-position,underline-thickness,unicode,unicode-bidi,unicode-range,units-per-em,v-alphabetic,v-hanging,v-ideographic,v-mathematical,values,vector-effect,version,vert-adv-y,vert-origin-x,vert-origin-y,viewBox,viewTarget,visibility,width,widths,word-spacing,writing-mode,x,x-height,x1,x2,xChannelSelector,xlink:actuate,xlink:arcrole,xlink:href,xlink:role,xlink:show,xlink:title,xlink:type,xmlns:xlink,xml:base,xml:lang,xml:space,y,y1,y2,yChannelSelector,z,zoomAndPan");const le=/[ !"#$%&'()*+,./:;<=>?@[\\\]^`{|}~]/g;function ce(e,t){return e.replace(le,e=>t?'"'===e?'\\\\\\"':`\\\\${e}`:`\\${e}`)}function de(e,t){if(e===t)return!0;let n=A(e),r=A(t);if(n||r)return!(!n||!r)&&e.getTime()===t.getTime();if(n=x(e),r=x(t),n||r)return e===t;if(n=g(e),r=g(t),n||r)return!(!n||!r)&&function(e,t){if(e.length!==t.length)return!1;let n=!0;for(let r=0;n&&r<e.length;r++)n=de(e[r],t[r]);return n}(e,t);if(n=w(e),r=w(t),n||r){if(!n||!r)return!1;if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const n in e){const r=e.hasOwnProperty(n),i=t.hasOwnProperty(n);if(r&&!i||!r&&i||!de(e[n],t[n]))return!1}}return String(e)===String(t)}function he(e,t){return e.findIndex(e=>de(e,t))}const ue=e=>!(!e||!0!==e.__v_isRef),pe=e=>y(e)?e:null==e?"":g(e)||w(e)&&(e.toString===k||!b(e.toString))?ue(e)?pe(e.value):JSON.stringify(e,fe,2):String(e),fe=(e,t)=>ue(t)?fe(e,t.value):m(t)?{[`Map(${t.size})`]:[...t.entries()].reduce((e,[t,n],r)=>(e[ge(t,r)+" =>"]=n,e),{})}:v(t)?{[`Set(${t.size})`]:[...t.values()].map(e=>ge(e))}:x(t)?ge(t):!w(t)||g(t)||O(t)?t:String(t),ge=(e,t="")=>{var n;return x(e)?`Symbol(${null!=(n=e.description)?n:t})`:e};function me(e){return null==e?"initial":"string"==typeof e?""===e?" ":e:("number"==typeof e&&Number.isFinite(e),String(e))}let ve,Ae;class be{constructor(e=!1){this.detached=e,this._active=!0,this._on=0,this.effects=[],this.cleanups=[],this._isPaused=!1,this.parent=ve,!e&&ve&&(this.index=(ve.scopes||(ve.scopes=[])).push(this)-1)}get active(){return this._active}pause(){if(this._active){let e,t;if(this._isPaused=!0,this.scopes)for(e=0,t=this.scopes.length;e<t;e++)this.scopes[e].pause();for(e=0,t=this.effects.length;e<t;e++)this.effects[e].pause()}}resume(){if(this._active&&this._isPaused){let e,t;if(this._isPaused=!1,this.scopes)for(e=0,t=this.scopes.length;e<t;e++)this.scopes[e].resume();for(e=0,t=this.effects.length;e<t;e++)this.effects[e].resume()}}run(e){if(this._active){const t=ve;try{return ve=this,e()}finally{ve=t}}else 0}on(){1===++this._on&&(this.prevScope=ve,ve=this)}off(){this._on>0&&0===--this._on&&(ve=this.prevScope,this.prevScope=void 0)}stop(e){if(this._active){let t,n;for(this._active=!1,t=0,n=this.effects.length;t<n;t++)this.effects[t].stop();for(this.effects.length=0,t=0,n=this.cleanups.length;t<n;t++)this.cleanups[t]();if(this.cleanups.length=0,this.scopes){for(t=0,n=this.scopes.length;t<n;t++)this.scopes[t].stop(!0);this.scopes.length=0}if(!this.detached&&this.parent&&!e){const e=this.parent.scopes.pop();e&&e!==this&&(this.parent.scopes[this.index]=e,e.index=this.index)}this.parent=void 0}}}function ye(e){return new be(e)}function xe(){return ve}function we(e,t=!1){ve&&ve.cleanups.push(e)}const Ce=new WeakSet;class ke{constructor(e){this.fn=e,this.deps=void 0,this.depsTail=void 0,this.flags=5,this.next=void 0,this.cleanup=void 0,this.scheduler=void 0,ve&&ve.active&&ve.effects.push(this)}pause(){this.flags|=64}resume(){64&this.flags&&(this.flags&=-65,Ce.has(this)&&(Ce.delete(this),this.trigger()))}notify(){2&this.flags&&!(32&this.flags)||8&this.flags||_e(this)}run(){if(!(1&this.flags))return this.fn();this.flags|=2,$e(this),Me(this);const e=Ae,t=Fe;Ae=this,Fe=!0;try{return this.fn()}finally{0,De(this),Ae=e,Fe=t,this.flags&=-3}}stop(){if(1&this.flags){for(let e=this.deps;e;e=e.nextDep)Ie(e);this.deps=this.depsTail=void 0,$e(this),this.onStop&&this.onStop(),this.flags&=-2}}trigger(){64&this.flags?Ce.add(this):this.scheduler?this.scheduler():this.runIfDirty()}runIfDirty(){Pe(this)&&this.run()}get dirty(){return Pe(this)}}let Se,Oe,Be=0;function _e(e,t=!1){if(e.flags|=8,t)return e.next=Oe,void(Oe=e);e.next=Se,Se=e}function Te(){Be++}function Ee(){if(--Be>0)return;if(Oe){let e=Oe;for(Oe=void 0;e;){const t=e.next;e.next=void 0,e.flags&=-9,e=t}}let e;for(;Se;){let t=Se;for(Se=void 0;t;){const n=t.next;if(t.next=void 0,t.flags&=-9,1&t.flags)try{t.trigger()}catch(t){e||(e=t)}t=n}}if(e)throw e}function Me(e){for(let t=e.deps;t;t=t.nextDep)t.version=-1,t.prevActiveLink=t.dep.activeLink,t.dep.activeLink=t}function De(e){let t,n=e.depsTail,r=n;for(;r;){const e=r.prevDep;-1===r.version?(r===n&&(n=e),Ie(r),Ne(r)):t=r,r.dep.activeLink=r.prevActiveLink,r.prevActiveLink=void 0,r=e}e.deps=t,e.depsTail=n}function Pe(e){for(let t=e.deps;t;t=t.nextDep)if(t.dep.version!==t.version||t.dep.computed&&(Re(t.dep.computed)||t.dep.version!==t.version))return!0;return!!e._dirty}function Re(e){if(4&e.flags&&!(16&e.flags))return;if(e.flags&=-17,e.globalVersion===He)return;if(e.globalVersion=He,!e.isSSR&&128&e.flags&&(!e.deps&&!e._dirty||!Pe(e)))return;e.flags|=2;const t=e.dep,n=Ae,r=Fe;Ae=e,Fe=!0;try{Me(e);const n=e.fn(e._value);(0===t.version||L(n,e._value))&&(e.flags|=128,e._value=n,t.version++)}catch(e){throw t.version++,e}finally{Ae=n,Fe=r,De(e),e.flags&=-3}}function Ie(e,t=!1){const{dep:n,prevSub:r,nextSub:i}=e;if(r&&(r.nextSub=i,e.prevSub=void 0),i&&(i.prevSub=r,e.nextSub=void 0),n.subs===e&&(n.subs=r,!r&&n.computed)){n.computed.flags&=-5;for(let e=n.computed.deps;e;e=e.nextDep)Ie(e,!0)}t||--n.sc||!n.map||n.map.delete(n.key)}function Ne(e){const{prevDep:t,nextDep:n}=e;t&&(t.nextDep=n,e.prevDep=void 0),n&&(n.prevDep=t,e.nextDep=void 0)}function Le(e,t){e.effect instanceof ke&&(e=e.effect.fn);const n=new ke(e);t&&h(n,t);try{n.run()}catch(e){throw n.stop(),e}const r=n.run.bind(n);return r.effect=n,r}function Qe(e){e.effect.stop()}let Fe=!0;const Ve=[];function ze(){Ve.push(Fe),Fe=!1}function We(){const e=Ve.pop();Fe=void 0===e||e}function $e(e){const{cleanup:t}=e;if(e.cleanup=void 0,t){const e=Ae;Ae=void 0;try{t()}finally{Ae=e}}}let He=0;class je{constructor(e,t){this.sub=e,this.dep=t,this.version=t.version,this.nextDep=this.prevDep=this.nextSub=this.prevSub=this.prevActiveLink=void 0}}class qe{constructor(e){this.computed=e,this.version=0,this.activeLink=void 0,this.subs=void 0,this.map=void 0,this.key=void 0,this.sc=0,this.__v_skip=!0}track(e){if(!Ae||!Fe||Ae===this.computed)return;let t=this.activeLink;if(void 0===t||t.sub!==Ae)t=this.activeLink=new je(Ae,this),Ae.deps?(t.prevDep=Ae.depsTail,Ae.depsTail.nextDep=t,Ae.depsTail=t):Ae.deps=Ae.depsTail=t,Ue(t);else if(-1===t.version&&(t.version=this.version,t.nextDep)){const e=t.nextDep;e.prevDep=t.prevDep,t.prevDep&&(t.prevDep.nextDep=e),t.prevDep=Ae.depsTail,t.nextDep=void 0,Ae.depsTail.nextDep=t,Ae.depsTail=t,Ae.deps===t&&(Ae.deps=e)}return t}trigger(e){this.version++,He++,this.notify(e)}notify(e){Te();try{0;for(let e=this.subs;e;e=e.prevSub)e.sub.notify()&&e.sub.dep.notify()}finally{Ee()}}}function Ue(e){if(e.dep.sc++,4&e.sub.flags){const t=e.dep.computed;if(t&&!e.dep.subs){t.flags|=20;for(let e=t.deps;e;e=e.nextDep)Ue(e)}const n=e.dep.subs;n!==e&&(e.prevSub=n,n&&(n.nextSub=e)),e.dep.subs=e}}const Ge=new WeakMap,Ye=Symbol(""),Xe=Symbol(""),Je=Symbol("");function Ke(e,t,n){if(Fe&&Ae){let t=Ge.get(e);t||Ge.set(e,t=new Map);let r=t.get(n);r||(t.set(n,r=new qe),r.map=t,r.key=n),r.track()}}function Ze(e,t,n,r,i,o){const s=Ge.get(e);if(!s)return void He++;const a=e=>{e&&e.trigger()};if(Te(),"clear"===t)s.forEach(a);else{const i=g(e),o=i&&B(n);if(i&&"length"===n){const e=Number(r);s.forEach((t,n)=>{("length"===n||n===Je||!x(n)&&n>=e)&&a(t)})}else switch((void 0!==n||s.has(void 0))&&a(s.get(n)),o&&a(s.get(Je)),t){case"add":i?o&&a(s.get("length")):(a(s.get(Ye)),m(e)&&a(s.get(Xe)));break;case"delete":i||(a(s.get(Ye)),m(e)&&a(s.get(Xe)));break;case"set":m(e)&&a(s.get(Ye))}}Ee()}function et(e){const t=$t(e);return t===e?t:(Ke(t,0,Je),zt(e)?t:t.map(jt))}function tt(e){return Ke(e=$t(e),0,Je),e}function nt(e,t){return Vt(e)?Ft(e)?qt(jt(t)):qt(t):jt(t)}const rt={__proto__:null,[Symbol.iterator](){return it(this,Symbol.iterator,e=>nt(this,e))},concat(...e){return et(this).concat(...e.map(e=>g(e)?et(e):e))},entries(){return it(this,"entries",e=>(e[1]=nt(this,e[1]),e))},every(e,t){return st(this,"every",e,t,void 0,arguments)},filter(e,t){return st(this,"filter",e,t,e=>e.map(e=>nt(this,e)),arguments)},find(e,t){return st(this,"find",e,t,e=>nt(this,e),arguments)},findIndex(e,t){return st(this,"findIndex",e,t,void 0,arguments)},findLast(e,t){return st(this,"findLast",e,t,e=>nt(this,e),arguments)},findLastIndex(e,t){return st(this,"findLastIndex",e,t,void 0,arguments)},forEach(e,t){return st(this,"forEach",e,t,void 0,arguments)},includes(...e){return lt(this,"includes",e)},indexOf(...e){return lt(this,"indexOf",e)},join(e){return et(this).join(e)},lastIndexOf(...e){return lt(this,"lastIndexOf",e)},map(e,t){return st(this,"map",e,t,void 0,arguments)},pop(){return ct(this,"pop")},push(...e){return ct(this,"push",e)},reduce(e,...t){return at(this,"reduce",e,t)},reduceRight(e,...t){return at(this,"reduceRight",e,t)},shift(){return ct(this,"shift")},some(e,t){return st(this,"some",e,t,void 0,arguments)},splice(...e){return ct(this,"splice",e)},toReversed(){return et(this).toReversed()},toSorted(e){return et(this).toSorted(e)},toSpliced(...e){return et(this).toSpliced(...e)},unshift(...e){return ct(this,"unshift",e)},values(){return it(this,"values",e=>nt(this,e))}};function it(e,t,n){const r=tt(e),i=r[t]();return r===e||zt(e)||(i._next=i.next,i.next=()=>{const e=i._next();return e.done||(e.value=n(e.value)),e}),i}const ot=Array.prototype;function st(e,t,n,r,i,o){const s=tt(e),a=s!==e&&!zt(e),l=s[t];if(l!==ot[t]){const t=l.apply(e,o);return a?jt(t):t}let c=n;s!==e&&(a?c=function(t,r){return n.call(this,nt(e,t),r,e)}:n.length>2&&(c=function(t,r){return n.call(this,t,r,e)}));const d=l.call(s,c,r);return a&&i?i(d):d}function at(e,t,n,r){const i=tt(e);let o=n;return i!==e&&(zt(e)?n.length>3&&(o=function(t,r,i){return n.call(this,t,r,i,e)}):o=function(t,r,i){return n.call(this,t,nt(e,r),i,e)}),i[t](o,...r)}function lt(e,t,n){const r=$t(e);Ke(r,0,Je);const i=r[t](...n);return-1!==i&&!1!==i||!Wt(n[0])?i:(n[0]=$t(n[0]),r[t](...n))}function ct(e,t,n=[]){ze(),Te();const r=$t(e)[t].apply(e,n);return Ee(),We(),r}const dt=i("__proto__,__v_isRef,__isVue"),ht=new Set(Object.getOwnPropertyNames(Symbol).filter(e=>"arguments"!==e&&"caller"!==e).map(e=>Symbol[e]).filter(x));function ut(e){x(e)||(e=String(e));const t=$t(this);return Ke(t,0,e),t.hasOwnProperty(e)}class pt{constructor(e=!1,t=!1){this._isReadonly=e,this._isShallow=t}get(e,t,n){if("__v_skip"===t)return e.__v_skip;const r=this._isReadonly,i=this._isShallow;if("__v_isReactive"===t)return!r;if("__v_isReadonly"===t)return r;if("__v_isShallow"===t)return i;if("__v_raw"===t)return n===(r?i?Dt:Mt:i?Et:Tt).get(e)||Object.getPrototypeOf(e)===Object.getPrototypeOf(n)?e:void 0;const o=g(e);if(!r){let e;if(o&&(e=rt[t]))return e;if("hasOwnProperty"===t)return ut}const s=Reflect.get(e,t,Ut(e)?e:n);if(x(t)?ht.has(t):dt(t))return s;if(r||Ke(e,0,t),i)return s;if(Ut(s)){const e=o&&B(t)?s:s.value;return r&&w(e)?Nt(e):e}return w(s)?r?Nt(s):Rt(s):s}}class ft extends pt{constructor(e=!1){super(!1,e)}set(e,t,n,r){let i=e[t];const o=g(e)&&B(t);if(!this._isShallow){const e=Vt(i);if(zt(n)||Vt(n)||(i=$t(i),n=$t(n)),!o&&Ut(i)&&!Ut(n))return e||(i.value=n),!0}const s=o?Number(t)<e.length:f(e,t),a=Reflect.set(e,t,n,Ut(e)?e:r);return e===$t(r)&&(s?L(n,i)&&Ze(e,"set",t,n):Ze(e,"add",t,n)),a}deleteProperty(e,t){const n=f(e,t),r=(e[t],Reflect.deleteProperty(e,t));return r&&n&&Ze(e,"delete",t,void 0),r}has(e,t){const n=Reflect.has(e,t);return x(t)&&ht.has(t)||Ke(e,0,t),n}ownKeys(e){return Ke(e,0,g(e)?"length":Ye),Reflect.ownKeys(e)}}class gt extends pt{constructor(e=!1){super(!0,e)}set(e,t){return!0}deleteProperty(e,t){return!0}}const mt=new ft,vt=new gt,At=new ft(!0),bt=new gt(!0),yt=e=>e,xt=e=>Reflect.getPrototypeOf(e);function wt(e){return function(...t){return"delete"!==e&&("clear"===e?void 0:this)}}function Ct(e,t){const n={get(n){const r=this.__v_raw,i=$t(r),o=$t(n);e||(L(n,o)&&Ke(i,0,n),Ke(i,0,o));const{has:s}=xt(i),a=t?yt:e?qt:jt;return s.call(i,n)?a(r.get(n)):s.call(i,o)?a(r.get(o)):void(r!==i&&r.get(n))},get size(){const t=this.__v_raw;return!e&&Ke($t(t),0,Ye),t.size},has(t){const n=this.__v_raw,r=$t(n),i=$t(t);return e||(L(t,i)&&Ke(r,0,t),Ke(r,0,i)),t===i?n.has(t):n.has(t)||n.has(i)},forEach(n,r){const i=this,o=i.__v_raw,s=$t(o),a=t?yt:e?qt:jt;return!e&&Ke(s,0,Ye),o.forEach((e,t)=>n.call(r,a(e),a(t),i))}};h(n,e?{add:wt("add"),set:wt("set"),delete:wt("delete"),clear:wt("clear")}:{add(e){t||zt(e)||Vt(e)||(e=$t(e));const n=$t(this);return xt(n).has.call(n,e)||(n.add(e),Ze(n,"add",e,e)),this},set(e,n){t||zt(n)||Vt(n)||(n=$t(n));const r=$t(this),{has:i,get:o}=xt(r);let s=i.call(r,e);s||(e=$t(e),s=i.call(r,e));const a=o.call(r,e);return r.set(e,n),s?L(n,a)&&Ze(r,"set",e,n):Ze(r,"add",e,n),this},delete(e){const t=$t(this),{has:n,get:r}=xt(t);let i=n.call(t,e);i||(e=$t(e),i=n.call(t,e));r&&r.call(t,e);const o=t.delete(e);return i&&Ze(t,"delete",e,void 0),o},clear(){const e=$t(this),t=0!==e.size,n=e.clear();return t&&Ze(e,"clear",void 0,void 0),n}});return["keys","values","entries",Symbol.iterator].forEach(r=>{n[r]=function(e,t,n){return function(...r){const i=this.__v_raw,o=$t(i),s=m(o),a="entries"===e||e===Symbol.iterator&&s,l="keys"===e&&s,c=i[e](...r),d=n?yt:t?qt:jt;return!t&&Ke(o,0,l?Xe:Ye),h(Object.create(c),{next(){const{value:e,done:t}=c.next();return t?{value:e,done:t}:{value:a?[d(e[0]),d(e[1])]:d(e),done:t}}})}}(r,e,t)}),n}function kt(e,t){const n=Ct(e,t);return(t,r,i)=>"__v_isReactive"===r?!e:"__v_isReadonly"===r?e:"__v_raw"===r?t:Reflect.get(f(n,r)&&r in t?n:t,r,i)}const St={get:kt(!1,!1)},Ot={get:kt(!1,!0)},Bt={get:kt(!0,!1)},_t={get:kt(!0,!0)};const Tt=new WeakMap,Et=new WeakMap,Mt=new WeakMap,Dt=new WeakMap;function Pt(e){return e.__v_skip||!Object.isExtensible(e)?0:function(e){switch(e){case"Object":case"Array":return 1;case"Map":case"Set":case"WeakMap":case"WeakSet":return 2;default:return 0}}((e=>S(e).slice(8,-1))(e))}function Rt(e){return Vt(e)?e:Qt(e,!1,mt,St,Tt)}function It(e){return Qt(e,!1,At,Ot,Et)}function Nt(e){return Qt(e,!0,vt,Bt,Mt)}function Lt(e){return Qt(e,!0,bt,_t,Dt)}function Qt(e,t,n,r,i){if(!w(e))return e;if(e.__v_raw&&(!t||!e.__v_isReactive))return e;const o=Pt(e);if(0===o)return e;const s=i.get(e);if(s)return s;const a=new Proxy(e,2===o?r:n);return i.set(e,a),a}function Ft(e){return Vt(e)?Ft(e.__v_raw):!(!e||!e.__v_isReactive)}function Vt(e){return!(!e||!e.__v_isReadonly)}function zt(e){return!(!e||!e.__v_isShallow)}function Wt(e){return!!e&&!!e.__v_raw}function $t(e){const t=e&&e.__v_raw;return t?$t(t):e}function Ht(e){return!f(e,"__v_skip")&&Object.isExtensible(e)&&F(e,"__v_skip",!0),e}const jt=e=>w(e)?Rt(e):e,qt=e=>w(e)?Nt(e):e;function Ut(e){return!!e&&!0===e.__v_isRef}function Gt(e){return Xt(e,!1)}function Yt(e){return Xt(e,!0)}function Xt(e,t){return Ut(e)?e:new Jt(e,t)}class Jt{constructor(e,t){this.dep=new qe,this.__v_isRef=!0,this.__v_isShallow=!1,this._rawValue=t?e:$t(e),this._value=t?e:jt(e),this.__v_isShallow=t}get value(){return this.dep.track(),this._value}set value(e){const t=this._rawValue,n=this.__v_isShallow||zt(e)||Vt(e);e=n?e:$t(e),L(e,t)&&(this._rawValue=e,this._value=n?e:jt(e),this.dep.trigger())}}function Kt(e){e.dep&&e.dep.trigger()}function Zt(e){return Ut(e)?e.value:e}function en(e){return b(e)?e():Zt(e)}const tn={get:(e,t,n)=>"__v_raw"===t?e:Zt(Reflect.get(e,t,n)),set:(e,t,n,r)=>{const i=e[t];return Ut(i)&&!Ut(n)?(i.value=n,!0):Reflect.set(e,t,n,r)}};function nn(e){return Ft(e)?e:new Proxy(e,tn)}class rn{constructor(e){this.__v_isRef=!0,this._value=void 0;const t=this.dep=new qe,{get:n,set:r}=e(t.track.bind(t),t.trigger.bind(t));this._get=n,this._set=r}get value(){return this._value=this._get()}set value(e){this._set(e)}}function on(e){return new rn(e)}function sn(e){const t=g(e)?new Array(e.length):{};for(const n in e)t[n]=dn(e,n);return t}class an{constructor(e,t,n){this._object=e,this._key=t,this._defaultValue=n,this.__v_isRef=!0,this._value=void 0,this._raw=$t(e);let r=!0,i=e;if(!g(e)||!B(String(t)))do{r=!Wt(i)||zt(i)}while(r&&(i=i.__v_raw));this._shallow=r}get value(){let e=this._object[this._key];return this._shallow&&(e=Zt(e)),this._value=void 0===e?this._defaultValue:e}set value(e){if(this._shallow&&Ut(this._raw[this._key])){const t=this._object[this._key];if(Ut(t))return void(t.value=e)}this._object[this._key]=e}get dep(){return function(e,t){const n=Ge.get(e);return n&&n.get(t)}(this._raw,this._key)}}class ln{constructor(e){this._getter=e,this.__v_isRef=!0,this.__v_isReadonly=!0,this._value=void 0}get value(){return this._value=this._getter()}}function cn(e,t,n){return Ut(e)?e:b(e)?new ln(e):w(e)&&arguments.length>1?dn(e,t,n):Gt(e)}function dn(e,t,n){return new an(e,t,n)}class hn{constructor(e,t,n){this.fn=e,this.setter=t,this._value=void 0,this.dep=new qe(this),this.__v_isRef=!0,this.deps=void 0,this.depsTail=void 0,this.flags=16,this.globalVersion=He-1,this.next=void 0,this.effect=this,this.__v_isReadonly=!t,this.isSSR=n}notify(){if(this.flags|=16,!(8&this.flags||Ae===this))return _e(this,!0),!0}get value(){const e=this.dep.track();return Re(this),e&&(e.version=this.dep.version),this._value}set value(e){this.setter&&this.setter(e)}}const un={GET:"get",HAS:"has",ITERATE:"iterate"},pn={SET:"set",ADD:"add",DELETE:"delete",CLEAR:"clear"},fn={},gn=new WeakMap;let mn;function vn(){return mn}function An(e,t=!1,n=mn){if(n){let t=gn.get(n);t||gn.set(n,t=[]),t.push(e)}else 0}function bn(e,t=1/0,n){if(t<=0||!w(e)||e.__v_skip)return e;if(((n=n||new Map).get(e)||0)>=t)return e;if(n.set(e,t),t--,Ut(e))bn(e.value,t,n);else if(g(e))for(let r=0;r<e.length;r++)bn(e[r],t,n);else if(v(e)||m(e))e.forEach(e=>{bn(e,t,n)});else if(O(e)){for(const r in e)bn(e[r],t,n);for(const r of Object.getOwnPropertySymbols(e))Object.prototype.propertyIsEnumerable.call(e,r)&&bn(e[r],t,n)}return e}const yn=[];let xn=!1;function wn(e,...t){if(xn)return;xn=!0,ze();const n=yn.length?yn[yn.length-1].component:null,r=n&&n.appContext.config.warnHandler,i=function(){let e=yn[yn.length-1];if(!e)return[];const t=[];for(;e;){const n=t[0];n&&n.vnode===e?n.recurseCount++:t.push({vnode:e,recurseCount:0});const r=e.component&&e.component.parent;e=r&&r.vnode}return t}();if(r)_n(r,n,11,[e+t.map(e=>{var t,n;return null!=(n=null==(t=e.toString)?void 0:t.call(e))?n:JSON.stringify(e)}).join(""),n&&n.proxy,i.map(({vnode:e})=>`at <${Oa(n,e.type)}>`).join("\n"),i]);else{const n=[`[Vue warn]: ${e}`,...t];i.length&&n.push("\n",...function(e){const t=[];return e.forEach((e,n)=>{t.push(...0===n?[]:["\n"],...function({vnode:e,recurseCount:t}){const n=t>0?`... (${t} recursive calls)`:"",r=!!e.component&&null==e.component.parent,i=` at <${Oa(e.component,e.type,r)}`,o=">"+n;return e.props?[i,...Cn(e.props),o]:[i+o]}(e))}),t}(i)),console.warn(...n)}We(),xn=!1}function Cn(e){const t=[],n=Object.keys(e);return n.slice(0,3).forEach(n=>{t.push(...kn(n,e[n]))}),n.length>3&&t.push(" ..."),t}function kn(e,t,n){return y(t)?(t=JSON.stringify(t),n?t:[`${e}=${t}`]):"number"==typeof t||"boolean"==typeof t||null==t?n?t:[`${e}=${t}`]:Ut(t)?(t=kn(e,$t(t.value),!0),n?t:[`${e}=Ref<`,t,">"]):b(t)?[`${e}=fn${t.name?`<${t.name}>`:""}`]:(t=$t(t),n?t:[`${e}=`,t])}function Sn(e,t){}const On={SETUP_FUNCTION:0,0:"SETUP_FUNCTION",RENDER_FUNCTION:1,1:"RENDER_FUNCTION",NATIVE_EVENT_HANDLER:5,5:"NATIVE_EVENT_HANDLER",COMPONENT_EVENT_HANDLER:6,6:"COMPONENT_EVENT_HANDLER",VNODE_HOOK:7,7:"VNODE_HOOK",DIRECTIVE_HOOK:8,8:"DIRECTIVE_HOOK",TRANSITION_HOOK:9,9:"TRANSITION_HOOK",APP_ERROR_HANDLER:10,10:"APP_ERROR_HANDLER",APP_WARN_HANDLER:11,11:"APP_WARN_HANDLER",FUNCTION_REF:12,12:"FUNCTION_REF",ASYNC_COMPONENT_LOADER:13,13:"ASYNC_COMPONENT_LOADER",SCHEDULER:14,14:"SCHEDULER",COMPONENT_UPDATE:15,15:"COMPONENT_UPDATE",APP_UNMOUNT_CLEANUP:16,16:"APP_UNMOUNT_CLEANUP"},Bn={sp:"serverPrefetch hook",bc:"beforeCreate hook",c:"created hook",bm:"beforeMount hook",m:"mounted hook",bu:"beforeUpdate hook",u:"updated",bum:"beforeUnmount hook",um:"unmounted hook",a:"activated hook",da:"deactivated hook",ec:"errorCaptured hook",rtc:"renderTracked hook",rtg:"renderTriggered hook",0:"setup function",1:"render function",2:"watcher getter",3:"watcher callback",4:"watcher cleanup function",5:"native event handler",6:"component event handler",7:"vnode hook",8:"directive hook",9:"transition hook",10:"app errorHandler",11:"app warnHandler",12:"ref function",13:"async component loader",14:"scheduler flush",15:"component update",16:"app unmount cleanup function"};function _n(e,t,n,r){try{return r?e(...r):e()}catch(e){En(e,t,n)}}function Tn(e,t,n,r){if(b(e)){const i=_n(e,t,n,r);return i&&C(i)&&i.catch(e=>{En(e,t,n)}),i}if(g(e)){const i=[];for(let o=0;o<e.length;o++)i.push(Tn(e[o],t,n,r));return i}}function En(e,t,n,r=!0){t&&t.vnode;const{errorHandler:i,throwUnhandledErrorInProduction:s}=t&&t.appContext.config||o;if(t){let r=t.parent;const o=t.proxy,s=`https://vuejs.org/error-reference/#runtime-${n}`;for(;r;){const t=r.ec;if(t)for(let n=0;n<t.length;n++)if(!1===t[n](e,o,s))return;r=r.parent}if(i)return ze(),_n(i,null,10,[e,o,s]),void We()}!function(e,t,n,r=!0,i=!1){if(i)throw e;console.error(e)}(e,0,0,r,s)}const Mn=[];let Dn=-1;const Pn=[];let Rn=null,In=0;const Nn=Promise.resolve();let Ln=null;function Qn(e){const t=Ln||Nn;return e?t.then(this?e.bind(this):e):t}function Fn(e){if(!(1&e.flags)){const t=Hn(e),n=Mn[Mn.length-1];!n||!(2&e.flags)&&t>=Hn(n)?Mn.push(e):Mn.splice(function(e){let t=Dn+1,n=Mn.length;for(;t<n;){const r=t+n>>>1,i=Mn[r],o=Hn(i);o<e||o===e&&2&i.flags?t=r+1:n=r}return t}(t),0,e),e.flags|=1,Vn()}}function Vn(){Ln||(Ln=Nn.then(jn))}function zn(e){g(e)?Pn.push(...e):Rn&&-1===e.id?Rn.splice(In+1,0,e):1&e.flags||(Pn.push(e),e.flags|=1),Vn()}function Wn(e,t,n=Dn+1){for(0;n<Mn.length;n++){const t=Mn[n];if(t&&2&t.flags){if(e&&t.id!==e.uid)continue;0,Mn.splice(n,1),n--,4&t.flags&&(t.flags&=-2),t(),4&t.flags||(t.flags&=-2)}}}function $n(e){if(Pn.length){const e=[...new Set(Pn)].sort((e,t)=>Hn(e)-Hn(t));if(Pn.length=0,Rn)return void Rn.push(...e);for(Rn=e,In=0;In<Rn.length;In++){const e=Rn[In];0,4&e.flags&&(e.flags&=-2),8&e.flags||e(),e.flags&=-2}Rn=null,In=0}}const Hn=e=>null==e.id?2&e.flags?-1:1/0:e.id;function jn(e){try{for(Dn=0;Dn<Mn.length;Dn++){const e=Mn[Dn];!e||8&e.flags||(4&e.flags&&(e.flags&=-2),_n(e,e.i,e.i?15:14),4&e.flags||(e.flags&=-2))}}finally{for(;Dn<Mn.length;Dn++){const e=Mn[Dn];e&&(e.flags&=-2)}Dn=-1,Mn.length=0,$n(),Ln=null,(Mn.length||Pn.length)&&jn(e)}}let qn,Un=[],Gn=!1;let Yn=null,Xn=null;function Jn(e){const t=Yn;return Yn=e,Xn=e&&e.type.__scopeId||null,t}function Kn(e){Xn=e}function Zn(){Xn=null}const er=e=>tr;function tr(e,t=Yn,n){if(!t)return e;if(e._n)return e;const r=(...n)=>{r._d&&Is(-1);const i=Jn(t);let o;try{o=e(...n)}finally{Jn(i),r._d&&Is(1)}return o};return r._n=!0,r._c=!0,r._d=!0,r}function nr(e,t){if(null===Yn)return e;const n=Ca(Yn),r=e.dirs||(e.dirs=[]);for(let e=0;e<t.length;e++){let[i,s,a,l=o]=t[e];i&&(b(i)&&(i={mounted:i,updated:i}),i.deep&&bn(s),r.push({dir:i,instance:n,value:s,oldValue:void 0,arg:a,modifiers:l}))}return e}function rr(e,t,n,r){const i=e.dirs,o=t&&t.dirs;for(let s=0;s<i.length;s++){const a=i[s];o&&(a.oldValue=o[s].value);let l=a.dir[r];l&&(ze(),Tn(l,n,8,[e.el,a,e,t]),We())}}function ir(e,t){if(sa){let n=sa.provides;const r=sa.parent&&sa.parent.provides;r===n&&(n=sa.provides=Object.create(r)),n[e]=t}}function or(e,t,n=!1){const r=aa();if(r||Po){let i=Po?Po._context.provides:r?null==r.parent||r.ce?r.vnode.appContext&&r.vnode.appContext.provides:r.parent.provides:void 0;if(i&&e in i)return i[e];if(arguments.length>1)return n&&b(t)?t.call(r&&r.proxy):t}else 0}function sr(){return!(!aa()&&!Po)}const ar=Symbol.for("v-scx"),lr=()=>{{const e=or(ar);return e}};function cr(e,t){return pr(e,null,t)}function dr(e,t){return pr(e,null,{flush:"post"})}function hr(e,t){return pr(e,null,{flush:"sync"})}function ur(e,t,n){return pr(e,t,n)}function pr(e,t,n=o){const{immediate:r,deep:i,flush:s,once:l}=n;const c=h({},n);const d=t&&r||!t&&"post"!==s;let p;if(ga)if("sync"===s){const e=lr();p=e.__watcherHandles||(e.__watcherHandles=[])}else if(!d){const e=()=>{};return e.stop=a,e.resume=a,e.pause=a,e}const f=sa;c.call=(e,t,n)=>Tn(e,f,t,n);let m=!1;"post"===s?c.scheduler=e=>{ss(e,f&&f.suspense)}:"sync"!==s&&(m=!0,c.scheduler=(e,t)=>{t?e():Fn(e)}),c.augmentJob=e=>{t&&(e.flags|=4),m&&(e.flags|=2,f&&(e.id=f.uid,e.i=f))};const v=function(e,t,n=o){const{immediate:r,deep:i,once:s,scheduler:l,augmentJob:c,call:d}=n,h=e=>i?e:zt(e)||!1===i||0===i?bn(e,1):bn(e);let p,f,m,v,A=!1,y=!1;if(Ut(e)?(f=()=>e.value,A=zt(e)):Ft(e)?(f=()=>h(e),A=!0):g(e)?(y=!0,A=e.some(e=>Ft(e)||zt(e)),f=()=>e.map(e=>Ut(e)?e.value:Ft(e)?h(e):b(e)?d?d(e,2):e():void 0)):f=b(e)?t?d?()=>d(e,2):e:()=>{if(m){ze();try{m()}finally{We()}}const t=mn;mn=p;try{return d?d(e,3,[v]):e(v)}finally{mn=t}}:a,t&&i){const e=f,t=!0===i?1/0:i;f=()=>bn(e(),t)}const x=xe(),w=()=>{p.stop(),x&&x.active&&u(x.effects,p)};if(s&&t){const e=t;t=(...t)=>{e(...t),w()}}let C=y?new Array(e.length).fill(fn):fn;const k=e=>{if(1&p.flags&&(p.dirty||e))if(t){const e=p.run();if(i||A||(y?e.some((e,t)=>L(e,C[t])):L(e,C))){m&&m();const n=mn;mn=p;try{const n=[e,C===fn?void 0:y&&C[0]===fn?[]:C,v];C=e,d?d(t,3,n):t(...n)}finally{mn=n}}}else p.run()};return c&&c(k),p=new ke(f),p.scheduler=l?()=>l(k,!1):k,v=e=>An(e,!1,p),m=p.onStop=()=>{const e=gn.get(p);if(e){if(d)d(e,4);else for(const t of e)t();gn.delete(p)}},t?r?k(!0):C=p.run():l?l(k.bind(null,!0),!0):p.run(),w.pause=p.pause.bind(p),w.resume=p.resume.bind(p),w.stop=w,w}(e,t,c);return ga&&(p?p.push(v):d&&v()),v}function fr(e,t,n){const r=this.proxy,i=y(e)?e.includes(".")?gr(r,e):()=>r[e]:e.bind(r,r);let o;b(t)?o=t:(o=t.handler,n=t);const s=da(this),a=pr(i,o.bind(r),n);return s(),a}function gr(e,t){const n=t.split(".");return()=>{let t=e;for(let e=0;e<n.length&&t;e++)t=t[n[e]];return t}}const mr=Symbol("_vte"),vr=e=>e.__isTeleport,Ar=e=>e&&(e.disabled||""===e.disabled),br=e=>e&&(e.defer||""===e.defer),yr=e=>"undefined"!=typeof SVGElement&&e instanceof SVGElement,xr=e=>"function"==typeof MathMLElement&&e instanceof MathMLElement,wr=(e,t)=>{const n=e&&e.to;if(y(n)){if(t){return t(n)}return null}return n},Cr={name:"Teleport",__isTeleport:!0,process(e,t,n,r,i,o,s,a,l,c){const{mc:d,pc:h,pbc:u,o:{insert:p,querySelector:f,createText:g,createComment:m}}=c,v=Ar(t.props);let{shapeFlag:A,children:b,dynamicChildren:y}=t;if(null==e){const e=t.el=g(""),c=t.anchor=g("");p(e,n,r),p(c,n,r);const h=(e,t)=>{16&A&&d(b,e,t,i,o,s,a,l)},u=()=>{const e=t.target=wr(t.props,f),n=Br(e,t,g,p);e&&("svg"!==s&&yr(e)?s="svg":"mathml"!==s&&xr(e)&&(s="mathml"),i&&i.isCE&&(i.ce._teleportTargets||(i.ce._teleportTargets=new Set)).add(e),v||(h(e,n),Or(t,!1)))};v&&(h(n,c),Or(t,!0)),br(t.props)?(t.el.__isMounted=!1,ss(()=>{u(),delete t.el.__isMounted},o)):u()}else{if(br(t.props)&&!1===e.el.__isMounted)return void ss(()=>{Cr.process(e,t,n,r,i,o,s,a,l,c)},o);t.el=e.el,t.targetStart=e.targetStart;const d=t.anchor=e.anchor,p=t.target=e.target,g=t.targetAnchor=e.targetAnchor,m=Ar(e.props),A=m?n:p,b=m?d:g;if("svg"===s||yr(p)?s="svg":("mathml"===s||xr(p))&&(s="mathml"),y?(u(e.dynamicChildren,y,A,i,o,s,a),ps(e,t,!0)):l||h(e,t,A,b,i,o,s,a,!1),v)m?t.props&&e.props&&t.props.to!==e.props.to&&(t.props.to=e.props.to):kr(t,n,d,c,1);else if((t.props&&t.props.to)!==(e.props&&e.props.to)){const e=t.target=wr(t.props,f);e&&kr(t,e,null,c,0)}else m&&kr(t,p,g,c,1);Or(t,v)}},remove(e,t,n,{um:r,o:{remove:i}},o){const{shapeFlag:s,children:a,anchor:l,targetStart:c,targetAnchor:d,target:h,props:u}=e;if(h&&(i(c),i(d)),o&&i(l),16&s){const e=o||!Ar(u);for(let i=0;i<a.length;i++){const o=a[i];r(o,t,n,e,!!o.dynamicChildren)}}},move:kr,hydrate:function(e,t,n,r,i,o,{o:{nextSibling:s,parentNode:a,querySelector:l,insert:c,createText:d}},h){function u(e,t,l,c){t.anchor=h(s(e),t,a(e),n,r,i,o),t.targetStart=l,t.targetAnchor=c}const p=t.target=wr(t.props,l),f=Ar(t.props);if(p){const a=p._lpa||p.firstChild;if(16&t.shapeFlag)if(f)u(e,t,a,a&&s(a));else{t.anchor=s(e);let l=a;for(;l;){if(l&&8===l.nodeType)if("teleport start anchor"===l.data)t.targetStart=l;else if("teleport anchor"===l.data){t.targetAnchor=l,p._lpa=t.targetAnchor&&s(t.targetAnchor);break}l=s(l)}t.targetAnchor||Br(p,t,d,c),h(a&&s(a),t,p,n,r,i,o)}Or(t,f)}else f&&16&t.shapeFlag&&u(e,t,e,s(e));return t.anchor&&s(t.anchor)}};function kr(e,t,n,{o:{insert:r},m:i},o=2){0===o&&r(e.targetAnchor,t,n);const{el:s,anchor:a,shapeFlag:l,children:c,props:d}=e,h=2===o;if(h&&r(s,t,n),(!h||Ar(d))&&16&l)for(let e=0;e<c.length;e++)i(c[e],t,n,2);h&&r(a,t,n)}const Sr=Cr;function Or(e,t){const n=e.ctx;if(n&&n.ut){let r,i;for(t?(r=e.el,i=e.anchor):(r=e.targetStart,i=e.targetAnchor);r&&r!==i;)1===r.nodeType&&r.setAttribute("data-v-owner",n.uid),r=r.nextSibling;n.ut()}}function Br(e,t,n,r){const i=t.targetStart=n(""),o=t.targetAnchor=n("");return i[mr]=o,e&&(r(i,e),r(o,e)),o}const _r=Symbol("_leaveCb"),Tr=Symbol("_enterCb");function Er(){const e={isMounted:!1,isLeaving:!1,isUnmounting:!1,leavingVNodes:new Map};return Ei(()=>{e.isMounted=!0}),Pi(()=>{e.isUnmounting=!0}),e}const Mr=[Function,Array],Dr={mode:String,appear:Boolean,persisted:Boolean,onBeforeEnter:Mr,onEnter:Mr,onAfterEnter:Mr,onEnterCancelled:Mr,onBeforeLeave:Mr,onLeave:Mr,onAfterLeave:Mr,onLeaveCancelled:Mr,onBeforeAppear:Mr,onAppear:Mr,onAfterAppear:Mr,onAppearCancelled:Mr},Pr=e=>{const t=e.subTree;return t.component?Pr(t.component):t},Rr={name:"BaseTransition",props:Dr,setup(e,{slots:t}){const n=aa(),r=Er();return()=>{const i=t.default&&Wr(t.default(),!0);if(!i||!i.length)return;const o=Ir(i),s=$t(e),{mode:a}=s;if(r.isLeaving)return Fr(o);const l=Vr(o);if(!l)return Fr(o);let c=Qr(l,s,r,n,e=>c=e);l.type!==Bs&&zr(l,c);let d=n.subTree&&Vr(n.subTree);if(d&&d.type!==Bs&&!Vs(d,l)&&Pr(n).type!==Bs){let e=Qr(d,s,r,n);if(zr(d,e),"out-in"===a&&l.type!==Bs)return r.isLeaving=!0,e.afterLeave=()=>{r.isLeaving=!1,8&n.job.flags||n.update(),delete e.afterLeave,d=void 0},Fr(o);"in-out"===a&&l.type!==Bs?e.delayLeave=(e,t,n)=>{Lr(r,d)[String(d.key)]=d,e[_r]=()=>{t(),e[_r]=void 0,delete c.delayedLeave,d=void 0},c.delayedLeave=()=>{n(),delete c.delayedLeave,d=void 0}}:d=void 0}else d&&(d=void 0);return o}}};function Ir(e){let t=e[0];if(e.length>1){let n=!1;for(const r of e)if(r.type!==Bs){0,t=r,n=!0;break}}return t}const Nr=Rr;function Lr(e,t){const{leavingVNodes:n}=e;let r=n.get(t.type);return r||(r=Object.create(null),n.set(t.type,r)),r}function Qr(e,t,n,r,i){const{appear:o,mode:s,persisted:a=!1,onBeforeEnter:l,onEnter:c,onAfterEnter:d,onEnterCancelled:h,onBeforeLeave:u,onLeave:p,onAfterLeave:f,onLeaveCancelled:m,onBeforeAppear:v,onAppear:A,onAfterAppear:b,onAppearCancelled:y}=t,x=String(e.key),w=Lr(n,e),C=(e,t)=>{e&&Tn(e,r,9,t)},k=(e,t)=>{const n=t[1];C(e,t),g(e)?e.every(e=>e.length<=1)&&n():e.length<=1&&n()},S={mode:s,persisted:a,beforeEnter(t){let r=l;if(!n.isMounted){if(!o)return;r=v||l}t[_r]&&t[_r](!0);const i=w[x];i&&Vs(e,i)&&i.el[_r]&&i.el[_r](),C(r,[t])},enter(e){let t=c,r=d,i=h;if(!n.isMounted){if(!o)return;t=A||c,r=b||d,i=y||h}let s=!1;const a=e[Tr]=t=>{s||(s=!0,C(t?i:r,[e]),S.delayedLeave&&S.delayedLeave(),e[Tr]=void 0)};t?k(t,[e,a]):a()},leave(t,r){const i=String(e.key);if(t[Tr]&&t[Tr](!0),n.isUnmounting)return r();C(u,[t]);let o=!1;const s=t[_r]=n=>{o||(o=!0,r(),C(n?m:f,[t]),t[_r]=void 0,w[i]===e&&delete w[i])};w[i]=e,p?k(p,[t,s]):s()},clone(e){const o=Qr(e,t,n,r,i);return i&&i(o),o}};return S}function Fr(e){if(vi(e))return(e=Gs(e)).children=null,e}function Vr(e){if(!vi(e))return vr(e.type)&&e.children?Ir(e.children):e;if(e.component)return e.component.subTree;const{shapeFlag:t,children:n}=e;if(n){if(16&t)return n[0];if(32&t&&b(n.default))return n.default()}}function zr(e,t){6&e.shapeFlag&&e.component?(e.transition=t,zr(e.component.subTree,t)):128&e.shapeFlag?(e.ssContent.transition=t.clone(e.ssContent),e.ssFallback.transition=t.clone(e.ssFallback)):e.transition=t}function Wr(e,t=!1,n){let r=[],i=0;for(let o=0;o<e.length;o++){let s=e[o];const a=null==n?s.key:String(n)+String(null!=s.key?s.key:o);s.type===Ss?(128&s.patchFlag&&i++,r=r.concat(Wr(s.children,t,a))):(t||s.type!==Bs)&&r.push(null!=a?Gs(s,{key:a}):s)}if(i>1)for(let e=0;e<r.length;e++)r[e].patchFlag=-2;return r}function $r(e,t){return b(e)?(()=>h({name:e.name},t,{setup:e}))():e}function Hr(){const e=aa();return e?(e.appContext.config.idPrefix||"v")+"-"+e.ids[0]+e.ids[1]++:""}function jr(e){e.ids=[e.ids[0]+e.ids[2]+++"-",0,0]}function qr(e){const t=aa(),n=Yt(null);if(t){const r=t.refs===o?t.refs={}:t.refs;Object.defineProperty(r,e,{enumerable:!0,get:()=>n.value,set:e=>n.value=e})}else 0;return n}const Ur=new WeakMap;function Gr(e,t,n,r,i=!1){if(g(e))return void e.forEach((e,o)=>Gr(e,t&&(g(t)?t[o]:t),n,r,i));if(fi(r)&&!i)return void(512&r.shapeFlag&&r.type.__asyncResolved&&r.component.subTree.component&&Gr(e,t,n,r.component.subTree));const s=4&r.shapeFlag?Ca(r.component):r.el,a=i?null:s,{i:c,r:d}=e;const h=t&&t.r,p=c.refs===o?c.refs={}:c.refs,m=c.setupState,v=$t(m),A=m===o?l:e=>f(v,e);if(null!=h&&h!==d)if(Yr(t),y(h))p[h]=null,A(h)&&(m[h]=null);else if(Ut(h)){h.value=null;const e=t;e.k&&(p[e.k]=null)}if(b(d))_n(d,c,12,[a,p]);else{const t=y(d),r=Ut(d);if(t||r){const o=()=>{if(e.f){const n=t?A(d)?m[d]:p[d]:d.value;if(i)g(n)&&u(n,s);else if(g(n))n.includes(s)||n.push(s);else if(t)p[d]=[s],A(d)&&(m[d]=p[d]);else{const t=[s];d.value=t,e.k&&(p[e.k]=t)}}else t?(p[d]=a,A(d)&&(m[d]=a)):r&&(d.value=a,e.k&&(p[e.k]=a))};if(a){const t=()=>{o(),Ur.delete(e)};t.id=-1,Ur.set(e,t),ss(t,n)}else Yr(e),o()}else 0}}function Yr(e){const t=Ur.get(e);t&&(t.flags|=8,Ur.delete(e))}let Xr=!1;const Jr=()=>{Xr||(console.error("Hydration completed but contains mismatches."),Xr=!0)},Kr=e=>{if(1===e.nodeType)return(e=>e.namespaceURI.includes("svg")&&"foreignObject"!==e.tagName)(e)?"svg":(e=>e.namespaceURI.includes("MathML"))(e)?"mathml":void 0},Zr=e=>8===e.nodeType;function ei(e){const{mt:t,p:n,o:{patchProp:r,createText:i,nextSibling:o,parentNode:s,remove:a,insert:l,createComment:d}}=e,h=(n,r,a,c,d,b=!1)=>{b=b||!!r.dynamicChildren;const y=Zr(n)&&"["===n.data,x=()=>g(n,r,a,c,d,y),{type:w,ref:C,shapeFlag:k,patchFlag:S}=r;let O=n.nodeType;r.el=n,-2===S&&(b=!1,r.dynamicChildren=null);let B=null;switch(w){case Os:3!==O?""===r.children?(l(r.el=i(""),s(n),n),B=n):B=x():(n.data!==r.children&&(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&wn("Hydration text mismatch in",n.parentNode,`\n  - rendered on server: ${JSON.stringify(n.data)}\n  - expected on client: ${JSON.stringify(r.children)}`),Jr(),n.data=r.children),B=o(n));break;case Bs:A(n)?(B=o(n),v(r.el=n.content.firstChild,n,a)):B=8!==O||y?x():o(n);break;case _s:if(y&&(O=(n=o(n)).nodeType),1===O||3===O){B=n;const e=!r.children.length;for(let t=0;t<r.staticCount;t++)e&&(r.children+=1===B.nodeType?B.outerHTML:B.data),t===r.staticCount-1&&(r.anchor=B),B=o(B);return y?o(B):B}x();break;case Ss:B=y?f(n,r,a,c,d,b):x();break;default:if(1&k)B=1===O&&r.type.toLowerCase()===n.tagName.toLowerCase()||A(n)?u(n,r,a,c,d,b):x();else if(6&k){r.slotScopeIds=d;const e=s(n);if(B=y?m(n):Zr(n)&&"teleport start"===n.data?m(n,n.data,"teleport end"):o(n),t(r,e,null,a,c,Kr(e),b),fi(r)&&!r.type.__asyncResolved){let t;y?(t=js(Ss),t.anchor=B?B.previousSibling:e.lastChild):t=3===n.nodeType?Ys(""):js("div"),t.el=n,r.component.subTree=t}}else 64&k?B=8!==O?x():r.type.hydrate(n,r,a,c,d,b,e,p):128&k?B=r.type.hydrate(n,r,a,c,Kr(s(n)),d,b,e,h):__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&wn("Invalid HostVNode type:",w,`(${typeof w})`)}return null!=C&&Gr(C,null,c,r),B},u=(e,t,n,i,o,s)=>{s=s||!!t.dynamicChildren;const{type:l,props:d,patchFlag:h,shapeFlag:u,dirs:f,transition:g}=t,m="input"===l||"option"===l;if(m||-1!==h){f&&rr(t,null,n,"created");let l,b=!1;if(A(e)){b=us(null,g)&&n&&n.vnode.props&&n.vnode.props.appear;const r=e.content.firstChild;if(b){const e=r.getAttribute("class");e&&(r.$cls=e),g.beforeEnter(r)}v(r,e,n),t.el=e=r}if(16&u&&(!d||!d.innerHTML&&!d.textContent)){let r=p(e.firstChild,t,e,n,i,o,s),l=!1;for(;r;){ai(e,1)||(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&!l&&(wn("Hydration children mismatch on",e,"\nServer rendered element contains more child nodes than client vdom."),l=!0),Jr());const t=r;r=r.nextSibling,a(t)}}else if(8&u){let n=t.children;"\n"!==n[0]||"PRE"!==e.tagName&&"TEXTAREA"!==e.tagName||(n=n.slice(1));const{textContent:r}=e;r!==n&&r!==n.replace(/\r\n|\r/g,"\n")&&(ai(e,0)||(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&wn("Hydration text content mismatch on",e,`\n  - rendered on server: ${r}\n  - expected on client: ${n}`),Jr()),e.textContent=t.children)}if(d)if(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__||m||!s||48&h){const i=e.tagName.includes("-");for(const o in d)!__VUE_PROD_HYDRATION_MISMATCH_DETAILS__||f&&f.some(e=>e.dir.created)||!ti(e,o,d[o],t,n)||Jr(),(m&&(o.endsWith("value")||"indeterminate"===o)||c(o)&&!_(o)||"."===o[0]||i&&!_(o))&&r(e,o,null,d[o],void 0,n)}else if(d.onClick)r(e,"onClick",null,d.onClick,void 0,n);else if(4&h&&Ft(d.style))for(const e in d.style)d.style[e];(l=d&&d.onVnodeBeforeMount)&&na(l,n,t),f&&rr(t,null,n,"beforeMount"),((l=d&&d.onVnodeMounted)||f||b)&&Cs(()=>{l&&na(l,n,t),b&&g.enter(e),f&&rr(t,null,n,"mounted")},i)}return e.nextSibling},p=(e,t,r,s,a,c,d)=>{d=d||!!t.dynamicChildren;const u=t.children,p=u.length;let f=!1;for(let t=0;t<p;t++){const g=d?u[t]:u[t]=Ks(u[t]),m=g.type===Os;e?(m&&!d&&t+1<p&&Ks(u[t+1]).type===Os&&(l(i(e.data.slice(g.children.length)),r,o(e)),e.data=g.children),e=h(e,g,s,a,c,d)):m&&!g.children?l(g.el=i(""),r):(ai(r,1)||(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&!f&&(wn("Hydration children mismatch on",r,"\nServer rendered element contains fewer child nodes than client vdom."),f=!0),Jr()),n(null,g,r,null,s,a,Kr(r),c))}return e},f=(e,t,n,r,i,a)=>{const{slotScopeIds:c}=t;c&&(i=i?i.concat(c):c);const h=s(e),u=p(o(e),t,h,n,r,i,a);return u&&Zr(u)&&"]"===u.data?o(t.anchor=u):(Jr(),l(t.anchor=d("]"),h,u),u)},g=(e,t,r,i,l,c)=>{if(ai(e.parentElement,1)||(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&wn("Hydration node mismatch:\n- rendered on server:",e,3===e.nodeType?"(text)":Zr(e)&&"["===e.data?"(start of fragment)":"","\n- expected on client:",t.type),Jr()),t.el=null,c){const t=m(e);for(;;){const n=o(e);if(!n||n===t)break;a(n)}}const d=o(e),h=s(e);return a(e),n(null,t,h,d,r,i,Kr(h),l),r&&(r.vnode.el=t.el,jo(r,t.el)),d},m=(e,t="[",n="]")=>{let r=0;for(;e;)if((e=o(e))&&Zr(e)&&(e.data===t&&r++,e.data===n)){if(0===r)return o(e);r--}return e},v=(e,t,n)=>{const r=t.parentNode;r&&r.replaceChild(e,t);let i=n;for(;i;)i.vnode.el===t&&(i.vnode.el=i.subTree.el=e),i=i.parent},A=e=>1===e.nodeType&&"TEMPLATE"===e.tagName;return[(e,t)=>{if(!t.hasChildNodes())return __VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&wn("Attempting to hydrate existing markup but container is empty. Performing full mount instead."),n(null,e,t),$n(),void(t._vnode=e);h(t.firstChild,e,null,null,null),$n(),t._vnode=e},h]}function ti(e,t,n,r,i){let o,s,a,l;if("class"===t)e.$cls?(a=e.$cls,delete e.$cls):a=e.getAttribute("class"),l=X(n),function(e,t){if(e.size!==t.size)return!1;for(const n of e)if(!t.has(n))return!1;return!0}(ni(a||""),ni(l))||(o=2,s="class");else if("style"===t){a=e.getAttribute("style")||"",l=y(n)?n:function(e){if(!e)return"";if(y(e))return e;let t="";for(const n in e){const r=e[n];(y(r)||"number"==typeof r)&&(t+=`${n.startsWith("--")?n:R(n)}:${r};`)}return t}(j(n));const t=ri(a),c=ri(l);if(r.dirs)for(const{dir:e,value:t}of r.dirs)"show"!==e.name||t||c.set("display","none");i&&ii(i,r,c),function(e,t){if(e.size!==t.size)return!1;for(const[n,r]of e)if(r!==t.get(n))return!1;return!0}(t,c)||(o=3,s="style")}else(e instanceof SVGElement&&ae(t)||e instanceof HTMLElement&&(ie(t)||se(t)))&&(ie(t)?(a=e.hasAttribute(t),l=oe(n)):null==n?(a=e.hasAttribute(t),l=!1):(a=e.hasAttribute(t)?e.getAttribute(t):"value"===t&&"TEXTAREA"===e.tagName&&e.value,l=!!function(e){if(null==e)return!1;const t=typeof e;return"string"===t||"number"===t||"boolean"===t}(n)&&String(n)),a!==l&&(o=4,s=t));if(null!=o&&!ai(e,o)){const t=e=>!1===e?"(not rendered)":`${s}="${e}"`;return wn(`Hydration ${si[o]} mismatch on`,e,`\n  - rendered on server: ${t(a)}\n  - expected on client: ${t(l)}\n  Note: this mismatch is check-only. The DOM will not be rectified in production due to performance overhead.\n  You should fix the source of the mismatch.`),!0}return!1}function ni(e){return new Set(e.trim().split(/\s+/))}function ri(e){const t=new Map;for(const n of e.split(";")){let[e,r]=n.split(":");e=e.trim(),r=r&&r.trim(),e&&r&&t.set(e,r)}return t}function ii(e,t,n){const r=e.subTree;if(e.getCssVars&&(t===r||r&&r.type===Ss&&r.children.includes(t))){const t=e.getCssVars();for(const e in t){const r=me(t[e]);n.set(`--${ce(e,!1)}`,r)}}t===r&&e.parent&&ii(e.parent,e.vnode,n)}const oi="data-allow-mismatch",si={0:"text",1:"children",2:"class",3:"style",4:"attribute"};function ai(e,t){if(0===t||1===t)for(;e&&!e.hasAttribute(oi);)e=e.parentElement;const n=e&&e.getAttribute(oi);if(null==n)return!1;if(""===n)return!0;{const e=n.split(",");return!(0!==t||!e.includes("children"))||e.includes(si[t])}}const li=$().requestIdleCallback||(e=>setTimeout(e,1)),ci=$().cancelIdleCallback||(e=>clearTimeout(e)),di=(e=1e4)=>t=>{const n=li(t,{timeout:e});return()=>ci(n)};const hi=e=>(t,n)=>{const r=new IntersectionObserver(e=>{for(const n of e)if(n.isIntersecting){r.disconnect(),t();break}},e);return n(e=>{if(e instanceof Element)return function(e){const{top:t,left:n,bottom:r,right:i}=e.getBoundingClientRect(),{innerHeight:o,innerWidth:s}=window;return(t>0&&t<o||r>0&&r<o)&&(n>0&&n<s||i>0&&i<s)}(e)?(t(),r.disconnect(),!1):void r.observe(e)}),()=>r.disconnect()},ui=e=>t=>{if(e){const n=matchMedia(e);if(!n.matches)return n.addEventListener("change",t,{once:!0}),()=>n.removeEventListener("change",t);t()}},pi=(e=[])=>(t,n)=>{y(e)&&(e=[e]);let r=!1;const i=e=>{r||(r=!0,o(),t(),e.target.dispatchEvent(new e.constructor(e.type,e)))},o=()=>{n(t=>{for(const n of e)t.removeEventListener(n,i)})};return n(t=>{for(const n of e)t.addEventListener(n,i,{once:!0})}),o};const fi=e=>!!e.type.__asyncLoader;function gi(e){b(e)&&(e={loader:e});const{loader:t,loadingComponent:n,errorComponent:r,delay:i=200,hydrate:o,timeout:s,suspensible:a=!0,onError:l}=e;let c,d=null,h=0;const u=()=>{let e;return d||(e=d=t().catch(e=>{if(e=e instanceof Error?e:new Error(String(e)),l)return new Promise((t,n)=>{l(e,()=>t((h++,d=null,u())),()=>n(e),h+1)});throw e}).then(t=>e!==d&&d?d:(t&&(t.__esModule||"Module"===t[Symbol.toStringTag])&&(t=t.default),c=t,t)))};return $r({name:"AsyncComponentWrapper",__asyncLoader:u,__asyncHydrate(e,t,n){let r=!1;(t.bu||(t.bu=[])).push(()=>r=!0);const i=()=>{r||n()},s=o?()=>{const n=o(i,t=>function(e,t){if(Zr(e)&&"["===e.data){let n=1,r=e.nextSibling;for(;r;){if(1===r.nodeType){if(!1===t(r))break}else if(Zr(r))if("]"===r.data){if(0===--n)break}else"["===r.data&&n++;r=r.nextSibling}}else t(e)}(e,t));n&&(t.bum||(t.bum=[])).push(n)}:i;c?s():u().then(()=>!t.isUnmounted&&s())},get __asyncResolved(){return c},setup(){const e=sa;if(jr(e),c)return()=>mi(c,e);const t=t=>{d=null,En(t,e,13,!r)};if(a&&e.suspense||ga)return u().then(t=>()=>mi(t,e)).catch(e=>(t(e),()=>r?js(r,{error:e}):null));const o=Gt(!1),l=Gt(),h=Gt(!!i);return i&&setTimeout(()=>{h.value=!1},i),null!=s&&setTimeout(()=>{if(!o.value&&!l.value){const e=new Error(`Async component timed out after ${s}ms.`);t(e),l.value=e}},s),u().then(()=>{o.value=!0,e.parent&&vi(e.parent.vnode)&&e.parent.update()}).catch(e=>{t(e),l.value=e}),()=>o.value&&c?mi(c,e):l.value&&r?js(r,{error:l.value}):n&&!h.value?mi(n,e):void 0}})}function mi(e,t){const{ref:n,props:r,children:i,ce:o}=t.vnode,s=js(e,r,i);return s.ref=n,s.ce=o,delete t.vnode.ce,s}const vi=e=>e.type.__isKeepAlive,Ai={name:"KeepAlive",__isKeepAlive:!0,props:{include:[String,RegExp,Array],exclude:[String,RegExp,Array],max:[String,Number]},setup(e,{slots:t}){const n=aa(),r=n.ctx;if(!r.renderer)return()=>{const e=t.default&&t.default();return e&&1===e.length?e[0]:e};const i=new Map,o=new Set;let s=null;const a=n.suspense,{renderer:{p:l,m:c,um:d,o:{createElement:h}}}=r,u=h("div");function p(e){Si(e),d(e,n,a,!0)}function f(e){i.forEach((t,n)=>{const r=Sa(fi(t)?t.type.__asyncResolved||{}:t.type);r&&!e(r)&&g(n)})}function g(e){const t=i.get(e);!t||s&&Vs(t,s)?s&&Si(s):p(t),i.delete(e),o.delete(e)}r.activate=(e,t,n,r,i)=>{const o=e.component;c(e,t,n,0,a),l(o.vnode,e,t,n,o,a,r,e.slotScopeIds,i),ss(()=>{o.isDeactivated=!1,o.a&&Q(o.a);const t=e.props&&e.props.onVnodeMounted;t&&na(t,o.parent,e)},a)},r.deactivate=e=>{const t=e.component;gs(t.m),gs(t.a),c(e,u,null,1,a),ss(()=>{t.da&&Q(t.da);const n=e.props&&e.props.onVnodeUnmounted;n&&na(n,t.parent,e),t.isDeactivated=!0},a)},ur(()=>[e.include,e.exclude],([e,t])=>{e&&f(t=>yi(e,t)),t&&f(e=>!yi(t,e))},{flush:"post",deep:!0});let m=null;const v=()=>{null!=m&&(vs(n.subTree.type)?ss(()=>{i.set(m,Oi(n.subTree))},n.subTree.suspense):i.set(m,Oi(n.subTree)))};return Ei(v),Di(v),Pi(()=>{i.forEach(e=>{const{subTree:t,suspense:r}=n,i=Oi(t);if(e.type===i.type&&e.key===i.key){Si(i);const e=i.component.da;return void(e&&ss(e,r))}p(e)})}),()=>{if(m=null,!t.default)return s=null;const n=t.default(),r=n[0];if(n.length>1)return s=null,n;if(!(Fs(r)&&(4&r.shapeFlag||128&r.shapeFlag)))return s=null,r;let a=Oi(r);if(a.type===Bs)return s=null,a;const l=a.type,c=Sa(fi(a)?a.type.__asyncResolved||{}:l),{include:d,exclude:h,max:u}=e;if(d&&(!c||!yi(d,c))||h&&c&&yi(h,c))return a.shapeFlag&=-257,s=a,r;const p=null==a.key?l:a.key,f=i.get(p);return a.el&&(a=Gs(a),128&r.shapeFlag&&(r.ssContent=a)),m=p,f?(a.el=f.el,a.component=f.component,a.transition&&zr(a,a.transition),a.shapeFlag|=512,o.delete(p),o.add(p)):(o.add(p),u&&o.size>parseInt(u,10)&&g(o.values().next().value)),a.shapeFlag|=256,s=a,vs(r.type)?r:a}}},bi=Ai;function yi(e,t){return g(e)?e.some(e=>yi(e,t)):y(e)?e.split(",").includes(t):"[object RegExp]"===S(e)&&(e.lastIndex=0,e.test(t))}function xi(e,t){Ci(e,"a",t)}function wi(e,t){Ci(e,"da",t)}function Ci(e,t,n=sa){const r=e.__wdc||(e.__wdc=()=>{let t=n;for(;t;){if(t.isDeactivated)return;t=t.parent}return e()});if(Bi(t,r,n),n){let e=n.parent;for(;e&&e.parent;)vi(e.parent.vnode)&&ki(r,t,n,e),e=e.parent}}function ki(e,t,n,r){const i=Bi(t,e,r,!0);Ri(()=>{u(r[t],i)},n)}function Si(e){e.shapeFlag&=-257,e.shapeFlag&=-513}function Oi(e){return 128&e.shapeFlag?e.ssContent:e}function Bi(e,t,n=sa,r=!1){if(n){const i=n[e]||(n[e]=[]),o=t.__weh||(t.__weh=(...r)=>{ze();const i=da(n),o=Tn(t,n,e,r);return i(),We(),o});return r?i.unshift(o):i.push(o),o}}const _i=e=>(t,n=sa)=>{ga&&"sp"!==e||Bi(e,(...e)=>t(...e),n)},Ti=_i("bm"),Ei=_i("m"),Mi=_i("bu"),Di=_i("u"),Pi=_i("bum"),Ri=_i("um"),Ii=_i("sp"),Ni=_i("rtg"),Li=_i("rtc");function Qi(e,t=sa){Bi("ec",e,t)}const Fi="components";function Vi(e,t){return Hi(Fi,e,!0,t)||e}const zi=Symbol.for("v-ndc");function Wi(e){return y(e)?Hi(Fi,e,!1)||e:e||zi}function $i(e){return Hi("directives",e)}function Hi(e,t,n=!0,r=!1){const i=Yn||sa;if(i){const n=i.type;if(e===Fi){const e=Sa(n,!1);if(e&&(e===t||e===D(t)||e===I(D(t))))return n}const o=ji(i[e]||n[e],t)||ji(i.appContext[e],t);return!o&&r?n:o}}function ji(e,t){return e&&(e[t]||e[D(t)]||e[I(D(t))])}function qi(e,t,n,r){let i;const o=n&&n[r],s=g(e);if(s||y(e)){let n=!1,r=!1;s&&Ft(e)&&(n=!zt(e),r=Vt(e),e=tt(e)),i=new Array(e.length);for(let s=0,a=e.length;s<a;s++)i[s]=t(n?r?qt(jt(e[s])):jt(e[s]):e[s],s,void 0,o&&o[s])}else if("number"==typeof e){0,i=new Array(e);for(let n=0;n<e;n++)i[n]=t(n+1,n,void 0,o&&o[n])}else if(w(e))if(e[Symbol.iterator])i=Array.from(e,(e,n)=>t(e,n,void 0,o&&o[n]));else{const n=Object.keys(e);i=new Array(n.length);for(let r=0,s=n.length;r<s;r++){const s=n[r];i[r]=t(e[s],s,r,o&&o[r])}}else i=[];return n&&(n[r]=i),i}function Ui(e,t){for(let n=0;n<t.length;n++){const r=t[n];if(g(r))for(let t=0;t<r.length;t++)e[r[t].name]=r[t].fn;else r&&(e[r.name]=r.key?(...e)=>{const t=r.fn(...e);return t&&(t.key=r.key),t}:r.fn)}return e}function Gi(e,t,n={},r,i){if(Yn.ce||Yn.parent&&fi(Yn.parent)&&Yn.parent.ce){const e=Object.keys(n).length>0;return"default"!==t&&(n.name=t),Ms(),Qs(Ss,null,[js("slot",n,r&&r())],e?-2:64)}let o=e[t];o&&o._c&&(o._d=!1),Ms();const s=o&&Yi(o(n)),a=n.key||s&&s.key,l=Qs(Ss,{key:(a&&!x(a)?a:`_${t}`)+(!s&&r?"_fb":"")},s||(r?r():[]),s&&1===e._?64:-2);return!i&&l.scopeId&&(l.slotScopeIds=[l.scopeId+"-s"]),o&&o._c&&(o._d=!0),l}function Yi(e){return e.some(e=>!Fs(e)||e.type!==Bs&&!(e.type===Ss&&!Yi(e.children)))?e:null}function Xi(e,t){const n={};for(const r in e)n[t&&/[A-Z]/.test(r)?`on:${r}`:N(r)]=e[r];return n}const Ji=e=>e?ua(e)?Ca(e):Ji(e.parent):null,Ki=h(Object.create(null),{$:e=>e,$el:e=>e.vnode.el,$data:e=>e.data,$props:e=>e.props,$attrs:e=>e.attrs,$slots:e=>e.slots,$refs:e=>e.refs,$parent:e=>Ji(e.parent),$root:e=>Ji(e.root),$host:e=>e.ce,$emit:e=>e.emit,$options:e=>wo(e),$forceUpdate:e=>e.f||(e.f=()=>{Fn(e.update)}),$nextTick:e=>e.n||(e.n=Qn.bind(e.proxy)),$watch:e=>fr.bind(e)}),Zi=(e,t)=>e!==o&&!e.__isScriptSetup&&f(e,t),eo={get({_:e},t){if("__v_skip"===t)return!0;const{ctx:n,setupState:r,data:i,props:s,accessCache:a,type:l,appContext:c}=e;if("$"!==t[0]){const e=a[t];if(void 0!==e)switch(e){case 1:return r[t];case 2:return i[t];case 4:return n[t];case 3:return s[t]}else{if(Zi(r,t))return a[t]=1,r[t];if(i!==o&&f(i,t))return a[t]=2,i[t];if(f(s,t))return a[t]=3,s[t];if(n!==o&&f(n,t))return a[t]=4,n[t];Ao&&(a[t]=0)}}const d=Ki[t];let h,u;return d?("$attrs"===t&&Ke(e.attrs,0,""),d(e)):(h=l.__cssModules)&&(h=h[t])?h:n!==o&&f(n,t)?(a[t]=4,n[t]):(u=c.config.globalProperties,f(u,t)?u[t]:void 0)},set({_:e},t,n){const{data:r,setupState:i,ctx:s}=e;return Zi(i,t)?(i[t]=n,!0):r!==o&&f(r,t)?(r[t]=n,!0):!f(e.props,t)&&(("$"!==t[0]||!(t.slice(1)in e))&&(s[t]=n,!0))},has({_:{data:e,setupState:t,accessCache:n,ctx:r,appContext:i,props:s,type:a}},l){let c;return!!(n[l]||e!==o&&"$"!==l[0]&&f(e,l)||Zi(t,l)||f(s,l)||f(r,l)||f(Ki,l)||f(i.config.globalProperties,l)||(c=a.__cssModules)&&c[l])},defineProperty(e,t,n){return null!=n.get?e._.accessCache[t]=0:f(n,"value")&&this.set(e,t,n.value,null),Reflect.defineProperty(e,t,n)}};const to=h({},eo,{get(e,t){if(t!==Symbol.unscopables)return eo.get(e,t,e)},has:(e,t)=>"_"!==t[0]&&!H(t)});function no(){return null}function ro(){return null}function io(e){0}function oo(e){0}function so(){return null}function ao(){0}function lo(e,t){return null}function co(){return uo("useSlots").slots}function ho(){return uo("useAttrs").attrs}function uo(e){const t=aa();return t.setupContext||(t.setupContext=wa(t))}function po(e){return g(e)?e.reduce((e,t)=>(e[t]=null,e),{}):e}function fo(e,t){const n=po(e);for(const e in t){if(e.startsWith("__skip"))continue;let r=n[e];r?g(r)||b(r)?r=n[e]={type:r,default:t[e]}:r.default=t[e]:null===r&&(r=n[e]={default:t[e]}),r&&t[`__skip_${e}`]&&(r.skipFactory=!0)}return n}function go(e,t){return e&&t?g(e)&&g(t)?e.concat(t):h({},po(e),po(t)):e||t}function mo(e,t){const n={};for(const r in e)t.includes(r)||Object.defineProperty(n,r,{enumerable:!0,get:()=>e[r]});return n}function vo(e){const t=aa();let n=e();return ha(),C(n)&&(n=n.catch(e=>{throw da(t),e})),[n,()=>da(t)]}let Ao=!0;function bo(e){const t=wo(e),n=e.proxy,r=e.ctx;Ao=!1,t.beforeCreate&&yo(t.beforeCreate,e,"bc");const{data:i,computed:o,methods:s,watch:l,provide:c,inject:d,created:h,beforeMount:u,mounted:p,beforeUpdate:f,updated:m,activated:v,deactivated:A,beforeDestroy:y,beforeUnmount:x,destroyed:C,unmounted:k,render:S,renderTracked:O,renderTriggered:B,errorCaptured:_,serverPrefetch:T,expose:E,inheritAttrs:M,components:D,directives:P,filters:R}=t;if(d&&function(e,t){g(e)&&(e=Oo(e));for(const n in e){const r=e[n];let i;i=w(r)?"default"in r?or(r.from||n,r.default,!0):or(r.from||n):or(r),Ut(i)?Object.defineProperty(t,n,{enumerable:!0,configurable:!0,get:()=>i.value,set:e=>i.value=e}):t[n]=i}}(d,r,null),s)for(const e in s){const t=s[e];b(t)&&(r[e]=t.bind(n))}if(i){0;const t=i.call(n,n);0,w(t)&&(e.data=Rt(t))}if(Ao=!0,o)for(const e in o){const t=o[e],i=b(t)?t.bind(n,n):b(t.get)?t.get.bind(n,n):a;0;const s=!b(t)&&b(t.set)?t.set.bind(n):a,l=_a({get:i,set:s});Object.defineProperty(r,e,{enumerable:!0,configurable:!0,get:()=>l.value,set:e=>l.value=e})}if(l)for(const e in l)xo(l[e],r,n,e);if(c){const e=b(c)?c.call(n):c;Reflect.ownKeys(e).forEach(t=>{ir(t,e[t])})}function I(e,t){g(t)?t.forEach(t=>e(t.bind(n))):t&&e(t.bind(n))}if(h&&yo(h,e,"c"),I(Ti,u),I(Ei,p),I(Mi,f),I(Di,m),I(xi,v),I(wi,A),I(Qi,_),I(Li,O),I(Ni,B),I(Pi,x),I(Ri,k),I(Ii,T),g(E))if(E.length){const t=e.exposed||(e.exposed={});E.forEach(e=>{Object.defineProperty(t,e,{get:()=>n[e],set:t=>n[e]=t,enumerable:!0})})}else e.exposed||(e.exposed={});S&&e.render===a&&(e.render=S),null!=M&&(e.inheritAttrs=M),D&&(e.components=D),P&&(e.directives=P),T&&jr(e)}function yo(e,t,n){Tn(g(e)?e.map(e=>e.bind(t.proxy)):e.bind(t.proxy),t,n)}function xo(e,t,n,r){let i=r.includes(".")?gr(n,r):()=>n[r];if(y(e)){const n=t[e];b(n)&&ur(i,n)}else if(b(e))ur(i,e.bind(n));else if(w(e))if(g(e))e.forEach(e=>xo(e,t,n,r));else{const r=b(e.handler)?e.handler.bind(n):t[e.handler];b(r)&&ur(i,r,e)}else 0}function wo(e){const t=e.type,{mixins:n,extends:r}=t,{mixins:i,optionsCache:o,config:{optionMergeStrategies:s}}=e.appContext,a=o.get(t);let l;return a?l=a:i.length||n||r?(l={},i.length&&i.forEach(e=>Co(l,e,s,!0)),Co(l,t,s)):l=t,w(t)&&o.set(t,l),l}function Co(e,t,n,r=!1){const{mixins:i,extends:o}=t;o&&Co(e,o,n,!0),i&&i.forEach(t=>Co(e,t,n,!0));for(const i in t)if(r&&"expose"===i);else{const r=ko[i]||n&&n[i];e[i]=r?r(e[i],t[i]):t[i]}return e}const ko={data:So,props:To,emits:To,methods:_o,computed:_o,beforeCreate:Bo,created:Bo,beforeMount:Bo,mounted:Bo,beforeUpdate:Bo,updated:Bo,beforeDestroy:Bo,beforeUnmount:Bo,destroyed:Bo,unmounted:Bo,activated:Bo,deactivated:Bo,errorCaptured:Bo,serverPrefetch:Bo,components:_o,directives:_o,watch:function(e,t){if(!e)return t;if(!t)return e;const n=h(Object.create(null),e);for(const r in t)n[r]=Bo(e[r],t[r]);return n},provide:So,inject:function(e,t){return _o(Oo(e),Oo(t))}};function So(e,t){return t?e?function(){return h(b(e)?e.call(this,this):e,b(t)?t.call(this,this):t)}:t:e}function Oo(e){if(g(e)){const t={};for(let n=0;n<e.length;n++)t[e[n]]=e[n];return t}return e}function Bo(e,t){return e?[...new Set([].concat(e,t))]:t}function _o(e,t){return e?h(Object.create(null),e,t):t}function To(e,t){return e?g(e)&&g(t)?[...new Set([...e,...t])]:h(Object.create(null),po(e),po(null!=t?t:{})):t}function Eo(){return{app:null,config:{isNativeTag:l,performance:!1,globalProperties:{},optionMergeStrategies:{},errorHandler:void 0,warnHandler:void 0,compilerOptions:{}},mixins:[],components:{},directives:{},provides:Object.create(null),optionsCache:new WeakMap,propsCache:new WeakMap,emitsCache:new WeakMap}}let Mo=0;function Do(e,t){return function(n,r=null){b(n)||(n=h({},n)),null==r||w(r)||(r=null);const i=Eo(),o=new WeakSet,s=[];let a=!1;const l=i.app={_uid:Mo++,_component:n,_props:r,_container:null,_context:i,_instance:null,version:Pa,get config(){return i.config},set config(e){0},use:(e,...t)=>(o.has(e)||(e&&b(e.install)?(o.add(e),e.install(l,...t)):b(e)&&(o.add(e),e(l,...t))),l),mixin:e=>(i.mixins.includes(e)||i.mixins.push(e),l),component:(e,t)=>t?(i.components[e]=t,l):i.components[e],directive:(e,t)=>t?(i.directives[e]=t,l):i.directives[e],mount(o,s,c){if(!a){0;const d=l._ceVNode||js(n,r);return d.appContext=i,!0===c?c="svg":!1===c&&(c=void 0),s&&t?t(d,o):e(d,o,c),a=!0,l._container=o,o.__vue_app__=l,Ca(d.component)}},onUnmount(e){s.push(e)},unmount(){a&&(Tn(s,l._instance,16),e(null,l._container),delete l._container.__vue_app__)},provide:(e,t)=>(i.provides[e]=t,l),runWithContext(e){const t=Po;Po=l;try{return e()}finally{Po=t}}};return l}}let Po=null;function Ro(e,t,n=o){const r=aa();const i=D(t);const s=R(t),a=Io(e,i),l=on((a,l)=>{let c,d,h=o;return hr(()=>{const t=e[i];L(c,t)&&(c=t,l())}),{get:()=>(a(),n.get?n.get(c):c),set(e){const a=n.set?n.set(e):e;if(!(L(a,c)||h!==o&&L(e,h)))return;const u=r.vnode.props;u&&(t in u||i in u||s in u)&&(`onUpdate:${t}`in u||`onUpdate:${i}`in u||`onUpdate:${s}`in u)||(c=e,l()),r.emit(`update:${t}`,a),L(e,a)&&L(e,h)&&!L(a,d)&&l(),h=e,d=a}}});return l[Symbol.iterator]=()=>{let e=0;return{next:()=>e<2?{value:e++?a||o:l,done:!1}:{done:!0}}},l}const Io=(e,t)=>"modelValue"===t||"model-value"===t?e.modelModifiers:e[`${t}Modifiers`]||e[`${D(t)}Modifiers`]||e[`${R(t)}Modifiers`];function No(e,t,...n){if(e.isUnmounted)return;const r=e.vnode.props||o;let i=n;const s=t.startsWith("update:"),a=s&&Io(r,t.slice(7));let l;a&&(a.trim&&(i=n.map(e=>y(e)?e.trim():e)),a.number&&(i=n.map(V)));let c=r[l=N(t)]||r[l=N(D(t))];!c&&s&&(c=r[l=N(R(t))]),c&&Tn(c,e,6,i);const d=r[l+"Once"];if(d){if(e.emitted){if(e.emitted[l])return}else e.emitted={};e.emitted[l]=!0,Tn(d,e,6,i)}}const Lo=new WeakMap;function Qo(e,t,n=!1){const r=n?Lo:t.emitsCache,i=r.get(e);if(void 0!==i)return i;const o=e.emits;let s={},a=!1;if(!b(e)){const r=e=>{const n=Qo(e,t,!0);n&&(a=!0,h(s,n))};!n&&t.mixins.length&&t.mixins.forEach(r),e.extends&&r(e.extends),e.mixins&&e.mixins.forEach(r)}return o||a?(g(o)?o.forEach(e=>s[e]=null):h(s,o),w(e)&&r.set(e,s),s):(w(e)&&r.set(e,null),null)}function Fo(e,t){return!(!e||!c(t))&&(t=t.slice(2).replace(/Once$/,""),f(e,t[0].toLowerCase()+t.slice(1))||f(e,R(t))||f(e,t))}function Vo(e){const{type:t,vnode:n,proxy:r,withProxy:i,propsOptions:[o],slots:s,attrs:a,emit:l,render:c,renderCache:h,props:u,data:p,setupState:f,ctx:g,inheritAttrs:m}=e,v=Jn(e);let A,b;try{if(4&n.shapeFlag){const e=i||r,t=e;A=Ks(c.call(t,e,h,u,f,p,g)),b=a}else{const e=t;0,A=Ks(e.length>1?e(u,{attrs:a,slots:s,emit:l}):e(u,null)),b=t.props?a:Wo(a)}}catch(t){Ts.length=0,En(t,e,1),A=js(Bs)}let y=A;if(b&&!1!==m){const e=Object.keys(b),{shapeFlag:t}=y;e.length&&7&t&&(o&&e.some(d)&&(b=$o(b,o)),y=Gs(y,b,!1,!0))}return n.dirs&&(y=Gs(y,null,!1,!0),y.dirs=y.dirs?y.dirs.concat(n.dirs):n.dirs),n.transition&&zr(y,n.transition),A=y,Jn(v),A}function zo(e,t=!0){let n;for(let t=0;t<e.length;t++){const r=e[t];if(!Fs(r))return;if(r.type!==Bs||"v-if"===r.children){if(n)return;n=r}}return n}const Wo=e=>{let t;for(const n in e)("class"===n||"style"===n||c(n))&&((t||(t={}))[n]=e[n]);return t},$o=(e,t)=>{const n={};for(const r in e)d(r)&&r.slice(9)in t||(n[r]=e[r]);return n};function Ho(e,t,n){const r=Object.keys(t);if(r.length!==Object.keys(e).length)return!0;for(let i=0;i<r.length;i++){const o=r[i];if(t[o]!==e[o]&&!Fo(n,o))return!0}return!1}function jo({vnode:e,parent:t},n){for(;t;){const r=t.subTree;if(r.suspense&&r.suspense.activeBranch===e&&(r.el=e.el),r!==e)break;(e=t.vnode).el=n,t=t.parent}}const qo={},Uo=()=>Object.create(qo),Go=e=>Object.getPrototypeOf(e)===qo;function Yo(e,t,n,r){const[i,s]=e.propsOptions;let a,l=!1;if(t)for(let o in t){if(_(o))continue;const c=t[o];let d;i&&f(i,d=D(o))?s&&s.includes(d)?(a||(a={}))[d]=c:n[d]=c:Fo(e.emitsOptions,o)||o in r&&c===r[o]||(r[o]=c,l=!0)}if(s){const t=$t(n),r=a||o;for(let o=0;o<s.length;o++){const a=s[o];n[a]=Xo(i,t,a,r[a],e,!f(r,a))}}return l}function Xo(e,t,n,r,i,o){const s=e[n];if(null!=s){const e=f(s,"default");if(e&&void 0===r){const e=s.default;if(s.type!==Function&&!s.skipFactory&&b(e)){const{propsDefaults:o}=i;if(n in o)r=o[n];else{const s=da(i);r=o[n]=e.call(null,t),s()}}else r=e;i.ce&&i.ce._setProp(n,r)}s[0]&&(o&&!e?r=!1:!s[1]||""!==r&&r!==R(n)||(r=!0))}return r}const Jo=new WeakMap;function Ko(e,t,n=!1){const r=n?Jo:t.propsCache,i=r.get(e);if(i)return i;const a=e.props,l={},c=[];let d=!1;if(!b(e)){const r=e=>{d=!0;const[n,r]=Ko(e,t,!0);h(l,n),r&&c.push(...r)};!n&&t.mixins.length&&t.mixins.forEach(r),e.extends&&r(e.extends),e.mixins&&e.mixins.forEach(r)}if(!a&&!d)return w(e)&&r.set(e,s),s;if(g(a))for(let e=0;e<a.length;e++){0;const t=D(a[e]);Zo(t)&&(l[t]=o)}else if(a){0;for(const e in a){const t=D(e);if(Zo(t)){const n=a[e],r=l[t]=g(n)||b(n)?{type:n}:h({},n),i=r.type;let o=!1,s=!0;if(g(i))for(let e=0;e<i.length;++e){const t=i[e],n=b(t)&&t.name;if("Boolean"===n){o=!0;break}"String"===n&&(s=!1)}else o=b(i)&&"Boolean"===i.name;r[0]=o,r[1]=s,(o||f(r,"default"))&&c.push(t)}}}const u=[l,c];return w(e)&&r.set(e,u),u}function Zo(e){return"$"!==e[0]&&!_(e)}const es=e=>"_"===e||"_ctx"===e||"$stable"===e,ts=e=>g(e)?e.map(Ks):[Ks(e)],ns=(e,t,n)=>{if(t._n)return t;const r=tr((...e)=>ts(t(...e)),n);return r._c=!1,r},rs=(e,t,n)=>{const r=e._ctx;for(const n in e){if(es(n))continue;const i=e[n];if(b(i))t[n]=ns(0,i,r);else if(null!=i){0;const e=ts(i);t[n]=()=>e}}},is=(e,t)=>{const n=ts(t);e.slots.default=()=>n},os=(e,t,n)=>{for(const r in t)!n&&es(r)||(e[r]=t[r])};const ss=Cs;function as(e){return cs(e)}function ls(e){return cs(e,ei)}function cs(e,t){"boolean"!=typeof __VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&($().__VUE_PROD_HYDRATION_MISMATCH_DETAILS__=!1);$().__VUE__=!0;const{insert:n,remove:r,patchProp:i,createElement:l,createText:c,createComment:d,setText:h,setElementText:u,parentNode:p,nextSibling:g,setScopeId:m=a,insertStaticContent:v}=e,A=(e,t,n,r=null,i=null,o=null,s=void 0,a=null,l=!!t.dynamicChildren)=>{if(e===t)return;e&&!Vs(e,t)&&(r=X(e),j(e,i,o,!0),e=null),-2===t.patchFlag&&(l=!1,t.dynamicChildren=null);const{type:c,ref:d,shapeFlag:h}=t;switch(c){case Os:b(e,t,n,r);break;case Bs:y(e,t,n,r);break;case _s:null==e&&x(t,n,r,s);break;case Ss:M(e,t,n,r,i,o,s,a,l);break;default:1&h?C(e,t,n,r,i,o,s,a,l):6&h?P(e,t,n,r,i,o,s,a,l):(64&h||128&h)&&c.process(e,t,n,r,i,o,s,a,l,Z)}null!=d&&i?Gr(d,e&&e.ref,o,t||e,!t):null==d&&e&&null!=e.ref&&Gr(e.ref,null,o,e,!0)},b=(e,t,r,i)=>{if(null==e)n(t.el=c(t.children),r,i);else{const n=t.el=e.el;t.children!==e.children&&h(n,t.children)}},y=(e,t,r,i)=>{null==e?n(t.el=d(t.children||""),r,i):t.el=e.el},x=(e,t,n,r)=>{[e.el,e.anchor]=v(e.children,t,n,r,e.el,e.anchor)},w=({el:e,anchor:t})=>{let n;for(;e&&e!==t;)n=g(e),r(e),e=n;r(t)},C=(e,t,n,r,i,o,s,a,l)=>{if("svg"===t.type?s="svg":"math"===t.type&&(s="mathml"),null==e)k(t,n,r,i,o,s,a,l);else{const n=e.el&&e.el._isVueCE?e.el:null;try{n&&n._beginPatch(),B(e,t,i,o,s,a,l)}finally{n&&n._endPatch()}}},k=(e,t,r,o,s,a,c,d)=>{let h,p;const{props:f,shapeFlag:g,transition:m,dirs:v}=e;if(h=e.el=l(e.type,a,f&&f.is,f),8&g?u(h,e.children):16&g&&O(e.children,h,null,o,s,ds(e,a),c,d),v&&rr(e,null,o,"created"),S(h,e,e.scopeId,c,o),f){for(const e in f)"value"===e||_(e)||i(h,e,null,f[e],a,o);"value"in f&&i(h,"value",null,f.value,a),(p=f.onVnodeBeforeMount)&&na(p,o,e)}v&&rr(e,null,o,"beforeMount");const A=us(s,m);A&&m.beforeEnter(h),n(h,t,r),((p=f&&f.onVnodeMounted)||A||v)&&ss(()=>{p&&na(p,o,e),A&&m.enter(h),v&&rr(e,null,o,"mounted")},s)},S=(e,t,n,r,i)=>{if(n&&m(e,n),r)for(let t=0;t<r.length;t++)m(e,r[t]);if(i){let n=i.subTree;if(t===n||vs(n.type)&&(n.ssContent===t||n.ssFallback===t)){const t=i.vnode;S(e,t,t.scopeId,t.slotScopeIds,i.parent)}}},O=(e,t,n,r,i,o,s,a,l=0)=>{for(let c=l;c<e.length;c++){const l=e[c]=a?Zs(e[c]):Ks(e[c]);A(null,l,t,n,r,i,o,s,a)}},B=(e,t,n,r,s,a,l)=>{const c=t.el=e.el;let{patchFlag:d,dynamicChildren:h,dirs:p}=t;d|=16&e.patchFlag;const f=e.props||o,g=t.props||o;let m;if(n&&hs(n,!1),(m=g.onVnodeBeforeUpdate)&&na(m,n,t,e),p&&rr(t,e,n,"beforeUpdate"),n&&hs(n,!0),(f.innerHTML&&null==g.innerHTML||f.textContent&&null==g.textContent)&&u(c,""),h?T(e.dynamicChildren,h,c,n,r,ds(t,s),a):l||V(e,t,c,null,n,r,ds(t,s),a,!1),d>0){if(16&d)E(c,f,g,n,s);else if(2&d&&f.class!==g.class&&i(c,"class",null,g.class,s),4&d&&i(c,"style",f.style,g.style,s),8&d){const e=t.dynamicProps;for(let t=0;t<e.length;t++){const r=e[t],o=f[r],a=g[r];a===o&&"value"!==r||i(c,r,o,a,s,n)}}1&d&&e.children!==t.children&&u(c,t.children)}else l||null!=h||E(c,f,g,n,s);((m=g.onVnodeUpdated)||p)&&ss(()=>{m&&na(m,n,t,e),p&&rr(t,e,n,"updated")},r)},T=(e,t,n,r,i,o,s)=>{for(let a=0;a<t.length;a++){const l=e[a],c=t[a],d=l.el&&(l.type===Ss||!Vs(l,c)||198&l.shapeFlag)?p(l.el):n;A(l,c,d,null,r,i,o,s,!0)}},E=(e,t,n,r,s)=>{if(t!==n){if(t!==o)for(const o in t)_(o)||o in n||i(e,o,t[o],null,s,r);for(const o in n){if(_(o))continue;const a=n[o],l=t[o];a!==l&&"value"!==o&&i(e,o,l,a,s,r)}"value"in n&&i(e,"value",t.value,n.value,s)}},M=(e,t,r,i,o,s,a,l,d)=>{const h=t.el=e?e.el:c(""),u=t.anchor=e?e.anchor:c("");let{patchFlag:p,dynamicChildren:f,slotScopeIds:g}=t;g&&(l=l?l.concat(g):g),null==e?(n(h,r,i),n(u,r,i),O(t.children||[],r,u,o,s,a,l,d)):p>0&&64&p&&f&&e.dynamicChildren&&e.dynamicChildren.length===f.length?(T(e.dynamicChildren,f,r,o,s,a,l),(null!=t.key||o&&t===o.subTree)&&ps(e,t,!0)):V(e,t,r,u,o,s,a,l,d)},P=(e,t,n,r,i,o,s,a,l)=>{t.slotScopeIds=a,null==e?512&t.shapeFlag?i.ctx.activate(t,n,r,s,l):I(t,n,r,i,o,s,l):N(e,t,l)},I=(e,t,n,r,i,o,s)=>{const a=e.component=oa(e,r,i);if(vi(e)&&(a.ctx.renderer=Z),ma(a,!1,s),a.asyncDep){if(i&&i.registerDep(a,L,s),!e.el){const r=a.subTree=js(Bs);y(null,r,t,n),e.placeholder=r.el}}else L(a,e,t,n,i,o,s)},N=(e,t,n)=>{const r=t.component=e.component;if(function(e,t,n){const{props:r,children:i,component:o}=e,{props:s,children:a,patchFlag:l}=t,c=o.emitsOptions;if(t.dirs||t.transition)return!0;if(!(n&&l>=0))return!(!i&&!a||a&&a.$stable)||r!==s&&(r?!s||Ho(r,s,c):!!s);if(1024&l)return!0;if(16&l)return r?Ho(r,s,c):!!s;if(8&l){const e=t.dynamicProps;for(let t=0;t<e.length;t++){const n=e[t];if(s[n]!==r[n]&&!Fo(c,n))return!0}}return!1}(e,t,n)){if(r.asyncDep&&!r.asyncResolved)return void F(r,t,n);r.next=t,r.update()}else t.el=e.el,r.vnode=t},L=(e,t,n,r,i,o,s)=>{const a=()=>{if(e.isMounted){let{next:t,bu:n,u:r,parent:l,vnode:c}=e;{const n=fs(e);if(n)return t&&(t.el=c.el,F(e,t,s)),void n.asyncDep.then(()=>{e.isUnmounted||a()})}let d,h=t;0,hs(e,!1),t?(t.el=c.el,F(e,t,s)):t=c,n&&Q(n),(d=t.props&&t.props.onVnodeBeforeUpdate)&&na(d,l,t,c),hs(e,!0);const u=Vo(e);0;const f=e.subTree;e.subTree=u,A(f,u,p(f.el),X(f),e,i,o),t.el=u.el,null===h&&jo(e,u.el),r&&ss(r,i),(d=t.props&&t.props.onVnodeUpdated)&&ss(()=>na(d,l,t,c),i)}else{let s;const{el:a,props:l}=t,{bm:c,m:d,parent:h,root:u,type:p}=e,f=fi(t);if(hs(e,!1),c&&Q(c),!f&&(s=l&&l.onVnodeBeforeMount)&&na(s,h,t),hs(e,!0),a&&te){const t=()=>{e.subTree=Vo(e),te(a,e.subTree,e,i,null)};f&&p.__asyncHydrate?p.__asyncHydrate(a,e,t):t()}else{u.ce&&!1!==u.ce._def.shadowRoot&&u.ce._injectChildStyle(p);const s=e.subTree=Vo(e);0,A(null,s,n,r,e,i,o),t.el=s.el}if(d&&ss(d,i),!f&&(s=l&&l.onVnodeMounted)){const e=t;ss(()=>na(s,h,e),i)}(256&t.shapeFlag||h&&fi(h.vnode)&&256&h.vnode.shapeFlag)&&e.a&&ss(e.a,i),e.isMounted=!0,t=n=r=null}};e.scope.on();const l=e.effect=new ke(a);e.scope.off();const c=e.update=l.run.bind(l),d=e.job=l.runIfDirty.bind(l);d.i=e,d.id=e.uid,l.scheduler=()=>Fn(d),hs(e,!0),c()},F=(e,t,n)=>{t.component=e;const r=e.vnode.props;e.vnode=t,e.next=null,function(e,t,n,r){const{props:i,attrs:o,vnode:{patchFlag:s}}=e,a=$t(i),[l]=e.propsOptions;let c=!1;if(!(r||s>0)||16&s){let r;Yo(e,t,i,o)&&(c=!0);for(const o in a)t&&(f(t,o)||(r=R(o))!==o&&f(t,r))||(l?!n||void 0===n[o]&&void 0===n[r]||(i[o]=Xo(l,a,o,void 0,e,!0)):delete i[o]);if(o!==a)for(const e in o)t&&f(t,e)||(delete o[e],c=!0)}else if(8&s){const n=e.vnode.dynamicProps;for(let r=0;r<n.length;r++){let s=n[r];if(Fo(e.emitsOptions,s))continue;const d=t[s];if(l)if(f(o,s))d!==o[s]&&(o[s]=d,c=!0);else{const t=D(s);i[t]=Xo(l,a,t,d,e,!1)}else d!==o[s]&&(o[s]=d,c=!0)}}c&&Ze(e.attrs,"set","")}(e,t.props,r,n),((e,t,n)=>{const{vnode:r,slots:i}=e;let s=!0,a=o;if(32&r.shapeFlag){const e=t._;e?n&&1===e?s=!1:os(i,t,n):(s=!t.$stable,rs(t,i)),a=t}else t&&(is(e,t),a={default:1});if(s)for(const e in i)es(e)||null!=a[e]||delete i[e]})(e,t.children,n),ze(),Wn(e),We()},V=(e,t,n,r,i,o,s,a,l=!1)=>{const c=e&&e.children,d=e?e.shapeFlag:0,h=t.children,{patchFlag:p,shapeFlag:f}=t;if(p>0){if(128&p)return void W(c,h,n,r,i,o,s,a,l);if(256&p)return void z(c,h,n,r,i,o,s,a,l)}8&f?(16&d&&Y(c,i,o),h!==c&&u(n,h)):16&d?16&f?W(c,h,n,r,i,o,s,a,l):Y(c,i,o,!0):(8&d&&u(n,""),16&f&&O(h,n,r,i,o,s,a,l))},z=(e,t,n,r,i,o,a,l,c)=>{t=t||s;const d=(e=e||s).length,h=t.length,u=Math.min(d,h);let p;for(p=0;p<u;p++){const r=t[p]=c?Zs(t[p]):Ks(t[p]);A(e[p],r,n,null,i,o,a,l,c)}d>h?Y(e,i,o,!0,!1,u):O(t,n,r,i,o,a,l,c,u)},W=(e,t,n,r,i,o,a,l,c)=>{let d=0;const h=t.length;let u=e.length-1,p=h-1;for(;d<=u&&d<=p;){const r=e[d],s=t[d]=c?Zs(t[d]):Ks(t[d]);if(!Vs(r,s))break;A(r,s,n,null,i,o,a,l,c),d++}for(;d<=u&&d<=p;){const r=e[u],s=t[p]=c?Zs(t[p]):Ks(t[p]);if(!Vs(r,s))break;A(r,s,n,null,i,o,a,l,c),u--,p--}if(d>u){if(d<=p){const e=p+1,s=e<h?t[e].el:r;for(;d<=p;)A(null,t[d]=c?Zs(t[d]):Ks(t[d]),n,s,i,o,a,l,c),d++}}else if(d>p)for(;d<=u;)j(e[d],i,o,!0),d++;else{const f=d,g=d,m=new Map;for(d=g;d<=p;d++){const e=t[d]=c?Zs(t[d]):Ks(t[d]);null!=e.key&&m.set(e.key,d)}let v,b=0;const y=p-g+1;let x=!1,w=0;const C=new Array(y);for(d=0;d<y;d++)C[d]=0;for(d=f;d<=u;d++){const r=e[d];if(b>=y){j(r,i,o,!0);continue}let s;if(null!=r.key)s=m.get(r.key);else for(v=g;v<=p;v++)if(0===C[v-g]&&Vs(r,t[v])){s=v;break}void 0===s?j(r,i,o,!0):(C[s-g]=d+1,s>=w?w=s:x=!0,A(r,t[s],n,null,i,o,a,l,c),b++)}const k=x?function(e){const t=e.slice(),n=[0];let r,i,o,s,a;const l=e.length;for(r=0;r<l;r++){const l=e[r];if(0!==l){if(i=n[n.length-1],e[i]<l){t[r]=i,n.push(r);continue}for(o=0,s=n.length-1;o<s;)a=o+s>>1,e[n[a]]<l?o=a+1:s=a;l<e[n[o]]&&(o>0&&(t[r]=n[o-1]),n[o]=r)}}o=n.length,s=n[o-1];for(;o-- >0;)n[o]=s,s=t[s];return n}(C):s;for(v=k.length-1,d=y-1;d>=0;d--){const e=g+d,s=t[e],u=t[e+1],p=e+1<h?u.el||ms(u):r;0===C[d]?A(null,s,n,p,i,o,a,l,c):x&&(v<0||d!==k[v]?H(s,n,p,2):v--)}}},H=(e,t,i,o,s=null)=>{const{el:a,type:l,transition:c,children:d,shapeFlag:h}=e;if(6&h)return void H(e.component.subTree,t,i,o);if(128&h)return void e.suspense.move(t,i,o);if(64&h)return void l.move(e,t,i,Z);if(l===Ss){n(a,t,i);for(let e=0;e<d.length;e++)H(d[e],t,i,o);return void n(e.anchor,t,i)}if(l===_s)return void(({el:e,anchor:t},r,i)=>{let o;for(;e&&e!==t;)o=g(e),n(e,r,i),e=o;n(t,r,i)})(e,t,i);if(2!==o&&1&h&&c)if(0===o)c.beforeEnter(a),n(a,t,i),ss(()=>c.enter(a),s);else{const{leave:o,delayLeave:s,afterLeave:l}=c,d=()=>{e.ctx.isUnmounted?r(a):n(a,t,i)},h=()=>{a._isLeaving&&a[_r](!0),o(a,()=>{d(),l&&l()})};s?s(a,d,h):h()}else n(a,t,i)},j=(e,t,n,r=!1,i=!1)=>{const{type:o,props:s,ref:a,children:l,dynamicChildren:c,shapeFlag:d,patchFlag:h,dirs:u,cacheIndex:p}=e;if(-2===h&&(i=!1),null!=a&&(ze(),Gr(a,null,n,e,!0),We()),null!=p&&(t.renderCache[p]=void 0),256&d)return void t.ctx.deactivate(e);const f=1&d&&u,g=!fi(e);let m;if(g&&(m=s&&s.onVnodeBeforeUnmount)&&na(m,t,e),6&d)G(e.component,n,r);else{if(128&d)return void e.suspense.unmount(n,r);f&&rr(e,null,t,"beforeUnmount"),64&d?e.type.remove(e,t,n,Z,r):c&&!c.hasOnce&&(o!==Ss||h>0&&64&h)?Y(c,t,n,!1,!0):(o===Ss&&384&h||!i&&16&d)&&Y(l,t,n),r&&q(e)}(g&&(m=s&&s.onVnodeUnmounted)||f)&&ss(()=>{m&&na(m,t,e),f&&rr(e,null,t,"unmounted")},n)},q=e=>{const{type:t,el:n,anchor:i,transition:o}=e;if(t===Ss)return void U(n,i);if(t===_s)return void w(e);const s=()=>{r(n),o&&!o.persisted&&o.afterLeave&&o.afterLeave()};if(1&e.shapeFlag&&o&&!o.persisted){const{leave:t,delayLeave:r}=o,i=()=>t(n,s);r?r(e.el,s,i):i()}else s()},U=(e,t)=>{let n;for(;e!==t;)n=g(e),r(e),e=n;r(t)},G=(e,t,n)=>{const{bum:r,scope:i,job:o,subTree:s,um:a,m:l,a:c}=e;gs(l),gs(c),r&&Q(r),i.stop(),o&&(o.flags|=8,j(s,e,t,n)),a&&ss(a,t),ss(()=>{e.isUnmounted=!0},t)},Y=(e,t,n,r=!1,i=!1,o=0)=>{for(let s=o;s<e.length;s++)j(e[s],t,n,r,i)},X=e=>{if(6&e.shapeFlag)return X(e.component.subTree);if(128&e.shapeFlag)return e.suspense.next();const t=g(e.anchor||e.el),n=t&&t[mr];return n?g(n):t};let J=!1;const K=(e,t,n)=>{let r;null==e?t._vnode&&(j(t._vnode,null,null,!0),r=t._vnode.component):A(t._vnode||null,e,t,null,null,null,n),t._vnode=e,J||(J=!0,Wn(r),$n(),J=!1)},Z={p:A,um:j,m:H,r:q,mt:I,mc:O,pc:V,pbc:T,n:X,o:e};let ee,te;return t&&([ee,te]=t(Z)),{render:K,hydrate:ee,createApp:Do(K,ee)}}function ds({type:e,props:t},n){return"svg"===n&&"foreignObject"===e||"mathml"===n&&"annotation-xml"===e&&t&&t.encoding&&t.encoding.includes("html")?void 0:n}function hs({effect:e,job:t},n){n?(e.flags|=32,t.flags|=4):(e.flags&=-33,t.flags&=-5)}function us(e,t){return(!e||e&&!e.pendingBranch)&&t&&!t.persisted}function ps(e,t,n=!1){const r=e.children,i=t.children;if(g(r)&&g(i))for(let t=0;t<r.length;t++){const o=r[t];let s=i[t];1&s.shapeFlag&&!s.dynamicChildren&&((s.patchFlag<=0||32===s.patchFlag)&&(s=i[t]=Zs(i[t]),s.el=o.el),n||-2===s.patchFlag||ps(o,s)),s.type===Os&&(-1!==s.patchFlag?s.el=o.el:s.__elIndex=t+(e.type===Ss?1:0)),s.type!==Bs||s.el||(s.el=o.el)}}function fs(e){const t=e.subTree.component;if(t)return t.asyncDep&&!t.asyncResolved?t:fs(t)}function gs(e){if(e)for(let t=0;t<e.length;t++)e[t].flags|=8}function ms(e){if(e.placeholder)return e.placeholder;const t=e.component;return t?ms(t.subTree):null}const vs=e=>e.__isSuspense;let As=0;const bs={name:"Suspense",__isSuspense:!0,process(e,t,n,r,i,o,s,a,l,c){if(null==e)!function(e,t,n,r,i,o,s,a,l){const{p:c,o:{createElement:d}}=l,h=d("div"),u=e.suspense=xs(e,i,r,t,h,n,o,s,a,l);c(null,u.pendingBranch=e.ssContent,h,null,r,u,o,s),u.deps>0?(ys(e,"onPending"),ys(e,"onFallback"),c(null,e.ssFallback,t,n,r,null,o,s),ks(u,e.ssFallback)):u.resolve(!1,!0)}(t,n,r,i,o,s,a,l,c);else{if(o&&o.deps>0&&!e.suspense.isInFallback)return t.suspense=e.suspense,t.suspense.vnode=t,void(t.el=e.el);!function(e,t,n,r,i,o,s,a,{p:l,um:c,o:{createElement:d}}){const h=t.suspense=e.suspense;h.vnode=t,t.el=e.el;const u=t.ssContent,p=t.ssFallback,{activeBranch:f,pendingBranch:g,isInFallback:m,isHydrating:v}=h;if(g)h.pendingBranch=u,Vs(g,u)?(l(g,u,h.hiddenContainer,null,i,h,o,s,a),h.deps<=0?h.resolve():m&&(v||(l(f,p,n,r,i,null,o,s,a),ks(h,p)))):(h.pendingId=As++,v?(h.isHydrating=!1,h.activeBranch=g):c(g,i,h),h.deps=0,h.effects.length=0,h.hiddenContainer=d("div"),m?(l(null,u,h.hiddenContainer,null,i,h,o,s,a),h.deps<=0?h.resolve():(l(f,p,n,r,i,null,o,s,a),ks(h,p))):f&&Vs(f,u)?(l(f,u,n,r,i,h,o,s,a),h.resolve(!0)):(l(null,u,h.hiddenContainer,null,i,h,o,s,a),h.deps<=0&&h.resolve()));else if(f&&Vs(f,u))l(f,u,n,r,i,h,o,s,a),ks(h,u);else if(ys(t,"onPending"),h.pendingBranch=u,512&u.shapeFlag?h.pendingId=u.component.suspenseId:h.pendingId=As++,l(null,u,h.hiddenContainer,null,i,h,o,s,a),h.deps<=0)h.resolve();else{const{timeout:e,pendingId:t}=h;e>0?setTimeout(()=>{h.pendingId===t&&h.fallback(p)},e):0===e&&h.fallback(p)}}(e,t,n,r,i,s,a,l,c)}},hydrate:function(e,t,n,r,i,o,s,a,l){const c=t.suspense=xs(t,r,n,e.parentNode,document.createElement("div"),null,i,o,s,a,!0),d=l(e,c.pendingBranch=t.ssContent,n,c,o,s);0===c.deps&&c.resolve(!1,!0);return d},normalize:function(e){const{shapeFlag:t,children:n}=e,r=32&t;e.ssContent=ws(r?n.default:n),e.ssFallback=r?ws(n.fallback):js(Bs)}};function ys(e,t){const n=e.props&&e.props[t];b(n)&&n()}function xs(e,t,n,r,i,o,s,a,l,c,d=!1){const{p:h,m:u,um:p,n:f,o:{parentNode:g,remove:m}}=c;let v;const A=function(e){const t=e.props&&e.props.suspensible;return null!=t&&!1!==t}(e);A&&t&&t.pendingBranch&&(v=t.pendingId,t.deps++);const b=e.props?z(e.props.timeout):void 0;const y=o,x={vnode:e,parent:t,parentComponent:n,namespace:s,container:r,hiddenContainer:i,deps:0,pendingId:As++,timeout:"number"==typeof b?b:-1,activeBranch:null,pendingBranch:null,isInFallback:!d,isHydrating:d,isUnmounted:!1,effects:[],resolve(e=!1,n=!1){const{vnode:r,activeBranch:i,pendingBranch:s,pendingId:a,effects:l,parentComponent:c,container:d,isInFallback:h}=x;let m=!1;x.isHydrating?x.isHydrating=!1:e||(m=i&&s.transition&&"out-in"===s.transition.mode,m&&(i.transition.afterLeave=()=>{a===x.pendingId&&(u(s,d,o===y?f(i):o,0),zn(l),h&&r.ssFallback&&(r.ssFallback.el=null))}),i&&(g(i.el)===d&&(o=f(i)),p(i,c,x,!0),!m&&h&&r.ssFallback&&ss(()=>r.ssFallback.el=null,x)),m||u(s,d,o,0)),ks(x,s),x.pendingBranch=null,x.isInFallback=!1;let b=x.parent,w=!1;for(;b;){if(b.pendingBranch){b.effects.push(...l),w=!0;break}b=b.parent}w||m||zn(l),x.effects=[],A&&t&&t.pendingBranch&&v===t.pendingId&&(t.deps--,0!==t.deps||n||t.resolve()),ys(r,"onResolve")},fallback(e){if(!x.pendingBranch)return;const{vnode:t,activeBranch:n,parentComponent:r,container:i,namespace:o}=x;ys(t,"onFallback");const s=f(n),c=()=>{x.isInFallback&&(h(null,e,i,s,r,null,o,a,l),ks(x,e))},d=e.transition&&"out-in"===e.transition.mode;d&&(n.transition.afterLeave=c),x.isInFallback=!0,p(n,r,null,!0),d||c()},move(e,t,n){x.activeBranch&&u(x.activeBranch,e,t,n),x.container=e},next:()=>x.activeBranch&&f(x.activeBranch),registerDep(e,t,n){const r=!!x.pendingBranch;r&&x.deps++;const i=e.vnode.el;e.asyncDep.catch(t=>{En(t,e,0)}).then(o=>{if(e.isUnmounted||x.isUnmounted||x.pendingId!==e.suspenseId)return;e.asyncResolved=!0;const{vnode:a}=e;va(e,o,!1),i&&(a.el=i);const l=!i&&e.subTree.el;t(e,a,g(i||e.subTree.el),i?null:f(e.subTree),x,s,n),l&&(a.placeholder=null,m(l)),jo(e,a.el),r&&0===--x.deps&&x.resolve()})},unmount(e,t){x.isUnmounted=!0,x.activeBranch&&p(x.activeBranch,n,e,t),x.pendingBranch&&p(x.pendingBranch,n,e,t)}};return x}function ws(e){let t;if(b(e)){const n=Rs&&e._c;n&&(e._d=!1,Ms()),e=e(),n&&(e._d=!0,t=Es,Ds())}if(g(e)){const t=zo(e);0,e=t}return e=Ks(e),t&&!e.dynamicChildren&&(e.dynamicChildren=t.filter(t=>t!==e)),e}function Cs(e,t){t&&t.pendingBranch?g(e)?t.effects.push(...e):t.effects.push(e):zn(e)}function ks(e,t){e.activeBranch=t;const{vnode:n,parentComponent:r}=e;let i=t.el;for(;!i&&t.component;)i=(t=t.component.subTree).el;n.el=i,r&&r.subTree===n&&(r.vnode.el=i,jo(r,i))}const Ss=Symbol.for("v-fgt"),Os=Symbol.for("v-txt"),Bs=Symbol.for("v-cmt"),_s=Symbol.for("v-stc"),Ts=[];let Es=null;function Ms(e=!1){Ts.push(Es=e?null:[])}function Ds(){Ts.pop(),Es=Ts[Ts.length-1]||null}let Ps,Rs=1;function Is(e,t=!1){Rs+=e,e<0&&Es&&t&&(Es.hasOnce=!0)}function Ns(e){return e.dynamicChildren=Rs>0?Es||s:null,Ds(),Rs>0&&Es&&Es.push(e),e}function Ls(e,t,n,r,i,o){return Ns(Hs(e,t,n,r,i,o,!0))}function Qs(e,t,n,r,i){return Ns(js(e,t,n,r,i,!0))}function Fs(e){return!!e&&!0===e.__v_isVNode}function Vs(e,t){return e.type===t.type&&e.key===t.key}function zs(e){Ps=e}const Ws=({key:e})=>null!=e?e:null,$s=({ref:e,ref_key:t,ref_for:n})=>("number"==typeof e&&(e=""+e),null!=e?y(e)||Ut(e)||b(e)?{i:Yn,r:e,k:t,f:!!n}:e:null);function Hs(e,t=null,n=null,r=0,i=null,o=(e===Ss?0:1),s=!1,a=!1){const l={__v_isVNode:!0,__v_skip:!0,type:e,props:t,key:t&&Ws(t),ref:t&&$s(t),scopeId:Xn,slotScopeIds:null,children:n,component:null,suspense:null,ssContent:null,ssFallback:null,dirs:null,transition:null,el:null,anchor:null,target:null,targetStart:null,targetAnchor:null,staticCount:0,shapeFlag:o,patchFlag:r,dynamicProps:i,dynamicChildren:null,appContext:null,ctx:Yn};return a?(ea(l,n),128&o&&e.normalize(l)):n&&(l.shapeFlag|=y(n)?8:16),Rs>0&&!s&&Es&&(l.patchFlag>0||6&o)&&32!==l.patchFlag&&Es.push(l),l}const js=qs;function qs(e,t=null,n=null,r=0,i=null,o=!1){if(e&&e!==zi||(e=Bs),Fs(e)){const r=Gs(e,t,!0);return n&&ea(r,n),Rs>0&&!o&&Es&&(6&r.shapeFlag?Es[Es.indexOf(e)]=r:Es.push(r)),r.patchFlag=-2,r}if(Ba(e)&&(e=e.__vccOpts),t){t=Us(t);let{class:e,style:n}=t;e&&!y(e)&&(t.class=X(e)),w(n)&&(Wt(n)&&!g(n)&&(n=h({},n)),t.style=j(n))}return Hs(e,t,n,r,i,y(e)?1:vs(e)?128:vr(e)?64:w(e)?4:b(e)?2:0,o,!0)}function Us(e){return e?Wt(e)||Go(e)?h({},e):e:null}function Gs(e,t,n=!1,r=!1){const{props:i,ref:o,patchFlag:s,children:a,transition:l}=e,c=t?ta(i||{},t):i,d={__v_isVNode:!0,__v_skip:!0,type:e.type,props:c,key:c&&Ws(c),ref:t&&t.ref?n&&o?g(o)?o.concat($s(t)):[o,$s(t)]:$s(t):o,scopeId:e.scopeId,slotScopeIds:e.slotScopeIds,children:a,target:e.target,targetStart:e.targetStart,targetAnchor:e.targetAnchor,staticCount:e.staticCount,shapeFlag:e.shapeFlag,patchFlag:t&&e.type!==Ss?-1===s?16:16|s:s,dynamicProps:e.dynamicProps,dynamicChildren:e.dynamicChildren,appContext:e.appContext,dirs:e.dirs,transition:l,component:e.component,suspense:e.suspense,ssContent:e.ssContent&&Gs(e.ssContent),ssFallback:e.ssFallback&&Gs(e.ssFallback),placeholder:e.placeholder,el:e.el,anchor:e.anchor,ctx:e.ctx,ce:e.ce};return l&&r&&zr(d,l.clone(d)),d}function Ys(e=" ",t=0){return js(Os,null,e,t)}function Xs(e,t){const n=js(_s,null,e);return n.staticCount=t,n}function Js(e="",t=!1){return t?(Ms(),Qs(Bs,null,e)):js(Bs,null,e)}function Ks(e){return null==e||"boolean"==typeof e?js(Bs):g(e)?js(Ss,null,e.slice()):Fs(e)?Zs(e):js(Os,null,String(e))}function Zs(e){return null===e.el&&-1!==e.patchFlag||e.memo?e:Gs(e)}function ea(e,t){let n=0;const{shapeFlag:r}=e;if(null==t)t=null;else if(g(t))n=16;else if("object"==typeof t){if(65&r){const n=t.default;return void(n&&(n._c&&(n._d=!1),ea(e,n()),n._c&&(n._d=!0)))}{n=32;const r=t._;r||Go(t)?3===r&&Yn&&(1===Yn.slots._?t._=1:(t._=2,e.patchFlag|=1024)):t._ctx=Yn}}else b(t)?(t={default:t,_ctx:Yn},n=32):(t=String(t),64&r?(n=16,t=[Ys(t)]):n=8);e.children=t,e.shapeFlag|=n}function ta(...e){const t={};for(let n=0;n<e.length;n++){const r=e[n];for(const e in r)if("class"===e)t.class!==r.class&&(t.class=X([t.class,r.class]));else if("style"===e)t.style=j([t.style,r.style]);else if(c(e)){const n=t[e],i=r[e];!i||n===i||g(n)&&n.includes(i)||(t[e]=n?[].concat(n,i):i)}else""!==e&&(t[e]=r[e])}return t}function na(e,t,n,r=null){Tn(e,t,7,[n,r])}const ra=Eo();let ia=0;function oa(e,t,n){const r=e.type,i=(t?t.appContext:e.appContext)||ra,s={uid:ia++,vnode:e,type:r,parent:t,appContext:i,root:null,next:null,subTree:null,effect:null,update:null,job:null,scope:new be(!0),render:null,proxy:null,exposed:null,exposeProxy:null,withProxy:null,provides:t?t.provides:Object.create(i.provides),ids:t?t.ids:["",0,0],accessCache:null,renderCache:[],components:null,directives:null,propsOptions:Ko(r,i),emitsOptions:Qo(r,i),emit:null,emitted:null,propsDefaults:o,inheritAttrs:r.inheritAttrs,ctx:o,data:o,props:o,attrs:o,slots:o,refs:o,setupState:o,setupContext:null,suspense:n,suspenseId:n?n.pendingId:0,asyncDep:null,asyncResolved:!1,isMounted:!1,isUnmounted:!1,isDeactivated:!1,bc:null,c:null,bm:null,m:null,bu:null,u:null,um:null,bum:null,da:null,a:null,rtg:null,rtc:null,ec:null,sp:null};return s.ctx={_:s},s.root=t?t.root:s,s.emit=No.bind(null,s),e.ce&&e.ce(s),s}let sa=null;const aa=()=>sa||Yn;let la,ca;{const e=$(),t=(t,n)=>{let r;return(r=e[t])||(r=e[t]=[]),r.push(n),e=>{r.length>1?r.forEach(t=>t(e)):r[0](e)}};la=t("__VUE_INSTANCE_SETTERS__",e=>sa=e),ca=t("__VUE_SSR_SETTERS__",e=>ga=e)}const da=e=>{const t=sa;return la(e),e.scope.on(),()=>{e.scope.off(),la(t)}},ha=()=>{sa&&sa.scope.off(),la(null)};function ua(e){return 4&e.vnode.shapeFlag}let pa,fa,ga=!1;function ma(e,t=!1,n=!1){t&&ca(t);const{props:r,children:i}=e.vnode,o=ua(e);!function(e,t,n,r=!1){const i={},o=Uo();e.propsDefaults=Object.create(null),Yo(e,t,i,o);for(const t in e.propsOptions[0])t in i||(i[t]=void 0);n?e.props=r?i:It(i):e.type.props?e.props=i:e.props=o,e.attrs=o}(e,r,o,t),((e,t,n)=>{const r=e.slots=Uo();if(32&e.vnode.shapeFlag){const e=t._;e?(os(r,t,n),n&&F(r,"_",e,!0)):rs(t,r)}else t&&is(e,t)})(e,i,n||t);const s=o?function(e,t){const n=e.type;0;e.accessCache=Object.create(null),e.proxy=new Proxy(e.ctx,eo),!1;const{setup:r}=n;if(r){ze();const n=e.setupContext=r.length>1?wa(e):null,i=da(e),o=_n(r,e,0,[e.props,n]),s=C(o);if(We(),i(),!s&&!e.sp||fi(e)||jr(e),s){if(o.then(ha,ha),t)return o.then(n=>{va(e,n,t)}).catch(t=>{En(t,e,0)});e.asyncDep=o}else va(e,o,t)}else ya(e,t)}(e,t):void 0;return t&&ca(!1),s}function va(e,t,n){b(t)?e.type.__ssrInlineRender?e.ssrRender=t:e.render=t:w(t)&&(e.setupState=nn(t)),ya(e,n)}function Aa(e){pa=e,fa=e=>{e.render._rc&&(e.withProxy=new Proxy(e.ctx,to))}}const ba=()=>!pa;function ya(e,t,n){const r=e.type;if(!e.render){if(!t&&pa&&!r.render){const t=r.template||wo(e).template;if(t){0;const{isCustomElement:n,compilerOptions:i}=e.appContext.config,{delimiters:o,compilerOptions:s}=r,a=h(h({isCustomElement:n,delimiters:o},i),s);r.render=pa(t,a)}}e.render=r.render||a,fa&&fa(e)}{const t=da(e);ze();try{bo(e)}finally{We(),t()}}}const xa={get:(e,t)=>(Ke(e,0,""),e[t])};function wa(e){const t=t=>{e.exposed=t||{}};return{attrs:new Proxy(e.attrs,xa),slots:e.slots,emit:e.emit,expose:t}}function Ca(e){return e.exposed?e.exposeProxy||(e.exposeProxy=new Proxy(nn(Ht(e.exposed)),{get:(t,n)=>n in t?t[n]:n in Ki?Ki[n](e):void 0,has:(e,t)=>t in e||t in Ki})):e.proxy}const ka=/(?:^|[-_])\w/g;function Sa(e,t=!0){return b(e)?e.displayName||e.name:e.name||t&&e.__name}function Oa(e,t,n=!1){let r=Sa(t);if(!r&&t.__file){const e=t.__file.match(/([^/\\]+)\.\w+$/);e&&(r=e[1])}if(!r&&e){const n=e=>{for(const n in e)if(e[n]===t)return n};r=n(e.components)||e.parent&&n(e.parent.type.components)||n(e.appContext.components)}return r?r.replace(ka,e=>e.toUpperCase()).replace(/[-_]/g,""):n?"App":"Anonymous"}function Ba(e){return b(e)&&"__vccOpts"in e}const _a=(e,t)=>{const n=function(e,t,n=!1){let r,i;return b(e)?r=e:(r=e.get,i=e.set),new hn(r,i,n)}(e,0,ga);return n};function Ta(e,t,n){try{Is(-1);const r=arguments.length;return 2===r?w(t)&&!g(t)?Fs(t)?js(e,null,[t]):js(e,t):js(e,null,t):(r>3?n=Array.prototype.slice.call(arguments,2):3===r&&Fs(n)&&(n=[n]),js(e,t,n))}finally{Is(1)}}function Ea(){return void 0}function Ma(e,t,n,r){const i=n[r];if(i&&Da(i,e))return i;const o=t();return o.memo=e.slice(),o.cacheIndex=r,n[r]=o}function Da(e,t){const n=e.memo;if(n.length!=t.length)return!1;for(let e=0;e<n.length;e++)if(L(n[e],t[e]))return!1;return Rs>0&&Es&&Es.push(e),!0}const Pa="3.5.27",Ra=a,Ia=Bn,Na=qn,La=function e(t,n){var r,i;if(qn=t,qn)qn.enabled=!0,Un.forEach(({event:e,args:t})=>qn.emit(e,...t)),Un=[];else if("undefined"!=typeof window&&window.HTMLElement&&!(null==(i=null==(r=window.navigator)?void 0:r.userAgent)?void 0:i.includes("jsdom"))){(n.__VUE_DEVTOOLS_HOOK_REPLAY__=n.__VUE_DEVTOOLS_HOOK_REPLAY__||[]).push(t=>{e(t,n)}),setTimeout(()=>{qn||(n.__VUE_DEVTOOLS_HOOK_REPLAY__=null,Gn=!0,Un=[])},3e3)}else Gn=!0,Un=[]},Qa={createComponentInstance:oa,setupComponent:ma,renderComponentRoot:Vo,setCurrentRenderingInstance:Jn,isVNode:Fs,normalizeVNode:Ks,getComponentPublicInstance:Ca,ensureValidVNode:Yi,pushWarningContext:function(e){yn.push(e)},popWarningContext:function(){yn.pop()}},Fa=null,Va=null,za=null;let Wa;const $a="undefined"!=typeof window&&window.trustedTypes;if($a)try{Wa=$a.createPolicy("vue",{createHTML:e=>e})}catch(SR){}const Ha=Wa?e=>Wa.createHTML(e):e=>e,ja="undefined"!=typeof document?document:null,qa=ja&&ja.createElement("template"),Ua={insert:(e,t,n)=>{t.insertBefore(e,n||null)},remove:e=>{const t=e.parentNode;t&&t.removeChild(e)},createElement:(e,t,n,r)=>{const i="svg"===t?ja.createElementNS("http://www.w3.org/2000/svg",e):"mathml"===t?ja.createElementNS("http://www.w3.org/1998/Math/MathML",e):n?ja.createElement(e,{is:n}):ja.createElement(e);return"select"===e&&r&&null!=r.multiple&&i.setAttribute("multiple",r.multiple),i},createText:e=>ja.createTextNode(e),createComment:e=>ja.createComment(e),setText:(e,t)=>{e.nodeValue=t},setElementText:(e,t)=>{e.textContent=t},parentNode:e=>e.parentNode,nextSibling:e=>e.nextSibling,querySelector:e=>ja.querySelector(e),setScopeId(e,t){e.setAttribute(t,"")},insertStaticContent(e,t,n,r,i,o){const s=n?n.previousSibling:t.lastChild;if(i&&(i===o||i.nextSibling))for(;t.insertBefore(i.cloneNode(!0),n),i!==o&&(i=i.nextSibling););else{qa.innerHTML=Ha("svg"===r?`<svg>${e}</svg>`:"mathml"===r?`<math>${e}</math>`:e);const i=qa.content;if("svg"===r||"mathml"===r){const e=i.firstChild;for(;e.firstChild;)i.appendChild(e.firstChild);i.removeChild(e)}t.insertBefore(i,n)}return[s?s.nextSibling:t.firstChild,n?n.previousSibling:t.lastChild]}},Ga="transition",Ya="animation",Xa=Symbol("_vtc"),Ja={name:String,type:String,css:{type:Boolean,default:!0},duration:[String,Number,Object],enterFromClass:String,enterActiveClass:String,enterToClass:String,appearFromClass:String,appearActiveClass:String,appearToClass:String,leaveFromClass:String,leaveActiveClass:String,leaveToClass:String},Ka=h({},Dr,Ja),Za=e=>(e.displayName="Transition",e.props=Ka,e),el=Za((e,{slots:t})=>Ta(Nr,rl(e),t)),tl=(e,t=[])=>{g(e)?e.forEach(e=>e(...t)):e&&e(...t)},nl=e=>!!e&&(g(e)?e.some(e=>e.length>1):e.length>1);function rl(e){const t={};for(const n in e)n in Ja||(t[n]=e[n]);if(!1===e.css)return t;const{name:n="v",type:r,duration:i,enterFromClass:o=`${n}-enter-from`,enterActiveClass:s=`${n}-enter-active`,enterToClass:a=`${n}-enter-to`,appearFromClass:l=o,appearActiveClass:c=s,appearToClass:d=a,leaveFromClass:u=`${n}-leave-from`,leaveActiveClass:p=`${n}-leave-active`,leaveToClass:f=`${n}-leave-to`}=e,g=function(e){if(null==e)return null;if(w(e))return[il(e.enter),il(e.leave)];{const t=il(e);return[t,t]}}(i),m=g&&g[0],v=g&&g[1],{onBeforeEnter:A,onEnter:b,onEnterCancelled:y,onLeave:x,onLeaveCancelled:C,onBeforeAppear:k=A,onAppear:S=b,onAppearCancelled:O=y}=t,B=(e,t,n,r)=>{e._enterCancelled=r,sl(e,t?d:a),sl(e,t?c:s),n&&n()},_=(e,t)=>{e._isLeaving=!1,sl(e,u),sl(e,f),sl(e,p),t&&t()},T=e=>(t,n)=>{const i=e?S:b,s=()=>B(t,e,n);tl(i,[t,s]),al(()=>{sl(t,e?l:o),ol(t,e?d:a),nl(i)||cl(t,r,m,s)})};return h(t,{onBeforeEnter(e){tl(A,[e]),ol(e,o),ol(e,s)},onBeforeAppear(e){tl(k,[e]),ol(e,l),ol(e,c)},onEnter:T(!1),onAppear:T(!0),onLeave(e,t){e._isLeaving=!0;const n=()=>_(e,t);ol(e,u),e._enterCancelled?(ol(e,p),pl(e)):(pl(e),ol(e,p)),al(()=>{e._isLeaving&&(sl(e,u),ol(e,f),nl(x)||cl(e,r,v,n))}),tl(x,[e,n])},onEnterCancelled(e){B(e,!1,void 0,!0),tl(y,[e])},onAppearCancelled(e){B(e,!0,void 0,!0),tl(O,[e])},onLeaveCancelled(e){_(e),tl(C,[e])}})}function il(e){return z(e)}function ol(e,t){t.split(/\s+/).forEach(t=>t&&e.classList.add(t)),(e[Xa]||(e[Xa]=new Set)).add(t)}function sl(e,t){t.split(/\s+/).forEach(t=>t&&e.classList.remove(t));const n=e[Xa];n&&(n.delete(t),n.size||(e[Xa]=void 0))}function al(e){requestAnimationFrame(()=>{requestAnimationFrame(e)})}let ll=0;function cl(e,t,n,r){const i=e._endId=++ll,o=()=>{i===e._endId&&r()};if(null!=n)return setTimeout(o,n);const{type:s,timeout:a,propCount:l}=dl(e,t);if(!s)return r();const c=s+"end";let d=0;const h=()=>{e.removeEventListener(c,u),o()},u=t=>{t.target===e&&++d>=l&&h()};setTimeout(()=>{d<l&&h()},a+1),e.addEventListener(c,u)}function dl(e,t){const n=window.getComputedStyle(e),r=e=>(n[e]||"").split(", "),i=r(`${Ga}Delay`),o=r(`${Ga}Duration`),s=hl(i,o),a=r(`${Ya}Delay`),l=r(`${Ya}Duration`),c=hl(a,l);let d=null,h=0,u=0;t===Ga?s>0&&(d=Ga,h=s,u=o.length):t===Ya?c>0&&(d=Ya,h=c,u=l.length):(h=Math.max(s,c),d=h>0?s>c?Ga:Ya:null,u=d?d===Ga?o.length:l.length:0);return{type:d,timeout:h,propCount:u,hasTransform:d===Ga&&/\b(?:transform|all)(?:,|$)/.test(r(`${Ga}Property`).toString())}}function hl(e,t){for(;e.length<t.length;)e=e.concat(e);return Math.max(...t.map((t,n)=>ul(t)+ul(e[n])))}function ul(e){return"auto"===e?0:1e3*Number(e.slice(0,-1).replace(",","."))}function pl(e){return(e?e.ownerDocument:document).body.offsetHeight}const fl=Symbol("_vod"),gl=Symbol("_vsh"),ml={name:"show",beforeMount(e,{value:t},{transition:n}){e[fl]="none"===e.style.display?"":e.style.display,n&&t?n.beforeEnter(e):vl(e,t)},mounted(e,{value:t},{transition:n}){n&&t&&n.enter(e)},updated(e,{value:t,oldValue:n},{transition:r}){!t!=!n&&(r?t?(r.beforeEnter(e),vl(e,!0),r.enter(e)):r.leave(e,()=>{vl(e,!1)}):vl(e,t))},beforeUnmount(e,{value:t}){vl(e,t)}};function vl(e,t){e.style.display=t?e[fl]:"none",e[gl]=!t}const Al=Symbol("");function bl(e){const t=aa();if(!t)return;const n=t.ut=(n=e(t.proxy))=>{Array.from(document.querySelectorAll(`[data-v-owner="${t.uid}"]`)).forEach(e=>xl(e,n))};const r=()=>{const r=e(t.proxy);t.ce?xl(t.ce,r):yl(t.subTree,r),n(r)};Mi(()=>{zn(r)}),Ei(()=>{ur(r,a,{flush:"post"});const e=new MutationObserver(r);e.observe(t.subTree.el.parentNode,{childList:!0}),Ri(()=>e.disconnect())})}function yl(e,t){if(128&e.shapeFlag){const n=e.suspense;e=n.activeBranch,n.pendingBranch&&!n.isHydrating&&n.effects.push(()=>{yl(n.activeBranch,t)})}for(;e.component;)e=e.component.subTree;if(1&e.shapeFlag&&e.el)xl(e.el,t);else if(e.type===Ss)e.children.forEach(e=>yl(e,t));else if(e.type===_s){let{el:n,anchor:r}=e;for(;n&&(xl(n,t),n!==r);)n=n.nextSibling}}function xl(e,t){if(1===e.nodeType){const n=e.style;let r="";for(const e in t){const i=me(t[e]);n.setProperty(`--${e}`,i),r+=`--${e}: ${i};`}n[Al]=r}}const wl=/(?:^|;)\s*display\s*:/;const Cl=/\s*!important$/;function kl(e,t,n){if(g(n))n.forEach(n=>kl(e,t,n));else if(null==n&&(n=""),t.startsWith("--"))e.setProperty(t,n);else{const r=function(e,t){const n=Ol[t];if(n)return n;let r=D(t);if("filter"!==r&&r in e)return Ol[t]=r;r=I(r);for(let n=0;n<Sl.length;n++){const i=Sl[n]+r;if(i in e)return Ol[t]=i}return t}(e,t);Cl.test(n)?e.setProperty(R(r),n.replace(Cl,""),"important"):e[r]=n}}const Sl=["Webkit","Moz","ms"],Ol={};const Bl="http://www.w3.org/1999/xlink";function _l(e,t,n,r,i,o=re(t)){r&&t.startsWith("xlink:")?null==n?e.removeAttributeNS(Bl,t.slice(6,t.length)):e.setAttributeNS(Bl,t,n):null==n||o&&!oe(n)?e.removeAttribute(t):e.setAttribute(t,o?"":x(n)?String(n):n)}function Tl(e,t,n,r,i){if("innerHTML"===t||"textContent"===t)return void(null!=n&&(e[t]="innerHTML"===t?Ha(n):n));const o=e.tagName;if("value"===t&&"PROGRESS"!==o&&!o.includes("-")){const r="OPTION"===o?e.getAttribute("value")||"":e.value,i=null==n?"checkbox"===e.type?"on":"":String(n);return r===i&&"_value"in e||(e.value=i),null==n&&e.removeAttribute(t),void(e._value=n)}let s=!1;if(""===n||null==n){const r=typeof e[t];"boolean"===r?n=oe(n):null==n&&"string"===r?(n="",s=!0):"number"===r&&(n=0,s=!0)}try{e[t]=n}catch(e){0}s&&e.removeAttribute(i||t)}function El(e,t,n,r){e.addEventListener(t,n,r)}const Ml=Symbol("_vei");function Dl(e,t,n,r,i=null){const o=e[Ml]||(e[Ml]={}),s=o[t];if(r&&s)s.value=r;else{const[n,a]=function(e){let t;if(Pl.test(e)){let n;for(t={};n=e.match(Pl);)e=e.slice(0,e.length-n[0].length),t[n[0].toLowerCase()]=!0}const n=":"===e[2]?e.slice(3):R(e.slice(2));return[n,t]}(t);if(r){const s=o[t]=function(e,t){const n=e=>{if(e._vts){if(e._vts<=n.attached)return}else e._vts=Date.now();Tn(function(e,t){if(g(t)){const n=e.stopImmediatePropagation;return e.stopImmediatePropagation=()=>{n.call(e),e._stopped=!0},t.map(e=>t=>!t._stopped&&e&&e(t))}return t}(e,n.value),t,5,[e])};return n.value=e,n.attached=(()=>Rl||(Il.then(()=>Rl=0),Rl=Date.now()))(),n}(r,i);El(e,n,s,a)}else s&&(!function(e,t,n,r){e.removeEventListener(t,n,r)}(e,n,s,a),o[t]=void 0)}}const Pl=/(?:Once|Passive|Capture)$/;let Rl=0;const Il=Promise.resolve();const Nl=e=>111===e.charCodeAt(0)&&110===e.charCodeAt(1)&&e.charCodeAt(2)>96&&e.charCodeAt(2)<123,Ll=(e,t,n,r,i,o)=>{const s="svg"===i;"class"===t?function(e,t,n){const r=e[Xa];r&&(t=(t?[t,...r]:[...r]).join(" ")),null==t?e.removeAttribute("class"):n?e.setAttribute("class",t):e.className=t}(e,r,s):"style"===t?function(e,t,n){const r=e.style,i=y(n);let o=!1;if(n&&!i){if(t)if(y(t))for(const e of t.split(";")){const t=e.slice(0,e.indexOf(":")).trim();null==n[t]&&kl(r,t,"")}else for(const e in t)null==n[e]&&kl(r,e,"");for(const e in n)"display"===e&&(o=!0),kl(r,e,n[e])}else if(i){if(t!==n){const e=r[Al];e&&(n+=";"+e),r.cssText=n,o=wl.test(n)}}else t&&e.removeAttribute("style");fl in e&&(e[fl]=o?r.display:"",e[gl]&&(r.display="none"))}(e,n,r):c(t)?d(t)||Dl(e,t,0,r,o):("."===t[0]?(t=t.slice(1),1):"^"===t[0]?(t=t.slice(1),0):function(e,t,n,r){if(r)return"innerHTML"===t||"textContent"===t||!!(t in e&&Nl(t)&&b(n));if("spellcheck"===t||"draggable"===t||"translate"===t||"autocorrect"===t)return!1;if("sandbox"===t&&"IFRAME"===e.tagName)return!1;if("form"===t)return!1;if("list"===t&&"INPUT"===e.tagName)return!1;if("type"===t&&"TEXTAREA"===e.tagName)return!1;if("width"===t||"height"===t){const t=e.tagName;if("IMG"===t||"VIDEO"===t||"CANVAS"===t||"SOURCE"===t)return!1}if(Nl(t)&&y(n))return!1;return t in e}(e,t,r,s))?(Tl(e,t,r),e.tagName.includes("-")||"value"!==t&&"checked"!==t&&"selected"!==t||_l(e,t,r,s,0,"value"!==t)):!e._isVueCE||!/[A-Z]/.test(t)&&y(r)?("true-value"===t?e._trueValue=r:"false-value"===t&&(e._falseValue=r),_l(e,t,r,s)):Tl(e,D(t),r,0,t)};const Ql={};function Fl(e,t,n){let r=$r(e,t);O(r)&&(r=h({},r,t));class i extends Wl{constructor(e){super(r,e,n)}}return i.def=r,i}const Vl=(e,t)=>Fl(e,t,Mc),zl="undefined"!=typeof HTMLElement?HTMLElement:class{};class Wl extends zl{constructor(e,t={},n=Ec){super(),this._def=e,this._props=t,this._createApp=n,this._isVueCE=!0,this._instance=null,this._app=null,this._nonce=this._def.nonce,this._connected=!1,this._resolved=!1,this._patching=!1,this._dirty=!1,this._numberProps=null,this._styleChildren=new WeakSet,this._ob=null,this.shadowRoot&&n!==Ec?this._root=this.shadowRoot:!1!==e.shadowRoot?(this.attachShadow(h({},e.shadowRootOptions,{mode:"open"})),this._root=this.shadowRoot):this._root=this}connectedCallback(){if(!this.isConnected)return;this.shadowRoot||this._resolved||this._parseSlots(),this._connected=!0;let e=this;for(;e=e&&(e.parentNode||e.host);)if(e instanceof Wl){this._parent=e;break}this._instance||(this._resolved?this._mount(this._def):e&&e._pendingResolve?this._pendingResolve=e._pendingResolve.then(()=>{this._pendingResolve=void 0,this._resolveDef()}):this._resolveDef())}_setParent(e=this._parent){e&&(this._instance.parent=e._instance,this._inheritParentContext(e))}_inheritParentContext(e=this._parent){e&&this._app&&Object.setPrototypeOf(this._app._context.provides,e._instance.provides)}disconnectedCallback(){this._connected=!1,Qn(()=>{this._connected||(this._ob&&(this._ob.disconnect(),this._ob=null),this._app&&this._app.unmount(),this._instance&&(this._instance.ce=void 0),this._app=this._instance=null,this._teleportTargets&&(this._teleportTargets.clear(),this._teleportTargets=void 0))})}_processMutations(e){for(const t of e)this._setAttr(t.attributeName)}_resolveDef(){if(this._pendingResolve)return;for(let e=0;e<this.attributes.length;e++)this._setAttr(this.attributes[e].name);this._ob=new MutationObserver(this._processMutations.bind(this)),this._ob.observe(this,{attributes:!0});const e=(e,t=!1)=>{this._resolved=!0,this._pendingResolve=void 0;const{props:n,styles:r}=e;let i;if(n&&!g(n))for(const e in n){const t=n[e];(t===Number||t&&t.type===Number)&&(e in this._props&&(this._props[e]=z(this._props[e])),(i||(i=Object.create(null)))[D(e)]=!0)}this._numberProps=i,this._resolveProps(e),this.shadowRoot&&this._applyStyles(r),this._mount(e)},t=this._def.__asyncLoader;t?this._pendingResolve=t().then(t=>{t.configureApp=this._def.configureApp,e(this._def=t,!0)}):e(this._def)}_mount(e){this._app=this._createApp(e),this._inheritParentContext(),e.configureApp&&e.configureApp(this._app),this._app._ceVNode=this._createVNode(),this._app.mount(this._root);const t=this._instance&&this._instance.exposed;if(t)for(const e in t)f(this,e)||Object.defineProperty(this,e,{get:()=>Zt(t[e])})}_resolveProps(e){const{props:t}=e,n=g(t)?t:Object.keys(t||{});for(const e of Object.keys(this))"_"!==e[0]&&n.includes(e)&&this._setProp(e,this[e]);for(const e of n.map(D))Object.defineProperty(this,e,{get(){return this._getProp(e)},set(t){this._setProp(e,t,!0,!this._patching)}})}_setAttr(e){if(e.startsWith("data-v-"))return;const t=this.hasAttribute(e);let n=t?this.getAttribute(e):Ql;const r=D(e);t&&this._numberProps&&this._numberProps[r]&&(n=z(n)),this._setProp(r,n,!1,!0)}_getProp(e){return this._props[e]}_setProp(e,t,n=!0,r=!1){if(t!==this._props[e]&&(this._dirty=!0,t===Ql?delete this._props[e]:(this._props[e]=t,"key"===e&&this._app&&(this._app._ceVNode.key=t)),r&&this._instance&&this._update(),n)){const n=this._ob;n&&(this._processMutations(n.takeRecords()),n.disconnect()),!0===t?this.setAttribute(R(e),""):"string"==typeof t||"number"==typeof t?this.setAttribute(R(e),t+""):t||this.removeAttribute(R(e)),n&&n.observe(this,{attributes:!0})}}_update(){const e=this._createVNode();this._app&&(e.appContext=this._app._context),_c(e,this._root)}_createVNode(){const e={};this.shadowRoot||(e.onVnodeMounted=e.onVnodeUpdated=this._renderSlots.bind(this));const t=js(this._def,h(e,this._props));return this._instance||(t.ce=e=>{this._instance=e,e.ce=this,e.isCE=!0;const t=(e,t)=>{this.dispatchEvent(new CustomEvent(e,O(t[0])?h({detail:t},t[0]):{detail:t}))};e.emit=(e,...n)=>{t(e,n),R(e)!==e&&t(R(e),n)},this._setParent()}),t}_applyStyles(e,t){if(!e)return;if(t){if(t===this._def||this._styleChildren.has(t))return;this._styleChildren.add(t)}const n=this._nonce;for(let t=e.length-1;t>=0;t--){const r=document.createElement("style");n&&r.setAttribute("nonce",n),r.textContent=e[t],this.shadowRoot.prepend(r)}}_parseSlots(){const e=this._slots={};let t;for(;t=this.firstChild;){const n=1===t.nodeType&&t.getAttribute("slot")||"default";(e[n]||(e[n]=[])).push(t),this.removeChild(t)}}_renderSlots(){const e=this._getSlots(),t=this._instance.type.__scopeId;for(let n=0;n<e.length;n++){const r=e[n],i=r.getAttribute("name")||"default",o=this._slots[i],s=r.parentNode;if(o)for(const e of o){if(t&&1===e.nodeType){const n=t+"-s",r=document.createTreeWalker(e,1);let i;for(e.setAttribute(n,"");i=r.nextNode();)i.setAttribute(n,"")}s.insertBefore(e,r)}else for(;r.firstChild;)s.insertBefore(r.firstChild,r);s.removeChild(r)}}_getSlots(){const e=[this];this._teleportTargets&&e.push(...this._teleportTargets);const t=new Set;for(const n of e){const e=n.querySelectorAll("slot");for(let n=0;n<e.length;n++)t.add(e[n])}return Array.from(t)}_injectChildStyle(e){this._applyStyles(e.styles,e)}_beginPatch(){this._patching=!0,this._dirty=!1}_endPatch(){this._patching=!1,this._dirty&&this._instance&&this._update()}_removeChildStyle(e){0}}function $l(e){const t=aa(),n=t&&t.ce;return n||null}function Hl(){const e=$l();return e&&e.shadowRoot}function jl(e="$style"){{const t=aa();if(!t)return o;const n=t.type.__cssModules;if(!n)return o;const r=n[e];return r||o}}const ql=new WeakMap,Ul=new WeakMap,Gl=Symbol("_moveCb"),Yl=Symbol("_enterCb"),Xl=e=>(delete e.props.mode,e),Jl=Xl({name:"TransitionGroup",props:h({},Ka,{tag:String,moveClass:String}),setup(e,{slots:t}){const n=aa(),r=Er();let i,o;return Di(()=>{if(!i.length)return;const t=e.moveClass||`${e.name||"v"}-move`;if(!function(e,t,n){const r=e.cloneNode(),i=e[Xa];i&&i.forEach(e=>{e.split(/\s+/).forEach(e=>e&&r.classList.remove(e))});n.split(/\s+/).forEach(e=>e&&r.classList.add(e)),r.style.display="none";const o=1===t.nodeType?t:t.parentNode;o.appendChild(r);const{hasTransform:s}=dl(r);return o.removeChild(r),s}(i[0].el,n.vnode.el,t))return void(i=[]);i.forEach(Zl),i.forEach(ec);const r=i.filter(tc);pl(n.vnode.el),r.forEach(e=>{const n=e.el,r=n.style;ol(n,t),r.transform=r.webkitTransform=r.transitionDuration="";const i=n[Gl]=e=>{e&&e.target!==n||e&&!e.propertyName.endsWith("transform")||(n.removeEventListener("transitionend",i),n[Gl]=null,sl(n,t))};n.addEventListener("transitionend",i)}),i=[]}),()=>{const s=$t(e),a=rl(s);let l=s.tag||Ss;if(i=[],o)for(let e=0;e<o.length;e++){const t=o[e];t.el&&t.el instanceof Element&&(i.push(t),zr(t,Qr(t,a,r,n)),ql.set(t,{left:t.el.offsetLeft,top:t.el.offsetTop}))}o=t.default?Wr(t.default()):[];for(let e=0;e<o.length;e++){const t=o[e];null!=t.key&&zr(t,Qr(t,a,r,n))}return js(l,null,o)}}}),Kl=Jl;function Zl(e){const t=e.el;t[Gl]&&t[Gl](),t[Yl]&&t[Yl]()}function ec(e){Ul.set(e,{left:e.el.offsetLeft,top:e.el.offsetTop})}function tc(e){const t=ql.get(e),n=Ul.get(e),r=t.left-n.left,i=t.top-n.top;if(r||i){const t=e.el.style;return t.transform=t.webkitTransform=`translate(${r}px,${i}px)`,t.transitionDuration="0s",e}}const nc=e=>{const t=e.props["onUpdate:modelValue"]||!1;return g(t)?e=>Q(t,e):t};function rc(e){e.target.composing=!0}function ic(e){const t=e.target;t.composing&&(t.composing=!1,t.dispatchEvent(new Event("input")))}const oc=Symbol("_assign");function sc(e,t,n){return t&&(e=e.trim()),n&&(e=V(e)),e}const ac={created(e,{modifiers:{lazy:t,trim:n,number:r}},i){e[oc]=nc(i);const o=r||i.props&&"number"===i.props.type;El(e,t?"change":"input",t=>{t.target.composing||e[oc](sc(e.value,n,o))}),(n||o)&&El(e,"change",()=>{e.value=sc(e.value,n,o)}),t||(El(e,"compositionstart",rc),El(e,"compositionend",ic),El(e,"change",ic))},mounted(e,{value:t}){e.value=null==t?"":t},beforeUpdate(e,{value:t,oldValue:n,modifiers:{lazy:r,trim:i,number:o}},s){if(e[oc]=nc(s),e.composing)return;const a=null==t?"":t;if((!o&&"number"!==e.type||/^0\d/.test(e.value)?e.value:V(e.value))!==a){if(document.activeElement===e&&"range"!==e.type){if(r&&t===n)return;if(i&&e.value.trim()===a)return}e.value=a}}},lc={deep:!0,created(e,t,n){e[oc]=nc(n),El(e,"change",()=>{const t=e._modelValue,n=pc(e),r=e.checked,i=e[oc];if(g(t)){const e=he(t,n),o=-1!==e;if(r&&!o)i(t.concat(n));else if(!r&&o){const n=[...t];n.splice(e,1),i(n)}}else if(v(t)){const e=new Set(t);r?e.add(n):e.delete(n),i(e)}else i(fc(e,r))})},mounted:cc,beforeUpdate(e,t,n){e[oc]=nc(n),cc(e,t,n)}};function cc(e,{value:t,oldValue:n},r){let i;if(e._modelValue=t,g(t))i=he(t,r.props.value)>-1;else if(v(t))i=t.has(r.props.value);else{if(t===n)return;i=de(t,fc(e,!0))}e.checked!==i&&(e.checked=i)}const dc={created(e,{value:t},n){e.checked=de(t,n.props.value),e[oc]=nc(n),El(e,"change",()=>{e[oc](pc(e))})},beforeUpdate(e,{value:t,oldValue:n},r){e[oc]=nc(r),t!==n&&(e.checked=de(t,r.props.value))}},hc={deep:!0,created(e,{value:t,modifiers:{number:n}},r){const i=v(t);El(e,"change",()=>{const t=Array.prototype.filter.call(e.options,e=>e.selected).map(e=>n?V(pc(e)):pc(e));e[oc](e.multiple?i?new Set(t):t:t[0]),e._assigning=!0,Qn(()=>{e._assigning=!1})}),e[oc]=nc(r)},mounted(e,{value:t}){uc(e,t)},beforeUpdate(e,t,n){e[oc]=nc(n)},updated(e,{value:t}){e._assigning||uc(e,t)}};function uc(e,t){const n=e.multiple,r=g(t);if(!n||r||v(t)){for(let i=0,o=e.options.length;i<o;i++){const o=e.options[i],s=pc(o);if(n)if(r){const e=typeof s;o.selected="string"===e||"number"===e?t.some(e=>String(e)===String(s)):he(t,s)>-1}else o.selected=t.has(s);else if(de(pc(o),t))return void(e.selectedIndex!==i&&(e.selectedIndex=i))}n||-1===e.selectedIndex||(e.selectedIndex=-1)}}function pc(e){return"_value"in e?e._value:e.value}function fc(e,t){const n=t?"_trueValue":"_falseValue";return n in e?e[n]:t}const gc={created(e,t,n){vc(e,t,n,null,"created")},mounted(e,t,n){vc(e,t,n,null,"mounted")},beforeUpdate(e,t,n,r){vc(e,t,n,r,"beforeUpdate")},updated(e,t,n,r){vc(e,t,n,r,"updated")}};function mc(e,t){switch(e){case"SELECT":return hc;case"TEXTAREA":return ac;default:switch(t){case"checkbox":return lc;case"radio":return dc;default:return ac}}}function vc(e,t,n,r,i){const o=mc(e.tagName,n.props&&n.props.type)[i];o&&o(e,t,n,r)}const Ac=["ctrl","shift","alt","meta"],bc={stop:e=>e.stopPropagation(),prevent:e=>e.preventDefault(),self:e=>e.target!==e.currentTarget,ctrl:e=>!e.ctrlKey,shift:e=>!e.shiftKey,alt:e=>!e.altKey,meta:e=>!e.metaKey,left:e=>"button"in e&&0!==e.button,middle:e=>"button"in e&&1!==e.button,right:e=>"button"in e&&2!==e.button,exact:(e,t)=>Ac.some(n=>e[`${n}Key`]&&!t.includes(n))},yc=(e,t)=>{const n=e._withMods||(e._withMods={}),r=t.join(".");return n[r]||(n[r]=(n,...r)=>{for(let e=0;e<t.length;e++){const r=bc[t[e]];if(r&&r(n,t))return}return e(n,...r)})},xc={esc:"escape",space:" ",up:"arrow-up",left:"arrow-left",right:"arrow-right",down:"arrow-down",delete:"backspace"},wc=(e,t)=>{const n=e._withKeys||(e._withKeys={}),r=t.join(".");return n[r]||(n[r]=n=>{if(!("key"in n))return;const r=R(n.key);return t.some(e=>e===r||xc[e]===r)?e(n):void 0})},Cc=h({patchProp:Ll},Ua);let kc,Sc=!1;function Oc(){return kc||(kc=as(Cc))}function Bc(){return kc=Sc?kc:ls(Cc),Sc=!0,kc}const _c=(...e)=>{Oc().render(...e)},Tc=(...e)=>{Bc().hydrate(...e)},Ec=(...e)=>{const t=Oc().createApp(...e);const{mount:n}=t;return t.mount=e=>{const r=Pc(e);if(!r)return;const i=t._component;b(i)||i.render||i.template||(i.template=r.innerHTML),1===r.nodeType&&(r.textContent="");const o=n(r,!1,Dc(r));return r instanceof Element&&(r.removeAttribute("v-cloak"),r.setAttribute("data-v-app","")),o},t},Mc=(...e)=>{const t=Bc().createApp(...e);const{mount:n}=t;return t.mount=e=>{const t=Pc(e);if(t)return n(t,!0,Dc(t))},t};function Dc(e){return e instanceof SVGElement?"svg":"function"==typeof MathMLElement&&e instanceof MathMLElement?"mathml":void 0}function Pc(e){if(y(e)){return document.querySelector(e)}return e}let Rc=!1;const Ic=()=>{Rc||(Rc=!0,ac.getSSRProps=({value:e})=>({value:e}),dc.getSSRProps=({value:e},t)=>{if(t.props&&de(t.props.value,e))return{checked:!0}},lc.getSSRProps=({value:e},t)=>{if(g(e)){if(t.props&&he(e,t.props.value)>-1)return{checked:!0}}else if(v(e)){if(t.props&&e.has(t.props.value))return{checked:!0}}else if(e)return{checked:!0}},gc.getSSRProps=(e,t)=>{if("string"!=typeof t.type)return;const n=mc(t.type.toUpperCase(),t.props&&t.props.type);return n.getSSRProps?n.getSSRProps(e,t):void 0},ml.getSSRProps=({value:e})=>{if(!e)return{style:{display:"none"}}})},Nc=Symbol(""),Lc=Symbol(""),Qc=Symbol(""),Fc=Symbol(""),Vc=Symbol(""),zc=Symbol(""),Wc=Symbol(""),$c=Symbol(""),Hc=Symbol(""),jc=Symbol(""),qc=Symbol(""),Uc=Symbol(""),Gc=Symbol(""),Yc=Symbol(""),Xc=Symbol(""),Jc=Symbol(""),Kc=Symbol(""),Zc=Symbol(""),ed=Symbol(""),td=Symbol(""),nd=Symbol(""),rd=Symbol(""),id=Symbol(""),od=Symbol(""),sd=Symbol(""),ad=Symbol(""),ld=Symbol(""),cd=Symbol(""),dd=Symbol(""),hd=Symbol(""),ud=Symbol(""),pd=Symbol(""),fd=Symbol(""),gd=Symbol(""),md=Symbol(""),vd=Symbol(""),Ad=Symbol(""),bd=Symbol(""),yd=Symbol(""),xd={[Nc]:"Fragment",[Lc]:"Teleport",[Qc]:"Suspense",[Fc]:"KeepAlive",[Vc]:"BaseTransition",[zc]:"openBlock",[Wc]:"createBlock",[$c]:"createElementBlock",[Hc]:"createVNode",[jc]:"createElementVNode",[qc]:"createCommentVNode",[Uc]:"createTextVNode",[Gc]:"createStaticVNode",[Yc]:"resolveComponent",[Xc]:"resolveDynamicComponent",[Jc]:"resolveDirective",[Kc]:"resolveFilter",[Zc]:"withDirectives",[ed]:"renderList",[td]:"renderSlot",[nd]:"createSlots",[rd]:"toDisplayString",[id]:"mergeProps",[od]:"normalizeClass",[sd]:"normalizeStyle",[ad]:"normalizeProps",[ld]:"guardReactiveProps",[cd]:"toHandlers",[dd]:"camelize",[hd]:"capitalize",[ud]:"toHandlerKey",[pd]:"setBlockTracking",[fd]:"pushScopeId",[gd]:"popScopeId",[md]:"withCtx",[vd]:"unref",[Ad]:"isRef",[bd]:"withMemo",[yd]:"isMemoSame"};const wd={start:{line:1,column:1,offset:0},end:{line:1,column:1,offset:0},source:""};function Cd(e,t,n,r,i,o,s,a=!1,l=!1,c=!1,d=wd){return e&&(a?(e.helper(zc),e.helper(Pd(e.inSSR,c))):e.helper(Dd(e.inSSR,c)),s&&e.helper(Zc)),{type:13,tag:t,props:n,children:r,patchFlag:i,dynamicProps:o,directives:s,isBlock:a,disableTracking:l,isComponent:c,loc:d}}function kd(e,t=wd){return{type:17,loc:t,elements:e}}function Sd(e,t=wd){return{type:15,loc:t,properties:e}}function Od(e,t){return{type:16,loc:wd,key:y(e)?Bd(e,!0):e,value:t}}function Bd(e,t=!1,n=wd,r=0){return{type:4,loc:n,content:e,isStatic:t,constType:t?3:r}}function _d(e,t=wd){return{type:8,loc:t,children:e}}function Td(e,t=[],n=wd){return{type:14,loc:n,callee:e,arguments:t}}function Ed(e,t=void 0,n=!1,r=!1,i=wd){return{type:18,params:e,returns:t,newline:n,isSlot:r,loc:i}}function Md(e,t,n,r=!0){return{type:19,test:e,consequent:t,alternate:n,newline:r,loc:wd}}function Dd(e,t){return e||t?Hc:jc}function Pd(e,t){return e||t?Wc:$c}function Rd(e,{helper:t,removeHelper:n,inSSR:r}){e.isBlock||(e.isBlock=!0,n(Dd(r,e.isComponent)),t(zc),t(Pd(r,e.isComponent)))}const Id=new Uint8Array([123,123]),Nd=new Uint8Array([125,125]);function Ld(e){return e>=97&&e<=122||e>=65&&e<=90}function Qd(e){return 32===e||10===e||9===e||12===e||13===e}function Fd(e){return 47===e||62===e||Qd(e)}function Vd(e){const t=new Uint8Array(e.length);for(let n=0;n<e.length;n++)t[n]=e.charCodeAt(n);return t}const zd={Cdata:new Uint8Array([67,68,65,84,65,91]),CdataEnd:new Uint8Array([93,93,62]),CommentEnd:new Uint8Array([45,45,62]),ScriptEnd:new Uint8Array([60,47,115,99,114,105,112,116]),StyleEnd:new Uint8Array([60,47,115,116,121,108,101]),TitleEnd:new Uint8Array([60,47,116,105,116,108,101]),TextareaEnd:new Uint8Array([60,47,116,101,120,116,97,114,101,97])};function Wd(e,{compatConfig:t}){const n=t&&t[e];return"MODE"===e?n||3:n}function $d(e,t){const n=Wd("MODE",t),r=Wd(e,t);return 3===n?!0===r:!1!==r}function Hd(e,t,n,...r){return $d(e,t)}function jd(e){throw e}function qd(e){}function Ud(e,t,n,r){const i=new SyntaxError(String(`https://vuejs.org/error-reference/#compiler-${e}`));return i.code=e,i.loc=t,i}const Gd=e=>4===e.type&&e.isStatic;function Yd(e){switch(e){case"Teleport":case"teleport":return Lc;case"Suspense":case"suspense":return Qc;case"KeepAlive":case"keep-alive":return Fc;case"BaseTransition":case"base-transition":return Vc}}const Xd=/^$|^\d|[^\$\w\xA0-\uFFFF]/,Jd=e=>!Xd.test(e),Kd=/[A-Za-z_$\xA0-\uFFFF]/,Zd=/[\.\?\w$\xA0-\uFFFF]/,eh=/\s+[.[]\s*|\s*[.[]\s+/g,th=e=>4===e.type?e.content:e.loc.source,nh=e=>{const t=th(e).trim().replace(eh,e=>e.trim());let n=0,r=[],i=0,o=0,s=null;for(let e=0;e<t.length;e++){const a=t.charAt(e);switch(n){case 0:if("["===a)r.push(n),n=1,i++;else if("("===a)r.push(n),n=2,o++;else if(!(0===e?Kd:Zd).test(a))return!1;break;case 1:"'"===a||'"'===a||"`"===a?(r.push(n),n=3,s=a):"["===a?i++:"]"===a&&(--i||(n=r.pop()));break;case 2:if("'"===a||'"'===a||"`"===a)r.push(n),n=3,s=a;else if("("===a)o++;else if(")"===a){if(e===t.length-1)return!1;--o||(n=r.pop())}break;case 3:a===s&&(n=r.pop(),s=null)}}return!i&&!o},rh=/^\s*(?:async\s*)?(?:\([^)]*?\)|[\w$_]+)\s*(?::[^=]+)?=>|^\s*(?:async\s+)?function(?:\s+[\w$]+)?\s*\(/,ih=e=>rh.test(th(e));function oh(e,t,n=!1){for(let r=0;r<e.props.length;r++){const i=e.props[r];if(7===i.type&&(n||i.exp)&&(y(t)?i.name===t:t.test(i.name)))return i}}function sh(e,t,n=!1,r=!1){for(let i=0;i<e.props.length;i++){const o=e.props[i];if(6===o.type){if(n)continue;if(o.name===t&&(o.value||r))return o}else if("bind"===o.name&&(o.exp||r)&&ah(o.arg,t))return o}}function ah(e,t){return!(!e||!Gd(e)||e.content!==t)}function lh(e){return 5===e.type||2===e.type}function ch(e){return 7===e.type&&"pre"===e.name}function dh(e){return 7===e.type&&"slot"===e.name}function hh(e){return 1===e.type&&3===e.tagType}function uh(e){return 1===e.type&&2===e.tagType}const ph=new Set([ad,ld]);function fh(e,t=[]){if(e&&!y(e)&&14===e.type){const n=e.callee;if(!y(n)&&ph.has(n))return fh(e.arguments[0],t.concat(e))}return[e,t]}function gh(e,t,n){let r,i,o=13===e.type?e.props:e.arguments[2],s=[];if(o&&!y(o)&&14===o.type){const e=fh(o);o=e[0],s=e[1],i=s[s.length-1]}if(null==o||y(o))r=Sd([t]);else if(14===o.type){const e=o.arguments[0];y(e)||15!==e.type?o.callee===cd?r=Td(n.helper(id),[Sd([t]),o]):o.arguments.unshift(Sd([t])):mh(t,e)||e.properties.unshift(t),!r&&(r=o)}else 15===o.type?(mh(t,o)||o.properties.unshift(t),r=o):(r=Td(n.helper(id),[Sd([t]),o]),i&&i.callee===ld&&(i=s[s.length-2]));13===e.type?i?i.arguments[0]=r:e.props=r:i?i.arguments[0]=r:e.arguments[2]=r}function mh(e,t){let n=!1;if(4===e.key.type){const r=e.key.content;n=t.properties.some(e=>4===e.key.type&&e.key.content===r)}return n}function vh(e,t){return`_${t}_${e.replace(/[^\w]/g,(t,n)=>"-"===t?"_":e.charCodeAt(n).toString())}`}const Ah=/([\s\S]*?)\s+(?:in|of)\s+(\S[\s\S]*)/;function bh(e){for(let t=0;t<e.length;t++)if(!Qd(e.charCodeAt(t)))return!1;return!0}function yh(e){return 2===e.type&&bh(e.content)||12===e.type&&yh(e.content)}function xh(e){return 3===e.type||yh(e)}const wh={parseMode:"base",ns:0,delimiters:["{{","}}"],getNamespace:()=>0,isVoidTag:l,isPreTag:l,isIgnoreNewlineTag:l,isCustomElement:l,onError:jd,onWarn:qd,comments:!1,prefixIdentifiers:!1};let Ch=wh,kh=null,Sh="",Oh=null,Bh=null,_h="",Th=-1,Eh=-1,Mh=0,Dh=!1,Ph=null;const Rh=[],Ih=new class{constructor(e,t){this.stack=e,this.cbs=t,this.state=1,this.buffer="",this.sectionStart=0,this.index=0,this.entityStart=0,this.baseState=1,this.inRCDATA=!1,this.inXML=!1,this.inVPre=!1,this.newlines=[],this.mode=0,this.delimiterOpen=Id,this.delimiterClose=Nd,this.delimiterIndex=-1,this.currentSequence=void 0,this.sequenceIndex=0}get inSFCRoot(){return 2===this.mode&&0===this.stack.length}reset(){this.state=1,this.mode=0,this.buffer="",this.sectionStart=0,this.index=0,this.baseState=1,this.inRCDATA=!1,this.currentSequence=void 0,this.newlines.length=0,this.delimiterOpen=Id,this.delimiterClose=Nd}getPos(e){let t=1,n=e+1;const r=this.newlines.length;let i=-1;if(r>100){let t=-1,n=r;for(;t+1<n;){const r=t+n>>>1;this.newlines[r]<e?t=r:n=r}i=t}else for(let t=r-1;t>=0;t--)if(e>this.newlines[t]){i=t;break}return i>=0&&(t=i+2,n=e-this.newlines[i]),{column:n,line:t,offset:e}}peek(){return this.buffer.charCodeAt(this.index+1)}stateText(e){60===e?(this.index>this.sectionStart&&this.cbs.ontext(this.sectionStart,this.index),this.state=5,this.sectionStart=this.index):this.inVPre||e!==this.delimiterOpen[0]||(this.state=2,this.delimiterIndex=0,this.stateInterpolationOpen(e))}stateInterpolationOpen(e){if(e===this.delimiterOpen[this.delimiterIndex])if(this.delimiterIndex===this.delimiterOpen.length-1){const e=this.index+1-this.delimiterOpen.length;e>this.sectionStart&&this.cbs.ontext(this.sectionStart,e),this.state=3,this.sectionStart=e}else this.delimiterIndex++;else this.inRCDATA?(this.state=32,this.stateInRCDATA(e)):(this.state=1,this.stateText(e))}stateInterpolation(e){e===this.delimiterClose[0]&&(this.state=4,this.delimiterIndex=0,this.stateInterpolationClose(e))}stateInterpolationClose(e){e===this.delimiterClose[this.delimiterIndex]?this.delimiterIndex===this.delimiterClose.length-1?(this.cbs.oninterpolation(this.sectionStart,this.index+1),this.inRCDATA?this.state=32:this.state=1,this.sectionStart=this.index+1):this.delimiterIndex++:(this.state=3,this.stateInterpolation(e))}stateSpecialStartSequence(e){const t=this.sequenceIndex===this.currentSequence.length;if(t?Fd(e):(32|e)===this.currentSequence[this.sequenceIndex]){if(!t)return void this.sequenceIndex++}else this.inRCDATA=!1;this.sequenceIndex=0,this.state=6,this.stateInTagName(e)}stateInRCDATA(e){if(this.sequenceIndex===this.currentSequence.length){if(62===e||Qd(e)){const t=this.index-this.currentSequence.length;if(this.sectionStart<t){const e=this.index;this.index=t,this.cbs.ontext(this.sectionStart,t),this.index=e}return this.sectionStart=t+2,this.stateInClosingTagName(e),void(this.inRCDATA=!1)}this.sequenceIndex=0}(32|e)===this.currentSequence[this.sequenceIndex]?this.sequenceIndex+=1:0===this.sequenceIndex?this.currentSequence===zd.TitleEnd||this.currentSequence===zd.TextareaEnd&&!this.inSFCRoot?this.inVPre||e!==this.delimiterOpen[0]||(this.state=2,this.delimiterIndex=0,this.stateInterpolationOpen(e)):this.fastForwardTo(60)&&(this.sequenceIndex=1):this.sequenceIndex=Number(60===e)}stateCDATASequence(e){e===zd.Cdata[this.sequenceIndex]?++this.sequenceIndex===zd.Cdata.length&&(this.state=28,this.currentSequence=zd.CdataEnd,this.sequenceIndex=0,this.sectionStart=this.index+1):(this.sequenceIndex=0,this.state=23,this.stateInDeclaration(e))}fastForwardTo(e){for(;++this.index<this.buffer.length;){const t=this.buffer.charCodeAt(this.index);if(10===t&&this.newlines.push(this.index),t===e)return!0}return this.index=this.buffer.length-1,!1}stateInCommentLike(e){e===this.currentSequence[this.sequenceIndex]?++this.sequenceIndex===this.currentSequence.length&&(this.currentSequence===zd.CdataEnd?this.cbs.oncdata(this.sectionStart,this.index-2):this.cbs.oncomment(this.sectionStart,this.index-2),this.sequenceIndex=0,this.sectionStart=this.index+1,this.state=1):0===this.sequenceIndex?this.fastForwardTo(this.currentSequence[0])&&(this.sequenceIndex=1):e!==this.currentSequence[this.sequenceIndex-1]&&(this.sequenceIndex=0)}startSpecial(e,t){this.enterRCDATA(e,t),this.state=31}enterRCDATA(e,t){this.inRCDATA=!0,this.currentSequence=e,this.sequenceIndex=t}stateBeforeTagName(e){33===e?(this.state=22,this.sectionStart=this.index+1):63===e?(this.state=24,this.sectionStart=this.index+1):Ld(e)?(this.sectionStart=this.index,0===this.mode?this.state=6:this.inSFCRoot?this.state=34:this.inXML?this.state=6:this.state=116===e?30:115===e?29:6):47===e?this.state=8:(this.state=1,this.stateText(e))}stateInTagName(e){Fd(e)&&this.handleTagName(e)}stateInSFCRootTagName(e){if(Fd(e)){const t=this.buffer.slice(this.sectionStart,this.index);"template"!==t&&this.enterRCDATA(Vd("</"+t),0),this.handleTagName(e)}}handleTagName(e){this.cbs.onopentagname(this.sectionStart,this.index),this.sectionStart=-1,this.state=11,this.stateBeforeAttrName(e)}stateBeforeClosingTagName(e){Qd(e)||(62===e?(this.state=1,this.sectionStart=this.index+1):(this.state=Ld(e)?9:27,this.sectionStart=this.index))}stateInClosingTagName(e){(62===e||Qd(e))&&(this.cbs.onclosetag(this.sectionStart,this.index),this.sectionStart=-1,this.state=10,this.stateAfterClosingTagName(e))}stateAfterClosingTagName(e){62===e&&(this.state=1,this.sectionStart=this.index+1)}stateBeforeAttrName(e){62===e?(this.cbs.onopentagend(this.index),this.inRCDATA?this.state=32:this.state=1,this.sectionStart=this.index+1):47===e?this.state=7:60===e&&47===this.peek()?(this.cbs.onopentagend(this.index),this.state=5,this.sectionStart=this.index):Qd(e)||this.handleAttrStart(e)}handleAttrStart(e){118===e&&45===this.peek()?(this.state=13,this.sectionStart=this.index):46===e||58===e||64===e||35===e?(this.cbs.ondirname(this.index,this.index+1),this.state=14,this.sectionStart=this.index+1):(this.state=12,this.sectionStart=this.index)}stateInSelfClosingTag(e){62===e?(this.cbs.onselfclosingtag(this.index),this.state=1,this.sectionStart=this.index+1,this.inRCDATA=!1):Qd(e)||(this.state=11,this.stateBeforeAttrName(e))}stateInAttrName(e){(61===e||Fd(e))&&(this.cbs.onattribname(this.sectionStart,this.index),this.handleAttrNameEnd(e))}stateInDirName(e){61===e||Fd(e)?(this.cbs.ondirname(this.sectionStart,this.index),this.handleAttrNameEnd(e)):58===e?(this.cbs.ondirname(this.sectionStart,this.index),this.state=14,this.sectionStart=this.index+1):46===e&&(this.cbs.ondirname(this.sectionStart,this.index),this.state=16,this.sectionStart=this.index+1)}stateInDirArg(e){61===e||Fd(e)?(this.cbs.ondirarg(this.sectionStart,this.index),this.handleAttrNameEnd(e)):91===e?this.state=15:46===e&&(this.cbs.ondirarg(this.sectionStart,this.index),this.state=16,this.sectionStart=this.index+1)}stateInDynamicDirArg(e){93===e?this.state=14:(61===e||Fd(e))&&(this.cbs.ondirarg(this.sectionStart,this.index+1),this.handleAttrNameEnd(e))}stateInDirModifier(e){61===e||Fd(e)?(this.cbs.ondirmodifier(this.sectionStart,this.index),this.handleAttrNameEnd(e)):46===e&&(this.cbs.ondirmodifier(this.sectionStart,this.index),this.sectionStart=this.index+1)}handleAttrNameEnd(e){this.sectionStart=this.index,this.state=17,this.cbs.onattribnameend(this.index),this.stateAfterAttrName(e)}stateAfterAttrName(e){61===e?this.state=18:47===e||62===e?(this.cbs.onattribend(0,this.sectionStart),this.sectionStart=-1,this.state=11,this.stateBeforeAttrName(e)):Qd(e)||(this.cbs.onattribend(0,this.sectionStart),this.handleAttrStart(e))}stateBeforeAttrValue(e){34===e?(this.state=19,this.sectionStart=this.index+1):39===e?(this.state=20,this.sectionStart=this.index+1):Qd(e)||(this.sectionStart=this.index,this.state=21,this.stateInAttrValueNoQuotes(e))}handleInAttrValue(e,t){(e===t||this.fastForwardTo(t))&&(this.cbs.onattribdata(this.sectionStart,this.index),this.sectionStart=-1,this.cbs.onattribend(34===t?3:2,this.index+1),this.state=11)}stateInAttrValueDoubleQuotes(e){this.handleInAttrValue(e,34)}stateInAttrValueSingleQuotes(e){this.handleInAttrValue(e,39)}stateInAttrValueNoQuotes(e){Qd(e)||62===e?(this.cbs.onattribdata(this.sectionStart,this.index),this.sectionStart=-1,this.cbs.onattribend(1,this.index),this.state=11,this.stateBeforeAttrName(e)):39!==e&&60!==e&&61!==e&&96!==e||this.cbs.onerr(18,this.index)}stateBeforeDeclaration(e){91===e?(this.state=26,this.sequenceIndex=0):this.state=45===e?25:23}stateInDeclaration(e){(62===e||this.fastForwardTo(62))&&(this.state=1,this.sectionStart=this.index+1)}stateInProcessingInstruction(e){(62===e||this.fastForwardTo(62))&&(this.cbs.onprocessinginstruction(this.sectionStart,this.index),this.state=1,this.sectionStart=this.index+1)}stateBeforeComment(e){45===e?(this.state=28,this.currentSequence=zd.CommentEnd,this.sequenceIndex=2,this.sectionStart=this.index+1):this.state=23}stateInSpecialComment(e){(62===e||this.fastForwardTo(62))&&(this.cbs.oncomment(this.sectionStart,this.index),this.state=1,this.sectionStart=this.index+1)}stateBeforeSpecialS(e){e===zd.ScriptEnd[3]?this.startSpecial(zd.ScriptEnd,4):e===zd.StyleEnd[3]?this.startSpecial(zd.StyleEnd,4):(this.state=6,this.stateInTagName(e))}stateBeforeSpecialT(e){e===zd.TitleEnd[3]?this.startSpecial(zd.TitleEnd,4):e===zd.TextareaEnd[3]?this.startSpecial(zd.TextareaEnd,4):(this.state=6,this.stateInTagName(e))}startEntity(){}stateInEntity(){}parse(e){for(this.buffer=e;this.index<this.buffer.length;){const e=this.buffer.charCodeAt(this.index);switch(10===e&&33!==this.state&&this.newlines.push(this.index),this.state){case 1:this.stateText(e);break;case 2:this.stateInterpolationOpen(e);break;case 3:this.stateInterpolation(e);break;case 4:this.stateInterpolationClose(e);break;case 31:this.stateSpecialStartSequence(e);break;case 32:this.stateInRCDATA(e);break;case 26:this.stateCDATASequence(e);break;case 19:this.stateInAttrValueDoubleQuotes(e);break;case 12:this.stateInAttrName(e);break;case 13:this.stateInDirName(e);break;case 14:this.stateInDirArg(e);break;case 15:this.stateInDynamicDirArg(e);break;case 16:this.stateInDirModifier(e);break;case 28:this.stateInCommentLike(e);break;case 27:this.stateInSpecialComment(e);break;case 11:this.stateBeforeAttrName(e);break;case 6:this.stateInTagName(e);break;case 34:this.stateInSFCRootTagName(e);break;case 9:this.stateInClosingTagName(e);break;case 5:this.stateBeforeTagName(e);break;case 17:this.stateAfterAttrName(e);break;case 20:this.stateInAttrValueSingleQuotes(e);break;case 18:this.stateBeforeAttrValue(e);break;case 8:this.stateBeforeClosingTagName(e);break;case 10:this.stateAfterClosingTagName(e);break;case 29:this.stateBeforeSpecialS(e);break;case 30:this.stateBeforeSpecialT(e);break;case 21:this.stateInAttrValueNoQuotes(e);break;case 7:this.stateInSelfClosingTag(e);break;case 23:this.stateInDeclaration(e);break;case 22:this.stateBeforeDeclaration(e);break;case 25:this.stateBeforeComment(e);break;case 24:this.stateInProcessingInstruction(e);break;case 33:this.stateInEntity()}this.index++}this.cleanup(),this.finish()}cleanup(){this.sectionStart!==this.index&&(1===this.state||32===this.state&&0===this.sequenceIndex?(this.cbs.ontext(this.sectionStart,this.index),this.sectionStart=this.index):19!==this.state&&20!==this.state&&21!==this.state||(this.cbs.onattribdata(this.sectionStart,this.index),this.sectionStart=this.index))}finish(){this.handleTrailingData(),this.cbs.onend()}handleTrailingData(){const e=this.buffer.length;this.sectionStart>=e||(28===this.state?this.currentSequence===zd.CdataEnd?this.cbs.oncdata(this.sectionStart,e):this.cbs.oncomment(this.sectionStart,e):6===this.state||11===this.state||18===this.state||17===this.state||12===this.state||13===this.state||14===this.state||15===this.state||16===this.state||20===this.state||19===this.state||21===this.state||9===this.state||this.cbs.ontext(this.sectionStart,e))}emitCodePoint(e,t){}}(Rh,{onerr:tu,ontext(e,t){Vh(Qh(e,t),e,t)},ontextentity(e,t,n){Vh(e,t,n)},oninterpolation(e,t){if(Dh)return Vh(Qh(e,t),e,t);let n=e+Ih.delimiterOpen.length,r=t-Ih.delimiterClose.length;for(;Qd(Sh.charCodeAt(n));)n++;for(;Qd(Sh.charCodeAt(r-1));)r--;let i=Qh(n,r);i.includes("&")&&(i=Ch.decodeEntities(i,!1)),Yh({type:5,content:eu(i,!1,Xh(n,r)),loc:Xh(e,t)})},onopentagname(e,t){const n=Qh(e,t);Oh={type:1,tag:n,ns:Ch.getNamespace(n,Rh[0],Ch.ns),tagType:0,props:[],children:[],loc:Xh(e-1,t),codegenNode:void 0}},onopentagend(e){Fh(e)},onclosetag(e,t){const n=Qh(e,t);if(!Ch.isVoidTag(n)){let r=!1;for(let e=0;e<Rh.length;e++){if(Rh[e].tag.toLowerCase()===n.toLowerCase()){r=!0,e>0&&tu(24,Rh[0].loc.start.offset);for(let n=0;n<=e;n++){zh(Rh.shift(),t,n<e)}break}}r||tu(23,Wh(e,60))}},onselfclosingtag(e){const t=Oh.tag;Oh.isSelfClosing=!0,Fh(e),Rh[0]&&Rh[0].tag===t&&zh(Rh.shift(),e)},onattribname(e,t){Bh={type:6,name:Qh(e,t),nameLoc:Xh(e,t),value:void 0,loc:Xh(e)}},ondirname(e,t){const n=Qh(e,t),r="."===n||":"===n?"bind":"@"===n?"on":"#"===n?"slot":n.slice(2);if(Dh||""!==r||tu(26,e),Dh||""===r)Bh={type:6,name:n,nameLoc:Xh(e,t),value:void 0,loc:Xh(e)};else if(Bh={type:7,name:r,rawName:n,exp:void 0,arg:void 0,modifiers:"."===n?[Bd("prop")]:[],loc:Xh(e)},"pre"===r){Dh=Ih.inVPre=!0,Ph=Oh;const e=Oh.props;for(let t=0;t<e.length;t++)7===e[t].type&&(e[t]=Zh(e[t]))}},ondirarg(e,t){if(e===t)return;const n=Qh(e,t);if(Dh&&!ch(Bh))Bh.name+=n,Kh(Bh.nameLoc,t);else{const r="["!==n[0];Bh.arg=eu(r?n:n.slice(1,-1),r,Xh(e,t),r?3:0)}},ondirmodifier(e,t){const n=Qh(e,t);if(Dh&&!ch(Bh))Bh.name+="."+n,Kh(Bh.nameLoc,t);else if("slot"===Bh.name){const e=Bh.arg;e&&(e.content+="."+n,Kh(e.loc,t))}else{const r=Bd(n,!0,Xh(e,t));Bh.modifiers.push(r)}},onattribdata(e,t){_h+=Qh(e,t),Th<0&&(Th=e),Eh=t},onattribentity(e,t,n){_h+=e,Th<0&&(Th=t),Eh=n},onattribnameend(e){const t=Bh.loc.start.offset,n=Qh(t,e);7===Bh.type&&(Bh.rawName=n),Oh.props.some(e=>(7===e.type?e.rawName:e.name)===n)&&tu(2,t)},onattribend(e,t){if(Oh&&Bh){if(Kh(Bh.loc,t),0!==e)if(_h.includes("&")&&(_h=Ch.decodeEntities(_h,!0)),6===Bh.type)"class"===Bh.name&&(_h=Gh(_h).trim()),1!==e||_h||tu(13,t),Bh.value={type:2,content:_h,loc:1===e?Xh(Th,Eh):Xh(Th-1,Eh+1)},Ih.inSFCRoot&&"template"===Oh.tag&&"lang"===Bh.name&&_h&&"html"!==_h&&Ih.enterRCDATA(Vd("</template"),0);else{let e=0;Bh.exp=eu(_h,!1,Xh(Th,Eh),0,e),"for"===Bh.name&&(Bh.forParseResult=function(e){const t=e.loc,n=e.content,r=n.match(Ah);if(!r)return;const[,i,o]=r,s=(e,n,r=!1)=>{const i=t.start.offset+n;return eu(e,!1,Xh(i,i+e.length),0,r?1:0)},a={source:s(o.trim(),n.indexOf(o,i.length)),value:void 0,key:void 0,index:void 0,finalized:!1};let l=i.trim().replace(Lh,"").trim();const c=i.indexOf(l),d=l.match(Nh);if(d){l=l.replace(Nh,"").trim();const e=d[1].trim();let t;if(e&&(t=n.indexOf(e,c+l.length),a.key=s(e,t,!0)),d[2]){const r=d[2].trim();r&&(a.index=s(r,n.indexOf(r,a.key?t+e.length:c+l.length),!0))}}l&&(a.value=s(l,c,!0));return a}(Bh.exp));let t=-1;"bind"===Bh.name&&(t=Bh.modifiers.findIndex(e=>"sync"===e.content))>-1&&Hd("COMPILER_V_BIND_SYNC",Ch,Bh.loc,Bh.arg.loc.source)&&(Bh.name="model",Bh.modifiers.splice(t,1))}7===Bh.type&&"pre"===Bh.name||Oh.props.push(Bh)}_h="",Th=Eh=-1},oncomment(e,t){Ch.comments&&Yh({type:3,content:Qh(e,t),loc:Xh(e-4,t+3)})},onend(){const e=Sh.length;for(let t=0;t<Rh.length;t++)zh(Rh[t],e-1),tu(24,Rh[t].loc.start.offset)},oncdata(e,t){0!==Rh[0].ns?Vh(Qh(e,t),e,t):tu(1,e-9)},onprocessinginstruction(e){0===(Rh[0]?Rh[0].ns:Ch.ns)&&tu(21,e-1)}}),Nh=/,([^,\}\]]*)(?:,([^,\}\]]*))?$/,Lh=/^\(|\)$/g;function Qh(e,t){return Sh.slice(e,t)}function Fh(e){Ih.inSFCRoot&&(Oh.innerLoc=Xh(e+1,e+1)),Yh(Oh);const{tag:t,ns:n}=Oh;0===n&&Ch.isPreTag(t)&&Mh++,Ch.isVoidTag(t)?zh(Oh,e):(Rh.unshift(Oh),1!==n&&2!==n||(Ih.inXML=!0)),Oh=null}function Vh(e,t,n){{const t=Rh[0]&&Rh[0].tag;"script"!==t&&"style"!==t&&e.includes("&")&&(e=Ch.decodeEntities(e,!1))}const r=Rh[0]||kh,i=r.children[r.children.length-1];i&&2===i.type?(i.content+=e,Kh(i.loc,n)):r.children.push({type:2,content:e,loc:Xh(t,n)})}function zh(e,t,n=!1){Kh(e.loc,n?Wh(t,60):function(e,t){let n=e;for(;Sh.charCodeAt(n)!==t&&n<Sh.length-1;)n++;return n}(t,62)+1),Ih.inSFCRoot&&(e.children.length?e.innerLoc.end=h({},e.children[e.children.length-1].loc.end):e.innerLoc.end=h({},e.innerLoc.start),e.innerLoc.source=Qh(e.innerLoc.start.offset,e.innerLoc.end.offset));const{tag:r,ns:i,children:o}=e;if(Dh||("slot"===r?e.tagType=2:Hh(e)?e.tagType=3:function({tag:e,props:t}){if(Ch.isCustomElement(e))return!1;if("component"===e||(n=e.charCodeAt(0),n>64&&n<91)||Yd(e)||Ch.isBuiltInComponent&&Ch.isBuiltInComponent(e)||Ch.isNativeTag&&!Ch.isNativeTag(e))return!0;var n;for(let e=0;e<t.length;e++){const n=t[e];if(6===n.type){if("is"===n.name&&n.value){if(n.value.content.startsWith("vue:"))return!0;if(Hd("COMPILER_IS_ON_ELEMENT",Ch,n.loc))return!0}}else if("bind"===n.name&&ah(n.arg,"is")&&Hd("COMPILER_IS_ON_ELEMENT",Ch,n.loc))return!0}return!1}(e)&&(e.tagType=1)),Ih.inRCDATA||(e.children=qh(o)),0===i&&Ch.isIgnoreNewlineTag(r)){const e=o[0];e&&2===e.type&&(e.content=e.content.replace(/^\r?\n/,""))}0===i&&Ch.isPreTag(r)&&Mh--,Ph===e&&(Dh=Ih.inVPre=!1,Ph=null),Ih.inXML&&0===(Rh[0]?Rh[0].ns:Ch.ns)&&(Ih.inXML=!1);{const t=e.props;if(!Ih.inSFCRoot&&$d("COMPILER_NATIVE_TEMPLATE",Ch)&&"template"===e.tag&&!Hh(e)){const t=Rh[0]||kh,n=t.children.indexOf(e);t.children.splice(n,1,...e.children)}const n=t.find(e=>6===e.type&&"inline-template"===e.name);n&&Hd("COMPILER_INLINE_TEMPLATE",Ch,n.loc)&&e.children.length&&(n.value={type:2,content:Qh(e.children[0].loc.start.offset,e.children[e.children.length-1].loc.end.offset),loc:n.loc})}}function Wh(e,t){let n=e;for(;Sh.charCodeAt(n)!==t&&n>=0;)n--;return n}const $h=new Set(["if","else","else-if","for","slot"]);function Hh({tag:e,props:t}){if("template"===e)for(let e=0;e<t.length;e++)if(7===t[e].type&&$h.has(t[e].name))return!0;return!1}const jh=/\r\n/g;function qh(e){const t="preserve"!==Ch.whitespace;let n=!1;for(let r=0;r<e.length;r++){const i=e[r];if(2===i.type)if(Mh)i.content=i.content.replace(jh,"\n");else if(bh(i.content)){const o=e[r-1]&&e[r-1].type,s=e[r+1]&&e[r+1].type;!o||!s||t&&(3===o&&(3===s||1===s)||1===o&&(3===s||1===s&&Uh(i.content)))?(n=!0,e[r]=null):i.content=" "}else t&&(i.content=Gh(i.content))}return n?e.filter(Boolean):e}function Uh(e){for(let t=0;t<e.length;t++){const n=e.charCodeAt(t);if(10===n||13===n)return!0}return!1}function Gh(e){let t="",n=!1;for(let r=0;r<e.length;r++)Qd(e.charCodeAt(r))?n||(t+=" ",n=!0):(t+=e[r],n=!1);return t}function Yh(e){(Rh[0]||kh).children.push(e)}function Xh(e,t){return{start:Ih.getPos(e),end:null==t?t:Ih.getPos(t),source:null==t?t:Qh(e,t)}}function Jh(e){return Xh(e.start.offset,e.end.offset)}function Kh(e,t){e.end=Ih.getPos(t),e.source=Qh(e.start.offset,t)}function Zh(e){const t={type:6,name:e.rawName,nameLoc:Xh(e.loc.start.offset,e.loc.start.offset+e.rawName.length),value:void 0,loc:e.loc};if(e.exp){const n=e.exp.loc;n.end.offset<e.loc.end.offset&&(n.start.offset--,n.start.column--,n.end.offset++,n.end.column++),t.value={type:2,content:e.exp.content,loc:n}}return t}function eu(e,t=!1,n,r=0,i=0){return Bd(e,t,n,r)}function tu(e,t,n){Ch.onError(Ud(e,Xh(t,t)))}function nu(e,t){if(Ih.reset(),Oh=null,Bh=null,_h="",Th=-1,Eh=-1,Rh.length=0,Sh=e,Ch=h({},wh),t){let e;for(e in t)null!=t[e]&&(Ch[e]=t[e])}Ih.mode="html"===Ch.parseMode?1:"sfc"===Ch.parseMode?2:0,Ih.inXML=1===Ch.ns||2===Ch.ns;const n=t&&t.delimiters;n&&(Ih.delimiterOpen=Vd(n[0]),Ih.delimiterClose=Vd(n[1]));const r=kh=function(e,t=""){return{type:0,source:t,children:e,helpers:new Set,components:[],directives:[],hoists:[],imports:[],cached:[],temps:0,codegenNode:void 0,loc:wd}}([],e);return Ih.parse(Sh),r.loc=Xh(0,e.length),r.children=qh(r.children),kh=null,r}function ru(e,t){ou(e,void 0,t,!!iu(e))}function iu(e){const t=e.children.filter(e=>3!==e.type);return 1!==t.length||1!==t[0].type||uh(t[0])?null:t[0]}function ou(e,t,n,r=!1,i=!1){const{children:o}=e,s=[];for(let t=0;t<o.length;t++){const a=o[t];if(1===a.type&&0===a.tagType){const e=r?0:su(a,n);if(e>0){if(e>=2){a.codegenNode.patchFlag=-1,s.push(a);continue}}else{const e=a.codegenNode;if(13===e.type){const t=e.patchFlag;if((void 0===t||512===t||1===t)&&cu(a,n)>=2){const t=du(a);t&&(e.props=n.hoist(t))}e.dynamicProps&&(e.dynamicProps=n.hoist(e.dynamicProps))}}}else if(12===a.type){if((r?0:su(a,n))>=2){14===a.codegenNode.type&&a.codegenNode.arguments.length>0&&a.codegenNode.arguments.push("-1"),s.push(a);continue}}if(1===a.type){const t=1===a.tagType;t&&n.scopes.vSlot++,ou(a,e,n,!1,i),t&&n.scopes.vSlot--}else if(11===a.type)ou(a,e,n,1===a.children.length,!0);else if(9===a.type)for(let t=0;t<a.branches.length;t++)ou(a.branches[t],e,n,1===a.branches[t].children.length,i)}let a=!1;if(s.length===o.length&&1===e.type)if(0===e.tagType&&e.codegenNode&&13===e.codegenNode.type&&g(e.codegenNode.children))e.codegenNode.children=l(kd(e.codegenNode.children)),a=!0;else if(1===e.tagType&&e.codegenNode&&13===e.codegenNode.type&&e.codegenNode.children&&!g(e.codegenNode.children)&&15===e.codegenNode.children.type){const t=c(e.codegenNode,"default");t&&(t.returns=l(kd(t.returns)),a=!0)}else if(3===e.tagType&&t&&1===t.type&&1===t.tagType&&t.codegenNode&&13===t.codegenNode.type&&t.codegenNode.children&&!g(t.codegenNode.children)&&15===t.codegenNode.children.type){const n=oh(e,"slot",!0),r=n&&n.arg&&c(t.codegenNode,n.arg);r&&(r.returns=l(kd(r.returns)),a=!0)}if(!a)for(const e of s)e.codegenNode=n.cache(e.codegenNode);function l(e){const t=n.cache(e);return t.needArraySpread=!0,t}function c(e,t){if(e.children&&!g(e.children)&&15===e.children.type){const n=e.children.properties.find(e=>e.key===t||e.key.content===t);return n&&n.value}}s.length&&n.transformHoist&&n.transformHoist(o,n,e)}function su(e,t){const{constantCache:n}=t;switch(e.type){case 1:if(0!==e.tagType)return 0;const r=n.get(e);if(void 0!==r)return r;const i=e.codegenNode;if(13!==i.type)return 0;if(i.isBlock&&"svg"!==e.tag&&"foreignObject"!==e.tag&&"math"!==e.tag)return 0;if(void 0===i.patchFlag){let r=3;const o=cu(e,t);if(0===o)return n.set(e,0),0;o<r&&(r=o);for(let i=0;i<e.children.length;i++){const o=su(e.children[i],t);if(0===o)return n.set(e,0),0;o<r&&(r=o)}if(r>1)for(let i=0;i<e.props.length;i++){const o=e.props[i];if(7===o.type&&"bind"===o.name&&o.exp){const i=su(o.exp,t);if(0===i)return n.set(e,0),0;i<r&&(r=i)}}if(i.isBlock){for(let t=0;t<e.props.length;t++){if(7===e.props[t].type)return n.set(e,0),0}t.removeHelper(zc),t.removeHelper(Pd(t.inSSR,i.isComponent)),i.isBlock=!1,t.helper(Dd(t.inSSR,i.isComponent))}return n.set(e,r),r}return n.set(e,0),0;case 2:case 3:return 3;case 9:case 11:case 10:default:return 0;case 5:case 12:return su(e.content,t);case 4:return e.constType;case 8:let o=3;for(let n=0;n<e.children.length;n++){const r=e.children[n];if(y(r)||x(r))continue;const i=su(r,t);if(0===i)return 0;i<o&&(o=i)}return o;case 20:return 2}}const au=new Set([od,sd,ad,ld]);function lu(e,t){if(14===e.type&&!y(e.callee)&&au.has(e.callee)){const n=e.arguments[0];if(4===n.type)return su(n,t);if(14===n.type)return lu(n,t)}return 0}function cu(e,t){let n=3;const r=du(e);if(r&&15===r.type){const{properties:e}=r;for(let r=0;r<e.length;r++){const{key:i,value:o}=e[r],s=su(i,t);if(0===s)return s;let a;if(s<n&&(n=s),a=4===o.type?su(o,t):14===o.type?lu(o,t):0,0===a)return a;a<n&&(n=a)}}return n}function du(e){const t=e.codegenNode;if(13===t.type)return t.props}function hu(e,{filename:t="",prefixIdentifiers:n=!1,hoistStatic:r=!1,hmr:i=!1,cacheHandlers:s=!1,nodeTransforms:l=[],directiveTransforms:c={},transformHoist:d=null,isBuiltInComponent:h=a,isCustomElement:u=a,expressionPlugins:p=[],scopeId:f=null,slotted:g=!0,ssr:m=!1,inSSR:v=!1,ssrCssVars:A="",bindingMetadata:b=o,inline:x=!1,isTS:w=!1,onError:C=jd,onWarn:k=qd,compatConfig:S}){const O=t.replace(/\?.*$/,"").match(/([^/\\]+)\.\w+$/),B={filename:t,selfName:O&&I(D(O[1])),prefixIdentifiers:n,hoistStatic:r,hmr:i,cacheHandlers:s,nodeTransforms:l,directiveTransforms:c,transformHoist:d,isBuiltInComponent:h,isCustomElement:u,expressionPlugins:p,scopeId:f,slotted:g,ssr:m,inSSR:v,ssrCssVars:A,bindingMetadata:b,inline:x,isTS:w,onError:C,onWarn:k,compatConfig:S,root:e,helpers:new Map,components:new Set,directives:new Set,hoists:[],imports:[],cached:[],constantCache:new WeakMap,temps:0,identifiers:Object.create(null),scopes:{vFor:0,vSlot:0,vPre:0,vOnce:0},parent:null,grandParent:null,currentNode:e,childIndex:0,inVOnce:!1,helper(e){const t=B.helpers.get(e)||0;return B.helpers.set(e,t+1),e},removeHelper(e){const t=B.helpers.get(e);if(t){const n=t-1;n?B.helpers.set(e,n):B.helpers.delete(e)}},helperString:e=>`_${xd[B.helper(e)]}`,replaceNode(e){B.parent.children[B.childIndex]=B.currentNode=e},removeNode(e){const t=B.parent.children,n=e?t.indexOf(e):B.currentNode?B.childIndex:-1;e&&e!==B.currentNode?B.childIndex>n&&(B.childIndex--,B.onNodeRemoved()):(B.currentNode=null,B.onNodeRemoved()),B.parent.children.splice(n,1)},onNodeRemoved:a,addIdentifiers(e){},removeIdentifiers(e){},hoist(e){y(e)&&(e=Bd(e)),B.hoists.push(e);const t=Bd(`_hoisted_${B.hoists.length}`,!1,e.loc,2);return t.hoisted=e,t},cache(e,t=!1,n=!1){const r=function(e,t,n=!1,r=!1){return{type:20,index:e,value:t,needPauseTracking:n,inVOnce:r,needArraySpread:!1,loc:wd}}(B.cached.length,e,t,n);return B.cached.push(r),r}};return B.filters=new Set,B}function uu(e,t){const n=hu(e,t);pu(e,n),t.hoistStatic&&ru(e,n),t.ssr||function(e,t){const{helper:n}=t,{children:r}=e;if(1===r.length){const n=iu(e);if(n&&n.codegenNode){const r=n.codegenNode;13===r.type&&Rd(r,t),e.codegenNode=r}else e.codegenNode=r[0]}else if(r.length>1){let r=64;0,e.codegenNode=Cd(t,n(Nc),void 0,e.children,r,void 0,void 0,!0,void 0,!1)}}(e,n),e.helpers=new Set([...n.helpers.keys()]),e.components=[...n.components],e.directives=[...n.directives],e.imports=n.imports,e.hoists=n.hoists,e.temps=n.temps,e.cached=n.cached,e.transformed=!0,e.filters=[...n.filters]}function pu(e,t){t.currentNode=e;const{nodeTransforms:n}=t,r=[];for(let i=0;i<n.length;i++){const o=n[i](e,t);if(o&&(g(o)?r.push(...o):r.push(o)),!t.currentNode)return;e=t.currentNode}switch(e.type){case 3:t.ssr||t.helper(qc);break;case 5:t.ssr||t.helper(rd);break;case 9:for(let n=0;n<e.branches.length;n++)pu(e.branches[n],t);break;case 10:case 11:case 1:case 0:!function(e,t){let n=0;const r=()=>{n--};for(;n<e.children.length;n++){const i=e.children[n];y(i)||(t.grandParent=t.parent,t.parent=e,t.childIndex=n,t.onNodeRemoved=r,pu(i,t))}}(e,t)}t.currentNode=e;let i=r.length;for(;i--;)r[i]()}function fu(e,t){const n=y(e)?t=>t===e:t=>e.test(t);return(e,r)=>{if(1===e.type){const{props:i}=e;if(3===e.tagType&&i.some(dh))return;const o=[];for(let s=0;s<i.length;s++){const a=i[s];if(7===a.type&&n(a.name)){i.splice(s,1),s--;const n=t(e,a,r);n&&o.push(n)}}return o}}}const gu="/*@__PURE__*/",mu=e=>`${xd[e]}: _${xd[e]}`;function vu(e,t={}){const n=function(e,{mode:t="function",prefixIdentifiers:n="module"===t,sourceMap:r=!1,filename:i="template.vue.html",scopeId:o=null,optimizeImports:s=!1,runtimeGlobalName:a="Vue",runtimeModuleName:l="vue",ssrRuntimeModuleName:c="vue/server-renderer",ssr:d=!1,isTS:h=!1,inSSR:u=!1}){const p={mode:t,prefixIdentifiers:n,sourceMap:r,filename:i,scopeId:o,optimizeImports:s,runtimeGlobalName:a,runtimeModuleName:l,ssrRuntimeModuleName:c,ssr:d,isTS:h,inSSR:u,source:e.source,code:"",column:1,line:1,offset:0,indentLevel:0,pure:!1,map:void 0,helper:e=>`_${xd[e]}`,push(e,t=-2,n){p.code+=e},indent(){f(++p.indentLevel)},deindent(e=!1){e?--p.indentLevel:f(--p.indentLevel)},newline(){f(p.indentLevel)}};function f(e){p.push("\n"+"  ".repeat(e),0)}return p}(e,t);t.onContextCreated&&t.onContextCreated(n);const{mode:r,push:i,prefixIdentifiers:o,indent:s,deindent:a,newline:l,scopeId:c,ssr:d}=n,h=Array.from(e.helpers),u=h.length>0,p=!o&&"module"!==r;!function(e,t){const{ssr:n,prefixIdentifiers:r,push:i,newline:o,runtimeModuleName:s,runtimeGlobalName:a,ssrRuntimeModuleName:l}=t,c=a,d=Array.from(e.helpers);if(d.length>0&&(i(`const _Vue = ${c}\n`,-1),e.hoists.length)){i(`const { ${[Hc,jc,qc,Uc,Gc].filter(e=>d.includes(e)).map(mu).join(", ")} } = _Vue\n`,-1)}(function(e,t){if(!e.length)return;t.pure=!0;const{push:n,newline:r}=t;r();for(let i=0;i<e.length;i++){const o=e[i];o&&(n(`const _hoisted_${i+1} = `),xu(o,t),r())}t.pure=!1})(e.hoists,t),o(),i("return ")}(e,n);if(i(`function ${d?"ssrRender":"render"}(${(d?["_ctx","_push","_parent","_attrs"]:["_ctx","_cache"]).join(", ")}) {`),s(),p&&(i("with (_ctx) {"),s(),u&&(i(`const { ${h.map(mu).join(", ")} } = _Vue\n`,-1),l())),e.components.length&&(Au(e.components,"component",n),(e.directives.length||e.temps>0)&&l()),e.directives.length&&(Au(e.directives,"directive",n),e.temps>0&&l()),e.filters&&e.filters.length&&(l(),Au(e.filters,"filter",n),l()),e.temps>0){i("let ");for(let t=0;t<e.temps;t++)i(`${t>0?", ":""}_temp${t}`)}return(e.components.length||e.directives.length||e.temps)&&(i("\n",0),l()),d||i("return "),e.codegenNode?xu(e.codegenNode,n):i("null"),p&&(a(),i("}")),a(),i("}"),{ast:e,code:n.code,preamble:"",map:n.map?n.map.toJSON():void 0}}function Au(e,t,{helper:n,push:r,newline:i,isTS:o}){const s=n("filter"===t?Kc:"component"===t?Yc:Jc);for(let n=0;n<e.length;n++){let a=e[n];const l=a.endsWith("__self");l&&(a=a.slice(0,-6)),r(`const ${vh(a,t)} = ${s}(${JSON.stringify(a)}${l?", true":""})${o?"!":""}`),n<e.length-1&&i()}}function bu(e,t){const n=e.length>3||!1;t.push("["),n&&t.indent(),yu(e,t,n),n&&t.deindent(),t.push("]")}function yu(e,t,n=!1,r=!0){const{push:i,newline:o}=t;for(let s=0;s<e.length;s++){const a=e[s];y(a)?i(a,-3):g(a)?bu(a,t):xu(a,t),s<e.length-1&&(n?(r&&i(","),o()):r&&i(", "))}}function xu(e,t){if(y(e))t.push(e,-3);else if(x(e))t.push(t.helper(e));else switch(e.type){case 1:case 9:case 11:case 12:xu(e.codegenNode,t);break;case 2:!function(e,t){t.push(JSON.stringify(e.content),-3,e)}(e,t);break;case 4:wu(e,t);break;case 5:!function(e,t){const{push:n,helper:r,pure:i}=t;i&&n(gu);n(`${r(rd)}(`),xu(e.content,t),n(")")}(e,t);break;case 8:Cu(e,t);break;case 3:!function(e,t){const{push:n,helper:r,pure:i}=t;i&&n(gu);n(`${r(qc)}(${JSON.stringify(e.content)})`,-3,e)}(e,t);break;case 13:!function(e,t){const{push:n,helper:r,pure:i}=t,{tag:o,props:s,children:a,patchFlag:l,dynamicProps:c,directives:d,isBlock:h,disableTracking:u,isComponent:p}=e;let f;l&&(f=String(l));d&&n(r(Zc)+"(");h&&n(`(${r(zc)}(${u?"true":""}), `);i&&n(gu);const g=h?Pd(t.inSSR,p):Dd(t.inSSR,p);n(r(g)+"(",-2,e),yu(function(e){let t=e.length;for(;t--&&null==e[t];);return e.slice(0,t+1).map(e=>e||"null")}([o,s,a,f,c]),t),n(")"),h&&n(")");d&&(n(", "),xu(d,t),n(")"))}(e,t);break;case 14:!function(e,t){const{push:n,helper:r,pure:i}=t,o=y(e.callee)?e.callee:r(e.callee);i&&n(gu);n(o+"(",-2,e),yu(e.arguments,t),n(")")}(e,t);break;case 15:!function(e,t){const{push:n,indent:r,deindent:i,newline:o}=t,{properties:s}=e;if(!s.length)return void n("{}",-2,e);const a=s.length>1||!1;n(a?"{":"{ "),a&&r();for(let e=0;e<s.length;e++){const{key:r,value:i}=s[e];ku(r,t),n(": "),xu(i,t),e<s.length-1&&(n(","),o())}a&&i(),n(a?"}":" }")}(e,t);break;case 17:!function(e,t){bu(e.elements,t)}(e,t);break;case 18:!function(e,t){const{push:n,indent:r,deindent:i}=t,{params:o,returns:s,body:a,newline:l,isSlot:c}=e;c&&n(`_${xd[md]}(`);n("(",-2,e),g(o)?yu(o,t):o&&xu(o,t);n(") => "),(l||a)&&(n("{"),r());s?(l&&n("return "),g(s)?bu(s,t):xu(s,t)):a&&xu(a,t);(l||a)&&(i(),n("}"));c&&(e.isNonScopedSlot&&n(", undefined, true"),n(")"))}(e,t);break;case 19:!function(e,t){const{test:n,consequent:r,alternate:i,newline:o}=e,{push:s,indent:a,deindent:l,newline:c}=t;if(4===n.type){const e=!Jd(n.content);e&&s("("),wu(n,t),e&&s(")")}else s("("),xu(n,t),s(")");o&&a(),t.indentLevel++,o||s(" "),s("? "),xu(r,t),t.indentLevel--,o&&c(),o||s(" "),s(": ");const d=19===i.type;d||t.indentLevel++;xu(i,t),d||t.indentLevel--;o&&l(!0)}(e,t);break;case 20:!function(e,t){const{push:n,helper:r,indent:i,deindent:o,newline:s}=t,{needPauseTracking:a,needArraySpread:l}=e;l&&n("[...(");n(`_cache[${e.index}] || (`),a&&(i(),n(`${r(pd)}(-1`),e.inVOnce&&n(", true"),n("),"),s(),n("("));n(`_cache[${e.index}] = `),xu(e.value,t),a&&(n(`).cacheIndex = ${e.index},`),s(),n(`${r(pd)}(1),`),s(),n(`_cache[${e.index}]`),o());n(")"),l&&n(")]")}(e,t);break;case 21:yu(e.body,t,!0,!1)}}function wu(e,t){const{content:n,isStatic:r}=e;t.push(r?JSON.stringify(n):n,-3,e)}function Cu(e,t){for(let n=0;n<e.children.length;n++){const r=e.children[n];y(r)?t.push(r,-3):xu(r,t)}}function ku(e,t){const{push:n}=t;if(8===e.type)n("["),Cu(e,t),n("]");else if(e.isStatic){n(Jd(e.content)?e.content:JSON.stringify(e.content),-2,e)}else n(`[${e.content}]`,-3,e)}new RegExp("\\b"+"arguments,await,break,case,catch,class,const,continue,debugger,default,delete,do,else,export,extends,finally,for,function,if,import,let,new,return,super,switch,throw,try,var,void,while,with,yield".split(",").join("\\b|\\b")+"\\b");const Su=fu(/^(?:if|else|else-if)$/,(e,t,n)=>function(e,t,n,r){if(!("else"===t.name||t.exp&&t.exp.content.trim())){const r=t.exp?t.exp.loc:e.loc;n.onError(Ud(28,t.loc)),t.exp=Bd("true",!1,r)}0;if("if"===t.name){const i=Ou(e,t),o={type:9,loc:Jh(e.loc),branches:[i]};if(n.replaceNode(o),r)return r(o,i,!0)}else{const i=n.parent.children;let o=i.indexOf(e);for(;o-- >=-1;){const s=i[o];if(!s||!xh(s)){if(s&&9===s.type){"else-if"!==t.name&&"else"!==t.name||void 0!==s.branches[s.branches.length-1].condition||n.onError(Ud(30,e.loc)),n.removeNode();const i=Ou(e,t);0,s.branches.push(i);const o=r&&r(s,i,!1);pu(i,n),o&&o(),n.currentNode=null}else n.onError(Ud(30,e.loc));break}n.removeNode(s)}}}(e,t,n,(e,t,r)=>{const i=n.parent.children;let o=i.indexOf(e),s=0;for(;o-- >=0;){const e=i[o];e&&9===e.type&&(s+=e.branches.length)}return()=>{if(r)e.codegenNode=Bu(t,s,n);else{const r=function(e){for(;;)if(19===e.type){if(19!==e.alternate.type)return e;e=e.alternate}else 20===e.type&&(e=e.value)}(e.codegenNode);r.alternate=Bu(t,s+e.branches.length-1,n)}}}));function Ou(e,t){const n=3===e.tagType;return{type:10,loc:e.loc,condition:"else"===t.name?void 0:t.exp,children:n&&!oh(e,"for")?e.children:[e],userKey:sh(e,"key"),isTemplateIf:n}}function Bu(e,t,n){return e.condition?Md(e.condition,_u(e,t,n),Td(n.helper(qc),['""',"true"])):_u(e,t,n)}function _u(e,t,n){const{helper:r}=n,i=Od("key",Bd(`${t}`,!1,wd,2)),{children:o}=e,s=o[0];if(1!==o.length||1!==s.type){if(1===o.length&&11===s.type){const e=s.codegenNode;return gh(e,i,n),e}{let t=64;return Cd(n,r(Nc),Sd([i]),o,t,void 0,void 0,!0,!1,!1,e.loc)}}{const e=s.codegenNode,t=14===(a=e).type&&a.callee===bd?a.arguments[1].returns:a;return 13===t.type&&Rd(t,n),gh(t,i,n),e}var a}const Tu=fu("for",(e,t,n)=>{const{helper:r,removeHelper:i}=n;return function(e,t,n,r){if(!t.exp)return void n.onError(Ud(31,t.loc));const i=t.forParseResult;if(!i)return void n.onError(Ud(32,t.loc));Eu(i,n);const{addIdentifiers:o,removeIdentifiers:s,scopes:a}=n,{source:l,value:c,key:d,index:h}=i,u={type:11,loc:t.loc,source:l,valueAlias:c,keyAlias:d,objectIndexAlias:h,parseResult:i,children:hh(e)?e.children:[e]};n.replaceNode(u),a.vFor++;const p=r&&r(u);return()=>{a.vFor--,p&&p()}}(e,t,n,t=>{const o=Td(r(ed),[t.source]),s=hh(e),a=oh(e,"memo"),l=sh(e,"key",!1,!0);l&&l.type;let c=l&&(6===l.type?l.value?Bd(l.value.content,!0):void 0:l.exp);const d=l&&c?Od("key",c):null,h=4===t.source.type&&t.source.constType>0,u=h?64:l?128:256;return t.codegenNode=Cd(n,r(Nc),void 0,o,u,void 0,void 0,!0,!h,!1,e.loc),()=>{let l;const{children:u}=t;const p=1!==u.length||1!==u[0].type,f=uh(e)?e:s&&1===e.children.length&&uh(e.children[0])?e.children[0]:null;if(f?(l=f.codegenNode,s&&d&&gh(l,d,n)):p?l=Cd(n,r(Nc),d?Sd([d]):void 0,e.children,64,void 0,void 0,!0,void 0,!1):(l=u[0].codegenNode,s&&d&&gh(l,d,n),l.isBlock!==!h&&(l.isBlock?(i(zc),i(Pd(n.inSSR,l.isComponent))):i(Dd(n.inSSR,l.isComponent))),l.isBlock=!h,l.isBlock?(r(zc),r(Pd(n.inSSR,l.isComponent))):r(Dd(n.inSSR,l.isComponent))),a){const e=Ed(Mu(t.parseResult,[Bd("_cached")]));e.body={type:21,body:[_d(["const _memo = (",a.exp,")"]),_d(["if (_cached",...c?[" && _cached.key === ",c]:[],` && ${n.helperString(yd)}(_cached, _memo)) return _cached`]),_d(["const _item = ",l]),Bd("_item.memo = _memo"),Bd("return _item")],loc:wd},o.arguments.push(e,Bd("_cache"),Bd(String(n.cached.length))),n.cached.push(null)}else o.arguments.push(Ed(Mu(t.parseResult),l,!0))}})});function Eu(e,t){e.finalized||(e.finalized=!0)}function Mu({value:e,key:t,index:n},r=[]){return function(e){let t=e.length;for(;t--&&!e[t];);return e.slice(0,t+1).map((e,t)=>e||Bd("_".repeat(t+1),!1))}([e,t,n,...r])}const Du=Bd("undefined",!1),Pu=(e,t)=>{if(1===e.type&&(1===e.tagType||3===e.tagType)){const n=oh(e,"slot");if(n)return n.exp,t.scopes.vSlot++,()=>{t.scopes.vSlot--}}},Ru=(e,t,n,r)=>Ed(e,n,!1,!0,n.length?n[0].loc:r);function Iu(e,t,n=Ru){t.helper(md);const{children:r,loc:i}=e,o=[],s=[];let a=t.scopes.vSlot>0||t.scopes.vFor>0;const l=oh(e,"slot",!0);if(l){const{arg:e,exp:t}=l;e&&!Gd(e)&&(a=!0),o.push(Od(e||Bd("default",!0),n(t,void 0,r,i)))}let c=!1,d=!1;const h=[],u=new Set;let p=0;for(let e=0;e<r.length;e++){const i=r[e];let f;if(!hh(i)||!(f=oh(i,"slot",!0))){3!==i.type&&h.push(i);continue}if(l){t.onError(Ud(37,f.loc));break}c=!0;const{children:g,loc:m}=i,{arg:v=Bd("default",!0),exp:A,loc:b}=f;let y;Gd(v)?y=v?v.content:"default":a=!0;const x=oh(i,"for"),w=n(A,x,g,m);let C,k;if(C=oh(i,"if"))a=!0,s.push(Md(C.exp,Nu(v,w,p++),Du));else if(k=oh(i,/^else(?:-if)?$/,!0)){let n,i=e;for(;i--&&(n=r[i],xh(n)););if(n&&hh(n)&&oh(n,/^(?:else-)?if$/)){let e=s[s.length-1];for(;19===e.alternate.type;)e=e.alternate;e.alternate=k.exp?Md(k.exp,Nu(v,w,p++),Du):Nu(v,w,p++)}else t.onError(Ud(30,k.loc))}else if(x){a=!0;const e=x.forParseResult;e?(Eu(e),s.push(Td(t.helper(ed),[e.source,Ed(Mu(e),Nu(v,w),!0)]))):t.onError(Ud(32,x.loc))}else{if(y){if(u.has(y)){t.onError(Ud(38,b));continue}u.add(y),"default"===y&&(d=!0)}o.push(Od(v,w))}}if(!l){const e=(e,r)=>{const o=n(e,void 0,r,i);return t.compatConfig&&(o.isNonScopedSlot=!0),Od("default",o)};c?h.length&&!h.every(yh)&&(d?t.onError(Ud(39,h[0].loc)):o.push(e(void 0,h))):o.push(e(void 0,r))}const f=a?2:Lu(e.children)?3:1;let g=Sd(o.concat(Od("_",Bd(f+"",!1))),i);return s.length&&(g=Td(t.helper(nd),[g,kd(s)])),{slots:g,hasDynamicSlots:a}}function Nu(e,t,n){const r=[Od("name",e),Od("fn",t)];return null!=n&&r.push(Od("key",Bd(String(n),!0))),Sd(r)}function Lu(e){for(let t=0;t<e.length;t++){const n=e[t];switch(n.type){case 1:if(2===n.tagType||Lu(n.children))return!0;break;case 9:if(Lu(n.branches))return!0;break;case 10:case 11:if(Lu(n.children))return!0}}return!1}const Qu=new WeakMap,Fu=(e,t)=>function(){if(1!==(e=t.currentNode).type||0!==e.tagType&&1!==e.tagType)return;const{tag:n,props:r}=e,i=1===e.tagType;let o=i?function(e,t,n=!1){let{tag:r}=e;const i=$u(r),o=sh(e,"is",!1,!0);if(o)if(i||$d("COMPILER_IS_ON_ELEMENT",t)){let e;if(6===o.type?e=o.value&&Bd(o.value.content,!0):(e=o.exp,e||(e=Bd("is",!1,o.arg.loc))),e)return Td(t.helper(Xc),[e])}else 6===o.type&&o.value.content.startsWith("vue:")&&(r=o.value.content.slice(4));const s=Yd(r)||t.isBuiltInComponent(r);if(s)return n||t.helper(s),s;return t.helper(Yc),t.components.add(r),vh(r,"component")}(e,t):`"${n}"`;const s=w(o)&&o.callee===Xc;let a,l,c,d,h,u=0,p=s||o===Lc||o===Qc||!i&&("svg"===n||"foreignObject"===n||"math"===n);if(r.length>0){const n=Vu(e,t,void 0,i,s);a=n.props,u=n.patchFlag,d=n.dynamicPropNames;const r=n.directives;h=r&&r.length?kd(r.map(e=>function(e,t){const n=[],r=Qu.get(e);r?n.push(t.helperString(r)):(t.helper(Jc),t.directives.add(e.name),n.push(vh(e.name,"directive")));const{loc:i}=e;e.exp&&n.push(e.exp);e.arg&&(e.exp||n.push("void 0"),n.push(e.arg));if(Object.keys(e.modifiers).length){e.arg||(e.exp||n.push("void 0"),n.push("void 0"));const t=Bd("true",!1,i);n.push(Sd(e.modifiers.map(e=>Od(e,t)),i))}return kd(n,e.loc)}(e,t))):void 0,n.shouldUseBlock&&(p=!0)}if(e.children.length>0){o===Fc&&(p=!0,u|=1024);if(i&&o!==Lc&&o!==Fc){const{slots:n,hasDynamicSlots:r}=Iu(e,t);l=n,r&&(u|=1024)}else if(1===e.children.length&&o!==Lc){const n=e.children[0],r=n.type,i=5===r||8===r;i&&0===su(n,t)&&(u|=1),l=i||2===r?n:e.children}else l=e.children}d&&d.length&&(c=function(e){let t="[";for(let n=0,r=e.length;n<r;n++)t+=JSON.stringify(e[n]),n<r-1&&(t+=", ");return t+"]"}(d)),e.codegenNode=Cd(t,o,a,l,0===u?void 0:u,c,h,!!p,!1,i,e.loc)};function Vu(e,t,n=e.props,r,i,o=!1){const{tag:s,loc:a,children:l}=e;let d=[];const h=[],u=[],p=l.length>0;let f=!1,g=0,m=!1,v=!1,A=!1,b=!1,y=!1,w=!1;const C=[],k=e=>{d.length&&(h.push(Sd(zu(d),a)),d=[]),e&&h.push(e)},S=()=>{t.scopes.vFor>0&&d.push(Od(Bd("ref_for",!0),Bd("true")))},O=({key:e,value:n})=>{if(Gd(e)){const o=e.content,s=c(o);if(!s||r&&!i||"onclick"===o.toLowerCase()||"onUpdate:modelValue"===o||_(o)||(b=!0),s&&_(o)&&(w=!0),s&&14===n.type&&(n=n.arguments[0]),20===n.type||(4===n.type||8===n.type)&&su(n,t)>0)return;"ref"===o?m=!0:"class"===o?v=!0:"style"===o?A=!0:"key"===o||C.includes(o)||C.push(o),!r||"class"!==o&&"style"!==o||C.includes(o)||C.push(o)}else y=!0};for(let i=0;i<n.length;i++){const l=n[i];if(6===l.type){const{loc:e,name:n,nameLoc:r,value:i}=l;let o=!0;if("ref"===n&&(m=!0,S()),"is"===n&&($u(s)||i&&i.content.startsWith("vue:")||$d("COMPILER_IS_ON_ELEMENT",t)))continue;d.push(Od(Bd(n,!0,r),Bd(i?i.content:"",o,i?i.loc:e)))}else{const{name:n,arg:i,exp:c,loc:m,modifiers:v}=l,A="bind"===n,b="on"===n;if("slot"===n){r||t.onError(Ud(40,m));continue}if("once"===n||"memo"===n)continue;if("is"===n||A&&ah(i,"is")&&($u(s)||$d("COMPILER_IS_ON_ELEMENT",t)))continue;if(b&&o)continue;if((A&&ah(i,"key")||b&&p&&ah(i,"vue:before-update"))&&(f=!0),A&&ah(i,"ref")&&S(),!i&&(A||b)){if(y=!0,c)if(A){if(k(),$d("COMPILER_V_BIND_OBJECT_ORDER",t)){h.unshift(c);continue}S(),k(),h.push(c)}else k({type:14,loc:m,callee:t.helper(cd),arguments:r?[c]:[c,"true"]});else t.onError(Ud(A?34:35,m));continue}A&&v.some(e=>"prop"===e.content)&&(g|=32);const w=t.directiveTransforms[n];if(w){const{props:n,needRuntime:r}=w(l,e,t);!o&&n.forEach(O),b&&i&&!Gd(i)?k(Sd(n,a)):d.push(...n),r&&(u.push(l),x(r)&&Qu.set(l,r))}else T(n)||(u.push(l),p&&(f=!0))}}let B;if(h.length?(k(),B=h.length>1?Td(t.helper(id),h,a):h[0]):d.length&&(B=Sd(zu(d),a)),y?g|=16:(v&&!r&&(g|=2),A&&!r&&(g|=4),C.length&&(g|=8),b&&(g|=32)),f||0!==g&&32!==g||!(m||w||u.length>0)||(g|=512),!t.inSSR&&B)switch(B.type){case 15:let e=-1,n=-1,r=!1;for(let t=0;t<B.properties.length;t++){const i=B.properties[t].key;Gd(i)?"class"===i.content?e=t:"style"===i.content&&(n=t):i.isHandlerKey||(r=!0)}const i=B.properties[e],o=B.properties[n];r?B=Td(t.helper(ad),[B]):(i&&!Gd(i.value)&&(i.value=Td(t.helper(od),[i.value])),o&&(A||4===o.value.type&&"["===o.value.content.trim()[0]||17===o.value.type)&&(o.value=Td(t.helper(sd),[o.value])));break;case 14:break;default:B=Td(t.helper(ad),[Td(t.helper(ld),[B])])}return{props:B,directives:u,patchFlag:g,dynamicPropNames:C,shouldUseBlock:f}}function zu(e){const t=new Map,n=[];for(let r=0;r<e.length;r++){const i=e[r];if(8===i.key.type||!i.key.isStatic){n.push(i);continue}const o=i.key.content,s=t.get(o);s?("style"===o||"class"===o||c(o))&&Wu(s,i):(t.set(o,i),n.push(i))}return n}function Wu(e,t){17===e.value.type?e.value.elements.push(t.value):e.value=kd([e.value,t.value],e.loc)}function $u(e){return"component"===e||"Component"===e}const Hu=(e,t)=>{if(uh(e)){const{children:n,loc:r}=e,{slotName:i,slotProps:o}=function(e,t){let n,r='"default"';const i=[];for(let t=0;t<e.props.length;t++){const n=e.props[t];if(6===n.type)n.value&&("name"===n.name?r=JSON.stringify(n.value.content):(n.name=D(n.name),i.push(n)));else if("bind"===n.name&&ah(n.arg,"name")){if(n.exp)r=n.exp;else if(n.arg&&4===n.arg.type){const e=D(n.arg.content);r=n.exp=Bd(e,!1,n.arg.loc)}}else"bind"===n.name&&n.arg&&Gd(n.arg)&&(n.arg.content=D(n.arg.content)),i.push(n)}if(i.length>0){const{props:r,directives:o}=Vu(e,t,i,!1,!1);n=r,o.length&&t.onError(Ud(36,o[0].loc))}return{slotName:r,slotProps:n}}(e,t),s=[t.prefixIdentifiers?"_ctx.$slots":"$slots",i,"{}","undefined","true"];let a=2;o&&(s[2]=o,a=3),n.length&&(s[3]=Ed([],n,!1,!1,r),a=4),t.scopeId&&!t.slotted&&(a=5),s.splice(a),e.codegenNode=Td(t.helper(td),s,r)}};const ju=(e,t,n,r)=>{const{loc:i,modifiers:o,arg:s}=e;let a;if(e.exp||o.length||n.onError(Ud(35,i)),4===s.type)if(s.isStatic){let e=s.content;0,e.startsWith("vue:")&&(e=`vnode-${e.slice(4)}`);a=Bd(0!==t.tagType||e.startsWith("vnode")||!/[A-Z]/.test(e)?N(D(e)):`on:${e}`,!0,s.loc)}else a=_d([`${n.helperString(ud)}(`,s,")"]);else a=s,a.children.unshift(`${n.helperString(ud)}(`),a.children.push(")");let l=e.exp;l&&!l.content.trim()&&(l=void 0);let c=n.cacheHandlers&&!l&&!n.inVOnce;if(l){const e=nh(l),t=!(e||ih(l)),n=l.content.includes(";");0,(t||c&&e)&&(l=_d([`${t?"$event":"(...args)"} => ${n?"{":"("}`,l,n?"}":")"]))}let d={props:[Od(a,l||Bd("() => {}",!1,i))]};return r&&(d=r(d)),c&&(d.props[0].value=n.cache(d.props[0].value)),d.props.forEach(e=>e.key.isHandlerKey=!0),d},qu=(e,t,n)=>{const{modifiers:r,loc:i}=e,o=e.arg;let{exp:s}=e;return s&&4===s.type&&!s.content.trim()&&(s=void 0),4!==o.type?(o.children.unshift("("),o.children.push(') || ""')):o.isStatic||(o.content=o.content?`${o.content} || ""`:'""'),r.some(e=>"camel"===e.content)&&(4===o.type?o.isStatic?o.content=D(o.content):o.content=`${n.helperString(dd)}(${o.content})`:(o.children.unshift(`${n.helperString(dd)}(`),o.children.push(")"))),n.inSSR||(r.some(e=>"prop"===e.content)&&Uu(o,"."),r.some(e=>"attr"===e.content)&&Uu(o,"^")),{props:[Od(o,s)]}},Uu=(e,t)=>{4===e.type?e.isStatic?e.content=t+e.content:e.content=`\`${t}\${${e.content}}\``:(e.children.unshift(`'${t}' + (`),e.children.push(")"))},Gu=(e,t)=>{if(0===e.type||1===e.type||11===e.type||10===e.type)return()=>{const n=e.children;let r,i=!1;for(let e=0;e<n.length;e++){const t=n[e];if(lh(t)){i=!0;for(let i=e+1;i<n.length;i++){const o=n[i];if(!lh(o)){r=void 0;break}r||(r=n[e]=_d([t],t.loc)),r.children.push(" + ",o),n.splice(i,1),i--}}}if(i&&(1!==n.length||0!==e.type&&(1!==e.type||0!==e.tagType||e.props.find(e=>7===e.type&&!t.directiveTransforms[e.name])||"template"===e.tag)))for(let e=0;e<n.length;e++){const r=n[e];if(lh(r)||8===r.type){const i=[];2===r.type&&" "===r.content||i.push(r),t.ssr||0!==su(r,t)||i.push("1"),n[e]={type:12,content:r,loc:r.loc,codegenNode:Td(t.helper(Uc),i)}}}}},Yu=new WeakSet,Xu=(e,t)=>{if(1===e.type&&oh(e,"once",!0)){if(Yu.has(e)||t.inVOnce||t.inSSR)return;return Yu.add(e),t.inVOnce=!0,t.helper(pd),()=>{t.inVOnce=!1;const e=t.currentNode;e.codegenNode&&(e.codegenNode=t.cache(e.codegenNode,!0,!0))}}},Ju=(e,t,n)=>{const{exp:r,arg:i}=e;if(!r)return n.onError(Ud(41,e.loc)),Ku();const o=r.loc.source.trim(),s=4===r.type?r.content:o,a=n.bindingMetadata[o];if("props"===a||"props-aliased"===a)return n.onError(Ud(44,r.loc)),Ku();if("literal-const"===a||"setup-const"===a)return n.onError(Ud(45,r.loc)),Ku();if(!s.trim()||!nh(r))return n.onError(Ud(42,r.loc)),Ku();const l=i||Bd("modelValue",!0),c=i?Gd(i)?`onUpdate:${D(i.content)}`:_d(['"onUpdate:" + ',i]):"onUpdate:modelValue";let d;d=_d([`${n.isTS?"($event: any)":"$event"} => ((`,r,") = $event)"]);const h=[Od(l,e.exp),Od(c,d)];if(e.modifiers.length&&1===t.tagType){const t=e.modifiers.map(e=>e.content).map(e=>(Jd(e)?e:JSON.stringify(e))+": true").join(", "),n=i?Gd(i)?`${i.content}Modifiers`:_d([i,' + "Modifiers"']):"modelModifiers";h.push(Od(n,Bd(`{ ${t} }`,!1,e.loc,2)))}return Ku(h)};function Ku(e=[]){return{props:e}}const Zu=/[\w).+\-_$\]]/,ep=(e,t)=>{$d("COMPILER_FILTERS",t)&&(5===e.type?tp(e.content,t):1===e.type&&e.props.forEach(e=>{7===e.type&&"for"!==e.name&&e.exp&&tp(e.exp,t)}))};function tp(e,t){if(4===e.type)np(e,t);else for(let n=0;n<e.children.length;n++){const r=e.children[n];"object"==typeof r&&(4===r.type?np(r,t):8===r.type?tp(e,t):5===r.type&&tp(r.content,t))}}function np(e,t){const n=e.content;let r,i,o,s,a=!1,l=!1,c=!1,d=!1,h=0,u=0,p=0,f=0,g=[];for(o=0;o<n.length;o++)if(i=r,r=n.charCodeAt(o),a)39===r&&92!==i&&(a=!1);else if(l)34===r&&92!==i&&(l=!1);else if(c)96===r&&92!==i&&(c=!1);else if(d)47===r&&92!==i&&(d=!1);else if(124!==r||124===n.charCodeAt(o+1)||124===n.charCodeAt(o-1)||h||u||p){switch(r){case 34:l=!0;break;case 39:a=!0;break;case 96:c=!0;break;case 40:p++;break;case 41:p--;break;case 91:u++;break;case 93:u--;break;case 123:h++;break;case 125:h--}if(47===r){let e,t=o-1;for(;t>=0&&(e=n.charAt(t)," "===e);t--);e&&Zu.test(e)||(d=!0)}}else void 0===s?(f=o+1,s=n.slice(0,o).trim()):m();function m(){g.push(n.slice(f,o).trim()),f=o+1}if(void 0===s?s=n.slice(0,o).trim():0!==f&&m(),g.length){for(o=0;o<g.length;o++)s=rp(s,g[o],t);e.content=s,e.ast=void 0}}function rp(e,t,n){n.helper(Kc);const r=t.indexOf("(");if(r<0)return n.filters.add(t),`${vh(t,"filter")}(${e})`;{const i=t.slice(0,r),o=t.slice(r+1);return n.filters.add(i),`${vh(i,"filter")}(${e}${")"!==o?","+o:o}`}}const ip=new WeakSet,op=(e,t)=>{if(1===e.type){const n=oh(e,"memo");if(!n||ip.has(e)||t.inSSR)return;return ip.add(e),()=>{const r=e.codegenNode||t.currentNode.codegenNode;r&&13===r.type&&(1!==e.tagType&&Rd(r,t),e.codegenNode=Td(t.helper(bd),[n.exp,Ed(void 0,r),"_cache",String(t.cached.length)]),t.cached.push(null))}}},sp=(e,t)=>{if(1===e.type)for(const n of e.props)if(7===n.type&&"bind"===n.name&&(!n.exp||4===n.exp.type&&!n.exp.content.trim())&&n.arg){const e=n.arg;if(4===e.type&&e.isStatic){const t=D(e.content);(Kd.test(t[0])||"-"===t[0])&&(n.exp=Bd(t,!1,e.loc))}else t.onError(Ud(53,e.loc)),n.exp=Bd("",!0,e.loc)}};function ap(e,t={}){const n=t.onError||jd,r="module"===t.mode;!0===t.prefixIdentifiers?n(Ud(48)):r&&n(Ud(49));t.cacheHandlers&&n(Ud(50)),t.scopeId&&!r&&n(Ud(51));const i=h({},t,{prefixIdentifiers:!1}),o=y(e)?nu(e,i):e,[s,a]=[[sp,Xu,Su,op,Tu,ep,Hu,Fu,Pu,Gu],{on:ju,bind:qu,model:Ju}];return uu(o,h({},i,{nodeTransforms:[...s,...t.nodeTransforms||[]],directiveTransforms:h({},a,t.directiveTransforms||{})})),vu(o,i)}const lp=Symbol(""),cp=Symbol(""),dp=Symbol(""),hp=Symbol(""),up=Symbol(""),pp=Symbol(""),fp=Symbol(""),gp=Symbol(""),mp=Symbol(""),vp=Symbol("");var Ap;let bp;Ap={[lp]:"vModelRadio",[cp]:"vModelCheckbox",[dp]:"vModelText",[hp]:"vModelSelect",[up]:"vModelDynamic",[pp]:"withModifiers",[fp]:"withKeys",[gp]:"vShow",[mp]:"Transition",[vp]:"TransitionGroup"},Object.getOwnPropertySymbols(Ap).forEach(e=>{xd[e]=Ap[e]});const yp={parseMode:"html",isVoidTag:te,isNativeTag:e=>K(e)||Z(e)||ee(e),isPreTag:e=>"pre"===e,isIgnoreNewlineTag:e=>"pre"===e||"textarea"===e,decodeEntities:function(e,t=!1){return bp||(bp=document.createElement("div")),t?(bp.innerHTML=`<div foo="${e.replace(/"/g,"&quot;")}">`,bp.children[0].getAttribute("foo")):(bp.innerHTML=e,bp.textContent)},isBuiltInComponent:e=>"Transition"===e||"transition"===e?mp:"TransitionGroup"===e||"transition-group"===e?vp:void 0,getNamespace(e,t,n){let r=t?t.ns:n;if(t&&2===r)if("annotation-xml"===t.tag){if("svg"===e)return 1;t.props.some(e=>6===e.type&&"encoding"===e.name&&null!=e.value&&("text/html"===e.value.content||"application/xhtml+xml"===e.value.content))&&(r=0)}else/^m(?:[ions]|text)$/.test(t.tag)&&"mglyph"!==e&&"malignmark"!==e&&(r=0);else t&&1===r&&("foreignObject"!==t.tag&&"desc"!==t.tag&&"title"!==t.tag||(r=0));if(0===r){if("svg"===e)return 1;if("math"===e)return 2}return r}},xp=(e,t)=>{const n=Y(e);return Bd(JSON.stringify(n),!1,t,3)};function Cp(e,t){return Ud(e,t)}const kp=i("passive,once,capture"),Sp=i("stop,prevent,self,ctrl,shift,alt,meta,exact,middle"),Op=i("left,right"),Bp=i("onkeyup,onkeydown,onkeypress"),_p=(e,t)=>Gd(e)&&"onclick"===e.content.toLowerCase()?Bd(t,!0):4!==e.type?_d(["(",e,`) === "onClick" ? "${t}" : (`,e,")"]):e;const Tp=(e,t)=>{1!==e.type||0!==e.tagType||"script"!==e.tag&&"style"!==e.tag||t.removeNode()};const Ep=[e=>{1===e.type&&e.props.forEach((t,n)=>{6===t.type&&"style"===t.name&&t.value&&(e.props[n]={type:7,name:"bind",arg:Bd("style",!0,t.loc),exp:xp(t.value.content,t.loc),modifiers:[],loc:t.loc})})}],Mp={cloak:()=>({props:[]}),html:(e,t,n)=>{const{exp:r,loc:i}=e;return r||n.onError(Cp(54,i)),t.children.length&&(n.onError(Cp(55,i)),t.children.length=0),{props:[Od(Bd("innerHTML",!0,i),r||Bd("",!0))]}},text:(e,t,n)=>{const{exp:r,loc:i}=e;return r||n.onError(Cp(56,i)),t.children.length&&(n.onError(Cp(57,i)),t.children.length=0),{props:[Od(Bd("textContent",!0),r?su(r,n)>0?r:Td(n.helperString(rd),[r],i):Bd("",!0))]}},model:(e,t,n)=>{const r=Ju(e,t,n);if(!r.props.length||1===t.tagType)return r;e.arg&&n.onError(Cp(59,e.arg.loc));const{tag:i}=t,o=n.isCustomElement(i);if("input"===i||"textarea"===i||"select"===i||o){let s=dp,a=!1;if("input"===i||o){const r=sh(t,"type");if(r){if(7===r.type)s=up;else if(r.value)switch(r.value.content){case"radio":s=lp;break;case"checkbox":s=cp;break;case"file":a=!0,n.onError(Cp(60,e.loc))}}else(function(e){return e.props.some(e=>!(7!==e.type||"bind"!==e.name||e.arg&&4===e.arg.type&&e.arg.isStatic))})(t)&&(s=up)}else"select"===i&&(s=hp);a||(r.needRuntime=n.helper(s))}else n.onError(Cp(58,e.loc));return r.props=r.props.filter(e=>!(4===e.key.type&&"modelValue"===e.key.content)),r},on:(e,t,n)=>ju(e,t,n,t=>{const{modifiers:r}=e;if(!r.length)return t;let{key:i,value:o}=t.props[0];const{keyModifiers:s,nonKeyModifiers:a,eventOptionModifiers:l}=((e,t,n)=>{const r=[],i=[],o=[];for(let s=0;s<t.length;s++){const a=t[s].content;"native"===a&&Hd("COMPILER_V_ON_NATIVE",n)||kp(a)?o.push(a):Op(a)?Gd(e)?Bp(e.content.toLowerCase())?r.push(a):i.push(a):(r.push(a),i.push(a)):Sp(a)?i.push(a):r.push(a)}return{keyModifiers:r,nonKeyModifiers:i,eventOptionModifiers:o}})(i,r,n,e.loc);if(a.includes("right")&&(i=_p(i,"onContextmenu")),a.includes("middle")&&(i=_p(i,"onMouseup")),a.length&&(o=Td(n.helper(pp),[o,JSON.stringify(a)])),!s.length||Gd(i)&&!Bp(i.content.toLowerCase())||(o=Td(n.helper(fp),[o,JSON.stringify(s)])),l.length){const e=l.map(I).join("");i=Gd(i)?Bd(`${i.content}${e}`,!0):_d(["(",i,`) + "${e}"`])}return{props:[Od(i,o)]}}),show:(e,t,n)=>{const{exp:r,loc:i}=e;return r||n.onError(Cp(62,i)),{props:[],needRuntime:n.helper(gp)}}};const Dp=Object.create(null);Aa(function(e,t){if(!y(e)){if(!e.nodeType)return a;e=e.innerHTML}const n=function(e,t){return e+JSON.stringify(t,(e,t)=>"function"==typeof t?t.toString():t)}(e,t),i=Dp[n];if(i)return i;if("#"===e[0]){const t=document.querySelector(e);0,e=t?t.innerHTML:""}const o=h({hoistStatic:!0,onError:void 0,onWarn:a},t);o.isCustomElement||"undefined"==typeof customElements||(o.isCustomElement=e=>!!customElements.get(e));const{code:s}=function(e,t={}){return ap(e,h({},yp,t,{nodeTransforms:[Tp,...Ep,...t.nodeTransforms||[]],directiveTransforms:h({},Mp,t.directiveTransforms||{}),transformHoist:null}))}(e,o),l=new Function("Vue",s)(r);return l._rc=!0,Dp[n]=l});const Pp="undefined"!=typeof document;function Rp(e){return"object"==typeof e||"displayName"in e||"props"in e||"__vccOpts"in e}function Ip(e){return e.__esModule||"Module"===e[Symbol.toStringTag]||e.default&&Rp(e.default)}const Np=Object.assign;function Lp(e,t){const n={};for(const r in t){const i=t[r];n[r]=Fp(i)?i.map(e):e(i)}return n}const Qp=()=>{},Fp=Array.isArray;function Vp(e,t){const n={};for(const r in e)n[r]=r in t?t[r]:e[r];return n}const zp=/#/g,Wp=/&/g,$p=/\//g,Hp=/=/g,jp=/\?/g,qp=/\+/g,Up=/%5B/g,Gp=/%5D/g,Yp=/%5E/g,Xp=/%60/g,Jp=/%7B/g,Kp=/%7C/g,Zp=/%7D/g,ef=/%20/g;function tf(e){return null==e?"":encodeURI(""+e).replace(Kp,"|").replace(Up,"[").replace(Gp,"]")}function nf(e){return tf(e).replace(Jp,"{").replace(Zp,"}").replace(Yp,"^")}function rf(e){return tf(e).replace(qp,"%2B").replace(ef,"+").replace(zp,"%23").replace(Wp,"%26").replace(Xp,"`").replace(Jp,"{").replace(Zp,"}").replace(Yp,"^")}function of(e){return rf(e).replace(Hp,"%3D")}function sf(e){return function(e){return tf(e).replace(zp,"%23").replace(jp,"%3F")}(e).replace($p,"%2F")}function af(e){if(null==e)return null;try{return decodeURIComponent(""+e)}catch(e){}return""+e}const lf=/\/$/;function cf(e,t,n="/"){let r,i={},o="",s="";const a=t.indexOf("#");let l=t.indexOf("?");return l=a>=0&&l>a?-1:l,l>=0&&(r=t.slice(0,l),o=t.slice(l,a>0?a:t.length),i=e(o.slice(1))),a>=0&&(r=r||t.slice(0,a),s=t.slice(a,t.length)),r=function(e,t){if(e.startsWith("/"))return e;0;if(!e)return t;const n=t.split("/"),r=e.split("/"),i=r[r.length-1];".."!==i&&"."!==i||r.push("");let o,s,a=n.length-1;for(o=0;o<r.length;o++)if(s=r[o],"."!==s){if(".."!==s)break;a>1&&a--}return n.slice(0,a).join("/")+"/"+r.slice(o).join("/")}(null!=r?r:t,n),{fullPath:r+o+s,path:r,query:i,hash:af(s)}}function df(e,t){return t&&e.toLowerCase().startsWith(t.toLowerCase())?e.slice(t.length)||"/":e}function hf(e,t){return(e.aliasOf||e)===(t.aliasOf||t)}function uf(e,t){if(Object.keys(e).length!==Object.keys(t).length)return!1;for(var n in e)if(!pf(e[n],t[n]))return!1;return!0}function pf(e,t){return Fp(e)?ff(e,t):Fp(t)?ff(t,e):e?.valueOf()===t?.valueOf()}function ff(e,t){return Fp(t)?e.length===t.length&&e.every((e,n)=>e===t[n]):1===e.length&&e[0]===t}const gf={path:"/",name:void 0,params:{},query:{},hash:"",fullPath:"/",matched:[],meta:{},redirectedFrom:void 0};let mf=function(e){return e.pop="pop",e.push="push",e}({}),vf=function(e){return e.back="back",e.forward="forward",e.unknown="",e}({});function Af(e){if(!e)if(Pp){const t=document.querySelector("base");e=(e=t&&t.getAttribute("href")||"/").replace(/^\w+:\/\/[^\/]+/,"")}else e="/";return"/"!==e[0]&&"#"!==e[0]&&(e="/"+e),e.replace(lf,"")}const bf=/^[^#]+#/;function yf(e,t){return e.replace(bf,"#")+t}const xf=()=>({left:window.scrollX,top:window.scrollY});function wf(e){let t;if("el"in e){const n=e.el,r="string"==typeof n&&n.startsWith("#");0;const i="string"==typeof n?r?document.getElementById(n.slice(1)):document.querySelector(n):n;if(!i)return;t=function(e,t){const n=document.documentElement.getBoundingClientRect(),r=e.getBoundingClientRect();return{behavior:t.behavior,left:r.left-n.left-(t.left||0),top:r.top-n.top-(t.top||0)}}(i,e)}else t=e;"scrollBehavior"in document.documentElement.style?window.scrollTo(t):window.scrollTo(null!=t.left?t.left:window.scrollX,null!=t.top?t.top:window.scrollY)}function Cf(e,t){return(history.state?history.state.position-t:-1)+e}const kf=new Map;function Sf(e){return"string"==typeof e||"symbol"==typeof e}let Of=function(e){return e[e.MATCHER_NOT_FOUND=1]="MATCHER_NOT_FOUND",e[e.NAVIGATION_GUARD_REDIRECT=2]="NAVIGATION_GUARD_REDIRECT",e[e.NAVIGATION_ABORTED=4]="NAVIGATION_ABORTED",e[e.NAVIGATION_CANCELLED=8]="NAVIGATION_CANCELLED",e[e.NAVIGATION_DUPLICATED=16]="NAVIGATION_DUPLICATED",e}({});const Bf=Symbol("");Of.MATCHER_NOT_FOUND,Of.NAVIGATION_GUARD_REDIRECT,Of.NAVIGATION_ABORTED,Of.NAVIGATION_CANCELLED,Of.NAVIGATION_DUPLICATED;function _f(e,t){return Np(new Error,{type:e,[Bf]:!0},t)}function Tf(e,t){return e instanceof Error&&Bf in e&&(null==t||!!(e.type&t))}const Ef=["params","query","hash"];function Mf(e){const t={};if(""===e||"?"===e)return t;const n=("?"===e[0]?e.slice(1):e).split("&");for(let e=0;e<n.length;++e){const r=n[e].replace(qp," "),i=r.indexOf("="),o=af(i<0?r:r.slice(0,i)),s=i<0?null:af(r.slice(i+1));if(o in t){let e=t[o];Fp(e)||(e=t[o]=[e]),e.push(s)}else t[o]=s}return t}function Df(e){let t="";for(let n in e){const r=e[n];n=of(n),null!=r?(Fp(r)?r.map(e=>e&&rf(e)):[r&&rf(r)]).forEach(e=>{void 0!==e&&(t+=(t.length?"&":"")+n,null!=e&&(t+="="+e))}):void 0!==r&&(t+=(t.length?"&":"")+n)}return t}function Pf(e){const t={};for(const n in e){const r=e[n];void 0!==r&&(t[n]=Fp(r)?r.map(e=>null==e?null:""+e):null==r?r:""+r)}return t}const Rf=Symbol(""),If=Symbol(""),Nf=Symbol(""),Lf=Symbol(""),Qf=Symbol("");function Ff(){let e=[];return{add:function(t){return e.push(t),()=>{const n=e.indexOf(t);n>-1&&e.splice(n,1)}},list:()=>e.slice(),reset:function(){e=[]}}}function Vf(e,t,n){const r=()=>{e[t].delete(n)};Ri(r),wi(r),xi(()=>{e[t].add(n)}),e[t].add(n)}function zf(e){const t=or(Rf,{}).value;t&&Vf(t,"leaveGuards",e)}function Wf(e,t,n,r,i,o=e=>e()){const s=r&&(r.enterCallbacks[i]=r.enterCallbacks[i]||[]);return()=>new Promise((a,l)=>{const c=e=>{var o;!1===e?l(_f(Of.NAVIGATION_ABORTED,{from:n,to:t})):e instanceof Error?l(e):"string"==typeof(o=e)||o&&"object"==typeof o?l(_f(Of.NAVIGATION_GUARD_REDIRECT,{from:t,to:e})):(s&&r.enterCallbacks[i]===s&&"function"==typeof e&&s.push(e),a())},d=o(()=>e.call(r&&r.instances[i],t,n,c));let h=Promise.resolve(d);e.length<3&&(h=h.then(c)),h.catch(e=>l(e))})}function $f(e,t,n,r,i=e=>e()){const o=[];for(const s of e){0;for(const e in s.components){let a=s.components[e];if("beforeRouteEnter"===t||s.instances[e])if(Rp(a)){const l=(a.__vccOpts||a)[t];l&&o.push(Wf(l,n,r,s,e,i))}else{let l=a();0,o.push(()=>l.then(o=>{if(!o)throw new Error(`Couldn't resolve component "${e}" at "${s.path}"`);const a=Ip(o)?o.default:o;s.mods[e]=o,s.components[e]=a;const l=(a.__vccOpts||a)[t];return l&&Wf(l,n,r,s,e,i)()}))}}}return o}function Hf(e,t){const{pathname:n,search:r,hash:i}=t,o=e.indexOf("#");if(o>-1){let t=i.includes(e.slice(o))?e.slice(o).length:1,n=i.slice(t);return"/"!==n[0]&&(n="/"+n),df(n,"")}return df(n,e)+r+i}function jf(e,t,n,r=!1,i=!1){return{back:e,current:t,forward:n,replaced:r,position:window.history.length,scroll:i?xf():null}}function qf(e){const{history:t,location:n}=window,r={value:Hf(e,n)},i={value:t.state};function o(r,o,s){const a=e.indexOf("#"),l=a>-1?(n.host&&document.querySelector("base")?e:e.slice(a))+r:location.protocol+"//"+location.host+e+r;try{t[s?"replaceState":"pushState"](o,"",l),i.value=o}catch(e){console.error(e),n[s?"replace":"assign"](l)}}return i.value||o(r.value,{back:null,current:r.value,forward:null,position:t.length-1,replaced:!0,scroll:null},!0),{location:r,state:i,push:function(e,n){const s=Np({},i.value,t.state,{forward:e,scroll:xf()});o(s.current,s,!0),o(e,Np({},jf(r.value,e,null),{position:s.position+1},n),!1),r.value=e},replace:function(e,n){o(e,Np({},t.state,jf(i.value.back,e,i.value.forward,!0),n,{position:i.value.position}),!0),r.value=e}}}function Uf(e){const t=qf(e=Af(e)),n=function(e,t,n,r){let i=[],o=[],s=null;const a=({state:o})=>{const a=Hf(e,location),l=n.value,c=t.value;let d=0;if(o){if(n.value=a,t.value=o,s&&s===l)return void(s=null);d=c?o.position-c.position:0}else r(a);i.forEach(e=>{e(n.value,l,{delta:d,type:mf.pop,direction:d?d>0?vf.forward:vf.back:vf.unknown})})};function l(){if("hidden"===document.visibilityState){const{history:e}=window;if(!e.state)return;e.replaceState(Np({},e.state,{scroll:xf()}),"")}}return window.addEventListener("popstate",a),window.addEventListener("pagehide",l),document.addEventListener("visibilitychange",l),{pauseListeners:function(){s=n.value},listen:function(e){i.push(e);const t=()=>{const t=i.indexOf(e);t>-1&&i.splice(t,1)};return o.push(t),t},destroy:function(){for(const e of o)e();o=[],window.removeEventListener("popstate",a),window.removeEventListener("pagehide",l),document.removeEventListener("visibilitychange",l)}}}(e,t.state,t.location,t.replace);const r=Np({location:"",base:e,go:function(e,t=!0){t||n.pauseListeners(),history.go(e)},createHref:yf.bind(null,e)},t,n);return Object.defineProperty(r,"location",{enumerable:!0,get:()=>t.location.value}),Object.defineProperty(r,"state",{enumerable:!0,get:()=>t.state.value}),r}let Gf=function(e){return e[e.Static=0]="Static",e[e.Param=1]="Param",e[e.Group=2]="Group",e}({});var Yf=function(e){return e[e.Static=0]="Static",e[e.Param=1]="Param",e[e.ParamRegExp=2]="ParamRegExp",e[e.ParamRegExpEnd=3]="ParamRegExpEnd",e[e.EscapeNext=4]="EscapeNext",e}(Yf||{});const Xf={type:Gf.Static,value:""},Jf=/[a-zA-Z0-9_]/;const Kf="[^/]+?",Zf={sensitive:!1,strict:!1,start:!0,end:!0};var eg=function(e){return e[e._multiplier=10]="_multiplier",e[e.Root=90]="Root",e[e.Segment=40]="Segment",e[e.SubSegment=30]="SubSegment",e[e.Static=40]="Static",e[e.Dynamic=20]="Dynamic",e[e.BonusCustomRegExp=10]="BonusCustomRegExp",e[e.BonusWildcard=-50]="BonusWildcard",e[e.BonusRepeatable=-20]="BonusRepeatable",e[e.BonusOptional=-8]="BonusOptional",e[e.BonusStrict=.7000000000000001]="BonusStrict",e[e.BonusCaseSensitive=.25]="BonusCaseSensitive",e}(eg||{});const tg=/[.+*?^${}()[\]/\\]/g;function ng(e,t){let n=0;for(;n<e.length&&n<t.length;){const r=t[n]-e[n];if(r)return r;n++}return e.length<t.length?1===e.length&&e[0]===eg.Static+eg.Segment?-1:1:e.length>t.length?1===t.length&&t[0]===eg.Static+eg.Segment?1:-1:0}function rg(e,t){let n=0;const r=e.score,i=t.score;for(;n<r.length&&n<i.length;){const e=ng(r[n],i[n]);if(e)return e;n++}if(1===Math.abs(i.length-r.length)){if(ig(r))return 1;if(ig(i))return-1}return i.length-r.length}function ig(e){const t=e[e.length-1];return e.length>0&&t[t.length-1]<0}const og={strict:!1,end:!0,sensitive:!1};function sg(e,t,n){const r=function(e,t){const n=Np({},Zf,t),r=[];let i=n.start?"^":"";const o=[];for(const t of e){const e=t.length?[]:[eg.Root];n.strict&&!t.length&&(i+="/");for(let r=0;r<t.length;r++){const s=t[r];let a=eg.Segment+(n.sensitive?eg.BonusCaseSensitive:0);if(s.type===Gf.Static)r||(i+="/"),i+=s.value.replace(tg,"\\$&"),a+=eg.Static;else if(s.type===Gf.Param){const{value:e,repeatable:n,optional:l,regexp:c}=s;o.push({name:e,repeatable:n,optional:l});const d=c||Kf;d!==Kf&&(a+=eg.BonusCustomRegExp);let h=n?`((?:${d})(?:/(?:${d}))*)`:`(${d})`;r||(h=l&&t.length<2?`(?:/${h})`:"/"+h),l&&(h+="?"),i+=h,a+=eg.Dynamic,l&&(a+=eg.BonusOptional),n&&(a+=eg.BonusRepeatable),".*"===d&&(a+=eg.BonusWildcard)}e.push(a)}r.push(e)}if(n.strict&&n.end){const e=r.length-1;r[e][r[e].length-1]+=eg.BonusStrict}n.strict||(i+="/?"),n.end?i+="$":n.strict&&!i.endsWith("/")&&(i+="(?:/|$)");const s=new RegExp(i,n.sensitive?"":"i");return{re:s,score:r,keys:o,parse:function(e){const t=e.match(s),n={};if(!t)return null;for(let e=1;e<t.length;e++){const r=t[e]||"",i=o[e-1];n[i.name]=r&&i.repeatable?r.split("/"):r}return n},stringify:function(t){let n="",r=!1;for(const i of e){r&&n.endsWith("/")||(n+="/"),r=!1;for(const e of i)if(e.type===Gf.Static)n+=e.value;else if(e.type===Gf.Param){const{value:o,repeatable:s,optional:a}=e,l=o in t?t[o]:"";if(Fp(l)&&!s)throw new Error(`Provided param "${o}" is an array but it is not repeatable (* or + modifiers)`);const c=Fp(l)?l.join("/"):l;if(!c){if(!a)throw new Error(`Missing required param "${o}"`);i.length<2&&(n.endsWith("/")?n=n.slice(0,-1):r=!0)}n+=c}}return n||"/"}}}(function(e){if(!e)return[[]];if("/"===e)return[[Xf]];if(!e.startsWith("/"))throw new Error(`Invalid path "${e}"`);function t(e){throw new Error(`ERR (${n})/"${c}": ${e}`)}let n=Yf.Static,r=n;const i=[];let o;function s(){o&&i.push(o),o=[]}let a,l=0,c="",d="";function h(){c&&(n===Yf.Static?o.push({type:Gf.Static,value:c}):n===Yf.Param||n===Yf.ParamRegExp||n===Yf.ParamRegExpEnd?(o.length>1&&("*"===a||"+"===a)&&t(`A repeatable param (${c}) must be alone in its segment. eg: '/:ids+.`),o.push({type:Gf.Param,value:c,regexp:d,repeatable:"*"===a||"+"===a,optional:"*"===a||"?"===a})):t("Invalid state to consume buffer"),c="")}function u(){c+=a}for(;l<e.length;)if(a=e[l++],"\\"!==a||n===Yf.ParamRegExp)switch(n){case Yf.Static:"/"===a?(c&&h(),s()):":"===a?(h(),n=Yf.Param):u();break;case Yf.EscapeNext:u(),n=r;break;case Yf.Param:"("===a?n=Yf.ParamRegExp:Jf.test(a)?u():(h(),n=Yf.Static,"*"!==a&&"?"!==a&&"+"!==a&&l--);break;case Yf.ParamRegExp:")"===a?"\\"==d[d.length-1]?d=d.slice(0,-1)+a:n=Yf.ParamRegExpEnd:d+=a;break;case Yf.ParamRegExpEnd:h(),n=Yf.Static,"*"!==a&&"?"!==a&&"+"!==a&&l--,d="";break;default:t("Unknown state")}else r=n,n=Yf.EscapeNext;return n===Yf.ParamRegExp&&t(`Unfinished custom RegExp for param "${c}"`),h(),s(),i}(e.path),n);const i=Np(r,{record:e,parent:t,children:[],alias:[]});return t&&!i.record.aliasOf==!t.record.aliasOf&&t.children.push(i),i}function ag(e,t){const n=[],r=new Map;function i(e,n,r){const a=!r,l=cg(e);l.aliasOf=r&&r.record;const c=Vp(t,e),d=[l];if("alias"in e){const t="string"==typeof e.alias?[e.alias]:e.alias;for(const e of t)d.push(cg(Np({},l,{components:r?r.record.components:l.components,path:e,aliasOf:r?r.record:l})))}let h,u;for(const t of d){const{path:d}=t;if(n&&"/"!==d[0]){const e=n.record.path,r="/"===e[e.length-1]?"":"/";t.path=n.record.path+(d&&r+d)}if(h=sg(t,n,c),r?r.alias.push(h):(u=u||h,u!==h&&u.alias.push(h),a&&e.name&&!hg(h)&&o(e.name)),pg(h)&&s(h),l.children){const e=l.children;for(let t=0;t<e.length;t++)i(e[t],h,r&&r.children[t])}r=r||h}return u?()=>{o(u)}:Qp}function o(e){if(Sf(e)){const t=r.get(e);t&&(r.delete(e),n.splice(n.indexOf(t),1),t.children.forEach(o),t.alias.forEach(o))}else{const t=n.indexOf(e);t>-1&&(n.splice(t,1),e.record.name&&r.delete(e.record.name),e.children.forEach(o),e.alias.forEach(o))}}function s(e){const t=function(e,t){let n=0,r=t.length;for(;n!==r;){const i=n+r>>1;rg(e,t[i])<0?r=i:n=i+1}const i=function(e){let t=e;for(;t=t.parent;)if(pg(t)&&0===rg(e,t))return t}(e);i&&(r=t.lastIndexOf(i,r-1));return r}(e,n);n.splice(t,0,e),e.record.name&&!hg(e)&&r.set(e.record.name,e)}return t=Vp(og,t),e.forEach(e=>i(e)),{addRoute:i,resolve:function(e,t){let i,o,s,a={};if("name"in e&&e.name){if(i=r.get(e.name),!i)throw _f(Of.MATCHER_NOT_FOUND,{location:e});0,s=i.record.name,a=Np(lg(t.params,i.keys.filter(e=>!e.optional).concat(i.parent?i.parent.keys.filter(e=>e.optional):[]).map(e=>e.name)),e.params&&lg(e.params,i.keys.map(e=>e.name))),o=i.stringify(a)}else if(null!=e.path)o=e.path,i=n.find(e=>e.re.test(o)),i&&(a=i.parse(o),s=i.record.name);else{if(i=t.name?r.get(t.name):n.find(e=>e.re.test(t.path)),!i)throw _f(Of.MATCHER_NOT_FOUND,{location:e,currentLocation:t});s=i.record.name,a=Np({},t.params,e.params),o=i.stringify(a)}const l=[];let c=i;for(;c;)l.unshift(c.record),c=c.parent;return{name:s,path:o,params:a,matched:l,meta:ug(l)}},removeRoute:o,clearRoutes:function(){n.length=0,r.clear()},getRoutes:function(){return n},getRecordMatcher:function(e){return r.get(e)}}}function lg(e,t){const n={};for(const r of t)r in e&&(n[r]=e[r]);return n}function cg(e){const t={path:e.path,redirect:e.redirect,name:e.name,meta:e.meta||{},aliasOf:e.aliasOf,beforeEnter:e.beforeEnter,props:dg(e),children:e.children||[],instances:{},leaveGuards:new Set,updateGuards:new Set,enterCallbacks:{},components:"components"in e?e.components||null:e.component&&{default:e.component}};return Object.defineProperty(t,"mods",{value:{}}),t}function dg(e){const t={},n=e.props||!1;if("component"in e)t.default=n;else for(const r in e.components)t[r]="object"==typeof n?n[r]:n;return t}function hg(e){for(;e;){if(e.record.aliasOf)return!0;e=e.parent}return!1}function ug(e){return e.reduce((e,t)=>Np(e,t.meta),{})}function pg({record:e}){return!!(e.name||e.components&&Object.keys(e.components).length||e.redirect)}function fg(e){const t=or(Nf),n=or(Lf);const r=_a(()=>{const n=Zt(e.to);return t.resolve(n)}),i=_a(()=>{const{matched:e}=r.value,{length:t}=e,i=e[t-1],o=n.matched;if(!i||!o.length)return-1;const s=o.findIndex(hf.bind(null,i));if(s>-1)return s;const a=vg(e[t-2]);return t>1&&vg(i)===a&&o[o.length-1].path!==a?o.findIndex(hf.bind(null,e[t-2])):s}),o=_a(()=>i.value>-1&&function(e,t){for(const n in t){const r=t[n],i=e[n];if("string"==typeof r){if(r!==i)return!1}else if(!Fp(i)||i.length!==r.length||r.some((e,t)=>e.valueOf()!==i[t].valueOf()))return!1}return!0}(n.params,r.value.params)),s=_a(()=>i.value>-1&&i.value===n.matched.length-1&&uf(n.params,r.value.params));return{route:r,href:_a(()=>r.value.href),isActive:o,isExactActive:s,navigate:function(n={}){if(function(e){if(e.metaKey||e.altKey||e.ctrlKey||e.shiftKey)return;if(e.defaultPrevented)return;if(void 0!==e.button&&0!==e.button)return;if(e.currentTarget&&e.currentTarget.getAttribute){const t=e.currentTarget.getAttribute("target");if(/\b_blank\b/i.test(t))return}e.preventDefault&&e.preventDefault();return!0}(n)){const n=t[Zt(e.replace)?"replace":"push"](Zt(e.to)).catch(Qp);return e.viewTransition&&"undefined"!=typeof document&&"startViewTransition"in document&&document.startViewTransition(()=>n),n}return Promise.resolve()}}}const gg=$r({name:"RouterLink",compatConfig:{MODE:3},props:{to:{type:[String,Object],required:!0},replace:Boolean,activeClass:String,exactActiveClass:String,custom:Boolean,ariaCurrentValue:{type:String,default:"page"},viewTransition:Boolean},useLink:fg,setup(e,{slots:t}){const n=Rt(fg(e)),{options:r}=or(Nf),i=_a(()=>({[Ag(e.activeClass,r.linkActiveClass,"router-link-active")]:n.isActive,[Ag(e.exactActiveClass,r.linkExactActiveClass,"router-link-exact-active")]:n.isExactActive}));return()=>{const r=t.default&&(1===(o=t.default(n)).length?o[0]:o);var o;return e.custom?r:Ta("a",{"aria-current":n.isExactActive?e.ariaCurrentValue:null,href:n.href,onClick:n.navigate,class:i.value},r)}}}),mg=gg;function vg(e){return e?e.aliasOf?e.aliasOf.path:e.path:""}const Ag=(e,t,n)=>null!=e?e:null!=t?t:n,bg=$r({name:"RouterView",inheritAttrs:!1,props:{name:{type:String,default:"default"},route:Object},compatConfig:{MODE:3},setup(e,{attrs:t,slots:n}){const r=or(Qf),i=_a(()=>e.route||r.value),o=or(If,0),s=_a(()=>{let e=Zt(o);const{matched:t}=i.value;let n;for(;(n=t[e])&&!n.components;)e++;return e}),a=_a(()=>i.value.matched[s.value]);ir(If,_a(()=>s.value+1)),ir(Rf,a),ir(Qf,i);const l=Gt();return ur(()=>[l.value,a.value,e.name],([e,t,n],[r,i,o])=>{t&&(t.instances[n]=e,i&&i!==t&&e&&e===r&&(t.leaveGuards.size||(t.leaveGuards=i.leaveGuards),t.updateGuards.size||(t.updateGuards=i.updateGuards))),!e||!t||i&&hf(t,i)&&r||(t.enterCallbacks[n]||[]).forEach(t=>t(e))},{flush:"post"}),()=>{const r=i.value,o=e.name,s=a.value,c=s&&s.components[o];if(!c)return yg(n.default,{Component:c,route:r});const d=s.props[o],h=d?!0===d?r.params:"function"==typeof d?d(r):d:null,u=Ta(c,Np({},h,t,{onVnodeUnmounted:e=>{e.component.isUnmounted&&(s.instances[o]=null)},ref:l}));return yg(n.default,{Component:u,route:r})||u}}});function yg(e,t){if(!e)return null;const n=e(t);return 1===n.length?n[0]:n}const xg=bg;var wg="floater",Cg="shortcode",kg="menu",Sg="tpLanguages";function Og(e){var t=or(e);if(!t)throw new Error('Config scope "'.concat(e,'" not provided.'));return t}function Bg(){var e=or(Sg);if(!e)throw new Error("Languages not provided—did you forget to call provideSwitcherConfig?");return e}var _g=n(72),Tg=n.n(_g),Eg=n(877),Mg={insert:"head",singleton:!1};Tg()(Eg.A,Mg);Eg.A.locals;function Dg(e){return(Dg="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var Pg=/^\s+/,Rg=/\s+$/;function Ig(e,t){if(t=t||{},(e=e||"")instanceof Ig)return e;if(!(this instanceof Ig))return new Ig(e,t);var n=function(e){var t={r:0,g:0,b:0},n=1,r=null,i=null,o=null,s=!1,a=!1;return"string"==typeof e&&(e=function(e){e=e.replace(Pg,"").replace(Rg,"").toLowerCase();var t,n=!1;if(Kg[e])e=Kg[e],n=!0;else if("transparent"==e)return{r:0,g:0,b:0,a:0,format:"name"};return(t=lm.rgb.exec(e))?{r:t[1],g:t[2],b:t[3]}:(t=lm.rgba.exec(e))?{r:t[1],g:t[2],b:t[3],a:t[4]}:(t=lm.hsl.exec(e))?{h:t[1],s:t[2],l:t[3]}:(t=lm.hsla.exec(e))?{h:t[1],s:t[2],l:t[3],a:t[4]}:(t=lm.hsv.exec(e))?{h:t[1],s:t[2],v:t[3]}:(t=lm.hsva.exec(e))?{h:t[1],s:t[2],v:t[3],a:t[4]}:(t=lm.hex8.exec(e))?{r:rm(t[1]),g:rm(t[2]),b:rm(t[3]),a:am(t[4]),format:n?"name":"hex8"}:(t=lm.hex6.exec(e))?{r:rm(t[1]),g:rm(t[2]),b:rm(t[3]),format:n?"name":"hex"}:(t=lm.hex4.exec(e))?{r:rm(t[1]+""+t[1]),g:rm(t[2]+""+t[2]),b:rm(t[3]+""+t[3]),a:am(t[4]+""+t[4]),format:n?"name":"hex8"}:!!(t=lm.hex3.exec(e))&&{r:rm(t[1]+""+t[1]),g:rm(t[2]+""+t[2]),b:rm(t[3]+""+t[3]),format:n?"name":"hex"}}(e)),"object"==Dg(e)&&(cm(e.r)&&cm(e.g)&&cm(e.b)?(t=function(e,t,n){return{r:255*tm(e,255),g:255*tm(t,255),b:255*tm(n,255)}}(e.r,e.g,e.b),s=!0,a="%"===String(e.r).substr(-1)?"prgb":"rgb"):cm(e.h)&&cm(e.s)&&cm(e.v)?(r=om(e.s),i=om(e.v),t=function(e,t,n){e=6*tm(e,360),t=tm(t,100),n=tm(n,100);var r=Math.floor(e),i=e-r,o=n*(1-t),s=n*(1-i*t),a=n*(1-(1-i)*t),l=r%6,c=[n,s,o,o,a,n][l],d=[a,n,n,s,o,o][l],h=[o,o,a,n,n,s][l];return{r:255*c,g:255*d,b:255*h}}(e.h,r,i),s=!0,a="hsv"):cm(e.h)&&cm(e.s)&&cm(e.l)&&(r=om(e.s),o=om(e.l),t=function(e,t,n){var r,i,o;function s(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+(t-e)*(2/3-n)*6:e}if(e=tm(e,360),t=tm(t,100),n=tm(n,100),0===t)r=i=o=n;else{var a=n<.5?n*(1+t):n+t-n*t,l=2*n-a;r=s(l,a,e+1/3),i=s(l,a,e),o=s(l,a,e-1/3)}return{r:255*r,g:255*i,b:255*o}}(e.h,r,o),s=!0,a="hsl"),e.hasOwnProperty("a")&&(n=e.a)),n=em(n),{ok:s,format:e.format||a,r:Math.min(255,Math.max(t.r,0)),g:Math.min(255,Math.max(t.g,0)),b:Math.min(255,Math.max(t.b,0)),a:n}}(e);this._originalInput=e,this._r=n.r,this._g=n.g,this._b=n.b,this._a=n.a,this._roundA=Math.round(100*this._a)/100,this._format=t.format||n.format,this._gradientType=t.gradientType,this._r<1&&(this._r=Math.round(this._r)),this._g<1&&(this._g=Math.round(this._g)),this._b<1&&(this._b=Math.round(this._b)),this._ok=n.ok}function Ng(e,t,n){e=tm(e,255),t=tm(t,255),n=tm(n,255);var r,i,o=Math.max(e,t,n),s=Math.min(e,t,n),a=(o+s)/2;if(o==s)r=i=0;else{var l=o-s;switch(i=a>.5?l/(2-o-s):l/(o+s),o){case e:r=(t-n)/l+(t<n?6:0);break;case t:r=(n-e)/l+2;break;case n:r=(e-t)/l+4}r/=6}return{h:r,s:i,l:a}}function Lg(e,t,n){e=tm(e,255),t=tm(t,255),n=tm(n,255);var r,i,o=Math.max(e,t,n),s=Math.min(e,t,n),a=o,l=o-s;if(i=0===o?0:l/o,o==s)r=0;else{switch(o){case e:r=(t-n)/l+(t<n?6:0);break;case t:r=(n-e)/l+2;break;case n:r=(e-t)/l+4}r/=6}return{h:r,s:i,v:a}}function Qg(e,t,n,r){var i=[im(Math.round(e).toString(16)),im(Math.round(t).toString(16)),im(Math.round(n).toString(16))];return r&&i[0].charAt(0)==i[0].charAt(1)&&i[1].charAt(0)==i[1].charAt(1)&&i[2].charAt(0)==i[2].charAt(1)?i[0].charAt(0)+i[1].charAt(0)+i[2].charAt(0):i.join("")}function Fg(e,t,n,r){return[im(sm(r)),im(Math.round(e).toString(16)),im(Math.round(t).toString(16)),im(Math.round(n).toString(16))].join("")}function Vg(e,t){t=0===t?0:t||10;var n=Ig(e).toHsl();return n.s-=t/100,n.s=nm(n.s),Ig(n)}function zg(e,t){t=0===t?0:t||10;var n=Ig(e).toHsl();return n.s+=t/100,n.s=nm(n.s),Ig(n)}function Wg(e){return Ig(e).desaturate(100)}function $g(e,t){t=0===t?0:t||10;var n=Ig(e).toHsl();return n.l+=t/100,n.l=nm(n.l),Ig(n)}function Hg(e,t){t=0===t?0:t||10;var n=Ig(e).toRgb();return n.r=Math.max(0,Math.min(255,n.r-Math.round(-t/100*255))),n.g=Math.max(0,Math.min(255,n.g-Math.round(-t/100*255))),n.b=Math.max(0,Math.min(255,n.b-Math.round(-t/100*255))),Ig(n)}function jg(e,t){t=0===t?0:t||10;var n=Ig(e).toHsl();return n.l-=t/100,n.l=nm(n.l),Ig(n)}function qg(e,t){var n=Ig(e).toHsl(),r=(n.h+t)%360;return n.h=r<0?360+r:r,Ig(n)}function Ug(e){var t=Ig(e).toHsl();return t.h=(t.h+180)%360,Ig(t)}function Gg(e,t){if(isNaN(t)||t<=0)throw new Error("Argument to polyad must be a positive number");for(var n=Ig(e).toHsl(),r=[Ig(e)],i=360/t,o=1;o<t;o++)r.push(Ig({h:(n.h+o*i)%360,s:n.s,l:n.l}));return r}function Yg(e){var t=Ig(e).toHsl(),n=t.h;return[Ig(e),Ig({h:(n+72)%360,s:t.s,l:t.l}),Ig({h:(n+216)%360,s:t.s,l:t.l})]}function Xg(e,t,n){t=t||6,n=n||30;var r=Ig(e).toHsl(),i=360/n,o=[Ig(e)];for(r.h=(r.h-(i*t>>1)+720)%360;--t;)r.h=(r.h+i)%360,o.push(Ig(r));return o}function Jg(e,t){t=t||6;for(var n=Ig(e).toHsv(),r=n.h,i=n.s,o=n.v,s=[],a=1/t;t--;)s.push(Ig({h:r,s:i,v:o})),o=(o+a)%1;return s}Ig.prototype={isDark:function(){return this.getBrightness()<128},isLight:function(){return!this.isDark()},isValid:function(){return this._ok},getOriginalInput:function(){return this._originalInput},getFormat:function(){return this._format},getAlpha:function(){return this._a},getBrightness:function(){var e=this.toRgb();return(299*e.r+587*e.g+114*e.b)/1e3},getLuminance:function(){var e,t,n,r=this.toRgb();return e=r.r/255,t=r.g/255,n=r.b/255,.2126*(e<=.03928?e/12.92:Math.pow((e+.055)/1.055,2.4))+.7152*(t<=.03928?t/12.92:Math.pow((t+.055)/1.055,2.4))+.0722*(n<=.03928?n/12.92:Math.pow((n+.055)/1.055,2.4))},setAlpha:function(e){return this._a=em(e),this._roundA=Math.round(100*this._a)/100,this},toHsv:function(){var e=Lg(this._r,this._g,this._b);return{h:360*e.h,s:e.s,v:e.v,a:this._a}},toHsvString:function(){var e=Lg(this._r,this._g,this._b),t=Math.round(360*e.h),n=Math.round(100*e.s),r=Math.round(100*e.v);return 1==this._a?"hsv("+t+", "+n+"%, "+r+"%)":"hsva("+t+", "+n+"%, "+r+"%, "+this._roundA+")"},toHsl:function(){var e=Ng(this._r,this._g,this._b);return{h:360*e.h,s:e.s,l:e.l,a:this._a}},toHslString:function(){var e=Ng(this._r,this._g,this._b),t=Math.round(360*e.h),n=Math.round(100*e.s),r=Math.round(100*e.l);return 1==this._a?"hsl("+t+", "+n+"%, "+r+"%)":"hsla("+t+", "+n+"%, "+r+"%, "+this._roundA+")"},toHex:function(e){return Qg(this._r,this._g,this._b,e)},toHexString:function(e){return"#"+this.toHex(e)},toHex8:function(e){return function(e,t,n,r,i){var o=[im(Math.round(e).toString(16)),im(Math.round(t).toString(16)),im(Math.round(n).toString(16)),im(sm(r))];return i&&o[0].charAt(0)==o[0].charAt(1)&&o[1].charAt(0)==o[1].charAt(1)&&o[2].charAt(0)==o[2].charAt(1)&&o[3].charAt(0)==o[3].charAt(1)?o[0].charAt(0)+o[1].charAt(0)+o[2].charAt(0)+o[3].charAt(0):o.join("")}(this._r,this._g,this._b,this._a,e)},toHex8String:function(e){return"#"+this.toHex8(e)},toRgb:function(){return{r:Math.round(this._r),g:Math.round(this._g),b:Math.round(this._b),a:this._a}},toRgbString:function(){return 1==this._a?"rgb("+Math.round(this._r)+", "+Math.round(this._g)+", "+Math.round(this._b)+")":"rgba("+Math.round(this._r)+", "+Math.round(this._g)+", "+Math.round(this._b)+", "+this._roundA+")"},toPercentageRgb:function(){return{r:Math.round(100*tm(this._r,255))+"%",g:Math.round(100*tm(this._g,255))+"%",b:Math.round(100*tm(this._b,255))+"%",a:this._a}},toPercentageRgbString:function(){return 1==this._a?"rgb("+Math.round(100*tm(this._r,255))+"%, "+Math.round(100*tm(this._g,255))+"%, "+Math.round(100*tm(this._b,255))+"%)":"rgba("+Math.round(100*tm(this._r,255))+"%, "+Math.round(100*tm(this._g,255))+"%, "+Math.round(100*tm(this._b,255))+"%, "+this._roundA+")"},toName:function(){return 0===this._a?"transparent":!(this._a<1)&&(Zg[Qg(this._r,this._g,this._b,!0)]||!1)},toFilter:function(e){var t="#"+Fg(this._r,this._g,this._b,this._a),n=t,r=this._gradientType?"GradientType = 1, ":"";if(e){var i=Ig(e);n="#"+Fg(i._r,i._g,i._b,i._a)}return"progid:DXImageTransform.Microsoft.gradient("+r+"startColorstr="+t+",endColorstr="+n+")"},toString:function(e){var t=!!e;e=e||this._format;var n=!1,r=this._a<1&&this._a>=0;return!t&&r&&("hex"===e||"hex6"===e||"hex3"===e||"hex4"===e||"hex8"===e||"name"===e)?"name"===e&&0===this._a?this.toName():this.toRgbString():("rgb"===e&&(n=this.toRgbString()),"prgb"===e&&(n=this.toPercentageRgbString()),("hex"===e||"hex6"===e)&&(n=this.toHexString()),"hex3"===e&&(n=this.toHexString(!0)),"hex4"===e&&(n=this.toHex8String(!0)),"hex8"===e&&(n=this.toHex8String()),"name"===e&&(n=this.toName()),"hsl"===e&&(n=this.toHslString()),"hsv"===e&&(n=this.toHsvString()),n||this.toHexString())},clone:function(){return Ig(this.toString())},_applyModification:function(e,t){var n=e.apply(null,[this].concat([].slice.call(t)));return this._r=n._r,this._g=n._g,this._b=n._b,this.setAlpha(n._a),this},lighten:function(){return this._applyModification($g,arguments)},brighten:function(){return this._applyModification(Hg,arguments)},darken:function(){return this._applyModification(jg,arguments)},desaturate:function(){return this._applyModification(Vg,arguments)},saturate:function(){return this._applyModification(zg,arguments)},greyscale:function(){return this._applyModification(Wg,arguments)},spin:function(){return this._applyModification(qg,arguments)},_applyCombination:function(e,t){return e.apply(null,[this].concat([].slice.call(t)))},analogous:function(){return this._applyCombination(Xg,arguments)},complement:function(){return this._applyCombination(Ug,arguments)},monochromatic:function(){return this._applyCombination(Jg,arguments)},splitcomplement:function(){return this._applyCombination(Yg,arguments)},triad:function(){return this._applyCombination(Gg,[3])},tetrad:function(){return this._applyCombination(Gg,[4])}},Ig.fromRatio=function(e,t){if("object"==Dg(e)){var n={};for(var r in e)e.hasOwnProperty(r)&&(n[r]="a"===r?e[r]:om(e[r]));e=n}return Ig(e,t)},Ig.equals=function(e,t){return!(!e||!t)&&Ig(e).toRgbString()==Ig(t).toRgbString()},Ig.random=function(){return Ig.fromRatio({r:Math.random(),g:Math.random(),b:Math.random()})},Ig.mix=function(e,t,n){n=0===n?0:n||50;var r=Ig(e).toRgb(),i=Ig(t).toRgb(),o=n/100;return Ig({r:(i.r-r.r)*o+r.r,g:(i.g-r.g)*o+r.g,b:(i.b-r.b)*o+r.b,a:(i.a-r.a)*o+r.a})},Ig.readability=function(e,t){var n=Ig(e),r=Ig(t);return(Math.max(n.getLuminance(),r.getLuminance())+.05)/(Math.min(n.getLuminance(),r.getLuminance())+.05)},Ig.isReadable=function(e,t,n){var r,i,o=Ig.readability(e,t);switch(i=!1,r=function(e){var t,n;return e=e||{level:"AA",size:"small"},t=(e.level||"AA").toUpperCase(),n=(e.size||"small").toLowerCase(),"AA"!==t&&"AAA"!==t&&(t="AA"),"small"!==n&&"large"!==n&&(n="small"),{level:t,size:n}}(n),r.level+r.size){case"AAsmall":case"AAAlarge":i=o>=4.5;break;case"AAlarge":i=o>=3;break;case"AAAsmall":i=o>=7}return i},Ig.mostReadable=function(e,t,n){var r,i,o,s,a=null,l=0;i=(n=n||{}).includeFallbackColors,o=n.level,s=n.size;for(var c=0;c<t.length;c++)(r=Ig.readability(e,t[c]))>l&&(l=r,a=Ig(t[c]));return Ig.isReadable(e,a,{level:o,size:s})||!i?a:(n.includeFallbackColors=!1,Ig.mostReadable(e,["#fff","#000"],n))};var Kg=Ig.names={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"0ff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"00f",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",burntsienna:"ea7e5d",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"0ff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"f0f",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"},Zg=Ig.hexNames=function(e){var t={};for(var n in e)e.hasOwnProperty(n)&&(t[e[n]]=n);return t}(Kg);function em(e){return e=parseFloat(e),(isNaN(e)||e<0||e>1)&&(e=1),e}function tm(e,t){(function(e){return"string"==typeof e&&-1!=e.indexOf(".")&&1===parseFloat(e)})(e)&&(e="100%");var n=function(e){return"string"==typeof e&&-1!=e.indexOf("%")}(e);return e=Math.min(t,Math.max(0,parseFloat(e))),n&&(e=parseInt(e*t,10)/100),Math.abs(e-t)<1e-6?1:e%t/parseFloat(t)}function nm(e){return Math.min(1,Math.max(0,e))}function rm(e){return parseInt(e,16)}function im(e){return 1==e.length?"0"+e:""+e}function om(e){return e<=1&&(e=100*e+"%"),e}function sm(e){return Math.round(255*parseFloat(e)).toString(16)}function am(e){return rm(e)/255}var lm=function(){var e="(?:[-\\+]?\\d*\\.\\d+%?)|(?:[-\\+]?\\d+%?)",t="[\\s|\\(]+("+e+")[,|\\s]+("+e+")[,|\\s]+("+e+")\\s*\\)?",n="[\\s|\\(]+("+e+")[,|\\s]+("+e+")[,|\\s]+("+e+")[,|\\s]+("+e+")\\s*\\)?";return{CSS_UNIT:new RegExp(e),rgb:new RegExp("rgb"+t),rgba:new RegExp("rgba"+n),hsl:new RegExp("hsl"+t),hsla:new RegExp("hsla"+n),hsv:new RegExp("hsv"+t),hsva:new RegExp("hsva"+n),hex3:/^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex6:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,hex4:/^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex8:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/}}();function cm(e){return!!lm.CSS_UNIT.exec(e)}const dm=(e,t,n=!1)=>{if(!n){let n=t;"hex"===t&&e.getAlpha()<1&&(n="hex8");let r=e.toString(n);try{r=JSON.parse(r)}catch{}return r}switch(t){case"rgb":return e.toRgb();case"prgb":return e.toPercentageRgb();case"hsl":return e.toHsl();case"hsv":return e.toHsv();default:return null}},hm=(e,t)=>!!(Object.prototype.hasOwnProperty.call(e,t)&&typeof e[t]<"u"),um=e=>typeof e>"u",pm=["update:tinyColor","update:modelValue","input"];function fm(e,t,n){let r,i;const o=_a({get:()=>{const{modelValue:t,tinyColor:n,value:o}=e,s=n??t??o;return um(i)&&(um(o)||(i=Ig(o).getFormat()),um(t)||(i=Ig(t).getFormat())),um(r)&&("object"==typeof o&&!(o instanceof Ig)&&(r=!0),"object"==typeof t&&(r=!0)),Ig(s)},set:e=>{s(e)}}),s=n=>{const o=Ig(n);if(hm(e,"tinyColor")&&t("update:tinyColor",o),hm(e,"modelValue")){const e=dm(o,i,r);t("update:modelValue",e)}if(hm(e,"value")){const e=dm(o,i,r);t("input",e)}};return o}const gm=e=>{const t={x:0,y:0};return e instanceof MouseEvent&&(t.x=e.pageX,t.y=e.pageY),typeof TouchEvent<"u"&&e instanceof TouchEvent&&(t.x=e.touches?.[0]?e.touches[0].pageX:e.changedTouches?.[0]?e.changedTouches[0].pageX:0,t.y=e.touches?.[0]?e.touches[0].pageY:e.changedTouches?.[0]?e.changedTouches[0].pageY:0),t},mm=e=>{const{x:t,y:n}={x:window.scrollX||window.pageXOffset||document.documentElement.scrollLeft||0,y:window.scrollY||window.pageYOffset||document.documentElement.scrollTop||0},r=e.getBoundingClientRect();return{x:r.left+t,y:r.top+n}},vm=e=>"ArrowUp"===e.code||38===e.keyCode?"up":"ArrowDown"===e.code||40===e.keyCode?"down":"ArrowLeft"===e.code||37===e.keyCode?"left":"ArrowRight"===e.code||39===e.keyCode?"right":null;function Am(e,t,n){return Math.min(Math.max(e,t),n)}const bm=(e,t=20)=>{let n,r,i;return(...o)=>{n?(clearTimeout(r),r=setTimeout(()=>{Date.now()-i>=t&&(e(...o),i=Date.now())},Math.max(t-(Date.now()-i),0))):(e(...o),i=Date.now(),n=!0)}},ym=["aria-valuetext"],xm=$r({__name:"SaturationSlider",props:{hue:{},tinyColor:{},modelValue:{},value:{}},emits:["change"].concat(pm),setup(e,{emit:t}){const n=t,r=e,i=Gt(0),o=fm(r,n),s=_a(()=>o.value.toHsv()),a=_a(()=>r.hue??s.value.h),l=_a(()=>`hsl(${a.value}, 100%, 50%)`),c=_a(()=>-100*s.value.v+1+100+"%"),d=_a(()=>s.value.v<=.01?100*i.value+"%":100*s.value.s+"%"),h=Gt(null);function u(e){o.value=e}const p=bm(function(e){const t=h.value;if(!t)return;const n=t.clientWidth,r=t.clientHeight,{x:o,y:l}=mm(t),{x:c,y:d}=gm(e),p=Am(c-o,0,n),f=Am(d-l,0,r),g=p/n,m=Am(1-f/r,0,1);i.value=g;let v=Math.round(100*g),A=Math.round(100*m);1===v&&(v=.01),1===A&&(A=.01),u({h:a.value,s:v,v:A,a:s.value.a})},20);function f(e){e.preventDefault(),e.type.startsWith("mouse")?(window.addEventListener("mousemove",p),window.addEventListener("mouseup",p),window.addEventListener("mouseup",g)):e.type.startsWith("touch")&&(window.addEventListener("touchmove",p),window.addEventListener("touchend",p),window.addEventListener("touchend",g))}function g(){m()}function m(){window.removeEventListener("mousemove",p),window.removeEventListener("mouseup",p),window.removeEventListener("mouseup",g),window.removeEventListener("touchmove",p),window.removeEventListener("touchend",p),window.removeEventListener("touchend",g)}function v(e){switch(e.preventDefault(),vm(e)){case"left":{const e=s.value.s-.01;u({...s.value,s:e>=0?e:0});break}case"right":{const e=s.value.s+.01;u({...s.value,s:e>1?1:e});break}case"up":{const e=s.value.v+.01;u({...s.value,v:e>1?1:e});break}case"down":{const e=s.value.v-.01;u({...s.value,v:e<0?0:e});break}}}return Ri(()=>{m()}),(e,t)=>(Ms(),Ls("div",{class:"vc-saturation-slider bg",style:j({background:l.value}),ref_key:"containerRef",ref:h,onMousedown:f,onTouchstart:f,role:"application","aria-label":"Saturation and brightness picker"},[t[1]||(t[1]=Hs("div",{class:"bg white"},null,-1)),t[2]||(t[2]=Hs("div",{class:"bg black"},null,-1)),Hs("div",{class:"picker-wrap",style:j({top:c.value,left:d.value}),role:"slider",tabindex:"0","aria-valuemin":"0","aria-valuemax":"1","aria-label":"press arrow to change saturation or brightness","aria-valuenow":"?","aria-valuetext":`saturation: ${s.value.s.toFixed(0)}%, brightness: ${s.value.v.toFixed(0)}%`,onKeydown:v},t[0]||(t[0]=[Hs("div",{class:"picker"},null,-1)]),44,ym)],36))}}),wm=(e,t)=>{const n=e.__vccOpts||e;for(const[e,r]of t)n[e]=r;return n},Cm=wm(xm,[["__scopeId","data-v-4d048d6e"]]),km=e=>typeof e<"u",Sm={class:"vc-base-slider"},Om={key:0,class:"background"},Bm=["aria-label","aria-valuemax","aria-valuenow"],_m=$r({__name:"BaseSlider",props:{direction:{default:"horizontal"},modelValue:{default:0},value:{default:0},max:{default:100},step:{},ariaLabel:{default:"slider"}},emits:["input","update:modelValue"],setup(e,{emit:t}){const n=e,r=t,i=_a(()=>n.modelValue??n.value),o=_a(()=>{let e=i.value/n.max;return"vertical"===n.direction&&(e=1-e),100*e+"%"}),s=Gt(null);function a(e){km(e)&&(r("input",e),r("update:modelValue",e))}function l(e){const{direction:t,max:r}=n,i=s.value;if(!i)return;const o=i.clientWidth,l=i.clientHeight,{x:c,y:d}=mm(i),{x:h,y:u}=gm(e),p=h-c,f=u-d;let g;g="vertical"===t?f<0?r:f>l?0:(1-f/l)*r:p<0?0:p>o?r:p/o*r,a(g)}const c=bm(l);function d(e){l(e),e.type.startsWith("mouse")?(window.addEventListener("mousemove",c),window.addEventListener("mouseup",h)):(window.addEventListener("touchmove",c),window.addEventListener("touchend",h))}function h(){u()}function u(){window.removeEventListener("mousemove",c),window.removeEventListener("mouseup",h),window.removeEventListener("touchmove",c),window.removeEventListener("touchend",h)}function p(e){e.preventDefault();const{direction:t,max:r}=n,o=vm(e),s=n.step??r/100,l=i.value;let c;switch(o){case"left":if("horizontal"!==t)return;c=l-s<0?0:l-s;break;case"right":if("horizontal"!==t)return;c=l+s>r?r:l+s;break;case"down":if("vertical"!==t)return;c=l-s<0?0:l-s;break;case"up":if("vertical"!==t)return;c=l+s>r?r:l+s}a(c)}return Ri(()=>{u()}),(e,t)=>(Ms(),Ls("div",Sm,[e.$slots.background?(Ms(),Ls("div",Om,[Gi(e.$slots,"background",{},void 0,!0)])):Js("",!0),Hs("div",{class:X({slider:!0,horizontal:"horizontal"===e.direction,vertical:"vertical"===e.direction}),ref_key:"containerRef",ref:s,onMousedown:d,onTouchstart:d,role:"slider","aria-label":e.ariaLabel,"aria-valuemax":e.max,"aria-valuemin":"0","aria-valuenow":i.value.toFixed(1),tabindex:"0",onKeydown:p},[Hs("div",{class:"picker-wrap",style:j({left:"horizontal"===e.direction?o.value:0,top:"vertical"===e.direction?o.value:0}),role:"presentation"},[Gi(e.$slots,"picker",{},()=>[t[0]||(t[0]=Hs("div",{class:"picker"},null,-1))],!0)],4)],42,Bm)]))}}),Tm=wm(_m,[["__scopeId","data-v-972b0fad"]]),Em=$r({__name:"HueSlider",props:{direction:{default:"horizontal"},modelValue:{default:0}},emits:["update:modelValue"],setup(e,{emit:t}){bl(e=>({"2f44f39d":i.value}));const n=e,r=t,i=_a(()=>`linear-gradient(to ${"horizontal"===n.direction?"right":"top"}, #f00 0%, #ff0 17%, #0f0 33%, #0ff 50%, #00f 67%, #f0f 83%, #f00 100%)`),o=_a(()=>{const e=Number(n.modelValue);return Number.isNaN(e)?0:e}),s=Gt();ur(o,(e,t)=>{0!==e&&e-t>0&&(s.value="right"),0!==e&&e-t<0&&(s.value="left")});const a=_a(()=>"vertical"===n.direction?0===o.value&&"right"===s.value?0:o.value:"horizontal"===n.direction?0===o.value&&"right"===s.value?360:o.value:0);function l(e){!function(e){r("update:modelValue",e)}(Math.round(e))}return(e,t)=>(Ms(),Qs(Tm,{class:"vc-hue-slider",max:360,step:1,modelValue:a.value,direction:e.direction,"onUpdate:modelValue":l,"aria-label":"Hue"},{background:tr(()=>t[0]||(t[0]=[Hs("div",{class:"gradient"},null,-1)])),picker:tr(()=>[Gi(e.$slots,"default",{},void 0,!0)]),_:3},8,["modelValue","direction"]))}}),Mm=wm(Em,[["__scopeId","data-v-5367c985"]]),Dm=$r({__name:"CheckerboardBG",props:{size:{default:8},white:{default:"#fff"},grey:{default:"#e6e6e6"}},setup(e){const t=e;function n(e,t,n){return function(e,t,n){if(typeof document>"u")return null;var r=document.createElement("canvas");r.width=r.height=2*n;var i=r.getContext("2d");return i?(i.fillStyle=e,i.fillRect(0,0,r.width,r.height),i.fillStyle=t,i.fillRect(0,0,n,n),i.translate(n,n),i.fillRect(0,0,n,n),r.toDataURL()):null}(e,t,n)}const r=_a(()=>`url(${n(t.white,t.grey,t.size)})`);return(e,t)=>(Ms(),Ls("div",{class:"vc-checkerboard",style:j({backgroundImage:r.value})},null,4))}}),Pm=wm(Dm,[["__scopeId","data-v-37d61ccd"]]),Rm=$r({__name:"AlphaSlider",props:{tinyColor:{},modelValue:{},value:{}},emits:pm,setup(e,{emit:t}){const n=fm(e,t),r=_a(()=>{const e=n.value.toRgb(),t=[e.r,e.g,e.b].join(",");return"linear-gradient(to right, rgba("+t+", 0) 0%, rgba("+t+", 1) 100%)"}),i=_a(()=>n.value.getAlpha());function o(e){n.value=n.value.setAlpha(e).clone()}return(e,t)=>(Ms(),Qs(Tm,{class:"vc-alpha-slider",modelValue:i.value,max:1,"aria-label":"Transparency","onUpdate:modelValue":o},{background:tr(()=>[js(Pm),Hs("div",{class:"gradient",style:j({background:r.value})},null,4)]),_:1},8,["modelValue"]))}}),Im=wm(Rm,[["__scopeId","data-v-07dd346b"]]),Nm={class:"vc-editable-input"},Lm=["value","aria-label"],Qm={key:0,class:"vc-input-desc","aria-hidden":"true"},Fm=$r({__name:"EditableInput",props:{value:{},label:{},desc:{},max:{},min:{},step:{default:1},a11y:{}},emits:["change","blur"],setup(e,{emit:t}){const n=e,r=t,i=n.a11y?.label??n.label,o=`input__label__${i}__${Math.random().toString().slice(2,5)}`;function s(e){const{min:t,max:i}=n;km(i)&&+e>i?r("change",i):km(t)&&+e<t?r("change",t):r("change",e)}function a(e){s(e.target?.value)}function l(e){r("blur",e)}function c(e){let t=Number(n.value);if(!isNaN(t)){let r=n.step;const i=function(e){const t=e.toString();return-1!==t.indexOf(".")?t.split(".")[1].length:0}(r),o=vm(e);"up"===o&&(s((t+r).toFixed(i)),e.preventDefault()),"down"===o&&(s((t-r).toFixed(i)),e.preventDefault())}}return(e,t)=>(Ms(),Ls("div",Nm,[Hs("input",{class:"vc-input-input",value:n.value,onKeydown:c,onInput:a,onBlur:l,"aria-label":Zt(i),id:o},null,40,Lm),Hs("label",{for:o,class:"vc-input-label","aria-hidden":"true"},pe(n.label),1),e.desc?(Ms(),Ls("span",Qm,pe(e.desc),1)):Js("",!0)]))}}),Vm=wm(Fm,[["__scopeId","data-v-9c267b2b"]]),zm=e=>Ig(e).isValid(),Wm=e=>0===Ig(e).getAlpha(),$m=$r({__name:"HexInput",props:{value:{},label:{},desc:{},a11y:{},type:{default:"hex"},withHash:{type:Boolean,default:!1}},emits:["change"],setup(e,{emit:t}){const n=e,r=t,i={label:"hex"===n.type?"Hex":"Hex with transparency",...n.a11y},o=(e,t="hex")=>{let r="";return"hex"===t&&(r=Ig(e).toHexString()),"hex8"===t&&(r=Ig(e).toHex8String()),!0!==n.withHash&&(r=r.replace("#","")),r},s=Gt(o(n.value,n.type));ur(()=>n.value,e=>{Ig.equals(e,s.value)||(s.value=o(e,n.type))});const a=e=>{if(!e)return;s.value=e;let t=e.length;"#"===e[0]&&(t-=1),("hex"!==n.type||t%3==0||8===t)&&("hex8"===n.type&&8!==t||zm(e)&&r("change",e))},l=()=>{let e=s.value.length;"#"===s.value[0]&&(e-=1),(!zm(s.value)||!("hex"===n.type&&6===e||"hex8"===n.type&&8===e))&&(s.value=o(n.value,n.type))};return(e,t)=>(Ms(),Qs(Vm,{label:n.label,a11y:i,value:s.value,onChange:a,onBlur:l},null,8,["label","value"]))}});const Hm=e=>{const t=Gt(0),n=`__from__vc__hue__${function(){const e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";return e.charAt(Math.floor(62*Math.random()))+e.charAt(Math.floor(62*Math.random()))}()}`;return ur(e,e=>{if(e[n])return;const r=e.toHsl().h;0===r&&0!==t.value||(t.value=r)},{immediate:!0}),{hueRef:t,updateHueRef:r=>{const i=Ig({...e.value.toHsl(),h:r});i[n]=!0,e.value=i,t.value=r}}},jm={class:"saturation"},qm={class:"body"},Um={class:"controls"},Gm={class:"color-wrap"},Ym=["aria-label"],Xm={class:"sliders"},Jm={class:"hue-wrap"},Km={key:0,class:"alpha-wrap"},Zm={key:0,class:"fieldsWrap","data-testid":"fields"},ev={key:0,class:"fields"},tv={class:"field"},nv={class:"field"},rv={class:"field"},iv={key:0,class:"field"},ov={key:1,class:"fields"},sv={class:"field"},av={key:2,class:"fields"},lv={class:"field"},cv={class:"field"},dv={class:"field"},hv={key:0,class:"field"},uv={class:"toggle-icon",role:"presentation"},pv={style:{width:"24px",height:"24px"},viewBox:"0 0 24 24"},fv={class:"toggle-icon_highlighted",role:"presentation"},gv=$r({__name:"ChromePicker",props:{disableAlpha:{type:Boolean},disableFields:{type:Boolean},formats:{default:()=>["rgb","hex","hsl"]},tinyColor:{},modelValue:{},value:{}},emits:pm,setup(e,{emit:t}){const n=e,r=fm(n,t),{hueRef:i,updateHueRef:o}=Hm(r),s=Gt(0);let a=Gt(!1);const l=_a(()=>{const e=r.value.toRgb();return"rgba("+[e.r,e.g,e.b,r.value.getAlpha()].join(",")+")"}),c=_a(()=>{const{h:e,s:t,l:n}=r.value.toHsl();return{h:e.toFixed(),s:`${(100*t).toFixed()}%`,l:`${(100*n).toFixed()}%`}}),d=_a(()=>r.value.toRgb()),h=_a(()=>Number(r.value.getAlpha().toFixed(2))),u=new Set(["hex","hsl","rgb"]),p=_a(()=>{const e=new Set,t=[],r=n.formats;for(const n of r)if(u.has(n)){const r=n;e.has(r)||(e.add(r),t.push(r))}return t}),f=_a(()=>{const{disableFields:e,formats:t}=n;return!(!0===e||!Array.isArray(t)||0===p.value.length)}),g=e=>p.value.includes(e),m=e=>p.value.indexOf(e),v=e=>{r.value=e},A=(e,t)=>{if(!t||isNaN(Number(t)))return;const n={[e]:t};r.value={...d.value,a:h.value,...n}},b=(e,t)=>{if(!t)return;const n={[e]:+t};("s"===e||"l"===e)&&(n[e]=+t.replace("%","")/100),r.value={...r.value.toHsl(),a:h.value,...n}},y=()=>{s.value!==p.value.length-1?s.value++:s.value=0},x=()=>{a.value=!0},w=()=>{a.value=!1};return(e,t)=>(Ms(),Ls("div",{role:"application","aria-label":"Chrome Color Picker",class:X(["vc-chrome-picker",e.disableAlpha?"alpha-disabled":""])},[Hs("div",jm,[js(Cm,{tinyColor:Zt(r),"onUpdate:tinyColor":t[0]||(t[0]=e=>Ut(r)?r.value=e:null),hue:Zt(i)},null,8,["tinyColor","hue"])]),Hs("div",qm,[Hs("div",Um,[Hs("div",Gm,[Hs("div",{class:"active-color",style:j({backgroundColor:l.value}),role:"presentation","aria-live":"polite","aria-label":`Current color is ${l.value}`},null,12,Ym),n.disableAlpha?Js("",!0):(Ms(),Qs(Pm,{key:0}))]),Hs("div",Xm,[Hs("div",Jm,[js(Mm,{modelValue:Zt(i),"onUpdate:modelValue":Zt(o)},null,8,["modelValue","onUpdate:modelValue"])]),n.disableAlpha?Js("",!0):(Ms(),Ls("div",Km,[js(Im,{tinyColor:Zt(r),"onUpdate:tinyColor":t[1]||(t[1]=e=>Ut(r)?r.value=e:null)},null,8,["tinyColor"])]))])]),f.value?(Ms(),Ls("div",Zm,[g("rgb")?nr((Ms(),Ls("div",ev,[Hs("div",tv,[js(Vm,{label:"r",value:d.value.r,onChange:t[2]||(t[2]=e=>A("r",e)),a11y:{label:"Red"}},null,8,["value"])]),Hs("div",nv,[js(Vm,{label:"g",value:d.value.g,onChange:t[3]||(t[3]=e=>A("g",e)),a11y:{label:"Green"}},null,8,["value"])]),Hs("div",rv,[js(Vm,{label:"b",value:d.value.b,onChange:t[4]||(t[4]=e=>A("b",e)),a11y:{label:"Blue"}},null,8,["value"])]),e.disableAlpha?Js("",!0):(Ms(),Ls("div",iv,[js(Vm,{label:"a",value:h.value,step:.01,max:1,onChange:t[5]||(t[5]=e=>A("a",e)),a11y:{label:"Transparency"}},null,8,["value"])]))],512)),[[ml,s.value===m("rgb")]]):Js("",!0),g("hex")?nr((Ms(),Ls("div",ov,[Hs("div",sv,[js($m,{type:1===h.value?"hex":"hex8",label:"hex",value:Zt(r).toHex8String(),onChange:v,"with-hash":!0},null,8,["type","value"])])],512)),[[ml,s.value===m("hex")]]):Js("",!0),g("hsl")?nr((Ms(),Ls("div",av,[Hs("div",lv,[js(Vm,{label:"h",value:Zt(i).toFixed(),onChange:t[6]||(t[6]=e=>b("h",e)),a11y:{label:"Hue"}},null,8,["value"])]),Hs("div",cv,[js(Vm,{label:"s",value:c.value.s,onChange:t[7]||(t[7]=e=>b("s",e)),a11y:{label:"Saturation"}},null,8,["value"])]),Hs("div",dv,[js(Vm,{label:"l",value:c.value.l,onChange:t[8]||(t[8]=e=>b("l",e)),a11y:{label:"Lightness"}},null,8,["value"])]),e.disableAlpha?Js("",!0):(Ms(),Ls("div",hv,[js(Vm,{label:"a",value:h.value,step:.01,max:1,onChange:t[9]||(t[9]=e=>b("a",e)),a11y:{label:"Transparency"}},null,8,["value"])]))],512)),[[ml,s.value===m("hsl")]]):Js("",!0),p.value.length>1?(Ms(),Ls("div",{key:3,class:"toggle-btn",onClick:y,onKeydown:[wc(y,["enter"]),wc(y,["space"])],onMouseover:x,onMouseenter:x,onMouseout:w,onFocus:x,onBlur:w,role:"button","aria-label":"Change color format",tabindex:"0"},[Hs("div",uv,[(Ms(),Ls("svg",pv,t[10]||(t[10]=[Hs("path",{fill:"currentColor",d:"M12,18.17L8.83,15L7.42,16.41L12,21L16.59,16.41L15.17,15M12,5.83L15.17,9L16.58,7.59L12,3L7.41,7.59L8.83,9L12,5.83Z"},null,-1)])))]),nr(Hs("div",fv,null,512),[[ml,Zt(a)]])],32)):Js("",!0)])):Js("",!0)])],2))}}),mv=wm(gv,[["__scopeId","data-v-dfdde7e0"]]),vv={class:"vc-compact-picker",role:"application","aria-label":"Compact color picker",tabindex:"0"},Av={class:"colors",role:"listbox","aria-label":"Pick a color"},bv=["onClick","aria-label","aria-selected","title","onKeydown"],yv={class:"dot"},xv=["#4D4D4D","#999999","#FFFFFF","#F44E3B","#FE9200","#FCDC00","#DBDF00","#A4DD00","#68CCCA","#73D8FF","#AEA1FF","#FDA1FF","#333333","#808080","#CCCCCC","#D33115","#E27300","#FCC400","#B0BC00","#68BC00","#16A5A5","#009CE0","#7B64FF","#FA28FF","#000000","#666666","#B3B3B3","#9F0500","#C45100","#FB9E00","#808900","#194D33","#0C797D","#0062B1","#653294","#AB149E"],wv=(["change"].concat(pm),{role:"application","aria-label":"Grayscale color picker",class:"vc-grayscale-picker"}),Cv={class:"colors",role:"listbox","aria-label":"Select a grayscale color",tabindex:"0"},kv=["onClick","aria-label","aria-selected","title","onKeydown"],Sv={class:"dot"},Ov=["#FFFFFF","#F2F2F2","#E6E6E6","#D9D9D9","#CCCCCC","#BFBFBF","#B3B3B3","#A6A6A6","#999999","#8C8C8C","#808080","#737373","#666666","#595959","#4D4D4D","#404040","#333333","#262626","#0D0D0D","#000000"],Bv=(["change"].concat(pm),{class:"title","aria-hidden":"true"}),_v={class:"body"},Tv={class:"saturation"},Ev={class:"hue"},Mv={class:"preview"},Dv={class:"preview-label","aria-hidden":"true"},Pv={class:"preview-swatches"},Rv=["aria-label"],Iv=["aria-label"],Nv={class:"preview-label","aria-hidden":"true"},Lv={key:0,class:"actions"},Qv=["aria-label"],Fv={class:"fields"},Vv=["aria-label"],zv=(Boolean,Boolean,pm.concat(["ok","cancel","reset"]),{class:"saturation"}),Wv={class:"controls"},$v={class:"sliders"},Hv={class:"hue"},jv={key:0,class:"alpha"},qv={class:"color"},Uv=["aria-label"],Gv={key:0,class:"field"},Yv={class:"field_double"},Xv={class:"field_single"},Jv={class:"field_single"},Kv={class:"field_single"},Zv={key:0,class:"field_single"},eA={class:"presets",role:"listbox","aria-label":"A color preset, pick one to set as current color"},tA=["onClick","title","aria-label","aria-selected","onKeydown"],nA=["onClick","aria-selected","title","onKeydown"],rA=["#D0021B","#F5A623","#F8E71C","#8B572A","#7ED321","#417505","#BD10E0","#9013FE","#4A90E2","#50E3C2","#B8E986","#000000","#4A4A4A","#9B9B9B","#FFFFFF","rgba(0,0,0,0)"],iA=(Boolean,Boolean,["change"].concat(pm),{role:"application","aria-label":"Slider color picker",class:"vc-slider-picker"}),oA={class:"hue"},sA={key:0,class:"alpha"},aA={key:1,class:"swatches",role:"listbox","aria-label":"Color segments in different shades of one color",tabindex:"0"},lA=["onClick","aria-label","title","onKeydown","aria-selected"],cA=.5,dA=[{s:cA,l:.8},{s:cA,l:.65},{s:cA,l:.5},{s:cA,l:.35},{s:cA,l:.2}];Boolean;const hA={class:"vc-hsl-sliders"},uA={class:"slider-wrap h-slider"},pA={class:"slider-wrap s-slider"},fA={class:"slider-wrap l-slider"},gA={key:0,class:"slider-wrap a-slider"};Boolean,Boolean;const mA={class:"vc-hsv-sliders"},vA={class:"slider-wrap h-slider"},AA={class:"slider-wrap s-slider"},bA={class:"slider-wrap b-slider"},yA={key:0,class:"slider-wrap"};Boolean,Boolean;const xA={class:"vc-rgb-sliders"},wA={class:"slider-wrap"},CA={class:"slider-wrap"},kA={class:"slider-wrap"},SA={key:0,class:"slider-wrap a-slider"},OA=(e,t)=>{const n=[];for(let r=1;r<=255;r++){const{r:i,g:o,b:s}={...t,[e]:r};n.push(`rgb(${i}, ${o}, ${s})`)}return`linear-gradient(to right, ${n.join(", ")})`};Boolean,Boolean;var BA={key:0,class:"trp-field__label trp-primary-text-bold"},_A={class:"trp-color__wrapper"},TA={class:"trp-color-code trp-primary-text"};const EA={__name:"ColorField",props:{label:{type:String,default:""},modelValue:{type:String,required:!0}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o=Gt(!1),s=Gt(null),a=Gt(null);function l(){o.value=!o.value}function c(e){s.value&&!s.value.contains(e.target)&&a.value&&!a.value.contains(e.target)&&(o.value=!1)}Ei(function(){return document.addEventListener("mousedown",c)}),Pi(function(){return document.removeEventListener("mousedown",c)});var d=_a({get:function(){return Ig(r.modelValue)},set:function(e){var t=Ig(e),n=t.toHexString().toUpperCase(),r=Math.round(255*t.getAlpha()).toString(16).padStart(2,"0").toUpperCase(),o="FF"===r?n:"".concat(n).concat(r);i("update:modelValue",o)}});return function(t,n){return Ms(),Ls("div",{class:X({"trp-color--picking":o.value})},[e.label?(Ms(),Ls("span",BA,pe(e.label),1)):Js("",!0),Hs("div",_A,[Hs("div",{class:"trp-color-input",style:j({background:e.modelValue}),ref_key:"swatchRef",ref:s,onClick:l,onKeydown:wc(l,["enter","space"]),role:"button","aria-label":"Open colour picker",tabindex:"0"},null,36),Hs("span",TA,pe(e.modelValue.toUpperCase()),1),o.value?(Ms(),Ls("div",{key:0,class:"trp-color__popover",ref_key:"pickerRef",ref:a,onMousedown:n[1]||(n[1]=yc(function(){},["stop"]))},[js(Zt(mv),{tinyColor:d.value,"onUpdate:tinyColor":n[0]||(n[0]=function(e){return d.value=e})},null,8,["tinyColor"])],544)):Js("",!0)])],2)}}};var MA=n(54),DA={insert:"head",singleton:!1};Tg()(MA.A,DA);MA.A.locals;var PA=n(262);const RA=(0,PA.A)(EA,[["__scopeId","data-v-6f8cc29c"]]);var IA={key:0,class:"trp-field__label trp-primary-text-bold"},NA={class:"trp-number__wrapper"},LA=["value","min"];const QA={__name:"NumberField",props:{label:{type:String,default:""},modelValue:{type:[Number,null],default:null},min:{type:Number,default:0,required:!1}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n;function o(e){var t=e.target.value;i("update:modelValue",""===t?r.min:Number(t))}return function(t,n){var r;return Ms(),Ls("div",null,[e.label?(Ms(),Ls("span",IA,pe(e.label),1)):Js("",!0),Hs("div",NA,[Hs("input",{type:"number",class:"trp-number-input",value:null!==(r=e.modelValue)&&void 0!==r?r:"",min:e.min,onInput:o},null,40,LA),n[0]||(n[0]=Hs("span",{class:"trp-primary-text"},"px",-1))])])}}};var FA=n(565),VA={insert:"head",singleton:!1};Tg()(FA.A,VA);FA.A.locals;const zA=(0,PA.A)(QA,[["__scopeId","data-v-4d5d37b0"]]);var WA={class:"trp-toggle-wrapper"},$A={key:0,class:"trp-field__label trp-primary-text-bold"},HA=["checked"];const jA={__name:"ToggleField",props:{modelValue:Boolean,label:{type:String,default:""}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=n;return function(t,n){return Ms(),Ls("div",WA,[e.label?(Ms(),Ls("span",$A,pe(e.label),1)):Js("",!0),Hs("div",{class:"trp-toggle-inner",onClick:n[0]||(n[0]=function(t){return r("update:modelValue",!e.modelValue)})},[Hs("input",{type:"checkbox",class:"trp-toggle-input",checked:e.modelValue,readonly:""},null,8,HA),n[1]||(n[1]=Hs("span",{class:"trp-toggle-slider"},null,-1))])])}}};var qA=n(787),UA={insert:"head",singleton:!1};Tg()(qA.A,UA);qA.A.locals;const GA=(0,PA.A)(jA,[["__scopeId","data-v-30d3f338"]]);var YA={class:"trp-toggle-status-field"},XA={class:"trp-primary-text"};const JA={__name:"ToggleStatusField",props:{modelValue:Boolean,onText:{type:String,default:"Enabled"},offText:{type:String,default:"Disabled"}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o=_a({get:function(){return r.modelValue},set:function(e){return i("update:modelValue",e)}});return function(t,n){return Ms(),Ls("div",YA,[js(GA,{modelValue:o.value,"onUpdate:modelValue":n[0]||(n[0]=function(e){return o.value=e}),label:""},null,8,["modelValue"]),Hs("span",XA,pe(e.modelValue?e.onText:e.offText),1)])}}};var KA=n(268),ZA={insert:"head",singleton:!1};Tg()(KA.A,ZA);KA.A.locals;const eb=(0,PA.A)(JA,[["__scopeId","data-v-63ef0d74"]]);function tb(e){return function(e){if(Array.isArray(e))return nb(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return nb(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?nb(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function nb(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var rb={class:"trp-radio-group__wrapper"},ib={key:0,class:"trp-field__label trp-primary-text-bold"},ob={class:"trp-radio-group"},sb=["title"],ab={class:"trp-radio-label"},lb=["name","value","checked","disabled","onChange"];const cb={__name:"RadioGroupField",props:{label:{type:String,required:!1,default:""},modelValue:{type:String,required:!0},options:{type:Array,required:!0,validator:function(e){return e.every(function(e){return"value"in e&&"label"in e&&(void 0===e.disabled||"boolean"==typeof e.disabled)&&(void 0===e.title||"string"==typeof e.title)})}},customValue:{type:[Number,String]}},emits:["update:modelValue","update:customValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o=Gt(r.customValue);ur(function(){return r.customValue},function(e){e!==o.value&&(o.value=e)}),ur(o,function(e){i("update:customValue",e)});var s=_a(function(){return void 0!==r.customValue}),a=_a(function(){return s.value?r.options.some(function(e){return"custom"===e.value})?r.options:[].concat(tb(r.options),[{value:"custom",label:"Custom"}]):r.options});return function(t,n){return Ms(),Ls("div",rb,[e.label?(Ms(),Ls("span",ib,pe(e.label),1)):Js("",!0),Hs("div",ob,[(Ms(!0),Ls(Ss,null,qi(a.value,function(t){return Ms(),Ls("div",{key:t.value,class:X(["trp-radio-option",{"is-disabled":t.disabled}]),title:t.title},[Hs("label",ab,[Hs("input",{type:"radio",name:e.label||"radio-group",value:t.value,checked:e.modelValue===t.value,disabled:t.disabled,onChange:function(){return i("update:modelValue",t.value)}},null,40,lb),Hs("span",null,pe(t.label),1)]),s.value&&"custom"===t.value&&"custom"===e.modelValue?(Ms(),Qs(zA,{key:0,class:"trp-lc-custom-number",modelValue:o.value,"onUpdate:modelValue":n[0]||(n[0]=function(e){return o.value=e}),label:"",min:0},null,8,["modelValue"])):Js("",!0)],10,sb)}),128))])])}}};var db=n(139),hb={insert:"head",singleton:!1};Tg()(db.A,hb);db.A.locals;const ub=(0,PA.A)(cb,[["__scopeId","data-v-e2617dbe"]]);function pb(e){return function(e){if(Array.isArray(e))return fb(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return fb(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?fb(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function fb(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var gb={class:"trp-field trp-field--column"},mb={class:"trp-field__label trp-primary-text-bold"},vb={class:"trp-quad-grid"},Ab={class:"trp-primary-text trp-corner-label"};const bb={__name:"QuadRadiusField",props:{label:{type:String,default:""},modelValue:{type:Array,required:!0}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o=Array.from({length:4},function(e,t){return _a({get:function(){var e;return null!==(e=r.modelValue[t])&&void 0!==e?e:0},set:function(e){var n=pb(r.modelValue);n[t]=e,i("update:modelValue",n)}})}),s=["Top Left","Top Right","Bottom Left","Bottom Right"];return function(t,n){return Ms(),Ls("div",gb,[Hs("span",mb,pe(e.label),1),Hs("div",vb,[(Ms(),Ls(Ss,null,qi(s,function(e,t){return Hs("div",{key:t,class:"trp-quad-radius-corner"},[Hs("span",Ab,pe(e),1),js(zA,{modelValue:Zt(o)[t].value,"onUpdate:modelValue":function(e){return Zt(o)[t].value=e},label:""},null,8,["modelValue","onUpdate:modelValue"])])}),64))])])}}};var yb=n(419),xb={insert:"head",singleton:!1};Tg()(yb.A,xb);yb.A.locals;const wb=(0,PA.A)(bb,[["__scopeId","data-v-44785c6b"]]);let Cb=[],kb=[];function Sb(e){if(e<768)return!1;for(let t=0,n=Cb.length;;){let r=t+n>>1;if(e<Cb[r])n=r;else{if(!(e>=kb[r]))return!0;t=r+1}if(t==n)return!1}}function Ob(e){return e>=127462&&e<=127487}(()=>{let e="lc,34,7n,7,7b,19,,,,2,,2,,,20,b,1c,l,g,,2t,7,2,6,2,2,,4,z,,u,r,2j,b,1m,9,9,,o,4,,9,,3,,5,17,3,3b,f,,w,1j,,,,4,8,4,,3,7,a,2,t,,1m,,,,2,4,8,,9,,a,2,q,,2,2,1l,,4,2,4,2,2,3,3,,u,2,3,,b,2,1l,,4,5,,2,4,,k,2,m,6,,,1m,,,2,,4,8,,7,3,a,2,u,,1n,,,,c,,9,,14,,3,,1l,3,5,3,,4,7,2,b,2,t,,1m,,2,,2,,3,,5,2,7,2,b,2,s,2,1l,2,,,2,4,8,,9,,a,2,t,,20,,4,,2,3,,,8,,29,,2,7,c,8,2q,,2,9,b,6,22,2,r,,,,,,1j,e,,5,,2,5,b,,10,9,,2u,4,,6,,2,2,2,p,2,4,3,g,4,d,,2,2,6,,f,,jj,3,qa,3,t,3,t,2,u,2,1s,2,,7,8,,2,b,9,,19,3,3b,2,y,,3a,3,4,2,9,,6,3,63,2,2,,1m,,,7,,,,,2,8,6,a,2,,1c,h,1r,4,1c,7,,,5,,14,9,c,2,w,4,2,2,,3,1k,,,2,3,,,3,1m,8,2,2,48,3,,d,,7,4,,6,,3,2,5i,1m,,5,ek,,5f,x,2da,3,3x,,2o,w,fe,6,2x,2,n9w,4,,a,w,2,28,2,7k,,3,,4,,p,2,5,,47,2,q,i,d,,12,8,p,b,1a,3,1c,,2,4,2,2,13,,1v,6,2,2,2,2,c,,8,,1b,,1f,,,3,2,2,5,2,,,16,2,8,,6m,,2,,4,,fn4,,kh,g,g,g,a6,2,gt,,6a,,45,5,1ae,3,,2,5,4,14,3,4,,4l,2,fx,4,ar,2,49,b,4w,,1i,f,1k,3,1d,4,2,2,1x,3,10,5,,8,1q,,c,2,1g,9,a,4,2,,2n,3,2,,,2,6,,4g,,3,8,l,2,1l,2,,,,,m,,e,7,3,5,5f,8,2,3,,,n,,29,,2,6,,,2,,,2,,2,6j,,2,4,6,2,,2,r,2,2d,8,2,,,2,2y,,,,2,6,,,2t,3,2,4,,5,77,9,,2,6t,,a,2,,,4,,40,4,2,2,4,,w,a,14,6,2,4,8,,9,6,2,3,1a,d,,2,ba,7,,6,,,2a,m,2,7,,2,,2,3e,6,3,,,2,,7,,,20,2,3,,,,9n,2,f0b,5,1n,7,t4,,1r,4,29,,f5k,2,43q,,,3,4,5,8,8,2,7,u,4,44,3,1iz,1j,4,1e,8,,e,,m,5,,f,11s,7,,h,2,7,,2,,5,79,7,c5,4,15s,7,31,7,240,5,gx7k,2o,3k,6o".split(",").map(e=>e?parseInt(e,36):1);for(let t=0,n=0;t<e.length;t++)(t%2?kb:Cb).push(n+=e[t])})();function Bb(e,t,n=!0,r=!0){return(n?_b:Tb)(e,t,r)}function _b(e,t,n){if(t==e.length)return t;t&&Mb(e.charCodeAt(t))&&Db(e.charCodeAt(t-1))&&t--;let r=Eb(e,t);for(t+=Pb(r);t<e.length;){let i=Eb(e,t);if(8205==r||8205==i||n&&Sb(i))t+=Pb(i),r=i;else{if(!Ob(i))break;{let n=0,r=t-2;for(;r>=0&&Ob(Eb(e,r));)n++,r-=2;if(n%2==0)break;t+=2}}}return t}function Tb(e,t,n){for(;t>0;){let r=_b(e,t-2,n);if(r<t)return r;t--}return 0}function Eb(e,t){let n=e.charCodeAt(t);if(!Db(n)||t+1==e.length)return n;let r=e.charCodeAt(t+1);return Mb(r)?r-56320+(n-55296<<10)+65536:n}function Mb(e){return e>=56320&&e<57344}function Db(e){return e>=55296&&e<56320}function Pb(e){return e<65536?1:2}class Rb{lineAt(e){if(e<0||e>this.length)throw new RangeError(`Invalid position ${e} in document of length ${this.length}`);return this.lineInner(e,!1,1,0)}line(e){if(e<1||e>this.lines)throw new RangeError(`Invalid line number ${e} in ${this.lines}-line document`);return this.lineInner(e,!0,1,0)}replace(e,t,n){[e,t]=$b(this,e,t);let r=[];return this.decompose(0,e,r,2),n.length&&n.decompose(0,n.length,r,3),this.decompose(t,this.length,r,1),Nb.from(r,this.length-(t-e)+n.length)}append(e){return this.replace(this.length,this.length,e)}slice(e,t=this.length){[e,t]=$b(this,e,t);let n=[];return this.decompose(e,t,n,0),Nb.from(n,t-e)}eq(e){if(e==this)return!0;if(e.length!=this.length||e.lines!=this.lines)return!1;let t=this.scanIdentical(e,1),n=this.length-this.scanIdentical(e,-1),r=new Fb(this),i=new Fb(e);for(let e=t,o=t;;){if(r.next(e),i.next(e),e=0,r.lineBreak!=i.lineBreak||r.done!=i.done||r.value!=i.value)return!1;if(o+=r.value.length,r.done||o>=n)return!0}}iter(e=1){return new Fb(this,e)}iterRange(e,t=this.length){return new Vb(this,e,t)}iterLines(e,t){let n;if(null==e)n=this.iter();else{null==t&&(t=this.lines+1);let r=this.line(e).from;n=this.iterRange(r,Math.max(r,t==this.lines+1?this.length:t<=1?0:this.line(t-1).to))}return new zb(n)}toString(){return this.sliceString(0)}toJSON(){let e=[];return this.flatten(e),e}constructor(){}static of(e){if(0==e.length)throw new RangeError("A document must have at least one line");return 1!=e.length||e[0]?e.length<=32?new Ib(e):Nb.from(Ib.split(e,[])):Rb.empty}}class Ib extends Rb{constructor(e,t=function(e){let t=-1;for(let n of e)t+=n.length+1;return t}(e)){super(),this.text=e,this.length=t}get lines(){return this.text.length}get children(){return null}lineInner(e,t,n,r){for(let i=0;;i++){let o=this.text[i],s=r+o.length;if((t?n:s)>=e)return new Wb(r,s,n,o);r=s+1,n++}}decompose(e,t,n,r){let i=e<=0&&t>=this.length?this:new Ib(Qb(this.text,e,t),Math.min(t,this.length)-Math.max(0,e));if(1&r){let e=n.pop(),t=Lb(i.text,e.text.slice(),0,i.length);if(t.length<=32)n.push(new Ib(t,e.length+i.length));else{let e=t.length>>1;n.push(new Ib(t.slice(0,e)),new Ib(t.slice(e)))}}else n.push(i)}replace(e,t,n){if(!(n instanceof Ib))return super.replace(e,t,n);[e,t]=$b(this,e,t);let r=Lb(this.text,Lb(n.text,Qb(this.text,0,e)),t),i=this.length+n.length-(t-e);return r.length<=32?new Ib(r,i):Nb.from(Ib.split(r,[]),i)}sliceString(e,t=this.length,n="\n"){[e,t]=$b(this,e,t);let r="";for(let i=0,o=0;i<=t&&o<this.text.length;o++){let s=this.text[o],a=i+s.length;i>e&&o&&(r+=n),e<a&&t>i&&(r+=s.slice(Math.max(0,e-i),t-i)),i=a+1}return r}flatten(e){for(let t of this.text)e.push(t)}scanIdentical(){return 0}static split(e,t){let n=[],r=-1;for(let i of e)n.push(i),r+=i.length+1,32==n.length&&(t.push(new Ib(n,r)),n=[],r=-1);return r>-1&&t.push(new Ib(n,r)),t}}class Nb extends Rb{constructor(e,t){super(),this.children=e,this.length=t,this.lines=0;for(let t of e)this.lines+=t.lines}lineInner(e,t,n,r){for(let i=0;;i++){let o=this.children[i],s=r+o.length,a=n+o.lines-1;if((t?a:s)>=e)return o.lineInner(e,t,n,r);r=s+1,n=a+1}}decompose(e,t,n,r){for(let i=0,o=0;o<=t&&i<this.children.length;i++){let s=this.children[i],a=o+s.length;if(e<=a&&t>=o){let i=r&((o<=e?1:0)|(a>=t?2:0));o>=e&&a<=t&&!i?n.push(s):s.decompose(e-o,t-o,n,i)}o=a+1}}replace(e,t,n){if([e,t]=$b(this,e,t),n.lines<this.lines)for(let r=0,i=0;r<this.children.length;r++){let o=this.children[r],s=i+o.length;if(e>=i&&t<=s){let a=o.replace(e-i,t-i,n),l=this.lines-o.lines+a.lines;if(a.lines<l>>4&&a.lines>l>>6){let i=this.children.slice();return i[r]=a,new Nb(i,this.length-(t-e)+n.length)}return super.replace(i,s,a)}i=s+1}return super.replace(e,t,n)}sliceString(e,t=this.length,n="\n"){[e,t]=$b(this,e,t);let r="";for(let i=0,o=0;i<this.children.length&&o<=t;i++){let s=this.children[i],a=o+s.length;o>e&&i&&(r+=n),e<a&&t>o&&(r+=s.sliceString(e-o,t-o,n)),o=a+1}return r}flatten(e){for(let t of this.children)t.flatten(e)}scanIdentical(e,t){if(!(e instanceof Nb))return 0;let n=0,[r,i,o,s]=t>0?[0,0,this.children.length,e.children.length]:[this.children.length-1,e.children.length-1,-1,-1];for(;;r+=t,i+=t){if(r==o||i==s)return n;let a=this.children[r],l=e.children[i];if(a!=l)return n+a.scanIdentical(l,t);n+=a.length+1}}static from(e,t=e.reduce((e,t)=>e+t.length+1,-1)){let n=0;for(let t of e)n+=t.lines;if(n<32){let n=[];for(let t of e)t.flatten(n);return new Ib(n,t)}let r=Math.max(32,n>>5),i=r<<1,o=r>>1,s=[],a=0,l=-1,c=[];function d(e){let t;if(e.lines>i&&e instanceof Nb)for(let t of e.children)d(t);else e.lines>o&&(a>o||!a)?(h(),s.push(e)):e instanceof Ib&&a&&(t=c[c.length-1])instanceof Ib&&e.lines+t.lines<=32?(a+=e.lines,l+=e.length+1,c[c.length-1]=new Ib(t.text.concat(e.text),t.length+1+e.length)):(a+e.lines>r&&h(),a+=e.lines,l+=e.length+1,c.push(e))}function h(){0!=a&&(s.push(1==c.length?c[0]:Nb.from(c,l)),l=-1,a=c.length=0)}for(let t of e)d(t);return h(),1==s.length?s[0]:new Nb(s,t)}}function Lb(e,t,n=0,r=1e9){for(let i=0,o=0,s=!0;o<e.length&&i<=r;o++){let a=e[o],l=i+a.length;l>=n&&(l>r&&(a=a.slice(0,r-i)),i<n&&(a=a.slice(n-i)),s?(t[t.length-1]+=a,s=!1):t.push(a)),i=l+1}return t}function Qb(e,t,n){return Lb(e,[""],t,n)}Rb.empty=new Ib([""],0);class Fb{constructor(e,t=1){this.dir=t,this.done=!1,this.lineBreak=!1,this.value="",this.nodes=[e],this.offsets=[t>0?1:(e instanceof Ib?e.text.length:e.children.length)<<1]}nextInner(e,t){for(this.done=this.lineBreak=!1;;){let n=this.nodes.length-1,r=this.nodes[n],i=this.offsets[n],o=i>>1,s=r instanceof Ib?r.text.length:r.children.length;if(o==(t>0?s:0)){if(0==n)return this.done=!0,this.value="",this;t>0&&this.offsets[n-1]++,this.nodes.pop(),this.offsets.pop()}else if((1&i)==(t>0?0:1)){if(this.offsets[n]+=t,0==e)return this.lineBreak=!0,this.value="\n",this;e--}else if(r instanceof Ib){let i=r.text[o+(t<0?-1:0)];if(this.offsets[n]+=t,i.length>Math.max(0,e))return this.value=0==e?i:t>0?i.slice(e):i.slice(0,i.length-e),this;e-=i.length}else{let i=r.children[o+(t<0?-1:0)];e>i.length?(e-=i.length,this.offsets[n]+=t):(t<0&&this.offsets[n]--,this.nodes.push(i),this.offsets.push(t>0?1:(i instanceof Ib?i.text.length:i.children.length)<<1))}}}next(e=0){return e<0&&(this.nextInner(-e,-this.dir),e=this.value.length),this.nextInner(e,this.dir)}}class Vb{constructor(e,t,n){this.value="",this.done=!1,this.cursor=new Fb(e,t>n?-1:1),this.pos=t>n?e.length:0,this.from=Math.min(t,n),this.to=Math.max(t,n)}nextInner(e,t){if(t<0?this.pos<=this.from:this.pos>=this.to)return this.value="",this.done=!0,this;e+=Math.max(0,t<0?this.pos-this.to:this.from-this.pos);let n=t<0?this.pos-this.from:this.to-this.pos;e>n&&(e=n),n-=e;let{value:r}=this.cursor.next(e);return this.pos+=(r.length+e)*t,this.value=r.length<=n?r:t<0?r.slice(r.length-n):r.slice(0,n),this.done=!this.value,this}next(e=0){return e<0?e=Math.max(e,this.from-this.pos):e>0&&(e=Math.min(e,this.to-this.pos)),this.nextInner(e,this.cursor.dir)}get lineBreak(){return this.cursor.lineBreak&&""!=this.value}}class zb{constructor(e){this.inner=e,this.afterBreak=!0,this.value="",this.done=!1}next(e=0){let{done:t,lineBreak:n,value:r}=this.inner.next(e);return t&&this.afterBreak?(this.value="",this.afterBreak=!1):t?(this.done=!0,this.value=""):n?this.afterBreak?this.value="":(this.afterBreak=!0,this.next()):(this.value=r,this.afterBreak=!1),this}get lineBreak(){return!1}}"undefined"!=typeof Symbol&&(Rb.prototype[Symbol.iterator]=function(){return this.iter()},Fb.prototype[Symbol.iterator]=Vb.prototype[Symbol.iterator]=zb.prototype[Symbol.iterator]=function(){return this});class Wb{constructor(e,t,n,r){this.from=e,this.to=t,this.number=n,this.text=r}get length(){return this.to-this.from}}function $b(e,t,n){return[t=Math.max(0,Math.min(e.length,t)),Math.max(t,Math.min(e.length,n))]}function Hb(e,t,n=!0,r=!0){return Bb(e,t,n,r)}function jb(e,t){let n=e.charCodeAt(t);if(!(r=n,r>=55296&&r<56320&&t+1!=e.length))return n;var r;let i=e.charCodeAt(t+1);return function(e){return e>=56320&&e<57344}(i)?i-56320+(n-55296<<10)+65536:n}function qb(e){return e<=65535?String.fromCharCode(e):(e-=65536,String.fromCharCode(55296+(e>>10),56320+(1023&e)))}function Ub(e){return e<65536?1:2}const Gb=/\r\n?|\n/;var Yb=function(e){return e[e.Simple=0]="Simple",e[e.TrackDel=1]="TrackDel",e[e.TrackBefore=2]="TrackBefore",e[e.TrackAfter=3]="TrackAfter",e}(Yb||(Yb={}));class Xb{constructor(e){this.sections=e}get length(){let e=0;for(let t=0;t<this.sections.length;t+=2)e+=this.sections[t];return e}get newLength(){let e=0;for(let t=0;t<this.sections.length;t+=2){let n=this.sections[t+1];e+=n<0?this.sections[t]:n}return e}get empty(){return 0==this.sections.length||2==this.sections.length&&this.sections[1]<0}iterGaps(e){for(let t=0,n=0,r=0;t<this.sections.length;){let i=this.sections[t++],o=this.sections[t++];o<0?(e(n,r,i),r+=i):r+=o,n+=i}}iterChangedRanges(e,t=!1){ey(this,e,t)}get invertedDesc(){let e=[];for(let t=0;t<this.sections.length;){let n=this.sections[t++],r=this.sections[t++];r<0?e.push(n,r):e.push(r,n)}return new Xb(e)}composeDesc(e){return this.empty?e:e.empty?this:ny(this,e)}mapDesc(e,t=!1){return e.empty?this:ty(this,e,t)}mapPos(e,t=-1,n=Yb.Simple){let r=0,i=0;for(let o=0;o<this.sections.length;){let s=this.sections[o++],a=this.sections[o++],l=r+s;if(a<0){if(l>e)return i+(e-r);i+=s}else{if(n!=Yb.Simple&&l>=e&&(n==Yb.TrackDel&&r<e&&l>e||n==Yb.TrackBefore&&r<e||n==Yb.TrackAfter&&l>e))return null;if(l>e||l==e&&t<0&&!s)return e==r||t<0?i:i+a;i+=a}r=l}if(e>r)throw new RangeError(`Position ${e} is out of range for changeset of length ${r}`);return i}touchesRange(e,t=e){for(let n=0,r=0;n<this.sections.length&&r<=t;){let i=r+this.sections[n++];if(this.sections[n++]>=0&&r<=t&&i>=e)return!(r<e&&i>t)||"cover";r=i}return!1}toString(){let e="";for(let t=0;t<this.sections.length;){let n=this.sections[t++],r=this.sections[t++];e+=(e?" ":"")+n+(r>=0?":"+r:"")}return e}toJSON(){return this.sections}static fromJSON(e){if(!Array.isArray(e)||e.length%2||e.some(e=>"number"!=typeof e))throw new RangeError("Invalid JSON representation of ChangeDesc");return new Xb(e)}static create(e){return new Xb(e)}}class Jb extends Xb{constructor(e,t){super(e),this.inserted=t}apply(e){if(this.length!=e.length)throw new RangeError("Applying change set to a document with the wrong length");return ey(this,(t,n,r,i,o)=>e=e.replace(r,r+(n-t),o),!1),e}mapDesc(e,t=!1){return ty(this,e,t,!0)}invert(e){let t=this.sections.slice(),n=[];for(let r=0,i=0;r<t.length;r+=2){let o=t[r],s=t[r+1];if(s>=0){t[r]=s,t[r+1]=o;let a=r>>1;for(;n.length<a;)n.push(Rb.empty);n.push(o?e.slice(i,i+o):Rb.empty)}i+=o}return new Jb(t,n)}compose(e){return this.empty?e:e.empty?this:ny(this,e,!0)}map(e,t=!1){return e.empty?this:ty(this,e,t,!0)}iterChanges(e,t=!1){ey(this,e,t)}get desc(){return Xb.create(this.sections)}filter(e){let t=[],n=[],r=[],i=new ry(this);e:for(let o=0,s=0;;){let a=o==e.length?1e9:e[o++];for(;s<a||s==a&&0==i.len;){if(i.done)break e;let e=Math.min(i.len,a-s);Kb(r,e,-1);let o=-1==i.ins?-1:0==i.off?i.ins:0;Kb(t,e,o),o>0&&Zb(n,t,i.text),i.forward(e),s+=e}let l=e[o++];for(;s<l;){if(i.done)break e;let e=Math.min(i.len,l-s);Kb(t,e,-1),Kb(r,e,-1==i.ins?-1:0==i.off?i.ins:0),i.forward(e),s+=e}}return{changes:new Jb(t,n),filtered:Xb.create(r)}}toJSON(){let e=[];for(let t=0;t<this.sections.length;t+=2){let n=this.sections[t],r=this.sections[t+1];r<0?e.push(n):0==r?e.push([n]):e.push([n].concat(this.inserted[t>>1].toJSON()))}return e}static of(e,t,n){let r=[],i=[],o=0,s=null;function a(e=!1){if(!e&&!r.length)return;o<t&&Kb(r,t-o,-1);let n=new Jb(r,i);s=s?s.compose(n.map(s)):n,r=[],i=[],o=0}return function e(l){if(Array.isArray(l))for(let t of l)e(t);else if(l instanceof Jb){if(l.length!=t)throw new RangeError(`Mismatched change set length (got ${l.length}, expected ${t})`);a(),s=s?s.compose(l.map(s)):l}else{let{from:e,to:s=e,insert:c}=l;if(e>s||e<0||s>t)throw new RangeError(`Invalid change range ${e} to ${s} (in doc of length ${t})`);let d=c?"string"==typeof c?Rb.of(c.split(n||Gb)):c:Rb.empty,h=d.length;if(e==s&&0==h)return;e<o&&a(),e>o&&Kb(r,e-o,-1),Kb(r,s-e,h),Zb(i,r,d),o=s}}(e),a(!s),s}static empty(e){return new Jb(e?[e,-1]:[],[])}static fromJSON(e){if(!Array.isArray(e))throw new RangeError("Invalid JSON representation of ChangeSet");let t=[],n=[];for(let r=0;r<e.length;r++){let i=e[r];if("number"==typeof i)t.push(i,-1);else{if(!Array.isArray(i)||"number"!=typeof i[0]||i.some((e,t)=>t&&"string"!=typeof e))throw new RangeError("Invalid JSON representation of ChangeSet");if(1==i.length)t.push(i[0],0);else{for(;n.length<r;)n.push(Rb.empty);n[r]=Rb.of(i.slice(1)),t.push(i[0],n[r].length)}}}return new Jb(t,n)}static createSet(e,t){return new Jb(e,t)}}function Kb(e,t,n,r=!1){if(0==t&&n<=0)return;let i=e.length-2;i>=0&&n<=0&&n==e[i+1]?e[i]+=t:i>=0&&0==t&&0==e[i]?e[i+1]+=n:r?(e[i]+=t,e[i+1]+=n):e.push(t,n)}function Zb(e,t,n){if(0==n.length)return;let r=t.length-2>>1;if(r<e.length)e[e.length-1]=e[e.length-1].append(n);else{for(;e.length<r;)e.push(Rb.empty);e.push(n)}}function ey(e,t,n){let r=e.inserted;for(let i=0,o=0,s=0;s<e.sections.length;){let a=e.sections[s++],l=e.sections[s++];if(l<0)i+=a,o+=a;else{let c=i,d=o,h=Rb.empty;for(;c+=a,d+=l,l&&r&&(h=h.append(r[s-2>>1])),!(n||s==e.sections.length||e.sections[s+1]<0);)a=e.sections[s++],l=e.sections[s++];t(i,c,o,d,h),i=c,o=d}}}function ty(e,t,n,r=!1){let i=[],o=r?[]:null,s=new ry(e),a=new ry(t);for(let e=-1;;){if(s.done&&a.len||a.done&&s.len)throw new Error("Mismatched change set lengths");if(-1==s.ins&&-1==a.ins){let e=Math.min(s.len,a.len);Kb(i,e,-1),s.forward(e),a.forward(e)}else if(a.ins>=0&&(s.ins<0||e==s.i||0==s.off&&(a.len<s.len||a.len==s.len&&!n))){let t=a.len;for(Kb(i,a.ins,-1);t;){let n=Math.min(s.len,t);s.ins>=0&&e<s.i&&s.len<=n&&(Kb(i,0,s.ins),o&&Zb(o,i,s.text),e=s.i),s.forward(n),t-=n}a.next()}else{if(!(s.ins>=0)){if(s.done&&a.done)return o?Jb.createSet(i,o):Xb.create(i);throw new Error("Mismatched change set lengths")}{let t=0,n=s.len;for(;n;)if(-1==a.ins){let e=Math.min(n,a.len);t+=e,n-=e,a.forward(e)}else{if(!(0==a.ins&&a.len<n))break;n-=a.len,a.next()}Kb(i,t,e<s.i?s.ins:0),o&&e<s.i&&Zb(o,i,s.text),e=s.i,s.forward(s.len-n)}}}}function ny(e,t,n=!1){let r=[],i=n?[]:null,o=new ry(e),s=new ry(t);for(let e=!1;;){if(o.done&&s.done)return i?Jb.createSet(r,i):Xb.create(r);if(0==o.ins)Kb(r,o.len,0,e),o.next();else if(0!=s.len||s.done){if(o.done||s.done)throw new Error("Mismatched change set lengths");{let t=Math.min(o.len2,s.len),n=r.length;if(-1==o.ins){let n=-1==s.ins?-1:s.off?0:s.ins;Kb(r,t,n,e),i&&n&&Zb(i,r,s.text)}else-1==s.ins?(Kb(r,o.off?0:o.len,t,e),i&&Zb(i,r,o.textBit(t))):(Kb(r,o.off?0:o.len,s.off?0:s.ins,e),i&&!s.off&&Zb(i,r,s.text));e=(o.ins>t||s.ins>=0&&s.len>t)&&(e||r.length>n),o.forward2(t),s.forward(t)}}else Kb(r,0,s.ins,e),i&&Zb(i,r,s.text),s.next()}}class ry{constructor(e){this.set=e,this.i=0,this.next()}next(){let{sections:e}=this.set;this.i<e.length?(this.len=e[this.i++],this.ins=e[this.i++]):(this.len=0,this.ins=-2),this.off=0}get done(){return-2==this.ins}get len2(){return this.ins<0?this.len:this.ins}get text(){let{inserted:e}=this.set,t=this.i-2>>1;return t>=e.length?Rb.empty:e[t]}textBit(e){let{inserted:t}=this.set,n=this.i-2>>1;return n>=t.length&&!e?Rb.empty:t[n].slice(this.off,null==e?void 0:this.off+e)}forward(e){e==this.len?this.next():(this.len-=e,this.off+=e)}forward2(e){-1==this.ins?this.forward(e):e==this.ins?this.next():(this.ins-=e,this.off+=e)}}class iy{constructor(e,t,n){this.from=e,this.to=t,this.flags=n}get anchor(){return 32&this.flags?this.to:this.from}get head(){return 32&this.flags?this.from:this.to}get empty(){return this.from==this.to}get assoc(){return 8&this.flags?-1:16&this.flags?1:0}get bidiLevel(){let e=7&this.flags;return 7==e?null:e}get goalColumn(){let e=this.flags>>6;return 16777215==e?void 0:e}map(e,t=-1){let n,r;return this.empty?n=r=e.mapPos(this.from,t):(n=e.mapPos(this.from,1),r=e.mapPos(this.to,-1)),n==this.from&&r==this.to?this:new iy(n,r,this.flags)}extend(e,t=e){if(e<=this.anchor&&t>=this.anchor)return oy.range(e,t);let n=Math.abs(e-this.anchor)>Math.abs(t-this.anchor)?e:t;return oy.range(this.anchor,n)}eq(e,t=!1){return!(this.anchor!=e.anchor||this.head!=e.head||this.goalColumn!=e.goalColumn||t&&this.empty&&this.assoc!=e.assoc)}toJSON(){return{anchor:this.anchor,head:this.head}}static fromJSON(e){if(!e||"number"!=typeof e.anchor||"number"!=typeof e.head)throw new RangeError("Invalid JSON representation for SelectionRange");return oy.range(e.anchor,e.head)}static create(e,t,n){return new iy(e,t,n)}}class oy{constructor(e,t){this.ranges=e,this.mainIndex=t}map(e,t=-1){return e.empty?this:oy.create(this.ranges.map(n=>n.map(e,t)),this.mainIndex)}eq(e,t=!1){if(this.ranges.length!=e.ranges.length||this.mainIndex!=e.mainIndex)return!1;for(let n=0;n<this.ranges.length;n++)if(!this.ranges[n].eq(e.ranges[n],t))return!1;return!0}get main(){return this.ranges[this.mainIndex]}asSingle(){return 1==this.ranges.length?this:new oy([this.main],0)}addRange(e,t=!0){return oy.create([e].concat(this.ranges),t?0:this.mainIndex+1)}replaceRange(e,t=this.mainIndex){let n=this.ranges.slice();return n[t]=e,oy.create(n,this.mainIndex)}toJSON(){return{ranges:this.ranges.map(e=>e.toJSON()),main:this.mainIndex}}static fromJSON(e){if(!e||!Array.isArray(e.ranges)||"number"!=typeof e.main||e.main>=e.ranges.length)throw new RangeError("Invalid JSON representation for EditorSelection");return new oy(e.ranges.map(e=>iy.fromJSON(e)),e.main)}static single(e,t=e){return new oy([oy.range(e,t)],0)}static create(e,t=0){if(0==e.length)throw new RangeError("A selection needs at least one range");for(let n=0,r=0;r<e.length;r++){let i=e[r];if(i.empty?i.from<=n:i.from<n)return oy.normalized(e.slice(),t);n=i.to}return new oy(e,t)}static cursor(e,t=0,n,r){return iy.create(e,e,(0==t?0:t<0?8:16)|(null==n?7:Math.min(6,n))|(null!=r?r:16777215)<<6)}static range(e,t,n,r){let i=(null!=n?n:16777215)<<6|(null==r?7:Math.min(6,r));return t<e?iy.create(t,e,48|i):iy.create(e,t,(t>e?8:0)|i)}static normalized(e,t=0){let n=e[t];e.sort((e,t)=>e.from-t.from),t=e.indexOf(n);for(let n=1;n<e.length;n++){let r=e[n],i=e[n-1];if(r.empty?r.from<=i.to:r.from<i.to){let o=i.from,s=Math.max(r.to,i.to);n<=t&&t--,e.splice(--n,2,r.anchor>r.head?oy.range(s,o):oy.range(o,s))}}return new oy(e,t)}}function sy(e,t){for(let n of e.ranges)if(n.to>t)throw new RangeError("Selection points outside of document")}let ay=0;class ly{constructor(e,t,n,r,i){this.combine=e,this.compareInput=t,this.compare=n,this.isStatic=r,this.id=ay++,this.default=e([]),this.extensions="function"==typeof i?i(this):i}get reader(){return this}static define(e={}){return new ly(e.combine||(e=>e),e.compareInput||((e,t)=>e===t),e.compare||(e.combine?(e,t)=>e===t:cy),!!e.static,e.enables)}of(e){return new dy([],this,0,e)}compute(e,t){if(this.isStatic)throw new Error("Can't compute a static facet");return new dy(e,this,1,t)}computeN(e,t){if(this.isStatic)throw new Error("Can't compute a static facet");return new dy(e,this,2,t)}from(e,t){return t||(t=e=>e),this.compute([e],n=>t(n.field(e)))}}function cy(e,t){return e==t||e.length==t.length&&e.every((e,n)=>e===t[n])}class dy{constructor(e,t,n,r){this.dependencies=e,this.facet=t,this.type=n,this.value=r,this.id=ay++}dynamicSlot(e){var t;let n=this.value,r=this.facet.compareInput,i=this.id,o=e[i]>>1,s=2==this.type,a=!1,l=!1,c=[];for(let n of this.dependencies)"doc"==n?a=!0:"selection"==n?l=!0:1&(null!==(t=e[n.id])&&void 0!==t?t:1)||c.push(e[n.id]);return{create:e=>(e.values[o]=n(e),1),update(e,t){if(a&&t.docChanged||l&&(t.docChanged||t.selection)||uy(e,c)){let t=n(e);if(s?!hy(t,e.values[o],r):!r(t,e.values[o]))return e.values[o]=t,1}return 0},reconfigure:(e,t)=>{let a,l=t.config.address[i];if(null!=l){let i=By(t,l);if(this.dependencies.every(n=>n instanceof ly?t.facet(n)===e.facet(n):!(n instanceof gy)||t.field(n,!1)==e.field(n,!1))||(s?hy(a=n(e),i,r):r(a=n(e),i)))return e.values[o]=i,0}else a=n(e);return e.values[o]=a,1}}}}function hy(e,t,n){if(e.length!=t.length)return!1;for(let r=0;r<e.length;r++)if(!n(e[r],t[r]))return!1;return!0}function uy(e,t){let n=!1;for(let r of t)1&Oy(e,r)&&(n=!0);return n}function py(e,t,n){let r=n.map(t=>e[t.id]),i=n.map(e=>e.type),o=r.filter(e=>!(1&e)),s=e[t.id]>>1;function a(e){let n=[];for(let t=0;t<r.length;t++){let o=By(e,r[t]);if(2==i[t])for(let e of o)n.push(e);else n.push(o)}return t.combine(n)}return{create(e){for(let t of r)Oy(e,t);return e.values[s]=a(e),1},update(e,n){if(!uy(e,o))return 0;let r=a(e);return t.compare(r,e.values[s])?0:(e.values[s]=r,1)},reconfigure(e,i){let o=uy(e,r),l=i.config.facets[t.id],c=i.facet(t);if(l&&!o&&cy(n,l))return e.values[s]=c,0;let d=a(e);return t.compare(d,c)?(e.values[s]=c,0):(e.values[s]=d,1)}}}const fy=ly.define({static:!0});class gy{constructor(e,t,n,r,i){this.id=e,this.createF=t,this.updateF=n,this.compareF=r,this.spec=i,this.provides=void 0}static define(e){let t=new gy(ay++,e.create,e.update,e.compare||((e,t)=>e===t),e);return e.provide&&(t.provides=e.provide(t)),t}create(e){let t=e.facet(fy).find(e=>e.field==this);return((null==t?void 0:t.create)||this.createF)(e)}slot(e){let t=e[this.id]>>1;return{create:e=>(e.values[t]=this.create(e),1),update:(e,n)=>{let r=e.values[t],i=this.updateF(r,n);return this.compareF(r,i)?0:(e.values[t]=i,1)},reconfigure:(e,n)=>{let r,i=e.facet(fy),o=n.facet(fy);return(r=i.find(e=>e.field==this))&&r!=o.find(e=>e.field==this)?(e.values[t]=r.create(e),1):null!=n.config.address[this.id]?(e.values[t]=n.field(this),0):(e.values[t]=this.create(e),1)}}}init(e){return[this,fy.of({field:this,create:e})]}get extension(){return this}}const my=4,vy=3,Ay=2,by=1;function yy(e){return t=>new wy(t,e)}const xy={highest:yy(0),high:yy(by),default:yy(Ay),low:yy(vy),lowest:yy(my)};class wy{constructor(e,t){this.inner=e,this.prec=t}}class Cy{of(e){return new ky(this,e)}reconfigure(e){return Cy.reconfigure.of({compartment:this,extension:e})}get(e){return e.config.compartments.get(this)}}class ky{constructor(e,t){this.compartment=e,this.inner=t}}class Sy{constructor(e,t,n,r,i,o){for(this.base=e,this.compartments=t,this.dynamicSlots=n,this.address=r,this.staticValues=i,this.facets=o,this.statusTemplate=[];this.statusTemplate.length<n.length;)this.statusTemplate.push(0)}staticFacet(e){let t=this.address[e.id];return null==t?e.default:this.staticValues[t>>1]}static resolve(e,t,n){let r=[],i=Object.create(null),o=new Map;for(let n of function(e,t,n){let r=[[],[],[],[],[]],i=new Map;function o(e,s){let a=i.get(e);if(null!=a){if(a<=s)return;let t=r[a].indexOf(e);t>-1&&r[a].splice(t,1),e instanceof ky&&n.delete(e.compartment)}if(i.set(e,s),Array.isArray(e))for(let t of e)o(t,s);else if(e instanceof ky){if(n.has(e.compartment))throw new RangeError("Duplicate use of compartment in extensions");let r=t.get(e.compartment)||e.inner;n.set(e.compartment,r),o(r,s)}else if(e instanceof wy)o(e.inner,e.prec);else if(e instanceof gy)r[s].push(e),e.provides&&o(e.provides,s);else if(e instanceof dy)r[s].push(e),e.facet.extensions&&o(e.facet.extensions,Ay);else{let t=e.extension;if(!t)throw new Error(`Unrecognized extension value in extension set (${e}). This sometimes happens because multiple instances of @codemirror/state are loaded, breaking instanceof checks.`);o(t,s)}}return o(e,Ay),r.reduce((e,t)=>e.concat(t))}(e,t,o))n instanceof gy?r.push(n):(i[n.facet.id]||(i[n.facet.id]=[])).push(n);let s=Object.create(null),a=[],l=[];for(let e of r)s[e.id]=l.length<<1,l.push(t=>e.slot(t));let c=null==n?void 0:n.config.facets;for(let e in i){let t=i[e],r=t[0].facet,o=c&&c[e]||[];if(t.every(e=>0==e.type))if(s[r.id]=a.length<<1|1,cy(o,t))a.push(n.facet(r));else{let e=r.combine(t.map(e=>e.value));a.push(n&&r.compare(e,n.facet(r))?n.facet(r):e)}else{for(let e of t)0==e.type?(s[e.id]=a.length<<1|1,a.push(e.value)):(s[e.id]=l.length<<1,l.push(t=>e.dynamicSlot(t)));s[r.id]=l.length<<1,l.push(e=>py(e,r,t))}}let d=l.map(e=>e(s));return new Sy(e,o,d,s,a,i)}}function Oy(e,t){if(1&t)return 2;let n=t>>1,r=e.status[n];if(4==r)throw new Error("Cyclic dependency between fields and/or facets");if(2&r)return r;e.status[n]=4;let i=e.computeSlot(e,e.config.dynamicSlots[n]);return e.status[n]=2|i}function By(e,t){return 1&t?e.config.staticValues[t>>1]:e.values[t>>1]}const _y=ly.define(),Ty=ly.define({combine:e=>e.some(e=>e),static:!0}),Ey=ly.define({combine:e=>e.length?e[0]:void 0,static:!0}),My=ly.define(),Dy=ly.define(),Py=ly.define(),Ry=ly.define({combine:e=>!!e.length&&e[0]});class Iy{constructor(e,t){this.type=e,this.value=t}static define(){return new Ny}}class Ny{of(e){return new Iy(this,e)}}class Ly{constructor(e){this.map=e}of(e){return new Qy(this,e)}}class Qy{constructor(e,t){this.type=e,this.value=t}map(e){let t=this.type.map(this.value,e);return void 0===t?void 0:t==this.value?this:new Qy(this.type,t)}is(e){return this.type==e}static define(e={}){return new Ly(e.map||(e=>e))}static mapEffects(e,t){if(!e.length)return e;let n=[];for(let r of e){let e=r.map(t);e&&n.push(e)}return n}}Qy.reconfigure=Qy.define(),Qy.appendConfig=Qy.define();class Fy{constructor(e,t,n,r,i,o){this.startState=e,this.changes=t,this.selection=n,this.effects=r,this.annotations=i,this.scrollIntoView=o,this._doc=null,this._state=null,n&&sy(n,t.newLength),i.some(e=>e.type==Fy.time)||(this.annotations=i.concat(Fy.time.of(Date.now())))}static create(e,t,n,r,i,o){return new Fy(e,t,n,r,i,o)}get newDoc(){return this._doc||(this._doc=this.changes.apply(this.startState.doc))}get newSelection(){return this.selection||this.startState.selection.map(this.changes)}get state(){return this._state||this.startState.applyTransaction(this),this._state}annotation(e){for(let t of this.annotations)if(t.type==e)return t.value}get docChanged(){return!this.changes.empty}get reconfigured(){return this.startState.config!=this.state.config}isUserEvent(e){let t=this.annotation(Fy.userEvent);return!(!t||!(t==e||t.length>e.length&&t.slice(0,e.length)==e&&"."==t[e.length]))}}function Vy(e,t){let n=[];for(let r=0,i=0;;){let o,s;if(r<e.length&&(i==t.length||t[i]>=e[r]))o=e[r++],s=e[r++];else{if(!(i<t.length))return n;o=t[i++],s=t[i++]}!n.length||n[n.length-1]<o?n.push(o,s):n[n.length-1]<s&&(n[n.length-1]=s)}}function zy(e,t,n){var r;let i,o,s;return n?(i=t.changes,o=Jb.empty(t.changes.length),s=e.changes.compose(t.changes)):(i=t.changes.map(e.changes),o=e.changes.mapDesc(t.changes,!0),s=e.changes.compose(i)),{changes:s,selection:t.selection?t.selection.map(o):null===(r=e.selection)||void 0===r?void 0:r.map(i),effects:Qy.mapEffects(e.effects,i).concat(Qy.mapEffects(t.effects,o)),annotations:e.annotations.length?e.annotations.concat(t.annotations):t.annotations,scrollIntoView:e.scrollIntoView||t.scrollIntoView}}function Wy(e,t,n){let r=t.selection,i=jy(t.annotations);return t.userEvent&&(i=i.concat(Fy.userEvent.of(t.userEvent))),{changes:t.changes instanceof Jb?t.changes:Jb.of(t.changes||[],n,e.facet(Ey)),selection:r&&(r instanceof oy?r:oy.single(r.anchor,r.head)),effects:jy(t.effects),annotations:i,scrollIntoView:!!t.scrollIntoView}}function $y(e,t,n){let r=Wy(e,t.length?t[0]:{},e.doc.length);t.length&&!1===t[0].filter&&(n=!1);for(let i=1;i<t.length;i++){!1===t[i].filter&&(n=!1);let o=!!t[i].sequential;r=zy(r,Wy(e,t[i],o?r.changes.newLength:e.doc.length),o)}let i=Fy.create(e,r.changes,r.selection,r.effects,r.annotations,r.scrollIntoView);return function(e){let t=e.startState,n=t.facet(Py),r=e;for(let i=n.length-1;i>=0;i--){let o=n[i](e);o&&Object.keys(o).length&&(r=zy(r,Wy(t,o,e.changes.newLength),!0))}return r==e?e:Fy.create(t,e.changes,e.selection,r.effects,r.annotations,r.scrollIntoView)}(n?function(e){let t=e.startState,n=!0;for(let r of t.facet(My)){let t=r(e);if(!1===t){n=!1;break}Array.isArray(t)&&(n=!0===n?t:Vy(n,t))}if(!0!==n){let r,i;if(!1===n)i=e.changes.invertedDesc,r=Jb.empty(t.doc.length);else{let t=e.changes.filter(n);r=t.changes,i=t.filtered.mapDesc(t.changes).invertedDesc}e=Fy.create(t,r,e.selection&&e.selection.map(i),Qy.mapEffects(e.effects,i),e.annotations,e.scrollIntoView)}let r=t.facet(Dy);for(let n=r.length-1;n>=0;n--){let i=r[n](e);e=i instanceof Fy?i:Array.isArray(i)&&1==i.length&&i[0]instanceof Fy?i[0]:$y(t,jy(i),!1)}return e}(i):i)}Fy.time=Iy.define(),Fy.userEvent=Iy.define(),Fy.addToHistory=Iy.define(),Fy.remote=Iy.define();const Hy=[];function jy(e){return null==e?Hy:Array.isArray(e)?e:[e]}var qy=function(e){return e[e.Word=0]="Word",e[e.Space=1]="Space",e[e.Other=2]="Other",e}(qy||(qy={}));const Uy=/[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;let Gy;try{Gy=new RegExp("[\\p{Alphabetic}\\p{Number}_]","u")}catch(e){}function Yy(e){return t=>{if(!/\S/.test(t))return qy.Space;if(function(e){if(Gy)return Gy.test(e);for(let t=0;t<e.length;t++){let n=e[t];if(/\w/.test(n)||n>""&&(n.toUpperCase()!=n.toLowerCase()||Uy.test(n)))return!0}return!1}(t))return qy.Word;for(let n=0;n<e.length;n++)if(t.indexOf(e[n])>-1)return qy.Word;return qy.Other}}class Xy{constructor(e,t,n,r,i,o){this.config=e,this.doc=t,this.selection=n,this.values=r,this.status=e.statusTemplate.slice(),this.computeSlot=i,o&&(o._state=this);for(let e=0;e<this.config.dynamicSlots.length;e++)Oy(this,e<<1);this.computeSlot=null}field(e,t=!0){let n=this.config.address[e.id];if(null!=n)return Oy(this,n),By(this,n);if(t)throw new RangeError("Field is not present in this state")}update(...e){return $y(this,e,!0)}applyTransaction(e){let t,n=this.config,{base:r,compartments:i}=n;for(let t of e.effects)t.is(Cy.reconfigure)?(n&&(i=new Map,n.compartments.forEach((e,t)=>i.set(t,e)),n=null),i.set(t.value.compartment,t.value.extension)):t.is(Qy.reconfigure)?(n=null,r=t.value):t.is(Qy.appendConfig)&&(n=null,r=jy(r).concat(t.value));if(n)t=e.startState.values.slice();else{n=Sy.resolve(r,i,this),t=new Xy(n,this.doc,this.selection,n.dynamicSlots.map(()=>null),(e,t)=>t.reconfigure(e,this),null).values}let o=e.startState.facet(Ty)?e.newSelection:e.newSelection.asSingle();new Xy(n,e.newDoc,o,t,(t,n)=>n.update(t,e),e)}replaceSelection(e){return"string"==typeof e&&(e=this.toText(e)),this.changeByRange(t=>({changes:{from:t.from,to:t.to,insert:e},range:oy.cursor(t.from+e.length)}))}changeByRange(e){let t=this.selection,n=e(t.ranges[0]),r=this.changes(n.changes),i=[n.range],o=jy(n.effects);for(let n=1;n<t.ranges.length;n++){let s=e(t.ranges[n]),a=this.changes(s.changes),l=a.map(r);for(let e=0;e<n;e++)i[e]=i[e].map(l);let c=r.mapDesc(a,!0);i.push(s.range.map(c)),r=r.compose(l),o=Qy.mapEffects(o,l).concat(Qy.mapEffects(jy(s.effects),c))}return{changes:r,selection:oy.create(i,t.mainIndex),effects:o}}changes(e=[]){return e instanceof Jb?e:Jb.of(e,this.doc.length,this.facet(Xy.lineSeparator))}toText(e){return Rb.of(e.split(this.facet(Xy.lineSeparator)||Gb))}sliceDoc(e=0,t=this.doc.length){return this.doc.sliceString(e,t,this.lineBreak)}facet(e){let t=this.config.address[e.id];return null==t?e.default:(Oy(this,t),By(this,t))}toJSON(e){let t={doc:this.sliceDoc(),selection:this.selection.toJSON()};if(e)for(let n in e){let r=e[n];r instanceof gy&&null!=this.config.address[r.id]&&(t[n]=r.spec.toJSON(this.field(e[n]),this))}return t}static fromJSON(e,t={},n){if(!e||"string"!=typeof e.doc)throw new RangeError("Invalid JSON representation for EditorState");let r=[];if(n)for(let t in n)if(Object.prototype.hasOwnProperty.call(e,t)){let i=n[t],o=e[t];r.push(i.init(e=>i.spec.fromJSON(o,e)))}return Xy.create({doc:e.doc,selection:oy.fromJSON(e.selection),extensions:t.extensions?r.concat([t.extensions]):r})}static create(e={}){let t=Sy.resolve(e.extensions||[],new Map),n=e.doc instanceof Rb?e.doc:Rb.of((e.doc||"").split(t.staticFacet(Xy.lineSeparator)||Gb)),r=e.selection?e.selection instanceof oy?e.selection:oy.single(e.selection.anchor,e.selection.head):oy.single(0);return sy(r,n.length),t.staticFacet(Ty)||(r=r.asSingle()),new Xy(t,n,r,t.dynamicSlots.map(()=>null),(e,t)=>t.create(e),null)}get tabSize(){return this.facet(Xy.tabSize)}get lineBreak(){return this.facet(Xy.lineSeparator)||"\n"}get readOnly(){return this.facet(Ry)}phrase(e,...t){for(let t of this.facet(Xy.phrases))if(Object.prototype.hasOwnProperty.call(t,e)){e=t[e];break}return t.length&&(e=e.replace(/\$(\$|\d*)/g,(e,n)=>{if("$"==n)return"$";let r=+(n||1);return!r||r>t.length?e:t[r-1]})),e}languageDataAt(e,t,n=-1){let r=[];for(let i of this.facet(_y))for(let o of i(this,t,n))Object.prototype.hasOwnProperty.call(o,e)&&r.push(o[e]);return r}charCategorizer(e){let t=this.languageDataAt("wordChars",e);return Yy(t.length?t[0]:"")}wordAt(e){let{text:t,from:n,length:r}=this.doc.lineAt(e),i=this.charCategorizer(e),o=e-n,s=e-n;for(;o>0;){let e=Hb(t,o,!1);if(i(t.slice(e,o))!=qy.Word)break;o=e}for(;s<r;){let e=Hb(t,s);if(i(t.slice(s,e))!=qy.Word)break;s=e}return o==s?null:oy.range(o+n,s+n)}}function Jy(e,t,n={}){let r={};for(let t of e)for(let e of Object.keys(t)){let i=t[e],o=r[e];if(void 0===o)r[e]=i;else if(o===i||void 0===i);else{if(!Object.hasOwnProperty.call(n,e))throw new Error("Config merge conflict for field "+e);r[e]=n[e](o,i)}}for(let e in t)void 0===r[e]&&(r[e]=t[e]);return r}Xy.allowMultipleSelections=Ty,Xy.tabSize=ly.define({combine:e=>e.length?e[0]:4}),Xy.lineSeparator=Ey,Xy.readOnly=Ry,Xy.phrases=ly.define({compare(e,t){let n=Object.keys(e),r=Object.keys(t);return n.length==r.length&&n.every(n=>e[n]==t[n])}}),Xy.languageData=_y,Xy.changeFilter=My,Xy.transactionFilter=Dy,Xy.transactionExtender=Py,Cy.reconfigure=Qy.define();class Ky{eq(e){return this==e}range(e,t=e){return ex.create(e,t,this)}}function Zy(e,t){return e==t||e.constructor==t.constructor&&e.eq(t)}Ky.prototype.startSide=Ky.prototype.endSide=0,Ky.prototype.point=!1,Ky.prototype.mapMode=Yb.TrackDel;class ex{constructor(e,t,n){this.from=e,this.to=t,this.value=n}static create(e,t,n){return new ex(e,t,n)}}function tx(e,t){return e.from-t.from||e.value.startSide-t.value.startSide}class nx{constructor(e,t,n,r){this.from=e,this.to=t,this.value=n,this.maxPoint=r}get length(){return this.to[this.to.length-1]}findIndex(e,t,n,r=0){let i=n?this.to:this.from;for(let o=r,s=i.length;;){if(o==s)return o;let r=o+s>>1,a=i[r]-e||(n?this.value[r].endSide:this.value[r].startSide)-t;if(r==o)return a>=0?o:s;a>=0?s=r:o=r+1}}between(e,t,n,r){for(let i=this.findIndex(t,-1e9,!0),o=this.findIndex(n,1e9,!1,i);i<o;i++)if(!1===r(this.from[i]+e,this.to[i]+e,this.value[i]))return!1}map(e,t){let n=[],r=[],i=[],o=-1,s=-1;for(let a=0;a<this.value.length;a++){let l,c,d=this.value[a],h=this.from[a]+e,u=this.to[a]+e;if(h==u){let e=t.mapPos(h,d.startSide,d.mapMode);if(null==e)continue;if(l=c=e,d.startSide!=d.endSide&&(c=t.mapPos(h,d.endSide),c<l))continue}else if(l=t.mapPos(h,d.startSide),c=t.mapPos(u,d.endSide),l>c||l==c&&d.startSide>0&&d.endSide<=0)continue;(c-l||d.endSide-d.startSide)<0||(o<0&&(o=l),d.point&&(s=Math.max(s,c-l)),n.push(d),r.push(l-o),i.push(c-o))}return{mapped:n.length?new nx(r,i,n,s):null,pos:o}}}class rx{constructor(e,t,n,r){this.chunkPos=e,this.chunk=t,this.nextLayer=n,this.maxPoint=r}static create(e,t,n,r){return new rx(e,t,n,r)}get length(){let e=this.chunk.length-1;return e<0?0:Math.max(this.chunkEnd(e),this.nextLayer.length)}get size(){if(this.isEmpty)return 0;let e=this.nextLayer.size;for(let t of this.chunk)e+=t.value.length;return e}chunkEnd(e){return this.chunkPos[e]+this.chunk[e].length}update(e){let{add:t=[],sort:n=!1,filterFrom:r=0,filterTo:i=this.length}=e,o=e.filter;if(0==t.length&&!o)return this;if(n&&(t=t.slice().sort(tx)),this.isEmpty)return t.length?rx.of(t):this;let s=new sx(this,null,-1).goto(0),a=0,l=[],c=new ix;for(;s.value||a<t.length;)if(a<t.length&&(s.from-t[a].from||s.startSide-t[a].value.startSide)>=0){let e=t[a++];c.addInner(e.from,e.to,e.value)||l.push(e)}else 1==s.rangeIndex&&s.chunkIndex<this.chunk.length&&(a==t.length||this.chunkEnd(s.chunkIndex)<t[a].from)&&(!o||r>this.chunkEnd(s.chunkIndex)||i<this.chunkPos[s.chunkIndex])&&c.addChunk(this.chunkPos[s.chunkIndex],this.chunk[s.chunkIndex])?s.nextChunk():((!o||r>s.to||i<s.from||o(s.from,s.to,s.value))&&(c.addInner(s.from,s.to,s.value)||l.push(ex.create(s.from,s.to,s.value))),s.next());return c.finishInner(this.nextLayer.isEmpty&&!l.length?rx.empty:this.nextLayer.update({add:l,filter:o,filterFrom:r,filterTo:i}))}map(e){if(e.empty||this.isEmpty)return this;let t=[],n=[],r=-1;for(let i=0;i<this.chunk.length;i++){let o=this.chunkPos[i],s=this.chunk[i],a=e.touchesRange(o,o+s.length);if(!1===a)r=Math.max(r,s.maxPoint),t.push(s),n.push(e.mapPos(o));else if(!0===a){let{mapped:i,pos:a}=s.map(o,e);i&&(r=Math.max(r,i.maxPoint),t.push(i),n.push(a))}}let i=this.nextLayer.map(e);return 0==t.length?i:new rx(n,t,i||rx.empty,r)}between(e,t,n){if(!this.isEmpty){for(let r=0;r<this.chunk.length;r++){let i=this.chunkPos[r],o=this.chunk[r];if(t>=i&&e<=i+o.length&&!1===o.between(i,e-i,t-i,n))return}this.nextLayer.between(e,t,n)}}iter(e=0){return ax.from([this]).goto(e)}get isEmpty(){return this.nextLayer==this}static iter(e,t=0){return ax.from(e).goto(t)}static compare(e,t,n,r,i=-1){let o=e.filter(e=>e.maxPoint>0||!e.isEmpty&&e.maxPoint>=i),s=t.filter(e=>e.maxPoint>0||!e.isEmpty&&e.maxPoint>=i),a=ox(o,s,n),l=new cx(o,a,i),c=new cx(s,a,i);n.iterGaps((e,t,n)=>dx(l,e,c,t,n,r)),n.empty&&0==n.length&&dx(l,0,c,0,0,r)}static eq(e,t,n=0,r){null==r&&(r=999999999);let i=e.filter(e=>!e.isEmpty&&t.indexOf(e)<0),o=t.filter(t=>!t.isEmpty&&e.indexOf(t)<0);if(i.length!=o.length)return!1;if(!i.length)return!0;let s=ox(i,o),a=new cx(i,s,0).goto(n),l=new cx(o,s,0).goto(n);for(;;){if(a.to!=l.to||!hx(a.active,l.active)||a.point&&(!l.point||!Zy(a.point,l.point)))return!1;if(a.to>r)return!0;a.next(),l.next()}}static spans(e,t,n,r,i=-1){let o=new cx(e,null,i).goto(t),s=t,a=o.openStart;for(;;){let e=Math.min(o.to,n);if(o.point){let n=o.activeForPoint(o.to),i=o.pointFrom<t?n.length+1:o.point.startSide<0?n.length:Math.min(n.length,a);r.point(s,e,o.point,n,i,o.pointRank),a=Math.min(o.openEnd(e),n.length)}else e>s&&(r.span(s,e,o.active,a),a=o.openEnd(e));if(o.to>n)return a+(o.point&&o.to>n?1:0);s=o.to,o.next()}}static of(e,t=!1){let n=new ix;for(let r of e instanceof ex?[e]:t?function(e){if(e.length>1)for(let t=e[0],n=1;n<e.length;n++){let r=e[n];if(tx(t,r)>0)return e.slice().sort(tx);t=r}return e}(e):e)n.add(r.from,r.to,r.value);return n.finish()}static join(e){if(!e.length)return rx.empty;let t=e[e.length-1];for(let n=e.length-2;n>=0;n--)for(let r=e[n];r!=rx.empty;r=r.nextLayer)t=new rx(r.chunkPos,r.chunk,t,Math.max(r.maxPoint,t.maxPoint));return t}}rx.empty=new rx([],[],null,-1),rx.empty.nextLayer=rx.empty;class ix{finishChunk(e){this.chunks.push(new nx(this.from,this.to,this.value,this.maxPoint)),this.chunkPos.push(this.chunkStart),this.chunkStart=-1,this.setMaxPoint=Math.max(this.setMaxPoint,this.maxPoint),this.maxPoint=-1,e&&(this.from=[],this.to=[],this.value=[])}constructor(){this.chunks=[],this.chunkPos=[],this.chunkStart=-1,this.last=null,this.lastFrom=-1e9,this.lastTo=-1e9,this.from=[],this.to=[],this.value=[],this.maxPoint=-1,this.setMaxPoint=-1,this.nextLayer=null}add(e,t,n){this.addInner(e,t,n)||(this.nextLayer||(this.nextLayer=new ix)).add(e,t,n)}addInner(e,t,n){let r=e-this.lastTo||n.startSide-this.last.endSide;if(r<=0&&(e-this.lastFrom||n.startSide-this.last.startSide)<0)throw new Error("Ranges must be added sorted by `from` position and `startSide`");return!(r<0)&&(250==this.from.length&&this.finishChunk(!0),this.chunkStart<0&&(this.chunkStart=e),this.from.push(e-this.chunkStart),this.to.push(t-this.chunkStart),this.last=n,this.lastFrom=e,this.lastTo=t,this.value.push(n),n.point&&(this.maxPoint=Math.max(this.maxPoint,t-e)),!0)}addChunk(e,t){if((e-this.lastTo||t.value[0].startSide-this.last.endSide)<0)return!1;this.from.length&&this.finishChunk(!0),this.setMaxPoint=Math.max(this.setMaxPoint,t.maxPoint),this.chunks.push(t),this.chunkPos.push(e);let n=t.value.length-1;return this.last=t.value[n],this.lastFrom=t.from[n]+e,this.lastTo=t.to[n]+e,!0}finish(){return this.finishInner(rx.empty)}finishInner(e){if(this.from.length&&this.finishChunk(!1),0==this.chunks.length)return e;let t=rx.create(this.chunkPos,this.chunks,this.nextLayer?this.nextLayer.finishInner(e):e,this.setMaxPoint);return this.from=null,t}}function ox(e,t,n){let r=new Map;for(let t of e)for(let e=0;e<t.chunk.length;e++)t.chunk[e].maxPoint<=0&&r.set(t.chunk[e],t.chunkPos[e]);let i=new Set;for(let e of t)for(let t=0;t<e.chunk.length;t++){let o=r.get(e.chunk[t]);null==o||(n?n.mapPos(o):o)!=e.chunkPos[t]||(null==n?void 0:n.touchesRange(o,o+e.chunk[t].length))||i.add(e.chunk[t])}return i}class sx{constructor(e,t,n,r=0){this.layer=e,this.skip=t,this.minPoint=n,this.rank=r}get startSide(){return this.value?this.value.startSide:0}get endSide(){return this.value?this.value.endSide:0}goto(e,t=-1e9){return this.chunkIndex=this.rangeIndex=0,this.gotoInner(e,t,!1),this}gotoInner(e,t,n){for(;this.chunkIndex<this.layer.chunk.length;){let t=this.layer.chunk[this.chunkIndex];if(!(this.skip&&this.skip.has(t)||this.layer.chunkEnd(this.chunkIndex)<e||t.maxPoint<this.minPoint))break;this.chunkIndex++,n=!1}if(this.chunkIndex<this.layer.chunk.length){let r=this.layer.chunk[this.chunkIndex].findIndex(e-this.layer.chunkPos[this.chunkIndex],t,!0);(!n||this.rangeIndex<r)&&this.setRangeIndex(r)}this.next()}forward(e,t){(this.to-e||this.endSide-t)<0&&this.gotoInner(e,t,!0)}next(){for(;;){if(this.chunkIndex==this.layer.chunk.length){this.from=this.to=1e9,this.value=null;break}{let e=this.layer.chunkPos[this.chunkIndex],t=this.layer.chunk[this.chunkIndex],n=e+t.from[this.rangeIndex];if(this.from=n,this.to=e+t.to[this.rangeIndex],this.value=t.value[this.rangeIndex],this.setRangeIndex(this.rangeIndex+1),this.minPoint<0||this.value.point&&this.to-this.from>=this.minPoint)break}}}setRangeIndex(e){if(e==this.layer.chunk[this.chunkIndex].value.length){if(this.chunkIndex++,this.skip)for(;this.chunkIndex<this.layer.chunk.length&&this.skip.has(this.layer.chunk[this.chunkIndex]);)this.chunkIndex++;this.rangeIndex=0}else this.rangeIndex=e}nextChunk(){this.chunkIndex++,this.rangeIndex=0,this.next()}compare(e){return this.from-e.from||this.startSide-e.startSide||this.rank-e.rank||this.to-e.to||this.endSide-e.endSide}}class ax{constructor(e){this.heap=e}static from(e,t=null,n=-1){let r=[];for(let i=0;i<e.length;i++)for(let o=e[i];!o.isEmpty;o=o.nextLayer)o.maxPoint>=n&&r.push(new sx(o,t,n,i));return 1==r.length?r[0]:new ax(r)}get startSide(){return this.value?this.value.startSide:0}goto(e,t=-1e9){for(let n of this.heap)n.goto(e,t);for(let e=this.heap.length>>1;e>=0;e--)lx(this.heap,e);return this.next(),this}forward(e,t){for(let n of this.heap)n.forward(e,t);for(let e=this.heap.length>>1;e>=0;e--)lx(this.heap,e);(this.to-e||this.value.endSide-t)<0&&this.next()}next(){if(0==this.heap.length)this.from=this.to=1e9,this.value=null,this.rank=-1;else{let e=this.heap[0];this.from=e.from,this.to=e.to,this.value=e.value,this.rank=e.rank,e.value&&e.next(),lx(this.heap,0)}}}function lx(e,t){for(let n=e[t];;){let r=1+(t<<1);if(r>=e.length)break;let i=e[r];if(r+1<e.length&&i.compare(e[r+1])>=0&&(i=e[r+1],r++),n.compare(i)<0)break;e[r]=n,e[t]=i,t=r}}class cx{constructor(e,t,n){this.minPoint=n,this.active=[],this.activeTo=[],this.activeRank=[],this.minActive=-1,this.point=null,this.pointFrom=0,this.pointRank=0,this.to=-1e9,this.endSide=0,this.openStart=-1,this.cursor=ax.from(e,t,n)}goto(e,t=-1e9){return this.cursor.goto(e,t),this.active.length=this.activeTo.length=this.activeRank.length=0,this.minActive=-1,this.to=e,this.endSide=t,this.openStart=-1,this.next(),this}forward(e,t){for(;this.minActive>-1&&(this.activeTo[this.minActive]-e||this.active[this.minActive].endSide-t)<0;)this.removeActive(this.minActive);this.cursor.forward(e,t)}removeActive(e){ux(this.active,e),ux(this.activeTo,e),ux(this.activeRank,e),this.minActive=fx(this.active,this.activeTo)}addActive(e){let t=0,{value:n,to:r,rank:i}=this.cursor;for(;t<this.activeRank.length&&(i-this.activeRank[t]||r-this.activeTo[t])>0;)t++;px(this.active,t,n),px(this.activeTo,t,r),px(this.activeRank,t,i),e&&px(e,t,this.cursor.from),this.minActive=fx(this.active,this.activeTo)}next(){let e=this.to,t=this.point;this.point=null;let n=this.openStart<0?[]:null;for(;;){let r=this.minActive;if(r>-1&&(this.activeTo[r]-this.cursor.from||this.active[r].endSide-this.cursor.startSide)<0){if(this.activeTo[r]>e){this.to=this.activeTo[r],this.endSide=this.active[r].endSide;break}this.removeActive(r),n&&ux(n,r)}else{if(!this.cursor.value){this.to=this.endSide=1e9;break}if(this.cursor.from>e){this.to=this.cursor.from,this.endSide=this.cursor.startSide;break}{let e=this.cursor.value;if(e.point){if(!(t&&this.cursor.to==this.to&&this.cursor.from<this.cursor.to)){this.point=e,this.pointFrom=this.cursor.from,this.pointRank=this.cursor.rank,this.to=this.cursor.to,this.endSide=e.endSide,this.cursor.next(),this.forward(this.to,this.endSide);break}this.cursor.next()}else this.addActive(n),this.cursor.next()}}}if(n){this.openStart=0;for(let t=n.length-1;t>=0&&n[t]<e;t--)this.openStart++}}activeForPoint(e){if(!this.active.length)return this.active;let t=[];for(let n=this.active.length-1;n>=0&&!(this.activeRank[n]<this.pointRank);n--)(this.activeTo[n]>e||this.activeTo[n]==e&&this.active[n].endSide>=this.point.endSide)&&t.push(this.active[n]);return t.reverse()}openEnd(e){let t=0;for(let n=this.activeTo.length-1;n>=0&&this.activeTo[n]>e;n--)t++;return t}}function dx(e,t,n,r,i,o){e.goto(t),n.goto(r);let s=r+i,a=r,l=r-t,c=!!o.boundChange;for(let t=!1;;){let r=e.to+l-n.to,i=r||e.endSide-n.endSide,d=i<0?e.to+l:n.to,h=Math.min(d,s);if(e.point||n.point?(e.point&&n.point&&Zy(e.point,n.point)&&hx(e.activeForPoint(e.to),n.activeForPoint(n.to))||o.comparePoint(a,h,e.point,n.point),t=!1):(t&&o.boundChange(a),h>a&&!hx(e.active,n.active)&&o.compareRange(a,h,e.active,n.active),c&&h<s&&(r||e.openEnd(d)!=n.openEnd(d))&&(t=!0)),d>s)break;a=d,i<=0&&e.next(),i>=0&&n.next()}}function hx(e,t){if(e.length!=t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!=t[n]&&!Zy(e[n],t[n]))return!1;return!0}function ux(e,t){for(let n=t,r=e.length-1;n<r;n++)e[n]=e[n+1];e.pop()}function px(e,t,n){for(let n=e.length-1;n>=t;n--)e[n+1]=e[n];e[t]=n}function fx(e,t){let n=-1,r=1e9;for(let i=0;i<t.length;i++)(t[i]-r||e[i].endSide-e[n].endSide)<0&&(n=i,r=t[i]);return n}function gx(e,t,n=e.length){let r=0;for(let i=0;i<n&&i<e.length;)9==e.charCodeAt(i)?(r+=t-r%t,i++):(r++,i=Hb(e,i));return r}function mx(e,t,n,r){for(let r=0,i=0;;){if(i>=t)return r;if(r==e.length)break;i+=9==e.charCodeAt(r)?n-i%n:1,r=Hb(e,r)}return!0===r?-1:e.length}const vx="undefined"==typeof Symbol?"__ͼ":Symbol.for("ͼ"),Ax="undefined"==typeof Symbol?"__styleSet"+Math.floor(1e8*Math.random()):Symbol("styleSet"),bx="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:{};class yx{constructor(e,t){this.rules=[];let{finish:n}=t||{};function r(e){return/^@/.test(e)?[e]:e.split(/,\s*/)}function i(e,t,o,s){let a=[],l=/^@(\w+)\b/.exec(e[0]),c=l&&"keyframes"==l[1];if(l&&null==t)return o.push(e[0]+";");for(let n in t){let s=t[n];if(/&/.test(n))i(n.split(/,\s*/).map(t=>e.map(e=>t.replace(/&/,e))).reduce((e,t)=>e.concat(t)),s,o);else if(s&&"object"==typeof s){if(!l)throw new RangeError("The value of a property ("+n+") should be a primitive value.");i(r(n),s,a,c)}else null!=s&&a.push(n.replace(/_.*/,"").replace(/[A-Z]/g,e=>"-"+e.toLowerCase())+": "+s+";")}(a.length||c)&&o.push((!n||l||s?e:e.map(n)).join(", ")+" {"+a.join(" ")+"}")}for(let t in e)i(r(t),e[t],this.rules)}getRules(){return this.rules.join("\n")}static newName(){let e=bx[vx]||1;return bx[vx]=e+1,"ͼ"+e.toString(36)}static mount(e,t,n){let r=e[Ax],i=n&&n.nonce;r?i&&r.setNonce(i):r=new wx(e,i),r.mount(Array.isArray(t)?t:[t],e)}}let xx=new Map;class wx{constructor(e,t){let n=e.ownerDocument||e,r=n.defaultView;if(!e.head&&e.adoptedStyleSheets&&r.CSSStyleSheet){let t=xx.get(n);if(t)return e[Ax]=t;this.sheet=new r.CSSStyleSheet,xx.set(n,this)}else this.styleTag=n.createElement("style"),t&&this.styleTag.setAttribute("nonce",t);this.modules=[],e[Ax]=this}mount(e,t){let n=this.sheet,r=0,i=0;for(let t=0;t<e.length;t++){let o=e[t],s=this.modules.indexOf(o);if(s<i&&s>-1&&(this.modules.splice(s,1),i--,s=-1),-1==s){if(this.modules.splice(i++,0,o),n)for(let e=0;e<o.rules.length;e++)n.insertRule(o.rules[e],r++)}else{for(;i<s;)r+=this.modules[i++].rules.length;r+=o.rules.length,i++}}if(n)t.adoptedStyleSheets.indexOf(this.sheet)<0&&(t.adoptedStyleSheets=[this.sheet,...t.adoptedStyleSheets]);else{let e="";for(let t=0;t<this.modules.length;t++)e+=this.modules[t].getRules()+"\n";this.styleTag.textContent=e;let n=t.head||t;this.styleTag.parentNode!=n&&n.insertBefore(this.styleTag,n.firstChild)}}setNonce(e){this.styleTag&&this.styleTag.getAttribute("nonce")!=e&&this.styleTag.setAttribute("nonce",e)}}for(var Cx={8:"Backspace",9:"Tab",10:"Enter",12:"NumLock",13:"Enter",16:"Shift",17:"Control",18:"Alt",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",44:"PrintScreen",45:"Insert",46:"Delete",59:";",61:"=",91:"Meta",92:"Meta",106:"*",107:"+",108:",",109:"-",110:".",111:"/",144:"NumLock",145:"ScrollLock",160:"Shift",161:"Shift",162:"Control",163:"Control",164:"Alt",165:"Alt",173:"-",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'"},kx={48:")",49:"!",50:"@",51:"#",52:"$",53:"%",54:"^",55:"&",56:"*",57:"(",59:":",61:"+",173:"_",186:":",187:"+",188:"<",189:"_",190:">",191:"?",192:"~",219:"{",220:"|",221:"}",222:'"'},Sx="undefined"!=typeof navigator&&/Mac/.test(navigator.platform),Ox="undefined"!=typeof navigator&&/MSIE \d|Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(navigator.userAgent),Bx=0;Bx<10;Bx++)Cx[48+Bx]=Cx[96+Bx]=String(Bx);for(Bx=1;Bx<=24;Bx++)Cx[Bx+111]="F"+Bx;for(Bx=65;Bx<=90;Bx++)Cx[Bx]=String.fromCharCode(Bx+32),kx[Bx]=String.fromCharCode(Bx);for(var _x in Cx)kx.hasOwnProperty(_x)||(kx[_x]=Cx[_x]);function Tx(){var e=arguments[0];"string"==typeof e&&(e=document.createElement(e));var t=1,n=arguments[1];if(n&&"object"==typeof n&&null==n.nodeType&&!Array.isArray(n)){for(var r in n)if(Object.prototype.hasOwnProperty.call(n,r)){var i=n[r];"string"==typeof i?e.setAttribute(r,i):null!=i&&(e[r]=i)}t++}for(;t<arguments.length;t++)Ex(e,arguments[t]);return e}function Ex(e,t){if("string"==typeof t)e.appendChild(document.createTextNode(t));else if(null==t);else if(null!=t.nodeType)e.appendChild(t);else{if(!Array.isArray(t))throw new RangeError("Unsupported child node: "+t);for(var n=0;n<t.length;n++)Ex(e,t[n])}}let Mx="undefined"!=typeof navigator?navigator:{userAgent:"",vendor:"",platform:""},Dx="undefined"!=typeof document?document:{documentElement:{style:{}}};const Px=/Edge\/(\d+)/.exec(Mx.userAgent),Rx=/MSIE \d/.test(Mx.userAgent),Ix=/Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(Mx.userAgent),Nx=!!(Rx||Ix||Px),Lx=!Nx&&/gecko\/(\d+)/i.test(Mx.userAgent),Qx=!Nx&&/Chrome\/(\d+)/.exec(Mx.userAgent),Fx="webkitFontSmoothing"in Dx.documentElement.style,Vx=!Nx&&/Apple Computer/.test(Mx.vendor),zx=Vx&&(/Mobile\/\w+/.test(Mx.userAgent)||Mx.maxTouchPoints>2);var Wx={mac:zx||/Mac/.test(Mx.platform),windows:/Win/.test(Mx.platform),linux:/Linux|X11/.test(Mx.platform),ie:Nx,ie_version:Rx?Dx.documentMode||6:Ix?+Ix[1]:Px?+Px[1]:0,gecko:Lx,gecko_version:Lx?+(/Firefox\/(\d+)/.exec(Mx.userAgent)||[0,0])[1]:0,chrome:!!Qx,chrome_version:Qx?+Qx[1]:0,ios:zx,android:/Android\b/.test(Mx.userAgent),webkit:Fx,webkit_version:Fx?+(/\bAppleWebKit\/(\d+)/.exec(Mx.userAgent)||[0,0])[1]:0,safari:Vx,safari_version:Vx?+(/\bVersion\/(\d+(\.\d+)?)/.exec(Mx.userAgent)||[0,0])[1]:0,tabSize:null!=Dx.documentElement.style.tabSize?"tab-size":"-moz-tab-size"};function $x(e,t){for(let n in e)"class"==n&&t.class?t.class+=" "+e.class:"style"==n&&t.style?t.style+=";"+e.style:t[n]=e[n];return t}const Hx=Object.create(null);function jx(e,t,n){if(e==t)return!0;e||(e=Hx),t||(t=Hx);let r=Object.keys(e),i=Object.keys(t);if(r.length-(n&&r.indexOf(n)>-1?1:0)!=i.length-(n&&i.indexOf(n)>-1?1:0))return!1;for(let o of r)if(o!=n&&(-1==i.indexOf(o)||e[o]!==t[o]))return!1;return!0}function qx(e,t,n){let r=!1;if(t)for(let i in t)n&&i in n||(r=!0,"style"==i?e.style.cssText="":e.removeAttribute(i));if(n)for(let i in n)t&&t[i]==n[i]||(r=!0,"style"==i?e.style.cssText=n[i]:e.setAttribute(i,n[i]));return r}function Ux(e){let t=Object.create(null);for(let n=0;n<e.attributes.length;n++){let r=e.attributes[n];t[r.name]=r.value}return t}class Gx{eq(e){return!1}updateDOM(e,t){return!1}compare(e){return this==e||this.constructor==e.constructor&&this.eq(e)}get estimatedHeight(){return-1}get lineBreaks(){return 0}ignoreEvent(e){return!0}coordsAt(e,t,n){return null}get isHidden(){return!1}get editable(){return!1}destroy(e){}}var Yx=function(e){return e[e.Text=0]="Text",e[e.WidgetBefore=1]="WidgetBefore",e[e.WidgetAfter=2]="WidgetAfter",e[e.WidgetRange=3]="WidgetRange",e}(Yx||(Yx={}));class Xx extends Ky{constructor(e,t,n,r){super(),this.startSide=e,this.endSide=t,this.widget=n,this.spec=r}get heightRelevant(){return!1}static mark(e){return new Jx(e)}static widget(e){let t=Math.max(-1e4,Math.min(1e4,e.side||0)),n=!!e.block;return t+=n&&!e.inlineOrder?t>0?3e8:-4e8:t>0?1e8:-1e8,new Zx(e,t,t,n,e.widget||null,!1)}static replace(e){let t,n,r=!!e.block;if(e.isBlockGap)t=-5e8,n=4e8;else{let{start:i,end:o}=ew(e,r);t=(i?r?-3e8:-1:5e8)-1,n=1+(o?r?2e8:1:-6e8)}return new Zx(e,t,n,r,e.widget||null,!0)}static line(e){return new Kx(e)}static set(e,t=!1){return rx.of(e,t)}hasHeight(){return!!this.widget&&this.widget.estimatedHeight>-1}}Xx.none=rx.empty;class Jx extends Xx{constructor(e){let{start:t,end:n}=ew(e);super(t?-1:5e8,n?1:-6e8,null,e),this.tagName=e.tagName||"span",this.attrs=e.class&&e.attributes?$x(e.attributes,{class:e.class}):e.class?{class:e.class}:e.attributes||Hx}eq(e){return this==e||e instanceof Jx&&this.tagName==e.tagName&&jx(this.attrs,e.attrs)}range(e,t=e){if(e>=t)throw new RangeError("Mark decorations may not be empty");return super.range(e,t)}}Jx.prototype.point=!1;class Kx extends Xx{constructor(e){super(-2e8,-2e8,null,e)}eq(e){return e instanceof Kx&&this.spec.class==e.spec.class&&jx(this.spec.attributes,e.spec.attributes)}range(e,t=e){if(t!=e)throw new RangeError("Line decoration ranges must be zero-length");return super.range(e,t)}}Kx.prototype.mapMode=Yb.TrackBefore,Kx.prototype.point=!0;class Zx extends Xx{constructor(e,t,n,r,i,o){super(t,n,i,e),this.block=r,this.isReplace=o,this.mapMode=r?t<=0?Yb.TrackBefore:Yb.TrackAfter:Yb.TrackDel}get type(){return this.startSide!=this.endSide?Yx.WidgetRange:this.startSide<=0?Yx.WidgetBefore:Yx.WidgetAfter}get heightRelevant(){return this.block||!!this.widget&&(this.widget.estimatedHeight>=5||this.widget.lineBreaks>0)}eq(e){return e instanceof Zx&&(t=this.widget,n=e.widget,t==n||!!(t&&n&&t.compare(n)))&&this.block==e.block&&this.startSide==e.startSide&&this.endSide==e.endSide;var t,n}range(e,t=e){if(this.isReplace&&(e>t||e==t&&this.startSide>0&&this.endSide<=0))throw new RangeError("Invalid range for replacement decoration");if(!this.isReplace&&t!=e)throw new RangeError("Widget decorations can only have zero-length ranges");return super.range(e,t)}}function ew(e,t=!1){let{inclusiveStart:n,inclusiveEnd:r}=e;return null==n&&(n=e.inclusive),null==r&&(r=e.inclusive),{start:null!=n?n:t,end:null!=r?r:t}}function tw(e,t,n,r=0){let i=n.length-1;i>=0&&n[i]+r>=e?n[i]=Math.max(n[i],t):n.push(e,t)}Zx.prototype.point=!0;class nw extends Ky{constructor(e,t){super(),this.tagName=e,this.attributes=t}eq(e){return e==this||e instanceof nw&&this.tagName==e.tagName&&jx(this.attributes,e.attributes)}static create(e){return new nw(e.tagName,e.attributes||Hx)}static set(e,t=!1){return rx.of(e,t)}}function rw(e){let t;return t=11==e.nodeType?e.getSelection?e:e.ownerDocument:e,t.getSelection()}function iw(e,t){return!!t&&(e==t||e.contains(1!=t.nodeType?t.parentNode:t))}function ow(e,t){if(!t.anchorNode)return!1;try{return iw(e,t.anchorNode)}catch(e){return!1}}function sw(e){return 3==e.nodeType?bw(e,0,e.nodeValue.length).getClientRects():1==e.nodeType?e.getClientRects():[]}function aw(e,t,n,r){return!!n&&(dw(e,t,n,r,-1)||dw(e,t,n,r,1))}function lw(e){for(var t=0;;t++)if(!(e=e.previousSibling))return t}function cw(e){return 1==e.nodeType&&/^(DIV|P|LI|UL|OL|BLOCKQUOTE|DD|DT|H\d|SECTION|PRE)$/.test(e.nodeName)}function dw(e,t,n,r,i){for(;;){if(e==n&&t==r)return!0;if(t==(i<0?0:hw(e))){if("DIV"==e.nodeName)return!1;let n=e.parentNode;if(!n||1!=n.nodeType)return!1;t=lw(e)+(i<0?0:1),e=n}else{if(1!=e.nodeType)return!1;if(1==(e=e.childNodes[t+(i<0?-1:0)]).nodeType&&"false"==e.contentEditable)return!1;t=i<0?hw(e):0}}}function hw(e){return 3==e.nodeType?e.nodeValue.length:e.childNodes.length}function uw(e,t){let n=t?e.left:e.right;return{left:n,right:n,top:e.top,bottom:e.bottom}}function pw(e){let t=e.visualViewport;return t?{left:0,right:t.width,top:0,bottom:t.height}:{left:0,right:e.innerWidth,top:0,bottom:e.innerHeight}}function fw(e,t){let n=t.width/e.offsetWidth,r=t.height/e.offsetHeight;return(n>.995&&n<1.005||!isFinite(n)||Math.abs(t.width-e.offsetWidth)<1)&&(n=1),(r>.995&&r<1.005||!isFinite(r)||Math.abs(t.height-e.offsetHeight)<1)&&(r=1),{scaleX:n,scaleY:r}}nw.prototype.startSide=nw.prototype.endSide=-1;class gw{constructor(){this.anchorNode=null,this.anchorOffset=0,this.focusNode=null,this.focusOffset=0}eq(e){return this.anchorNode==e.anchorNode&&this.anchorOffset==e.anchorOffset&&this.focusNode==e.focusNode&&this.focusOffset==e.focusOffset}setRange(e){let{anchorNode:t,focusNode:n}=e;this.set(t,Math.min(e.anchorOffset,t?hw(t):0),n,Math.min(e.focusOffset,n?hw(n):0))}set(e,t,n,r){this.anchorNode=e,this.anchorOffset=t,this.focusNode=n,this.focusOffset=r}}let mw,vw=null;function Aw(e){if(e.setActive)return e.setActive();if(vw)return e.focus(vw);let t=[];for(let n=e;n&&(t.push(n,n.scrollTop,n.scrollLeft),n!=n.ownerDocument);n=n.parentNode);if(e.focus(null==vw?{get preventScroll(){return vw={preventScroll:!0},!0}}:void 0),!vw){vw=!1;for(let e=0;e<t.length;){let n=t[e++],r=t[e++],i=t[e++];n.scrollTop!=r&&(n.scrollTop=r),n.scrollLeft!=i&&(n.scrollLeft=i)}}}function bw(e,t,n=t){let r=mw||(mw=document.createRange());return r.setEnd(e,n),r.setStart(e,t),r}function yw(e,t,n,r){let i={key:t,code:t,keyCode:n,which:n,cancelable:!0};r&&({altKey:i.altKey,ctrlKey:i.ctrlKey,shiftKey:i.shiftKey,metaKey:i.metaKey}=r);let o=new KeyboardEvent("keydown",i);o.synthetic=!0,e.dispatchEvent(o);let s=new KeyboardEvent("keyup",i);return s.synthetic=!0,e.dispatchEvent(s),o.defaultPrevented||s.defaultPrevented}function xw(e){return e.scrollTop>Math.max(1,e.scrollHeight-e.clientHeight-4)}function ww(e,t){for(let n=e,r=t;;){if(3==n.nodeType&&r>0)return{node:n,offset:r};if(1==n.nodeType&&r>0){if("false"==n.contentEditable)return null;n=n.childNodes[r-1],r=hw(n)}else{if(!n.parentNode||cw(n))return null;r=lw(n),n=n.parentNode}}}function Cw(e,t){for(let n=e,r=t;;){if(3==n.nodeType&&r<n.nodeValue.length)return{node:n,offset:r};if(1==n.nodeType&&r<n.childNodes.length){if("false"==n.contentEditable)return null;n=n.childNodes[r],r=0}else{if(!n.parentNode||cw(n))return null;r=lw(n)+1,n=n.parentNode}}}Wx.safari&&Wx.safari_version>=26&&(vw=!1);class kw{constructor(e,t,n=!0){this.node=e,this.offset=t,this.precise=n}static before(e,t){return new kw(e.parentNode,lw(e),t)}static after(e,t){return new kw(e.parentNode,lw(e)+1,t)}}var Sw=function(e){return e[e.LTR=0]="LTR",e[e.RTL=1]="RTL",e}(Sw||(Sw={}));const Ow=Sw.LTR,Bw=Sw.RTL;function _w(e){let t=[];for(let n=0;n<e.length;n++)t.push(1<<+e[n]);return t}const Tw=_w("88888888888888888888888888888888888666888888787833333333337888888000000000000000000000000008888880000000000000000000000000088888888888888888888888888888888888887866668888088888663380888308888800000000000000000000000800000000000000000000000000000008"),Ew=_w("4444448826627288999999999992222222222222222222222222222222222222222222222229999999999999999999994444444444644222822222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222999999949999999229989999223333333333"),Mw=Object.create(null),Dw=[];for(let e of["()","[]","{}"]){let t=e.charCodeAt(0),n=e.charCodeAt(1);Mw[t]=n,Mw[n]=-t}function Pw(e){return e<=247?Tw[e]:1424<=e&&e<=1524?2:1536<=e&&e<=1785?Ew[e-1536]:1774<=e&&e<=2220?4:8192<=e&&e<=8204?256:64336<=e&&e<=65023?4:1}const Rw=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\ufb50-\ufdff]/;class Iw{get dir(){return this.level%2?Bw:Ow}constructor(e,t,n){this.from=e,this.to=t,this.level=n}side(e,t){return this.dir==t==e?this.to:this.from}forward(e,t){return e==(this.dir==t)}static find(e,t,n,r){let i=-1;for(let o=0;o<e.length;o++){let s=e[o];if(s.from<=t&&s.to>=t){if(s.level==n)return o;(i<0||(0!=r?r<0?s.from<t:s.to>t:e[i].level>s.level))&&(i=o)}}if(i<0)throw new RangeError("Index out of range");return i}}function Nw(e,t){if(e.length!=t.length)return!1;for(let n=0;n<e.length;n++){let r=e[n],i=t[n];if(r.from!=i.from||r.to!=i.to||r.direction!=i.direction||!Nw(r.inner,i.inner))return!1}return!0}const Lw=[];function Qw(e,t,n,r,i,o,s){let a=r%2?2:1;if(r%2==i%2)for(let l=t,c=0;l<n;){let t=!0,d=!1;if(c==o.length||l<o[c].from){let e=Lw[l];e!=a&&(t=!1,d=16==e)}let h=t||1!=a?null:[],u=t?r:r+1,p=l;e:for(;;)if(c<o.length&&p==o[c].from){if(d)break e;let f=o[c];if(!t)for(let e=f.to,t=c+1;;){if(e==n)break e;if(!(t<o.length&&o[t].from==e)){if(Lw[e]==a)break e;break}e=o[t++].to}if(c++,h)h.push(f);else{f.from>l&&s.push(new Iw(l,f.from,u)),Fw(e,f.direction==Ow!=!(u%2)?r+1:r,i,f.inner,f.from,f.to,s),l=f.to}p=f.to}else{if(p==n||(t?Lw[p]!=a:Lw[p]==a))break;p++}h?Qw(e,l,p,r+1,i,h,s):l<p&&s.push(new Iw(l,p,u)),l=p}else for(let l=n,c=o.length;l>t;){let n=!0,d=!1;if(!c||l>o[c-1].to){let e=Lw[l-1];e!=a&&(n=!1,d=16==e)}let h=n||1!=a?null:[],u=n?r:r+1,p=l;e:for(;;)if(c&&p==o[c-1].to){if(d)break e;let f=o[--c];if(!n)for(let e=f.from,n=c;;){if(e==t)break e;if(!n||o[n-1].to!=e){if(Lw[e-1]==a)break e;break}e=o[--n].from}if(h)h.push(f);else{f.to<l&&s.push(new Iw(f.to,l,u)),Fw(e,f.direction==Ow!=!(u%2)?r+1:r,i,f.inner,f.from,f.to,s),l=f.from}p=f.from}else{if(p==t||(n?Lw[p-1]!=a:Lw[p-1]==a))break;p--}h?Qw(e,p,l,r+1,i,h,s):p<l&&s.push(new Iw(p,l,u)),l=p}}function Fw(e,t,n,r,i,o,s){let a=t%2?2:1;!function(e,t,n,r,i){for(let o=0;o<=r.length;o++){let s=o?r[o-1].to:t,a=o<r.length?r[o].from:n,l=o?256:i;for(let t=s,n=l,r=l;t<a;t++){let i=Pw(e.charCodeAt(t));512==i?i=n:8==i&&4==r&&(i=16),Lw[t]=4==i?2:i,7&i&&(r=i),n=i}for(let e=s,t=l,r=l;e<a;e++){let i=Lw[e];if(128==i)e<a-1&&t==Lw[e+1]&&24&t?i=Lw[e]=t:Lw[e]=256;else if(64==i){let i=e+1;for(;i<a&&64==Lw[i];)i++;let o=e&&8==t||i<n&&8==Lw[i]?1==r?1:8:256;for(let t=e;t<i;t++)Lw[t]=o;e=i-1}else 8==i&&1==r&&(Lw[e]=1);t=i,7&i&&(r=i)}}}(e,i,o,r,a),function(e,t,n,r,i){let o=1==i?2:1;for(let s=0,a=0,l=0;s<=r.length;s++){let c=s?r[s-1].to:t,d=s<r.length?r[s].from:n;for(let t,n,r,s=c;s<d;s++)if(n=Mw[t=e.charCodeAt(s)])if(n<0){for(let e=a-3;e>=0;e-=3)if(Dw[e+1]==-n){let t=Dw[e+2],n=2&t?i:4&t?1&t?o:i:0;n&&(Lw[s]=Lw[Dw[e]]=n),a=e;break}}else{if(189==Dw.length)break;Dw[a++]=s,Dw[a++]=t,Dw[a++]=l}else if(2==(r=Lw[s])||1==r){let e=r==i;l=e?0:1;for(let t=a-3;t>=0;t-=3){let n=Dw[t+2];if(2&n)break;if(e)Dw[t+2]|=2;else{if(4&n)break;Dw[t+2]|=4}}}}}(e,i,o,r,a),function(e,t,n,r){for(let i=0,o=r;i<=n.length;i++){let s=i?n[i-1].to:e,a=i<n.length?n[i].from:t;for(let l=s;l<a;){let s=Lw[l];if(256==s){let s=l+1;for(;;)if(s==a){if(i==n.length)break;s=n[i++].to,a=i<n.length?n[i].from:t}else{if(256!=Lw[s])break;s++}let c=1==o,d=c==(1==(s<t?Lw[s]:r))?c?1:2:r;for(let t=s,r=i,o=r?n[r-1].to:e;t>l;)t==o&&(t=n[--r].from,o=r?n[r-1].to:e),Lw[--t]=d;l=s}else o=s,l++}}}(i,o,r,a),Qw(e,i,o,t,n,r,s)}function Vw(e,t,n){if(!e)return[new Iw(0,0,t==Bw?1:0)];if(t==Ow&&!n.length&&!Rw.test(e))return zw(e.length);if(n.length)for(;e.length>Lw.length;)Lw[Lw.length]=256;let r=[],i=t==Ow?0:1;return Fw(e,i,i,n,0,e.length,r),r}function zw(e){return[new Iw(0,e,0)]}let Ww="";function $w(e,t,n,r,i){var o;let s=r.head-e.from,a=Iw.find(t,s,null!==(o=r.bidiLevel)&&void 0!==o?o:-1,r.assoc),l=t[a],c=l.side(i,n);if(s==c){let e=a+=i?1:-1;if(e<0||e>=t.length)return null;l=t[a=e],s=l.side(!i,n),c=l.side(i,n)}let d=Hb(e.text,s,l.forward(i,n));(d<l.from||d>l.to)&&(d=c),Ww=e.text.slice(Math.min(s,d),Math.max(s,d));let h=a==(i?t.length-1:0)?null:t[a+(i?1:-1)];return h&&d==c&&h.level+(i?0:1)<l.level?oy.cursor(h.side(!i,n)+e.from,h.forward(i,n)?1:-1,h.level):oy.cursor(d+e.from,l.forward(i,n)?-1:1,l.level)}function Hw(e,t,n){for(let r=t;r<n;r++){let t=Pw(e.charCodeAt(r));if(1==t)return Ow;if(2==t||4==t)return Bw}return Ow}const jw=ly.define(),qw=ly.define(),Uw=ly.define(),Gw=ly.define(),Yw=ly.define(),Xw=ly.define(),Jw=ly.define(),Kw=ly.define(),Zw=ly.define(),eC=ly.define({combine:e=>e.some(e=>e)}),tC=ly.define({combine:e=>e.some(e=>e)}),nC=ly.define();class rC{constructor(e,t="nearest",n="nearest",r=5,i=5,o=!1){this.range=e,this.y=t,this.x=n,this.yMargin=r,this.xMargin=i,this.isSnapshot=o}map(e){return e.empty?this:new rC(this.range.map(e),this.y,this.x,this.yMargin,this.xMargin,this.isSnapshot)}clip(e){return this.range.to<=e.doc.length?this:new rC(oy.cursor(e.doc.length),this.y,this.x,this.yMargin,this.xMargin,this.isSnapshot)}}const iC=Qy.define({map:(e,t)=>e.map(t)}),oC=Qy.define();function sC(e,t,n){let r=e.facet(Gw);r.length?r[0](t):window.onerror&&window.onerror(String(t),n,void 0,void 0,t)||(n?console.error(n+":",t):console.error(t))}const aC=ly.define({combine:e=>!e.length||e[0]});let lC=0;const cC=ly.define({combine:e=>e.filter((t,n)=>{for(let r=0;r<n;r++)if(e[r].plugin==t.plugin)return!1;return!0})});class dC{constructor(e,t,n,r,i){this.id=e,this.create=t,this.domEventHandlers=n,this.domEventObservers=r,this.baseExtensions=i(this),this.extension=this.baseExtensions.concat(cC.of({plugin:this,arg:void 0}))}of(e){return this.baseExtensions.concat(cC.of({plugin:this,arg:e}))}static define(e,t){const{eventHandlers:n,eventObservers:r,provide:i,decorations:o}=t||{};return new dC(lC++,e,n,r,e=>{let t=[];return o&&t.push(fC.of(t=>{let n=t.plugin(e);return n?o(n):Xx.none})),i&&t.push(i(e)),t})}static fromClass(e,t){return dC.define((t,n)=>new e(t,n),t)}}class hC{constructor(e){this.spec=e,this.mustUpdate=null,this.value=null}get plugin(){return this.spec&&this.spec.plugin}update(e){if(this.value){if(this.mustUpdate){let e=this.mustUpdate;if(this.mustUpdate=null,this.value.update)try{this.value.update(e)}catch(t){if(sC(e.state,t,"CodeMirror plugin crashed"),this.value.destroy)try{this.value.destroy()}catch(e){}this.deactivate()}}}else if(this.spec)try{this.value=this.spec.plugin.create(e,this.spec.arg)}catch(t){sC(e.state,t,"CodeMirror plugin crashed"),this.deactivate()}return this}destroy(e){var t;if(null===(t=this.value)||void 0===t?void 0:t.destroy)try{this.value.destroy()}catch(t){sC(e.state,t,"CodeMirror plugin crashed")}}deactivate(){this.spec=this.value=null}}const uC=ly.define(),pC=ly.define(),fC=ly.define(),gC=ly.define(),mC=ly.define(),vC=ly.define(),AC=ly.define();function bC(e,t){let n=e.state.facet(AC);if(!n.length)return n;let r=n.map(t=>t instanceof Function?t(e):t),i=[];return rx.spans(r,t.from,t.to,{point(){},span(e,n,r,o){let s=e-t.from,a=n-t.from,l=i;for(let e=r.length-1;e>=0;e--,o--){let n,i=r[e].spec.bidiIsolate;if(null==i&&(i=Hw(t.text,s,a)),o>0&&l.length&&(n=l[l.length-1]).to==s&&n.direction==i)n.to=a,l=n.inner;else{let e={from:s,to:a,direction:i,inner:[]};l.push(e),l=e.inner}}}}),i}const yC=ly.define();function xC(e){let t=0,n=0,r=0,i=0;for(let o of e.state.facet(yC)){let s=o(e);s&&(null!=s.left&&(t=Math.max(t,s.left)),null!=s.right&&(n=Math.max(n,s.right)),null!=s.top&&(r=Math.max(r,s.top)),null!=s.bottom&&(i=Math.max(i,s.bottom)))}return{left:t,right:n,top:r,bottom:i}}const wC=ly.define();class CC{constructor(e,t,n,r){this.fromA=e,this.toA=t,this.fromB=n,this.toB=r}join(e){return new CC(Math.min(this.fromA,e.fromA),Math.max(this.toA,e.toA),Math.min(this.fromB,e.fromB),Math.max(this.toB,e.toB))}addToSet(e){let t=e.length,n=this;for(;t>0;t--){let r=e[t-1];if(!(r.fromA>n.toA)){if(r.toA<n.fromA)break;n=n.join(r),e.splice(t-1,1)}}return e.splice(t,0,n),e}static extendWithRanges(e,t){if(0==t.length)return e;let n=[];for(let r=0,i=0,o=0;;){let s=r<e.length?e[r].fromB:1e9,a=i<t.length?t[i]:1e9,l=Math.min(s,a);if(1e9==l)break;let c=l+o,d=l,h=c;for(;;)if(i<t.length&&t[i]<=d){let n=t[i+1];i+=2,d=Math.max(d,n);for(let t=r;t<e.length&&e[t].fromB<=d;t++)o=e[t].toA-e[t].toB;h=Math.max(h,n+o)}else{if(!(r<e.length&&e[r].fromB<=d))break;{let t=e[r++];d=Math.max(d,t.toB),h=Math.max(h,t.toA),o=t.toA-t.toB}}n.push(new CC(c,h,l,d))}return n}}class kC{constructor(e,t,n){this.view=e,this.state=t,this.transactions=n,this.flags=0,this.startState=e.state,this.changes=Jb.empty(this.startState.doc.length);for(let e of n)this.changes=this.changes.compose(e.changes);let r=[];this.changes.iterChangedRanges((e,t,n,i)=>r.push(new CC(e,t,n,i))),this.changedRanges=r}static create(e,t,n){return new kC(e,t,n)}get viewportChanged(){return(4&this.flags)>0}get viewportMoved(){return(8&this.flags)>0}get heightChanged(){return(2&this.flags)>0}get geometryChanged(){return this.docChanged||(18&this.flags)>0}get focusChanged(){return(1&this.flags)>0}get docChanged(){return!this.changes.empty}get selectionSet(){return this.transactions.some(e=>e.selection)}get empty(){return 0==this.flags&&0==this.transactions.length}}const SC=[];class OC{constructor(e,t,n=0){this.dom=e,this.length=t,this.flags=n,this.parent=null,e.cmTile=this}get breakAfter(){return 1&this.flags}get children(){return SC}isWidget(){return!1}get isHidden(){return!1}isComposite(){return!1}isLine(){return!1}isText(){return!1}isBlock(){return!1}get domAttrs(){return null}sync(e){if(this.flags|=2,4&this.flags){this.flags&=-5;let e=this.domAttrs;e&&function(e,t){for(let n=e.attributes.length-1;n>=0;n--){let r=e.attributes[n].name;null==t[r]&&e.removeAttribute(r)}for(let n in t){let r=t[n];"style"==n?e.style.cssText=r:e.getAttribute(n)!=r&&e.setAttribute(n,r)}}(this.dom,e)}}toString(){return this.constructor.name+(this.children.length?`(${this.children})`:"")+(this.breakAfter?"#":"")}destroy(){this.parent=null}setDOM(e){this.dom=e,e.cmTile=this}get posAtStart(){return this.parent?this.parent.posBefore(this):0}get posAtEnd(){return this.posAtStart+this.length}posBefore(e,t=this.posAtStart){let n=t;for(let t of this.children){if(t==e)return n;n+=t.length+t.breakAfter}throw new RangeError("Invalid child in posBefore")}posAfter(e){return this.posBefore(e)+e.length}covers(e){return!0}coordsIn(e,t){return null}domPosFor(e,t){let n=lw(this.dom),r=this.length?e>0:t>0;return new kw(this.parent.dom,n+(r?1:0),0==e||e==this.length)}markDirty(e){this.flags&=-3,e&&(this.flags|=4),this.parent&&2&this.parent.flags&&this.parent.markDirty(!1)}get overrideDOMText(){return null}get root(){for(let e=this;e;e=e.parent)if(e instanceof TC)return e;return null}static get(e){return e.cmTile}}class BC extends OC{constructor(e){super(e,0),this._children=[]}isComposite(){return!0}get children(){return this._children}get lastChild(){return this.children.length?this.children[this.children.length-1]:null}append(e){this.children.push(e),e.parent=this}sync(e){if(2&this.flags)return;super.sync(e);let t,n=this.dom,r=null,i=(null==e?void 0:e.node)==n?e:null,o=0;for(let s of this.children){if(s.sync(e),o+=s.length+s.breakAfter,t=r?r.nextSibling:n.firstChild,i&&t!=s.dom&&(i.written=!0),s.dom.parentNode==n)for(;t&&t!=s.dom;)t=_C(t);else n.insertBefore(s.dom,t);r=s.dom}for(t=r?r.nextSibling:n.firstChild,i&&t&&(i.written=!0);t;)t=_C(t);this.length=o}}function _C(e){let t=e.nextSibling;return e.parentNode.removeChild(e),t}class TC extends BC{constructor(e,t){super(t),this.view=e}owns(e){for(;e;e=e.parent)if(e==this)return!0;return!1}isBlock(){return!0}nearest(e){for(;;){if(!e)return null;let t=OC.get(e);if(t&&this.owns(t))return t;e=e.parentNode}}blockTiles(e){for(let t=[],n=this,r=0,i=0;;)if(r==n.children.length){if(!t.length)return;n=n.parent,n.breakAfter&&i++,r=t.pop()}else{let o=n.children[r++];if(o instanceof EC)t.push(r),n=o,r=0;else{let t=i+o.length,n=e(o,i);if(void 0!==n)return n;i=t+o.breakAfter}}}resolveBlock(e,t){let n,r,i=-1,o=-1;if(this.blockTiles((s,a)=>{let l=a+s.length;if(e>=a&&e<=l){if(s.isWidget()&&t>=-1&&t<=1){if(32&s.flags)return!0;16&s.flags&&(n=void 0)}(a<e||e==l&&(t<-1?s.length:s.covers(1)))&&(!n||!s.isWidget()&&n.isWidget())&&(n=s,i=e-a),(l>e||e==a&&(t>1?s.length:s.covers(-1)))&&(!r||!s.isWidget()&&r.isWidget())&&(r=s,o=e-a)}}),!n&&!r)throw new Error("No tile at position "+e);return n&&t<0||!r?{tile:n,offset:i}:{tile:r,offset:o}}}class EC extends BC{constructor(e,t){super(e),this.wrapper=t}isBlock(){return!0}covers(e){return!!this.children.length&&(e<0?this.children[0].covers(-1):this.lastChild.covers(1))}get domAttrs(){return this.wrapper.attributes}static of(e,t){let n=new EC(t||document.createElement(e.tagName),e);return t||(n.flags|=4),n}}class MC extends BC{constructor(e,t){super(e),this.attrs=t}isLine(){return!0}static start(e,t,n){let r=new MC(t||document.createElement("div"),e);return t&&n||(r.flags|=4),r}get domAttrs(){return this.attrs}resolveInline(e,t,n){let r=null,i=-1,o=null,s=-1;!function e(a,l){for(let c=0,d=0;c<a.children.length&&d<=l;c++){let h=a.children[c],u=d+h.length;u>=l&&(h.isComposite()?e(h,l-d):(!o||o.isHidden&&(t>0||n&&DC(o,h)))&&(u>l||32&h.flags)?(o=h,s=l-d):(d<l||16&h.flags&&!h.isHidden)&&(r=h,i=l-d)),d=u}}(this,e);let a=(t<0?r:o)||r||o;return a?{tile:a,offset:a==r?i:s}:null}coordsIn(e,t){let n=this.resolveInline(e,t,!0);return n?n.tile.coordsIn(Math.max(0,n.offset),t):function(e){let t=e.dom.lastChild;if(!t)return e.dom.getBoundingClientRect();let n=sw(t);return n[n.length-1]||null}(this)}domIn(e,t){let n=this.resolveInline(e,t);if(n){let{tile:e,offset:r}=n;if(this.dom.contains(e.dom))return e.isText()?new kw(e.dom,Math.min(e.dom.nodeValue.length,r)):e.domPosFor(r,16&e.flags?1:32&e.flags?-1:t);let i=n.tile.parent,o=!1;for(let e of i.children){if(o)return new kw(e.dom,0);e==n.tile&&(o=!0)}}return new kw(this.dom,0)}}function DC(e,t){let n=e.coordsIn(0,1),r=t.coordsIn(0,1);return n&&r&&r.top<n.bottom}class PC extends BC{constructor(e,t){super(e),this.mark=t}get domAttrs(){return this.mark.attrs}static of(e,t){let n=new PC(t||document.createElement(e.tagName),e);return t||(n.flags|=4),n}}class RC extends OC{constructor(e,t){super(e,t.length),this.text=t}sync(e){2&this.flags||(super.sync(e),this.dom.nodeValue!=this.text&&(e&&e.node==this.dom&&(e.written=!0),this.dom.nodeValue=this.text))}isText(){return!0}toString(){return JSON.stringify(this.text)}coordsIn(e,t){let n=this.dom.nodeValue.length;e>n&&(e=n);let r=e,i=e,o=0;0==e&&t<0||e==n&&t>=0?Wx.chrome||Wx.gecko||(e?(r--,o=1):i<n&&(i++,o=-1)):t<0?r--:i<n&&i++;let s=bw(this.dom,r,i).getClientRects();if(!s.length)return null;let a=s[(o?o<0:t>=0)?0:s.length-1];return Wx.safari&&!o&&0==a.width&&(a=Array.prototype.find.call(s,e=>e.width)||a),o?uw(a,o<0):a||null}static of(e,t){let n=new RC(t||document.createTextNode(e),e);return t||(n.flags|=2),n}}class IC extends OC{constructor(e,t,n,r){super(e,t,r),this.widget=n}isWidget(){return!0}get isHidden(){return this.widget.isHidden}covers(e){return!(48&this.flags)&&(this.flags&(e<0?64:128))>0}coordsIn(e,t){return this.coordsInWidget(e,t,!1)}coordsInWidget(e,t,n){let r=this.widget.coordsAt(this.dom,e,t);if(r)return r;if(n)return uw(this.dom.getBoundingClientRect(),this.length?0==e:t<=0);{let t=this.dom.getClientRects(),n=null;if(!t.length)return null;let r=!!(16&this.flags)||!(32&this.flags)&&e>0;for(let i=r?t.length-1:0;n=t[i],!(e>0?0==i:i==t.length-1||n.top<n.bottom);i+=r?-1:1);return uw(n,!r)}}get overrideDOMText(){if(!this.length)return Rb.empty;let{root:e}=this;if(!e)return Rb.empty;let t=this.posAtStart;return e.view.state.doc.slice(t,t+this.length)}destroy(){super.destroy(),this.widget.destroy(this.dom)}static of(e,t,n,r,i){return i||(i=e.toDOM(t),e.editable||(i.contentEditable="false")),new IC(i,n,e,r)}}class NC extends OC{constructor(e){let t=document.createElement("img");t.className="cm-widgetBuffer",t.setAttribute("aria-hidden","true"),super(t,0,e)}get isHidden(){return!0}get overrideDOMText(){return Rb.empty}coordsIn(e){return this.dom.getBoundingClientRect()}}class LC{constructor(e){this.index=0,this.beforeBreak=!1,this.parents=[],this.tile=e}advance(e,t,n){let{tile:r,index:i,beforeBreak:o,parents:s}=this;for(;e||t>0;)if(r.isComposite())if(o){if(!e)break;n&&n.break(),e--,o=!1}else if(i==r.children.length){if(!e&&!s.length)break;n&&n.leave(r),o=!!r.breakAfter,({tile:r,index:i}=s.pop()),i++}else{let a=r.children[i],l=a.breakAfter;!(t>0?a.length<=e:a.length<e)||n&&!1===n.skip(a,0,a.length)&&a.isComposite?(s.push({tile:r,index:i}),r=a,i=0,n&&a.isComposite()&&n.enter(a)):(o=!!l,i++,e-=a.length)}else if(i==r.length)o=!!r.breakAfter,({tile:r,index:i}=s.pop()),i++;else{if(!e)break;{let t=Math.min(e,r.length-i);n&&n.skip(r,i,i+t),e-=t,i+=t}}return this.tile=r,this.index=i,this.beforeBreak=o,this}get root(){return this.parents.length?this.parents[0].tile:this.tile}}class QC{constructor(e,t,n,r){this.from=e,this.to=t,this.wrapper=n,this.rank=r}}class FC{constructor(e,t,n){this.cache=e,this.root=t,this.blockWrappers=n,this.curLine=null,this.lastBlock=null,this.afterWidget=null,this.pos=0,this.wrappers=[],this.wrapperPos=0}addText(e,t,n,r){var i;this.flushBuffer();let o=this.ensureMarks(t,n),s=o.lastChild;if(s&&s.isText()&&!(8&s.flags)&&s.length+e.length<512){this.cache.reused.set(s,2),(o.children[o.children.length-1]=new RC(s.dom,s.text+e)).parent=o}else o.append(r||RC.of(e,null===(i=this.cache.find(RC))||void 0===i?void 0:i.dom));this.pos+=e.length,this.afterWidget=null}addComposition(e,t){let n=this.curLine;n.dom!=t.line.dom&&(n.setDOM(this.cache.reused.has(t.line)?qC(t.line.dom):t.line.dom),this.cache.reused.set(t.line,2));let r=n;for(let e=t.marks.length-1;e>=0;e--){let n=t.marks[e],i=r.lastChild;if(i instanceof PC&&i.mark.eq(n.mark))i.dom!=n.dom&&i.setDOM(qC(n.dom)),r=i;else{if(this.cache.reused.get(n)){let e=OC.get(n.dom);e&&e.setDOM(qC(n.dom))}let e=PC.of(n.mark,n.dom);r.append(e),r=e}this.cache.reused.set(n,2)}let i=OC.get(e.text);i&&this.cache.reused.set(i,2);let o=new RC(e.text,e.text.nodeValue);o.flags|=8,r.append(o)}addInlineWidget(e,t,n){let r=this.afterWidget&&48&e.flags&&(48&this.afterWidget.flags)==(48&e.flags);r||this.flushBuffer();let i=this.ensureMarks(t,n);r||16&e.flags||i.append(this.getBuffer(1)),i.append(e),this.pos+=e.length,this.afterWidget=e}addMark(e,t,n){this.flushBuffer(),this.ensureMarks(t,n).append(e),this.pos+=e.length,this.afterWidget=null}addBlockWidget(e){this.getBlockPos().append(e),this.pos+=e.length,this.lastBlock=e,this.endLine()}continueWidget(e){(this.afterWidget||this.lastBlock).length+=e,this.pos+=e}addLineStart(e,t){var n;e||(e=jC);let r=MC.start(e,t||(null===(n=this.cache.find(MC))||void 0===n?void 0:n.dom),!!t);this.getBlockPos().append(this.lastBlock=this.curLine=r)}addLine(e){this.getBlockPos().append(e),this.pos+=e.length,this.lastBlock=e,this.endLine()}addBreak(){this.lastBlock.flags|=1,this.endLine(),this.pos++}addLineStartIfNotCovered(e){this.blockPosCovered()||this.addLineStart(e)}ensureLine(e){this.curLine||this.addLineStart(e)}ensureMarks(e,t){var n;let r=this.curLine;for(let i=e.length-1;i>=0;i--){let o,s=e[i];if(t>0&&(o=r.lastChild)&&o instanceof PC&&o.mark.eq(s))r=o,t--;else{let e=PC.of(s,null===(n=this.cache.find(PC,e=>e.mark.eq(s)))||void 0===n?void 0:n.dom);r.append(e),r=e,t=0}}return r}endLine(){if(this.curLine){this.flushBuffer();let e=this.curLine.lastChild;e&&HC(this.curLine,!1)&&("BR"==e.dom.nodeName||!e.isWidget()||Wx.ios&&HC(this.curLine,!0))||this.curLine.append(this.cache.findWidget(GC,0,32)||new IC(GC.toDOM(),0,GC,32)),this.curLine=this.afterWidget=null}}updateBlockWrappers(){this.wrapperPos>this.pos+1e4&&(this.blockWrappers.goto(this.pos),this.wrappers.length=0);for(let e=this.wrappers.length-1;e>=0;e--)this.wrappers[e].to<this.pos&&this.wrappers.splice(e,1);for(let e=this.blockWrappers;e.value&&e.from<=this.pos;e.next())if(e.to>=this.pos){let t=new QC(e.from,e.to,e.value,e.rank),n=this.wrappers.length;for(;n>0&&(this.wrappers[n-1].rank-t.rank||this.wrappers[n-1].to-t.to)<0;)n--;this.wrappers.splice(n,0,t)}this.wrapperPos=this.pos}getBlockPos(){var e;this.updateBlockWrappers();let t=this.root;for(let n of this.wrappers){let r=t.lastChild;if(n.from<this.pos&&r instanceof EC&&r.wrapper.eq(n.wrapper))t=r;else{let r=EC.of(n.wrapper,null===(e=this.cache.find(EC,e=>e.wrapper.eq(n.wrapper)))||void 0===e?void 0:e.dom);t.append(r),t=r}}return t}blockPosCovered(){let e=this.lastBlock;return null!=e&&!e.breakAfter&&(!e.isWidget()||(160&e.flags)>0)}getBuffer(e){let t=2|(e<0?16:32),n=this.cache.find(NC,void 0,1);return n&&(n.flags=t),n||new NC(t)}flushBuffer(){!this.afterWidget||32&this.afterWidget.flags||(this.afterWidget.parent.append(this.getBuffer(-1)),this.afterWidget=null)}}class VC{constructor(e){this.skipCount=0,this.text="",this.textOff=0,this.cursor=e.iter()}skip(e){this.textOff+e<=this.text.length?this.textOff+=e:(this.skipCount+=e-(this.text.length-this.textOff),this.text="",this.textOff=0)}next(e){if(this.textOff==this.text.length){let{value:t,lineBreak:n,done:r}=this.cursor.next(this.skipCount);if(this.skipCount=0,r)throw new Error("Ran out of text content when drawing inline views");this.text=t;let i=this.textOff=Math.min(e,t.length);return n?null:t.slice(0,i)}let t=Math.min(this.text.length,this.textOff+e),n=this.text.slice(this.textOff,t);return this.textOff=t,n}}const zC=[IC,MC,RC,PC,NC,EC,TC];for(let e=0;e<zC.length;e++)zC[e].bucket=e;class WC{constructor(e){this.view=e,this.buckets=zC.map(()=>[]),this.index=zC.map(()=>0),this.reused=new Map}add(e){let t=e.constructor.bucket,n=this.buckets[t];n.length<6?n.push(e):n[this.index[t]=(this.index[t]+1)%6]=e}find(e,t,n=2){let r=e.bucket,i=this.buckets[r],o=this.index[r];for(let e=i.length-1;e>=0;e--){let s=(e+o)%i.length,a=i[s];if((!t||t(a))&&!this.reused.has(a))return i.splice(s,1),s<o&&this.index[r]--,this.reused.set(a,n),a}return null}findWidget(e,t,n){let r=this.buckets[0];if(r.length)for(let i=0,o=0;;i++){if(i==r.length){if(o)return null;o=1,i=0}let s=r[i];if(!this.reused.has(s)&&(0==o?s.widget.compare(e):s.widget.constructor==e.constructor&&e.updateDOM(s.dom,this.view)))return r.splice(i,1),i<this.index[0]&&this.index[0]--,s.widget==e&&s.length==t&&(497&s.flags)==n?(this.reused.set(s,1),s):(this.reused.set(s,2),new IC(s.dom,t,e,-498&s.flags|n))}}reuse(e){return this.reused.set(e,1),e}maybeReuse(e,t=2){if(!this.reused.has(e))return this.reused.set(e,t),e.dom}clear(){for(let e=0;e<this.buckets.length;e++)this.buckets[e].length=this.index[e]=0}}class $C{constructor(e,t,n,r,i){this.view=e,this.decorations=r,this.disallowBlockEffectsFor=i,this.openWidget=!1,this.openMarks=0,this.cache=new WC(e),this.text=new VC(e.state.doc),this.builder=new FC(this.cache,new TC(e,e.contentDOM),rx.iter(n)),this.cache.reused.set(t,2),this.old=new LC(t),this.reuseWalker={skip:(e,t,n)=>{if(this.cache.add(e),e.isComposite())return!1},enter:e=>this.cache.add(e),leave:()=>{},break:()=>{}}}run(e,t){let n=t&&this.getCompositionContext(t.text);for(let r=0,i=0,o=0;;){let s=o<e.length?e[o++]:null,a=s?s.fromA:this.old.root.length;if(a>r){let e=a-r;this.preserve(e,!o,!s),r=a,i+=e}if(!s)break;t&&s.fromA<=t.range.fromA&&s.toA>=t.range.toA?(this.forward(s.fromA,t.range.fromA,t.range.fromA<t.range.toA?1:-1),this.emit(i,t.range.fromB),this.cache.clear(),this.builder.addComposition(t,n),this.text.skip(t.range.toB-t.range.fromB),this.forward(t.range.fromA,s.toA),this.emit(t.range.toB,s.toB)):(this.forward(s.fromA,s.toA),this.emit(i,s.toB)),i=s.toB,r=s.toA}return this.builder.curLine&&this.builder.endLine(),this.builder.root}preserve(e,t,n){let r=function(e){let t=[];for(let n=e.parents.length;n>1;n--){let r=n==e.parents.length?e.tile:e.parents[n].tile;r instanceof PC&&t.push(r.mark)}return t}(this.old),i=this.openMarks;this.old.advance(e,n?1:-1,{skip:(e,t,n)=>{if(e.isWidget())if(this.openWidget)this.builder.continueWidget(n-t);else{let o=n>0||t<e.length?IC.of(e.widget,this.view,n-t,496&e.flags,this.cache.maybeReuse(e)):this.cache.reuse(e);256&o.flags?(o.flags&=-2,this.builder.addBlockWidget(o)):(this.builder.ensureLine(null),this.builder.addInlineWidget(o,r,i),i=r.length)}else if(e.isText())this.builder.ensureLine(null),t||n!=e.length?(this.cache.add(e),this.builder.addText(e.text.slice(t,n),r,i)):this.builder.addText(e.text,r,i,this.cache.reuse(e)),i=r.length;else if(e.isLine())e.flags&=-2,this.cache.reused.set(e,1),this.builder.addLine(e);else if(e instanceof NC)this.cache.add(e);else{if(!(e instanceof PC))return!1;this.builder.ensureLine(null),this.builder.addMark(e,r,i),this.cache.reused.set(e,1),i=r.length}this.openWidget=!1},enter:e=>{e.isLine()?this.builder.addLineStart(e.attrs,this.cache.maybeReuse(e)):(this.cache.add(e),e instanceof PC&&r.unshift(e.mark)),this.openWidget=!1},leave:e=>{e.isLine()?r.length&&(r.length=i=0):e instanceof PC&&(r.shift(),i=Math.min(i,r.length))},break:()=>{this.builder.addBreak(),this.openWidget=!1}}),this.text.skip(e)}emit(e,t){let n=null,r=this.builder,i=0,o=rx.spans(this.decorations,e,t,{point:(e,t,o,s,a,l)=>{if(o instanceof Zx){if(this.disallowBlockEffectsFor[l]){if(o.block)throw new RangeError("Block decorations may not be specified via plugins");if(t>this.view.state.doc.lineAt(e).to)throw new RangeError("Decorations that replace line breaks may not be specified via plugins")}if(i=s.length,a>s.length)r.continueWidget(t-e);else{let i=o.widget||(o.block?UC.block:UC.inline),l=function(e){let t=e.isReplace?(e.startSide<0?64:0)|(e.endSide>0?128:0):e.startSide>0?32:16;e.block&&(t|=256);return t}(o),c=this.cache.findWidget(i,t-e,l)||IC.of(i,this.view,t-e,l);o.block?(o.startSide>0&&r.addLineStartIfNotCovered(n),r.addBlockWidget(c)):(r.ensureLine(n),r.addInlineWidget(c,s,a))}n=null}else n=function(e,t){let n=t.spec.attributes,r=t.spec.class;if(!n&&!r)return e;e||(e={class:"cm-line"});n&&$x(n,e);r&&(e.class+=" "+r);return e}(n,o);t>e&&this.text.skip(t-e)},span:(e,t,i,o)=>{for(let s=e;s<t;){let a=this.text.next(Math.min(512,t-s));null==a?(r.addLineStartIfNotCovered(n),r.addBreak(),s++):(r.ensureLine(n),r.addText(a,i,s==e?o:i.length),s+=a.length),n=null}}});r.addLineStartIfNotCovered(n),this.openWidget=o>i,this.openMarks=o}forward(e,t,n=1){t-e<=10?this.old.advance(t-e,n,this.reuseWalker):(this.old.advance(5,-1,this.reuseWalker),this.old.advance(t-e-10,-1),this.old.advance(5,n,this.reuseWalker))}getCompositionContext(e){let t=[],n=null;for(let r=e.parentNode;;r=r.parentNode){let e=OC.get(r);if(r==this.view.contentDOM)break;e instanceof PC?t.push(e):(null==e?void 0:e.isLine())?n=e:"DIV"!=r.nodeName||n||r==this.view.contentDOM?t.push(PC.of(new Jx({tagName:r.nodeName.toLowerCase(),attributes:Ux(r)}),r)):n=new MC(r,jC)}return{line:n,marks:t}}}function HC(e,t){let n=e=>{for(let r of e.children)if((t?r.isText():r.length)||n(r))return!0;return!1};return n(e)}const jC={class:"cm-line"};function qC(e){let t=OC.get(e);return t&&t.setDOM(e.cloneNode()),e}class UC extends Gx{constructor(e){super(),this.tag=e}eq(e){return e.tag==this.tag}toDOM(){return document.createElement(this.tag)}updateDOM(e){return e.nodeName.toLowerCase()==this.tag}get isHidden(){return!0}}UC.inline=new UC("span"),UC.block=new UC("div");const GC=new class extends Gx{toDOM(){return document.createElement("br")}get isHidden(){return!0}get editable(){return!0}};class YC{constructor(e){this.view=e,this.decorations=[],this.blockWrappers=[],this.dynamicDecorationMap=[!1],this.domChanged=null,this.hasComposition=null,this.editContextFormatting=Xx.none,this.lastCompositionAfterCursor=!1,this.minWidth=0,this.minWidthFrom=0,this.minWidthTo=0,this.impreciseAnchor=null,this.impreciseHead=null,this.forceSelection=!1,this.lastUpdate=Date.now(),this.updateDeco(),this.tile=new TC(e,e.contentDOM),this.updateInner([new CC(0,0,0,e.state.doc.length)],null)}update(e){var t;let n=e.changedRanges;this.minWidth>0&&n.length&&(n.every(({fromA:e,toA:t})=>t<this.minWidthFrom||e>this.minWidthTo)?(this.minWidthFrom=e.changes.mapPos(this.minWidthFrom,1),this.minWidthTo=e.changes.mapPos(this.minWidthTo,1)):this.minWidth=this.minWidthFrom=this.minWidthTo=0),this.updateEditContextFormatting(e);let r=-1;this.view.inputState.composing>=0&&!this.view.observer.editContext&&((null===(t=this.domChanged)||void 0===t?void 0:t.newSel)?r=this.domChanged.newSel.head:function(e,t){let n=!1;t&&e.iterChangedRanges((e,r)=>{e<t.to&&r>t.from&&(n=!0)});return n}(e.changes,this.hasComposition)||e.selectionSet||(r=e.state.selection.main.head));let i=r>-1?function(e,t,n){let r=JC(e,n);if(!r)return null;let{node:i,from:o,to:s}=r,a=i.nodeValue;if(/[\n\r]/.test(a))return null;if(e.state.doc.sliceString(r.from,r.to)!=a)return null;let l=t.invertedDesc;return{range:new CC(l.mapPos(o),l.mapPos(s),o,s),text:i}}(this.view,e.changes,r):null;if(this.domChanged=null,this.hasComposition){let{from:t,to:r}=this.hasComposition;n=new CC(t,r,e.changes.mapPos(t,-1),e.changes.mapPos(r,1)).addToSet(n.slice())}this.hasComposition=i?{from:i.range.fromB,to:i.range.toB}:null,(Wx.ie||Wx.chrome)&&!i&&e&&e.state.doc.lines!=e.startState.doc.lines&&(this.forceSelection=!0);let o=this.decorations,s=this.blockWrappers;this.updateDeco();let a=function(e,t,n){let r=new KC;return rx.compare(e,t,n,r),r.changes}(o,this.decorations,e.changes);a.length&&(n=CC.extendWithRanges(n,a));let l=function(e,t,n){let r=new ZC;return rx.compare(e,t,n,r),r.changes}(s,this.blockWrappers,e.changes);return l.length&&(n=CC.extendWithRanges(n,l)),i&&!n.some(e=>e.fromA<=i.range.fromA&&e.toA>=i.range.toA)&&(n=i.range.addToSet(n.slice())),!(2&this.tile.flags&&0==n.length)&&(this.updateInner(n,i),e.transactions.length&&(this.lastUpdate=Date.now()),!0)}updateInner(e,t){this.view.viewState.mustMeasureContent=!0;let{observer:n}=this.view;n.ignore(()=>{if(t||e.length){let n=this.tile,r=new $C(this.view,n,this.blockWrappers,this.decorations,this.dynamicDecorationMap);this.tile=r.run(e,t),XC(n,r.cache.reused)}this.tile.dom.style.height=this.view.viewState.contentHeight/this.view.scaleY+"px",this.tile.dom.style.flexBasis=this.minWidth?this.minWidth+"px":"";let r=Wx.chrome||Wx.ios?{node:n.selectionRange.focusNode,written:!1}:void 0;this.tile.sync(r),!r||!r.written&&n.selectionRange.focusNode==r.node&&this.tile.dom.contains(r.node)||(this.forceSelection=!0),this.tile.dom.style.height=""});let r=[];if(this.view.viewport.from||this.view.viewport.to<this.view.state.doc.length)for(let e of this.tile.children)e.isWidget()&&e.widget instanceof ek&&r.push(e.dom);n.updateGaps(r)}updateEditContextFormatting(e){this.editContextFormatting=this.editContextFormatting.map(e.changes);for(let t of e.transactions)for(let e of t.effects)e.is(oC)&&(this.editContextFormatting=e.value)}updateSelection(e=!1,t=!1){!e&&this.view.observer.selectionRange.focusNode||this.view.observer.readSelectionRange();let{dom:n}=this.tile,r=this.view.root.activeElement,i=r==n,o=!i&&!(this.view.state.facet(aC)||n.tabIndex>-1)&&ow(n,this.view.observer.selectionRange)&&!(r&&n.contains(r));if(!(i||t||o))return;let s=this.forceSelection;this.forceSelection=!1;let a,l,c=this.view.state.selection.main;if(c.empty?l=a=this.inlineDOMNearPos(c.anchor,c.assoc||1):(l=this.inlineDOMNearPos(c.head,c.head==c.from?1:-1),a=this.inlineDOMNearPos(c.anchor,c.anchor==c.from?1:-1)),Wx.gecko&&c.empty&&!this.hasComposition&&(1==(d=a).node.nodeType&&d.node.firstChild&&(0==d.offset||"false"==d.node.childNodes[d.offset-1].contentEditable)&&(d.offset==d.node.childNodes.length||"false"==d.node.childNodes[d.offset].contentEditable))){let e=document.createTextNode("");this.view.observer.ignore(()=>a.node.insertBefore(e,a.node.childNodes[a.offset]||null)),a=l=new kw(e,0),s=!0}var d;let h=this.view.observer.selectionRange;!s&&h.focusNode&&(aw(a.node,a.offset,h.anchorNode,h.anchorOffset)&&aw(l.node,l.offset,h.focusNode,h.focusOffset)||this.suppressWidgetCursorChange(h,c))||(this.view.observer.ignore(()=>{Wx.android&&Wx.chrome&&n.contains(h.focusNode)&&function(e,t){for(let n=e;n&&n!=t;n=n.assignedSlot||n.parentNode)if(1==n.nodeType&&"false"==n.contentEditable)return!0;return!1}(h.focusNode,n)&&(n.blur(),n.focus({preventScroll:!0}));let e=rw(this.view.root);if(e)if(c.empty){if(Wx.gecko){let e=(t=a.node,i=a.offset,1!=t.nodeType?0:(i&&"false"==t.childNodes[i-1].contentEditable?1:0)|(i<t.childNodes.length&&"false"==t.childNodes[i].contentEditable?2:0));if(e&&3!=e){let t=(1==e?ww:Cw)(a.node,a.offset);t&&(a=new kw(t.node,t.offset))}}e.collapse(a.node,a.offset),null!=c.bidiLevel&&void 0!==e.caretBidiLevel&&(e.caretBidiLevel=c.bidiLevel)}else if(e.extend){e.collapse(a.node,a.offset);try{e.extend(l.node,l.offset)}catch(e){}}else{let t=document.createRange();c.anchor>c.head&&([a,l]=[l,a]),t.setEnd(l.node,l.offset),t.setStart(a.node,a.offset),e.removeAllRanges(),e.addRange(t)}else;var t,i;o&&this.view.root.activeElement==n&&(n.blur(),r&&r.focus())}),this.view.observer.setSelectionRange(a,l)),this.impreciseAnchor=a.precise?null:new kw(h.anchorNode,h.anchorOffset),this.impreciseHead=l.precise?null:new kw(h.focusNode,h.focusOffset)}suppressWidgetCursorChange(e,t){return this.hasComposition&&t.empty&&aw(e.focusNode,e.focusOffset,e.anchorNode,e.anchorOffset)&&this.posFromDOM(e.focusNode,e.focusOffset)==t.head}enforceCursorAssoc(){if(this.hasComposition)return;let{view:e}=this,t=e.state.selection.main,n=rw(e.root),{anchorNode:r,anchorOffset:i}=e.observer.selectionRange;if(!(n&&t.empty&&t.assoc&&n.modify))return;let o=this.lineAt(t.head,t.assoc);if(!o)return;let s=o.posAtStart;if(t.head==s||t.head==s+o.length)return;let a=this.coordsAt(t.head,-1),l=this.coordsAt(t.head,1);if(!a||!l||a.bottom>l.top)return;let c=this.domAtPos(t.head+t.assoc,t.assoc);n.collapse(c.node,c.offset),n.modify("move",t.assoc<0?"forward":"backward","lineboundary"),e.observer.readSelectionRange();let d=e.observer.selectionRange;e.docView.posFromDOM(d.anchorNode,d.anchorOffset)!=t.from&&n.collapse(r,i)}posFromDOM(e,t){let n=this.tile.nearest(e);if(!n)return 2&this.tile.dom.compareDocumentPosition(e)?0:this.view.state.doc.length;let r=n.posAtStart;if(!n.isComposite())return n.isText()?e==n.dom?r+t:r+(t?n.length:0):r;{let i;if(e==n.dom)i=n.dom.childNodes[t];else{let r=0==hw(e)?0:0==t?-1:1;for(;;){let t=e.parentNode;if(t==n.dom)break;0==r&&t.firstChild!=t.lastChild&&(r=e==t.firstChild?-1:1),e=t}i=r<0?e:e.nextSibling}if(i==n.dom.firstChild)return r;for(;i&&!OC.get(i);)i=i.nextSibling;if(!i)return r+n.length;for(let e=0,t=r;;e++){let r=n.children[e];if(r.dom==i)return t;t+=r.length+r.breakAfter}}}domAtPos(e,t){let{tile:n,offset:r}=this.tile.resolveBlock(e,t);return n.isWidget()?n.domPosFor(e,t):n.domIn(r,t)}inlineDOMNearPos(e,t){let n,r,i=-1,o=!1,s=-1,a=!1;return this.tile.blockTiles((t,l)=>{if(t.isWidget()){if(32&t.flags&&l>=e)return!0;16&t.flags&&(o=!0)}else{let c=l+t.length;if(l<=e&&(n=t,i=e-l,o=c<e),c>=e&&!r&&(r=t,s=e-l,a=l>e),l>e&&r)return!0}}),n||r?(o&&r?n=null:a&&n&&(r=null),n&&t<0||!r?n.domIn(i,t):r.domIn(s,t)):this.domAtPos(e,t)}coordsAt(e,t){let{tile:n,offset:r}=this.tile.resolveBlock(e,t);return n.isWidget()?n.widget instanceof ek?null:n.coordsInWidget(r,t,!0):n.coordsIn(r,t)}lineAt(e,t){let{tile:n}=this.tile.resolveBlock(e,t);return n.isLine()?n:null}coordsForChar(e){let{tile:t,offset:n}=this.tile.resolveBlock(e,1);if(!t.isLine())return null;return function e(t,n){if(t.isComposite())for(let r of t.children){if(r.length>=n){let t=e(r,n);if(t)return t}if((n-=r.length)<0)break}else if(t.isText()&&n<t.length){let e=Hb(t.text,n);if(e==n)return null;let r=bw(t.dom,n,e).getClientRects();for(let e=0;e<r.length;e++){let t=r[e];if(e==r.length-1||t.top<t.bottom&&t.left<t.right)return t}}return null}(t,n)}measureVisibleLineHeights(e){let t=[],{from:n,to:r}=e,i=this.view.contentDOM.clientWidth,o=i>Math.max(this.view.scrollDOM.clientWidth,this.minWidth)+1,s=-1,a=this.view.textDirection==Sw.LTR,l=0,c=(e,d,h)=>{for(let u=0;u<e.children.length&&!(d>r);u++){let r=e.children[u],p=d+r.length,f=r.dom.getBoundingClientRect(),{height:g}=f;if(h&&!u&&(l+=f.top-h.top),r instanceof EC)p>n&&c(r,d,f);else if(d>=n&&(l>0&&t.push(-l),t.push(g+l),l=0,o)){let e=r.dom.lastChild,t=e?sw(e):[];if(t.length){let e=t[t.length-1],n=a?e.right-f.left:f.right-e.left;n>s&&(s=n,this.minWidth=i,this.minWidthFrom=d,this.minWidthTo=p)}}h&&u==e.children.length-1&&(l+=h.bottom-f.bottom),d=p+r.breakAfter}};return c(this.tile,0,null),t}textDirectionAt(e){let{tile:t}=this.tile.resolveBlock(e,1);return"rtl"==getComputedStyle(t.dom).direction?Sw.RTL:Sw.LTR}measureTextSize(){let e=this.tile.blockTiles(e=>{if(e.isLine()&&e.children.length&&e.length<=20){let t,n=0;for(let r of e.children){if(!r.isText()||/[^ -~]/.test(r.text))return;let e=sw(r.dom);if(1!=e.length)return;n+=e[0].width,t=e[0].height}if(n)return{lineHeight:e.dom.getBoundingClientRect().height,charWidth:n/e.length,textHeight:t}}});if(e)return e;let t,n,r,i=document.createElement("div");return i.className="cm-line",i.style.width="99999px",i.style.position="absolute",i.textContent="abc def ghi jkl mno pqr stu",this.view.observer.ignore(()=>{this.tile.dom.appendChild(i);let e=sw(i.firstChild)[0];t=i.getBoundingClientRect().height,n=e&&e.width?e.width/27:7,r=e&&e.height?e.height:t,i.remove()}),{lineHeight:t,charWidth:n,textHeight:r}}computeBlockGapDeco(){let e=[],t=this.view.viewState;for(let n=0,r=0;;r++){let i=r==t.viewports.length?null:t.viewports[r],o=i?i.from-1:this.view.state.doc.length;if(o>n){let r=(t.lineBlockAt(o).bottom-t.lineBlockAt(n).top)/this.view.scaleY;e.push(Xx.replace({widget:new ek(r),block:!0,inclusive:!0,isBlockGap:!0}).range(n,o))}if(!i)break;n=i.to+1}return Xx.set(e)}updateDeco(){let e=1,t=this.view.state.facet(fC).map(t=>(this.dynamicDecorationMap[e++]="function"==typeof t)?t(this.view):t),n=!1,r=this.view.state.facet(mC).map((e,t)=>{let r="function"==typeof e;return r&&(n=!0),r?e(this.view):e});for(r.length&&(this.dynamicDecorationMap[e++]=n,t.push(rx.join(r))),this.decorations=[this.editContextFormatting,...t,this.computeBlockGapDeco(),this.view.viewState.lineGapDeco];e<this.decorations.length;)this.dynamicDecorationMap[e++]=!1;this.blockWrappers=this.view.state.facet(gC).map(e=>"function"==typeof e?e(this.view):e)}scrollIntoView(e){if(e.isSnapshot){let t=this.view.viewState.lineBlockAt(e.range.head);return this.view.scrollDOM.scrollTop=t.top-e.yMargin,void(this.view.scrollDOM.scrollLeft=e.xMargin)}for(let t of this.view.state.facet(nC))try{if(t(this.view,e.range,e))return!0}catch(e){sC(this.view.state,e,"scroll handler")}let t,{range:n}=e,r=this.coordsAt(n.head,n.empty?n.assoc:n.head>n.anchor?-1:1);if(!r)return;!n.empty&&(t=this.coordsAt(n.anchor,n.anchor>n.head?-1:1))&&(r={left:Math.min(r.left,t.left),top:Math.min(r.top,t.top),right:Math.max(r.right,t.right),bottom:Math.max(r.bottom,t.bottom)});let i=xC(this.view),o={left:r.left-i.left,top:r.top-i.top,right:r.right+i.right,bottom:r.bottom+i.bottom},{offsetWidth:s,offsetHeight:a}=this.view.scrollDOM;!function(e,t,n,r,i,o,s,a){let l=e.ownerDocument,c=l.defaultView||window;for(let d=e,h=!1;d&&!h;)if(1==d.nodeType){let e,u=d==l.body,p=1,f=1;if(u)e=pw(c);else{if(/^(fixed|sticky)$/.test(getComputedStyle(d).position)&&(h=!0),d.scrollHeight<=d.clientHeight&&d.scrollWidth<=d.clientWidth){d=d.assignedSlot||d.parentNode;continue}let t=d.getBoundingClientRect();({scaleX:p,scaleY:f}=fw(d,t)),e={left:t.left,right:t.left+d.clientWidth*p,top:t.top,bottom:t.top+d.clientHeight*f}}let g=0,m=0;if("nearest"==i)t.top<e.top?(m=t.top-(e.top+s),n>0&&t.bottom>e.bottom+m&&(m=t.bottom-e.bottom+s)):t.bottom>e.bottom&&(m=t.bottom-e.bottom+s,n<0&&t.top-m<e.top&&(m=t.top-(e.top+s)));else{let r=t.bottom-t.top,o=e.bottom-e.top;m=("center"==i&&r<=o?t.top+r/2-o/2:"start"==i||"center"==i&&n<0?t.top-s:t.bottom-o+s)-e.top}if("nearest"==r?t.left<e.left?(g=t.left-(e.left+o),n>0&&t.right>e.right+g&&(g=t.right-e.right+o)):t.right>e.right&&(g=t.right-e.right+o,n<0&&t.left<e.left+g&&(g=t.left-(e.left+o))):g=("center"==r?t.left+(t.right-t.left)/2-(e.right-e.left)/2:"start"==r==a?t.left-o:t.right-(e.right-e.left)+o)-e.left,g||m)if(u)c.scrollBy(g,m);else{let e=0,n=0;if(m){let e=d.scrollTop;d.scrollTop+=m/f,n=(d.scrollTop-e)*f}if(g){let t=d.scrollLeft;d.scrollLeft+=g/p,e=(d.scrollLeft-t)*p}t={left:t.left-e,top:t.top-n,right:t.right-e,bottom:t.bottom-n},e&&Math.abs(e-g)<1&&(r="nearest"),n&&Math.abs(n-m)<1&&(i="nearest")}if(u)break;(t.top<e.top||t.bottom>e.bottom||t.left<e.left||t.right>e.right)&&(t={left:Math.max(t.left,e.left),right:Math.min(t.right,e.right),top:Math.max(t.top,e.top),bottom:Math.min(t.bottom,e.bottom)}),d=d.assignedSlot||d.parentNode}else{if(11!=d.nodeType)break;d=d.host}}(this.view.scrollDOM,o,n.head<n.anchor?-1:1,e.x,e.y,Math.max(Math.min(e.xMargin,s),-s),Math.max(Math.min(e.yMargin,a),-a),this.view.textDirection==Sw.LTR)}lineHasWidget(e){let t=e=>e.isWidget()||e.children.some(t);return t(this.tile.resolveBlock(e,1).tile)}destroy(){XC(this.tile)}}function XC(e,t){let n=null==t?void 0:t.get(e);if(1!=n){null==n&&e.destroy();for(let n of e.children)XC(n,t)}}function JC(e,t){let n=e.observer.selectionRange;if(!n.focusNode)return null;let r=ww(n.focusNode,n.focusOffset),i=Cw(n.focusNode,n.focusOffset),o=r||i;if(i&&r&&i.node!=r.node){let t=OC.get(i.node);if(!t||t.isText()&&t.text!=i.node.nodeValue)o=i;else if(e.docView.lastCompositionAfterCursor){let e=OC.get(r.node);!e||e.isText()&&e.text!=r.node.nodeValue||(o=i)}}if(e.docView.lastCompositionAfterCursor=o!=r,!o)return null;let s=t-o.offset;return{from:s,to:s+o.node.nodeValue.length,node:o.node}}let KC=class{constructor(){this.changes=[]}compareRange(e,t){tw(e,t,this.changes)}comparePoint(e,t){tw(e,t,this.changes)}boundChange(e){tw(e,e,this.changes)}};class ZC{constructor(){this.changes=[]}compareRange(e,t){tw(e,t,this.changes)}comparePoint(){}boundChange(e){tw(e,e,this.changes)}}class ek extends Gx{constructor(e){super(),this.height=e}toDOM(){let e=document.createElement("div");return e.className="cm-gap",this.updateDOM(e),e}eq(e){return e.height==this.height}updateDOM(e){return e.style.height=this.height+"px",!0}get editable(){return!0}get estimatedHeight(){return this.height}ignoreEvent(){return!1}}function tk(e,t,n){let r=e.lineBlockAt(t);if(Array.isArray(r.type)){let e;for(let i of r.type){if(i.from>t)break;if(!(i.to<t)){if(i.from<t&&i.to>t)return i;e&&(i.type!=Yx.Text||e.type==i.type&&!(n<0?i.from<t:i.to>t))||(e=i)}}return e||r}return r}function nk(e,t,n,r){let i=e.state.doc.lineAt(t.head),o=e.bidiSpans(i),s=e.textDirectionAt(i.from);for(let a=t,l=null;;){let t=$w(i,o,s,a,n),c=Ww;if(!t){if(i.number==(n?e.state.doc.lines:1))return a;c="\n",i=e.state.doc.line(i.number+(n?1:-1)),o=e.bidiSpans(i),t=e.visualLineSide(i,!n)}if(l){if(!l(c))return a}else{if(!r)return t;l=r(c)}a=t}}function rk(e,t,n){for(;;){let r=0;for(let i of e)i.between(t-1,t+1,(e,i,o)=>{if(t>e&&t<i){let o=r||n||(t-e<i-t?-1:1);t=o<0?e:i,r=o}});if(!r)return t}}function ik(e,t){let n=null;for(let r=0;r<t.ranges.length;r++){let i=t.ranges[r],o=null;if(i.empty){let t=rk(e,i.from,0);t!=i.from&&(o=oy.cursor(t,-1))}else{let t=rk(e,i.from,-1),n=rk(e,i.to,1);t==i.from&&n==i.to||(o=oy.range(i.from==i.anchor?t:n,i.from==i.head?t:n))}o&&(n||(n=t.ranges.slice()),n[r]=o)}return n?oy.create(n,t.mainIndex):t}function ok(e,t,n){let r=rk(e.state.facet(vC).map(t=>t(e)),n.from,t.head>n.from?-1:1);return r==n.from?n:oy.cursor(r,r<n.from?1:-1)}class sk{constructor(e,t){this.pos=e,this.assoc=t}}function ak(e,t,n,r){let i,o=e.contentDOM.getBoundingClientRect(),s=o.top+e.viewState.paddingTop,{x:a,y:l}=t,c=l-s;for(;;){if(c<0)return new sk(0,1);if(c>e.viewState.docHeight)return new sk(e.state.doc.length,-1);if(i=e.elementAtHeight(c),null==r)break;if(i.type==Yx.Text){if(r<0?i.to<e.viewport.from:i.from>e.viewport.to)break;let t=e.docView.coordsAt(r<0?i.from:i.to,r);if(t&&(r<0?t.top<=c+s:t.bottom>=c+s))break}let t=e.viewState.heightOracle.textHeight/2;c=r>0?i.bottom+t:i.top-t}if(e.viewport.from>=i.to||e.viewport.to<=i.from){if(n)return null;if(i.type==Yx.Text){let t=function(e,t,n,r,i){let o=Math.round((r-t.left)*e.defaultCharacterWidth);if(e.lineWrapping&&n.height>1.5*e.defaultLineHeight){let t=e.viewState.heightOracle.textHeight;o+=Math.floor((i-n.top-.5*(e.defaultLineHeight-t))/t)*e.viewState.heightOracle.lineLength}let s=e.state.sliceDoc(n.from,n.to);return n.from+mx(s,o,e.state.tabSize)}(e,o,i,a,l);return new sk(t,t==i.from?1:-1)}}if(i.type!=Yx.Text)return c<(i.top+i.bottom)/2?new sk(i.from,1):new sk(i.to,-1);let d=e.docView.lineAt(i.from,2);return d&&d.length==i.length||(d=e.docView.lineAt(i.from,-2)),lk(e,d,i.from,a,l)}function lk(e,t,n,r,i){let o=-1,s=null,a=1e9,l=1e9,c=i,d=i,h=(e,t)=>{for(let n=0;n<e.length;n++){let h=e[n];if(h.top==h.bottom)continue;let u=h.left>r?h.left-r:h.right<r?r-h.right:0,p=h.top>i?h.top-i:h.bottom<i?i-h.bottom:0;h.top<=d&&h.bottom>=c&&(c=Math.min(h.top,c),d=Math.max(h.bottom,d),p=0),(o<0||(p-l||u-a)<0)&&(o>=0&&l&&a<u&&s.top<=d-2&&s.bottom>=c+2?l=0:(o=t,a=u,l=p,s=h))}};if(t.isText()){for(let e=0;e<t.length;){let n=Hb(t.text,e);if(h(bw(t.dom,e,n).getClientRects(),e),!a&&!l)break;e=n}return r>(s.left+s.right)/2==(ck(e,o+n)==Sw.LTR)?new sk(n+Hb(t.text,o),-1):new sk(n+o,1)}{if(!t.length)return new sk(n,1);for(let e=0;e<t.children.length;e++){let n=t.children[e];if(!(48&n.flags)&&(h((1==n.dom.nodeType?n.dom:bw(n.dom,0,n.length)).getClientRects(),e),!a&&!l))break}let c=t.children[o],d=t.posBefore(c,n);return c.isComposite()||c.isText()?lk(e,c,d,Math.max(s.left,Math.min(s.right,r)),i):r>(s.left+s.right)/2==(ck(e,o+n)==Sw.LTR)?new sk(d+c.length,-1):new sk(d,1)}}function ck(e,t){let n=e.state.doc.lineAt(t);return e.bidiSpans(n)[Iw.find(e.bidiSpans(n),t-n.from,-1,1)].dir}const dk="￿";class hk{constructor(e,t){this.points=e,this.view=t,this.text="",this.lineSeparator=t.state.facet(Xy.lineSeparator)}append(e){this.text+=e}lineBreak(){this.text+=dk}readRange(e,t){if(!e)return this;let n=e.parentNode;for(let r=e;;){this.findPointBefore(n,r);let e=this.text.length;this.readNode(r);let i=OC.get(r),o=r.nextSibling;if(o==t){(null==i?void 0:i.breakAfter)&&!o&&n!=this.view.contentDOM&&this.lineBreak();break}let s=OC.get(o);(i&&s?i.breakAfter:(i?i.breakAfter:cw(r))||cw(o)&&("BR"!=r.nodeName||(null==i?void 0:i.isWidget()))&&this.text.length>e)&&!pk(o,t)&&this.lineBreak(),r=o}return this.findPointBefore(n,t),this}readTextNode(e){let t=e.nodeValue;for(let n of this.points)n.node==e&&(n.pos=this.text.length+Math.min(n.offset,t.length));for(let n=0,r=this.lineSeparator?null:/\r\n?|\n/g;;){let i,o=-1,s=1;if(this.lineSeparator?(o=t.indexOf(this.lineSeparator,n),s=this.lineSeparator.length):(i=r.exec(t))&&(o=i.index,s=i[0].length),this.append(t.slice(n,o<0?t.length:o)),o<0)break;if(this.lineBreak(),s>1)for(let t of this.points)t.node==e&&t.pos>this.text.length&&(t.pos-=s-1);n=o+s}}readNode(e){let t=OC.get(e),n=t&&t.overrideDOMText;if(null!=n){this.findPointInside(e,n.length);for(let e=n.iter();!e.next().done;)e.lineBreak?this.lineBreak():this.append(e.value)}else 3==e.nodeType?this.readTextNode(e):"BR"==e.nodeName?e.nextSibling&&this.lineBreak():1==e.nodeType&&this.readRange(e.firstChild,null)}findPointBefore(e,t){for(let n of this.points)n.node==e&&e.childNodes[n.offset]==t&&(n.pos=this.text.length)}findPointInside(e,t){for(let n of this.points)(3==e.nodeType?n.node==e:e.contains(n.node))&&(n.pos=this.text.length+(uk(e,n.node,n.offset)?t:0))}}function uk(e,t,n){for(;;){if(!t||n<hw(t))return!1;if(t==e)return!0;n=lw(t)+1,t=t.parentNode}}function pk(e,t){let n;for(;e!=t&&e;e=e.nextSibling){let t=OC.get(e);if(!(null==t?void 0:t.isWidget()))return!1;t&&(n||(n=[])).push(t)}if(n)for(let e of n){let t=e.overrideDOMText;if(null==t?void 0:t.length)return!1}return!0}class fk{constructor(e,t){this.node=e,this.offset=t,this.pos=-1}}class gk{constructor(e,t,n,r){this.typeOver=r,this.bounds=null,this.text="",this.domChanged=t>-1;let{impreciseHead:i,impreciseAnchor:o}=e.docView;if(e.state.readOnly&&t>-1)this.newSel=null;else if(t>-1&&(this.bounds=mk(e.docView.tile,t,n,0))){let t=i||o?[]:function(e){let t=[];if(e.root.activeElement!=e.contentDOM)return t;let{anchorNode:n,anchorOffset:r,focusNode:i,focusOffset:o}=e.observer.selectionRange;n&&(t.push(new fk(n,r)),i==n&&o==r||t.push(new fk(i,o)));return t}(e),n=new hk(t,e);n.readRange(this.bounds.startDOM,this.bounds.endDOM),this.text=n.text,this.newSel=function(e,t){if(0==e.length)return null;let n=e[0].pos,r=2==e.length?e[1].pos:n;return n>-1&&r>-1?oy.single(n+t,r+t):null}(t,this.bounds.from)}else{let t=e.observer.selectionRange,n=i&&i.node==t.focusNode&&i.offset==t.focusOffset||!iw(e.contentDOM,t.focusNode)?e.state.selection.main.head:e.docView.posFromDOM(t.focusNode,t.focusOffset),r=o&&o.node==t.anchorNode&&o.offset==t.anchorOffset||!iw(e.contentDOM,t.anchorNode)?e.state.selection.main.anchor:e.docView.posFromDOM(t.anchorNode,t.anchorOffset),s=e.viewport;if((Wx.ios||Wx.chrome)&&e.state.selection.main.empty&&n!=r&&(s.from>0||s.to<e.state.doc.length)){let t=Math.min(n,r),i=Math.max(n,r),o=s.from-t,a=s.to-i;0!=o&&1!=o&&0!=t||0!=a&&-1!=a&&i!=e.state.doc.length||(n=0,r=e.state.doc.length)}e.inputState.composing>-1&&e.state.selection.ranges.length>1?this.newSel=e.state.selection.replaceRange(oy.range(r,n)):this.newSel=oy.single(r,n)}}}function mk(e,t,n,r){if(e.isComposite()){let i=-1,o=-1,s=-1,a=-1;for(let l=0,c=r,d=r;l<e.children.length;l++){let r=e.children[l],h=c+r.length;if(c<t&&h>n)return mk(r,t,n,c);if(h>=t&&-1==i&&(i=l,o=c),c>n&&r.dom.parentNode==e.dom){s=l,a=d;break}d=h,c=h+r.breakAfter}return{from:o,to:a<0?r+e.length:a,startDOM:(i?e.children[i-1].dom.nextSibling:null)||e.dom.firstChild,endDOM:s<e.children.length&&s>=0?e.children[s].dom:null}}return e.isText()?{from:r,to:r+e.length,startDOM:e.dom,endDOM:e.dom.nextSibling}:null}function vk(e,t){let n,{newSel:r}=t,i=e.state.selection.main,o=e.inputState.lastKeyTime>Date.now()-100?e.inputState.lastKeyCode:-1;if(t.bounds){let{from:r,to:s}=t.bounds,a=i.from,l=null;(8===o||Wx.android&&t.text.length<s-r)&&(a=i.to,l="end");let c=bk(e.state.doc.sliceString(r,s,dk),t.text,a-r,l);c&&(Wx.chrome&&13==o&&c.toB==c.from+2&&t.text.slice(c.from,c.toB)==dk+dk&&c.toB--,n={from:r+c.from,to:r+c.toA,insert:Rb.of(t.text.slice(c.from,c.toB).split(dk))})}else r&&(!e.hasFocus&&e.state.facet(aC)||yk(r,i))&&(r=null);if(!n&&!r)return!1;if(!n&&t.typeOver&&!i.empty&&r&&r.main.empty?n={from:i.from,to:i.to,insert:e.state.doc.slice(i.from,i.to)}:(Wx.mac||Wx.android)&&n&&n.from==n.to&&n.from==i.head-1&&/^\. ?$/.test(n.insert.toString())&&"off"==e.contentDOM.getAttribute("autocorrect")?(r&&2==n.insert.length&&(r=oy.single(r.main.anchor-1,r.main.head-1)),n={from:n.from,to:n.to,insert:Rb.of([n.insert.toString().replace("."," ")])}):n&&n.from>=i.from&&n.to<=i.to&&(n.from!=i.from||n.to!=i.to)&&i.to-i.from-(n.to-n.from)<=4?n={from:i.from,to:i.to,insert:e.state.doc.slice(i.from,n.from).append(n.insert).append(e.state.doc.slice(n.to,i.to))}:e.state.doc.lineAt(i.from).to<i.to&&e.docView.lineHasWidget(i.to)&&e.inputState.insertingTextAt>Date.now()-50?n={from:i.from,to:i.to,insert:e.state.toText(e.inputState.insertingText)}:Wx.chrome&&n&&n.from==n.to&&n.from==i.head&&"\n "==n.insert.toString()&&e.lineWrapping&&(r&&(r=oy.single(r.main.anchor-1,r.main.head-1)),n={from:i.from,to:i.to,insert:Rb.of([" "])}),n)return Ak(e,n,r,o);if(r&&!yk(r,i)){let t=!1,n="select";return e.inputState.lastSelectionTime>Date.now()-50&&("select"==e.inputState.lastSelectionOrigin&&(t=!0),n=e.inputState.lastSelectionOrigin,"select.pointer"==n&&(r=ik(e.state.facet(vC).map(t=>t(e)),r))),e.dispatch({selection:r,scrollIntoView:t,userEvent:n}),!0}return!1}function Ak(e,t,n,r=-1){if(Wx.ios&&e.inputState.flushIOSKey(t))return!0;let i=e.state.selection.main;if(Wx.android&&(t.to==i.to&&(t.from==i.from||t.from==i.from-1&&" "==e.state.sliceDoc(t.from,i.from))&&1==t.insert.length&&2==t.insert.lines&&yw(e.contentDOM,"Enter",13)||(t.from==i.from-1&&t.to==i.to&&0==t.insert.length||8==r&&t.insert.length<t.to-t.from&&t.to>i.head)&&yw(e.contentDOM,"Backspace",8)||t.from==i.from&&t.to==i.to+1&&0==t.insert.length&&yw(e.contentDOM,"Delete",46)))return!0;let o,s=t.insert.toString();e.inputState.composing>=0&&e.inputState.composing++;let a=()=>o||(o=function(e,t,n){let r,i=e.state,o=i.selection.main,s=-1;if(t.from==t.to&&t.from<o.from||t.from>o.to){let n=t.from<o.from?-1:1,r=n<0?o.from:o.to,a=rk(i.facet(vC).map(t=>t(e)),r,n);t.from==a&&(s=a)}if(s>-1)r={changes:t,selection:oy.cursor(t.from+t.insert.length,-1)};else if(t.from>=o.from&&t.to<=o.to&&t.to-t.from>=(o.to-o.from)/3&&(!n||n.main.empty&&n.main.from==t.from+t.insert.length)&&e.inputState.composing<0){let n=o.from<t.from?i.sliceDoc(o.from,t.from):"",s=o.to>t.to?i.sliceDoc(t.to,o.to):"";r=i.replaceSelection(e.state.toText(n+t.insert.sliceString(0,void 0,e.state.lineBreak)+s))}else{let s=i.changes(t),a=n&&n.main.to<=s.newLength?n.main:void 0;if(i.selection.ranges.length>1&&(e.inputState.composing>=0||e.inputState.compositionPendingChange)&&t.to<=o.to+10&&t.to>=o.to-10){let l,c=e.state.sliceDoc(t.from,t.to),d=n&&JC(e,n.main.head);if(d){let e=t.insert.length-(t.to-t.from);l={from:d.from,to:d.to-e}}else l=e.state.doc.lineAt(o.head);let h=o.to-t.to;r=i.changeByRange(n=>{if(n.from==o.from&&n.to==o.to)return{changes:s,range:a||n.map(s)};let r=n.to-h,d=r-c.length;if(e.state.sliceDoc(d,r)!=c||r>=l.from&&d<=l.to)return{range:n};let u=i.changes({from:d,to:r,insert:t.insert}),p=n.to-o.to;return{changes:u,range:a?oy.range(Math.max(0,a.anchor+p),Math.max(0,a.head+p)):n.map(u)}})}else r={changes:s,selection:a&&i.selection.replaceRange(a)}}let a="input.type";(e.composing||e.inputState.compositionPendingChange&&e.inputState.compositionEndedAt>Date.now()-50)&&(e.inputState.compositionPendingChange=!1,a+=".compose",e.inputState.compositionFirstChange&&(a+=".start",e.inputState.compositionFirstChange=!1));return i.update(r,{userEvent:a,scrollIntoView:!0})}(e,t,n));return e.state.facet(Xw).some(n=>n(e,t.from,t.to,s,a))||e.dispatch(a()),!0}function bk(e,t,n,r){let i=Math.min(e.length,t.length),o=0;for(;o<i&&e.charCodeAt(o)==t.charCodeAt(o);)o++;if(o==i&&e.length==t.length)return null;let s=e.length,a=t.length;for(;s>0&&a>0&&e.charCodeAt(s-1)==t.charCodeAt(a-1);)s--,a--;if("end"==r){n-=s+Math.max(0,o-Math.min(s,a))-o}if(s<o&&e.length<t.length){o-=n<=o&&n>=s?o-n:0,a=o+(a-s),s=o}else if(a<o){o-=n<=o&&n>=a?o-n:0,s=o+(s-a),a=o}return{from:o,toA:s,toB:a}}function yk(e,t){return t.head==e.main.head&&t.anchor==e.main.anchor}class xk{setSelectionOrigin(e){this.lastSelectionOrigin=e,this.lastSelectionTime=Date.now()}constructor(e){this.view=e,this.lastKeyCode=0,this.lastKeyTime=0,this.lastTouchTime=0,this.lastFocusTime=0,this.lastScrollTop=0,this.lastScrollLeft=0,this.pendingIOSKey=void 0,this.tabFocusMode=-1,this.lastSelectionOrigin=null,this.lastSelectionTime=0,this.lastContextMenu=0,this.scrollHandlers=[],this.handlers=Object.create(null),this.composing=-1,this.compositionFirstChange=null,this.compositionEndedAt=0,this.compositionPendingKey=!1,this.compositionPendingChange=!1,this.insertingText="",this.insertingTextAt=0,this.mouseSelection=null,this.draggedContent=null,this.handleEvent=this.handleEvent.bind(this),this.notifiedFocused=e.hasFocus,Wx.safari&&e.contentDOM.addEventListener("input",()=>null),Wx.gecko&&function(e){jk.has(e)||(jk.add(e),e.addEventListener("copy",()=>{}),e.addEventListener("cut",()=>{}))}(e.contentDOM.ownerDocument)}handleEvent(e){(function(e,t){if(!t.bubbles)return!0;if(t.defaultPrevented)return!1;for(let n,r=t.target;r!=e.contentDOM;r=r.parentNode)if(!r||11==r.nodeType||(n=OC.get(r))&&n.isWidget()&&!n.isHidden&&n.widget.ignoreEvent(t))return!1;return!0})(this.view,e)&&!this.ignoreDuringComposition(e)&&("keydown"==e.type&&this.keydown(e)||(0!=this.view.updateState?Promise.resolve().then(()=>this.runHandlers(e.type,e)):this.runHandlers(e.type,e)))}runHandlers(e,t){let n=this.handlers[e];if(n){for(let e of n.observers)e(this.view,t);for(let e of n.handlers){if(t.defaultPrevented)break;if(e(this.view,t)){t.preventDefault();break}}}}ensureHandlers(e){let t=Ck(e),n=this.handlers,r=this.view.contentDOM;for(let e in t)if("scroll"!=e){let i=!t[e].handlers.length,o=n[e];o&&i!=!o.handlers.length&&(r.removeEventListener(e,this.handleEvent),o=null),o||r.addEventListener(e,this.handleEvent,{passive:i})}for(let e in n)"scroll"==e||t[e]||r.removeEventListener(e,this.handleEvent);this.handlers=t}keydown(e){if(this.lastKeyCode=e.keyCode,this.lastKeyTime=Date.now(),9==e.keyCode&&this.tabFocusMode>-1&&(!this.tabFocusMode||Date.now()<=this.tabFocusMode))return!0;if(this.tabFocusMode>0&&27!=e.keyCode&&Ok.indexOf(e.keyCode)<0&&(this.tabFocusMode=-1),Wx.android&&Wx.chrome&&!e.synthetic&&(13==e.keyCode||8==e.keyCode))return this.view.observer.delayAndroidKey(e.key,e.keyCode),!0;let t;return!Wx.ios||e.synthetic||e.altKey||e.metaKey||!((t=kk.find(t=>t.keyCode==e.keyCode))&&!e.ctrlKey||Sk.indexOf(e.key)>-1&&e.ctrlKey&&!e.shiftKey)?(229!=e.keyCode&&this.view.observer.forceFlush(),!1):(this.pendingIOSKey=t||e,setTimeout(()=>this.flushIOSKey(),250),!0)}flushIOSKey(e){let t=this.pendingIOSKey;return!!t&&(!("Enter"==t.key&&e&&e.from<e.to&&/^\S+$/.test(e.insert.toString()))&&(this.pendingIOSKey=void 0,yw(this.view.contentDOM,t.key,t.keyCode,t instanceof KeyboardEvent?t:void 0)))}ignoreDuringComposition(e){return!(!/^key/.test(e.type)||e.synthetic)&&(this.composing>0||!!(Wx.safari&&!Wx.ios&&this.compositionPendingKey&&Date.now()-this.compositionEndedAt<100)&&(this.compositionPendingKey=!1,!0))}startMouseSelection(e){this.mouseSelection&&this.mouseSelection.destroy(),this.mouseSelection=e}update(e){this.view.observer.update(e),this.mouseSelection&&this.mouseSelection.update(e),this.draggedContent&&e.docChanged&&(this.draggedContent=this.draggedContent.map(e.changes)),e.transactions.length&&(this.lastKeyCode=this.lastSelectionTime=0)}destroy(){this.mouseSelection&&this.mouseSelection.destroy()}}function wk(e,t){return(n,r)=>{try{return t.call(e,r,n)}catch(e){sC(n.state,e)}}}function Ck(e){let t=Object.create(null);function n(e){return t[e]||(t[e]={observers:[],handlers:[]})}for(let t of e){let e=t.spec,r=e&&e.plugin.domEventHandlers,i=e&&e.plugin.domEventObservers;if(r)for(let e in r){let i=r[e];i&&n(e).handlers.push(wk(t.value,i))}if(i)for(let e in i){let r=i[e];r&&n(e).observers.push(wk(t.value,r))}}for(let e in Tk)n(e).handlers.push(Tk[e]);for(let e in Ek)n(e).observers.push(Ek[e]);return t}const kk=[{key:"Backspace",keyCode:8,inputType:"deleteContentBackward"},{key:"Enter",keyCode:13,inputType:"insertParagraph"},{key:"Enter",keyCode:13,inputType:"insertLineBreak"},{key:"Delete",keyCode:46,inputType:"deleteContentForward"}],Sk="dthko",Ok=[16,17,18,20,91,92,224,225];function Bk(e){return.7*Math.max(0,e)+8}class _k{constructor(e,t,n,r){this.view=e,this.startEvent=t,this.style=n,this.mustSelect=r,this.scrollSpeed={x:0,y:0},this.scrolling=-1,this.lastEvent=t,this.scrollParents=function(e){let t,n,r=e.ownerDocument;for(let i=e.parentNode;i&&!(i==r.body||t&&n);)if(1==i.nodeType)!n&&i.scrollHeight>i.clientHeight&&(n=i),!t&&i.scrollWidth>i.clientWidth&&(t=i),i=i.assignedSlot||i.parentNode;else{if(11!=i.nodeType)break;i=i.host}return{x:t,y:n}}(e.contentDOM),this.atoms=e.state.facet(vC).map(t=>t(e));let i=e.contentDOM.ownerDocument;i.addEventListener("mousemove",this.move=this.move.bind(this)),i.addEventListener("mouseup",this.up=this.up.bind(this)),this.extend=t.shiftKey,this.multiple=e.state.facet(Xy.allowMultipleSelections)&&function(e,t){let n=e.state.facet(jw);return n.length?n[0](t):Wx.mac?t.metaKey:t.ctrlKey}(e,t),this.dragging=!(!function(e,t){let{main:n}=e.state.selection;if(n.empty)return!1;let r=rw(e.root);if(!r||0==r.rangeCount)return!0;let i=r.getRangeAt(0).getClientRects();for(let e=0;e<i.length;e++){let n=i[e];if(n.left<=t.clientX&&n.right>=t.clientX&&n.top<=t.clientY&&n.bottom>=t.clientY)return!0}return!1}(e,t)||1!=Fk(t))&&null}start(e){!1===this.dragging&&this.select(e)}move(e){if(0==e.buttons)return this.destroy();if(this.dragging||null==this.dragging&&(t=this.startEvent,n=e,Math.max(Math.abs(t.clientX-n.clientX),Math.abs(t.clientY-n.clientY))<10))return;var t,n;this.select(this.lastEvent=e);let r=0,i=0,o=0,s=0,a=this.view.win.innerWidth,l=this.view.win.innerHeight;this.scrollParents.x&&({left:o,right:a}=this.scrollParents.x.getBoundingClientRect()),this.scrollParents.y&&({top:s,bottom:l}=this.scrollParents.y.getBoundingClientRect());let c=xC(this.view);e.clientX-c.left<=o+6?r=-Bk(o-e.clientX):e.clientX+c.right>=a-6&&(r=Bk(e.clientX-a)),e.clientY-c.top<=s+6?i=-Bk(s-e.clientY):e.clientY+c.bottom>=l-6&&(i=Bk(e.clientY-l)),this.setScrollSpeed(r,i)}up(e){null==this.dragging&&this.select(this.lastEvent),this.dragging||e.preventDefault(),this.destroy()}destroy(){this.setScrollSpeed(0,0);let e=this.view.contentDOM.ownerDocument;e.removeEventListener("mousemove",this.move),e.removeEventListener("mouseup",this.up),this.view.inputState.mouseSelection=this.view.inputState.draggedContent=null}setScrollSpeed(e,t){this.scrollSpeed={x:e,y:t},e||t?this.scrolling<0&&(this.scrolling=setInterval(()=>this.scroll(),50)):this.scrolling>-1&&(clearInterval(this.scrolling),this.scrolling=-1)}scroll(){let{x:e,y:t}=this.scrollSpeed;e&&this.scrollParents.x&&(this.scrollParents.x.scrollLeft+=e,e=0),t&&this.scrollParents.y&&(this.scrollParents.y.scrollTop+=t,t=0),(e||t)&&this.view.win.scrollBy(e,t),!1===this.dragging&&this.select(this.lastEvent)}select(e){let{view:t}=this,n=ik(this.atoms,this.style.get(e,this.extend,this.multiple));!this.mustSelect&&n.eq(t.state.selection,!1===this.dragging)||this.view.dispatch({selection:n,userEvent:"select.pointer"}),this.mustSelect=!1}update(e){e.transactions.some(e=>e.isUserEvent("input.type"))?this.destroy():this.style.update(e)&&setTimeout(()=>this.select(this.lastEvent),20)}}const Tk=Object.create(null),Ek=Object.create(null),Mk=Wx.ie&&Wx.ie_version<15||Wx.ios&&Wx.webkit_version<604;function Dk(e,t,n){for(let r of e.facet(t))n=r(n,e);return n}function Pk(e,t){t=Dk(e.state,Kw,t);let n,{state:r}=e,i=1,o=r.toText(t),s=o.lines==r.selection.ranges.length;if(null!=zk&&r.selection.ranges.every(e=>e.empty)&&zk==o.toString()){let e=-1;n=r.changeByRange(n=>{let a=r.doc.lineAt(n.from);if(a.from==e)return{range:n};e=a.from;let l=r.toText((s?o.line(i++).text:t)+r.lineBreak);return{changes:{from:a.from,insert:l},range:oy.cursor(n.from+l.length)}})}else n=s?r.changeByRange(e=>{let t=o.line(i++);return{changes:{from:e.from,to:e.to,insert:t.text},range:oy.cursor(e.from+t.length)}}):r.replaceSelection(o);e.dispatch(n,{userEvent:"input.paste",scrollIntoView:!0})}function Rk(e,t,n,r){if(1==r)return oy.cursor(t,n);if(2==r)return function(e,t,n=1){let r=e.charCategorizer(t),i=e.doc.lineAt(t),o=t-i.from;if(0==i.length)return oy.cursor(t);0==o?n=1:o==i.length&&(n=-1);let s=o,a=o;n<0?s=Hb(i.text,o,!1):a=Hb(i.text,o);let l=r(i.text.slice(s,a));for(;s>0;){let e=Hb(i.text,s,!1);if(r(i.text.slice(e,s))!=l)break;s=e}for(;a<i.length;){let e=Hb(i.text,a);if(r(i.text.slice(a,e))!=l)break;a=e}return oy.range(s+i.from,a+i.from)}(e.state,t,n);{let r=e.docView.lineAt(t,n),i=e.state.doc.lineAt(r?r.posAtEnd:t),o=r?r.posAtStart:i.from,s=r?r.posAtEnd:i.to;return s<e.state.doc.length&&s==i.to&&s++,oy.range(o,s)}}Ek.scroll=e=>{e.inputState.lastScrollTop=e.scrollDOM.scrollTop,e.inputState.lastScrollLeft=e.scrollDOM.scrollLeft},Tk.keydown=(e,t)=>(e.inputState.setSelectionOrigin("select"),27==t.keyCode&&0!=e.inputState.tabFocusMode&&(e.inputState.tabFocusMode=Date.now()+2e3),!1),Ek.touchstart=(e,t)=>{e.inputState.lastTouchTime=Date.now(),e.inputState.setSelectionOrigin("select.pointer")},Ek.touchmove=e=>{e.inputState.setSelectionOrigin("select.pointer")},Tk.mousedown=(e,t)=>{if(e.observer.flush(),e.inputState.lastTouchTime>Date.now()-2e3)return!1;let n=null;for(let r of e.state.facet(Uw))if(n=r(e,t),n)break;if(n||0!=t.button||(n=function(e,t){let n=e.posAndSideAtCoords({x:t.clientX,y:t.clientY},!1),r=Fk(t),i=e.state.selection;return{update(e){e.docChanged&&(n.pos=e.changes.mapPos(n.pos),i=i.map(e.changes))},get(t,o,s){let a,l=e.posAndSideAtCoords({x:t.clientX,y:t.clientY},!1),c=Rk(e,l.pos,l.assoc,r);if(n.pos!=l.pos&&!o){let t=Rk(e,n.pos,n.assoc,r),i=Math.min(t.from,c.from),o=Math.max(t.to,c.to);c=i<c.from?oy.range(i,o):oy.range(o,i)}return o?i.replaceRange(i.main.extend(c.from,c.to)):s&&1==r&&i.ranges.length>1&&(a=function(e,t){for(let n=0;n<e.ranges.length;n++){let{from:r,to:i}=e.ranges[n];if(r<=t&&i>=t)return oy.create(e.ranges.slice(0,n).concat(e.ranges.slice(n+1)),e.mainIndex==n?0:e.mainIndex-(e.mainIndex>n?1:0))}return null}(i,l.pos))?a:s?i.addRange(c):oy.create([c])}}}(e,t)),n){let r=!e.hasFocus;e.inputState.startMouseSelection(new _k(e,t,n,r)),r&&e.observer.ignore(()=>{Aw(e.contentDOM);let t=e.root.activeElement;t&&!t.contains(e.contentDOM)&&t.blur()});let i=e.inputState.mouseSelection;if(i)return i.start(t),!1===i.dragging}else e.inputState.setSelectionOrigin("select.pointer");return!1};const Ik=Wx.ie&&Wx.ie_version<=11;let Nk=null,Lk=0,Qk=0;function Fk(e){if(!Ik)return e.detail;let t=Nk,n=Qk;return Nk=e,Qk=Date.now(),Lk=!t||n>Date.now()-400&&Math.abs(t.clientX-e.clientX)<2&&Math.abs(t.clientY-e.clientY)<2?(Lk+1)%3:1}function Vk(e,t,n,r){if(!(n=Dk(e.state,Kw,n)))return;let i=e.posAtCoords({x:t.clientX,y:t.clientY},!1),{draggedContent:o}=e.inputState,s=r&&o&&function(e,t){let n=e.state.facet(qw);return n.length?n[0](t):Wx.mac?!t.altKey:!t.ctrlKey}(e,t)?{from:o.from,to:o.to}:null,a={from:i,insert:n},l=e.state.changes(s?[s,a]:a);e.focus(),e.dispatch({changes:l,selection:{anchor:l.mapPos(i,-1),head:l.mapPos(i,1)},userEvent:s?"move.drop":"input.drop"}),e.inputState.draggedContent=null}Tk.dragstart=(e,t)=>{let{selection:{main:n}}=e.state;if(t.target.draggable){let r=e.docView.tile.nearest(t.target);if(r&&r.isWidget()){let e=r.posAtStart,t=e+r.length;(e>=n.to||t<=n.from)&&(n=oy.range(e,t))}}let{inputState:r}=e;return r.mouseSelection&&(r.mouseSelection.dragging=!0),r.draggedContent=n,t.dataTransfer&&(t.dataTransfer.setData("Text",Dk(e.state,Zw,e.state.sliceDoc(n.from,n.to))),t.dataTransfer.effectAllowed="copyMove"),!1},Tk.dragend=e=>(e.inputState.draggedContent=null,!1),Tk.drop=(e,t)=>{if(!t.dataTransfer)return!1;if(e.state.readOnly)return!0;let n=t.dataTransfer.files;if(n&&n.length){let r=Array(n.length),i=0,o=()=>{++i==n.length&&Vk(e,t,r.filter(e=>null!=e).join(e.state.lineBreak),!1)};for(let e=0;e<n.length;e++){let t=new FileReader;t.onerror=o,t.onload=()=>{/[\x00-\x08\x0e-\x1f]{2}/.test(t.result)||(r[e]=t.result),o()},t.readAsText(n[e])}return!0}{let n=t.dataTransfer.getData("Text");if(n)return Vk(e,t,n,!0),!0}return!1},Tk.paste=(e,t)=>{if(e.state.readOnly)return!0;e.observer.flush();let n=Mk?null:t.clipboardData;return n?(Pk(e,n.getData("text/plain")||n.getData("text/uri-list")),!0):(function(e){let t=e.dom.parentNode;if(!t)return;let n=t.appendChild(document.createElement("textarea"));n.style.cssText="position: fixed; left: -10000px; top: 10px",n.focus(),setTimeout(()=>{e.focus(),n.remove(),Pk(e,n.value)},50)}(e),!1)};let zk=null;Tk.copy=Tk.cut=(e,t)=>{let n=rw(e.root);if(n&&!ow(e.contentDOM,n))return!1;let{text:r,ranges:i,linewise:o}=function(e){let t=[],n=[],r=!1;for(let r of e.selection.ranges)r.empty||(t.push(e.sliceDoc(r.from,r.to)),n.push(r));if(!t.length){let i=-1;for(let{from:r}of e.selection.ranges){let o=e.doc.lineAt(r);o.number>i&&(t.push(o.text),n.push({from:o.from,to:Math.min(e.doc.length,o.to+1)})),i=o.number}r=!0}return{text:Dk(e,Zw,t.join(e.lineBreak)),ranges:n,linewise:r}}(e.state);if(!r&&!o)return!1;zk=o?r:null,"cut"!=t.type||e.state.readOnly||e.dispatch({changes:i,scrollIntoView:!0,userEvent:"delete.cut"});let s=Mk?null:t.clipboardData;return s?(s.clearData(),s.setData("text/plain",r),!0):(function(e,t){let n=e.dom.parentNode;if(!n)return;let r=n.appendChild(document.createElement("textarea"));r.style.cssText="position: fixed; left: -10000px; top: 10px",r.value=t,r.focus(),r.selectionEnd=t.length,r.selectionStart=0,setTimeout(()=>{r.remove(),e.focus()},50)}(e,r),!1)};const Wk=Iy.define();function $k(e,t){let n=[];for(let r of e.facet(Jw)){let i=r(e,t);i&&n.push(i)}return n.length?e.update({effects:n,annotations:Wk.of(!0)}):null}function Hk(e){setTimeout(()=>{let t=e.hasFocus;if(t!=e.inputState.notifiedFocused){let n=$k(e.state,t);n?e.dispatch(n):e.update([])}},10)}Ek.focus=e=>{e.inputState.lastFocusTime=Date.now(),e.scrollDOM.scrollTop||!e.inputState.lastScrollTop&&!e.inputState.lastScrollLeft||(e.scrollDOM.scrollTop=e.inputState.lastScrollTop,e.scrollDOM.scrollLeft=e.inputState.lastScrollLeft),Hk(e)},Ek.blur=e=>{e.observer.clearSelectionRange(),Hk(e)},Ek.compositionstart=Ek.compositionupdate=e=>{e.observer.editContext||(null==e.inputState.compositionFirstChange&&(e.inputState.compositionFirstChange=!0),e.inputState.composing<0&&(e.inputState.composing=0))},Ek.compositionend=e=>{e.observer.editContext||(e.inputState.composing=-1,e.inputState.compositionEndedAt=Date.now(),e.inputState.compositionPendingKey=!0,e.inputState.compositionPendingChange=e.observer.pendingRecords().length>0,e.inputState.compositionFirstChange=null,Wx.chrome&&Wx.android?e.observer.flushSoon():e.inputState.compositionPendingChange?Promise.resolve().then(()=>e.observer.flush()):setTimeout(()=>{e.inputState.composing<0&&e.docView.hasComposition&&e.update([])},50))},Ek.contextmenu=e=>{e.inputState.lastContextMenu=Date.now()},Tk.beforeinput=(e,t)=>{var n,r;if("insertText"!=t.inputType&&"insertCompositionText"!=t.inputType||(e.inputState.insertingText=t.data,e.inputState.insertingTextAt=Date.now()),"insertReplacementText"==t.inputType&&e.observer.editContext){let r=null===(n=t.dataTransfer)||void 0===n?void 0:n.getData("text/plain"),i=t.getTargetRanges();if(r&&i.length){let t=i[0],n=e.posAtDOM(t.startContainer,t.startOffset),o=e.posAtDOM(t.endContainer,t.endOffset);return Ak(e,{from:n,to:o,insert:e.state.toText(r)},null),!0}}let i;if(Wx.chrome&&Wx.android&&(i=kk.find(e=>e.inputType==t.inputType))&&(e.observer.delayAndroidKey(i.key,i.keyCode),"Backspace"==i.key||"Delete"==i.key)){let t=(null===(r=window.visualViewport)||void 0===r?void 0:r.height)||0;setTimeout(()=>{var n;((null===(n=window.visualViewport)||void 0===n?void 0:n.height)||0)>t+10&&e.hasFocus&&(e.contentDOM.blur(),e.focus())},100)}return Wx.ios&&"deleteContentForward"==t.inputType&&e.observer.flushSoon(),Wx.safari&&"insertText"==t.inputType&&e.inputState.composing>=0&&setTimeout(()=>Ek.compositionend(e,t),20),!1};const jk=new Set;const qk=["pre-wrap","normal","pre-line","break-spaces"];let Uk=!1;function Gk(){Uk=!1}class Yk{constructor(e){this.lineWrapping=e,this.doc=Rb.empty,this.heightSamples={},this.lineHeight=14,this.charWidth=7,this.textHeight=14,this.lineLength=30}heightForGap(e,t){let n=this.doc.lineAt(t).number-this.doc.lineAt(e).number+1;return this.lineWrapping&&(n+=Math.max(0,Math.ceil((t-e-n*this.lineLength*.5)/this.lineLength))),this.lineHeight*n}heightForLine(e){if(!this.lineWrapping)return this.lineHeight;return(1+Math.max(0,Math.ceil((e-this.lineLength)/Math.max(1,this.lineLength-5))))*this.lineHeight}setDoc(e){return this.doc=e,this}mustRefreshForWrapping(e){return qk.indexOf(e)>-1!=this.lineWrapping}mustRefreshForHeights(e){let t=!1;for(let n=0;n<e.length;n++){let r=e[n];r<0?n++:this.heightSamples[Math.floor(10*r)]||(t=!0,this.heightSamples[Math.floor(10*r)]=!0)}return t}refresh(e,t,n,r,i,o){let s=qk.indexOf(e)>-1,a=Math.abs(t-this.lineHeight)>.3||this.lineWrapping!=s||Math.abs(n-this.charWidth)>.1;if(this.lineWrapping=s,this.lineHeight=t,this.charWidth=n,this.textHeight=r,this.lineLength=i,a){this.heightSamples={};for(let e=0;e<o.length;e++){let t=o[e];t<0?e++:this.heightSamples[Math.floor(10*t)]=!0}}return a}}class Xk{constructor(e,t){this.from=e,this.heights=t,this.index=0}get more(){return this.index<this.heights.length}}class Jk{constructor(e,t,n,r,i){this.from=e,this.length=t,this.top=n,this.height=r,this._content=i}get type(){return"number"==typeof this._content?Yx.Text:Array.isArray(this._content)?this._content:this._content.type}get to(){return this.from+this.length}get bottom(){return this.top+this.height}get widget(){return this._content instanceof Zx?this._content.widget:null}get widgetLineBreaks(){return"number"==typeof this._content?this._content:0}join(e){let t=(Array.isArray(this._content)?this._content:[this]).concat(Array.isArray(e._content)?e._content:[e]);return new Jk(this.from,this.length+e.length,this.top,this.height+e.height,t)}}var Kk=function(e){return e[e.ByPos=0]="ByPos",e[e.ByHeight=1]="ByHeight",e[e.ByPosNoHeight=2]="ByPosNoHeight",e}(Kk||(Kk={}));const Zk=.001;class eS{constructor(e,t,n=2){this.length=e,this.height=t,this.flags=n}get outdated(){return(2&this.flags)>0}set outdated(e){this.flags=(e?2:0)|-3&this.flags}setHeight(e){this.height!=e&&(Math.abs(this.height-e)>Zk&&(Uk=!0),this.height=e)}replace(e,t,n){return eS.of(n)}decomposeLeft(e,t){t.push(this)}decomposeRight(e,t){t.push(this)}applyChanges(e,t,n,r){let i=this,o=n.doc;for(let s=r.length-1;s>=0;s--){let{fromA:a,toA:l,fromB:c,toB:d}=r[s],h=i.lineAt(a,Kk.ByPosNoHeight,n.setDoc(t),0,0),u=h.to>=l?h:i.lineAt(l,Kk.ByPosNoHeight,n,0,0);for(d+=u.to-l,l=u.to;s>0&&h.from<=r[s-1].toA;)a=r[s-1].fromA,c=r[s-1].fromB,s--,a<h.from&&(h=i.lineAt(a,Kk.ByPosNoHeight,n,0,0));c+=h.from-a,a=h.from;let p=lS.build(n.setDoc(o),e,c,d);i=tS(i,i.replace(a,l,p))}return i.updateHeight(n,0)}static empty(){return new iS(0,0,0)}static of(e){if(1==e.length)return e[0];let t=0,n=e.length,r=0,i=0;for(;;)if(t==n)if(r>2*i){let i=e[t-1];i.break?e.splice(--t,1,i.left,null,i.right):e.splice(--t,1,i.left,i.right),n+=1+i.break,r-=i.size}else{if(!(i>2*r))break;{let t=e[n];t.break?e.splice(n,1,t.left,null,t.right):e.splice(n,1,t.left,t.right),n+=2+t.break,i-=t.size}}else if(r<i){let n=e[t++];n&&(r+=n.size)}else{let t=e[--n];t&&(i+=t.size)}let o=0;return null==e[t-1]?(o=1,t--):null==e[t]&&(o=1,n++),new sS(eS.of(e.slice(0,t)),o,eS.of(e.slice(n)))}}function tS(e,t){return e==t?e:(e.constructor!=t.constructor&&(Uk=!0),t)}eS.prototype.size=1;const nS=Xx.replace({});class rS extends eS{constructor(e,t,n){super(e,t),this.deco=n,this.spaceAbove=0}mainBlock(e,t){return new Jk(t,this.length,e+this.spaceAbove,this.height-this.spaceAbove,this.deco||0)}blockAt(e,t,n,r){return this.spaceAbove&&e<n+this.spaceAbove?new Jk(r,0,n,this.spaceAbove,nS):this.mainBlock(n,r)}lineAt(e,t,n,r,i){let o=this.mainBlock(r,i);return this.spaceAbove?this.blockAt(0,n,r,i).join(o):o}forEachLine(e,t,n,r,i,o){e<=i+this.length&&t>=i&&o(this.lineAt(0,Kk.ByPos,n,r,i))}setMeasuredHeight(e){let t=e.heights[e.index++];t<0?(this.spaceAbove=-t,t=e.heights[e.index++]):this.spaceAbove=0,this.setHeight(t)}updateHeight(e,t=0,n=!1,r){return r&&r.from<=t&&r.more&&this.setMeasuredHeight(r),this.outdated=!1,this}toString(){return`block(${this.length})`}}class iS extends rS{constructor(e,t,n){super(e,t,null),this.collapsed=0,this.widgetHeight=0,this.breaks=0,this.spaceAbove=n}mainBlock(e,t){return new Jk(t,this.length,e+this.spaceAbove,this.height-this.spaceAbove,this.breaks)}replace(e,t,n){let r=n[0];return 1==n.length&&(r instanceof iS||r instanceof oS&&4&r.flags)&&Math.abs(this.length-r.length)<10?(r instanceof oS?r=new iS(r.length,this.height,this.spaceAbove):r.height=this.height,this.outdated||(r.outdated=!1),r):eS.of(n)}updateHeight(e,t=0,n=!1,r){return r&&r.from<=t&&r.more?this.setMeasuredHeight(r):(n||this.outdated)&&(this.spaceAbove=0,this.setHeight(Math.max(this.widgetHeight,e.heightForLine(this.length-this.collapsed))+this.breaks*e.lineHeight)),this.outdated=!1,this}toString(){return`line(${this.length}${this.collapsed?-this.collapsed:""}${this.widgetHeight?":"+this.widgetHeight:""})`}}class oS extends eS{constructor(e){super(e,0)}heightMetrics(e,t){let n,r=e.doc.lineAt(t).number,i=e.doc.lineAt(t+this.length).number,o=i-r+1,s=0;if(e.lineWrapping){let t=Math.min(this.height,e.lineHeight*o);n=t/o,this.length>o+1&&(s=(this.height-t)/(this.length-o-1))}else n=this.height/o;return{firstLine:r,lastLine:i,perLine:n,perChar:s}}blockAt(e,t,n,r){let{firstLine:i,lastLine:o,perLine:s,perChar:a}=this.heightMetrics(t,r);if(t.lineWrapping){let i=r+(e<t.lineHeight?0:Math.round(Math.max(0,Math.min(1,(e-n)/this.height))*this.length)),o=t.doc.lineAt(i),l=s+o.length*a,c=Math.max(n,e-l/2);return new Jk(o.from,o.length,c,l,0)}{let r=Math.max(0,Math.min(o-i,Math.floor((e-n)/s))),{from:a,length:l}=t.doc.line(i+r);return new Jk(a,l,n+s*r,s,0)}}lineAt(e,t,n,r,i){if(t==Kk.ByHeight)return this.blockAt(e,n,r,i);if(t==Kk.ByPosNoHeight){let{from:t,to:r}=n.doc.lineAt(e);return new Jk(t,r-t,0,0,0)}let{firstLine:o,perLine:s,perChar:a}=this.heightMetrics(n,i),l=n.doc.lineAt(e),c=s+l.length*a,d=l.number-o,h=r+s*d+a*(l.from-i-d);return new Jk(l.from,l.length,Math.max(r,Math.min(h,r+this.height-c)),c,0)}forEachLine(e,t,n,r,i,o){e=Math.max(e,i),t=Math.min(t,i+this.length);let{firstLine:s,perLine:a,perChar:l}=this.heightMetrics(n,i);for(let c=e,d=r;c<=t;){let t=n.doc.lineAt(c);if(c==e){let n=t.number-s;d+=a*n+l*(e-i-n)}let r=a+l*t.length;o(new Jk(t.from,t.length,d,r,0)),d+=r,c=t.to+1}}replace(e,t,n){let r=this.length-t;if(r>0){let e=n[n.length-1];e instanceof oS?n[n.length-1]=new oS(e.length+r):n.push(null,new oS(r-1))}if(e>0){let t=n[0];t instanceof oS?n[0]=new oS(e+t.length):n.unshift(new oS(e-1),null)}return eS.of(n)}decomposeLeft(e,t){t.push(new oS(e-1),null)}decomposeRight(e,t){t.push(null,new oS(this.length-e-1))}updateHeight(e,t=0,n=!1,r){let i=t+this.length;if(r&&r.from<=t+this.length&&r.more){let n=[],o=Math.max(t,r.from),s=-1;for(r.from>t&&n.push(new oS(r.from-t-1).updateHeight(e,t));o<=i&&r.more;){let t=e.doc.lineAt(o).length;n.length&&n.push(null);let i=r.heights[r.index++],a=0;i<0&&(a=-i,i=r.heights[r.index++]),-1==s?s=i:Math.abs(i-s)>=Zk&&(s=-2);let l=new iS(t,i,a);l.outdated=!1,n.push(l),o+=t+1}o<=i&&n.push(null,new oS(i-o).updateHeight(e,o));let a=eS.of(n);return(s<0||Math.abs(a.height-this.height)>=Zk||Math.abs(s-this.heightMetrics(e,t).perLine)>=Zk)&&(Uk=!0),tS(this,a)}return(n||this.outdated)&&(this.setHeight(e.heightForGap(t,t+this.length)),this.outdated=!1),this}toString(){return`gap(${this.length})`}}class sS extends eS{constructor(e,t,n){super(e.length+t+n.length,e.height+n.height,t|(e.outdated||n.outdated?2:0)),this.left=e,this.right=n,this.size=e.size+n.size}get break(){return 1&this.flags}blockAt(e,t,n,r){let i=n+this.left.height;return e<i?this.left.blockAt(e,t,n,r):this.right.blockAt(e,t,i,r+this.left.length+this.break)}lineAt(e,t,n,r,i){let o=r+this.left.height,s=i+this.left.length+this.break,a=t==Kk.ByHeight?e<o:e<s,l=a?this.left.lineAt(e,t,n,r,i):this.right.lineAt(e,t,n,o,s);if(this.break||(a?l.to<s:l.from>s))return l;let c=t==Kk.ByPosNoHeight?Kk.ByPosNoHeight:Kk.ByPos;return a?l.join(this.right.lineAt(s,c,n,o,s)):this.left.lineAt(s,c,n,r,i).join(l)}forEachLine(e,t,n,r,i,o){let s=r+this.left.height,a=i+this.left.length+this.break;if(this.break)e<a&&this.left.forEachLine(e,t,n,r,i,o),t>=a&&this.right.forEachLine(e,t,n,s,a,o);else{let l=this.lineAt(a,Kk.ByPos,n,r,i);e<l.from&&this.left.forEachLine(e,l.from-1,n,r,i,o),l.to>=e&&l.from<=t&&o(l),t>l.to&&this.right.forEachLine(l.to+1,t,n,s,a,o)}}replace(e,t,n){let r=this.left.length+this.break;if(t<r)return this.balanced(this.left.replace(e,t,n),this.right);if(e>this.left.length)return this.balanced(this.left,this.right.replace(e-r,t-r,n));let i=[];e>0&&this.decomposeLeft(e,i);let o=i.length;for(let e of n)i.push(e);if(e>0&&aS(i,o-1),t<this.length){let e=i.length;this.decomposeRight(t,i),aS(i,e)}return eS.of(i)}decomposeLeft(e,t){let n=this.left.length;if(e<=n)return this.left.decomposeLeft(e,t);t.push(this.left),this.break&&(n++,e>=n&&t.push(null)),e>n&&this.right.decomposeLeft(e-n,t)}decomposeRight(e,t){let n=this.left.length,r=n+this.break;if(e>=r)return this.right.decomposeRight(e-r,t);e<n&&this.left.decomposeRight(e,t),this.break&&e<r&&t.push(null),t.push(this.right)}balanced(e,t){return e.size>2*t.size||t.size>2*e.size?eS.of(this.break?[e,null,t]:[e,t]):(this.left=tS(this.left,e),this.right=tS(this.right,t),this.setHeight(e.height+t.height),this.outdated=e.outdated||t.outdated,this.size=e.size+t.size,this.length=e.length+this.break+t.length,this)}updateHeight(e,t=0,n=!1,r){let{left:i,right:o}=this,s=t+i.length+this.break,a=null;return r&&r.from<=t+i.length&&r.more?a=i=i.updateHeight(e,t,n,r):i.updateHeight(e,t,n),r&&r.from<=s+o.length&&r.more?a=o=o.updateHeight(e,s,n,r):o.updateHeight(e,s,n),a?this.balanced(i,o):(this.height=this.left.height+this.right.height,this.outdated=!1,this)}toString(){return this.left+(this.break?" ":"-")+this.right}}function aS(e,t){let n,r;null==e[t]&&(n=e[t-1])instanceof oS&&(r=e[t+1])instanceof oS&&e.splice(t-1,3,new oS(n.length+1+r.length))}class lS{constructor(e,t){this.pos=e,this.oracle=t,this.nodes=[],this.lineStart=-1,this.lineEnd=-1,this.covering=null,this.writtenTo=e}get isCovered(){return this.covering&&this.nodes[this.nodes.length-1]==this.covering}span(e,t){if(this.lineStart>-1){let e=Math.min(t,this.lineEnd),n=this.nodes[this.nodes.length-1];n instanceof iS?n.length+=e-this.pos:(e>this.pos||!this.isCovered)&&this.nodes.push(new iS(e-this.pos,-1,0)),this.writtenTo=e,t>e&&(this.nodes.push(null),this.writtenTo++,this.lineStart=-1)}this.pos=t}point(e,t,n){if(e<t||n.heightRelevant){let r=n.widget?n.widget.estimatedHeight:0,i=n.widget?n.widget.lineBreaks:0;r<0&&(r=this.oracle.lineHeight);let o=t-e;n.block?this.addBlock(new rS(o,r,n)):(o||i||r>=5)&&this.addLineDeco(r,i,o)}else t>e&&this.span(e,t);this.lineEnd>-1&&this.lineEnd<this.pos&&(this.lineEnd=this.oracle.doc.lineAt(this.pos).to)}enterLine(){if(this.lineStart>-1)return;let{from:e,to:t}=this.oracle.doc.lineAt(this.pos);this.lineStart=e,this.lineEnd=t,this.writtenTo<e&&((this.writtenTo<e-1||null==this.nodes[this.nodes.length-1])&&this.nodes.push(this.blankContent(this.writtenTo,e-1)),this.nodes.push(null)),this.pos>e&&this.nodes.push(new iS(this.pos-e,-1,0)),this.writtenTo=this.pos}blankContent(e,t){let n=new oS(t-e);return this.oracle.doc.lineAt(e).to==t&&(n.flags|=4),n}ensureLine(){this.enterLine();let e=this.nodes.length?this.nodes[this.nodes.length-1]:null;if(e instanceof iS)return e;let t=new iS(0,-1,0);return this.nodes.push(t),t}addBlock(e){this.enterLine();let t=e.deco;t&&t.startSide>0&&!this.isCovered&&this.ensureLine(),this.nodes.push(e),this.writtenTo=this.pos=this.pos+e.length,t&&t.endSide>0&&(this.covering=e)}addLineDeco(e,t,n){let r=this.ensureLine();r.length+=n,r.collapsed+=n,r.widgetHeight=Math.max(r.widgetHeight,e),r.breaks+=t,this.writtenTo=this.pos=this.pos+n}finish(e){let t=0==this.nodes.length?null:this.nodes[this.nodes.length-1];!(this.lineStart>-1)||t instanceof iS||this.isCovered?(this.writtenTo<this.pos||null==t)&&this.nodes.push(this.blankContent(this.writtenTo,this.pos)):this.nodes.push(new iS(0,-1,0));let n=e;for(let e of this.nodes)e instanceof iS&&e.updateHeight(this.oracle,n),n+=e?e.length:1;return this.nodes}static build(e,t,n,r){let i=new lS(n,e);return rx.spans(t,n,r,i,0),i.finish(n)}}class cS{constructor(){this.changes=[]}compareRange(){}comparePoint(e,t,n,r){(e<t||n&&n.heightRelevant||r&&r.heightRelevant)&&tw(e,t,this.changes,5)}}function dS(e,t){let n=e.getBoundingClientRect(),r=e.ownerDocument,i=r.defaultView||window,o=Math.max(0,n.left),s=Math.min(i.innerWidth,n.right),a=Math.max(0,n.top),l=Math.min(i.innerHeight,n.bottom);for(let t=e.parentNode;t&&t!=r.body;)if(1==t.nodeType){let n=t,r=window.getComputedStyle(n);if((n.scrollHeight>n.clientHeight||n.scrollWidth>n.clientWidth)&&"visible"!=r.overflow){let r=n.getBoundingClientRect();o=Math.max(o,r.left),s=Math.min(s,r.right),a=Math.max(a,r.top),l=Math.min(t==e.parentNode?i.innerHeight:l,r.bottom)}t="absolute"==r.position||"fixed"==r.position?n.offsetParent:n.parentNode}else{if(11!=t.nodeType)break;t=t.host}return{left:o-n.left,right:Math.max(o,s)-n.left,top:a-(n.top+t),bottom:Math.max(a,l)-(n.top+t)}}function hS(e,t){let n=e.getBoundingClientRect();return{left:0,right:n.right-n.left,top:t,bottom:n.bottom-(n.top+t)}}class uS{constructor(e,t,n,r){this.from=e,this.to=t,this.size=n,this.displaySize=r}static same(e,t){if(e.length!=t.length)return!1;for(let n=0;n<e.length;n++){let r=e[n],i=t[n];if(r.from!=i.from||r.to!=i.to||r.size!=i.size)return!1}return!0}draw(e,t){return Xx.replace({widget:new pS(this.displaySize*(t?e.scaleY:e.scaleX),t)}).range(this.from,this.to)}}class pS extends Gx{constructor(e,t){super(),this.size=e,this.vertical=t}eq(e){return e.size==this.size&&e.vertical==this.vertical}toDOM(){let e=document.createElement("div");return this.vertical?e.style.height=this.size+"px":(e.style.width=this.size+"px",e.style.height="2px",e.style.display="inline-block"),e}get estimatedHeight(){return this.vertical?this.size:-1}}class fS{constructor(e){this.state=e,this.pixelViewport={left:0,right:window.innerWidth,top:0,bottom:0},this.inView=!0,this.paddingTop=0,this.paddingBottom=0,this.contentDOMWidth=0,this.contentDOMHeight=0,this.editorHeight=0,this.editorWidth=0,this.scrollTop=0,this.scrolledToBottom=!1,this.scaleX=1,this.scaleY=1,this.scrollAnchorPos=0,this.scrollAnchorHeight=-1,this.scaler=AS,this.scrollTarget=null,this.printing=!1,this.mustMeasureContent=!0,this.defaultTextDirection=Sw.LTR,this.visibleRanges=[],this.mustEnforceCursorAssoc=!1;let t=e.facet(pC).some(e=>"function"!=typeof e&&"cm-lineWrapping"==e.class);this.heightOracle=new Yk(t),this.stateDeco=bS(e),this.heightMap=eS.empty().applyChanges(this.stateDeco,Rb.empty,this.heightOracle.setDoc(e.doc),[new CC(0,0,0,e.doc.length)]);for(let e=0;e<2&&(this.viewport=this.getViewport(0,null),this.updateForViewport());e++);this.updateViewportLines(),this.lineGaps=this.ensureLineGaps([]),this.lineGapDeco=Xx.set(this.lineGaps.map(e=>e.draw(this,!1))),this.computeVisibleRanges()}updateForViewport(){let e=[this.viewport],{main:t}=this.state.selection;for(let n=0;n<=1;n++){let r=n?t.head:t.anchor;if(!e.some(({from:e,to:t})=>r>=e&&r<=t)){let{from:t,to:n}=this.lineBlockAt(r);e.push(new gS(t,n))}}return this.viewports=e.sort((e,t)=>e.from-t.from),this.updateScaler()}updateScaler(){let e=this.scaler;return this.scaler=this.heightMap.height<=7e6?AS:new yS(this.heightOracle,this.heightMap,this.viewports),e.eq(this.scaler)?0:2}updateViewportLines(){this.viewportLines=[],this.heightMap.forEachLine(this.viewport.from,this.viewport.to,this.heightOracle.setDoc(this.state.doc),0,0,e=>{this.viewportLines.push(xS(e,this.scaler))})}update(e,t=null){this.state=e.state;let n=this.stateDeco;this.stateDeco=bS(this.state);let r=e.changedRanges,i=CC.extendWithRanges(r,function(e,t,n){let r=new cS;return rx.compare(e,t,n,r,0),r.changes}(n,this.stateDeco,e?e.changes:Jb.empty(this.state.doc.length))),o=this.heightMap.height,s=this.scrolledToBottom?null:this.scrollAnchorAt(this.scrollTop);Gk(),this.heightMap=this.heightMap.applyChanges(this.stateDeco,e.startState.doc,this.heightOracle.setDoc(this.state.doc),i),(this.heightMap.height!=o||Uk)&&(e.flags|=2),s?(this.scrollAnchorPos=e.changes.mapPos(s.from,-1),this.scrollAnchorHeight=s.top):(this.scrollAnchorPos=-1,this.scrollAnchorHeight=o);let a=i.length?this.mapViewport(this.viewport,e.changes):this.viewport;(t&&(t.range.head<a.from||t.range.head>a.to)||!this.viewportIsAppropriate(a))&&(a=this.getViewport(0,t));let l=a.from!=this.viewport.from||a.to!=this.viewport.to;this.viewport=a,e.flags|=this.updateForViewport(),(l||!e.changes.empty||2&e.flags)&&this.updateViewportLines(),(this.lineGaps.length||this.viewport.to-this.viewport.from>4e3)&&this.updateLineGaps(this.ensureLineGaps(this.mapLineGaps(this.lineGaps,e.changes))),e.flags|=this.computeVisibleRanges(e.changes),t&&(this.scrollTarget=t),!this.mustEnforceCursorAssoc&&(e.selectionSet||e.focusChanged)&&e.view.lineWrapping&&e.state.selection.main.empty&&e.state.selection.main.assoc&&!e.state.facet(tC)&&(this.mustEnforceCursorAssoc=!0)}measure(e){let t=e.contentDOM,n=window.getComputedStyle(t),r=this.heightOracle,i=n.whiteSpace;this.defaultTextDirection="rtl"==n.direction?Sw.RTL:Sw.LTR;let o=this.heightOracle.mustRefreshForWrapping(i)||this.mustMeasureContent,s=t.getBoundingClientRect(),a=o||this.mustMeasureContent||this.contentDOMHeight!=s.height;this.contentDOMHeight=s.height,this.mustMeasureContent=!1;let l=0,c=0;if(s.width&&s.height){let{scaleX:e,scaleY:n}=fw(t,s);(e>.005&&Math.abs(this.scaleX-e)>.005||n>.005&&Math.abs(this.scaleY-n)>.005)&&(this.scaleX=e,this.scaleY=n,l|=16,o=a=!0)}let d=(parseInt(n.paddingTop)||0)*this.scaleY,h=(parseInt(n.paddingBottom)||0)*this.scaleY;this.paddingTop==d&&this.paddingBottom==h||(this.paddingTop=d,this.paddingBottom=h,l|=18),this.editorWidth!=e.scrollDOM.clientWidth&&(r.lineWrapping&&(a=!0),this.editorWidth=e.scrollDOM.clientWidth,l|=16);let u=e.scrollDOM.scrollTop*this.scaleY;this.scrollTop!=u&&(this.scrollAnchorHeight=-1,this.scrollTop=u),this.scrolledToBottom=xw(e.scrollDOM);let p=(this.printing?hS:dS)(t,this.paddingTop),f=p.top-this.pixelViewport.top,g=p.bottom-this.pixelViewport.bottom;this.pixelViewport=p;let m=this.pixelViewport.bottom>this.pixelViewport.top&&this.pixelViewport.right>this.pixelViewport.left;if(m!=this.inView&&(this.inView=m,m&&(a=!0)),!this.inView&&!this.scrollTarget&&!function(e){let t=e.getBoundingClientRect(),n=e.ownerDocument.defaultView||window;return t.left<n.innerWidth&&t.right>0&&t.top<n.innerHeight&&t.bottom>0}(e.dom))return 0;let v=s.width;if(this.contentDOMWidth==v&&this.editorHeight==e.scrollDOM.clientHeight||(this.contentDOMWidth=s.width,this.editorHeight=e.scrollDOM.clientHeight,l|=16),a){let t=e.docView.measureVisibleLineHeights(this.viewport);if(r.mustRefreshForHeights(t)&&(o=!0),o||r.lineWrapping&&Math.abs(v-this.contentDOMWidth)>r.charWidth){let{lineHeight:n,charWidth:s,textHeight:a}=e.docView.measureTextSize();o=n>0&&r.refresh(i,n,s,a,Math.max(5,v/s),t),o&&(e.docView.minWidth=0,l|=16)}f>0&&g>0?c=Math.max(f,g):f<0&&g<0&&(c=Math.min(f,g)),Gk();for(let n of this.viewports){let i=n.from==this.viewport.from?t:e.docView.measureVisibleLineHeights(n);this.heightMap=(o?eS.empty().applyChanges(this.stateDeco,Rb.empty,this.heightOracle,[new CC(0,0,0,e.state.doc.length)]):this.heightMap).updateHeight(r,0,o,new Xk(n.from,i))}Uk&&(l|=2)}let A=!this.viewportIsAppropriate(this.viewport,c)||this.scrollTarget&&(this.scrollTarget.range.head<this.viewport.from||this.scrollTarget.range.head>this.viewport.to);return A&&(2&l&&(l|=this.updateScaler()),this.viewport=this.getViewport(c,this.scrollTarget),l|=this.updateForViewport()),(2&l||A)&&this.updateViewportLines(),(this.lineGaps.length||this.viewport.to-this.viewport.from>4e3)&&this.updateLineGaps(this.ensureLineGaps(o?[]:this.lineGaps,e)),l|=this.computeVisibleRanges(),this.mustEnforceCursorAssoc&&(this.mustEnforceCursorAssoc=!1,e.docView.enforceCursorAssoc()),l}get visibleTop(){return this.scaler.fromDOM(this.pixelViewport.top)}get visibleBottom(){return this.scaler.fromDOM(this.pixelViewport.bottom)}getViewport(e,t){let n=.5-Math.max(-.5,Math.min(.5,e/1e3/2)),r=this.heightMap,i=this.heightOracle,{visibleTop:o,visibleBottom:s}=this,a=new gS(r.lineAt(o-1e3*n,Kk.ByHeight,i,0,0).from,r.lineAt(s+1e3*(1-n),Kk.ByHeight,i,0,0).to);if(t){let{head:e}=t.range;if(e<a.from||e>a.to){let n,o=Math.min(this.editorHeight,this.pixelViewport.bottom-this.pixelViewport.top),s=r.lineAt(e,Kk.ByPos,i,0,0);n="center"==t.y?(s.top+s.bottom)/2-o/2:"start"==t.y||"nearest"==t.y&&e<a.from?s.top:s.bottom-o,a=new gS(r.lineAt(n-500,Kk.ByHeight,i,0,0).from,r.lineAt(n+o+500,Kk.ByHeight,i,0,0).to)}}return a}mapViewport(e,t){let n=t.mapPos(e.from,-1),r=t.mapPos(e.to,1);return new gS(this.heightMap.lineAt(n,Kk.ByPos,this.heightOracle,0,0).from,this.heightMap.lineAt(r,Kk.ByPos,this.heightOracle,0,0).to)}viewportIsAppropriate({from:e,to:t},n=0){if(!this.inView)return!0;let{top:r}=this.heightMap.lineAt(e,Kk.ByPos,this.heightOracle,0,0),{bottom:i}=this.heightMap.lineAt(t,Kk.ByPos,this.heightOracle,0,0),{visibleTop:o,visibleBottom:s}=this;return(0==e||r<=o-Math.max(10,Math.min(-n,250)))&&(t==this.state.doc.length||i>=s+Math.max(10,Math.min(n,250)))&&r>o-2e3&&i<s+2e3}mapLineGaps(e,t){if(!e.length||t.empty)return e;let n=[];for(let r of e)t.touchesRange(r.from,r.to)||n.push(new uS(t.mapPos(r.from),t.mapPos(r.to),r.size,r.displaySize));return n}ensureLineGaps(e,t){let n=this.heightOracle.lineWrapping,r=n?1e4:2e3,i=r>>1,o=r<<1;if(this.defaultTextDirection!=Sw.LTR&&!n)return[];let s=[],a=(r,o,l,c)=>{if(o-r<i)return;let d=this.state.selection.main,h=[d.from];d.empty||h.push(d.to);for(let e of h)if(e>r&&e<o)return a(r,e-10,l,c),void a(e+10,o,l,c);let u=function(e,t){for(let n of e)if(t(n))return n;return}(e,e=>e.from>=l.from&&e.to<=l.to&&Math.abs(e.from-r)<i&&Math.abs(e.to-o)<i&&!h.some(t=>e.from<t&&e.to>t));if(!u){if(o<l.to&&t&&n&&t.visibleRanges.some(e=>e.from<=o&&e.to>=o)){let e=t.moveToLineBoundary(oy.cursor(o),!1,!0).head;e>r&&(o=e)}let e=this.gapSize(l,r,o,c);u=new uS(r,o,e,n||e<2e6?e:2e6)}s.push(u)},l=t=>{if(t.length<o||t.type!=Yx.Text)return;let i=function(e,t,n){let r=[],i=e,o=0;rx.spans(n,e,t,{span(){},point(e,t){e>i&&(r.push({from:i,to:e}),o+=e-i),i=t}},20),i<t&&(r.push({from:i,to:t}),o+=t-i);return{total:o,ranges:r}}(t.from,t.to,this.stateDeco);if(i.total<o)return;let s,l,c=this.scrollTarget?this.scrollTarget.range.head:null;if(n){let e,n,o=r/this.heightOracle.lineLength*this.heightOracle.lineHeight;if(null!=c){let r=vS(i,c),s=((this.visibleBottom-this.visibleTop)/2+o)/t.height;e=r-s,n=r+s}else e=(this.visibleTop-t.top-o)/t.height,n=(this.visibleBottom-t.top+o)/t.height;s=mS(i,e),l=mS(i,n)}else{let n=i.total*this.heightOracle.charWidth,o=r*this.heightOracle.charWidth,a=0;if(n>2e6)for(let n of e)n.from>=t.from&&n.from<t.to&&n.size!=n.displaySize&&n.from*this.heightOracle.charWidth+a<this.pixelViewport.left&&(a=n.size-n.displaySize);let d,h,u=this.pixelViewport.left+a,p=this.pixelViewport.right+a;if(null!=c){let e=vS(i,c),t=((p-u)/2+o)/n;d=e-t,h=e+t}else d=(u-o)/n,h=(p+o)/n;s=mS(i,d),l=mS(i,h)}s>t.from&&a(t.from,s,t,i),l<t.to&&a(l,t.to,t,i)};for(let e of this.viewportLines)Array.isArray(e.type)?e.type.forEach(l):l(e);return s}gapSize(e,t,n,r){let i=vS(r,n)-vS(r,t);return this.heightOracle.lineWrapping?e.height*i:r.total*this.heightOracle.charWidth*i}updateLineGaps(e){uS.same(e,this.lineGaps)||(this.lineGaps=e,this.lineGapDeco=Xx.set(e.map(e=>e.draw(this,this.heightOracle.lineWrapping))))}computeVisibleRanges(e){let t=this.stateDeco;this.lineGaps.length&&(t=t.concat(this.lineGapDeco));let n=[];rx.spans(t,this.viewport.from,this.viewport.to,{span(e,t){n.push({from:e,to:t})},point(){}},20);let r=0;if(n.length!=this.visibleRanges.length)r=12;else for(let t=0;t<n.length&&!(8&r);t++){let i=this.visibleRanges[t],o=n[t];i.from==o.from&&i.to==o.to||(r|=4,e&&e.mapPos(i.from,-1)==o.from&&e.mapPos(i.to,1)==o.to||(r|=8))}return this.visibleRanges=n,r}lineBlockAt(e){return e>=this.viewport.from&&e<=this.viewport.to&&this.viewportLines.find(t=>t.from<=e&&t.to>=e)||xS(this.heightMap.lineAt(e,Kk.ByPos,this.heightOracle,0,0),this.scaler)}lineBlockAtHeight(e){return e>=this.viewportLines[0].top&&e<=this.viewportLines[this.viewportLines.length-1].bottom&&this.viewportLines.find(t=>t.top<=e&&t.bottom>=e)||xS(this.heightMap.lineAt(this.scaler.fromDOM(e),Kk.ByHeight,this.heightOracle,0,0),this.scaler)}scrollAnchorAt(e){let t=this.lineBlockAtHeight(e+8);return t.from>=this.viewport.from||this.viewportLines[0].top-e>200?t:this.viewportLines[0]}elementAtHeight(e){return xS(this.heightMap.blockAt(this.scaler.fromDOM(e),this.heightOracle,0,0),this.scaler)}get docHeight(){return this.scaler.toDOM(this.heightMap.height)}get contentHeight(){return this.docHeight+this.paddingTop+this.paddingBottom}}class gS{constructor(e,t){this.from=e,this.to=t}}function mS({total:e,ranges:t},n){if(n<=0)return t[0].from;if(n>=1)return t[t.length-1].to;let r=Math.floor(e*n);for(let e=0;;e++){let{from:n,to:i}=t[e],o=i-n;if(r<=o)return n+r;r-=o}}function vS(e,t){let n=0;for(let{from:r,to:i}of e.ranges){if(t<=i){n+=t-r;break}n+=i-r}return n/e.total}const AS={toDOM:e=>e,fromDOM:e=>e,scale:1,eq(e){return e==this}};function bS(e){let t=e.facet(fC).filter(e=>"function"!=typeof e),n=e.facet(mC).filter(e=>"function"!=typeof e);return n.length&&t.push(rx.join(n)),t}class yS{constructor(e,t,n){let r=0,i=0,o=0;this.viewports=n.map(({from:n,to:i})=>{let o=t.lineAt(n,Kk.ByPos,e,0,0).top,s=t.lineAt(i,Kk.ByPos,e,0,0).bottom;return r+=s-o,{from:n,to:i,top:o,bottom:s,domTop:0,domBottom:0}}),this.scale=(7e6-r)/(t.height-r);for(let e of this.viewports)e.domTop=o+(e.top-i)*this.scale,o=e.domBottom=e.domTop+(e.bottom-e.top),i=e.bottom}toDOM(e){for(let t=0,n=0,r=0;;t++){let i=t<this.viewports.length?this.viewports[t]:null;if(!i||e<i.top)return r+(e-n)*this.scale;if(e<=i.bottom)return i.domTop+(e-i.top);n=i.bottom,r=i.domBottom}}fromDOM(e){for(let t=0,n=0,r=0;;t++){let i=t<this.viewports.length?this.viewports[t]:null;if(!i||e<i.domTop)return n+(e-r)/this.scale;if(e<=i.domBottom)return i.top+(e-i.domTop);n=i.bottom,r=i.domBottom}}eq(e){return e instanceof yS&&(this.scale==e.scale&&this.viewports.length==e.viewports.length&&this.viewports.every((t,n)=>t.from==e.viewports[n].from&&t.to==e.viewports[n].to))}}function xS(e,t){if(1==t.scale)return e;let n=t.toDOM(e.top),r=t.toDOM(e.bottom);return new Jk(e.from,e.length,n,r-n,Array.isArray(e._content)?e._content.map(e=>xS(e,t)):e._content)}const wS=ly.define({combine:e=>e.join(" ")}),CS=ly.define({combine:e=>e.indexOf(!0)>-1}),kS=yx.newName(),SS=yx.newName(),OS=yx.newName(),BS={"&light":"."+SS,"&dark":"."+OS};function _S(e,t,n){return new yx(t,{finish:t=>/&/.test(t)?t.replace(/&\w*/,t=>{if("&"==t)return e;if(!n||!n[t])throw new RangeError(`Unsupported selector: ${t}`);return n[t]}):e+" "+t})}const TS=_S("."+kS,{"&":{position:"relative !important",boxSizing:"border-box","&.cm-focused":{outline:"1px dotted #212121"},display:"flex !important",flexDirection:"column"},".cm-scroller":{display:"flex !important",alignItems:"flex-start !important",fontFamily:"monospace",lineHeight:1.4,height:"100%",overflowX:"auto",position:"relative",zIndex:0,overflowAnchor:"none"},".cm-content":{margin:0,flexGrow:2,flexShrink:0,display:"block",whiteSpace:"pre",wordWrap:"normal",boxSizing:"border-box",minHeight:"100%",padding:"4px 0",outline:"none","&[contenteditable=true]":{WebkitUserModify:"read-write-plaintext-only"}},".cm-lineWrapping":{whiteSpace_fallback:"pre-wrap",whiteSpace:"break-spaces",wordBreak:"break-word",overflowWrap:"anywhere",flexShrink:1},"&light .cm-content":{caretColor:"black"},"&dark .cm-content":{caretColor:"white"},".cm-line":{display:"block",padding:"0 2px 0 6px"},".cm-layer":{position:"absolute",left:0,top:0,contain:"size style","& > *":{position:"absolute"}},"&light .cm-selectionBackground":{background:"#d9d9d9"},"&dark .cm-selectionBackground":{background:"#222"},"&light.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground":{background:"#d7d4f0"},"&dark.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground":{background:"#233"},".cm-cursorLayer":{pointerEvents:"none"},"&.cm-focused > .cm-scroller > .cm-cursorLayer":{animation:"steps(1) cm-blink 1.2s infinite"},"@keyframes cm-blink":{"0%":{},"50%":{opacity:0},"100%":{}},"@keyframes cm-blink2":{"0%":{},"50%":{opacity:0},"100%":{}},".cm-cursor, .cm-dropCursor":{borderLeft:"1.2px solid black",marginLeft:"-0.6px",pointerEvents:"none"},".cm-cursor":{display:"none"},"&dark .cm-cursor":{borderLeftColor:"#ddd"},".cm-dropCursor":{position:"absolute"},"&.cm-focused > .cm-scroller > .cm-cursorLayer .cm-cursor":{display:"block"},".cm-iso":{unicodeBidi:"isolate"},".cm-announced":{position:"fixed",top:"-10000px"},"@media print":{".cm-announced":{display:"none"}},"&light .cm-activeLine":{backgroundColor:"#cceeff44"},"&dark .cm-activeLine":{backgroundColor:"#99eeff33"},"&light .cm-specialChar":{color:"red"},"&dark .cm-specialChar":{color:"#f78"},".cm-gutters":{flexShrink:0,display:"flex",height:"100%",boxSizing:"border-box",zIndex:200},".cm-gutters-before":{insetInlineStart:0},".cm-gutters-after":{insetInlineEnd:0},"&light .cm-gutters":{backgroundColor:"#f5f5f5",color:"#6c6c6c",border:"0px solid #ddd","&.cm-gutters-before":{borderRightWidth:"1px"},"&.cm-gutters-after":{borderLeftWidth:"1px"}},"&dark .cm-gutters":{backgroundColor:"#333338",color:"#ccc"},".cm-gutter":{display:"flex !important",flexDirection:"column",flexShrink:0,boxSizing:"border-box",minHeight:"100%",overflow:"hidden"},".cm-gutterElement":{boxSizing:"border-box"},".cm-lineNumbers .cm-gutterElement":{padding:"0 3px 0 5px",minWidth:"20px",textAlign:"right",whiteSpace:"nowrap"},"&light .cm-activeLineGutter":{backgroundColor:"#e2f2ff"},"&dark .cm-activeLineGutter":{backgroundColor:"#222227"},".cm-panels":{boxSizing:"border-box",position:"sticky",left:0,right:0,zIndex:300},"&light .cm-panels":{backgroundColor:"#f5f5f5",color:"black"},"&light .cm-panels-top":{borderBottom:"1px solid #ddd"},"&light .cm-panels-bottom":{borderTop:"1px solid #ddd"},"&dark .cm-panels":{backgroundColor:"#333338",color:"white"},".cm-dialog":{padding:"2px 19px 4px 6px",position:"relative","& label":{fontSize:"80%"}},".cm-dialog-close":{position:"absolute",top:"3px",right:"4px",backgroundColor:"inherit",border:"none",font:"inherit",fontSize:"14px",padding:"0"},".cm-tab":{display:"inline-block",overflow:"hidden",verticalAlign:"bottom"},".cm-widgetBuffer":{verticalAlign:"text-top",height:"1em",width:0,display:"inline"},".cm-placeholder":{color:"#888",display:"inline-block",verticalAlign:"top",userSelect:"none"},".cm-highlightSpace":{backgroundImage:"radial-gradient(circle at 50% 55%, #aaa 20%, transparent 5%)",backgroundPosition:"center"},".cm-highlightTab":{backgroundImage:'url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="200" height="20"><path stroke="%23888" stroke-width="1" fill="none" d="M1 10H196L190 5M190 15L196 10M197 4L197 16"/></svg>\')',backgroundSize:"auto 100%",backgroundPosition:"right 90%",backgroundRepeat:"no-repeat"},".cm-trailingSpace":{backgroundColor:"#ff332255"},".cm-button":{verticalAlign:"middle",color:"inherit",fontSize:"70%",padding:".2em 1em",borderRadius:"1px"},"&light .cm-button":{backgroundImage:"linear-gradient(#eff1f5, #d9d9df)",border:"1px solid #888","&:active":{backgroundImage:"linear-gradient(#b4b4b4, #d0d3d6)"}},"&dark .cm-button":{backgroundImage:"linear-gradient(#393939, #111)",border:"1px solid #888","&:active":{backgroundImage:"linear-gradient(#111, #333)"}},".cm-textfield":{verticalAlign:"middle",color:"inherit",fontSize:"70%",border:"1px solid silver",padding:".2em .5em"},"&light .cm-textfield":{backgroundColor:"white"},"&dark .cm-textfield":{border:"1px solid #555",backgroundColor:"inherit"}},BS),ES={childList:!0,characterData:!0,subtree:!0,attributes:!0,characterDataOldValue:!0},MS=Wx.ie&&Wx.ie_version<=11;class DS{constructor(e){this.view=e,this.active=!1,this.editContext=null,this.selectionRange=new gw,this.selectionChanged=!1,this.delayedFlush=-1,this.resizeTimeout=-1,this.queue=[],this.delayedAndroidKey=null,this.flushingAndroidKey=-1,this.lastChange=0,this.scrollTargets=[],this.intersection=null,this.resizeScroll=null,this.intersecting=!1,this.gapIntersection=null,this.gaps=[],this.printQuery=null,this.parentCheck=-1,this.dom=e.contentDOM,this.observer=new MutationObserver(t=>{for(let e of t)this.queue.push(e);(Wx.ie&&Wx.ie_version<=11||Wx.ios&&e.composing)&&t.some(e=>"childList"==e.type&&e.removedNodes.length||"characterData"==e.type&&e.oldValue.length>e.target.nodeValue.length)?this.flushSoon():this.flush()}),!window.EditContext||!Wx.android||!1===e.constructor.EDIT_CONTEXT||Wx.chrome&&Wx.chrome_version<126||(this.editContext=new IS(e),e.state.facet(aC)&&(e.contentDOM.editContext=this.editContext.editContext)),MS&&(this.onCharData=e=>{this.queue.push({target:e.target,type:"characterData",oldValue:e.prevValue}),this.flushSoon()}),this.onSelectionChange=this.onSelectionChange.bind(this),this.onResize=this.onResize.bind(this),this.onPrint=this.onPrint.bind(this),this.onScroll=this.onScroll.bind(this),window.matchMedia&&(this.printQuery=window.matchMedia("print")),"function"==typeof ResizeObserver&&(this.resizeScroll=new ResizeObserver(()=>{var e;(null===(e=this.view.docView)||void 0===e?void 0:e.lastUpdate)<Date.now()-75&&this.onResize()}),this.resizeScroll.observe(e.scrollDOM)),this.addWindowListeners(this.win=e.win),this.start(),"function"==typeof IntersectionObserver&&(this.intersection=new IntersectionObserver(e=>{this.parentCheck<0&&(this.parentCheck=setTimeout(this.listenForScroll.bind(this),1e3)),e.length>0&&e[e.length-1].intersectionRatio>0!=this.intersecting&&(this.intersecting=!this.intersecting,this.intersecting!=this.view.inView&&this.onScrollChanged(document.createEvent("Event")))},{threshold:[0,.001]}),this.intersection.observe(this.dom),this.gapIntersection=new IntersectionObserver(e=>{e.length>0&&e[e.length-1].intersectionRatio>0&&this.onScrollChanged(document.createEvent("Event"))},{})),this.listenForScroll(),this.readSelectionRange()}onScrollChanged(e){this.view.inputState.runHandlers("scroll",e),this.intersecting&&this.view.measure()}onScroll(e){this.intersecting&&this.flush(!1),this.editContext&&this.view.requestMeasure(this.editContext.measureReq),this.onScrollChanged(e)}onResize(){this.resizeTimeout<0&&(this.resizeTimeout=setTimeout(()=>{this.resizeTimeout=-1,this.view.requestMeasure()},50))}onPrint(e){("change"!=e.type&&e.type||e.matches)&&(this.view.viewState.printing=!0,this.view.measure(),setTimeout(()=>{this.view.viewState.printing=!1,this.view.requestMeasure()},500))}updateGaps(e){if(this.gapIntersection&&(e.length!=this.gaps.length||this.gaps.some((t,n)=>t!=e[n]))){this.gapIntersection.disconnect();for(let t of e)this.gapIntersection.observe(t);this.gaps=e}}onSelectionChange(e){let t=this.selectionChanged;if(!this.readSelectionRange()||this.delayedAndroidKey)return;let{view:n}=this,r=this.selectionRange;if(n.state.facet(aC)?n.root.activeElement!=this.dom:!ow(this.dom,r))return;let i=r.anchorNode&&n.docView.tile.nearest(r.anchorNode);i&&i.isWidget()&&i.widget.ignoreEvent(e)?t||(this.selectionChanged=!1):(Wx.ie&&Wx.ie_version<=11||Wx.android&&Wx.chrome)&&!n.state.selection.main.empty&&r.focusNode&&aw(r.focusNode,r.focusOffset,r.anchorNode,r.anchorOffset)?this.flushSoon():this.flush(!1)}readSelectionRange(){let{view:e}=this,t=rw(e.root);if(!t)return!1;let n=Wx.safari&&11==e.root.nodeType&&e.root.activeElement==this.dom&&function(e,t){if(t.getComposedRanges){let n=t.getComposedRanges(e.root)[0];if(n)return RS(e,n)}let n=null;function r(e){e.preventDefault(),e.stopImmediatePropagation(),n=e.getTargetRanges()[0]}return e.contentDOM.addEventListener("beforeinput",r,!0),e.dom.ownerDocument.execCommand("indent"),e.contentDOM.removeEventListener("beforeinput",r,!0),n?RS(e,n):null}(this.view,t)||t;if(!n||this.selectionRange.eq(n))return!1;let r=ow(this.dom,n);return r&&!this.selectionChanged&&e.inputState.lastFocusTime>Date.now()-200&&e.inputState.lastTouchTime<Date.now()-300&&function(e,t){let n=t.focusNode,r=t.focusOffset;if(!n||t.anchorNode!=n||t.anchorOffset!=r)return!1;for(r=Math.min(r,hw(n));;)if(r){if(1!=n.nodeType)return!1;let e=n.childNodes[r-1];"false"==e.contentEditable?r--:(n=e,r=hw(n))}else{if(n==e)return!0;r=lw(n),n=n.parentNode}}(this.dom,n)?(this.view.inputState.lastFocusTime=0,e.docView.updateSelection(),!1):(this.selectionRange.setRange(n),r&&(this.selectionChanged=!0),!0)}setSelectionRange(e,t){this.selectionRange.set(e.node,e.offset,t.node,t.offset),this.selectionChanged=!1}clearSelectionRange(){this.selectionRange.set(null,0,null,0)}listenForScroll(){this.parentCheck=-1;let e=0,t=null;for(let n=this.dom;n;)if(1==n.nodeType)!t&&e<this.scrollTargets.length&&this.scrollTargets[e]==n?e++:t||(t=this.scrollTargets.slice(0,e)),t&&t.push(n),n=n.assignedSlot||n.parentNode;else{if(11!=n.nodeType)break;n=n.host}if(e<this.scrollTargets.length&&!t&&(t=this.scrollTargets.slice(0,e)),t){for(let e of this.scrollTargets)e.removeEventListener("scroll",this.onScroll);for(let e of this.scrollTargets=t)e.addEventListener("scroll",this.onScroll)}}ignore(e){if(!this.active)return e();try{return this.stop(),e()}finally{this.start(),this.clear()}}start(){this.active||(this.observer.observe(this.dom,ES),MS&&this.dom.addEventListener("DOMCharacterDataModified",this.onCharData),this.active=!0)}stop(){this.active&&(this.active=!1,this.observer.disconnect(),MS&&this.dom.removeEventListener("DOMCharacterDataModified",this.onCharData))}clear(){this.processRecords(),this.queue.length=0,this.selectionChanged=!1}delayAndroidKey(e,t){var n;if(!this.delayedAndroidKey){let e=()=>{let e=this.delayedAndroidKey;if(e){this.clearDelayedAndroidKey(),this.view.inputState.lastKeyCode=e.keyCode,this.view.inputState.lastKeyTime=Date.now(),!this.flush()&&e.force&&yw(this.dom,e.key,e.keyCode)}};this.flushingAndroidKey=this.view.win.requestAnimationFrame(e)}this.delayedAndroidKey&&"Enter"!=e||(this.delayedAndroidKey={key:e,keyCode:t,force:this.lastChange<Date.now()-50||!!(null===(n=this.delayedAndroidKey)||void 0===n?void 0:n.force)})}clearDelayedAndroidKey(){this.win.cancelAnimationFrame(this.flushingAndroidKey),this.delayedAndroidKey=null,this.flushingAndroidKey=-1}flushSoon(){this.delayedFlush<0&&(this.delayedFlush=this.view.win.requestAnimationFrame(()=>{this.delayedFlush=-1,this.flush()}))}forceFlush(){this.delayedFlush>=0&&(this.view.win.cancelAnimationFrame(this.delayedFlush),this.delayedFlush=-1),this.flush()}pendingRecords(){for(let e of this.observer.takeRecords())this.queue.push(e);return this.queue}processRecords(){let e=this.pendingRecords();e.length&&(this.queue=[]);let t=-1,n=-1,r=!1;for(let i of e){let e=this.readMutation(i);e&&(e.typeOver&&(r=!0),-1==t?({from:t,to:n}=e):(t=Math.min(e.from,t),n=Math.max(e.to,n)))}return{from:t,to:n,typeOver:r}}readChange(){let{from:e,to:t,typeOver:n}=this.processRecords(),r=this.selectionChanged&&ow(this.dom,this.selectionRange);if(e<0&&!r)return null;e>-1&&(this.lastChange=Date.now()),this.view.inputState.lastFocusTime=0,this.selectionChanged=!1;let i=new gk(this.view,e,t,n);return this.view.docView.domChanged={newSel:i.newSel?i.newSel.main:null},i}flush(e=!0){if(this.delayedFlush>=0||this.delayedAndroidKey)return!1;e&&this.readSelectionRange();let t=this.readChange();if(!t)return this.view.requestMeasure(),!1;let n=this.view.state,r=vk(this.view,t);return this.view.state==n&&(t.domChanged||t.newSel&&!yk(this.view.state.selection,t.newSel.main))&&this.view.update([]),r}readMutation(e){let t=this.view.docView.tile.nearest(e.target);if(!t||t.isWidget())return null;if(t.markDirty("attributes"==e.type),"childList"==e.type){let n=PS(t,e.previousSibling||e.target.previousSibling,-1),r=PS(t,e.nextSibling||e.target.nextSibling,1);return{from:n?t.posAfter(n):t.posAtStart,to:r?t.posBefore(r):t.posAtEnd,typeOver:!1}}return"characterData"==e.type?{from:t.posAtStart,to:t.posAtEnd,typeOver:e.target.nodeValue==e.oldValue}:null}setWindow(e){e!=this.win&&(this.removeWindowListeners(this.win),this.win=e,this.addWindowListeners(this.win))}addWindowListeners(e){e.addEventListener("resize",this.onResize),this.printQuery?this.printQuery.addEventListener?this.printQuery.addEventListener("change",this.onPrint):this.printQuery.addListener(this.onPrint):e.addEventListener("beforeprint",this.onPrint),e.addEventListener("scroll",this.onScroll),e.document.addEventListener("selectionchange",this.onSelectionChange)}removeWindowListeners(e){e.removeEventListener("scroll",this.onScroll),e.removeEventListener("resize",this.onResize),this.printQuery?this.printQuery.removeEventListener?this.printQuery.removeEventListener("change",this.onPrint):this.printQuery.removeListener(this.onPrint):e.removeEventListener("beforeprint",this.onPrint),e.document.removeEventListener("selectionchange",this.onSelectionChange)}update(e){this.editContext&&(this.editContext.update(e),e.startState.facet(aC)!=e.state.facet(aC)&&(e.view.contentDOM.editContext=e.state.facet(aC)?this.editContext.editContext:null))}destroy(){var e,t,n;this.stop(),null===(e=this.intersection)||void 0===e||e.disconnect(),null===(t=this.gapIntersection)||void 0===t||t.disconnect(),null===(n=this.resizeScroll)||void 0===n||n.disconnect();for(let e of this.scrollTargets)e.removeEventListener("scroll",this.onScroll);this.removeWindowListeners(this.win),clearTimeout(this.parentCheck),clearTimeout(this.resizeTimeout),this.win.cancelAnimationFrame(this.delayedFlush),this.win.cancelAnimationFrame(this.flushingAndroidKey),this.editContext&&(this.view.contentDOM.editContext=null,this.editContext.destroy())}}function PS(e,t,n){for(;t;){let r=OC.get(t);if(r&&r.parent==e)return r;let i=t.parentNode;t=i!=e.dom?i:n>0?t.nextSibling:t.previousSibling}return null}function RS(e,t){let n=t.startContainer,r=t.startOffset,i=t.endContainer,o=t.endOffset,s=e.docView.domAtPos(e.state.selection.main.anchor,1);return aw(s.node,s.offset,i,o)&&([n,r,i,o]=[i,o,n,r]),{anchorNode:n,anchorOffset:r,focusNode:i,focusOffset:o}}class IS{constructor(e){this.from=0,this.to=0,this.pendingContextChange=null,this.handlers=Object.create(null),this.composing=null,this.resetRange(e.state);let t=this.editContext=new window.EditContext({text:e.state.doc.sliceString(this.from,this.to),selectionStart:this.toContextPos(Math.max(this.from,Math.min(this.to,e.state.selection.main.anchor))),selectionEnd:this.toContextPos(e.state.selection.main.head)});this.handlers.textupdate=n=>{let r=e.state.selection.main,{anchor:i,head:o}=r,s=this.toEditorPos(n.updateRangeStart),a=this.toEditorPos(n.updateRangeEnd);e.inputState.composing>=0&&!this.composing&&(this.composing={contextBase:n.updateRangeStart,editorBase:s,drifted:!1});let l=a-s>n.text.length;s==this.from&&i<this.from?s=i:a==this.to&&i>this.to&&(a=i);let c=bk(e.state.sliceDoc(s,a),n.text,(l?r.from:r.to)-s,l?"end":null);if(!c){let t=oy.single(this.toEditorPos(n.selectionStart),this.toEditorPos(n.selectionEnd));return void(yk(t,r)||e.dispatch({selection:t,userEvent:"select"}))}let d={from:c.from+s,to:c.toA+s,insert:Rb.of(n.text.slice(c.from,c.toB).split("\n"))};if((Wx.mac||Wx.android)&&d.from==o-1&&/^\. ?$/.test(n.text)&&"off"==e.contentDOM.getAttribute("autocorrect")&&(d={from:s,to:a,insert:Rb.of([n.text.replace("."," ")])}),this.pendingContextChange=d,!e.state.readOnly){let t=this.to-this.from+(d.to-d.from+d.insert.length);Ak(e,d,oy.single(this.toEditorPos(n.selectionStart,t),this.toEditorPos(n.selectionEnd,t)))}this.pendingContextChange&&(this.revertPending(e.state),this.setSelection(e.state)),d.from<d.to&&!d.insert.length&&e.inputState.composing>=0&&!/[\\p{Alphabetic}\\p{Number}_]/.test(t.text.slice(Math.max(0,n.updateRangeStart-1),Math.min(t.text.length,n.updateRangeStart+1)))&&this.handlers.compositionend(n)},this.handlers.characterboundsupdate=n=>{let r=[],i=null;for(let t=this.toEditorPos(n.rangeStart),o=this.toEditorPos(n.rangeEnd);t<o;t++){let n=e.coordsForChar(t);i=n&&new DOMRect(n.left,n.top,n.right-n.left,n.bottom-n.top)||i||new DOMRect,r.push(i)}t.updateCharacterBounds(n.rangeStart,r)},this.handlers.textformatupdate=t=>{let n=[];for(let e of t.getTextFormats()){let t=e.underlineStyle,r=e.underlineThickness;if(!/none/i.test(t)&&!/none/i.test(r)){let i=this.toEditorPos(e.rangeStart),o=this.toEditorPos(e.rangeEnd);if(i<o){let e=`text-decoration: underline ${/^[a-z]/.test(t)?t+" ":"Dashed"==t?"dashed ":"Squiggle"==t?"wavy ":""}${/thin/i.test(r)?1:2}px`;n.push(Xx.mark({attributes:{style:e}}).range(i,o))}}}e.dispatch({effects:oC.of(Xx.set(n))})},this.handlers.compositionstart=()=>{e.inputState.composing<0&&(e.inputState.composing=0,e.inputState.compositionFirstChange=!0)},this.handlers.compositionend=()=>{if(e.inputState.composing=-1,e.inputState.compositionFirstChange=null,this.composing){let{drifted:t}=this.composing;this.composing=null,t&&this.reset(e.state)}};for(let e in this.handlers)t.addEventListener(e,this.handlers[e]);this.measureReq={read:e=>{this.editContext.updateControlBounds(e.contentDOM.getBoundingClientRect());let t=rw(e.root);t&&t.rangeCount&&this.editContext.updateSelectionBounds(t.getRangeAt(0).getBoundingClientRect())}}}applyEdits(e){let t=0,n=!1,r=this.pendingContextChange;return e.changes.iterChanges((i,o,s,a,l)=>{if(n)return;let c=l.length-(o-i);if(r&&o>=r.to){if(r.from==i&&r.to==o&&r.insert.eq(l))return r=this.pendingContextChange=null,t+=c,void(this.to+=c);r=null,this.revertPending(e.state)}if(i+=t,(o+=t)<=this.from)this.from+=c,this.to+=c;else if(i<this.to){if(i<this.from||o>this.to||this.to-this.from+l.length>3e4)return void(n=!0);this.editContext.updateText(this.toContextPos(i),this.toContextPos(o),l.toString()),this.to+=c}t+=c}),r&&!n&&this.revertPending(e.state),!n}update(e){let t=this.pendingContextChange,n=e.startState.selection.main;this.composing&&(this.composing.drifted||!e.changes.touchesRange(n.from,n.to)&&e.transactions.some(e=>!e.isUserEvent("input.type")&&e.changes.touchesRange(this.from,this.to)))?(this.composing.drifted=!0,this.composing.editorBase=e.changes.mapPos(this.composing.editorBase)):this.applyEdits(e)&&this.rangeIsValid(e.state)?(e.docChanged||e.selectionSet||t)&&this.setSelection(e.state):(this.pendingContextChange=null,this.reset(e.state)),(e.geometryChanged||e.docChanged||e.selectionSet)&&e.view.requestMeasure(this.measureReq)}resetRange(e){let{head:t}=e.selection.main;this.from=Math.max(0,t-1e4),this.to=Math.min(e.doc.length,t+1e4)}reset(e){this.resetRange(e),this.editContext.updateText(0,this.editContext.text.length,e.doc.sliceString(this.from,this.to)),this.setSelection(e)}revertPending(e){let t=this.pendingContextChange;this.pendingContextChange=null,this.editContext.updateText(this.toContextPos(t.from),this.toContextPos(t.from+t.insert.length),e.doc.sliceString(t.from,t.to))}setSelection(e){let{main:t}=e.selection,n=this.toContextPos(Math.max(this.from,Math.min(this.to,t.anchor))),r=this.toContextPos(t.head);this.editContext.selectionStart==n&&this.editContext.selectionEnd==r||this.editContext.updateSelection(n,r)}rangeIsValid(e){let{head:t}=e.selection.main;return!(this.from>0&&t-this.from<500||this.to<e.doc.length&&this.to-t<500||this.to-this.from>3e4)}toEditorPos(e,t=this.to-this.from){e=Math.min(e,t);let n=this.composing;return n&&n.drifted?n.editorBase+(e-n.contextBase):e+this.from}toContextPos(e){let t=this.composing;return t&&t.drifted?t.contextBase+(e-t.editorBase):e-this.from}destroy(){for(let e in this.handlers)this.editContext.removeEventListener(e,this.handlers[e])}}class NS{get state(){return this.viewState.state}get viewport(){return this.viewState.viewport}get visibleRanges(){return this.viewState.visibleRanges}get inView(){return this.viewState.inView}get composing(){return!!this.inputState&&this.inputState.composing>0}get compositionStarted(){return!!this.inputState&&this.inputState.composing>=0}get root(){return this._root}get win(){return this.dom.ownerDocument.defaultView||window}constructor(e={}){var t;this.plugins=[],this.pluginMap=new Map,this.editorAttrs={},this.contentAttrs={},this.bidiCache=[],this.destroyed=!1,this.updateState=2,this.measureScheduled=-1,this.measureRequests=[],this.contentDOM=document.createElement("div"),this.scrollDOM=document.createElement("div"),this.scrollDOM.tabIndex=-1,this.scrollDOM.className="cm-scroller",this.scrollDOM.appendChild(this.contentDOM),this.announceDOM=document.createElement("div"),this.announceDOM.className="cm-announced",this.announceDOM.setAttribute("aria-live","polite"),this.dom=document.createElement("div"),this.dom.appendChild(this.announceDOM),this.dom.appendChild(this.scrollDOM),e.parent&&e.parent.appendChild(this.dom);let{dispatch:n}=e;this.dispatchTransactions=e.dispatchTransactions||n&&(e=>e.forEach(e=>n(e,this)))||(e=>this.update(e)),this.dispatch=this.dispatch.bind(this),this._root=e.root||function(e){for(;e;){if(e&&(9==e.nodeType||11==e.nodeType&&e.host))return e;e=e.assignedSlot||e.parentNode}return null}(e.parent)||document,this.viewState=new fS(e.state||Xy.create(e)),e.scrollTo&&e.scrollTo.is(iC)&&(this.viewState.scrollTarget=e.scrollTo.value.clip(this.viewState.state)),this.plugins=this.state.facet(cC).map(e=>new hC(e));for(let e of this.plugins)e.update(this);this.observer=new DS(this),this.inputState=new xk(this),this.inputState.ensureHandlers(this.plugins),this.docView=new YC(this),this.mountStyles(),this.updateAttrs(),this.updateState=0,this.requestMeasure(),(null===(t=document.fonts)||void 0===t?void 0:t.ready)&&document.fonts.ready.then(()=>{this.viewState.mustMeasureContent=!0,this.requestMeasure()})}dispatch(...e){let t=1==e.length&&e[0]instanceof Fy?e:1==e.length&&Array.isArray(e[0])?e[0]:[this.state.update(...e)];this.dispatchTransactions(t,this)}update(e){if(0!=this.updateState)throw new Error("Calls to EditorView.update are not allowed while an update is in progress");let t,n=!1,r=!1,i=this.state;for(let t of e){if(t.startState!=i)throw new RangeError("Trying to update state with a transaction that doesn't start from the previous state.");i=t.state}if(this.destroyed)return void(this.viewState.state=i);let o=this.hasFocus,s=0,a=null;e.some(e=>e.annotation(Wk))?(this.inputState.notifiedFocused=o,s=1):o!=this.inputState.notifiedFocused&&(this.inputState.notifiedFocused=o,a=$k(i,o),a||(s=1));let l=this.observer.delayedAndroidKey,c=null;if(l?(this.observer.clearDelayedAndroidKey(),c=this.observer.readChange(),(c&&!this.state.doc.eq(i.doc)||!this.state.selection.eq(i.selection))&&(c=null)):this.observer.clear(),i.facet(Xy.phrases)!=this.state.facet(Xy.phrases))return this.setState(i);t=kC.create(this,i,e),t.flags|=s;let d=this.viewState.scrollTarget;try{this.updateState=2;for(let t of e){if(d&&(d=d.map(t.changes)),t.scrollIntoView){let{main:e}=t.state.selection;d=new rC(e.empty?e:oy.cursor(e.head,e.head>e.anchor?-1:1))}for(let e of t.effects)e.is(iC)&&(d=e.value.clip(this.state))}this.viewState.update(t,d),this.bidiCache=FS.update(this.bidiCache,t.changes),t.empty||(this.updatePlugins(t),this.inputState.update(t)),n=this.docView.update(t),this.state.facet(wC)!=this.styleModules&&this.mountStyles(),r=this.updateAttrs(),this.showAnnouncements(e),this.docView.updateSelection(n,e.some(e=>e.isUserEvent("select.pointer")))}finally{this.updateState=0}if(t.startState.facet(wS)!=t.state.facet(wS)&&(this.viewState.mustMeasureContent=!0),(n||r||d||this.viewState.mustEnforceCursorAssoc||this.viewState.mustMeasureContent)&&this.requestMeasure(),n&&this.docViewUpdate(),!t.empty)for(let e of this.state.facet(Yw))try{e(t)}catch(e){sC(this.state,e,"update listener")}(a||c)&&Promise.resolve().then(()=>{a&&this.state==a.startState&&this.dispatch(a),c&&!vk(this,c)&&l.force&&yw(this.contentDOM,l.key,l.keyCode)})}setState(e){if(0!=this.updateState)throw new Error("Calls to EditorView.setState are not allowed while an update is in progress");if(this.destroyed)return void(this.viewState.state=e);this.updateState=2;let t=this.hasFocus;try{for(let e of this.plugins)e.destroy(this);this.viewState=new fS(e),this.plugins=e.facet(cC).map(e=>new hC(e)),this.pluginMap.clear();for(let e of this.plugins)e.update(this);this.docView.destroy(),this.docView=new YC(this),this.inputState.ensureHandlers(this.plugins),this.mountStyles(),this.updateAttrs(),this.bidiCache=[]}finally{this.updateState=0}t&&this.focus(),this.requestMeasure()}updatePlugins(e){let t=e.startState.facet(cC),n=e.state.facet(cC);if(t!=n){let r=[];for(let i of n){let n=t.indexOf(i);if(n<0)r.push(new hC(i));else{let t=this.plugins[n];t.mustUpdate=e,r.push(t)}}for(let t of this.plugins)t.mustUpdate!=e&&t.destroy(this);this.plugins=r,this.pluginMap.clear()}else for(let t of this.plugins)t.mustUpdate=e;for(let e=0;e<this.plugins.length;e++)this.plugins[e].update(this);t!=n&&this.inputState.ensureHandlers(this.plugins)}docViewUpdate(){for(let e of this.plugins){let t=e.value;if(t&&t.docViewUpdate)try{t.docViewUpdate(this)}catch(e){sC(this.state,e,"doc view update listener")}}}measure(e=!0){if(this.destroyed)return;if(this.measureScheduled>-1&&this.win.cancelAnimationFrame(this.measureScheduled),this.observer.delayedAndroidKey)return this.measureScheduled=-1,void this.requestMeasure();this.measureScheduled=0,e&&this.observer.forceFlush();let t=null,n=this.scrollDOM,r=n.scrollTop*this.scaleY,{scrollAnchorPos:i,scrollAnchorHeight:o}=this.viewState;Math.abs(r-this.viewState.scrollTop)>1&&(o=-1),this.viewState.scrollAnchorHeight=-1;try{for(let e=0;;e++){if(o<0)if(xw(n))i=-1,o=this.viewState.heightMap.height;else{let e=this.viewState.scrollAnchorAt(r);i=e.from,o=e.top}this.updateState=1;let s=this.viewState.measure(this);if(!s&&!this.measureRequests.length&&null==this.viewState.scrollTarget)break;if(e>5){console.warn(this.measureRequests.length?"Measure loop restarted more than 5 times":"Viewport failed to stabilize");break}let a=[];4&s||([this.measureRequests,a]=[a,this.measureRequests]);let l=a.map(e=>{try{return e.read(this)}catch(e){return sC(this.state,e),QS}}),c=kC.create(this,this.state,[]),d=!1;c.flags|=s,t?t.flags|=s:t=c,this.updateState=2,c.empty||(this.updatePlugins(c),this.inputState.update(c),this.updateAttrs(),d=this.docView.update(c),d&&this.docViewUpdate());for(let e=0;e<a.length;e++)if(l[e]!=QS)try{let t=a[e];t.write&&t.write(l[e],this)}catch(e){sC(this.state,e)}if(d&&this.docView.updateSelection(!0),!c.viewportChanged&&0==this.measureRequests.length){if(this.viewState.editorHeight){if(this.viewState.scrollTarget){this.docView.scrollIntoView(this.viewState.scrollTarget),this.viewState.scrollTarget=null,o=-1;continue}{let e=(i<0?this.viewState.heightMap.height:this.viewState.lineBlockAt(i).top)-o;if(e>1||e<-1){r+=e,n.scrollTop=r/this.scaleY,o=-1;continue}}}break}}}finally{this.updateState=0,this.measureScheduled=-1}if(t&&!t.empty)for(let e of this.state.facet(Yw))e(t)}get themeClasses(){return kS+" "+(this.state.facet(CS)?OS:SS)+" "+this.state.facet(wS)}updateAttrs(){let e=VS(this,uC,{class:"cm-editor"+(this.hasFocus?" cm-focused ":" ")+this.themeClasses}),t={spellcheck:"false",autocorrect:"off",autocapitalize:"off",writingsuggestions:"false",translate:"no",contenteditable:this.state.facet(aC)?"true":"false",class:"cm-content",style:`${Wx.tabSize}: ${this.state.tabSize}`,role:"textbox","aria-multiline":"true"};this.state.readOnly&&(t["aria-readonly"]="true"),VS(this,pC,t);let n=this.observer.ignore(()=>{let n=qx(this.contentDOM,this.contentAttrs,t),r=qx(this.dom,this.editorAttrs,e);return n||r});return this.editorAttrs=e,this.contentAttrs=t,n}showAnnouncements(e){let t=!0;for(let n of e)for(let e of n.effects)if(e.is(NS.announce)){t&&(this.announceDOM.textContent=""),t=!1,this.announceDOM.appendChild(document.createElement("div")).textContent=e.value}}mountStyles(){this.styleModules=this.state.facet(wC);let e=this.state.facet(NS.cspNonce);yx.mount(this.root,this.styleModules.concat(TS).reverse(),e?{nonce:e}:void 0)}readMeasured(){if(2==this.updateState)throw new Error("Reading the editor layout isn't allowed during an update");0==this.updateState&&this.measureScheduled>-1&&this.measure(!1)}requestMeasure(e){if(this.measureScheduled<0&&(this.measureScheduled=this.win.requestAnimationFrame(()=>this.measure())),e){if(this.measureRequests.indexOf(e)>-1)return;if(null!=e.key)for(let t=0;t<this.measureRequests.length;t++)if(this.measureRequests[t].key===e.key)return void(this.measureRequests[t]=e);this.measureRequests.push(e)}}plugin(e){let t=this.pluginMap.get(e);return(void 0===t||t&&t.plugin!=e)&&this.pluginMap.set(e,t=this.plugins.find(t=>t.plugin==e)||null),t&&t.update(this).value}get documentTop(){return this.contentDOM.getBoundingClientRect().top+this.viewState.paddingTop}get documentPadding(){return{top:this.viewState.paddingTop,bottom:this.viewState.paddingBottom}}get scaleX(){return this.viewState.scaleX}get scaleY(){return this.viewState.scaleY}elementAtHeight(e){return this.readMeasured(),this.viewState.elementAtHeight(e)}lineBlockAtHeight(e){return this.readMeasured(),this.viewState.lineBlockAtHeight(e)}get viewportLineBlocks(){return this.viewState.viewportLines}lineBlockAt(e){return this.viewState.lineBlockAt(e)}get contentHeight(){return this.viewState.contentHeight}moveByChar(e,t,n){return ok(this,e,nk(this,e,t,n))}moveByGroup(e,t){return ok(this,e,nk(this,e,t,t=>function(e,t,n){let r=e.state.charCategorizer(t),i=r(n);return e=>{let t=r(e);return i==qy.Space&&(i=t),i==t}}(this,e.head,t)))}visualLineSide(e,t){let n=this.bidiSpans(e),r=this.textDirectionAt(e.from),i=n[t?n.length-1:0];return oy.cursor(i.side(t,r)+e.from,i.forward(!t,r)?1:-1)}moveToLineBoundary(e,t,n=!0){return function(e,t,n,r){let i=tk(e,t.head,t.assoc||-1),o=r&&i.type==Yx.Text&&(e.lineWrapping||i.widgetLineBreaks)?e.coordsAtPos(t.assoc<0&&t.head>i.from?t.head-1:t.head):null;if(o){let t=e.dom.getBoundingClientRect(),r=e.textDirectionAt(i.from),s=e.posAtCoords({x:n==(r==Sw.LTR)?t.right-1:t.left+1,y:(o.top+o.bottom)/2});if(null!=s)return oy.cursor(s,n?-1:1)}return oy.cursor(n?i.to:i.from,n?-1:1)}(this,e,t,n)}moveVertically(e,t,n){return ok(this,e,function(e,t,n,r){let i=t.head,o=n?1:-1;if(i==(n?e.state.doc.length:0))return oy.cursor(i,t.assoc);let s,a=t.goalColumn,l=e.contentDOM.getBoundingClientRect(),c=e.coordsAtPos(i,t.assoc||-1),d=e.documentTop;if(c)null==a&&(a=c.left-l.left),s=o<0?c.top:c.bottom;else{let t=e.viewState.lineBlockAt(i);null==a&&(a=Math.min(l.right-l.left,e.defaultCharacterWidth*(i-t.from))),s=(o<0?t.top:t.bottom)+d}let h=ak(e,{x:l.left+a,y:s+(null!=r?r:e.viewState.heightOracle.textHeight>>1)*o},!1,o);return oy.cursor(h.pos,h.assoc,void 0,a)}(this,e,t,n))}domAtPos(e,t=1){return this.docView.domAtPos(e,t)}posAtDOM(e,t=0){return this.docView.posFromDOM(e,t)}posAtCoords(e,t=!0){this.readMeasured();let n=ak(this,e,t);return n&&n.pos}posAndSideAtCoords(e,t=!0){return this.readMeasured(),ak(this,e,t)}coordsAtPos(e,t=1){this.readMeasured();let n=this.docView.coordsAt(e,t);if(!n||n.left==n.right)return n;let r=this.state.doc.lineAt(e),i=this.bidiSpans(r);return uw(n,i[Iw.find(i,e-r.from,-1,t)].dir==Sw.LTR==t>0)}coordsForChar(e){return this.readMeasured(),this.docView.coordsForChar(e)}get defaultCharacterWidth(){return this.viewState.heightOracle.charWidth}get defaultLineHeight(){return this.viewState.heightOracle.lineHeight}get textDirection(){return this.viewState.defaultTextDirection}textDirectionAt(e){return!this.state.facet(eC)||e<this.viewport.from||e>this.viewport.to?this.textDirection:(this.readMeasured(),this.docView.textDirectionAt(e))}get lineWrapping(){return this.viewState.heightOracle.lineWrapping}bidiSpans(e){if(e.length>LS)return zw(e.length);let t,n=this.textDirectionAt(e.from);for(let r of this.bidiCache)if(r.from==e.from&&r.dir==n&&(r.fresh||Nw(r.isolates,t=bC(this,e))))return r.order;t||(t=bC(this,e));let r=Vw(e.text,n,t);return this.bidiCache.push(new FS(e.from,e.to,n,t,!0,r)),r}get hasFocus(){var e;return(this.dom.ownerDocument.hasFocus()||Wx.safari&&(null===(e=this.inputState)||void 0===e?void 0:e.lastContextMenu)>Date.now()-3e4)&&this.root.activeElement==this.contentDOM}focus(){this.observer.ignore(()=>{Aw(this.contentDOM),this.docView.updateSelection()})}setRoot(e){this._root!=e&&(this._root=e,this.observer.setWindow((9==e.nodeType?e:e.ownerDocument).defaultView||window),this.mountStyles())}destroy(){this.root.activeElement==this.contentDOM&&this.contentDOM.blur();for(let e of this.plugins)e.destroy(this);this.plugins=[],this.inputState.destroy(),this.docView.destroy(),this.dom.remove(),this.observer.destroy(),this.measureScheduled>-1&&this.win.cancelAnimationFrame(this.measureScheduled),this.destroyed=!0}static scrollIntoView(e,t={}){return iC.of(new rC("number"==typeof e?oy.cursor(e):e,t.y,t.x,t.yMargin,t.xMargin))}scrollSnapshot(){let{scrollTop:e,scrollLeft:t}=this.scrollDOM,n=this.viewState.scrollAnchorAt(e);return iC.of(new rC(oy.cursor(n.from),"start","start",n.top-e,t,!0))}setTabFocusMode(e){null==e?this.inputState.tabFocusMode=this.inputState.tabFocusMode<0?0:-1:"boolean"==typeof e?this.inputState.tabFocusMode=e?0:-1:0!=this.inputState.tabFocusMode&&(this.inputState.tabFocusMode=Date.now()+e)}static domEventHandlers(e){return dC.define(()=>({}),{eventHandlers:e})}static domEventObservers(e){return dC.define(()=>({}),{eventObservers:e})}static theme(e,t){let n=yx.newName(),r=[wS.of(n),wC.of(_S(`.${n}`,e))];return t&&t.dark&&r.push(CS.of(!0)),r}static baseTheme(e){return xy.lowest(wC.of(_S("."+kS,e,BS)))}static findFromDOM(e){var t;let n=e.querySelector(".cm-content"),r=n&&OC.get(n)||OC.get(e);return(null===(t=null==r?void 0:r.root)||void 0===t?void 0:t.view)||null}}NS.styleModule=wC,NS.inputHandler=Xw,NS.clipboardInputFilter=Kw,NS.clipboardOutputFilter=Zw,NS.scrollHandler=nC,NS.focusChangeEffect=Jw,NS.perLineTextDirection=eC,NS.exceptionSink=Gw,NS.updateListener=Yw,NS.editable=aC,NS.mouseSelectionStyle=Uw,NS.dragMovesSelection=qw,NS.clickAddsSelectionRange=jw,NS.decorations=fC,NS.blockWrappers=gC,NS.outerDecorations=mC,NS.atomicRanges=vC,NS.bidiIsolatedRanges=AC,NS.scrollMargins=yC,NS.darkTheme=CS,NS.cspNonce=ly.define({combine:e=>e.length?e[0]:""}),NS.contentAttributes=pC,NS.editorAttributes=uC,NS.lineWrapping=NS.contentAttributes.of({class:"cm-lineWrapping"}),NS.announce=Qy.define();const LS=4096,QS={};class FS{constructor(e,t,n,r,i,o){this.from=e,this.to=t,this.dir=n,this.isolates=r,this.fresh=i,this.order=o}static update(e,t){if(t.empty&&!e.some(e=>e.fresh))return e;let n=[],r=e.length?e[e.length-1].dir:Sw.LTR;for(let i=Math.max(0,e.length-10);i<e.length;i++){let o=e[i];o.dir!=r||t.touchesRange(o.from,o.to)||n.push(new FS(t.mapPos(o.from,1),t.mapPos(o.to,-1),o.dir,o.isolates,!1,o.order))}return n}}function VS(e,t,n){for(let r=e.state.facet(t),i=r.length-1;i>=0;i--){let t=r[i],o="function"==typeof t?t(e):t;o&&$x(o,n)}return n}const zS=Wx.mac?"mac":Wx.windows?"win":Wx.linux?"linux":"key";function WS(e,t,n){return t.altKey&&(e="Alt-"+e),t.ctrlKey&&(e="Ctrl-"+e),t.metaKey&&(e="Meta-"+e),!1!==n&&t.shiftKey&&(e="Shift-"+e),e}const $S=xy.default(NS.domEventHandlers({keydown:(e,t)=>YS(qS(t.state),e,t,"editor")})),HS=ly.define({enables:$S}),jS=new WeakMap;function qS(e){let t=e.facet(HS),n=jS.get(t);return n||jS.set(t,n=function(e,t=zS){let n=Object.create(null),r=Object.create(null),i=(e,t)=>{let n=r[e];if(null==n)r[e]=t;else if(n!=t)throw new Error("Key binding "+e+" is used both as a regular binding and as a multi-stroke prefix")},o=(e,r,o,s,a)=>{var l,c;let d=n[e]||(n[e]=Object.create(null)),h=r.split(/ (?!$)/).map(e=>function(e,t){const n=e.split(/-(?!$)/);let r,i,o,s,a=n[n.length-1];"Space"==a&&(a=" ");for(let e=0;e<n.length-1;++e){const a=n[e];if(/^(cmd|meta|m)$/i.test(a))s=!0;else if(/^a(lt)?$/i.test(a))r=!0;else if(/^(c|ctrl|control)$/i.test(a))i=!0;else if(/^s(hift)?$/i.test(a))o=!0;else{if(!/^mod$/i.test(a))throw new Error("Unrecognized modifier name: "+a);"mac"==t?s=!0:i=!0}}return r&&(a="Alt-"+a),i&&(a="Ctrl-"+a),s&&(a="Meta-"+a),o&&(a="Shift-"+a),a}(e,t));for(let t=1;t<h.length;t++){let n=h.slice(0,t).join(" ");i(n,!0),d[n]||(d[n]={preventDefault:!0,stopPropagation:!1,run:[t=>{let r=US={view:t,prefix:n,scope:e};return setTimeout(()=>{US==r&&(US=null)},4e3),!0}]})}let u=h.join(" ");i(u,!1);let p=d[u]||(d[u]={preventDefault:!1,stopPropagation:!1,run:(null===(c=null===(l=d._any)||void 0===l?void 0:l.run)||void 0===c?void 0:c.slice())||[]});o&&p.run.push(o),s&&(p.preventDefault=!0),a&&(p.stopPropagation=!0)};for(let r of e){let e=r.scope?r.scope.split(" "):["editor"];if(r.any)for(let t of e){let e=n[t]||(n[t]=Object.create(null));e._any||(e._any={preventDefault:!1,stopPropagation:!1,run:[]});let{any:i}=r;for(let t in e)e[t].run.push(e=>i(e,GS))}let i=r[t]||r.key;if(i)for(let t of e)o(t,i,r.run,r.preventDefault,r.stopPropagation),r.shift&&o(t,"Shift-"+i,r.shift,r.preventDefault,r.stopPropagation)}return n}(t.reduce((e,t)=>e.concat(t),[]))),n}let US=null;let GS=null;function YS(e,t,n,r){GS=t;let i=function(e){var t=!(Sx&&e.metaKey&&e.shiftKey&&!e.ctrlKey&&!e.altKey||Ox&&e.shiftKey&&e.key&&1==e.key.length||"Unidentified"==e.key)&&e.key||(e.shiftKey?kx:Cx)[e.keyCode]||e.key||"Unidentified";return"Esc"==t&&(t="Escape"),"Del"==t&&(t="Delete"),"Left"==t&&(t="ArrowLeft"),"Up"==t&&(t="ArrowUp"),"Right"==t&&(t="ArrowRight"),"Down"==t&&(t="ArrowDown"),t}(t),o=Ub(jb(i,0))==i.length&&" "!=i,s="",a=!1,l=!1,c=!1;US&&US.view==n&&US.scope==r&&(s=US.prefix+" ",Ok.indexOf(t.keyCode)<0&&(l=!0,US=null));let d,h,u=new Set,p=e=>{if(e){for(let t of e.run)if(!u.has(t)&&(u.add(t),t(n)))return e.stopPropagation&&(c=!0),!0;e.preventDefault&&(e.stopPropagation&&(c=!0),l=!0)}return!1},f=e[r];return f&&(p(f[s+WS(i,t,!o)])?a=!0:!o||!(t.altKey||t.metaKey||t.ctrlKey)||Wx.windows&&t.ctrlKey&&t.altKey||Wx.mac&&t.altKey&&!t.ctrlKey&&!t.metaKey||!(d=Cx[t.keyCode])||d==i?o&&t.shiftKey&&p(f[s+WS(i,t,!0)])&&(a=!0):(p(f[s+WS(d,t,!0)])||t.shiftKey&&(h=kx[t.keyCode])!=i&&h!=d&&p(f[s+WS(h,t,!1)]))&&(a=!0),!a&&p(f._any)&&(a=!0)),l&&(a=!0),a&&c&&t.stopPropagation(),GS=null,a}class XS{constructor(e,t,n,r,i){this.className=e,this.left=t,this.top=n,this.width=r,this.height=i}draw(){let e=document.createElement("div");return e.className=this.className,this.adjust(e),e}update(e,t){return t.className==this.className&&(this.adjust(e),!0)}adjust(e){e.style.left=this.left+"px",e.style.top=this.top+"px",null!=this.width&&(e.style.width=this.width+"px"),e.style.height=this.height+"px"}eq(e){return this.left==e.left&&this.top==e.top&&this.width==e.width&&this.height==e.height&&this.className==e.className}static forRange(e,t,n){if(n.empty){let r=e.coordsAtPos(n.head,n.assoc||1);if(!r)return[];let i=JS(e);return[new XS(t,r.left-i.left,r.top-i.top,null,r.bottom-r.top)]}return function(e,t,n){if(n.to<=e.viewport.from||n.from>=e.viewport.to)return[];let r=Math.max(n.from,e.viewport.from),i=Math.min(n.to,e.viewport.to),o=e.textDirection==Sw.LTR,s=e.contentDOM,a=s.getBoundingClientRect(),l=JS(e),c=s.querySelector(".cm-line"),d=c&&window.getComputedStyle(c),h=a.left+(d?parseInt(d.paddingLeft)+Math.min(0,parseInt(d.textIndent)):0),u=a.right-(d?parseInt(d.paddingRight):0),p=tk(e,r,1),f=tk(e,i,-1),g=p.type==Yx.Text?p:null,m=f.type==Yx.Text?f:null;g&&(e.lineWrapping||p.widgetLineBreaks)&&(g=KS(e,r,1,g));m&&(e.lineWrapping||f.widgetLineBreaks)&&(m=KS(e,i,-1,m));if(g&&m&&g.from==m.from&&g.to==m.to)return A(b(n.from,n.to,g));{let t=g?b(n.from,null,g):y(p,!1),r=m?b(null,n.to,m):y(f,!0),i=[];return(g||p).to<(m||f).from-(g&&m?1:0)||p.widgetLineBreaks>1&&t.bottom+e.defaultLineHeight/2<r.top?i.push(v(h,t.bottom,u,r.top)):t.bottom<r.top&&e.elementAtHeight((t.bottom+r.top)/2).type==Yx.Text&&(t.bottom=r.top=(t.bottom+r.top)/2),A(t).concat(i).concat(A(r))}function v(e,n,r,i){return new XS(t,e-l.left,n-l.top,Math.max(0,r-e),i-n)}function A({top:e,bottom:t,horizontal:n}){let r=[];for(let i=0;i<n.length;i+=2)r.push(v(n[i],e,n[i+1],t));return r}function b(t,n,r){let i=1e9,s=-1e9,a=[];function l(t,n,l,c,d){let p=e.coordsAtPos(t,t==r.to?-2:2),f=e.coordsAtPos(l,l==r.from?2:-2);p&&f&&(i=Math.min(p.top,f.top,i),s=Math.max(p.bottom,f.bottom,s),d==Sw.LTR?a.push(o&&n?h:p.left,o&&c?u:f.right):a.push(!o&&c?h:f.left,!o&&n?u:p.right))}let c=null!=t?t:r.from,d=null!=n?n:r.to;for(let r of e.visibleRanges)if(r.to>c&&r.from<d)for(let i=Math.max(r.from,c),o=Math.min(r.to,d);;){let r=e.state.doc.lineAt(i);for(let s of e.bidiSpans(r)){let e=s.from+r.from,a=s.to+r.from;if(e>=o)break;a>i&&l(Math.max(e,i),null==t&&e<=c,Math.min(a,o),null==n&&a>=d,s.dir)}if(i=r.to+1,i>=o)break}return 0==a.length&&l(c,null==t,d,null==n,e.textDirection),{top:i,bottom:s,horizontal:a}}function y(e,t){let n=a.top+(t?e.top:e.bottom);return{top:n,bottom:n,horizontal:[]}}}(e,t,n)}}function JS(e){let t=e.scrollDOM.getBoundingClientRect();return{left:(e.textDirection==Sw.LTR?t.left:t.right-e.scrollDOM.clientWidth*e.scaleX)-e.scrollDOM.scrollLeft*e.scaleX,top:t.top-e.scrollDOM.scrollTop*e.scaleY}}function KS(e,t,n,r){let i=e.coordsAtPos(t,2*n);if(!i)return r;let o=e.dom.getBoundingClientRect(),s=(i.top+i.bottom)/2,a=e.posAtCoords({x:o.left+1,y:s}),l=e.posAtCoords({x:o.right-1,y:s});return null==a||null==l?r:{from:Math.max(r.from,Math.min(a,l)),to:Math.min(r.to,Math.max(a,l))}}class ZS{constructor(e,t){this.view=e,this.layer=t,this.drawn=[],this.scaleX=1,this.scaleY=1,this.measureReq={read:this.measure.bind(this),write:this.draw.bind(this)},this.dom=e.scrollDOM.appendChild(document.createElement("div")),this.dom.classList.add("cm-layer"),t.above&&this.dom.classList.add("cm-layer-above"),t.class&&this.dom.classList.add(t.class),this.scale(),this.dom.setAttribute("aria-hidden","true"),this.setOrder(e.state),e.requestMeasure(this.measureReq),t.mount&&t.mount(this.dom,e)}update(e){e.startState.facet(eO)!=e.state.facet(eO)&&this.setOrder(e.state),(this.layer.update(e,this.dom)||e.geometryChanged)&&(this.scale(),e.view.requestMeasure(this.measureReq))}docViewUpdate(e){!1!==this.layer.updateOnDocViewUpdate&&e.requestMeasure(this.measureReq)}setOrder(e){let t=0,n=e.facet(eO);for(;t<n.length&&n[t]!=this.layer;)t++;this.dom.style.zIndex=String((this.layer.above?150:-1)-t)}measure(){return this.layer.markers(this.view)}scale(){let{scaleX:e,scaleY:t}=this.view;e==this.scaleX&&t==this.scaleY||(this.scaleX=e,this.scaleY=t,this.dom.style.transform=`scale(${1/e}, ${1/t})`)}draw(e){if(e.length!=this.drawn.length||e.some((e,t)=>{return n=e,r=this.drawn[t],!(n.constructor==r.constructor&&n.eq(r));var n,r})){let t=this.dom.firstChild,n=0;for(let r of e)r.update&&t&&r.constructor&&this.drawn[n].constructor&&r.update(t,this.drawn[n])?(t=t.nextSibling,n++):this.dom.insertBefore(r.draw(),t);for(;t;){let e=t.nextSibling;t.remove(),t=e}this.drawn=e,Wx.safari&&Wx.safari_version>=26&&(this.dom.style.display=this.dom.firstChild?"":"none")}}destroy(){this.layer.destroy&&this.layer.destroy(this.dom,this.view),this.dom.remove()}}const eO=ly.define();function tO(e){return[dC.define(t=>new ZS(t,e)),eO.of(e)]}const nO=ly.define({combine:e=>Jy(e,{cursorBlinkRate:1200,drawRangeCursor:!0},{cursorBlinkRate:(e,t)=>Math.min(e,t),drawRangeCursor:(e,t)=>e||t})});function rO(e={}){return[nO.of(e),oO,aO,lO,tC.of(!0)]}function iO(e){return e.startState.facet(nO)!=e.state.facet(nO)}const oO=tO({above:!0,markers(e){let{state:t}=e,n=t.facet(nO),r=[];for(let i of t.selection.ranges){let o=i==t.selection.main;if(i.empty||n.drawRangeCursor){let t=o?"cm-cursor cm-cursor-primary":"cm-cursor cm-cursor-secondary",n=i.empty?i:oy.cursor(i.head,i.head>i.anchor?-1:1);for(let i of XS.forRange(e,t,n))r.push(i)}}return r},update(e,t){e.transactions.some(e=>e.selection)&&(t.style.animationName="cm-blink"==t.style.animationName?"cm-blink2":"cm-blink");let n=iO(e);return n&&sO(e.state,t),e.docChanged||e.selectionSet||n},mount(e,t){sO(t.state,e)},class:"cm-cursorLayer"});function sO(e,t){t.style.animationDuration=e.facet(nO).cursorBlinkRate+"ms"}const aO=tO({above:!1,markers:e=>e.state.selection.ranges.map(t=>t.empty?[]:XS.forRange(e,"cm-selectionBackground",t)).reduce((e,t)=>e.concat(t)),update:(e,t)=>e.docChanged||e.selectionSet||e.viewportChanged||iO(e),class:"cm-selectionLayer"}),lO=xy.highest(NS.theme({".cm-line":{"& ::selection, &::selection":{backgroundColor:"transparent !important"},caretColor:"transparent !important"},".cm-content":{caretColor:"transparent !important","& :focus":{caretColor:"initial !important","&::selection, & ::selection":{backgroundColor:"Highlight !important"}}}})),cO=Qy.define({map:(e,t)=>null==e?null:t.mapPos(e)}),dO=gy.define({create:()=>null,update:(e,t)=>(null!=e&&(e=t.changes.mapPos(e)),t.effects.reduce((e,t)=>t.is(cO)?t.value:e,e))}),hO=dC.fromClass(class{constructor(e){this.view=e,this.cursor=null,this.measureReq={read:this.readPos.bind(this),write:this.drawCursor.bind(this)}}update(e){var t;let n=e.state.field(dO);null==n?null!=this.cursor&&(null===(t=this.cursor)||void 0===t||t.remove(),this.cursor=null):(this.cursor||(this.cursor=this.view.scrollDOM.appendChild(document.createElement("div")),this.cursor.className="cm-dropCursor"),(e.startState.field(dO)!=n||e.docChanged||e.geometryChanged)&&this.view.requestMeasure(this.measureReq))}readPos(){let{view:e}=this,t=e.state.field(dO),n=null!=t&&e.coordsAtPos(t);if(!n)return null;let r=e.scrollDOM.getBoundingClientRect();return{left:n.left-r.left+e.scrollDOM.scrollLeft*e.scaleX,top:n.top-r.top+e.scrollDOM.scrollTop*e.scaleY,height:n.bottom-n.top}}drawCursor(e){if(this.cursor){let{scaleX:t,scaleY:n}=this.view;e?(this.cursor.style.left=e.left/t+"px",this.cursor.style.top=e.top/n+"px",this.cursor.style.height=e.height/n+"px"):this.cursor.style.left="-100000px"}}destroy(){this.cursor&&this.cursor.remove()}setDropPos(e){this.view.state.field(dO)!=e&&this.view.dispatch({effects:cO.of(e)})}},{eventObservers:{dragover(e){this.setDropPos(this.view.posAtCoords({x:e.clientX,y:e.clientY}))},dragleave(e){e.target!=this.view.contentDOM&&this.view.contentDOM.contains(e.relatedTarget)||this.setDropPos(null)},dragend(){this.setDropPos(null)},drop(){this.setDropPos(null)}}});function uO(e,t,n,r,i){t.lastIndex=0;for(let o,s=e.iterRange(n,r),a=n;!s.next().done;a+=s.value.length)if(!s.lineBreak)for(;o=t.exec(s.value);)i(a+o.index,o)}class pO{constructor(e){const{regexp:t,decoration:n,decorate:r,boundary:i,maxLength:o=1e3}=e;if(!t.global)throw new RangeError("The regular expression given to MatchDecorator should have its 'g' flag set");if(this.regexp=t,r)this.addMatch=(e,t,n,i)=>r(i,n,n+e[0].length,e,t);else if("function"==typeof n)this.addMatch=(e,t,r,i)=>{let o=n(e,t,r);o&&i(r,r+e[0].length,o)};else{if(!n)throw new RangeError("Either 'decorate' or 'decoration' should be provided to MatchDecorator");this.addMatch=(e,t,r,i)=>i(r,r+e[0].length,n)}this.boundary=i,this.maxLength=o}createDeco(e){let t=new ix,n=t.add.bind(t);for(let{from:t,to:r}of function(e,t){let n=e.visibleRanges;if(1==n.length&&n[0].from==e.viewport.from&&n[0].to==e.viewport.to)return n;let r=[];for(let{from:i,to:o}of n)i=Math.max(e.state.doc.lineAt(i).from,i-t),o=Math.min(e.state.doc.lineAt(o).to,o+t),r.length&&r[r.length-1].to>=i?r[r.length-1].to=o:r.push({from:i,to:o});return r}(e,this.maxLength))uO(e.state.doc,this.regexp,t,r,(t,r)=>this.addMatch(r,e,t,n));return t.finish()}updateDeco(e,t){let n=1e9,r=-1;return e.docChanged&&e.changes.iterChanges((t,i,o,s)=>{s>=e.view.viewport.from&&o<=e.view.viewport.to&&(n=Math.min(o,n),r=Math.max(s,r))}),e.viewportMoved||r-n>1e3?this.createDeco(e.view):r>-1?this.updateRange(e.view,t.map(e.changes),n,r):t}updateRange(e,t,n,r){for(let i of e.visibleRanges){let o=Math.max(i.from,n),s=Math.min(i.to,r);if(s>=o){let n=e.state.doc.lineAt(o),r=n.to<s?e.state.doc.lineAt(s):n,a=Math.max(i.from,n.from),l=Math.min(i.to,r.to);if(this.boundary){for(;o>n.from;o--)if(this.boundary.test(n.text[o-1-n.from])){a=o;break}for(;s<r.to;s++)if(this.boundary.test(r.text[s-r.from])){l=s;break}}let c,d=[],h=(e,t,n)=>d.push(n.range(e,t));if(n==r)for(this.regexp.lastIndex=a-n.from;(c=this.regexp.exec(n.text))&&c.index<l-n.from;)this.addMatch(c,e,c.index+n.from,h);else uO(e.state.doc,this.regexp,a,l,(t,n)=>this.addMatch(n,e,t,h));t=t.update({filterFrom:a,filterTo:l,filter:(e,t)=>e<a||t>l,add:d})}}return t}}const fO=null!=/x/.unicode?"gu":"g",gO=new RegExp("[\0-\b\n--­؜​‎‏\u2028\u2029‭‮⁦⁧⁩\ufeff￹-￼]",fO),mO={0:"null",7:"bell",8:"backspace",10:"newline",11:"vertical tab",13:"carriage return",27:"escape",8203:"zero width space",8204:"zero width non-joiner",8205:"zero width joiner",8206:"left-to-right mark",8207:"right-to-left mark",8232:"line separator",8237:"left-to-right override",8238:"right-to-left override",8294:"left-to-right isolate",8295:"right-to-left isolate",8297:"pop directional isolate",8233:"paragraph separator",65279:"zero width no-break space",65532:"object replacement"};let vO=null;const AO=ly.define({combine(e){let t=Jy(e,{render:null,specialChars:gO,addSpecialChars:null});return(t.replaceTabs=!function(){var e;if(null==vO&&"undefined"!=typeof document&&document.body){let t=document.body.style;vO=null!=(null!==(e=t.tabSize)&&void 0!==e?e:t.MozTabSize)}return vO||!1}())&&(t.specialChars=new RegExp("\t|"+t.specialChars.source,fO)),t.addSpecialChars&&(t.specialChars=new RegExp(t.specialChars.source+"|"+t.addSpecialChars.source,fO)),t}});function bO(e={}){return[AO.of(e),yO||(yO=dC.fromClass(class{constructor(e){this.view=e,this.decorations=Xx.none,this.decorationCache=Object.create(null),this.decorator=this.makeDecorator(e.state.facet(AO)),this.decorations=this.decorator.createDeco(e)}makeDecorator(e){return new pO({regexp:e.specialChars,decoration:(t,n,r)=>{let{doc:i}=n.state,o=jb(t[0],0);if(9==o){let e=i.lineAt(r),t=n.state.tabSize,o=gx(e.text,t,r-e.from);return Xx.replace({widget:new wO((t-o%t)*this.view.defaultCharacterWidth/this.view.scaleX)})}return this.decorationCache[o]||(this.decorationCache[o]=Xx.replace({widget:new xO(e,o)}))},boundary:e.replaceTabs?void 0:/[^]/})}update(e){let t=e.state.facet(AO);e.startState.facet(AO)!=t?(this.decorator=this.makeDecorator(t),this.decorations=this.decorator.createDeco(e.view)):this.decorations=this.decorator.updateDeco(e,this.decorations)}},{decorations:e=>e.decorations}))]}let yO=null;class xO extends Gx{constructor(e,t){super(),this.options=e,this.code=t}eq(e){return e.code==this.code}toDOM(e){let t=function(e){return e>=32?"•":10==e?"␤":String.fromCharCode(9216+e)}(this.code),n=e.state.phrase("Control character")+" "+(mO[this.code]||"0x"+this.code.toString(16)),r=this.options.render&&this.options.render(this.code,n,t);if(r)return r;let i=document.createElement("span");return i.textContent=t,i.title=n,i.setAttribute("aria-label",n),i.className="cm-specialChar",i}ignoreEvent(){return!1}}class wO extends Gx{constructor(e){super(),this.width=e}eq(e){return e.width==this.width}toDOM(){let e=document.createElement("span");return e.textContent="\t",e.className="cm-tab",e.style.width=this.width+"px",e}ignoreEvent(){return!1}}const CO=Xx.line({class:"cm-activeLine"}),kO=dC.fromClass(class{constructor(e){this.decorations=this.getDeco(e)}update(e){(e.docChanged||e.selectionSet)&&(this.decorations=this.getDeco(e.view))}getDeco(e){let t=-1,n=[];for(let r of e.state.selection.ranges){let i=e.lineBlockAt(r.head);i.from>t&&(n.push(CO.range(i.from)),t=i.from)}return Xx.set(n)}},{decorations:e=>e.decorations});class SO extends Gx{constructor(e){super(),this.content=e}toDOM(e){let t=document.createElement("span");return t.className="cm-placeholder",t.style.pointerEvents="none",t.appendChild("string"==typeof this.content?document.createTextNode(this.content):"function"==typeof this.content?this.content(e):this.content.cloneNode(!0)),t.setAttribute("aria-hidden","true"),t}coordsAt(e){let t=e.firstChild?sw(e.firstChild):[];if(!t.length)return null;let n=window.getComputedStyle(e.parentNode),r=uw(t[0],"rtl"!=n.direction),i=parseInt(n.lineHeight);return r.bottom-r.top>1.5*i?{left:r.left,right:r.right,top:r.top,bottom:r.top+i}:r}ignoreEvent(){return!1}}const OO=2e3;function BO(e,t){let n=e.posAtCoords({x:t.clientX,y:t.clientY},!1),r=e.state.doc.lineAt(n),i=n-r.from,o=i>OO?-1:i==r.length?function(e,t){let n=e.coordsAtPos(e.viewport.from);return n?Math.round(Math.abs((n.left-t)/e.defaultCharacterWidth)):-1}(e,t.clientX):gx(r.text,e.state.tabSize,n-r.from);return{line:r.number,col:o,off:i}}function _O(e,t){let n=BO(e,t),r=e.state.selection;return n?{update(e){if(e.docChanged){let t=e.changes.mapPos(e.startState.doc.line(n.line).from),i=e.state.doc.lineAt(t);n={line:i.number,col:n.col,off:Math.min(n.off,i.length)},r=r.map(e.changes)}},get(t,i,o){let s=BO(e,t);if(!s)return r;let a=function(e,t,n){let r=Math.min(t.line,n.line),i=Math.max(t.line,n.line),o=[];if(t.off>OO||n.off>OO||t.col<0||n.col<0){let s=Math.min(t.off,n.off),a=Math.max(t.off,n.off);for(let t=r;t<=i;t++){let n=e.doc.line(t);n.length<=a&&o.push(oy.range(n.from+s,n.to+a))}}else{let s=Math.min(t.col,n.col),a=Math.max(t.col,n.col);for(let t=r;t<=i;t++){let n=e.doc.line(t),r=mx(n.text,s,e.tabSize,!0);if(r<0)o.push(oy.cursor(n.to));else{let t=mx(n.text,a,e.tabSize);o.push(oy.range(n.from+r,n.from+t))}}}return o}(e.state,n,s);return a.length?o?oy.create(a.concat(r.ranges)):oy.create(a):r}}:null}function TO(e){let t=(null==e?void 0:e.eventFilter)||(e=>e.altKey&&0==e.button);return NS.mouseSelectionStyle.of((e,n)=>t(n)?_O(e,n):null)}const EO={Alt:[18,e=>!!e.altKey],Control:[17,e=>!!e.ctrlKey],Shift:[16,e=>!!e.shiftKey],Meta:[91,e=>!!e.metaKey]},MO={style:"cursor: crosshair"};function DO(e={}){let[t,n]=EO[e.key||"Alt"],r=dC.fromClass(class{constructor(e){this.view=e,this.isDown=!1}set(e){this.isDown!=e&&(this.isDown=e,this.view.update([]))}},{eventObservers:{keydown(e){this.set(e.keyCode==t||n(e))},keyup(e){e.keyCode!=t&&n(e)||this.set(!1)},mousemove(e){this.set(n(e))}}});return[r,NS.contentAttributes.of(e=>{var t;return(null===(t=e.plugin(r))||void 0===t?void 0:t.isDown)?MO:null})]}const PO="-10000px";class RO{constructor(e,t,n,r){this.facet=t,this.createTooltipView=n,this.removeTooltipView=r,this.input=e.state.facet(t),this.tooltips=this.input.filter(e=>e);let i=null;this.tooltipViews=this.tooltips.map(e=>i=n(e,i))}update(e,t){var n;let r=e.state.facet(this.facet),i=r.filter(e=>e);if(r===this.input){for(let t of this.tooltipViews)t.update&&t.update(e);return!1}let o=[],s=t?[]:null;for(let n=0;n<i.length;n++){let r=i[n],a=-1;if(r){for(let e=0;e<this.tooltips.length;e++){let t=this.tooltips[e];t&&t.create==r.create&&(a=e)}if(a<0)o[n]=this.createTooltipView(r,n?o[n-1]:null),s&&(s[n]=!!r.above);else{let r=o[n]=this.tooltipViews[a];s&&(s[n]=t[a]),r.update&&r.update(e)}}}for(let e of this.tooltipViews)o.indexOf(e)<0&&(this.removeTooltipView(e),null===(n=e.destroy)||void 0===n||n.call(e));return t&&(s.forEach((e,n)=>t[n]=e),t.length=s.length),this.input=r,this.tooltips=i,this.tooltipViews=o,!0}}function IO(e){let t=e.dom.ownerDocument.documentElement;return{top:0,left:0,bottom:t.clientHeight,right:t.clientWidth}}const NO=ly.define({combine:e=>{var t,n,r;return{position:Wx.ios?"absolute":(null===(t=e.find(e=>e.position))||void 0===t?void 0:t.position)||"fixed",parent:(null===(n=e.find(e=>e.parent))||void 0===n?void 0:n.parent)||null,tooltipSpace:(null===(r=e.find(e=>e.tooltipSpace))||void 0===r?void 0:r.tooltipSpace)||IO}}}),LO=new WeakMap,QO=dC.fromClass(class{constructor(e){this.view=e,this.above=[],this.inView=!0,this.madeAbsolute=!1,this.lastTransaction=0,this.measureTimeout=-1;let t=e.state.facet(NO);this.position=t.position,this.parent=t.parent,this.classes=e.themeClasses,this.createContainer(),this.measureReq={read:this.readMeasure.bind(this),write:this.writeMeasure.bind(this),key:this},this.resizeObserver="function"==typeof ResizeObserver?new ResizeObserver(()=>this.measureSoon()):null,this.manager=new RO(e,WO,(e,t)=>this.createTooltip(e,t),e=>{this.resizeObserver&&this.resizeObserver.unobserve(e.dom),e.dom.remove()}),this.above=this.manager.tooltips.map(e=>!!e.above),this.intersectionObserver="function"==typeof IntersectionObserver?new IntersectionObserver(e=>{Date.now()>this.lastTransaction-50&&e.length>0&&e[e.length-1].intersectionRatio<1&&this.measureSoon()},{threshold:[1]}):null,this.observeIntersection(),e.win.addEventListener("resize",this.measureSoon=this.measureSoon.bind(this)),this.maybeMeasure()}createContainer(){this.parent?(this.container=document.createElement("div"),this.container.style.position="relative",this.container.className=this.view.themeClasses,this.parent.appendChild(this.container)):this.container=this.view.dom}observeIntersection(){if(this.intersectionObserver){this.intersectionObserver.disconnect();for(let e of this.manager.tooltipViews)this.intersectionObserver.observe(e.dom)}}measureSoon(){this.measureTimeout<0&&(this.measureTimeout=setTimeout(()=>{this.measureTimeout=-1,this.maybeMeasure()},50))}update(e){e.transactions.length&&(this.lastTransaction=Date.now());let t=this.manager.update(e,this.above);t&&this.observeIntersection();let n=t||e.geometryChanged,r=e.state.facet(NO);if(r.position!=this.position&&!this.madeAbsolute){this.position=r.position;for(let e of this.manager.tooltipViews)e.dom.style.position=this.position;n=!0}if(r.parent!=this.parent){this.parent&&this.container.remove(),this.parent=r.parent,this.createContainer();for(let e of this.manager.tooltipViews)this.container.appendChild(e.dom);n=!0}else this.parent&&this.view.themeClasses!=this.classes&&(this.classes=this.container.className=this.view.themeClasses);n&&this.maybeMeasure()}createTooltip(e,t){let n=e.create(this.view),r=t?t.dom:null;if(n.dom.classList.add("cm-tooltip"),e.arrow&&!n.dom.querySelector(".cm-tooltip > .cm-tooltip-arrow")){let e=document.createElement("div");e.className="cm-tooltip-arrow",n.dom.appendChild(e)}return n.dom.style.position=this.position,n.dom.style.top=PO,n.dom.style.left="0px",this.container.insertBefore(n.dom,r),n.mount&&n.mount(this.view),this.resizeObserver&&this.resizeObserver.observe(n.dom),n}destroy(){var e,t,n;this.view.win.removeEventListener("resize",this.measureSoon);for(let t of this.manager.tooltipViews)t.dom.remove(),null===(e=t.destroy)||void 0===e||e.call(t);this.parent&&this.container.remove(),null===(t=this.resizeObserver)||void 0===t||t.disconnect(),null===(n=this.intersectionObserver)||void 0===n||n.disconnect(),clearTimeout(this.measureTimeout)}readMeasure(){let e=1,t=1,n=!1;if("fixed"==this.position&&this.manager.tooltipViews.length){let{dom:e}=this.manager.tooltipViews[0];if(Wx.safari){let t=e.getBoundingClientRect();n=Math.abs(t.top+1e4)>1||Math.abs(t.left)>1}else n=!!e.offsetParent&&e.offsetParent!=this.container.ownerDocument.body}if(n||"absolute"==this.position)if(this.parent){let n=this.parent.getBoundingClientRect();n.width&&n.height&&(e=n.width/this.parent.offsetWidth,t=n.height/this.parent.offsetHeight)}else({scaleX:e,scaleY:t}=this.view.viewState);let r=this.view.scrollDOM.getBoundingClientRect(),i=xC(this.view);return{visible:{left:r.left+i.left,top:r.top+i.top,right:r.right-i.right,bottom:r.bottom-i.bottom},parent:this.parent?this.container.getBoundingClientRect():this.view.dom.getBoundingClientRect(),pos:this.manager.tooltips.map((e,t)=>{let n=this.manager.tooltipViews[t];return n.getCoords?n.getCoords(e.pos):this.view.coordsAtPos(e.pos)}),size:this.manager.tooltipViews.map(({dom:e})=>e.getBoundingClientRect()),space:this.view.state.facet(NO).tooltipSpace(this.view),scaleX:e,scaleY:t,makeAbsolute:n}}writeMeasure(e){var t;if(e.makeAbsolute){this.madeAbsolute=!0,this.position="absolute";for(let e of this.manager.tooltipViews)e.dom.style.position="absolute"}let{visible:n,space:r,scaleX:i,scaleY:o}=e,s=[];for(let a=0;a<this.manager.tooltips.length;a++){let l=this.manager.tooltips[a],c=this.manager.tooltipViews[a],{dom:d}=c,h=e.pos[a],u=e.size[a];if(!h||!1!==l.clip&&(h.bottom<=Math.max(n.top,r.top)||h.top>=Math.min(n.bottom,r.bottom)||h.right<Math.max(n.left,r.left)-.1||h.left>Math.min(n.right,r.right)+.1)){d.style.top=PO;continue}let p=l.arrow?c.dom.querySelector(".cm-tooltip-arrow"):null,f=p?7:0,g=u.right-u.left,m=null!==(t=LO.get(c))&&void 0!==t?t:u.bottom-u.top,v=c.offset||zO,A=this.view.textDirection==Sw.LTR,b=u.width>r.right-r.left?A?r.left:r.right-u.width:A?Math.max(r.left,Math.min(h.left-(p?14:0)+v.x,r.right-g)):Math.min(Math.max(r.left,h.left-g+(p?14:0)-v.x),r.right-g),y=this.above[a];!l.strictSide&&(y?h.top-m-f-v.y<r.top:h.bottom+m+f+v.y>r.bottom)&&y==r.bottom-h.bottom>h.top-r.top&&(y=this.above[a]=!y);let x=(y?h.top-r.top:r.bottom-h.bottom)-f;if(x<m&&!1!==c.resize){if(x<this.view.defaultLineHeight){d.style.top=PO;continue}LO.set(c,m),d.style.height=(m=x)/o+"px"}else d.style.height&&(d.style.height="");let w=y?h.top-m-f-v.y:h.bottom+f+v.y,C=b+g;if(!0!==c.overlap)for(let e of s)e.left<C&&e.right>b&&e.top<w+m&&e.bottom>w&&(w=y?e.top-m-2-f:e.bottom+f+2);if("absolute"==this.position?(d.style.top=(w-e.parent.top)/o+"px",FO(d,(b-e.parent.left)/i)):(d.style.top=w/o+"px",FO(d,b/i)),p){let e=h.left+(A?v.x:-v.x)-(b+14-7);p.style.left=e/i+"px"}!0!==c.overlap&&s.push({left:b,top:w,right:C,bottom:w+m}),d.classList.toggle("cm-tooltip-above",y),d.classList.toggle("cm-tooltip-below",!y),c.positioned&&c.positioned(e.space)}}maybeMeasure(){if(this.manager.tooltips.length&&(this.view.inView&&this.view.requestMeasure(this.measureReq),this.inView!=this.view.inView&&(this.inView=this.view.inView,!this.inView)))for(let e of this.manager.tooltipViews)e.dom.style.top=PO}},{eventObservers:{scroll(){this.maybeMeasure()}}});function FO(e,t){let n=parseInt(e.style.left,10);(isNaN(n)||Math.abs(t-n)>1)&&(e.style.left=t+"px")}const VO=NS.baseTheme({".cm-tooltip":{zIndex:500,boxSizing:"border-box"},"&light .cm-tooltip":{border:"1px solid #bbb",backgroundColor:"#f5f5f5"},"&light .cm-tooltip-section:not(:first-child)":{borderTop:"1px solid #bbb"},"&dark .cm-tooltip":{backgroundColor:"#333338",color:"white"},".cm-tooltip-arrow":{height:"7px",width:"14px",position:"absolute",zIndex:-1,overflow:"hidden","&:before, &:after":{content:"''",position:"absolute",width:0,height:0,borderLeft:"7px solid transparent",borderRight:"7px solid transparent"},".cm-tooltip-above &":{bottom:"-7px","&:before":{borderTop:"7px solid #bbb"},"&:after":{borderTop:"7px solid #f5f5f5",bottom:"1px"}},".cm-tooltip-below &":{top:"-7px","&:before":{borderBottom:"7px solid #bbb"},"&:after":{borderBottom:"7px solid #f5f5f5",top:"1px"}}},"&dark .cm-tooltip .cm-tooltip-arrow":{"&:before":{borderTopColor:"#333338",borderBottomColor:"#333338"},"&:after":{borderTopColor:"transparent",borderBottomColor:"transparent"}}}),zO={x:0,y:0},WO=ly.define({enables:[QO,VO]}),$O=ly.define({combine:e=>e.reduce((e,t)=>e.concat(t),[])});class HO{static create(e){return new HO(e)}constructor(e){this.view=e,this.mounted=!1,this.dom=document.createElement("div"),this.dom.classList.add("cm-tooltip-hover"),this.manager=new RO(e,$O,(e,t)=>this.createHostedView(e,t),e=>e.dom.remove())}createHostedView(e,t){let n=e.create(this.view);return n.dom.classList.add("cm-tooltip-section"),this.dom.insertBefore(n.dom,t?t.dom.nextSibling:this.dom.firstChild),this.mounted&&n.mount&&n.mount(this.view),n}mount(e){for(let t of this.manager.tooltipViews)t.mount&&t.mount(e);this.mounted=!0}positioned(e){for(let t of this.manager.tooltipViews)t.positioned&&t.positioned(e)}update(e){this.manager.update(e)}destroy(){var e;for(let t of this.manager.tooltipViews)null===(e=t.destroy)||void 0===e||e.call(t)}passProp(e){let t;for(let n of this.manager.tooltipViews){let r=n[e];if(void 0!==r)if(void 0===t)t=r;else if(t!==r)return}return t}get offset(){return this.passProp("offset")}get getCoords(){return this.passProp("getCoords")}get overlap(){return this.passProp("overlap")}get resize(){return this.passProp("resize")}}const jO=WO.compute([$O],e=>{let t=e.facet($O);return 0===t.length?null:{pos:Math.min(...t.map(e=>e.pos)),end:Math.max(...t.map(e=>{var t;return null!==(t=e.end)&&void 0!==t?t:e.pos})),create:HO.create,above:t[0].above,arrow:t.some(e=>e.arrow)}});class qO{constructor(e,t,n,r,i){this.view=e,this.source=t,this.field=n,this.setHover=r,this.hoverTime=i,this.hoverTimeout=-1,this.restartTimeout=-1,this.pending=null,this.lastMove={x:0,y:0,target:e.dom,time:0},this.checkHover=this.checkHover.bind(this),e.dom.addEventListener("mouseleave",this.mouseleave=this.mouseleave.bind(this)),e.dom.addEventListener("mousemove",this.mousemove=this.mousemove.bind(this))}update(){this.pending&&(this.pending=null,clearTimeout(this.restartTimeout),this.restartTimeout=setTimeout(()=>this.startHover(),20))}get active(){return this.view.state.field(this.field)}checkHover(){if(this.hoverTimeout=-1,this.active.length)return;let e=Date.now()-this.lastMove.time;e<this.hoverTime?this.hoverTimeout=setTimeout(this.checkHover,this.hoverTime-e):this.startHover()}startHover(){clearTimeout(this.restartTimeout);let{view:e,lastMove:t}=this,n=e.docView.tile.nearest(t.target);if(!n)return;let r,i=1;if(n.isWidget())r=n.posAtStart;else{if(r=e.posAtCoords(t),null==r)return;let n=e.coordsAtPos(r);if(!n||t.y<n.top||t.y>n.bottom||t.x<n.left-e.defaultCharacterWidth||t.x>n.right+e.defaultCharacterWidth)return;let o=e.bidiSpans(e.state.doc.lineAt(r)).find(e=>e.from<=r&&e.to>=r),s=o&&o.dir==Sw.RTL?-1:1;i=t.x<n.left?-s:s}let o=this.source(e,r,i);if(null==o?void 0:o.then){let t=this.pending={pos:r};o.then(n=>{this.pending==t&&(this.pending=null,!n||Array.isArray(n)&&!n.length||e.dispatch({effects:this.setHover.of(Array.isArray(n)?n:[n])}))},t=>sC(e.state,t,"hover tooltip"))}else!o||Array.isArray(o)&&!o.length||e.dispatch({effects:this.setHover.of(Array.isArray(o)?o:[o])})}get tooltip(){let e=this.view.plugin(QO),t=e?e.manager.tooltips.findIndex(e=>e.create==HO.create):-1;return t>-1?e.manager.tooltipViews[t]:null}mousemove(e){var t,n;this.lastMove={x:e.clientX,y:e.clientY,target:e.target,time:Date.now()},this.hoverTimeout<0&&(this.hoverTimeout=setTimeout(this.checkHover,this.hoverTime));let{active:r,tooltip:i}=this;if(r.length&&i&&!function(e,t){let n,{left:r,right:i,top:o,bottom:s}=e.getBoundingClientRect();if(n=e.querySelector(".cm-tooltip-arrow")){let e=n.getBoundingClientRect();o=Math.min(e.top,o),s=Math.max(e.bottom,s)}return t.clientX>=r-4&&t.clientX<=i+4&&t.clientY>=o-4&&t.clientY<=s+4}(i.dom,e)||this.pending){let{pos:i}=r[0]||this.pending,o=null!==(n=null===(t=r[0])||void 0===t?void 0:t.end)&&void 0!==n?n:i;(i==o?this.view.posAtCoords(this.lastMove)==i:function(e,t,n,r,i){let o=e.scrollDOM.getBoundingClientRect(),s=e.documentTop+e.documentPadding.top+e.contentHeight;if(o.left>r||o.right<r||o.top>i||Math.min(o.bottom,s)<i)return!1;let a=e.posAtCoords({x:r,y:i},!1);return a>=t&&a<=n}(this.view,i,o,e.clientX,e.clientY))||(this.view.dispatch({effects:this.setHover.of([])}),this.pending=null)}}mouseleave(e){clearTimeout(this.hoverTimeout),this.hoverTimeout=-1;let{active:t}=this;if(t.length){let{tooltip:t}=this;t&&t.dom.contains(e.relatedTarget)?this.watchTooltipLeave(t.dom):this.view.dispatch({effects:this.setHover.of([])})}}watchTooltipLeave(e){let t=n=>{e.removeEventListener("mouseleave",t),this.active.length&&!this.view.dom.contains(n.relatedTarget)&&this.view.dispatch({effects:this.setHover.of([])})};e.addEventListener("mouseleave",t)}destroy(){clearTimeout(this.hoverTimeout),clearTimeout(this.restartTimeout),this.view.dom.removeEventListener("mouseleave",this.mouseleave),this.view.dom.removeEventListener("mousemove",this.mousemove)}}function UO(e,t={}){let n=Qy.define(),r=gy.define({create:()=>[],update(e,r){if(e.length&&(t.hideOnChange&&(r.docChanged||r.selection)?e=[]:t.hideOn&&(e=e.filter(e=>!t.hideOn(r,e))),r.docChanged)){let t=[];for(let n of e){let e=r.changes.mapPos(n.pos,-1,Yb.TrackDel);if(null!=e){let i=Object.assign(Object.create(null),n);i.pos=e,null!=i.end&&(i.end=r.changes.mapPos(i.end)),t.push(i)}}e=t}for(let t of r.effects)t.is(n)&&(e=t.value),t.is(YO)&&(e=[]);return e},provide:e=>$O.from(e)});return{active:r,extension:[r,dC.define(i=>new qO(i,e,r,n,t.hoverTime||300)),jO]}}function GO(e,t){let n=e.plugin(QO);if(!n)return null;let r=n.manager.tooltips.indexOf(t);return r<0?null:n.manager.tooltipViews[r]}const YO=Qy.define();const XO=ly.define({combine(e){let t,n;for(let r of e)t=t||r.topContainer,n=n||r.bottomContainer;return{topContainer:t,bottomContainer:n}}});function JO(e,t){let n=e.plugin(KO),r=n?n.specs.indexOf(t):-1;return r>-1?n.panels[r]:null}const KO=dC.fromClass(class{constructor(e){this.input=e.state.facet(tB),this.specs=this.input.filter(e=>e),this.panels=this.specs.map(t=>t(e));let t=e.state.facet(XO);this.top=new ZO(e,!0,t.topContainer),this.bottom=new ZO(e,!1,t.bottomContainer),this.top.sync(this.panels.filter(e=>e.top)),this.bottom.sync(this.panels.filter(e=>!e.top));for(let e of this.panels)e.dom.classList.add("cm-panel"),e.mount&&e.mount()}update(e){let t=e.state.facet(XO);this.top.container!=t.topContainer&&(this.top.sync([]),this.top=new ZO(e.view,!0,t.topContainer)),this.bottom.container!=t.bottomContainer&&(this.bottom.sync([]),this.bottom=new ZO(e.view,!1,t.bottomContainer)),this.top.syncClasses(),this.bottom.syncClasses();let n=e.state.facet(tB);if(n!=this.input){let t=n.filter(e=>e),r=[],i=[],o=[],s=[];for(let n of t){let t,a=this.specs.indexOf(n);a<0?(t=n(e.view),s.push(t)):(t=this.panels[a],t.update&&t.update(e)),r.push(t),(t.top?i:o).push(t)}this.specs=t,this.panels=r,this.top.sync(i),this.bottom.sync(o);for(let e of s)e.dom.classList.add("cm-panel"),e.mount&&e.mount()}else for(let t of this.panels)t.update&&t.update(e)}destroy(){this.top.sync([]),this.bottom.sync([])}},{provide:e=>NS.scrollMargins.of(t=>{let n=t.plugin(e);return n&&{top:n.top.scrollMargin(),bottom:n.bottom.scrollMargin()}})});class ZO{constructor(e,t,n){this.view=e,this.top=t,this.container=n,this.dom=void 0,this.classes="",this.panels=[],this.syncClasses()}sync(e){for(let t of this.panels)t.destroy&&e.indexOf(t)<0&&t.destroy();this.panels=e,this.syncDOM()}syncDOM(){if(0==this.panels.length)return void(this.dom&&(this.dom.remove(),this.dom=void 0));if(!this.dom){this.dom=document.createElement("div"),this.dom.className=this.top?"cm-panels cm-panels-top":"cm-panels cm-panels-bottom",this.dom.style[this.top?"top":"bottom"]="0";let e=this.container||this.view.dom;e.insertBefore(this.dom,this.top?e.firstChild:null)}let e=this.dom.firstChild;for(let t of this.panels)if(t.dom.parentNode==this.dom){for(;e!=t.dom;)e=eB(e);e=e.nextSibling}else this.dom.insertBefore(t.dom,e);for(;e;)e=eB(e)}scrollMargin(){return!this.dom||this.container?0:Math.max(0,this.top?this.dom.getBoundingClientRect().bottom-Math.max(0,this.view.scrollDOM.getBoundingClientRect().top):Math.min(innerHeight,this.view.scrollDOM.getBoundingClientRect().bottom)-this.dom.getBoundingClientRect().top)}syncClasses(){if(this.container&&this.classes!=this.view.themeClasses){for(let e of this.classes.split(" "))e&&this.container.classList.remove(e);for(let e of(this.classes=this.view.themeClasses).split(" "))e&&this.container.classList.add(e)}}}function eB(e){let t=e.nextSibling;return e.remove(),t}const tB=ly.define({enables:KO});function nB(e,t){let n,r=new Promise(e=>n=e),i=e=>function(e,t,n){let r=t.content?t.content(e,()=>s(null)):null;if(!r){if(r=Tx("form"),t.input){let e=Tx("input",t.input);/^(text|password|number|email|tel|url)$/.test(e.type)&&e.classList.add("cm-textfield"),e.name||(e.name="input"),r.appendChild(Tx("label",(t.label||"")+": ",e))}else r.appendChild(document.createTextNode(t.label||""));r.appendChild(document.createTextNode(" ")),r.appendChild(Tx("button",{class:"cm-button",type:"submit"},t.submitLabel||"OK"))}let i="FORM"==r.nodeName?[r]:r.querySelectorAll("form");for(let e=0;e<i.length;e++){let t=i[e];t.addEventListener("keydown",e=>{27==e.keyCode?(e.preventDefault(),s(null)):13==e.keyCode&&(e.preventDefault(),s(t))}),t.addEventListener("submit",e=>{e.preventDefault(),s(t)})}let o=Tx("div",r,Tx("button",{onclick:()=>s(null),"aria-label":e.state.phrase("close"),class:"cm-dialog-close",type:"button"},["×"]));t.class&&(o.className=t.class);function s(t){o.contains(o.ownerDocument.activeElement)&&e.focus(),n(t)}return o.classList.add("cm-dialog"),{dom:o,top:t.top,mount:()=>{if(t.focus){let e;e="string"==typeof t.focus?r.querySelector(t.focus):r.querySelector("input")||r.querySelector("button"),e&&"select"in e?e.select():e&&"focus"in e&&e.focus()}}}}(e,t,n);e.state.field(rB,!1)?e.dispatch({effects:iB.of(i)}):e.dispatch({effects:Qy.appendConfig.of(rB.init(()=>[i]))});let o=oB.of(i);return{close:o,result:r.then(t=>((e.win.queueMicrotask||(t=>e.win.setTimeout(t,10)))(()=>{e.state.field(rB).indexOf(i)>-1&&e.dispatch({effects:o})}),t))}}const rB=gy.define({create:()=>[],update(e,t){for(let n of t.effects)n.is(iB)?e=[n.value].concat(e):n.is(oB)&&(e=e.filter(e=>e!=n.value));return e},provide:e=>tB.computeN([e],t=>t.field(e))}),iB=Qy.define(),oB=Qy.define();class sB extends Ky{compare(e){return this==e||this.constructor==e.constructor&&this.eq(e)}eq(e){return!1}destroy(e){}}sB.prototype.elementClass="",sB.prototype.toDOM=void 0,sB.prototype.mapMode=Yb.TrackBefore,sB.prototype.startSide=sB.prototype.endSide=-1,sB.prototype.point=!0;const aB=ly.define(),lB=ly.define(),cB={class:"",renderEmptyElements:!1,elementStyle:"",markers:()=>rx.empty,lineMarker:()=>null,widgetMarker:()=>null,lineMarkerChange:null,initialSpacer:null,updateSpacer:null,domEventHandlers:{},side:"before"},dB=ly.define();function hB(e){return[pB(),dB.of({...cB,...e})]}const uB=ly.define({combine:e=>e.some(e=>e)});function pB(e){let t=[fB];return e&&!1===e.fixed&&t.push(uB.of(!0)),t}const fB=dC.fromClass(class{constructor(e){this.view=e,this.domAfter=null,this.prevViewport=e.viewport,this.dom=document.createElement("div"),this.dom.className="cm-gutters cm-gutters-before",this.dom.setAttribute("aria-hidden","true"),this.dom.style.minHeight=this.view.contentHeight/this.view.scaleY+"px",this.gutters=e.state.facet(dB).map(t=>new AB(e,t)),this.fixed=!e.state.facet(uB);for(let e of this.gutters)"after"==e.config.side?this.getDOMAfter().appendChild(e.dom):this.dom.appendChild(e.dom);this.fixed&&(this.dom.style.position="sticky"),this.syncGutters(!1),e.scrollDOM.insertBefore(this.dom,e.contentDOM)}getDOMAfter(){return this.domAfter||(this.domAfter=document.createElement("div"),this.domAfter.className="cm-gutters cm-gutters-after",this.domAfter.setAttribute("aria-hidden","true"),this.domAfter.style.minHeight=this.view.contentHeight/this.view.scaleY+"px",this.domAfter.style.position=this.fixed?"sticky":"",this.view.scrollDOM.appendChild(this.domAfter)),this.domAfter}update(e){if(this.updateGutters(e)){let t=this.prevViewport,n=e.view.viewport,r=Math.min(t.to,n.to)-Math.max(t.from,n.from);this.syncGutters(r<.8*(n.to-n.from))}if(e.geometryChanged){let e=this.view.contentHeight/this.view.scaleY+"px";this.dom.style.minHeight=e,this.domAfter&&(this.domAfter.style.minHeight=e)}this.view.state.facet(uB)!=!this.fixed&&(this.fixed=!this.fixed,this.dom.style.position=this.fixed?"sticky":"",this.domAfter&&(this.domAfter.style.position=this.fixed?"sticky":"")),this.prevViewport=e.view.viewport}syncGutters(e){let t=this.dom.nextSibling;e&&(this.dom.remove(),this.domAfter&&this.domAfter.remove());let n=rx.iter(this.view.state.facet(aB),this.view.viewport.from),r=[],i=this.gutters.map(e=>new vB(e,this.view.viewport,-this.view.documentPadding.top));for(let e of this.view.viewportLineBlocks)if(r.length&&(r=[]),Array.isArray(e.type)){let t=!0;for(let o of e.type)if(o.type==Yx.Text&&t){mB(n,r,o.from);for(let e of i)e.line(this.view,o,r);t=!1}else if(o.widget)for(let e of i)e.widget(this.view,o)}else if(e.type==Yx.Text){mB(n,r,e.from);for(let t of i)t.line(this.view,e,r)}else if(e.widget)for(let t of i)t.widget(this.view,e);for(let e of i)e.finish();e&&(this.view.scrollDOM.insertBefore(this.dom,t),this.domAfter&&this.view.scrollDOM.appendChild(this.domAfter))}updateGutters(e){let t=e.startState.facet(dB),n=e.state.facet(dB),r=e.docChanged||e.heightChanged||e.viewportChanged||!rx.eq(e.startState.facet(aB),e.state.facet(aB),e.view.viewport.from,e.view.viewport.to);if(t==n)for(let t of this.gutters)t.update(e)&&(r=!0);else{r=!0;let i=[];for(let r of n){let n=t.indexOf(r);n<0?i.push(new AB(this.view,r)):(this.gutters[n].update(e),i.push(this.gutters[n]))}for(let e of this.gutters)e.dom.remove(),i.indexOf(e)<0&&e.destroy();for(let e of i)"after"==e.config.side?this.getDOMAfter().appendChild(e.dom):this.dom.appendChild(e.dom);this.gutters=i}return r}destroy(){for(let e of this.gutters)e.destroy();this.dom.remove(),this.domAfter&&this.domAfter.remove()}},{provide:e=>NS.scrollMargins.of(t=>{let n=t.plugin(e);if(!n||0==n.gutters.length||!n.fixed)return null;let r=n.dom.offsetWidth*t.scaleX,i=n.domAfter?n.domAfter.offsetWidth*t.scaleX:0;return t.textDirection==Sw.LTR?{left:r,right:i}:{right:r,left:i}})});function gB(e){return Array.isArray(e)?e:[e]}function mB(e,t,n){for(;e.value&&e.from<=n;)e.from==n&&t.push(e.value),e.next()}class vB{constructor(e,t,n){this.gutter=e,this.height=n,this.i=0,this.cursor=rx.iter(e.markers,t.from)}addElement(e,t,n){let{gutter:r}=this,i=(t.top-this.height)/e.scaleY,o=t.height/e.scaleY;if(this.i==r.elements.length){let t=new bB(e,o,i,n);r.elements.push(t),r.dom.appendChild(t.dom)}else r.elements[this.i].update(e,o,i,n);this.height=t.bottom,this.i++}line(e,t,n){let r=[];mB(this.cursor,r,t.from),n.length&&(r=r.concat(n));let i=this.gutter.config.lineMarker(e,t,r);i&&r.unshift(i);let o=this.gutter;(0!=r.length||o.config.renderEmptyElements)&&this.addElement(e,t,r)}widget(e,t){let n=this.gutter.config.widgetMarker(e,t.widget,t),r=n?[n]:null;for(let n of e.state.facet(lB)){let i=n(e,t.widget,t);i&&(r||(r=[])).push(i)}r&&this.addElement(e,t,r)}finish(){let e=this.gutter;for(;e.elements.length>this.i;){let t=e.elements.pop();e.dom.removeChild(t.dom),t.destroy()}}}class AB{constructor(e,t){this.view=e,this.config=t,this.elements=[],this.spacer=null,this.dom=document.createElement("div"),this.dom.className="cm-gutter"+(this.config.class?" "+this.config.class:"");for(let n in t.domEventHandlers)this.dom.addEventListener(n,r=>{let i,o=r.target;if(o!=this.dom&&this.dom.contains(o)){for(;o.parentNode!=this.dom;)o=o.parentNode;let e=o.getBoundingClientRect();i=(e.top+e.bottom)/2}else i=r.clientY;let s=e.lineBlockAtHeight(i-e.documentTop);t.domEventHandlers[n](e,s,r)&&r.preventDefault()});this.markers=gB(t.markers(e)),t.initialSpacer&&(this.spacer=new bB(e,0,0,[t.initialSpacer(e)]),this.dom.appendChild(this.spacer.dom),this.spacer.dom.style.cssText+="visibility: hidden; pointer-events: none")}update(e){let t=this.markers;if(this.markers=gB(this.config.markers(e.view)),this.spacer&&this.config.updateSpacer){let t=this.config.updateSpacer(this.spacer.markers[0],e);t!=this.spacer.markers[0]&&this.spacer.update(e.view,0,0,[t])}let n=e.view.viewport;return!rx.eq(this.markers,t,n.from,n.to)||!!this.config.lineMarkerChange&&this.config.lineMarkerChange(e)}destroy(){for(let e of this.elements)e.destroy()}}class bB{constructor(e,t,n,r){this.height=-1,this.above=0,this.markers=[],this.dom=document.createElement("div"),this.dom.className="cm-gutterElement",this.update(e,t,n,r)}update(e,t,n,r){this.height!=t&&(this.height=t,this.dom.style.height=t+"px"),this.above!=n&&(this.dom.style.marginTop=(this.above=n)?n+"px":""),function(e,t){if(e.length!=t.length)return!1;for(let n=0;n<e.length;n++)if(!e[n].compare(t[n]))return!1;return!0}(this.markers,r)||this.setMarkers(e,r)}setMarkers(e,t){let n="cm-gutterElement",r=this.dom.firstChild;for(let i=0,o=0;;){let s=o,a=i<t.length?t[i++]:null,l=!1;if(a){let e=a.elementClass;e&&(n+=" "+e);for(let e=o;e<this.markers.length;e++)if(this.markers[e].compare(a)){s=e,l=!0;break}}else s=this.markers.length;for(;o<s;){let e=this.markers[o++];if(e.toDOM){e.destroy(r);let t=r.nextSibling;r.remove(),r=t}}if(!a)break;a.toDOM&&(l?r=r.nextSibling:this.dom.insertBefore(a.toDOM(e),r)),l&&o++}this.dom.className=n,this.markers=t}destroy(){this.setMarkers(null,[])}}const yB=ly.define(),xB=ly.define(),wB=ly.define({combine:e=>Jy(e,{formatNumber:String,domEventHandlers:{}},{domEventHandlers(e,t){let n=Object.assign({},e);for(let e in t){let r=n[e],i=t[e];n[e]=r?(e,t,n)=>r(e,t,n)||i(e,t,n):i}return n}})});class CB extends sB{constructor(e){super(),this.number=e}eq(e){return this.number==e.number}toDOM(){return document.createTextNode(this.number)}}function kB(e,t){return e.state.facet(wB).formatNumber(t,e.state)}const SB=dB.compute([wB],e=>({class:"cm-lineNumbers",renderEmptyElements:!1,markers:e=>e.state.facet(yB),lineMarker:(e,t,n)=>n.some(e=>e.toDOM)?null:new CB(kB(e,e.state.doc.lineAt(t.from).number)),widgetMarker:(e,t,n)=>{for(let r of e.state.facet(xB)){let i=r(e,t,n);if(i)return i}return null},lineMarkerChange:e=>e.startState.facet(wB)!=e.state.facet(wB),initialSpacer:e=>new CB(kB(e,BB(e.state.doc.lines))),updateSpacer(e,t){let n=kB(t.view,BB(t.view.state.doc.lines));return n==e.number?e:new CB(n)},domEventHandlers:e.facet(wB).domEventHandlers,side:"before"}));function OB(e={}){return[wB.of(e),pB(),SB]}function BB(e){let t=9;for(;t<e;)t=10*t+9;return t}const _B=new class extends sB{constructor(){super(...arguments),this.elementClass="cm-activeLineGutter"}},TB=aB.compute(["selection"],e=>{let t=[],n=-1;for(let r of e.selection.ranges){let i=e.doc.lineAt(r.head).from;i>n&&(n=i,t.push(_B.range(i)))}return rx.of(t)});const EB=1024;let MB=0;class DB{constructor(e,t){this.from=e,this.to=t}}class PB{constructor(e={}){this.id=MB++,this.perNode=!!e.perNode,this.deserialize=e.deserialize||(()=>{throw new Error("This node type doesn't define a deserialize function")}),this.combine=e.combine||null}add(e){if(this.perNode)throw new RangeError("Can't add per-node props to node types");return"function"!=typeof e&&(e=NB.match(e)),t=>{let n=e(t);return void 0===n?null:[this,n]}}}PB.closedBy=new PB({deserialize:e=>e.split(" ")}),PB.openedBy=new PB({deserialize:e=>e.split(" ")}),PB.group=new PB({deserialize:e=>e.split(" ")}),PB.isolate=new PB({deserialize:e=>{if(e&&"rtl"!=e&&"ltr"!=e&&"auto"!=e)throw new RangeError("Invalid value for isolate: "+e);return e||"auto"}}),PB.contextHash=new PB({perNode:!0}),PB.lookAhead=new PB({perNode:!0}),PB.mounted=new PB({perNode:!0});class RB{constructor(e,t,n,r=!1){this.tree=e,this.overlay=t,this.parser=n,this.bracketed=r}static get(e){return e&&e.props&&e.props[PB.mounted.id]}}const IB=Object.create(null);class NB{constructor(e,t,n,r=0){this.name=e,this.props=t,this.id=n,this.flags=r}static define(e){let t=e.props&&e.props.length?Object.create(null):IB,n=(e.top?1:0)|(e.skipped?2:0)|(e.error?4:0)|(null==e.name?8:0),r=new NB(e.name||"",t,e.id,n);if(e.props)for(let n of e.props)if(Array.isArray(n)||(n=n(r)),n){if(n[0].perNode)throw new RangeError("Can't store a per-node prop on a node type");t[n[0].id]=n[1]}return r}prop(e){return this.props[e.id]}get isTop(){return(1&this.flags)>0}get isSkipped(){return(2&this.flags)>0}get isError(){return(4&this.flags)>0}get isAnonymous(){return(8&this.flags)>0}is(e){if("string"==typeof e){if(this.name==e)return!0;let t=this.prop(PB.group);return!!t&&t.indexOf(e)>-1}return this.id==e}static match(e){let t=Object.create(null);for(let n in e)for(let r of n.split(" "))t[r]=e[n];return e=>{for(let n=e.prop(PB.group),r=-1;r<(n?n.length:0);r++){let i=t[r<0?e.name:n[r]];if(i)return i}}}}NB.none=new NB("",Object.create(null),0,8);class LB{constructor(e){this.types=e;for(let t=0;t<e.length;t++)if(e[t].id!=t)throw new RangeError("Node type ids should correspond to array positions when creating a node set")}extend(...e){let t=[];for(let n of this.types){let r=null;for(let t of e){let e=t(n);if(e){r||(r=Object.assign({},n.props));let t=e[1],i=e[0];i.combine&&i.id in r&&(t=i.combine(r[i.id],t)),r[i.id]=t}}t.push(r?new NB(n.name,r,n.id,n.flags):n)}return new LB(t)}}const QB=new WeakMap,FB=new WeakMap;var VB;!function(e){e[e.ExcludeBuffers=1]="ExcludeBuffers",e[e.IncludeAnonymous=2]="IncludeAnonymous",e[e.IgnoreMounts=4]="IgnoreMounts",e[e.IgnoreOverlays=8]="IgnoreOverlays",e[e.EnterBracketed=16]="EnterBracketed"}(VB||(VB={}));class zB{constructor(e,t,n,r,i){if(this.type=e,this.children=t,this.positions=n,this.length=r,this.props=null,i&&i.length){this.props=Object.create(null);for(let[e,t]of i)this.props["number"==typeof e?e:e.id]=t}}toString(){let e=RB.get(this);if(e&&!e.overlay)return e.tree.toString();let t="";for(let e of this.children){let n=e.toString();n&&(t&&(t+=","),t+=n)}return this.type.name?(/\W/.test(this.type.name)&&!this.type.isError?JSON.stringify(this.type.name):this.type.name)+(t.length?"("+t+")":""):t}cursor(e=0){return new e_(this.topNode,e)}cursorAt(e,t=0,n=0){let r=QB.get(this)||this.topNode,i=new e_(r);return i.moveTo(e,t),QB.set(this,i._tree),i}get topNode(){return new UB(this,0,0,null)}resolve(e,t=0){let n=jB(QB.get(this)||this.topNode,e,t,!1);return QB.set(this,n),n}resolveInner(e,t=0){let n=jB(FB.get(this)||this.topNode,e,t,!0);return FB.set(this,n),n}resolveStack(e,t=0){return function(e,t,n){let r=e.resolveInner(t,n),i=null;for(let e=r instanceof UB?r:r.context.parent;e;e=e.parent)if(e.index<0){let o=e.parent;(i||(i=[r])).push(o.resolve(t,n)),e=o}else{let o=RB.get(e.tree);if(o&&o.overlay&&o.overlay[0].from<=t&&o.overlay[o.overlay.length-1].to>=t){let s=new UB(o.tree,o.overlay[0].from+e.from,-1,e);(i||(i=[r])).push(jB(s,t,n,!1))}}return i?KB(i):r}(this,e,t)}iterate(e){let{enter:t,leave:n,from:r=0,to:i=this.length}=e,o=e.mode||0,s=(o&VB.IncludeAnonymous)>0;for(let e=this.cursor(o|VB.IncludeAnonymous);;){let o=!1;if(e.from<=i&&e.to>=r&&(!s&&e.type.isAnonymous||!1!==t(e))){if(e.firstChild())continue;o=!0}for(;o&&n&&(s||!e.type.isAnonymous)&&n(e),!e.nextSibling();){if(!e.parent())return;o=!0}}}prop(e){return e.perNode?this.props?this.props[e.id]:void 0:this.type.prop(e)}get propValues(){let e=[];if(this.props)for(let t in this.props)e.push([+t,this.props[t]]);return e}balance(e={}){return this.children.length<=8?this:i_(NB.none,this.children,this.positions,0,this.children.length,0,this.length,(e,t,n)=>new zB(this.type,e,t,n,this.propValues),e.makeTree||((e,t,n)=>new zB(NB.none,e,t,n)))}static build(e){return function(e){var t;let{buffer:n,nodeSet:r,maxBufferLength:i=EB,reused:o=[],minRepeatType:s=r.types.length}=e,a=Array.isArray(n)?new WB(n,n.length):n,l=r.types,c=0,d=0;function h(e,t,n,A,b,y){let{id:x,start:w,end:C,size:k}=a,S=d,O=c;if(k<0){if(a.next(),-1==k){let t=o[x];return n.push(t),void A.push(w-e)}if(-3==k)return void(c=x);if(-4==k)return void(d=x);throw new RangeError(`Unrecognized record size: ${k}`)}let B,_,T=l[x],E=w-e;if(C-w<=i&&(_=m(a.pos-t,b))){let t=new Uint16Array(_.size-_.skip),n=a.pos-_.size,i=t.length;for(;a.pos>n;)i=v(_.start,t,i);B=new $B(t,C-_.start,r),E=_.start-e}else{let e=a.pos-k;a.next();let t=[],n=[],r=x>=s?x:-1,o=0,l=C;for(;a.pos>e;)r>=0&&a.id==r&&a.size>=0?(a.end<=l-i&&(f(t,n,w,o,a.end,l,r,S,O),o=t.length,l=a.end),a.next()):y>2500?u(w,e,t,n):h(w,e,t,n,r,y+1);if(r>=0&&o>0&&o<t.length&&f(t,n,w,o,w,l,r,S,O),t.reverse(),n.reverse(),r>-1&&o>0){let e=p(T,O);B=i_(T,t,n,0,t.length,0,C-w,e,e)}else B=g(T,t,n,C-w,S-C,O)}n.push(B),A.push(E)}function u(e,t,n,o){let s=[],l=0,c=-1;for(;a.pos>t;){let{id:e,start:t,end:n,size:r}=a;if(r>4)a.next();else{if(c>-1&&t<c)break;c<0&&(c=n-i),s.push(e,t,n),l++,a.next()}}if(l){let t=new Uint16Array(4*l),i=s[s.length-2];for(let e=s.length-3,n=0;e>=0;e-=3)t[n++]=s[e],t[n++]=s[e+1]-i,t[n++]=s[e+2]-i,t[n++]=n;n.push(new $B(t,s[2]-i,r)),o.push(i-e)}}function p(e,t){return(n,r,i)=>{let o,s,a=0,l=n.length-1;if(l>=0&&(o=n[l])instanceof zB){if(!l&&o.type==e&&o.length==i)return o;(s=o.prop(PB.lookAhead))&&(a=r[l]+o.length+s)}return g(e,n,r,i,a,t)}}function f(e,t,n,i,o,s,a,l,c){let d=[],h=[];for(;e.length>i;)d.push(e.pop()),h.push(t.pop()+n-o);e.push(g(r.types[a],d,h,s-o,l-s,c)),t.push(o-n)}function g(e,t,n,r,i,o,s){if(o){let e=[PB.contextHash,o];s=s?[e].concat(s):[e]}if(i>25){let e=[PB.lookAhead,i];s=s?[e].concat(s):[e]}return new zB(e,t,n,r,s)}function m(e,t){let n=a.fork(),r=0,o=0,l=0,c=n.end-i,d={size:0,start:0,skip:0};e:for(let i=n.pos-e;n.pos>i;){let e=n.size;if(n.id==t&&e>=0){d.size=r,d.start=o,d.skip=l,l+=4,r+=4,n.next();continue}let a=n.pos-e;if(e<0||a<i||n.start<c)break;let h=n.id>=s?4:0,u=n.start;for(n.next();n.pos>a;){if(n.size<0){if(-3!=n.size&&-4!=n.size)break e;h+=4}else n.id>=s&&(h+=4);n.next()}o=u,r+=e,l+=h}return(t<0||r==e)&&(d.size=r,d.start=o,d.skip=l),d.size>4?d:void 0}function v(e,t,n){let{id:r,start:i,end:o,size:l}=a;if(a.next(),l>=0&&r<s){let s=n;if(l>4){let r=a.pos-(l-4);for(;a.pos>r;)n=v(e,t,n)}t[--n]=s,t[--n]=o-e,t[--n]=i-e,t[--n]=r}else-3==l?c=r:-4==l&&(d=r);return n}let A=[],b=[];for(;a.pos>0;)h(e.start||0,e.bufferStart||0,A,b,-1,0);let y=null!==(t=e.length)&&void 0!==t?t:A.length?b[0]+A[0].length:0;return new zB(l[e.topID],A.reverse(),b.reverse(),y)}(e)}}zB.empty=new zB(NB.none,[],[],0);class WB{constructor(e,t){this.buffer=e,this.index=t}get id(){return this.buffer[this.index-4]}get start(){return this.buffer[this.index-3]}get end(){return this.buffer[this.index-2]}get size(){return this.buffer[this.index-1]}get pos(){return this.index}next(){this.index-=4}fork(){return new WB(this.buffer,this.index)}}class $B{constructor(e,t,n){this.buffer=e,this.length=t,this.set=n}get type(){return NB.none}toString(){let e=[];for(let t=0;t<this.buffer.length;)e.push(this.childString(t)),t=this.buffer[t+3];return e.join(",")}childString(e){let t=this.buffer[e],n=this.buffer[e+3],r=this.set.types[t],i=r.name;if(/\W/.test(i)&&!r.isError&&(i=JSON.stringify(i)),n==(e+=4))return i;let o=[];for(;e<n;)o.push(this.childString(e)),e=this.buffer[e+3];return i+"("+o.join(",")+")"}findChild(e,t,n,r,i){let{buffer:o}=this,s=-1;for(let a=e;a!=t&&!(HB(i,r,o[a+1],o[a+2])&&(s=a,n>0));a=o[a+3]);return s}slice(e,t,n){let r=this.buffer,i=new Uint16Array(t-e),o=0;for(let s=e,a=0;s<t;){i[a++]=r[s++],i[a++]=r[s++]-n;let t=i[a++]=r[s++]-n;i[a++]=r[s++]-e,o=Math.max(o,t)}return new $B(i,o,this.set)}}function HB(e,t,n,r){switch(e){case-2:return n<t;case-1:return r>=t&&n<t;case 0:return n<t&&r>t;case 1:return n<=t&&r>t;case 2:return r>t;case 4:return!0}}function jB(e,t,n,r){for(var i;e.from==e.to||(n<1?e.from>=t:e.from>t)||(n>-1?e.to<=t:e.to<t);){let t=!r&&e instanceof UB&&e.index<0?null:e.parent;if(!t)return e;e=t}let o=r?0:VB.IgnoreOverlays;if(r)for(let r=e,s=r.parent;s;r=s,s=r.parent)r instanceof UB&&r.index<0&&(null===(i=s.enter(t,n,o))||void 0===i?void 0:i.from)!=r.from&&(e=s);for(;;){let r=e.enter(t,n,o);if(!r)return e;e=r}}class qB{cursor(e=0){return new e_(this,e)}getChild(e,t=null,n=null){let r=GB(this,e,t,n);return r.length?r[0]:null}getChildren(e,t=null,n=null){return GB(this,e,t,n)}resolve(e,t=0){return jB(this,e,t,!1)}resolveInner(e,t=0){return jB(this,e,t,!0)}matchContext(e){return YB(this.parent,e)}enterUnfinishedNodesBefore(e){let t=this.childBefore(e),n=this;for(;t;){let e=t.lastChild;if(!e||e.to!=t.to)break;e.type.isError&&e.from==e.to?(n=t,t=e.prevSibling):t=e}return n}get node(){return this}get next(){return this.parent}}class UB extends qB{constructor(e,t,n,r){super(),this._tree=e,this.from=t,this.index=n,this._parent=r}get type(){return this._tree.type}get name(){return this._tree.type.name}get to(){return this.from+this._tree.length}nextChild(e,t,n,r,i=0){var o;for(let s=this;;){for(let{children:a,positions:l}=s._tree,c=t>0?a.length:-1;e!=c;e+=t){let c=a[e],d=l[e]+s.from;if(i&VB.EnterBracketed&&c instanceof zB&&null===(null===(o=RB.get(c))||void 0===o?void 0:o.overlay)&&(d>=n||d+c.length<=n)||HB(r,n,d,d+c.length))if(c instanceof $B){if(i&VB.ExcludeBuffers)continue;let o=c.findChild(0,c.buffer.length,t,n-d,r);if(o>-1)return new JB(new XB(s,c,e,d),null,o)}else if(i&VB.IncludeAnonymous||!c.type.isAnonymous||t_(c)){let o;if(!(i&VB.IgnoreMounts)&&(o=RB.get(c))&&!o.overlay)return new UB(o.tree,d,e,s);let a=new UB(c,d,e,s);return i&VB.IncludeAnonymous||!a.type.isAnonymous?a:a.nextChild(t<0?c.children.length-1:0,t,n,r,i)}}if(i&VB.IncludeAnonymous||!s.type.isAnonymous)return null;if(e=s.index>=0?s.index+t:t<0?-1:s._parent._tree.children.length,s=s._parent,!s)return null}}get firstChild(){return this.nextChild(0,1,0,4)}get lastChild(){return this.nextChild(this._tree.children.length-1,-1,0,4)}childAfter(e){return this.nextChild(0,1,e,2)}childBefore(e){return this.nextChild(this._tree.children.length-1,-1,e,-2)}prop(e){return this._tree.prop(e)}enter(e,t,n=0){let r;if(!(n&VB.IgnoreOverlays)&&(r=RB.get(this._tree))&&r.overlay){let i=e-this.from,o=n&VB.EnterBracketed&&r.bracketed;for(let{from:e,to:n}of r.overlay)if((t>0||o?e<=i:e<i)&&(t<0||o?n>=i:n>i))return new UB(r.tree,r.overlay[0].from+this.from,-1,this)}return this.nextChild(0,1,e,t,n)}nextSignificantParent(){let e=this;for(;e.type.isAnonymous&&e._parent;)e=e._parent;return e}get parent(){return this._parent?this._parent.nextSignificantParent():null}get nextSibling(){return this._parent&&this.index>=0?this._parent.nextChild(this.index+1,1,0,4):null}get prevSibling(){return this._parent&&this.index>=0?this._parent.nextChild(this.index-1,-1,0,4):null}get tree(){return this._tree}toTree(){return this._tree}toString(){return this._tree.toString()}}function GB(e,t,n,r){let i=e.cursor(),o=[];if(!i.firstChild())return o;if(null!=n)for(let e=!1;!e;)if(e=i.type.is(n),!i.nextSibling())return o;for(;;){if(null!=r&&i.type.is(r))return o;if(i.type.is(t)&&o.push(i.node),!i.nextSibling())return null==r?o:[]}}function YB(e,t,n=t.length-1){for(let r=e;n>=0;r=r.parent){if(!r)return!1;if(!r.type.isAnonymous){if(t[n]&&t[n]!=r.name)return!1;n--}}return!0}class XB{constructor(e,t,n,r){this.parent=e,this.buffer=t,this.index=n,this.start=r}}class JB extends qB{get name(){return this.type.name}get from(){return this.context.start+this.context.buffer.buffer[this.index+1]}get to(){return this.context.start+this.context.buffer.buffer[this.index+2]}constructor(e,t,n){super(),this.context=e,this._parent=t,this.index=n,this.type=e.buffer.set.types[e.buffer.buffer[n]]}child(e,t,n){let{buffer:r}=this.context,i=r.findChild(this.index+4,r.buffer[this.index+3],e,t-this.context.start,n);return i<0?null:new JB(this.context,this,i)}get firstChild(){return this.child(1,0,4)}get lastChild(){return this.child(-1,0,4)}childAfter(e){return this.child(1,e,2)}childBefore(e){return this.child(-1,e,-2)}prop(e){return this.type.prop(e)}enter(e,t,n=0){if(n&VB.ExcludeBuffers)return null;let{buffer:r}=this.context,i=r.findChild(this.index+4,r.buffer[this.index+3],t>0?1:-1,e-this.context.start,t);return i<0?null:new JB(this.context,this,i)}get parent(){return this._parent||this.context.parent.nextSignificantParent()}externalSibling(e){return this._parent?null:this.context.parent.nextChild(this.context.index+e,e,0,4)}get nextSibling(){let{buffer:e}=this.context,t=e.buffer[this.index+3];return t<(this._parent?e.buffer[this._parent.index+3]:e.buffer.length)?new JB(this.context,this._parent,t):this.externalSibling(1)}get prevSibling(){let{buffer:e}=this.context,t=this._parent?this._parent.index+4:0;return this.index==t?this.externalSibling(-1):new JB(this.context,this._parent,e.findChild(t,this.index,-1,0,4))}get tree(){return null}toTree(){let e=[],t=[],{buffer:n}=this.context,r=this.index+4,i=n.buffer[this.index+3];if(i>r){let o=n.buffer[this.index+1];e.push(n.slice(r,i,o)),t.push(0)}return new zB(this.type,e,t,this.to-this.from)}toString(){return this.context.buffer.childString(this.index)}}function KB(e){if(!e.length)return null;let t=0,n=e[0];for(let r=1;r<e.length;r++){let i=e[r];(i.from>n.from||i.to<n.to)&&(n=i,t=r)}let r=n instanceof UB&&n.index<0?null:n.parent,i=e.slice();return r?i[t]=r:i.splice(t,1),new ZB(i,n)}class ZB{constructor(e,t){this.heads=e,this.node=t}get next(){return KB(this.heads)}}class e_{get name(){return this.type.name}constructor(e,t=0){if(this.buffer=null,this.stack=[],this.index=0,this.bufferNode=null,this.mode=t&~VB.EnterBracketed,e instanceof UB)this.yieldNode(e);else{this._tree=e.context.parent,this.buffer=e.context;for(let t=e._parent;t;t=t._parent)this.stack.unshift(t.index);this.bufferNode=e,this.yieldBuf(e.index)}}yieldNode(e){return!!e&&(this._tree=e,this.type=e.type,this.from=e.from,this.to=e.to,!0)}yieldBuf(e,t){this.index=e;let{start:n,buffer:r}=this.buffer;return this.type=t||r.set.types[r.buffer[e]],this.from=n+r.buffer[e+1],this.to=n+r.buffer[e+2],!0}yield(e){return!!e&&(e instanceof UB?(this.buffer=null,this.yieldNode(e)):(this.buffer=e.context,this.yieldBuf(e.index,e.type)))}toString(){return this.buffer?this.buffer.buffer.childString(this.index):this._tree.toString()}enterChild(e,t,n){if(!this.buffer)return this.yield(this._tree.nextChild(e<0?this._tree._tree.children.length-1:0,e,t,n,this.mode));let{buffer:r}=this.buffer,i=r.findChild(this.index+4,r.buffer[this.index+3],e,t-this.buffer.start,n);return!(i<0)&&(this.stack.push(this.index),this.yieldBuf(i))}firstChild(){return this.enterChild(1,0,4)}lastChild(){return this.enterChild(-1,0,4)}childAfter(e){return this.enterChild(1,e,2)}childBefore(e){return this.enterChild(-1,e,-2)}enter(e,t,n=this.mode){return this.buffer?!(n&VB.ExcludeBuffers)&&this.enterChild(1,e,t):this.yield(this._tree.enter(e,t,n))}parent(){if(!this.buffer)return this.yieldNode(this.mode&VB.IncludeAnonymous?this._tree._parent:this._tree.parent);if(this.stack.length)return this.yieldBuf(this.stack.pop());let e=this.mode&VB.IncludeAnonymous?this.buffer.parent:this.buffer.parent.nextSignificantParent();return this.buffer=null,this.yieldNode(e)}sibling(e){if(!this.buffer)return!!this._tree._parent&&this.yield(this._tree.index<0?null:this._tree._parent.nextChild(this._tree.index+e,e,0,4,this.mode));let{buffer:t}=this.buffer,n=this.stack.length-1;if(e<0){let e=n<0?0:this.stack[n]+4;if(this.index!=e)return this.yieldBuf(t.findChild(e,this.index,-1,0,4))}else{let e=t.buffer[this.index+3];if(e<(n<0?t.buffer.length:t.buffer[this.stack[n]+3]))return this.yieldBuf(e)}return n<0&&this.yield(this.buffer.parent.nextChild(this.buffer.index+e,e,0,4,this.mode))}nextSibling(){return this.sibling(1)}prevSibling(){return this.sibling(-1)}atLastNode(e){let t,n,{buffer:r}=this;if(r){if(e>0){if(this.index<r.buffer.buffer.length)return!1}else for(let e=0;e<this.index;e++)if(r.buffer.buffer[e+3]<this.index)return!1;({index:t,parent:n}=r)}else({index:t,_parent:n}=this._tree);for(;n;({index:t,_parent:n}=n))if(t>-1)for(let r=t+e,i=e<0?-1:n._tree.children.length;r!=i;r+=e){let e=n._tree.children[r];if(this.mode&VB.IncludeAnonymous||e instanceof $B||!e.type.isAnonymous||t_(e))return!1}return!0}move(e,t){if(t&&this.enterChild(e,0,4))return!0;for(;;){if(this.sibling(e))return!0;if(this.atLastNode(e)||!this.parent())return!1}}next(e=!0){return this.move(1,e)}prev(e=!0){return this.move(-1,e)}moveTo(e,t=0){for(;(this.from==this.to||(t<1?this.from>=e:this.from>e)||(t>-1?this.to<=e:this.to<e))&&this.parent(););for(;this.enterChild(1,e,t););return this}get node(){if(!this.buffer)return this._tree;let e=this.bufferNode,t=null,n=0;if(e&&e.context==this.buffer)e:for(let r=this.index,i=this.stack.length;i>=0;){for(let o=e;o;o=o._parent)if(o.index==r){if(r==this.index)return o;t=o,n=i+1;break e}r=this.stack[--i]}for(let e=n;e<this.stack.length;e++)t=new JB(this.buffer,t,this.stack[e]);return this.bufferNode=new JB(this.buffer,t,this.index)}get tree(){return this.buffer?null:this._tree._tree}iterate(e,t){for(let n=0;;){let r=!1;if(this.type.isAnonymous||!1!==e(this)){if(this.firstChild()){n++;continue}this.type.isAnonymous||(r=!0)}for(;;){if(r&&t&&t(this),r=this.type.isAnonymous,!n)return;if(this.nextSibling())break;this.parent(),n--,r=!0}}}matchContext(e){if(!this.buffer)return YB(this.node.parent,e);let{buffer:t}=this.buffer,{types:n}=t.set;for(let r=e.length-1,i=this.stack.length-1;r>=0;i--){if(i<0)return YB(this._tree,e,r);let o=n[t.buffer[this.stack[i]]];if(!o.isAnonymous){if(e[r]&&e[r]!=o.name)return!1;r--}}return!0}}function t_(e){return e.children.some(e=>e instanceof $B||!e.type.isAnonymous||t_(e))}const n_=new WeakMap;function r_(e,t){if(!e.isAnonymous||t instanceof $B||t.type!=e)return 1;let n=n_.get(t);if(null==n){n=1;for(let r of t.children){if(r.type!=e||!(r instanceof zB)){n=1;break}n+=r_(e,r)}n_.set(t,n)}return n}function i_(e,t,n,r,i,o,s,a,l){let c=0;for(let n=r;n<i;n++)c+=r_(e,t[n]);let d=Math.ceil(1.5*c/8),h=[],u=[];return function t(n,r,i,s,a){for(let c=i;c<s;){let i=c,p=r[c],f=r_(e,n[c]);for(c++;c<s;c++){let t=r_(e,n[c]);if(f+t>=d)break;f+=t}if(c==i+1){if(f>d){let e=n[i];t(e.children,e.positions,0,e.children.length,r[i]+a);continue}h.push(n[i])}else{let t=r[c-1]+n[c-1].length-p;h.push(i_(e,n,r,i,c,p,t,null,l))}u.push(p+a-o)}}(t,n,r,i,0),(a||l)(h,u,s)}class o_{constructor(){this.map=new WeakMap}setBuffer(e,t,n){let r=this.map.get(e);r||this.map.set(e,r=new Map),r.set(t,n)}getBuffer(e,t){let n=this.map.get(e);return n&&n.get(t)}set(e,t){e instanceof JB?this.setBuffer(e.context.buffer,e.index,t):e instanceof UB&&this.map.set(e.tree,t)}get(e){return e instanceof JB?this.getBuffer(e.context.buffer,e.index):e instanceof UB?this.map.get(e.tree):void 0}cursorSet(e,t){e.buffer?this.setBuffer(e.buffer.buffer,e.index,t):this.map.set(e.tree,t)}cursorGet(e){return e.buffer?this.getBuffer(e.buffer.buffer,e.index):this.map.get(e.tree)}}class s_{constructor(e,t,n,r,i=!1,o=!1){this.from=e,this.to=t,this.tree=n,this.offset=r,this.open=(i?1:0)|(o?2:0)}get openStart(){return(1&this.open)>0}get openEnd(){return(2&this.open)>0}static addTree(e,t=[],n=!1){let r=[new s_(0,e.length,e,0,!1,n)];for(let n of t)n.to>e.length&&r.push(n);return r}static applyChanges(e,t,n=128){if(!t.length)return e;let r=[],i=1,o=e.length?e[0]:null;for(let s=0,a=0,l=0;;s++){let c=s<t.length?t[s]:null,d=c?c.fromA:1e9;if(d-a>=n)for(;o&&o.from<d;){let t=o;if(a>=t.from||d<=t.to||l){let e=Math.max(t.from,a)-l,n=Math.min(t.to,d)-l;t=e>=n?null:new s_(e,n,t.tree,t.offset+l,s>0,!!c)}if(t&&r.push(t),o.to>d)break;o=i<e.length?e[i++]:null}if(!c)break;a=c.toA,l=c.toA-c.toB}return r}}class a_{startParse(e,t,n){return"string"==typeof e&&(e=new l_(e)),n=n?n.length?n.map(e=>new DB(e.from,e.to)):[new DB(0,0)]:[new DB(0,e.length)],this.createParse(e,t||[],n)}parse(e,t,n){let r=this.startParse(e,t,n);for(;;){let e=r.advance();if(e)return e}}}class l_{constructor(e){this.string=e}get length(){return this.string.length}chunk(e){return this.string.slice(e)}get lineChunks(){return!1}read(e,t){return this.string.slice(e,t)}}new PB({perNode:!0});let c_=0;class d_{constructor(e,t,n,r){this.name=e,this.set=t,this.base=n,this.modified=r,this.id=c_++}toString(){let{name:e}=this;for(let t of this.modified)t.name&&(e=`${t.name}(${e})`);return e}static define(e,t){let n="string"==typeof e?e:"?";if(e instanceof d_&&(t=e),null==t?void 0:t.base)throw new Error("Can not derive from a modified tag");let r=new d_(n,[],null,[]);if(r.set.push(r),t)for(let e of t.set)r.set.push(e);return r}static defineModifier(e){let t=new u_(e);return e=>e.modified.indexOf(t)>-1?e:u_.get(e.base||e,e.modified.concat(t).sort((e,t)=>e.id-t.id))}}let h_=0;class u_{constructor(e){this.name=e,this.instances=[],this.id=h_++}static get(e,t){if(!t.length)return e;let n=t[0].instances.find(n=>{return n.base==e&&(r=t,i=n.modified,r.length==i.length&&r.every((e,t)=>e==i[t]));var r,i});if(n)return n;let r=[],i=new d_(e.name,r,e,t);for(let e of t)e.instances.push(i);let o=function(e){let t=[[]];for(let n=0;n<e.length;n++)for(let r=0,i=t.length;r<i;r++)t.push(t[r].concat(e[n]));return t.sort((e,t)=>t.length-e.length)}(t);for(let t of e.set)if(!t.modified.length)for(let e of o)r.push(u_.get(t,e));return i}}function p_(e){let t=Object.create(null);for(let n in e){let r=e[n];Array.isArray(r)||(r=[r]);for(let e of n.split(" "))if(e){let n=[],i=2,o=e;for(let t=0;;){if("..."==o&&t>0&&t+3==e.length){i=1;break}let r=/^"(?:[^"\\]|\\.)*?"|[^\/!]+/.exec(o);if(!r)throw new RangeError("Invalid path: "+e);if(n.push("*"==r[0]?"":'"'==r[0][0]?JSON.parse(r[0]):r[0]),t+=r[0].length,t==e.length)break;let s=e[t++];if(t==e.length&&"!"==s){i=0;break}if("/"!=s)throw new RangeError("Invalid path: "+e);o=e.slice(t)}let s=n.length-1,a=n[s];if(!a)throw new RangeError("Invalid path: "+e);let l=new g_(r,i,s>0?n.slice(0,s):null);t[a]=l.sort(t[a])}}return f_.add(t)}const f_=new PB({combine(e,t){let n,r,i;for(;e||t;){if(!e||t&&e.depth>=t.depth?(i=t,t=t.next):(i=e,e=e.next),n&&n.mode==i.mode&&!i.context&&!n.context)continue;let o=new g_(i.tags,i.mode,i.context);n?n.next=o:r=o,n=o}return r}});class g_{constructor(e,t,n,r){this.tags=e,this.mode=t,this.context=n,this.next=r}get opaque(){return 0==this.mode}get inherit(){return 1==this.mode}sort(e){return!e||e.depth<this.depth?(this.next=e,this):(e.next=this.sort(e.next),e)}get depth(){return this.context?this.context.length:0}}function m_(e,t){let n=Object.create(null);for(let t of e)if(Array.isArray(t.tag))for(let e of t.tag)n[e.id]=t.class;else n[t.tag.id]=t.class;let{scope:r,all:i=null}=t||{};return{style:e=>{let t=i;for(let r of e)for(let e of r.set){let r=n[e.id];if(r){t=t?t+" "+r:r;break}}return t},scope:r}}function v_(e,t,n,r=0,i=e.length){let o=new A_(r,Array.isArray(t)?t:[t],n);o.highlightRange(e.cursor(),r,i,"",o.highlighters),o.flush(i)}g_.empty=new g_([],2,null);class A_{constructor(e,t,n){this.at=e,this.highlighters=t,this.span=n,this.class=""}startSpan(e,t){t!=this.class&&(this.flush(e),e>this.at&&(this.at=e),this.class=t)}flush(e){e>this.at&&this.class&&this.span(this.at,e,this.class)}highlightRange(e,t,n,r,i){let{type:o,from:s,to:a}=e;if(s>=n||a<=t)return;o.isTop&&(i=this.highlighters.filter(e=>!e.scope||e.scope(o)));let l=r,c=function(e){let t=e.type.prop(f_);for(;t&&t.context&&!e.matchContext(t.context);)t=t.next;return t||null}(e)||g_.empty,d=function(e,t){let n=null;for(let r of e){let e=r.style(t);e&&(n=n?n+" "+e:e)}return n}(i,c.tags);if(d&&(l&&(l+=" "),l+=d,1==c.mode&&(r+=(r?" ":"")+d)),this.startSpan(Math.max(t,s),l),c.opaque)return;let h=e.tree&&e.tree.prop(PB.mounted);if(h&&h.overlay){let o=e.node.enter(h.overlay[0].from+s,1),c=this.highlighters.filter(e=>!e.scope||e.scope(h.tree.type)),d=e.firstChild();for(let u=0,p=s;;u++){let f=u<h.overlay.length?h.overlay[u]:null,g=f?f.from+s:a,m=Math.max(t,p),v=Math.min(n,g);if(m<v&&d)for(;e.from<v&&(this.highlightRange(e,m,v,r,i),this.startSpan(Math.min(v,e.to),l),!(e.to>=g)&&e.nextSibling()););if(!f||g>n)break;p=f.to+s,p>t&&(this.highlightRange(o.cursor(),Math.max(t,f.from+s),Math.min(n,p),"",c),this.startSpan(Math.min(n,p),l))}d&&e.parent()}else if(e.firstChild()){h&&(r="");do{if(!(e.to<=t)){if(e.from>=n)break;this.highlightRange(e,t,n,r,i),this.startSpan(Math.min(n,e.to),l)}}while(e.nextSibling());e.parent()}}}const b_=d_.define,y_=b_(),x_=b_(),w_=b_(x_),C_=b_(x_),k_=b_(),S_=b_(k_),O_=b_(k_),B_=b_(),__=b_(B_),T_=b_(),E_=b_(),M_=b_(),D_=b_(M_),P_=b_(),R_={comment:y_,lineComment:b_(y_),blockComment:b_(y_),docComment:b_(y_),name:x_,variableName:b_(x_),typeName:w_,tagName:b_(w_),propertyName:C_,attributeName:b_(C_),className:b_(x_),labelName:b_(x_),namespace:b_(x_),macroName:b_(x_),literal:k_,string:S_,docString:b_(S_),character:b_(S_),attributeValue:b_(S_),number:O_,integer:b_(O_),float:b_(O_),bool:b_(k_),regexp:b_(k_),escape:b_(k_),color:b_(k_),url:b_(k_),keyword:T_,self:b_(T_),null:b_(T_),atom:b_(T_),unit:b_(T_),modifier:b_(T_),operatorKeyword:b_(T_),controlKeyword:b_(T_),definitionKeyword:b_(T_),moduleKeyword:b_(T_),operator:E_,derefOperator:b_(E_),arithmeticOperator:b_(E_),logicOperator:b_(E_),bitwiseOperator:b_(E_),compareOperator:b_(E_),updateOperator:b_(E_),definitionOperator:b_(E_),typeOperator:b_(E_),controlOperator:b_(E_),punctuation:M_,separator:b_(M_),bracket:D_,angleBracket:b_(D_),squareBracket:b_(D_),paren:b_(D_),brace:b_(D_),content:B_,heading:__,heading1:b_(__),heading2:b_(__),heading3:b_(__),heading4:b_(__),heading5:b_(__),heading6:b_(__),contentSeparator:b_(B_),list:b_(B_),quote:b_(B_),emphasis:b_(B_),strong:b_(B_),link:b_(B_),monospace:b_(B_),strikethrough:b_(B_),inserted:b_(),deleted:b_(),changed:b_(),invalid:b_(),meta:P_,documentMeta:b_(P_),annotation:b_(P_),processingInstruction:b_(P_),definition:d_.defineModifier("definition"),constant:d_.defineModifier("constant"),function:d_.defineModifier("function"),standard:d_.defineModifier("standard"),local:d_.defineModifier("local"),special:d_.defineModifier("special")};for(let e in R_){let t=R_[e];t instanceof d_&&(t.name=e)}m_([{tag:R_.link,class:"tok-link"},{tag:R_.heading,class:"tok-heading"},{tag:R_.emphasis,class:"tok-emphasis"},{tag:R_.strong,class:"tok-strong"},{tag:R_.keyword,class:"tok-keyword"},{tag:R_.atom,class:"tok-atom"},{tag:R_.bool,class:"tok-bool"},{tag:R_.url,class:"tok-url"},{tag:R_.labelName,class:"tok-labelName"},{tag:R_.inserted,class:"tok-inserted"},{tag:R_.deleted,class:"tok-deleted"},{tag:R_.literal,class:"tok-literal"},{tag:R_.string,class:"tok-string"},{tag:R_.number,class:"tok-number"},{tag:[R_.regexp,R_.escape,R_.special(R_.string)],class:"tok-string2"},{tag:R_.variableName,class:"tok-variableName"},{tag:R_.local(R_.variableName),class:"tok-variableName tok-local"},{tag:R_.definition(R_.variableName),class:"tok-variableName tok-definition"},{tag:R_.special(R_.variableName),class:"tok-variableName2"},{tag:R_.definition(R_.propertyName),class:"tok-propertyName tok-definition"},{tag:R_.typeName,class:"tok-typeName"},{tag:R_.namespace,class:"tok-namespace"},{tag:R_.className,class:"tok-className"},{tag:R_.macroName,class:"tok-macroName"},{tag:R_.propertyName,class:"tok-propertyName"},{tag:R_.operator,class:"tok-operator"},{tag:R_.comment,class:"tok-comment"},{tag:R_.meta,class:"tok-meta"},{tag:R_.invalid,class:"tok-invalid"},{tag:R_.punctuation,class:"tok-punctuation"}]);var I_;const N_=new PB;function L_(e){return ly.define({combine:e?t=>t.concat(e):void 0})}const Q_=new PB;class F_{constructor(e,t,n=[],r=""){this.data=e,this.name=r,Xy.prototype.hasOwnProperty("tree")||Object.defineProperty(Xy.prototype,"tree",{get(){return W_(this)}}),this.parser=t,this.extension=[J_.of(this),Xy.languageData.of((e,t,n)=>{let r=V_(e,t,n),i=r.type.prop(N_);if(!i)return[];let o=e.facet(i),s=r.type.prop(Q_);if(s){let i=r.resolve(t-r.from,n);for(let t of s)if(t.test(i,e)){let n=e.facet(t.facet);return"replace"==t.type?n:n.concat(o)}}return o})].concat(n)}isActiveAt(e,t,n=-1){return V_(e,t,n).type.prop(N_)==this.data}findRegions(e){let t=e.facet(J_);if((null==t?void 0:t.data)==this.data)return[{from:0,to:e.doc.length}];if(!t||!t.allowsNesting)return[];let n=[],r=(e,t)=>{if(e.prop(N_)==this.data)return void n.push({from:t,to:t+e.length});let i=e.prop(PB.mounted);if(i){if(i.tree.prop(N_)==this.data){if(i.overlay)for(let e of i.overlay)n.push({from:e.from+t,to:e.to+t});else n.push({from:t,to:t+e.length});return}if(i.overlay){let e=n.length;if(r(i.tree,i.overlay[0].from+t),n.length>e)return}}for(let n=0;n<e.children.length;n++){let i=e.children[n];i instanceof zB&&r(i,e.positions[n]+t)}};return r(W_(e),0),n}get allowsNesting(){return!0}}function V_(e,t,n){let r=e.facet(J_),i=W_(e).topNode;if(!r||r.allowsNesting)for(let e=i;e;e=e.enter(t,n,VB.ExcludeBuffers|VB.EnterBracketed))e.type.isTop&&(i=e);return i}F_.setState=Qy.define();class z_ extends F_{constructor(e,t,n){super(e,t,[],n),this.parser=t}static define(e){let t=L_(e.languageData);return new z_(t,e.parser.configure({props:[N_.add(e=>e.isTop?t:void 0)]}),e.name)}configure(e,t){return new z_(this.data,this.parser.configure(e),t||this.name)}get allowsNesting(){return this.parser.hasWrappers()}}function W_(e){let t=e.field(F_.state,!1);return t?t.tree:zB.empty}class $_{constructor(e){this.doc=e,this.cursorPos=0,this.string="",this.cursor=e.iter()}get length(){return this.doc.length}syncTo(e){return this.string=this.cursor.next(e-this.cursorPos).value,this.cursorPos=e+this.string.length,this.cursorPos-this.string.length}chunk(e){return this.syncTo(e),this.string}get lineChunks(){return!0}read(e,t){let n=this.cursorPos-this.string.length;return e<n||t>=this.cursorPos?this.doc.sliceString(e,t):this.string.slice(e-n,t-n)}}let H_=null;class j_{constructor(e,t,n=[],r,i,o,s,a){this.parser=e,this.state=t,this.fragments=n,this.tree=r,this.treeLen=i,this.viewport=o,this.skipped=s,this.scheduleOn=a,this.parse=null,this.tempSkipped=[]}static create(e,t,n){return new j_(e,t,[],zB.empty,0,n,[],null)}startParse(){return this.parser.startParse(new $_(this.state.doc),this.fragments)}work(e,t){return null!=t&&t>=this.state.doc.length&&(t=void 0),this.tree!=zB.empty&&this.isDone(null!=t?t:this.state.doc.length)?(this.takeTree(),!0):this.withContext(()=>{var n;if("number"==typeof e){let t=Date.now()+e;e=()=>Date.now()>t}for(this.parse||(this.parse=this.startParse()),null!=t&&(null==this.parse.stoppedAt||this.parse.stoppedAt>t)&&t<this.state.doc.length&&this.parse.stopAt(t);;){let r=this.parse.advance();if(r){if(this.fragments=this.withoutTempSkipped(s_.addTree(r,this.fragments,null!=this.parse.stoppedAt)),this.treeLen=null!==(n=this.parse.stoppedAt)&&void 0!==n?n:this.state.doc.length,this.tree=r,this.parse=null,!(this.treeLen<(null!=t?t:this.state.doc.length)))return!0;this.parse=this.startParse()}if(e())return!1}})}takeTree(){let e,t;this.parse&&(e=this.parse.parsedPos)>=this.treeLen&&((null==this.parse.stoppedAt||this.parse.stoppedAt>e)&&this.parse.stopAt(e),this.withContext(()=>{for(;!(t=this.parse.advance()););}),this.treeLen=e,this.tree=t,this.fragments=this.withoutTempSkipped(s_.addTree(this.tree,this.fragments,!0)),this.parse=null)}withContext(e){let t=H_;H_=this;try{return e()}finally{H_=t}}withoutTempSkipped(e){for(let t;t=this.tempSkipped.pop();)e=q_(e,t.from,t.to);return e}changes(e,t){let{fragments:n,tree:r,treeLen:i,viewport:o,skipped:s}=this;if(this.takeTree(),!e.empty){let t=[];if(e.iterChangedRanges((e,n,r,i)=>t.push({fromA:e,toA:n,fromB:r,toB:i})),n=s_.applyChanges(n,t),r=zB.empty,i=0,o={from:e.mapPos(o.from,-1),to:e.mapPos(o.to,1)},this.skipped.length){s=[];for(let t of this.skipped){let n=e.mapPos(t.from,1),r=e.mapPos(t.to,-1);n<r&&s.push({from:n,to:r})}}}return new j_(this.parser,t,n,r,i,o,s,this.scheduleOn)}updateViewport(e){if(this.viewport.from==e.from&&this.viewport.to==e.to)return!1;this.viewport=e;let t=this.skipped.length;for(let t=0;t<this.skipped.length;t++){let{from:n,to:r}=this.skipped[t];n<e.to&&r>e.from&&(this.fragments=q_(this.fragments,n,r),this.skipped.splice(t--,1))}return!(this.skipped.length>=t)&&(this.reset(),!0)}reset(){this.parse&&(this.takeTree(),this.parse=null)}skipUntilInView(e,t){this.skipped.push({from:e,to:t})}static getSkippingParser(e){return new class extends a_{createParse(t,n,r){let i=r[0].from,o=r[r.length-1].to;return{parsedPos:i,advance(){let t=H_;if(t){for(let e of r)t.tempSkipped.push(e);e&&(t.scheduleOn=t.scheduleOn?Promise.all([t.scheduleOn,e]):e)}return this.parsedPos=o,new zB(NB.none,[],[],o-i)},stoppedAt:null,stopAt(){}}}}}isDone(e){e=Math.min(e,this.state.doc.length);let t=this.fragments;return this.treeLen>=e&&t.length&&0==t[0].from&&t[0].to>=e}static get(){return H_}}function q_(e,t,n){return s_.applyChanges(e,[{fromA:t,toA:n,fromB:t,toB:n}])}class U_{constructor(e){this.context=e,this.tree=e.tree}apply(e){if(!e.docChanged&&this.tree==this.context.tree)return this;let t=this.context.changes(e.changes,e.state),n=this.context.treeLen==e.startState.doc.length?void 0:Math.max(e.changes.mapPos(this.context.treeLen),t.viewport.to);return t.work(20,n)||t.takeTree(),new U_(t)}static init(e){let t=Math.min(3e3,e.doc.length),n=j_.create(e.facet(J_).parser,e,{from:0,to:t});return n.work(20,t)||n.takeTree(),new U_(n)}}F_.state=gy.define({create:U_.init,update(e,t){for(let e of t.effects)if(e.is(F_.setState))return e.value;return t.startState.facet(J_)!=t.state.facet(J_)?U_.init(t.state):e.apply(t)}});let G_=e=>{let t=setTimeout(()=>e(),500);return()=>clearTimeout(t)};"undefined"!=typeof requestIdleCallback&&(G_=e=>{let t=-1,n=setTimeout(()=>{t=requestIdleCallback(e,{timeout:400})},100);return()=>t<0?clearTimeout(n):cancelIdleCallback(t)});const Y_="undefined"!=typeof navigator&&(null===(I_=navigator.scheduling)||void 0===I_?void 0:I_.isInputPending)?()=>navigator.scheduling.isInputPending():null,X_=dC.fromClass(class{constructor(e){this.view=e,this.working=null,this.workScheduled=0,this.chunkEnd=-1,this.chunkBudget=-1,this.work=this.work.bind(this),this.scheduleWork()}update(e){let t=this.view.state.field(F_.state).context;(t.updateViewport(e.view.viewport)||this.view.viewport.to>t.treeLen)&&this.scheduleWork(),(e.docChanged||e.selectionSet)&&(this.view.hasFocus&&(this.chunkBudget+=50),this.scheduleWork()),this.checkAsyncSchedule(t)}scheduleWork(){if(this.working)return;let{state:e}=this.view,t=e.field(F_.state);t.tree==t.context.tree&&t.context.isDone(e.doc.length)||(this.working=G_(this.work))}work(e){this.working=null;let t=Date.now();if(this.chunkEnd<t&&(this.chunkEnd<0||this.view.hasFocus)&&(this.chunkEnd=t+3e4,this.chunkBudget=3e3),this.chunkBudget<=0)return;let{state:n,viewport:{to:r}}=this.view,i=n.field(F_.state);if(i.tree==i.context.tree&&i.context.isDone(r+1e5))return;let o=Date.now()+Math.min(this.chunkBudget,100,e&&!Y_?Math.max(25,e.timeRemaining()-5):1e9),s=i.context.treeLen<r&&n.doc.length>r+1e3,a=i.context.work(()=>Y_&&Y_()||Date.now()>o,r+(s?0:1e5));this.chunkBudget-=Date.now()-t,(a||this.chunkBudget<=0)&&(i.context.takeTree(),this.view.dispatch({effects:F_.setState.of(new U_(i.context))})),this.chunkBudget>0&&(!a||s)&&this.scheduleWork(),this.checkAsyncSchedule(i.context)}checkAsyncSchedule(e){e.scheduleOn&&(this.workScheduled++,e.scheduleOn.then(()=>this.scheduleWork()).catch(e=>sC(this.view.state,e)).then(()=>this.workScheduled--),e.scheduleOn=null)}destroy(){this.working&&this.working()}isWorking(){return!!(this.working||this.workScheduled>0)}},{eventHandlers:{focus(){this.scheduleWork()}}}),J_=ly.define({combine:e=>e.length?e[0]:null,enables:e=>[F_.state,X_,NS.contentAttributes.compute([e],t=>{let n=t.facet(e);return n&&n.name?{"data-language":n.name}:{}})]});class K_{constructor(e,t=[]){this.language=e,this.support=t,this.extension=[e,t]}}const Z_=ly.define(),eT=ly.define({combine:e=>{if(!e.length)return"  ";let t=e[0];if(!t||/\S/.test(t)||Array.from(t).some(e=>e!=t[0]))throw new Error("Invalid indent unit: "+JSON.stringify(e[0]));return t}});function tT(e){let t=e.facet(eT);return 9==t.charCodeAt(0)?e.tabSize*t.length:t.length}function nT(e,t){let n="",r=e.tabSize,i=e.facet(eT)[0];if("\t"==i){for(;t>=r;)n+="\t",t-=r;i=" "}for(let e=0;e<t;e++)n+=i;return n}function rT(e,t){e instanceof Xy&&(e=new iT(e));for(let n of e.state.facet(Z_)){let r=n(e,t);if(void 0!==r)return r}let n=W_(e.state);return n.length>=t?function(e,t,n){let r=t.resolveStack(n),i=t.resolveInner(n,-1).resolve(n,0).enterUnfinishedNodesBefore(n);if(i!=r.node){let e=[];for(let t=i;t&&!(t.from<r.node.from||t.to>r.node.to||t.from==r.node.from&&t.type==r.node.type);t=t.parent)e.push(t);for(let t=e.length-1;t>=0;t--)r={node:e[t],next:r}}return sT(r,e,n)}(e,n,t):null}class iT{constructor(e,t={}){this.state=e,this.options=t,this.unit=tT(e)}lineAt(e,t=1){let n=this.state.doc.lineAt(e),{simulateBreak:r,simulateDoubleBreak:i}=this.options;return null!=r&&r>=n.from&&r<=n.to?i&&r==e?{text:"",from:e}:(t<0?r<e:r<=e)?{text:n.text.slice(r-n.from),from:r}:{text:n.text.slice(0,r-n.from),from:n.from}:n}textAfterPos(e,t=1){if(this.options.simulateDoubleBreak&&e==this.options.simulateBreak)return"";let{text:n,from:r}=this.lineAt(e,t);return n.slice(e-r,Math.min(n.length,e+100-r))}column(e,t=1){let{text:n,from:r}=this.lineAt(e,t),i=this.countColumn(n,e-r),o=this.options.overrideIndentation?this.options.overrideIndentation(r):-1;return o>-1&&(i+=o-this.countColumn(n,n.search(/\S|$/))),i}countColumn(e,t=e.length){return gx(e,this.state.tabSize,t)}lineIndent(e,t=1){let{text:n,from:r}=this.lineAt(e,t),i=this.options.overrideIndentation;if(i){let e=i(r);if(e>-1)return e}return this.countColumn(n,n.search(/\S|$/))}get simulatedBreak(){return this.options.simulateBreak||null}}const oT=new PB;function sT(e,t,n){for(let r=e;r;r=r.next){let e=aT(r.node);if(e)return e(cT.create(t,n,r))}return 0}function aT(e){let t=e.type.prop(oT);if(t)return t;let n,r=e.firstChild;if(r&&(n=r.type.prop(PB.closedBy))){let t=e.lastChild,r=t&&n.indexOf(t.name)>-1;return e=>hT(e,!0,1,void 0,r&&!function(e){return e.pos==e.options.simulateBreak&&e.options.simulateDoubleBreak}(e)?t.from:void 0)}return null==e.parent?lT:null}function lT(){return 0}class cT extends iT{constructor(e,t,n){super(e.state,e.options),this.base=e,this.pos=t,this.context=n}get node(){return this.context.node}static create(e,t,n){return new cT(e,t,n)}get textAfter(){return this.textAfterPos(this.pos)}get baseIndent(){return this.baseIndentFor(this.node)}baseIndentFor(e){let t=this.state.doc.lineAt(e.from);for(;;){let n=e.resolve(t.from);for(;n.parent&&n.parent.from==n.from;)n=n.parent;if(dT(n,e))break;t=this.state.doc.lineAt(n.from)}return this.lineIndent(t.from)}continue(){return sT(this.context.next,this.base,this.pos)}}function dT(e,t){for(let n=t;n;n=n.parent)if(e==n)return!0;return!1}function hT(e,t,n,r,i){let o=e.textAfter,s=o.match(/^\s*/)[0].length,a=r&&o.slice(s,s+r.length)==r||i==e.pos+s,l=t?function(e){let t=e.node,n=t.childAfter(t.from),r=t.lastChild;if(!n)return null;let i=e.options.simulateBreak,o=e.state.doc.lineAt(n.from),s=null==i||i<=o.from?o.to:Math.min(o.to,i);for(let e=n.to;;){let i=t.childAfter(e);if(!i||i==r)return null;if(!i.type.isSkipped){if(i.from>=s)return null;let e=/^ */.exec(o.text.slice(n.to-o.from))[0].length;return{from:n.from,to:n.to+e}}e=i.to}}(e):null;return l?a?e.column(l.from):e.column(l.to):e.baseIndent+(a?0:e.unit*n)}function uT({except:e,units:t=1}={}){return n=>{let r=e&&e.test(n.textAfter);return n.baseIndent+(r?0:t*n.unit)}}const pT=ly.define(),fT=new PB;function gT(e){let t=e.lastChild;return t&&t.to==e.to&&t.type.isError}function mT(e,t,n){for(let r of e.facet(pT)){let i=r(e,t,n);if(i)return i}return function(e,t,n){let r=W_(e);if(r.length<n)return null;let i=null;for(let o=r.resolveStack(n,1);o;o=o.next){let s=o.node;if(s.to<=n||s.from>n)continue;if(i&&s.from<t)break;let a=s.type.prop(fT);if(a&&(s.to<r.length-50||r.length==e.doc.length||!gT(s))){let r=a(s,e);r&&r.from<=n&&r.from>=t&&r.to>n&&(i=r)}}return i}(e,t,n)}function vT(e,t){let n=t.mapPos(e.from,1),r=t.mapPos(e.to,-1);return n>=r?void 0:{from:n,to:r}}const AT=Qy.define({map:vT}),bT=Qy.define({map:vT});function yT(e){let t=[];for(let{head:n}of e.state.selection.ranges)t.some(e=>e.from<=n&&e.to>=n)||t.push(e.lineBlockAt(n));return t}const xT=gy.define({create:()=>Xx.none,update(e,t){t.isUserEvent("delete")&&t.changes.iterChangedRanges((t,n)=>e=wT(e,t,n)),e=e.map(t.changes);for(let n of t.effects)if(n.is(AT)&&!kT(e,n.value.from,n.value.to)){let{preparePlaceholder:r}=t.state.facet(TT),i=r?Xx.replace({widget:new PT(r(t.state,n.value))}):DT;e=e.update({add:[i.range(n.value.from,n.value.to)]})}else n.is(bT)&&(e=e.update({filter:(e,t)=>n.value.from!=e||n.value.to!=t,filterFrom:n.value.from,filterTo:n.value.to}));return t.selection&&(e=wT(e,t.selection.main.head)),e},provide:e=>NS.decorations.from(e),toJSON(e,t){let n=[];return e.between(0,t.doc.length,(e,t)=>{n.push(e,t)}),n},fromJSON(e){if(!Array.isArray(e)||e.length%2)throw new RangeError("Invalid JSON for fold state");let t=[];for(let n=0;n<e.length;){let r=e[n++],i=e[n++];if("number"!=typeof r||"number"!=typeof i)throw new RangeError("Invalid JSON for fold state");t.push(DT.range(r,i))}return Xx.set(t,!0)}});function wT(e,t,n=t){let r=!1;return e.between(t,n,(e,i)=>{e<n&&i>t&&(r=!0)}),r?e.update({filterFrom:t,filterTo:n,filter:(e,r)=>e>=n||r<=t}):e}function CT(e,t,n){var r;let i=null;return null===(r=e.field(xT,!1))||void 0===r||r.between(t,n,(e,t)=>{(!i||i.from>e)&&(i={from:e,to:t})}),i}function kT(e,t,n){let r=!1;return e.between(t,t,(e,i)=>{e==t&&i==n&&(r=!0)}),r}function ST(e,t){return e.field(xT,!1)?t:t.concat(Qy.appendConfig.of(ET()))}function OT(e,t,n=!0){let r=e.state.doc.lineAt(t.from).number,i=e.state.doc.lineAt(t.to).number;return NS.announce.of(`${e.state.phrase(n?"Folded lines":"Unfolded lines")} ${r} ${e.state.phrase("to")} ${i}.`)}const BT=[{key:"Ctrl-Shift-[",mac:"Cmd-Alt-[",run:e=>{for(let t of yT(e)){let n=mT(e.state,t.from,t.to);if(n)return e.dispatch({effects:ST(e.state,[AT.of(n),OT(e,n)])}),!0}return!1}},{key:"Ctrl-Shift-]",mac:"Cmd-Alt-]",run:e=>{if(!e.state.field(xT,!1))return!1;let t=[];for(let n of yT(e)){let r=CT(e.state,n.from,n.to);r&&t.push(bT.of(r),OT(e,r,!1))}return t.length&&e.dispatch({effects:t}),t.length>0}},{key:"Ctrl-Alt-[",run:e=>{let{state:t}=e,n=[];for(let r=0;r<t.doc.length;){let i=e.lineBlockAt(r),o=mT(t,i.from,i.to);o&&n.push(AT.of(o)),r=(o?e.lineBlockAt(o.to):i).to+1}return n.length&&e.dispatch({effects:ST(e.state,n)}),!!n.length}},{key:"Ctrl-Alt-]",run:e=>{let t=e.state.field(xT,!1);if(!t||!t.size)return!1;let n=[];return t.between(0,e.state.doc.length,(e,t)=>{n.push(bT.of({from:e,to:t}))}),e.dispatch({effects:n}),!0}}],_T={placeholderDOM:null,preparePlaceholder:null,placeholderText:"…"},TT=ly.define({combine:e=>Jy(e,_T)});function ET(e){let t=[xT,LT];return e&&t.push(TT.of(e)),t}function MT(e,t){let{state:n}=e,r=n.facet(TT),i=t=>{let n=e.lineBlockAt(e.posAtDOM(t.target)),r=CT(e.state,n.from,n.to);r&&e.dispatch({effects:bT.of(r)}),t.preventDefault()};if(r.placeholderDOM)return r.placeholderDOM(e,i,t);let o=document.createElement("span");return o.textContent=r.placeholderText,o.setAttribute("aria-label",n.phrase("folded code")),o.title=n.phrase("unfold"),o.className="cm-foldPlaceholder",o.onclick=i,o}const DT=Xx.replace({widget:new class extends Gx{toDOM(e){return MT(e,null)}}});class PT extends Gx{constructor(e){super(),this.value=e}eq(e){return this.value==e.value}toDOM(e){return MT(e,this.value)}}const RT={openText:"⌄",closedText:"›",markerDOM:null,domEventHandlers:{},foldingChanged:()=>!1};class IT extends sB{constructor(e,t){super(),this.config=e,this.open=t}eq(e){return this.config==e.config&&this.open==e.open}toDOM(e){if(this.config.markerDOM)return this.config.markerDOM(this.open);let t=document.createElement("span");return t.textContent=this.open?this.config.openText:this.config.closedText,t.title=e.state.phrase(this.open?"Fold line":"Unfold line"),t}}function NT(e={}){let t={...RT,...e},n=new IT(t,!0),r=new IT(t,!1),i=dC.fromClass(class{constructor(e){this.from=e.viewport.from,this.markers=this.buildMarkers(e)}update(e){(e.docChanged||e.viewportChanged||e.startState.facet(J_)!=e.state.facet(J_)||e.startState.field(xT,!1)!=e.state.field(xT,!1)||W_(e.startState)!=W_(e.state)||t.foldingChanged(e))&&(this.markers=this.buildMarkers(e.view))}buildMarkers(e){let t=new ix;for(let i of e.viewportLineBlocks){let o=CT(e.state,i.from,i.to)?r:mT(e.state,i.from,i.to)?n:null;o&&t.add(i.from,i.from,o)}return t.finish()}}),{domEventHandlers:o}=t;return[i,hB({class:"cm-foldGutter",markers(e){var t;return(null===(t=e.plugin(i))||void 0===t?void 0:t.markers)||rx.empty},initialSpacer:()=>new IT(t,!1),domEventHandlers:{...o,click:(e,t,n)=>{if(o.click&&o.click(e,t,n))return!0;let r=CT(e.state,t.from,t.to);if(r)return e.dispatch({effects:bT.of(r)}),!0;let i=mT(e.state,t.from,t.to);return!!i&&(e.dispatch({effects:AT.of(i)}),!0)}}}),ET()]}const LT=NS.baseTheme({".cm-foldPlaceholder":{backgroundColor:"#eee",border:"1px solid #ddd",color:"#888",borderRadius:".2em",margin:"0 1px",padding:"0 1px",cursor:"pointer"},".cm-foldGutter span":{padding:"0 1px",cursor:"pointer"}});class QT{constructor(e,t){let n;function r(e){let t=yx.newName();return(n||(n=Object.create(null)))["."+t]=e,t}this.specs=e;const i="string"==typeof t.all?t.all:t.all?r(t.all):void 0,o=t.scope;this.scope=o instanceof F_?e=>e.prop(N_)==o.data:o?e=>e==o:void 0,this.style=m_(e.map(e=>({tag:e.tag,class:e.class||r(Object.assign({},e,{tag:null}))})),{all:i}).style,this.module=n?new yx(n):null,this.themeType=t.themeType}static define(e,t){return new QT(e,t||{})}}const FT=ly.define(),VT=ly.define({combine:e=>e.length?[e[0]]:null});function zT(e){let t=e.facet(FT);return t.length?t:e.facet(VT)}function WT(e,t){let n,r=[HT];return e instanceof QT&&(e.module&&r.push(NS.styleModule.of(e.module)),n=e.themeType),(null==t?void 0:t.fallback)?r.push(VT.of(e)):n?r.push(FT.computeN([NS.darkTheme],t=>t.facet(NS.darkTheme)==("dark"==n)?[e]:[])):r.push(FT.of(e)),r}class $T{constructor(e){this.markCache=Object.create(null),this.tree=W_(e.state),this.decorations=this.buildDeco(e,zT(e.state)),this.decoratedTo=e.viewport.to}update(e){let t=W_(e.state),n=zT(e.state),r=n!=zT(e.startState),{viewport:i}=e.view,o=e.changes.mapPos(this.decoratedTo,1);t.length<i.to&&!r&&t.type==this.tree.type&&o>=i.to?(this.decorations=this.decorations.map(e.changes),this.decoratedTo=o):(t!=this.tree||e.viewportChanged||r)&&(this.tree=t,this.decorations=this.buildDeco(e.view,n),this.decoratedTo=i.to)}buildDeco(e,t){if(!t||!this.tree.length)return Xx.none;let n=new ix;for(let{from:r,to:i}of e.visibleRanges)v_(this.tree,t,(e,t,r)=>{n.add(e,t,this.markCache[r]||(this.markCache[r]=Xx.mark({class:r})))},r,i);return n.finish()}}const HT=xy.high(dC.fromClass($T,{decorations:e=>e.decorations})),jT=QT.define([{tag:R_.meta,color:"#404740"},{tag:R_.link,textDecoration:"underline"},{tag:R_.heading,textDecoration:"underline",fontWeight:"bold"},{tag:R_.emphasis,fontStyle:"italic"},{tag:R_.strong,fontWeight:"bold"},{tag:R_.strikethrough,textDecoration:"line-through"},{tag:R_.keyword,color:"#708"},{tag:[R_.atom,R_.bool,R_.url,R_.contentSeparator,R_.labelName],color:"#219"},{tag:[R_.literal,R_.inserted],color:"#164"},{tag:[R_.string,R_.deleted],color:"#a11"},{tag:[R_.regexp,R_.escape,R_.special(R_.string)],color:"#e40"},{tag:R_.definition(R_.variableName),color:"#00f"},{tag:R_.local(R_.variableName),color:"#30a"},{tag:[R_.typeName,R_.namespace],color:"#085"},{tag:R_.className,color:"#167"},{tag:[R_.special(R_.variableName),R_.macroName],color:"#256"},{tag:R_.definition(R_.propertyName),color:"#00c"},{tag:R_.comment,color:"#940"},{tag:R_.invalid,color:"#f00"}]),qT=NS.baseTheme({"&.cm-focused .cm-matchingBracket":{backgroundColor:"#328c8252"},"&.cm-focused .cm-nonmatchingBracket":{backgroundColor:"#bb555544"}}),UT="()[]{}",GT=ly.define({combine:e=>Jy(e,{afterCursor:!0,brackets:UT,maxScanDistance:1e4,renderMatch:JT})}),YT=Xx.mark({class:"cm-matchingBracket"}),XT=Xx.mark({class:"cm-nonmatchingBracket"});function JT(e){let t=[],n=e.matched?YT:XT;return t.push(n.range(e.start.from,e.start.to)),e.end&&t.push(n.range(e.end.from,e.end.to)),t}const KT=gy.define({create:()=>Xx.none,update(e,t){if(!t.docChanged&&!t.selection)return e;let n=[],r=t.state.facet(GT);for(let e of t.state.selection.ranges){if(!e.empty)continue;let i=iE(t.state,e.head,-1,r)||e.head>0&&iE(t.state,e.head-1,1,r)||r.afterCursor&&(iE(t.state,e.head,1,r)||e.head<t.state.doc.length&&iE(t.state,e.head+1,-1,r));i&&(n=n.concat(r.renderMatch(i,t.state)))}return Xx.set(n,!0)},provide:e=>NS.decorations.from(e)}),ZT=[KT,qT];function eE(e={}){return[GT.of(e),ZT]}const tE=new PB;function nE(e,t,n){let r=e.prop(t<0?PB.openedBy:PB.closedBy);if(r)return r;if(1==e.name.length){let r=n.indexOf(e.name);if(r>-1&&r%2==(t<0?1:0))return[n[r+t]]}return null}function rE(e){let t=e.type.prop(tE);return t?t(e.node):e}function iE(e,t,n,r={}){let i=r.maxScanDistance||1e4,o=r.brackets||UT,s=W_(e),a=s.resolveInner(t,n);for(let r=a;r;r=r.parent){let i=nE(r.type,n,o);if(i&&r.from<r.to){let s=rE(r);if(s&&(n>0?t>=s.from&&t<s.to:t>s.from&&t<=s.to))return oE(e,t,n,r,s,i,o)}}return function(e,t,n,r,i,o,s){let a=n<0?e.sliceDoc(t-1,t):e.sliceDoc(t,t+1),l=s.indexOf(a);if(l<0||l%2==0!=n>0)return null;let c={from:n<0?t-1:t,to:n>0?t+1:t},d=e.doc.iterRange(t,n>0?e.doc.length:0),h=0;for(let e=0;!d.next().done&&e<=o;){let o=d.value;n<0&&(e+=o.length);let a=t+e*n;for(let e=n>0?0:o.length-1,t=n>0?o.length:-1;e!=t;e+=n){let t=s.indexOf(o[e]);if(!(t<0||r.resolveInner(a+e,1).type!=i))if(t%2==0==n>0)h++;else{if(1==h)return{start:c,end:{from:a+e,to:a+e+1},matched:t>>1==l>>1};h--}}n>0&&(e+=o.length)}return d.done?{start:c,matched:!1}:null}(e,t,n,s,a.type,i,o)}function oE(e,t,n,r,i,o,s){let a=r.parent,l={from:i.from,to:i.to},c=0,d=null==a?void 0:a.cursor();if(d&&(n<0?d.childBefore(r.from):d.childAfter(r.to)))do{if(n<0?d.to<=r.from:d.from>=r.to){if(0==c&&o.indexOf(d.type.name)>-1&&d.from<d.to){let e=rE(d);return{start:l,end:e?{from:e.from,to:e.to}:void 0,matched:!0}}if(nE(d.type,n,s))c++;else if(nE(d.type,-n,s)){if(0==c){let e=rE(d);return{start:l,end:e&&e.from<e.to?{from:e.from,to:e.to}:void 0,matched:!1}}c--}}}while(n<0?d.prevSibling():d.nextSibling());return{start:l,matched:!1}}const sE=Object.create(null),aE=[NB.none],lE=[],cE=Object.create(null),dE=Object.create(null);for(let[e,t]of[["variable","variableName"],["variable-2","variableName.special"],["string-2","string.special"],["def","variableName.definition"],["tag","tagName"],["attribute","attributeName"],["type","typeName"],["builtin","variableName.standard"],["qualifier","modifier"],["error","invalid"],["header","heading"],["property","propertyName"]])dE[e]=uE(sE,t);function hE(e,t){lE.indexOf(e)>-1||(lE.push(e),console.warn(t))}function uE(e,t){let n=[];for(let r of t.split(" ")){let t=[];for(let n of r.split(".")){let r=e[n]||R_[n];r?"function"==typeof r?t.length?t=t.map(r):hE(n,`Modifier ${n} used at start of tag`):t.length?hE(n,`Tag ${n} used as modifier`):t=Array.isArray(r)?r:[r]:hE(n,`Unknown highlighting tag ${n}`)}for(let e of t)n.push(e)}if(!n.length)return 0;let r=t.replace(/ /g,"_"),i=r+" "+n.map(e=>e.id),o=cE[i];if(o)return o.id;let s=cE[i]=NB.define({id:aE.length,name:r,props:[p_({[r]:n})]});return aE.push(s),s.id}Sw.RTL,Sw.LTR;function pE(e,t){return({state:n,dispatch:r})=>{if(n.readOnly)return!1;let i=e(t,n);return!!i&&(r(n.update(i)),!0)}}const fE=pE(bE,0),gE=pE(AE,0),mE=pE((e,t)=>AE(e,t,function(e){let t=[];for(let n of e.selection.ranges){let r=e.doc.lineAt(n.from),i=n.to<=r.to?r:e.doc.lineAt(n.to);i.from>r.from&&i.from==n.to&&(i=n.to==r.to+1?r:e.doc.lineAt(n.to-1));let o=t.length-1;o>=0&&t[o].to>r.from?t[o].to=i.to:t.push({from:r.from+/^\s*/.exec(r.text)[0].length,to:i.to})}return t}(t)),0);function vE(e,t){let n=e.languageDataAt("commentTokens",t,1);return n.length?n[0]:{}}function AE(e,t,n=t.selection.ranges){let r=n.map(e=>vE(t,e.from).block);if(!r.every(e=>e))return null;let i=n.map((e,n)=>function(e,{open:t,close:n},r,i){let o,s,a=e.sliceDoc(r-50,r),l=e.sliceDoc(i,i+50),c=/\s*$/.exec(a)[0].length,d=/^\s*/.exec(l)[0].length,h=a.length-c;if(a.slice(h-t.length,h)==t&&l.slice(d,d+n.length)==n)return{open:{pos:r-c,margin:c&&1},close:{pos:i+d,margin:d&&1}};i-r<=100?o=s=e.sliceDoc(r,i):(o=e.sliceDoc(r,r+50),s=e.sliceDoc(i-50,i));let u=/^\s*/.exec(o)[0].length,p=/\s*$/.exec(s)[0].length,f=s.length-p-n.length;return o.slice(u,u+t.length)==t&&s.slice(f,f+n.length)==n?{open:{pos:r+u+t.length,margin:/\s/.test(o.charAt(u+t.length))?1:0},close:{pos:i-p-n.length,margin:/\s/.test(s.charAt(f-1))?1:0}}:null}(t,r[n],e.from,e.to));if(2!=e&&!i.every(e=>e))return{changes:t.changes(n.map((e,t)=>i[t]?[]:[{from:e.from,insert:r[t].open+" "},{from:e.to,insert:" "+r[t].close}]))};if(1!=e&&i.some(e=>e)){let e=[];for(let t,n=0;n<i.length;n++)if(t=i[n]){let i=r[n],{open:o,close:s}=t;e.push({from:o.pos-i.open.length,to:o.pos+o.margin},{from:s.pos-s.margin,to:s.pos+i.close.length})}return{changes:e}}return null}function bE(e,t,n=t.selection.ranges){let r=[],i=-1;for(let{from:e,to:o}of n){let n=r.length,s=1e9,a=vE(t,e).line;if(a){for(let n=e;n<=o;){let l=t.doc.lineAt(n);if(l.from>i&&(e==o||o>l.from)){i=l.from;let e=/^\s*/.exec(l.text)[0].length,t=e==l.length,n=l.text.slice(e,e+a.length)==a?e:-1;e<l.text.length&&e<s&&(s=e),r.push({line:l,comment:n,token:a,indent:e,empty:t,single:!1})}n=l.to+1}if(s<1e9)for(let e=n;e<r.length;e++)r[e].indent<r[e].line.text.length&&(r[e].indent=s);r.length==n+1&&(r[n].single=!0)}}if(2!=e&&r.some(e=>e.comment<0&&(!e.empty||e.single))){let e=[];for(let{line:t,token:n,indent:i,empty:o,single:s}of r)!s&&o||e.push({from:t.from+i,insert:n+" "});let n=t.changes(e);return{changes:n,selection:t.selection.map(n,1)}}if(1!=e&&r.some(e=>e.comment>=0)){let e=[];for(let{line:t,comment:n,token:i}of r)if(n>=0){let r=t.from+n,o=r+i.length;" "==t.text[o-t.from]&&o++,e.push({from:r,to:o})}return{changes:e}}return null}const yE=Iy.define(),xE=Iy.define(),wE=ly.define(),CE=ly.define({combine:e=>Jy(e,{minDepth:100,newGroupDelay:500,joinToEvent:(e,t)=>t},{minDepth:Math.max,newGroupDelay:Math.min,joinToEvent:(e,t)=>(n,r)=>e(n,r)||t(n,r)})}),kE=gy.define({create:()=>VE.empty,update(e,t){let n=t.state.facet(CE),r=t.annotation(yE);if(r){let i=ME.fromTransaction(t,r.selection),o=r.side,s=0==o?e.undone:e.done;return s=i?DE(s,s.length,n.minDepth,i):IE(s,t.startState.selection),new VE(0==o?r.rest:s,0==o?s:r.rest)}let i=t.annotation(xE);if("full"!=i&&"before"!=i||(e=e.isolate()),!1===t.annotation(Fy.addToHistory))return t.changes.empty?e:e.addMapping(t.changes.desc);let o=ME.fromTransaction(t),s=t.annotation(Fy.time),a=t.annotation(Fy.userEvent);return o?e=e.addChanges(o,s,a,n,t):t.selection&&(e=e.addSelection(t.startState.selection,s,a,n.newGroupDelay)),"full"!=i&&"after"!=i||(e=e.isolate()),e},toJSON:e=>({done:e.done.map(e=>e.toJSON()),undone:e.undone.map(e=>e.toJSON())}),fromJSON:e=>new VE(e.done.map(ME.fromJSON),e.undone.map(ME.fromJSON))});function SE(e={}){return[kE,CE.of(e),NS.domEventHandlers({beforeinput(e,t){let n="historyUndo"==e.inputType?BE:"historyRedo"==e.inputType?_E:null;return!!n&&(e.preventDefault(),n(t))}})]}function OE(e,t){return function({state:n,dispatch:r}){if(!t&&n.readOnly)return!1;let i=n.field(kE,!1);if(!i)return!1;let o=i.pop(e,n,t);return!!o&&(r(o),!0)}}const BE=OE(0,!1),_E=OE(1,!1),TE=OE(0,!0),EE=OE(1,!0);class ME{constructor(e,t,n,r,i){this.changes=e,this.effects=t,this.mapped=n,this.startSelection=r,this.selectionsAfter=i}setSelAfter(e){return new ME(this.changes,this.effects,this.mapped,this.startSelection,e)}toJSON(){var e,t,n;return{changes:null===(e=this.changes)||void 0===e?void 0:e.toJSON(),mapped:null===(t=this.mapped)||void 0===t?void 0:t.toJSON(),startSelection:null===(n=this.startSelection)||void 0===n?void 0:n.toJSON(),selectionsAfter:this.selectionsAfter.map(e=>e.toJSON())}}static fromJSON(e){return new ME(e.changes&&Jb.fromJSON(e.changes),[],e.mapped&&Xb.fromJSON(e.mapped),e.startSelection&&oy.fromJSON(e.startSelection),e.selectionsAfter.map(oy.fromJSON))}static fromTransaction(e,t){let n=RE;for(let t of e.startState.facet(wE)){let r=t(e);r.length&&(n=n.concat(r))}return!n.length&&e.changes.empty?null:new ME(e.changes.invert(e.startState.doc),n,void 0,t||e.startState.selection,RE)}static selection(e){return new ME(void 0,RE,void 0,void 0,e)}}function DE(e,t,n,r){let i=t+1>n+20?t-n-1:0,o=e.slice(i,t);return o.push(r),o}function PE(e,t){return e.length?t.length?e.concat(t):e:t}const RE=[];function IE(e,t){if(e.length){let n=e[e.length-1],r=n.selectionsAfter.slice(Math.max(0,n.selectionsAfter.length-200));return r.length&&r[r.length-1].eq(t)?e:(r.push(t),DE(e,e.length-1,1e9,n.setSelAfter(r)))}return[ME.selection([t])]}function NE(e){let t=e[e.length-1],n=e.slice();return n[e.length-1]=t.setSelAfter(t.selectionsAfter.slice(0,t.selectionsAfter.length-1)),n}function LE(e,t){if(!e.length)return e;let n=e.length,r=RE;for(;n;){let i=QE(e[n-1],t,r);if(i.changes&&!i.changes.empty||i.effects.length){let t=e.slice(0,n);return t[n-1]=i,t}t=i.mapped,n--,r=i.selectionsAfter}return r.length?[ME.selection(r)]:RE}function QE(e,t,n){let r=PE(e.selectionsAfter.length?e.selectionsAfter.map(e=>e.map(t)):RE,n);if(!e.changes)return ME.selection(r);let i=e.changes.map(t),o=t.mapDesc(e.changes,!0),s=e.mapped?e.mapped.composeDesc(o):o;return new ME(i,Qy.mapEffects(e.effects,t),s,e.startSelection.map(o),r)}const FE=/^(input\.type|delete)($|\.)/;class VE{constructor(e,t,n=0,r=void 0){this.done=e,this.undone=t,this.prevTime=n,this.prevUserEvent=r}isolate(){return this.prevTime?new VE(this.done,this.undone):this}addChanges(e,t,n,r,i){let o=this.done,s=o[o.length-1];return o=s&&s.changes&&!s.changes.empty&&e.changes&&(!n||FE.test(n))&&(!s.selectionsAfter.length&&t-this.prevTime<r.newGroupDelay&&r.joinToEvent(i,function(e,t){let n=[],r=!1;return e.iterChangedRanges((e,t)=>n.push(e,t)),t.iterChangedRanges((e,t,i,o)=>{for(let e=0;e<n.length;){let t=n[e++],s=n[e++];o>=t&&i<=s&&(r=!0)}}),r}(s.changes,e.changes))||"input.type.compose"==n)?DE(o,o.length-1,r.minDepth,new ME(e.changes.compose(s.changes),PE(Qy.mapEffects(e.effects,s.changes),s.effects),s.mapped,s.startSelection,RE)):DE(o,o.length,r.minDepth,e),new VE(o,RE,t,n)}addSelection(e,t,n,r){let i=this.done.length?this.done[this.done.length-1].selectionsAfter:RE;return i.length>0&&t-this.prevTime<r&&n==this.prevUserEvent&&n&&/^select($|\.)/.test(n)&&(o=i[i.length-1],s=e,o.ranges.length==s.ranges.length&&0===o.ranges.filter((e,t)=>e.empty!=s.ranges[t].empty).length)?this:new VE(IE(this.done,e),this.undone,t,n);var o,s}addMapping(e){return new VE(LE(this.done,e),LE(this.undone,e),this.prevTime,this.prevUserEvent)}pop(e,t,n){let r=0==e?this.done:this.undone;if(0==r.length)return null;let i=r[r.length-1],o=i.selectionsAfter[0]||t.selection;if(n&&i.selectionsAfter.length)return t.update({selection:i.selectionsAfter[i.selectionsAfter.length-1],annotations:yE.of({side:e,rest:NE(r),selection:o}),userEvent:0==e?"select.undo":"select.redo",scrollIntoView:!0});if(i.changes){let n=1==r.length?RE:r.slice(0,r.length-1);return i.mapped&&(n=LE(n,i.mapped)),t.update({changes:i.changes,selection:i.startSelection,effects:i.effects,annotations:yE.of({side:e,rest:n,selection:o}),filter:!1,userEvent:0==e?"undo":"redo",scrollIntoView:!0})}return null}}VE.empty=new VE(RE,RE);const zE=[{key:"Mod-z",run:BE,preventDefault:!0},{key:"Mod-y",mac:"Mod-Shift-z",run:_E,preventDefault:!0},{linux:"Ctrl-Shift-z",run:_E,preventDefault:!0},{key:"Mod-u",run:TE,preventDefault:!0},{key:"Alt-u",mac:"Mod-Shift-u",run:EE,preventDefault:!0}];function WE(e,t){return oy.create(e.ranges.map(t),e.mainIndex)}function $E(e,t){return e.update({selection:t,scrollIntoView:!0,userEvent:"select"})}function HE({state:e,dispatch:t},n){let r=WE(e.selection,n);return!r.eq(e.selection,!0)&&(t($E(e,r)),!0)}function jE(e,t){return oy.cursor(t?e.to:e.from)}function qE(e,t){return HE(e,n=>n.empty?e.moveByChar(n,t):jE(n,t))}function UE(e){return e.textDirectionAt(e.state.selection.main.head)==Sw.LTR}const GE=e=>qE(e,!UE(e)),YE=e=>qE(e,UE(e));function XE(e,t){return HE(e,n=>n.empty?e.moveByGroup(n,t):jE(n,t))}"undefined"!=typeof Intl&&Intl.Segmenter;function JE(e,t,n){if(t.type.prop(n))return!0;let r=t.to-t.from;return r&&(r>2||/[^\s,.;:]/.test(e.sliceDoc(t.from,t.to)))||t.firstChild}function KE(e,t,n){let r,i,o=W_(e).resolveInner(t.head),s=n?PB.closedBy:PB.openedBy;for(let r=t.head;;){let t=n?o.childAfter(r):o.childBefore(r);if(!t)break;JE(e,t,s)?o=t:r=n?t.to:t.from}return i=o.type.prop(s)&&(r=n?iE(e,o.from,1):iE(e,o.to,-1))&&r.matched?n?r.end.to:r.end.from:n?o.to:o.from,oy.cursor(i,n?-1:1)}function ZE(e,t){return HE(e,n=>{if(!n.empty)return jE(n,t);let r=e.moveVertically(n,t);return r.head!=n.head?r:e.moveToLineBoundary(n,t)})}const eM=e=>ZE(e,!1),tM=e=>ZE(e,!0);function nM(e){let t,n=e.scrollDOM.clientHeight<e.scrollDOM.scrollHeight-2,r=0,i=0;if(n){for(let t of e.state.facet(NS.scrollMargins)){let n=t(e);(null==n?void 0:n.top)&&(r=Math.max(null==n?void 0:n.top,r)),(null==n?void 0:n.bottom)&&(i=Math.max(null==n?void 0:n.bottom,i))}t=e.scrollDOM.clientHeight-r-i}else t=(e.dom.ownerDocument.defaultView||window).innerHeight;return{marginTop:r,marginBottom:i,selfScroll:n,height:Math.max(e.defaultLineHeight,t-5)}}function rM(e,t){let n,r=nM(e),{state:i}=e,o=WE(i.selection,n=>n.empty?e.moveVertically(n,t,r.height):jE(n,t));if(o.eq(i.selection))return!1;if(r.selfScroll){let t=e.coordsAtPos(i.selection.main.head),s=e.scrollDOM.getBoundingClientRect(),a=s.top+r.marginTop,l=s.bottom-r.marginBottom;t&&t.top>a&&t.bottom<l&&(n=NS.scrollIntoView(o.main.head,{y:"start",yMargin:t.top-a}))}return e.dispatch($E(i,o),{effects:n}),!0}const iM=e=>rM(e,!1),oM=e=>rM(e,!0);function sM(e,t,n){let r=e.lineBlockAt(t.head),i=e.moveToLineBoundary(t,n);if(i.head==t.head&&i.head!=(n?r.to:r.from)&&(i=e.moveToLineBoundary(t,n,!1)),!n&&i.head==r.from&&r.length){let n=/^\s*/.exec(e.state.sliceDoc(r.from,Math.min(r.from+100,r.to)))[0].length;n&&t.head!=r.from+n&&(i=oy.cursor(r.from+n))}return i}function aM(e,t,n){let r=!1,i=WE(e.selection,t=>{let i=iE(e,t.head,-1)||iE(e,t.head,1)||t.head>0&&iE(e,t.head-1,1)||t.head<e.doc.length&&iE(e,t.head+1,-1);if(!i||!i.end)return t;r=!0;let o=i.start.from==t.head?i.end.to:i.end.from;return n?oy.range(t.anchor,o):oy.cursor(o)});return!!r&&(t($E(e,i)),!0)}function lM(e,t){let n=WE(e.state.selection,e=>{let n=t(e);return oy.range(e.anchor,n.head,n.goalColumn,n.bidiLevel||void 0)});return!n.eq(e.state.selection)&&(e.dispatch($E(e.state,n)),!0)}function cM(e,t){return lM(e,n=>e.moveByChar(n,t))}const dM=e=>cM(e,!UE(e)),hM=e=>cM(e,UE(e));function uM(e,t){return lM(e,n=>e.moveByGroup(n,t))}function pM(e,t){return lM(e,n=>e.moveVertically(n,t))}const fM=e=>pM(e,!1),gM=e=>pM(e,!0);function mM(e,t){return lM(e,n=>e.moveVertically(n,t,nM(e).height))}const vM=e=>mM(e,!1),AM=e=>mM(e,!0),bM=({state:e,dispatch:t})=>(t($E(e,{anchor:0})),!0),yM=({state:e,dispatch:t})=>(t($E(e,{anchor:e.doc.length})),!0),xM=({state:e,dispatch:t})=>(t($E(e,{anchor:e.selection.main.anchor,head:0})),!0),wM=({state:e,dispatch:t})=>(t($E(e,{anchor:e.selection.main.anchor,head:e.doc.length})),!0);function CM(e,t){let{state:n}=e,r=n.selection,i=n.selection.ranges.slice();for(let r of n.selection.ranges){let o=n.doc.lineAt(r.head);if(t?o.to<e.state.doc.length:o.from>0)for(let n=r;;){let r=e.moveVertically(n,t);if(r.head<o.from||r.head>o.to){i.some(e=>e.head==r.head)||i.push(r);break}if(r.head==n.head)break;n=r}}return i.length!=r.ranges.length&&(e.dispatch($E(n,oy.create(i,i.length-1))),!0)}function kM(e,t){if(e.state.readOnly)return!1;let n="delete.selection",{state:r}=e,i=r.changeByRange(r=>{let{from:i,to:o}=r;if(i==o){let s=t(r);s<i?(n="delete.backward",s=SM(e,s,!1)):s>i&&(n="delete.forward",s=SM(e,s,!0)),i=Math.min(i,s),o=Math.max(o,s)}else i=SM(e,i,!1),o=SM(e,o,!0);return i==o?{range:r}:{changes:{from:i,to:o},range:oy.cursor(i,i<r.head?-1:1)}});return!i.changes.empty&&(e.dispatch(r.update(i,{scrollIntoView:!0,userEvent:n,effects:"delete.selection"==n?NS.announce.of(r.phrase("Selection deleted")):void 0})),!0)}function SM(e,t,n){if(e instanceof NS)for(let r of e.state.facet(NS.atomicRanges).map(t=>t(e)))r.between(t,t,(e,r)=>{e<t&&r>t&&(t=n?r:e)});return t}const OM=(e,t,n)=>kM(e,r=>{let i,o,s=r.from,{state:a}=e,l=a.doc.lineAt(s);if(n&&!t&&s>l.from&&s<l.from+200&&!/[^ \t]/.test(i=l.text.slice(0,s-l.from))){if("\t"==i[i.length-1])return s-1;let e=gx(i,a.tabSize)%tT(a)||tT(a);for(let t=0;t<e&&" "==i[i.length-1-t];t++)s--;o=s}else o=Hb(l.text,s-l.from,t,t)+l.from,o==s&&l.number!=(t?a.doc.lines:1)?o+=t?1:-1:!t&&/[\ufe00-\ufe0f]/.test(l.text.slice(o-l.from,s-l.from))&&(o=Hb(l.text,o-l.from,!1,!1)+l.from);return o}),BM=e=>OM(e,!1,!0),_M=e=>OM(e,!0,!1),TM=(e,t)=>kM(e,n=>{let r=n.head,{state:i}=e,o=i.doc.lineAt(r),s=i.charCategorizer(r);for(let e=null;;){if(r==(t?o.to:o.from)){r==n.head&&o.number!=(t?i.doc.lines:1)&&(r+=t?1:-1);break}let a=Hb(o.text,r-o.from,t)+o.from,l=o.text.slice(Math.min(r,a)-o.from,Math.max(r,a)-o.from),c=s(l);if(null!=e&&c!=e)break;" "==l&&r==n.head||(e=c),r=a}return r}),EM=e=>TM(e,!1);function MM(e){let t=[],n=-1;for(let r of e.selection.ranges){let i=e.doc.lineAt(r.from),o=e.doc.lineAt(r.to);if(r.empty||r.to!=o.from||(o=e.doc.lineAt(r.to-1)),n>=i.number){let e=t[t.length-1];e.to=o.to,e.ranges.push(r)}else t.push({from:i.from,to:o.to,ranges:[r]});n=o.number+1}return t}function DM(e,t,n){if(e.readOnly)return!1;let r=[],i=[];for(let t of MM(e)){if(n?t.to==e.doc.length:0==t.from)continue;let o=e.doc.lineAt(n?t.to+1:t.from-1),s=o.length+1;if(n){r.push({from:t.to,to:o.to},{from:t.from,insert:o.text+e.lineBreak});for(let n of t.ranges)i.push(oy.range(Math.min(e.doc.length,n.anchor+s),Math.min(e.doc.length,n.head+s)))}else{r.push({from:o.from,to:t.from},{from:t.to,insert:e.lineBreak+o.text});for(let e of t.ranges)i.push(oy.range(e.anchor-s,e.head-s))}}return!!r.length&&(t(e.update({changes:r,scrollIntoView:!0,selection:oy.create(i,e.selection.mainIndex),userEvent:"move.line"})),!0)}function PM(e,t,n){if(e.readOnly)return!1;let r=[];for(let t of MM(e))n?r.push({from:t.from,insert:e.doc.slice(t.from,t.to)+e.lineBreak}):r.push({from:t.to,insert:e.lineBreak+e.doc.slice(t.from,t.to)});let i=e.changes(r);return t(e.update({changes:i,selection:e.selection.map(i,n?1:-1),scrollIntoView:!0,userEvent:"input.copyline"})),!0}const RM=NM(!1),IM=NM(!0);function NM(e){return({state:t,dispatch:n})=>{if(t.readOnly)return!1;let r=t.changeByRange(n=>{let{from:r,to:i}=n,o=t.doc.lineAt(r),s=!e&&r==i&&function(e,t){if(/\(\)|\[\]|\{\}/.test(e.sliceDoc(t-1,t+1)))return{from:t,to:t};let n,r=W_(e).resolveInner(t),i=r.childBefore(t),o=r.childAfter(t);return i&&o&&i.to<=t&&o.from>=t&&(n=i.type.prop(PB.closedBy))&&n.indexOf(o.name)>-1&&e.doc.lineAt(i.to).from==e.doc.lineAt(o.from).from&&!/\S/.test(e.sliceDoc(i.to,o.from))?{from:i.to,to:o.from}:null}(t,r);e&&(r=i=(i<=o.to?o:t.doc.lineAt(i)).to);let a=new iT(t,{simulateBreak:r,simulateDoubleBreak:!!s}),l=rT(a,r);for(null==l&&(l=gx(/^\s*/.exec(t.doc.lineAt(r).text)[0],t.tabSize));i<o.to&&/\s/.test(o.text[i-o.from]);)i++;s?({from:r,to:i}=s):r>o.from&&r<o.from+100&&!/\S/.test(o.text.slice(0,r))&&(r=o.from);let c=["",nT(t,l)];return s&&c.push(nT(t,a.lineIndent(o.from,-1))),{changes:{from:r,to:i,insert:Rb.of(c)},range:oy.cursor(r+1+c[1].length)}});return n(t.update(r,{scrollIntoView:!0,userEvent:"input"})),!0}}function LM(e,t){let n=-1;return e.changeByRange(r=>{let i=[];for(let o=r.from;o<=r.to;){let s=e.doc.lineAt(o);s.number>n&&(r.empty||r.to>s.from)&&(t(s,i,r),n=s.number),o=s.to+1}let o=e.changes(i);return{changes:i,range:oy.range(o.mapPos(r.anchor,1),o.mapPos(r.head,1))}})}const QM=({state:e,dispatch:t})=>!e.readOnly&&(t(e.update(LM(e,(t,n)=>{n.push({from:t.from,insert:e.facet(eT)})}),{userEvent:"input.indent"})),!0),FM=({state:e,dispatch:t})=>!e.readOnly&&(t(e.update(LM(e,(t,n)=>{let r=/^\s*/.exec(t.text)[0];if(!r)return;let i=gx(r,e.tabSize),o=0,s=nT(e,Math.max(0,i-tT(e)));for(;o<r.length&&o<s.length&&r.charCodeAt(o)==s.charCodeAt(o);)o++;n.push({from:t.from+o,to:t.from+r.length,insert:s.slice(o)})}),{userEvent:"delete.dedent"})),!0),VM=[{key:"Ctrl-b",run:GE,shift:dM,preventDefault:!0},{key:"Ctrl-f",run:YE,shift:hM},{key:"Ctrl-p",run:eM,shift:fM},{key:"Ctrl-n",run:tM,shift:gM},{key:"Ctrl-a",run:e=>HE(e,t=>oy.cursor(e.lineBlockAt(t.head).from,1)),shift:e=>lM(e,t=>oy.cursor(e.lineBlockAt(t.head).from))},{key:"Ctrl-e",run:e=>HE(e,t=>oy.cursor(e.lineBlockAt(t.head).to,-1)),shift:e=>lM(e,t=>oy.cursor(e.lineBlockAt(t.head).to))},{key:"Ctrl-d",run:_M},{key:"Ctrl-h",run:BM},{key:"Ctrl-k",run:e=>kM(e,t=>{let n=e.lineBlockAt(t.head).to;return t.head<n?n:Math.min(e.state.doc.length,t.head+1)})},{key:"Ctrl-Alt-h",run:EM},{key:"Ctrl-o",run:({state:e,dispatch:t})=>{if(e.readOnly)return!1;let n=e.changeByRange(e=>({changes:{from:e.from,to:e.to,insert:Rb.of(["",""])},range:oy.cursor(e.from)}));return t(e.update(n,{scrollIntoView:!0,userEvent:"input"})),!0}},{key:"Ctrl-t",run:({state:e,dispatch:t})=>{if(e.readOnly)return!1;let n=e.changeByRange(t=>{if(!t.empty||0==t.from||t.from==e.doc.length)return{range:t};let n=t.from,r=e.doc.lineAt(n),i=n==r.from?n-1:Hb(r.text,n-r.from,!1)+r.from,o=n==r.to?n+1:Hb(r.text,n-r.from,!0)+r.from;return{changes:{from:i,to:o,insert:e.doc.slice(n,o).append(e.doc.slice(i,n))},range:oy.cursor(o)}});return!n.changes.empty&&(t(e.update(n,{scrollIntoView:!0,userEvent:"move.character"})),!0)}},{key:"Ctrl-v",run:oM}],zM=[{key:"ArrowLeft",run:GE,shift:dM,preventDefault:!0},{key:"Mod-ArrowLeft",mac:"Alt-ArrowLeft",run:e=>XE(e,!UE(e)),shift:e=>uM(e,!UE(e)),preventDefault:!0},{mac:"Cmd-ArrowLeft",run:e=>HE(e,t=>sM(e,t,!UE(e))),shift:e=>lM(e,t=>sM(e,t,!UE(e))),preventDefault:!0},{key:"ArrowRight",run:YE,shift:hM,preventDefault:!0},{key:"Mod-ArrowRight",mac:"Alt-ArrowRight",run:e=>XE(e,UE(e)),shift:e=>uM(e,UE(e)),preventDefault:!0},{mac:"Cmd-ArrowRight",run:e=>HE(e,t=>sM(e,t,UE(e))),shift:e=>lM(e,t=>sM(e,t,UE(e))),preventDefault:!0},{key:"ArrowUp",run:eM,shift:fM,preventDefault:!0},{mac:"Cmd-ArrowUp",run:bM,shift:xM},{mac:"Ctrl-ArrowUp",run:iM,shift:vM},{key:"ArrowDown",run:tM,shift:gM,preventDefault:!0},{mac:"Cmd-ArrowDown",run:yM,shift:wM},{mac:"Ctrl-ArrowDown",run:oM,shift:AM},{key:"PageUp",run:iM,shift:vM},{key:"PageDown",run:oM,shift:AM},{key:"Home",run:e=>HE(e,t=>sM(e,t,!1)),shift:e=>lM(e,t=>sM(e,t,!1)),preventDefault:!0},{key:"Mod-Home",run:bM,shift:xM},{key:"End",run:e=>HE(e,t=>sM(e,t,!0)),shift:e=>lM(e,t=>sM(e,t,!0)),preventDefault:!0},{key:"Mod-End",run:yM,shift:wM},{key:"Enter",run:RM,shift:RM},{key:"Mod-a",run:({state:e,dispatch:t})=>(t(e.update({selection:{anchor:0,head:e.doc.length},userEvent:"select"})),!0)},{key:"Backspace",run:BM,shift:BM,preventDefault:!0},{key:"Delete",run:_M,preventDefault:!0},{key:"Mod-Backspace",mac:"Alt-Backspace",run:EM,preventDefault:!0},{key:"Mod-Delete",mac:"Alt-Delete",run:e=>TM(e,!0),preventDefault:!0},{mac:"Mod-Backspace",run:e=>kM(e,t=>{let n=e.moveToLineBoundary(t,!1).head;return t.head>n?n:Math.max(0,t.head-1)}),preventDefault:!0},{mac:"Mod-Delete",run:e=>kM(e,t=>{let n=e.moveToLineBoundary(t,!0).head;return t.head<n?n:Math.min(e.state.doc.length,t.head+1)}),preventDefault:!0}].concat(VM.map(e=>({mac:e.key,run:e.run,shift:e.shift}))),WM=[{key:"Alt-ArrowLeft",mac:"Ctrl-ArrowLeft",run:e=>HE(e,t=>KE(e.state,t,!UE(e))),shift:e=>lM(e,t=>KE(e.state,t,!UE(e)))},{key:"Alt-ArrowRight",mac:"Ctrl-ArrowRight",run:e=>HE(e,t=>KE(e.state,t,UE(e))),shift:e=>lM(e,t=>KE(e.state,t,UE(e)))},{key:"Alt-ArrowUp",run:({state:e,dispatch:t})=>DM(e,t,!1)},{key:"Shift-Alt-ArrowUp",run:({state:e,dispatch:t})=>PM(e,t,!1)},{key:"Alt-ArrowDown",run:({state:e,dispatch:t})=>DM(e,t,!0)},{key:"Shift-Alt-ArrowDown",run:({state:e,dispatch:t})=>PM(e,t,!0)},{key:"Mod-Alt-ArrowUp",run:e=>CM(e,!1)},{key:"Mod-Alt-ArrowDown",run:e=>CM(e,!0)},{key:"Escape",run:({state:e,dispatch:t})=>{let n=e.selection,r=null;return n.ranges.length>1?r=oy.create([n.main]):n.main.empty||(r=oy.create([oy.cursor(n.main.head)])),!!r&&(t($E(e,r)),!0)}},{key:"Mod-Enter",run:IM},{key:"Alt-l",mac:"Ctrl-l",run:({state:e,dispatch:t})=>{let n=MM(e).map(({from:t,to:n})=>oy.range(t,Math.min(n+1,e.doc.length)));return t(e.update({selection:oy.create(n),userEvent:"select"})),!0}},{key:"Mod-i",run:({state:e,dispatch:t})=>{let n=WE(e.selection,t=>{let n=W_(e),r=n.resolveStack(t.from,1);if(t.empty){let e=n.resolveStack(t.from,-1);e.node.from>=r.node.from&&e.node.to<=r.node.to&&(r=e)}for(let e=r;e;e=e.next){let{node:n}=e;if((n.from<t.from&&n.to>=t.to||n.to>t.to&&n.from<=t.from)&&e.next)return oy.range(n.to,n.from)}return t});return!n.eq(e.selection)&&(t($E(e,n)),!0)},preventDefault:!0},{key:"Mod-[",run:FM},{key:"Mod-]",run:QM},{key:"Mod-Alt-\\",run:({state:e,dispatch:t})=>{if(e.readOnly)return!1;let n=Object.create(null),r=new iT(e,{overrideIndentation:e=>{let t=n[e];return null==t?-1:t}}),i=LM(e,(t,i,o)=>{let s=rT(r,t.from);if(null==s)return;/\S/.test(t.text)||(s=0);let a=/^\s*/.exec(t.text)[0],l=nT(e,s);(a!=l||o.from<t.from+a.length)&&(n[t.from]=s,i.push({from:t.from,to:t.from+a.length,insert:l}))});return i.changes.empty||t(e.update(i,{userEvent:"indent"})),!0}},{key:"Shift-Mod-k",run:e=>{if(e.state.readOnly)return!1;let{state:t}=e,n=t.changes(MM(t).map(({from:e,to:n})=>(e>0?e--:n<t.doc.length&&n++,{from:e,to:n}))),r=WE(t.selection,t=>{let n;if(e.lineWrapping){let r=e.lineBlockAt(t.head),i=e.coordsAtPos(t.head,t.assoc||1);i&&(n=r.bottom+e.documentTop-i.bottom+e.defaultLineHeight/2)}return e.moveVertically(t,!0,n)}).map(n);return e.dispatch({changes:n,selection:r,scrollIntoView:!0,userEvent:"delete.line"}),!0}},{key:"Shift-Mod-\\",run:({state:e,dispatch:t})=>aM(e,t,!1)},{key:"Mod-/",run:e=>{let{state:t}=e,n=t.doc.lineAt(t.selection.main.from),r=vE(e.state,n.from);return r.line?fE(e):!!r.block&&mE(e)}},{key:"Alt-A",run:gE},{key:"Ctrl-m",mac:"Shift-Alt-m",run:e=>(e.setTabFocusMode(),!0)}].concat(zM),$M={key:"Tab",run:QM,shift:FM},HM="function"==typeof String.prototype.normalize?e=>e.normalize("NFKD"):e=>e;class jM{constructor(e,t,n=0,r=e.length,i,o){this.test=o,this.value={from:0,to:0},this.done=!1,this.matches=[],this.buffer="",this.bufferPos=0,this.iter=e.iterRange(n,r),this.bufferStart=n,this.normalize=i?e=>i(HM(e)):HM,this.query=this.normalize(t)}peek(){if(this.bufferPos==this.buffer.length){if(this.bufferStart+=this.buffer.length,this.iter.next(),this.iter.done)return-1;this.bufferPos=0,this.buffer=this.iter.value}return jb(this.buffer,this.bufferPos)}next(){for(;this.matches.length;)this.matches.pop();return this.nextOverlapping()}nextOverlapping(){for(;;){let e=this.peek();if(e<0)return this.done=!0,this;let t=qb(e),n=this.bufferStart+this.bufferPos;this.bufferPos+=Ub(e);let r=this.normalize(t);if(r.length)for(let e=0,i=n;;e++){let o=r.charCodeAt(e),s=this.match(o,i,this.bufferPos+this.bufferStart);if(e==r.length-1){if(s)return this.value=s,this;break}i==n&&e<t.length&&t.charCodeAt(e)==o&&i++}}}match(e,t,n){let r=null;for(let t=0;t<this.matches.length;t+=2){let i=this.matches[t],o=!1;this.query.charCodeAt(i)==e&&(i==this.query.length-1?r={from:this.matches[t+1],to:n}:(this.matches[t]++,o=!0)),o||(this.matches.splice(t,2),t-=2)}return this.query.charCodeAt(0)==e&&(1==this.query.length?r={from:t,to:n}:this.matches.push(1,t)),r&&this.test&&!this.test(r.from,r.to,this.buffer,this.bufferStart)&&(r=null),r}}"undefined"!=typeof Symbol&&(jM.prototype[Symbol.iterator]=function(){return this});const qM={from:-1,to:-1,match:/.*/.exec("")},UM="gm"+(null==/x/.unicode?"":"u");class GM{constructor(e,t,n,r=0,i=e.length){if(this.text=e,this.to=i,this.curLine="",this.done=!1,this.value=qM,/\\[sWDnr]|\n|\r|\[\^/.test(t))return new JM(e,t,n,r,i);this.re=new RegExp(t,UM+((null==n?void 0:n.ignoreCase)?"i":"")),this.test=null==n?void 0:n.test,this.iter=e.iter();let o=e.lineAt(r);this.curLineStart=o.from,this.matchPos=KM(e,r),this.getLine(this.curLineStart)}getLine(e){this.iter.next(e),this.iter.lineBreak?this.curLine="":(this.curLine=this.iter.value,this.curLineStart+this.curLine.length>this.to&&(this.curLine=this.curLine.slice(0,this.to-this.curLineStart)),this.iter.next())}nextLine(){this.curLineStart=this.curLineStart+this.curLine.length+1,this.curLineStart>this.to?this.curLine="":this.getLine(0)}next(){for(let e=this.matchPos-this.curLineStart;;){this.re.lastIndex=e;let t=this.matchPos<=this.to&&this.re.exec(this.curLine);if(t){let n=this.curLineStart+t.index,r=n+t[0].length;if(this.matchPos=KM(this.text,r+(n==r?1:0)),n==this.curLineStart+this.curLine.length&&this.nextLine(),(n<r||n>this.value.to)&&(!this.test||this.test(n,r,t)))return this.value={from:n,to:r,match:t},this;e=this.matchPos-this.curLineStart}else{if(!(this.curLineStart+this.curLine.length<this.to))return this.done=!0,this;this.nextLine(),e=0}}}}const YM=new WeakMap;class XM{constructor(e,t){this.from=e,this.text=t}get to(){return this.from+this.text.length}static get(e,t,n){let r=YM.get(e);if(!r||r.from>=n||r.to<=t){let r=new XM(t,e.sliceString(t,n));return YM.set(e,r),r}if(r.from==t&&r.to==n)return r;let{text:i,from:o}=r;return o>t&&(i=e.sliceString(t,o)+i,o=t),r.to<n&&(i+=e.sliceString(r.to,n)),YM.set(e,new XM(o,i)),new XM(t,i.slice(t-o,n-o))}}class JM{constructor(e,t,n,r,i){this.text=e,this.to=i,this.done=!1,this.value=qM,this.matchPos=KM(e,r),this.re=new RegExp(t,UM+((null==n?void 0:n.ignoreCase)?"i":"")),this.test=null==n?void 0:n.test,this.flat=XM.get(e,r,this.chunkEnd(r+5e3))}chunkEnd(e){return e>=this.to?this.to:this.text.lineAt(e).to}next(){for(;;){let e=this.re.lastIndex=this.matchPos-this.flat.from,t=this.re.exec(this.flat.text);if(t&&!t[0]&&t.index==e&&(this.re.lastIndex=e+1,t=this.re.exec(this.flat.text)),t){let e=this.flat.from+t.index,n=e+t[0].length;if((this.flat.to>=this.to||t.index+t[0].length<=this.flat.text.length-10)&&(!this.test||this.test(e,n,t)))return this.value={from:e,to:n,match:t},this.matchPos=KM(this.text,n+(e==n?1:0)),this}if(this.flat.to==this.to)return this.done=!0,this;this.flat=XM.get(this.text,this.flat.from,this.chunkEnd(this.flat.from+2*this.flat.text.length))}}}function KM(e,t){if(t>=e.length)return t;let n,r=e.lineAt(t);for(;t<r.to&&(n=r.text.charCodeAt(t-r.from))>=56320&&n<57344;)t++;return t}"undefined"!=typeof Symbol&&(GM.prototype[Symbol.iterator]=JM.prototype[Symbol.iterator]=function(){return this});const ZM={highlightWordAroundCursor:!1,minSelectionLength:1,maxMatches:100,wholeWords:!1},eD=ly.define({combine:e=>Jy(e,ZM,{highlightWordAroundCursor:(e,t)=>e||t,minSelectionLength:Math.min,maxMatches:Math.min})});function tD(e){let t=[sD,oD];return e&&t.push(eD.of(e)),t}const nD=Xx.mark({class:"cm-selectionMatch"}),rD=Xx.mark({class:"cm-selectionMatch cm-selectionMatch-main"});function iD(e,t,n,r){return!(0!=n&&e(t.sliceDoc(n-1,n))==qy.Word||r!=t.doc.length&&e(t.sliceDoc(r,r+1))==qy.Word)}const oD=dC.fromClass(class{constructor(e){this.decorations=this.getDeco(e)}update(e){(e.selectionSet||e.docChanged||e.viewportChanged)&&(this.decorations=this.getDeco(e.view))}getDeco(e){let t=e.state.facet(eD),{state:n}=e,r=n.selection;if(r.ranges.length>1)return Xx.none;let i,o=r.main,s=null;if(o.empty){if(!t.highlightWordAroundCursor)return Xx.none;let e=n.wordAt(o.head);if(!e)return Xx.none;s=n.charCategorizer(o.head),i=n.sliceDoc(e.from,e.to)}else{let e=o.to-o.from;if(e<t.minSelectionLength||e>200)return Xx.none;if(t.wholeWords){if(i=n.sliceDoc(o.from,o.to),s=n.charCategorizer(o.head),!iD(s,n,o.from,o.to)||!function(e,t,n,r){return e(t.sliceDoc(n,n+1))==qy.Word&&e(t.sliceDoc(r-1,r))==qy.Word}(s,n,o.from,o.to))return Xx.none}else if(i=n.sliceDoc(o.from,o.to),!i)return Xx.none}let a=[];for(let r of e.visibleRanges){let e=new jM(n.doc,i,r.from,r.to);for(;!e.next().done;){let{from:r,to:i}=e.value;if((!s||iD(s,n,r,i))&&(o.empty&&r<=o.from&&i>=o.to?a.push(rD.range(r,i)):(r>=o.to||i<=o.from)&&a.push(nD.range(r,i)),a.length>t.maxMatches))return Xx.none}}return Xx.set(a)}},{decorations:e=>e.decorations}),sD=NS.baseTheme({".cm-selectionMatch":{backgroundColor:"#99ff7780"},".cm-searchMatch .cm-selectionMatch":{backgroundColor:"transparent"}});const aD=ly.define({combine:e=>Jy(e,{top:!1,caseSensitive:!1,literal:!1,regexp:!1,wholeWord:!1,createPanel:e=>new ND(e),scrollToMatch:e=>NS.scrollIntoView(e)})});class lD{constructor(e){this.search=e.search,this.caseSensitive=!!e.caseSensitive,this.literal=!!e.literal,this.regexp=!!e.regexp,this.replace=e.replace||"",this.valid=!!this.search&&(!this.regexp||function(e){try{return new RegExp(e,UM),!0}catch(e){return!1}}(this.search)),this.unquoted=this.unquote(this.search),this.wholeWord=!!e.wholeWord,this.test=e.test}unquote(e){return this.literal?e:e.replace(/\\([nrt\\])/g,(e,t)=>"n"==t?"\n":"r"==t?"\r":"t"==t?"\t":"\\")}eq(e){return this.search==e.search&&this.replace==e.replace&&this.caseSensitive==e.caseSensitive&&this.regexp==e.regexp&&this.wholeWord==e.wholeWord&&this.test==e.test}create(){return this.regexp?new gD(this):new hD(this)}getCursor(e,t=0,n){let r=e.doc?e:Xy.create({doc:e});return null==n&&(n=r.doc.length),this.regexp?uD(this,r,t,n):dD(this,r,t,n)}}class cD{constructor(e){this.spec=e}}function dD(e,t,n,r){let i;return e.wholeWord&&(i=function(e,t){return(n,r,i,o)=>((o>n||o+i.length<r)&&(o=Math.max(0,n-2),i=e.sliceString(o,Math.min(e.length,r+2))),!(t(pD(i,n-o))==qy.Word&&t(fD(i,n-o))==qy.Word||t(fD(i,r-o))==qy.Word&&t(pD(i,r-o))==qy.Word))}(t.doc,t.charCategorizer(t.selection.main.head))),e.test&&(i=function(e,t,n){return(r,i,o,s)=>{if(n&&!n(r,i,o,s))return!1;let a=r>=s&&i<=s+o.length?o.slice(r-s,i-s):t.doc.sliceString(r,i);return e(a,t,r,i)}}(e.test,t,i)),new jM(t.doc,e.unquoted,n,r,e.caseSensitive?void 0:e=>e.toLowerCase(),i)}class hD extends cD{constructor(e){super(e)}nextMatch(e,t,n){let r=dD(this.spec,e,n,e.doc.length).nextOverlapping();if(r.done){let n=Math.min(e.doc.length,t+this.spec.unquoted.length);r=dD(this.spec,e,0,n).nextOverlapping()}return r.done||r.value.from==t&&r.value.to==n?null:r.value}prevMatchInRange(e,t,n){for(let r=n;;){let n=Math.max(t,r-1e4-this.spec.unquoted.length),i=dD(this.spec,e,n,r),o=null;for(;!i.nextOverlapping().done;)o=i.value;if(o)return o;if(n==t)return null;r-=1e4}}prevMatch(e,t,n){let r=this.prevMatchInRange(e,0,t);return r||(r=this.prevMatchInRange(e,Math.max(0,n-this.spec.unquoted.length),e.doc.length)),!r||r.from==t&&r.to==n?null:r}getReplacement(e){return this.spec.unquote(this.spec.replace)}matchAll(e,t){let n=dD(this.spec,e,0,e.doc.length),r=[];for(;!n.next().done;){if(r.length>=t)return null;r.push(n.value)}return r}highlight(e,t,n,r){let i=dD(this.spec,e,Math.max(0,t-this.spec.unquoted.length),Math.min(n+this.spec.unquoted.length,e.doc.length));for(;!i.next().done;)r(i.value.from,i.value.to)}}function uD(e,t,n,r){let i;var o;return e.wholeWord&&(o=t.charCategorizer(t.selection.main.head),i=(e,t,n)=>!n[0].length||(o(pD(n.input,n.index))!=qy.Word||o(fD(n.input,n.index))!=qy.Word)&&(o(fD(n.input,n.index+n[0].length))!=qy.Word||o(pD(n.input,n.index+n[0].length))!=qy.Word)),e.test&&(i=function(e,t,n){return(r,i,o)=>(!n||n(r,i,o))&&e(o[0],t,r,i)}(e.test,t,i)),new GM(t.doc,e.search,{ignoreCase:!e.caseSensitive,test:i},n,r)}function pD(e,t){return e.slice(Hb(e,t,!1),t)}function fD(e,t){return e.slice(t,Hb(e,t))}class gD extends cD{nextMatch(e,t,n){let r=uD(this.spec,e,n,e.doc.length).next();return r.done&&(r=uD(this.spec,e,0,t).next()),r.done?null:r.value}prevMatchInRange(e,t,n){for(let r=1;;r++){let i=Math.max(t,n-1e4*r),o=uD(this.spec,e,i,n),s=null;for(;!o.next().done;)s=o.value;if(s&&(i==t||s.from>i+10))return s;if(i==t)return null}}prevMatch(e,t,n){return this.prevMatchInRange(e,0,t)||this.prevMatchInRange(e,n,e.doc.length)}getReplacement(e){return this.spec.unquote(this.spec.replace).replace(/\$([$&]|\d+)/g,(t,n)=>{if("&"==n)return e.match[0];if("$"==n)return"$";for(let t=n.length;t>0;t--){let r=+n.slice(0,t);if(r>0&&r<e.match.length)return e.match[r]+n.slice(t)}return t})}matchAll(e,t){let n=uD(this.spec,e,0,e.doc.length),r=[];for(;!n.next().done;){if(r.length>=t)return null;r.push(n.value)}return r}highlight(e,t,n,r){let i=uD(this.spec,e,Math.max(0,t-250),Math.min(n+250,e.doc.length));for(;!i.next().done;)r(i.value.from,i.value.to)}}const mD=Qy.define(),vD=Qy.define(),AD=gy.define({create:e=>new bD(ED(e).create(),null),update(e,t){for(let n of t.effects)n.is(mD)?e=new bD(n.value.create(),e.panel):n.is(vD)&&(e=new bD(e.query,n.value?TD:null));return e},provide:e=>tB.from(e,e=>e.panel)});class bD{constructor(e,t){this.query=e,this.panel=t}}const yD=Xx.mark({class:"cm-searchMatch"}),xD=Xx.mark({class:"cm-searchMatch cm-searchMatch-selected"}),wD=dC.fromClass(class{constructor(e){this.view=e,this.decorations=this.highlight(e.state.field(AD))}update(e){let t=e.state.field(AD);(t!=e.startState.field(AD)||e.docChanged||e.selectionSet||e.viewportChanged)&&(this.decorations=this.highlight(t))}highlight({query:e,panel:t}){if(!t||!e.spec.valid)return Xx.none;let{view:n}=this,r=new ix;for(let t=0,i=n.visibleRanges,o=i.length;t<o;t++){let{from:s,to:a}=i[t];for(;t<o-1&&a>i[t+1].from-500;)a=i[++t].to;e.highlight(n.state,s,a,(e,t)=>{let i=n.state.selection.ranges.some(n=>n.from==e&&n.to==t);r.add(e,t,i?xD:yD)})}return r.finish()}},{decorations:e=>e.decorations});function CD(e){return t=>{let n=t.state.field(AD,!1);return n&&n.query.spec.valid?e(t,n):PD(t)}}const kD=CD((e,{query:t})=>{let{to:n}=e.state.selection.main,r=t.nextMatch(e.state,n,n);if(!r)return!1;let i=oy.single(r.from,r.to),o=e.state.facet(aD);return e.dispatch({selection:i,effects:[FD(e,r),o.scrollToMatch(i.main,e)],userEvent:"select.search"}),DD(e),!0}),SD=CD((e,{query:t})=>{let{state:n}=e,{from:r}=n.selection.main,i=t.prevMatch(n,r,r);if(!i)return!1;let o=oy.single(i.from,i.to),s=e.state.facet(aD);return e.dispatch({selection:o,effects:[FD(e,i),s.scrollToMatch(o.main,e)],userEvent:"select.search"}),DD(e),!0}),OD=CD((e,{query:t})=>{let n=t.matchAll(e.state,1e3);return!(!n||!n.length)&&(e.dispatch({selection:oy.create(n.map(e=>oy.range(e.from,e.to))),userEvent:"select.search.matches"}),!0)}),BD=CD((e,{query:t})=>{let{state:n}=e,{from:r,to:i}=n.selection.main;if(n.readOnly)return!1;let o=t.nextMatch(n,r,r);if(!o)return!1;let s,a,l=o,c=[],d=[];l.from==r&&l.to==i&&(a=n.toText(t.getReplacement(l)),c.push({from:l.from,to:l.to,insert:a}),l=t.nextMatch(n,l.from,l.to),d.push(NS.announce.of(n.phrase("replaced match on line $",n.doc.lineAt(r).number)+".")));let h=e.state.changes(c);return l&&(s=oy.single(l.from,l.to).map(h),d.push(FD(e,l)),d.push(n.facet(aD).scrollToMatch(s.main,e))),e.dispatch({changes:h,selection:s,effects:d,userEvent:"input.replace"}),!0}),_D=CD((e,{query:t})=>{if(e.state.readOnly)return!1;let n=t.matchAll(e.state,1e9).map(e=>{let{from:n,to:r}=e;return{from:n,to:r,insert:t.getReplacement(e)}});if(!n.length)return!1;let r=e.state.phrase("replaced $ matches",n.length)+".";return e.dispatch({changes:n,effects:NS.announce.of(r),userEvent:"input.replace.all"}),!0});function TD(e){return e.state.facet(aD).createPanel(e)}function ED(e,t){var n,r,i,o,s;let a=e.selection.main,l=a.empty||a.to>a.from+100?"":e.sliceDoc(a.from,a.to);if(t&&!l)return t;let c=e.facet(aD);return new lD({search:(null!==(n=null==t?void 0:t.literal)&&void 0!==n?n:c.literal)?l:l.replace(/\n/g,"\\n"),caseSensitive:null!==(r=null==t?void 0:t.caseSensitive)&&void 0!==r?r:c.caseSensitive,literal:null!==(i=null==t?void 0:t.literal)&&void 0!==i?i:c.literal,regexp:null!==(o=null==t?void 0:t.regexp)&&void 0!==o?o:c.regexp,wholeWord:null!==(s=null==t?void 0:t.wholeWord)&&void 0!==s?s:c.wholeWord})}function MD(e){let t=JO(e,TD);return t&&t.dom.querySelector("[main-field]")}function DD(e){let t=MD(e);t&&t==e.root.activeElement&&t.select()}const PD=e=>{let t=e.state.field(AD,!1);if(t&&t.panel){let n=MD(e);if(n&&n!=e.root.activeElement){let r=ED(e.state,t.query.spec);r.valid&&e.dispatch({effects:mD.of(r)}),n.focus(),n.select()}}else e.dispatch({effects:[vD.of(!0),t?mD.of(ED(e.state,t.query.spec)):Qy.appendConfig.of(zD)]});return!0},RD=e=>{let t=e.state.field(AD,!1);if(!t||!t.panel)return!1;let n=JO(e,TD);return n&&n.dom.contains(e.root.activeElement)&&e.focus(),e.dispatch({effects:vD.of(!1)}),!0},ID=[{key:"Mod-f",run:PD,scope:"editor search-panel"},{key:"F3",run:kD,shift:SD,scope:"editor search-panel",preventDefault:!0},{key:"Mod-g",run:kD,shift:SD,scope:"editor search-panel",preventDefault:!0},{key:"Escape",run:RD,scope:"editor search-panel"},{key:"Mod-Shift-l",run:({state:e,dispatch:t})=>{let n=e.selection;if(n.ranges.length>1||n.main.empty)return!1;let{from:r,to:i}=n.main,o=[],s=0;for(let t=new jM(e.doc,e.sliceDoc(r,i));!t.next().done;){if(o.length>1e3)return!1;t.value.from==r&&(s=o.length),o.push(oy.range(t.value.from,t.value.to))}return t(e.update({selection:oy.create(o,s),userEvent:"select.search.matches"})),!0}},{key:"Mod-Alt-g",run:e=>{let{state:t}=e,n=String(t.doc.lineAt(e.state.selection.main.head).number),{close:r,result:i}=nB(e,{label:t.phrase("Go to line"),input:{type:"text",name:"line",value:n},focus:!0,submitLabel:t.phrase("go")});return i.then(n=>{let i=n&&/^([+-])?(\d+)?(:\d+)?(%)?$/.exec(n.elements.line.value);if(!i)return void e.dispatch({effects:r});let o=t.doc.lineAt(t.selection.main.head),[,s,a,l,c]=i,d=l?+l.slice(1):0,h=a?+a:o.number;if(a&&c){let e=h/100;s&&(e=e*("-"==s?-1:1)+o.number/t.doc.lines),h=Math.round(t.doc.lines*e)}else a&&s&&(h=h*("-"==s?-1:1)+o.number);let u=t.doc.line(Math.max(1,Math.min(t.doc.lines,h))),p=oy.cursor(u.from+Math.max(0,Math.min(d,u.length)));e.dispatch({effects:[r,NS.scrollIntoView(p.from,{y:"center"})],selection:p})}),!0}},{key:"Mod-d",run:({state:e,dispatch:t})=>{let{ranges:n}=e.selection;if(n.some(e=>e.from===e.to))return(({state:e,dispatch:t})=>{let{selection:n}=e,r=oy.create(n.ranges.map(t=>e.wordAt(t.head)||oy.cursor(t.head)),n.mainIndex);return!r.eq(n)&&(t(e.update({selection:r})),!0)})({state:e,dispatch:t});let r=e.sliceDoc(n[0].from,n[0].to);if(e.selection.ranges.some(t=>e.sliceDoc(t.from,t.to)!=r))return!1;let i=function(e,t){let{main:n,ranges:r}=e.selection,i=e.wordAt(n.head),o=i&&i.from==n.from&&i.to==n.to;for(let n=!1,i=new jM(e.doc,t,r[r.length-1].to);;){if(i.next(),!i.done){if(n&&r.some(e=>e.from==i.value.from))continue;if(o){let t=e.wordAt(i.value.from);if(!t||t.from!=i.value.from||t.to!=i.value.to)continue}return i.value}if(n)return null;i=new jM(e.doc,t,0,Math.max(0,r[r.length-1].from-1)),n=!0}}(e,r);return!!i&&(t(e.update({selection:e.selection.addRange(oy.range(i.from,i.to),!1),effects:NS.scrollIntoView(i.to)})),!0)},preventDefault:!0}];class ND{constructor(e){this.view=e;let t=this.query=e.state.field(AD).query.spec;function n(e,t,n){return Tx("button",{class:"cm-button",name:e,onclick:t,type:"button"},n)}this.commit=this.commit.bind(this),this.searchField=Tx("input",{value:t.search,placeholder:LD(e,"Find"),"aria-label":LD(e,"Find"),class:"cm-textfield",name:"search",form:"","main-field":"true",onchange:this.commit,onkeyup:this.commit}),this.replaceField=Tx("input",{value:t.replace,placeholder:LD(e,"Replace"),"aria-label":LD(e,"Replace"),class:"cm-textfield",name:"replace",form:"",onchange:this.commit,onkeyup:this.commit}),this.caseField=Tx("input",{type:"checkbox",name:"case",form:"",checked:t.caseSensitive,onchange:this.commit}),this.reField=Tx("input",{type:"checkbox",name:"re",form:"",checked:t.regexp,onchange:this.commit}),this.wordField=Tx("input",{type:"checkbox",name:"word",form:"",checked:t.wholeWord,onchange:this.commit}),this.dom=Tx("div",{onkeydown:e=>this.keydown(e),class:"cm-search"},[this.searchField,n("next",()=>kD(e),[LD(e,"next")]),n("prev",()=>SD(e),[LD(e,"previous")]),n("select",()=>OD(e),[LD(e,"all")]),Tx("label",null,[this.caseField,LD(e,"match case")]),Tx("label",null,[this.reField,LD(e,"regexp")]),Tx("label",null,[this.wordField,LD(e,"by word")]),...e.state.readOnly?[]:[Tx("br"),this.replaceField,n("replace",()=>BD(e),[LD(e,"replace")]),n("replaceAll",()=>_D(e),[LD(e,"replace all")])],Tx("button",{name:"close",onclick:()=>RD(e),"aria-label":LD(e,"close"),type:"button"},["×"])])}commit(){let e=new lD({search:this.searchField.value,caseSensitive:this.caseField.checked,regexp:this.reField.checked,wholeWord:this.wordField.checked,replace:this.replaceField.value});e.eq(this.query)||(this.query=e,this.view.dispatch({effects:mD.of(e)}))}keydown(e){!function(e,t,n){return YS(qS(e.state),t,e,n)}(this.view,e,"search-panel")?13==e.keyCode&&e.target==this.searchField?(e.preventDefault(),(e.shiftKey?SD:kD)(this.view)):13==e.keyCode&&e.target==this.replaceField&&(e.preventDefault(),BD(this.view)):e.preventDefault()}update(e){for(let t of e.transactions)for(let e of t.effects)e.is(mD)&&!e.value.eq(this.query)&&this.setQuery(e.value)}setQuery(e){this.query=e,this.searchField.value=e.search,this.replaceField.value=e.replace,this.caseField.checked=e.caseSensitive,this.reField.checked=e.regexp,this.wordField.checked=e.wholeWord}mount(){this.searchField.select()}get pos(){return 80}get top(){return this.view.state.facet(aD).top}}function LD(e,t){return e.state.phrase(t)}const QD=/[\s\.,:;?!]/;function FD(e,{from:t,to:n}){let r=e.state.doc.lineAt(t),i=e.state.doc.lineAt(n).to,o=Math.max(r.from,t-30),s=Math.min(i,n+30),a=e.state.sliceDoc(o,s);if(o!=r.from)for(let e=0;e<30;e++)if(!QD.test(a[e+1])&&QD.test(a[e])){a=a.slice(e);break}if(s!=i)for(let e=a.length-1;e>a.length-30;e--)if(!QD.test(a[e-1])&&QD.test(a[e])){a=a.slice(0,e);break}return NS.announce.of(`${e.state.phrase("current match")}. ${a} ${e.state.phrase("on line")} ${r.number}.`)}const VD=NS.baseTheme({".cm-panel.cm-search":{padding:"2px 6px 4px",position:"relative","& [name=close]":{position:"absolute",top:"0",right:"4px",backgroundColor:"inherit",border:"none",font:"inherit",padding:0,margin:0},"& input, & button, & label":{margin:".2em .6em .2em 0"},"& input[type=checkbox]":{marginRight:".2em"},"& label":{fontSize:"80%",whiteSpace:"pre"}},"&light .cm-searchMatch":{backgroundColor:"#ffff0054"},"&dark .cm-searchMatch":{backgroundColor:"#00ffff8a"},"&light .cm-searchMatch-selected":{backgroundColor:"#ff6a0054"},"&dark .cm-searchMatch-selected":{backgroundColor:"#ff00ff8a"}}),zD=[AD,xy.low(wD),VD];class WD{constructor(e,t,n,r){this.state=e,this.pos=t,this.explicit=n,this.view=r,this.abortListeners=[],this.abortOnDocChange=!1}tokenBefore(e){let t=W_(this.state).resolveInner(this.pos,-1);for(;t&&e.indexOf(t.name)<0;)t=t.parent;return t?{from:t.from,to:this.pos,text:this.state.sliceDoc(t.from,this.pos),type:t.type}:null}matchBefore(e){let t=this.state.doc.lineAt(this.pos),n=Math.max(t.from,this.pos-250),r=t.text.slice(n-t.from,this.pos-t.from),i=r.search(UD(e,!1));return i<0?null:{from:n+i,to:this.pos,text:r.slice(i)}}get aborted(){return null==this.abortListeners}addEventListener(e,t,n){"abort"==e&&this.abortListeners&&(this.abortListeners.push(t),n&&n.onDocChange&&(this.abortOnDocChange=!0))}}function $D(e){let t=Object.keys(e).join(""),n=/\w/.test(t);return n&&(t=t.replace(/\w/g,"")),`[${n?"\\w":""}${t.replace(/[^\w\s]/g,"\\$&")}]`}function HD(e){let t=e.map(e=>"string"==typeof e?{label:e}:e),[n,r]=t.every(e=>/^\w+$/.test(e.label))?[/\w*$/,/\w+$/]:function(e){let t=Object.create(null),n=Object.create(null);for(let{label:r}of e){t[r[0]]=!0;for(let e=1;e<r.length;e++)n[r[e]]=!0}let r=$D(t)+$D(n)+"*$";return[new RegExp("^"+r),new RegExp(r)]}(t);return e=>{let i=e.matchBefore(r);return i||e.explicit?{from:i?i.from:e.pos,options:t,validFor:n}:null}}class jD{constructor(e,t,n,r){this.completion=e,this.source=t,this.match=n,this.score=r}}function qD(e){return e.selection.main.from}function UD(e,t){var n;let{source:r}=e,i=t&&"^"!=r[0],o="$"!=r[r.length-1];return i||o?new RegExp(`${i?"^":""}(?:${r})${o?"$":""}`,null!==(n=e.flags)&&void 0!==n?n:e.ignoreCase?"i":""):e}const GD=Iy.define();function YD(e,t,n,r){let{main:i}=e.selection,o=n-i.from,s=r-i.from;return{...e.changeByRange(a=>{if(a!=i&&n!=r&&e.sliceDoc(a.from+o,a.from+s)!=e.sliceDoc(n,r))return{range:a};let l=e.toText(t);return{changes:{from:a.from+o,to:r==i.from?a.to:a.from+s,insert:l},range:oy.cursor(a.from+o+l.length)}}),scrollIntoView:!0,userEvent:"input.complete"}}const XD=new WeakMap;function JD(e){if(!Array.isArray(e))return e;let t=XD.get(e);return t||XD.set(e,t=HD(e)),t}const KD=Qy.define(),ZD=Qy.define();class eP{constructor(e){this.pattern=e,this.chars=[],this.folded=[],this.any=[],this.precise=[],this.byWord=[],this.score=0,this.matched=[];for(let t=0;t<e.length;){let n=jb(e,t),r=Ub(n);this.chars.push(n);let i=e.slice(t,t+r),o=i.toUpperCase();this.folded.push(jb(o==i?i.toLowerCase():o,0)),t+=r}this.astral=e.length!=this.chars.length}ret(e,t){return this.score=e,this.matched=t,this}match(e){if(0==this.pattern.length)return this.ret(-100,[]);if(e.length<this.pattern.length)return null;let{chars:t,folded:n,any:r,precise:i,byWord:o}=this;if(1==t.length){let r=jb(e,0),i=Ub(r),o=i==e.length?0:-100;if(r==t[0]);else{if(r!=n[0])return null;o+=-200}return this.ret(o,[0,i])}let s=e.indexOf(this.pattern);if(0==s)return this.ret(e.length==this.pattern.length?0:-100,[0,this.pattern.length]);let a=t.length,l=0;if(s<0){for(let i=0,o=Math.min(e.length,200);i<o&&l<a;){let o=jb(e,i);o!=t[l]&&o!=n[l]||(r[l++]=i),i+=Ub(o)}if(l<a)return null}let c=0,d=0,h=!1,u=0,p=-1,f=-1,g=/[a-z]/.test(e),m=!0;for(let r=0,l=Math.min(e.length,200),v=0;r<l&&d<a;){let l=jb(e,r);s<0&&(c<a&&l==t[c]&&(i[c++]=r),u<a&&(l==t[u]||l==n[u]?(0==u&&(p=r),f=r+1,u++):u=0));let A,b=l<255?l>=48&&l<=57||l>=97&&l<=122?2:l>=65&&l<=90?1:0:(A=qb(l))!=A.toLowerCase()?1:A!=A.toUpperCase()?2:0;(!r||1==b&&g||0==v&&0!=b)&&(t[d]==l||n[d]==l&&(h=!0)?o[d++]=r:o.length&&(m=!1)),v=b,r+=Ub(l)}return d==a&&0==o[0]&&m?this.result((h?-200:0)-100,o,e):u==a&&0==p?this.ret(-200-e.length+(f==e.length?0:-100),[0,f]):s>-1?this.ret(-700-e.length,[s,s+this.pattern.length]):u==a?this.ret(-900-e.length,[p,f]):d==a?this.result((h?-200:0)-100-700+(m?0:-1100),o,e):2==t.length?null:this.result((r[0]?-700:0)-200-1100,r,e)}result(e,t,n){let r=[],i=0;for(let e of t){let t=e+(this.astral?Ub(jb(n,e)):1);i&&r[i-1]==e?r[i-1]=t:(r[i++]=e,r[i++]=t)}return this.ret(e-n.length,r)}}class tP{constructor(e){this.pattern=e,this.matched=[],this.score=0,this.folded=e.toLowerCase()}match(e){if(e.length<this.pattern.length)return null;let t=e.slice(0,this.pattern.length),n=t==this.pattern?0:t.toLowerCase()==this.folded?-200:null;return null==n?null:(this.matched=[0,t.length],this.score=n+(e.length==this.pattern.length?0:-100),this)}}const nP=ly.define({combine:e=>Jy(e,{activateOnTyping:!0,activateOnCompletion:()=>!1,activateOnTypingDelay:100,selectOnOpen:!0,override:null,closeOnBlur:!0,maxRenderedOptions:100,defaultKeymap:!0,tooltipClass:()=>"",optionClass:()=>"",aboveCursor:!1,icons:!0,addToOptions:[],positionInfo:iP,filterStrict:!1,compareCompletions:(e,t)=>(e.sortText||e.label).localeCompare(t.sortText||t.label),interactionDelay:75,updateSyncTime:100},{defaultKeymap:(e,t)=>e&&t,closeOnBlur:(e,t)=>e&&t,icons:(e,t)=>e&&t,tooltipClass:(e,t)=>n=>rP(e(n),t(n)),optionClass:(e,t)=>n=>rP(e(n),t(n)),addToOptions:(e,t)=>e.concat(t),filterStrict:(e,t)=>e||t})});function rP(e,t){return e?t?e+" "+t:e:t}function iP(e,t,n,r,i,o){let s,a,l=e.textDirection==Sw.RTL,c=l,d=!1,h="top",u=t.left-i.left,p=i.right-t.right,f=r.right-r.left,g=r.bottom-r.top;if(c&&u<Math.min(f,p)?c=!1:!c&&p<Math.min(f,u)&&(c=!0),f<=(c?u:p))s=Math.max(i.top,Math.min(n.top,i.bottom-g))-t.top,a=Math.min(400,c?u:p);else{d=!0,a=Math.min(400,(l?t.right:i.right-t.left)-30);let e=i.bottom-t.bottom;e>=g||e>t.top?s=n.bottom-t.top:(h="bottom",s=t.bottom-n.top)}return{style:`${h}: ${s/((t.bottom-t.top)/o.offsetHeight)}px; max-width: ${a/((t.right-t.left)/o.offsetWidth)}px`,class:"cm-completionInfo-"+(d?l?"left-narrow":"right-narrow":c?"left":"right")}}function oP(e,t,n){if(e<=n)return{from:0,to:e};if(t<0&&(t=0),t<=e>>1){let e=Math.floor(t/n);return{from:e*n,to:(e+1)*n}}let r=Math.floor((e-t)/n);return{from:e-(r+1)*n,to:e-r*n}}class sP{constructor(e,t,n){this.view=e,this.stateField=t,this.applyCompletion=n,this.info=null,this.infoDestroy=null,this.placeInfoReq={read:()=>this.measureInfo(),write:e=>this.placeInfo(e),key:this},this.space=null,this.currentClass="";let r=e.state.field(t),{options:i,selected:o}=r.open,s=e.state.facet(nP);this.optionContent=function(e){let t=e.addToOptions.slice();return e.icons&&t.push({render(e){let t=document.createElement("div");return t.classList.add("cm-completionIcon"),e.type&&t.classList.add(...e.type.split(/\s+/g).map(e=>"cm-completionIcon-"+e)),t.setAttribute("aria-hidden","true"),t},position:20}),t.push({render(e,t,n,r){let i=document.createElement("span");i.className="cm-completionLabel";let o=e.displayLabel||e.label,s=0;for(let e=0;e<r.length;){let t=r[e++],n=r[e++];t>s&&i.appendChild(document.createTextNode(o.slice(s,t)));let a=i.appendChild(document.createElement("span"));a.appendChild(document.createTextNode(o.slice(t,n))),a.className="cm-completionMatchedText",s=n}return s<o.length&&i.appendChild(document.createTextNode(o.slice(s))),i},position:50},{render(e){if(!e.detail)return null;let t=document.createElement("span");return t.className="cm-completionDetail",t.textContent=e.detail,t},position:80}),t.sort((e,t)=>e.position-t.position).map(e=>e.render)}(s),this.optionClass=s.optionClass,this.tooltipClass=s.tooltipClass,this.range=oP(i.length,o,s.maxRenderedOptions),this.dom=document.createElement("div"),this.dom.className="cm-tooltip-autocomplete",this.updateTooltipClass(e.state),this.dom.addEventListener("mousedown",n=>{let{options:r}=e.state.field(t).open;for(let t,i=n.target;i&&i!=this.dom;i=i.parentNode)if("LI"==i.nodeName&&(t=/-(\d+)$/.exec(i.id))&&+t[1]<r.length)return this.applyCompletion(e,r[+t[1]]),void n.preventDefault()}),this.dom.addEventListener("focusout",t=>{let n=e.state.field(this.stateField,!1);n&&n.tooltip&&e.state.facet(nP).closeOnBlur&&t.relatedTarget!=e.contentDOM&&e.dispatch({effects:ZD.of(null)})}),this.showOptions(i,r.id)}mount(){this.updateSel()}showOptions(e,t){this.list&&this.list.remove(),this.list=this.dom.appendChild(this.createListBox(e,t,this.range)),this.list.addEventListener("scroll",()=>{this.info&&this.view.requestMeasure(this.placeInfoReq)})}update(e){var t;let n=e.state.field(this.stateField),r=e.startState.field(this.stateField);if(this.updateTooltipClass(e.state),n!=r){let{options:i,selected:o,disabled:s}=n.open;r.open&&r.open.options==i||(this.range=oP(i.length,o,e.state.facet(nP).maxRenderedOptions),this.showOptions(i,n.id)),this.updateSel(),s!=(null===(t=r.open)||void 0===t?void 0:t.disabled)&&this.dom.classList.toggle("cm-tooltip-autocomplete-disabled",!!s)}}updateTooltipClass(e){let t=this.tooltipClass(e);if(t!=this.currentClass){for(let e of this.currentClass.split(" "))e&&this.dom.classList.remove(e);for(let e of t.split(" "))e&&this.dom.classList.add(e);this.currentClass=t}}positioned(e){this.space=e,this.info&&this.view.requestMeasure(this.placeInfoReq)}updateSel(){let e=this.view.state.field(this.stateField),t=e.open;(t.selected>-1&&t.selected<this.range.from||t.selected>=this.range.to)&&(this.range=oP(t.options.length,t.selected,this.view.state.facet(nP).maxRenderedOptions),this.showOptions(t.options,e.id));let n=this.updateSelectedOption(t.selected);if(n){this.destroyInfo();let{completion:r}=t.options[t.selected],{info:i}=r;if(!i)return;let o="string"==typeof i?document.createTextNode(i):i(r);if(!o)return;"then"in o?o.then(t=>{t&&this.view.state.field(this.stateField,!1)==e&&this.addInfoPane(t,r)}).catch(e=>sC(this.view.state,e,"completion info")):(this.addInfoPane(o,r),n.setAttribute("aria-describedby",this.info.id))}}addInfoPane(e,t){this.destroyInfo();let n=this.info=document.createElement("div");if(n.className="cm-tooltip cm-completionInfo",n.id="cm-completionInfo-"+Math.floor(65535*Math.random()).toString(16),null!=e.nodeType)n.appendChild(e),this.infoDestroy=null;else{let{dom:t,destroy:r}=e;n.appendChild(t),this.infoDestroy=r||null}this.dom.appendChild(n),this.view.requestMeasure(this.placeInfoReq)}updateSelectedOption(e){let t=null;for(let n=this.list.firstChild,r=this.range.from;n;n=n.nextSibling,r++)"LI"==n.nodeName&&n.id?r==e?n.hasAttribute("aria-selected")||(n.setAttribute("aria-selected","true"),t=n):n.hasAttribute("aria-selected")&&(n.removeAttribute("aria-selected"),n.removeAttribute("aria-describedby")):r--;return t&&function(e,t){let n=e.getBoundingClientRect(),r=t.getBoundingClientRect(),i=n.height/e.offsetHeight;r.top<n.top?e.scrollTop-=(n.top-r.top)/i:r.bottom>n.bottom&&(e.scrollTop+=(r.bottom-n.bottom)/i)}(this.list,t),t}measureInfo(){let e=this.dom.querySelector("[aria-selected]");if(!e||!this.info)return null;let t=this.dom.getBoundingClientRect(),n=this.info.getBoundingClientRect(),r=e.getBoundingClientRect(),i=this.space;if(!i){let e=this.dom.ownerDocument.documentElement;i={left:0,top:0,right:e.clientWidth,bottom:e.clientHeight}}return r.top>Math.min(i.bottom,t.bottom)-10||r.bottom<Math.max(i.top,t.top)+10?null:this.view.state.facet(nP).positionInfo(this.view,t,r,n,i,this.dom)}placeInfo(e){this.info&&(e?(e.style&&(this.info.style.cssText=e.style),this.info.className="cm-tooltip cm-completionInfo "+(e.class||"")):this.info.style.cssText="top: -1e6px")}createListBox(e,t,n){const r=document.createElement("ul");r.id=t,r.setAttribute("role","listbox"),r.setAttribute("aria-expanded","true"),r.setAttribute("aria-label",this.view.state.phrase("Completions")),r.addEventListener("mousedown",e=>{e.target==r&&e.preventDefault()});let i=null;for(let o=n.from;o<n.to;o++){let{completion:s,match:a}=e[o],{section:l}=s;if(l){let e="string"==typeof l?l:l.name;if(e!=i&&(o>n.from||0==n.from))if(i=e,"string"!=typeof l&&l.header)r.appendChild(l.header(l));else{r.appendChild(document.createElement("completion-section")).textContent=e}}const c=r.appendChild(document.createElement("li"));c.id=t+"-"+o,c.setAttribute("role","option");let d=this.optionClass(s);d&&(c.className=d);for(let e of this.optionContent){let t=e(s,this.view.state,this.view,a);t&&c.appendChild(t)}}return n.from&&r.classList.add("cm-completionListIncompleteTop"),n.to<e.length&&r.classList.add("cm-completionListIncompleteBottom"),r}destroyInfo(){this.info&&(this.infoDestroy&&this.infoDestroy(),this.info.remove(),this.info=null)}destroy(){this.destroyInfo()}}function aP(e,t){return n=>new sP(n,e,t)}function lP(e){return 100*(e.boost||0)+(e.apply?10:0)+(e.info?5:0)+(e.type?1:0)}class cP{constructor(e,t,n,r,i,o){this.options=e,this.attrs=t,this.tooltip=n,this.timestamp=r,this.selected=i,this.disabled=o}setSelected(e,t){return e==this.selected||e>=this.options.length?this:new cP(this.options,pP(t,e),this.tooltip,this.timestamp,e,this.disabled)}static build(e,t,n,r,i,o){if(r&&!o&&e.some(e=>e.isPending))return r.setDisabled();let s=function(e,t){let n=[],r=null,i=null,o=e=>{n.push(e);let{section:t}=e.completion;if(t){r||(r=[]);let e="string"==typeof t?t:t.name;r.some(t=>t.name==e)||r.push("string"==typeof t?{name:e}:t)}},s=t.facet(nP);for(let r of e)if(r.hasResult()){let e=r.result.getMatch;if(!1===r.result.filter)for(let t of r.result.options)o(new jD(t,r.source,e?e(t):[],1e9-n.length));else{let n,a=t.sliceDoc(r.from,r.to),l=s.filterStrict?new tP(a):new eP(a);for(let t of r.result.options)if(n=l.match(t.label)){let s=t.displayLabel?e?e(t,n.matched):[]:n.matched,a=n.score+(t.boost||0);if(o(new jD(t,r.source,s,a)),"object"==typeof t.section&&"dynamic"===t.section.rank){let{name:e}=t.section;i||(i=Object.create(null)),i[e]=Math.max(a,i[e]||-1e9)}}}}if(r){let e=Object.create(null),t=0,o=(e,t)=>("dynamic"===e.rank&&"dynamic"===t.rank?i[t.name]-i[e.name]:0)||("number"==typeof e.rank?e.rank:1e9)-("number"==typeof t.rank?t.rank:1e9)||(e.name<t.name?-1:1);for(let n of r.sort(o))t-=1e5,e[n.name]=t;for(let t of n){let{section:n}=t.completion;n&&(t.score+=e["string"==typeof n?n:n.name])}}let a=[],l=null,c=s.compareCompletions;for(let e of n.sort((e,t)=>t.score-e.score||c(e.completion,t.completion))){let t=e.completion;!l||l.label!=t.label||l.detail!=t.detail||null!=l.type&&null!=t.type&&l.type!=t.type||l.apply!=t.apply||l.boost!=t.boost?a.push(e):lP(e.completion)>lP(l)&&(a[a.length-1]=e),l=e.completion}return a}(e,t);if(!s.length)return r&&e.some(e=>e.isPending)?r.setDisabled():null;let a=t.facet(nP).selectOnOpen?0:-1;if(r&&r.selected!=a&&-1!=r.selected){let e=r.options[r.selected].completion;for(let t=0;t<s.length;t++)if(s[t].completion==e){a=t;break}}return new cP(s,pP(n,a),{pos:e.reduce((e,t)=>t.hasResult()?Math.min(e,t.from):e,1e8),create:wP,above:i.aboveCursor},r?r.timestamp:Date.now(),a,!1)}map(e){return new cP(this.options,this.attrs,{...this.tooltip,pos:e.mapPos(this.tooltip.pos)},this.timestamp,this.selected,this.disabled)}setDisabled(){return new cP(this.options,this.attrs,this.tooltip,this.timestamp,this.selected,!0)}}class dP{constructor(e,t,n){this.active=e,this.id=t,this.open=n}static start(){return new dP(fP,"cm-ac-"+Math.floor(2e6*Math.random()).toString(36),null)}update(e){let{state:t}=e,n=t.facet(nP),r=(n.override||t.languageDataAt("autocomplete",qD(t)).map(JD)).map(t=>(this.active.find(e=>e.source==t)||new mP(t,this.active.some(e=>0!=e.state)?1:0)).update(e,n));r.length==this.active.length&&r.every((e,t)=>e==this.active[t])&&(r=this.active);let i=this.open,o=e.effects.some(e=>e.is(AP));i&&e.docChanged&&(i=i.map(e.changes)),e.selection||r.some(t=>t.hasResult()&&e.changes.touchesRange(t.from,t.to))||!function(e,t){if(e==t)return!0;for(let n=0,r=0;;){for(;n<e.length&&!e[n].hasResult();)n++;for(;r<t.length&&!t[r].hasResult();)r++;let i=n==e.length,o=r==t.length;if(i||o)return i==o;if(e[n++].result!=t[r++].result)return!1}}(r,this.active)||o?i=cP.build(r,t,this.id,i,n,o):i&&i.disabled&&!r.some(e=>e.isPending)&&(i=null),!i&&r.every(e=>!e.isPending)&&r.some(e=>e.hasResult())&&(r=r.map(e=>e.hasResult()?new mP(e.source,0):e));for(let t of e.effects)t.is(bP)&&(i=i&&i.setSelected(t.value,this.id));return r==this.active&&i==this.open?this:new dP(r,this.id,i)}get tooltip(){return this.open?this.open.tooltip:null}get attrs(){return this.open?this.open.attrs:this.active.length?hP:uP}}const hP={"aria-autocomplete":"list"},uP={};function pP(e,t){let n={"aria-autocomplete":"list","aria-haspopup":"listbox","aria-controls":e};return t>-1&&(n["aria-activedescendant"]=e+"-"+t),n}const fP=[];function gP(e,t){if(e.isUserEvent("input.complete")){let n=e.annotation(GD);if(n&&t.activateOnCompletion(n))return 12}let n=e.isUserEvent("input.type");return n&&t.activateOnTyping?5:n?1:e.isUserEvent("delete.backward")?2:e.selection?8:e.docChanged?16:0}class mP{constructor(e,t,n=!1){this.source=e,this.state=t,this.explicit=n}hasResult(){return!1}get isPending(){return 1==this.state}update(e,t){let n=gP(e,t),r=this;(8&n||16&n&&this.touches(e))&&(r=new mP(r.source,0)),4&n&&0==r.state&&(r=new mP(this.source,1)),r=r.updateFor(e,n);for(let t of e.effects)if(t.is(KD))r=new mP(r.source,1,t.value);else if(t.is(ZD))r=new mP(r.source,0);else if(t.is(AP))for(let e of t.value)e.source==r.source&&(r=e);return r}updateFor(e,t){return this.map(e.changes)}map(e){return this}touches(e){return e.changes.touchesRange(qD(e.state))}}class vP extends mP{constructor(e,t,n,r,i,o){super(e,3,t),this.limit=n,this.result=r,this.from=i,this.to=o}hasResult(){return!0}updateFor(e,t){var n;if(!(3&t))return this.map(e.changes);let r=this.result;r.map&&!e.changes.empty&&(r=r.map(r,e.changes));let i=e.changes.mapPos(this.from),o=e.changes.mapPos(this.to,1),s=qD(e.state);if(s>o||!r||2&t&&(qD(e.startState)==this.from||s<this.limit))return new mP(this.source,4&t?1:0);let a=e.changes.mapPos(this.limit);return function(e,t,n,r){if(!e)return!1;let i=t.sliceDoc(n,r);return"function"==typeof e?e(i,n,r,t):UD(e,!0).test(i)}(r.validFor,e.state,i,o)?new vP(this.source,this.explicit,a,r,i,o):r.update&&(r=r.update(r,i,o,new WD(e.state,s,!1)))?new vP(this.source,this.explicit,a,r,r.from,null!==(n=r.to)&&void 0!==n?n:qD(e.state)):new mP(this.source,1,this.explicit)}map(e){if(e.empty)return this;return(this.result.map?this.result.map(this.result,e):this.result)?new vP(this.source,this.explicit,e.mapPos(this.limit),this.result,e.mapPos(this.from),e.mapPos(this.to,1)):new mP(this.source,0)}touches(e){return e.changes.touchesRange(this.from,this.to)}}const AP=Qy.define({map:(e,t)=>e.map(e=>e.map(t))}),bP=Qy.define(),yP=gy.define({create:()=>dP.start(),update:(e,t)=>e.update(t),provide:e=>[WO.from(e,e=>e.tooltip),NS.contentAttributes.from(e,e=>e.attrs)]});function xP(e,t){const n=t.completion.apply||t.completion.label;let r=e.state.field(yP).active.find(e=>e.source==t.source);return r instanceof vP&&("string"==typeof n?e.dispatch({...YD(e.state,n,r.from,r.to),annotations:GD.of(t.completion)}):n(e,t.completion,r.from,r.to),!0)}const wP=aP(yP,xP);function CP(e,t="option"){return n=>{let r=n.state.field(yP,!1);if(!r||!r.open||r.open.disabled||Date.now()-r.open.timestamp<n.state.facet(nP).interactionDelay)return!1;let i,o=1;"page"==t&&(i=GO(n,r.open.tooltip))&&(o=Math.max(2,Math.floor(i.dom.offsetHeight/i.dom.querySelector("li").offsetHeight)-1));let{length:s}=r.open.options,a=r.open.selected>-1?r.open.selected+o*(e?1:-1):e?0:s-1;return a<0?a="page"==t?0:s-1:a>=s&&(a="page"==t?s-1:0),n.dispatch({effects:bP.of(a)}),!0}}const kP=e=>!!e.state.field(yP,!1)&&(e.dispatch({effects:KD.of(!0)}),!0);class SP{constructor(e,t){this.active=e,this.context=t,this.time=Date.now(),this.updates=[],this.done=void 0}}const OP=dC.fromClass(class{constructor(e){this.view=e,this.debounceUpdate=-1,this.running=[],this.debounceAccept=-1,this.pendingStart=!1,this.composing=0;for(let t of e.state.field(yP).active)t.isPending&&this.startQuery(t)}update(e){let t=e.state.field(yP),n=e.state.facet(nP);if(!e.selectionSet&&!e.docChanged&&e.startState.field(yP)==t)return;let r=e.transactions.some(e=>{let t=gP(e,n);return 8&t||(e.selection||e.docChanged)&&!(3&t)});for(let t=0;t<this.running.length;t++){let n=this.running[t];if(r||n.context.abortOnDocChange&&e.docChanged||n.updates.length+e.transactions.length>50&&Date.now()-n.time>1e3){for(let e of n.context.abortListeners)try{e()}catch(e){sC(this.view.state,e)}n.context.abortListeners=null,this.running.splice(t--,1)}else n.updates.push(...e.transactions)}this.debounceUpdate>-1&&clearTimeout(this.debounceUpdate),e.transactions.some(e=>e.effects.some(e=>e.is(KD)))&&(this.pendingStart=!0);let i=this.pendingStart?50:n.activateOnTypingDelay;if(this.debounceUpdate=t.active.some(e=>e.isPending&&!this.running.some(t=>t.active.source==e.source))?setTimeout(()=>this.startUpdate(),i):-1,0!=this.composing)for(let t of e.transactions)t.isUserEvent("input.type")?this.composing=2:2==this.composing&&t.selection&&(this.composing=3)}startUpdate(){this.debounceUpdate=-1,this.pendingStart=!1;let{state:e}=this.view,t=e.field(yP);for(let e of t.active)e.isPending&&!this.running.some(t=>t.active.source==e.source)&&this.startQuery(e);this.running.length&&t.open&&t.open.disabled&&(this.debounceAccept=setTimeout(()=>this.accept(),this.view.state.facet(nP).updateSyncTime))}startQuery(e){let{state:t}=this.view,n=qD(t),r=new WD(t,n,e.explicit,this.view),i=new SP(e,r);this.running.push(i),Promise.resolve(e.source(r)).then(e=>{i.context.aborted||(i.done=e||null,this.scheduleAccept())},e=>{this.view.dispatch({effects:ZD.of(null)}),sC(this.view.state,e)})}scheduleAccept(){this.running.every(e=>void 0!==e.done)?this.accept():this.debounceAccept<0&&(this.debounceAccept=setTimeout(()=>this.accept(),this.view.state.facet(nP).updateSyncTime))}accept(){var e;this.debounceAccept>-1&&clearTimeout(this.debounceAccept),this.debounceAccept=-1;let t=[],n=this.view.state.facet(nP),r=this.view.state.field(yP);for(let i=0;i<this.running.length;i++){let o=this.running[i];if(void 0===o.done)continue;if(this.running.splice(i--,1),o.done){let r=qD(o.updates.length?o.updates[0].startState:this.view.state),i=Math.min(r,o.done.from+(o.active.explicit?0:1)),s=new vP(o.active.source,o.active.explicit,i,o.done,o.done.from,null!==(e=o.done.to)&&void 0!==e?e:r);for(let e of o.updates)s=s.update(e,n);if(s.hasResult()){t.push(s);continue}}let s=r.active.find(e=>e.source==o.active.source);if(s&&s.isPending)if(null==o.done){let e=new mP(o.active.source,0);for(let t of o.updates)e=e.update(t,n);e.isPending||t.push(e)}else this.startQuery(s)}(t.length||r.open&&r.open.disabled)&&this.view.dispatch({effects:AP.of(t)})}},{eventHandlers:{blur(e){let t=this.view.state.field(yP,!1);if(t&&t.tooltip&&this.view.state.facet(nP).closeOnBlur){let n=t.open&&GO(this.view,t.open.tooltip);n&&n.dom.contains(e.relatedTarget)||setTimeout(()=>this.view.dispatch({effects:ZD.of(null)}),10)}},compositionstart(){this.composing=1},compositionend(){3==this.composing&&setTimeout(()=>this.view.dispatch({effects:KD.of(!1)}),20),this.composing=0}}}),BP="object"==typeof navigator&&/Win/.test(navigator.platform),_P=xy.highest(NS.domEventHandlers({keydown(e,t){let n=t.state.field(yP,!1);if(!n||!n.open||n.open.disabled||n.open.selected<0||e.key.length>1||e.ctrlKey&&(!BP||!e.altKey)||e.metaKey)return!1;let r=n.open.options[n.open.selected],i=n.active.find(e=>e.source==r.source),o=r.completion.commitCharacters||i.result.commitCharacters;return o&&o.indexOf(e.key)>-1&&xP(t,r),!1}})),TP=NS.baseTheme({".cm-tooltip.cm-tooltip-autocomplete":{"& > ul":{fontFamily:"monospace",whiteSpace:"nowrap",overflow:"hidden auto",maxWidth_fallback:"700px",maxWidth:"min(700px, 95vw)",minWidth:"250px",maxHeight:"10em",height:"100%",listStyle:"none",margin:0,padding:0,"& > li, & > completion-section":{padding:"1px 3px",lineHeight:1.2},"& > li":{overflowX:"hidden",textOverflow:"ellipsis",cursor:"pointer"},"& > completion-section":{display:"list-item",borderBottom:"1px solid silver",paddingLeft:"0.5em",opacity:.7}}},"&light .cm-tooltip-autocomplete ul li[aria-selected]":{background:"#17c",color:"white"},"&light .cm-tooltip-autocomplete-disabled ul li[aria-selected]":{background:"#777"},"&dark .cm-tooltip-autocomplete ul li[aria-selected]":{background:"#347",color:"white"},"&dark .cm-tooltip-autocomplete-disabled ul li[aria-selected]":{background:"#444"},".cm-completionListIncompleteTop:before, .cm-completionListIncompleteBottom:after":{content:'"···"',opacity:.5,display:"block",textAlign:"center"},".cm-tooltip.cm-completionInfo":{position:"absolute",padding:"3px 9px",width:"max-content",maxWidth:"400px",boxSizing:"border-box",whiteSpace:"pre-line"},".cm-completionInfo.cm-completionInfo-left":{right:"100%"},".cm-completionInfo.cm-completionInfo-right":{left:"100%"},".cm-completionInfo.cm-completionInfo-left-narrow":{right:"30px"},".cm-completionInfo.cm-completionInfo-right-narrow":{left:"30px"},"&light .cm-snippetField":{backgroundColor:"#00000022"},"&dark .cm-snippetField":{backgroundColor:"#ffffff22"},".cm-snippetFieldPosition":{verticalAlign:"text-top",width:0,height:"1.15em",display:"inline-block",margin:"0 -0.7px -.7em",borderLeft:"1.4px dotted #888"},".cm-completionMatchedText":{textDecoration:"underline"},".cm-completionDetail":{marginLeft:"0.5em",fontStyle:"italic"},".cm-completionIcon":{fontSize:"90%",width:".8em",display:"inline-block",textAlign:"center",paddingRight:".6em",opacity:"0.6",boxSizing:"content-box"},".cm-completionIcon-function, .cm-completionIcon-method":{"&:after":{content:"'ƒ'"}},".cm-completionIcon-class":{"&:after":{content:"'○'"}},".cm-completionIcon-interface":{"&:after":{content:"'◌'"}},".cm-completionIcon-variable":{"&:after":{content:"'𝑥'"}},".cm-completionIcon-constant":{"&:after":{content:"'𝐶'"}},".cm-completionIcon-type":{"&:after":{content:"'𝑡'"}},".cm-completionIcon-enum":{"&:after":{content:"'∪'"}},".cm-completionIcon-property":{"&:after":{content:"'□'"}},".cm-completionIcon-keyword":{"&:after":{content:"'🔑︎'"}},".cm-completionIcon-namespace":{"&:after":{content:"'▢'"}},".cm-completionIcon-text":{"&:after":{content:"'abc'",fontSize:"50%",verticalAlign:"middle"}}});const EP={brackets:["(","[","{","'",'"'],before:")]}:;>",stringPrefixes:[]},MP=Qy.define({map(e,t){let n=t.mapPos(e,-1,Yb.TrackAfter);return null==n?void 0:n}}),DP=new class extends Ky{};DP.startSide=1,DP.endSide=-1;const PP=gy.define({create:()=>rx.empty,update(e,t){if(e=e.map(t.changes),t.selection){let n=t.state.doc.lineAt(t.selection.main.head);e=e.update({filter:e=>e>=n.from&&e<=n.to})}for(let n of t.effects)n.is(MP)&&(e=e.update({add:[DP.range(n.value,n.value+1)]}));return e}});const RP="()[]{}<>«»»«［］｛｝";function IP(e){for(let t=0;t<16;t+=2)if(RP.charCodeAt(t)==e)return RP.charAt(t+1);return qb(e<128?e:e+1)}function NP(e,t){return e.languageDataAt("closeBrackets",t)[0]||EP}const LP="object"==typeof navigator&&/Android\b/.test(navigator.userAgent),QP=NS.inputHandler.of((e,t,n,r)=>{if((LP?e.composing:e.compositionStarted)||e.state.readOnly)return!1;let i=e.state.selection.main;if(r.length>2||2==r.length&&1==Ub(jb(r,0))||t!=i.from||n!=i.to)return!1;let o=function(e,t){let n=NP(e,e.selection.main.head),r=n.brackets||EP.brackets;for(let i of r){let o=IP(jb(i,0));if(t==i)return o==i?HP(e,i,r.indexOf(i+i+i)>-1,n):WP(e,i,o,n.before||EP.before);if(t==o&&VP(e,e.selection.main.from))return $P(e,i,o)}return null}(e.state,r);return!!o&&(e.dispatch(o),!0)}),FP=[{key:"Backspace",run:({state:e,dispatch:t})=>{if(e.readOnly)return!1;let n=NP(e,e.selection.main.head).brackets||EP.brackets,r=null,i=e.changeByRange(t=>{if(t.empty){let r=function(e,t){let n=e.sliceString(t-2,t);return Ub(jb(n,0))==n.length?n:n.slice(1)}(e.doc,t.head);for(let i of n)if(i==r&&zP(e.doc,t.head)==IP(jb(i,0)))return{changes:{from:t.head-i.length,to:t.head+i.length},range:oy.cursor(t.head-i.length)}}return{range:r=t}});return r||t(e.update(i,{scrollIntoView:!0,userEvent:"delete.backward"})),!r}}];function VP(e,t){let n=!1;return e.field(PP).between(0,e.doc.length,e=>{e==t&&(n=!0)}),n}function zP(e,t){let n=e.sliceString(t,t+2);return n.slice(0,Ub(jb(n,0)))}function WP(e,t,n,r){let i=null,o=e.changeByRange(o=>{if(!o.empty)return{changes:[{insert:t,from:o.from},{insert:n,from:o.to}],effects:MP.of(o.to+t.length),range:oy.range(o.anchor+t.length,o.head+t.length)};let s=zP(e.doc,o.head);return!s||/\s/.test(s)||r.indexOf(s)>-1?{changes:{insert:t+n,from:o.head},effects:MP.of(o.head+t.length),range:oy.cursor(o.head+t.length)}:{range:i=o}});return i?null:e.update(o,{scrollIntoView:!0,userEvent:"input.type"})}function $P(e,t,n){let r=null,i=e.changeByRange(t=>t.empty&&zP(e.doc,t.head)==n?{changes:{from:t.head,to:t.head+n.length,insert:n},range:oy.cursor(t.head+n.length)}:r={range:t});return r?null:e.update(i,{scrollIntoView:!0,userEvent:"input.type"})}function HP(e,t,n,r){let i=r.stringPrefixes||EP.stringPrefixes,o=null,s=e.changeByRange(r=>{if(!r.empty)return{changes:[{insert:t,from:r.from},{insert:t,from:r.to}],effects:MP.of(r.to+t.length),range:oy.range(r.anchor+t.length,r.head+t.length)};let s,a=r.head,l=zP(e.doc,a);if(l==t){if(jP(e,a))return{changes:{insert:t+t,from:a},effects:MP.of(a+t.length),range:oy.cursor(a+t.length)};if(VP(e,a)){let r=n&&e.sliceDoc(a,a+3*t.length)==t+t+t?t+t+t:t;return{changes:{from:a,to:a+r.length,insert:r},range:oy.cursor(a+r.length)}}}else{if(n&&e.sliceDoc(a-2*t.length,a)==t+t&&(s=qP(e,a-2*t.length,i))>-1&&jP(e,s))return{changes:{insert:t+t+t+t,from:a},effects:MP.of(a+t.length),range:oy.cursor(a+t.length)};if(e.charCategorizer(a)(l)!=qy.Word&&qP(e,a,i)>-1&&!function(e,t,n,r){let i=W_(e).resolveInner(t,-1),o=r.reduce((e,t)=>Math.max(e,t.length),0);for(let s=0;s<5;s++){let s=e.sliceDoc(i.from,Math.min(i.to,i.from+n.length+o)),a=s.indexOf(n);if(!a||a>-1&&r.indexOf(s.slice(0,a))>-1){let t=i.firstChild;for(;t&&t.from==i.from&&t.to-t.from>n.length+a;){if(e.sliceDoc(t.to-n.length,t.to)==n)return!1;t=t.firstChild}return!0}let l=i.to==t&&i.parent;if(!l)break;i=l}return!1}(e,a,t,i))return{changes:{insert:t+t,from:a},effects:MP.of(a+t.length),range:oy.cursor(a+t.length)}}return{range:o=r}});return o?null:e.update(s,{scrollIntoView:!0,userEvent:"input.type"})}function jP(e,t){let n=W_(e).resolveInner(t+1);return n.parent&&n.from==t}function qP(e,t,n){let r=e.charCategorizer(t);if(r(e.sliceDoc(t-1,t))!=qy.Word)return t;for(let i of n){let n=t-i.length;if(e.sliceDoc(n,t)==i&&r(e.sliceDoc(n-1,n))!=qy.Word)return n}return-1}function UP(e={}){return[_P,yP,nP.of(e),OP,YP,TP]}const GP=[{key:"Ctrl-Space",run:kP},{mac:"Alt-`",run:kP},{mac:"Alt-i",run:kP},{key:"Escape",run:e=>{let t=e.state.field(yP,!1);return!(!t||!t.active.some(e=>0!=e.state))&&(e.dispatch({effects:ZD.of(null)}),!0)}},{key:"ArrowDown",run:CP(!0)},{key:"ArrowUp",run:CP(!1)},{key:"PageDown",run:CP(!0,"page")},{key:"PageUp",run:CP(!1,"page")},{key:"Enter",run:e=>{let t=e.state.field(yP,!1);return!(e.state.readOnly||!t||!t.open||t.open.selected<0||t.open.disabled||Date.now()-t.open.timestamp<e.state.facet(nP).interactionDelay)&&xP(e,t.open.options[t.open.selected])}}],YP=xy.highest(HS.computeN([nP],e=>e.facet(nP).defaultKeymap?[GP]:[]));class XP{constructor(e,t,n){this.from=e,this.to=t,this.diagnostic=n}}class JP{constructor(e,t,n){this.diagnostics=e,this.panel=t,this.selected=n}static init(e,t,n){let r=n.facet(dR).markerFilter;r&&(e=r(e,n));let i=e.slice().sort((e,t)=>e.from-t.from||e.to-t.to),o=new ix,s=[],a=0,l=n.doc.iter(),c=0,d=n.doc.length;for(let e=0;;){let t,n,r=e==i.length?null:i[e];if(!r&&!s.length)break;if(s.length)t=a,n=s.reduce((e,t)=>Math.min(e,t.to),r&&r.from>t?r.from:1e8);else{if(t=r.from,t>d)break;n=r.to,s.push(r),e++}for(;e<i.length;){let r=i[e];if(r.from!=t||!(r.to>r.from||r.to==t)){n=Math.min(r.from,n);break}s.push(r),e++,n=Math.min(r.to,n)}n=Math.min(n,d);let h=!1;if(s.some(e=>e.from==t&&(e.to==n||n==d))&&(h=t==n,!h&&n-t<10)){let e=t-(c+l.value.length);e>0&&(l.next(e),c=t);for(let e=t;;){if(e>=n){h=!0;break}if(!l.lineBreak&&c+l.value.length>e)break;e=c+l.value.length,c+=l.value.length,l.next()}}let u=xR(s);if(h)o.add(t,t,Xx.widget({widget:new fR(u),diagnostics:s.slice()}));else{let e=s.reduce((e,t)=>t.markClass?e+" "+t.markClass:e,"");o.add(t,n,Xx.mark({class:"cm-lintRange cm-lintRange-"+u+e,diagnostics:s.slice(),inclusiveEnd:s.some(e=>e.to>n)}))}if(a=n,a==d)break;for(let e=0;e<s.length;e++)s[e].to<=a&&s.splice(e--,1)}let h=o.finish();return new JP(h,t,KP(h))}}function KP(e,t=null,n=0){let r=null;return e.between(n,1e9,(e,n,{spec:i})=>{if(!(t&&i.diagnostics.indexOf(t)<0))if(r){if(i.diagnostics.indexOf(r.diagnostic)<0)return!1;r=new XP(r.from,n,r.diagnostic)}else r=new XP(e,n,t||i.diagnostics[0])}),r}function ZP(e,t){let n=t.pos,r=t.end||n,i=e.state.facet(dR).hideOn(e,n,r);if(null!=i)return i;let o=e.startState.doc.lineAt(t.pos);return!(!e.effects.some(e=>e.is(tR))&&!e.changes.touchesRange(o.from,Math.max(o.to,r)))}function eR(e,t){return e.field(iR,!1)?t:t.concat(Qy.appendConfig.of(wR))}const tR=Qy.define(),nR=Qy.define(),rR=Qy.define(),iR=gy.define({create:()=>new JP(Xx.none,null,null),update(e,t){if(t.docChanged&&e.diagnostics.size){let n=e.diagnostics.map(t.changes),r=null,i=e.panel;if(e.selected){let i=t.changes.mapPos(e.selected.from,1);r=KP(n,e.selected.diagnostic,i)||KP(n,null,i)}!n.size&&i&&t.state.facet(dR).autoPanel&&(i=null),e=new JP(n,i,r)}for(let n of t.effects)if(n.is(tR)){let r=t.state.facet(dR).autoPanel?n.value.length?mR.open:null:e.panel;e=JP.init(n.value,r,t.state)}else n.is(nR)?e=new JP(e.diagnostics,n.value?mR.open:null,e.selected):n.is(rR)&&(e=new JP(e.diagnostics,e.panel,n.value));return e},provide:e=>[tB.from(e,e=>e.panel),NS.decorations.from(e,e=>e.diagnostics)]});const oR=Xx.mark({class:"cm-lintRange cm-lintRange-active"});function sR(e,t,n){let r,{diagnostics:i}=e.state.field(iR),o=-1,s=-1;i.between(t-(n<0?1:0),t+(n>0?1:0),(e,i,{spec:a})=>{if(t>=e&&t<=i&&(e==i||(t>e||n>0)&&(t<i||n<0)))return r=a.diagnostics,o=e,s=i,!1});let a=e.state.facet(dR).tooltipFilter;return r&&a&&(r=a(r,e.state)),r?{pos:o,end:s,above:e.state.doc.lineAt(o).to<s,create:()=>({dom:aR(e,r)})}:null}function aR(e,t){return Tx("ul",{class:"cm-tooltip-lint"},t.map(t=>pR(e,t,!1)))}const lR=e=>{let t=e.state.field(iR,!1);return!(!t||!t.panel)&&(e.dispatch({effects:nR.of(!1)}),!0)},cR=[{key:"Mod-Shift-m",run:e=>{let t=e.state.field(iR,!1);t&&t.panel||e.dispatch({effects:eR(e.state,[nR.of(!0)])});let n=JO(e,mR.open);return n&&n.dom.querySelector(".cm-panel-lint ul").focus(),!0},preventDefault:!0},{key:"F8",run:e=>{let t=e.state.field(iR,!1);if(!t)return!1;let n=e.state.selection.main,r=t.diagnostics.iter(n.to+1);return!(!r.value&&(r=t.diagnostics.iter(0),!r.value||r.from==n.from&&r.to==n.to))&&(e.dispatch({selection:{anchor:r.from,head:r.to},scrollIntoView:!0}),!0)}}];const dR=ly.define({combine:e=>({sources:e.map(e=>e.source).filter(e=>null!=e),...Jy(e.map(e=>e.config),{delay:750,markerFilter:null,tooltipFilter:null,needsRefresh:null,hideOn:()=>null},{delay:Math.max,markerFilter:hR,tooltipFilter:hR,needsRefresh:(e,t)=>e?t?n=>e(n)||t(n):e:t,hideOn:(e,t)=>e?t?(n,r,i)=>e(n,r,i)||t(n,r,i):e:t,autoPanel:(e,t)=>e||t})})});function hR(e,t){return e?t?(n,r)=>t(e(n,r),r):e:t}function uR(e){let t=[];if(e)e:for(let{name:n}of e){for(let e=0;e<n.length;e++){let r=n[e];if(/[a-zA-Z]/.test(r)&&!t.some(e=>e.toLowerCase()==r.toLowerCase())){t.push(r);continue e}}t.push("")}return t}function pR(e,t,n){var r;let i=n?uR(t.actions):[];return Tx("li",{class:"cm-diagnostic cm-diagnostic-"+t.severity},Tx("span",{class:"cm-diagnosticText"},t.renderMessage?t.renderMessage(e):t.message),null===(r=t.actions)||void 0===r?void 0:r.map((n,r)=>{let o=!1,s=r=>{if(r.preventDefault(),o)return;o=!0;let i=KP(e.state.field(iR).diagnostics,t);i&&n.apply(e,i.from,i.to)},{name:a}=n,l=i[r]?a.indexOf(i[r]):-1,c=l<0?a:[a.slice(0,l),Tx("u",a.slice(l,l+1)),a.slice(l+1)];return Tx("button",{type:"button",class:"cm-diagnosticAction"+(n.markClass?" "+n.markClass:""),onclick:s,onmousedown:s,"aria-label":` Action: ${a}${l<0?"":` (access key "${i[r]})"`}.`},c)}),t.source&&Tx("div",{class:"cm-diagnosticSource"},t.source))}class fR extends Gx{constructor(e){super(),this.sev=e}eq(e){return e.sev==this.sev}toDOM(){return Tx("span",{class:"cm-lintPoint cm-lintPoint-"+this.sev})}}class gR{constructor(e,t){this.diagnostic=t,this.id="item_"+Math.floor(4294967295*Math.random()).toString(16),this.dom=pR(e,t,!0),this.dom.id=this.id,this.dom.setAttribute("role","option")}}class mR{constructor(e){this.view=e,this.items=[];this.list=Tx("ul",{tabIndex:0,role:"listbox","aria-label":this.view.state.phrase("Diagnostics"),onkeydown:t=>{if(!(t.ctrlKey||t.altKey||t.metaKey)){if(27==t.keyCode)lR(this.view),this.view.focus();else if(38==t.keyCode||33==t.keyCode)this.moveSelection((this.selectedIndex-1+this.items.length)%this.items.length);else if(40==t.keyCode||34==t.keyCode)this.moveSelection((this.selectedIndex+1)%this.items.length);else if(36==t.keyCode)this.moveSelection(0);else if(35==t.keyCode)this.moveSelection(this.items.length-1);else if(13==t.keyCode)this.view.focus();else{if(!(t.keyCode>=65&&t.keyCode<=90&&this.selectedIndex>=0))return;{let{diagnostic:n}=this.items[this.selectedIndex],r=uR(n.actions);for(let i=0;i<r.length;i++)if(r[i].toUpperCase().charCodeAt(0)==t.keyCode){let t=KP(this.view.state.field(iR).diagnostics,n);t&&n.actions[i].apply(e,t.from,t.to)}}}t.preventDefault()}},onclick:e=>{for(let t=0;t<this.items.length;t++)this.items[t].dom.contains(e.target)&&this.moveSelection(t)}}),this.dom=Tx("div",{class:"cm-panel-lint"},this.list,Tx("button",{type:"button",name:"close","aria-label":this.view.state.phrase("close"),onclick:()=>lR(this.view)},"×")),this.update()}get selectedIndex(){let e=this.view.state.field(iR).selected;if(!e)return-1;for(let t=0;t<this.items.length;t++)if(this.items[t].diagnostic==e.diagnostic)return t;return-1}update(){let{diagnostics:e,selected:t}=this.view.state.field(iR),n=0,r=!1,i=null,o=new Set;for(e.between(0,this.view.state.doc.length,(e,s,{spec:a})=>{for(let e of a.diagnostics){if(o.has(e))continue;o.add(e);let s,a=-1;for(let t=n;t<this.items.length;t++)if(this.items[t].diagnostic==e){a=t;break}a<0?(s=new gR(this.view,e),this.items.splice(n,0,s),r=!0):(s=this.items[a],a>n&&(this.items.splice(n,a-n),r=!0)),t&&s.diagnostic==t.diagnostic?s.dom.hasAttribute("aria-selected")||(s.dom.setAttribute("aria-selected","true"),i=s):s.dom.hasAttribute("aria-selected")&&s.dom.removeAttribute("aria-selected"),n++}});n<this.items.length&&!(1==this.items.length&&this.items[0].diagnostic.from<0);)r=!0,this.items.pop();0==this.items.length&&(this.items.push(new gR(this.view,{from:-1,to:-1,severity:"info",message:this.view.state.phrase("No diagnostics")})),r=!0),i?(this.list.setAttribute("aria-activedescendant",i.id),this.view.requestMeasure({key:this,read:()=>({sel:i.dom.getBoundingClientRect(),panel:this.list.getBoundingClientRect()}),write:({sel:e,panel:t})=>{let n=t.height/this.list.offsetHeight;e.top<t.top?this.list.scrollTop-=(t.top-e.top)/n:e.bottom>t.bottom&&(this.list.scrollTop+=(e.bottom-t.bottom)/n)}})):this.selectedIndex<0&&this.list.removeAttribute("aria-activedescendant"),r&&this.sync()}sync(){let e=this.list.firstChild;function t(){let t=e;e=t.nextSibling,t.remove()}for(let n of this.items)if(n.dom.parentNode==this.list){for(;e!=n.dom;)t();e=n.dom.nextSibling}else this.list.insertBefore(n.dom,e);for(;e;)t()}moveSelection(e){if(this.selectedIndex<0)return;let t=KP(this.view.state.field(iR).diagnostics,this.items[e].diagnostic);t&&this.view.dispatch({selection:{anchor:t.from,head:t.to},scrollIntoView:!0,effects:rR.of(t)})}static open(e){return new mR(e)}}function vR(e,t='viewBox="0 0 40 40"'){return`url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" ${t}>${encodeURIComponent(e)}</svg>')`}function AR(e){return vR(`<path d="m0 2.5 l2 -1.5 l1 0 l2 1.5 l1 0" stroke="${e}" fill="none" stroke-width=".7"/>`,'width="6" height="3"')}const bR=NS.baseTheme({".cm-diagnostic":{padding:"3px 6px 3px 8px",marginLeft:"-1px",display:"block",whiteSpace:"pre-wrap"},".cm-diagnostic-error":{borderLeft:"5px solid #d11"},".cm-diagnostic-warning":{borderLeft:"5px solid orange"},".cm-diagnostic-info":{borderLeft:"5px solid #999"},".cm-diagnostic-hint":{borderLeft:"5px solid #66d"},".cm-diagnosticAction":{font:"inherit",border:"none",padding:"2px 4px",backgroundColor:"#444",color:"white",borderRadius:"3px",marginLeft:"8px",cursor:"pointer"},".cm-diagnosticSource":{fontSize:"70%",opacity:.7},".cm-lintRange":{backgroundPosition:"left bottom",backgroundRepeat:"repeat-x",paddingBottom:"0.7px"},".cm-lintRange-error":{backgroundImage:AR("#d11")},".cm-lintRange-warning":{backgroundImage:AR("orange")},".cm-lintRange-info":{backgroundImage:AR("#999")},".cm-lintRange-hint":{backgroundImage:AR("#66d")},".cm-lintRange-active":{backgroundColor:"#ffdd9980"},".cm-tooltip-lint":{padding:0,margin:0},".cm-lintPoint":{position:"relative","&:after":{content:'""',position:"absolute",bottom:0,left:"-2px",borderLeft:"3px solid transparent",borderRight:"3px solid transparent",borderBottom:"4px solid #d11"}},".cm-lintPoint-warning":{"&:after":{borderBottomColor:"orange"}},".cm-lintPoint-info":{"&:after":{borderBottomColor:"#999"}},".cm-lintPoint-hint":{"&:after":{borderBottomColor:"#66d"}},".cm-panel.cm-panel-lint":{position:"relative","& ul":{maxHeight:"100px",overflowY:"auto","& [aria-selected]":{backgroundColor:"#ddd","& u":{textDecoration:"underline"}},"&:focus [aria-selected]":{background_fallback:"#bdf",backgroundColor:"Highlight",color_fallback:"white",color:"HighlightText"},"& u":{textDecoration:"none"},padding:0,margin:0},"& [name=close]":{position:"absolute",top:"0",right:"2px",background:"inherit",border:"none",font:"inherit",padding:0,margin:0}}});function yR(e){return"error"==e?4:"warning"==e?3:"info"==e?2:1}function xR(e){let t="hint",n=1;for(let r of e){let e=yR(r.severity);e>n&&(n=e,t=r.severity)}return t}const wR=[iR,NS.decorations.compute([iR],e=>{let{selected:t,panel:n}=e.field(iR);return t&&n&&t.from!=t.to?Xx.set([oR.range(t.from,t.to)]):Xx.none}),UO(sR,{hideOn:ZP}),bR];const CR=(()=>[OB(),TB,bO(),SE(),NT(),rO(),[dO,hO],Xy.allowMultipleSelections.of(!0),Xy.transactionFilter.of(e=>{if(!e.docChanged||!e.isUserEvent("input.type")&&!e.isUserEvent("input.complete"))return e;let t=e.startState.languageDataAt("indentOnInput",e.startState.selection.main.head);if(!t.length)return e;let n=e.newDoc,{head:r}=e.newSelection.main,i=n.lineAt(r);if(r>i.from+200)return e;let o=n.sliceString(i.from,r);if(!t.some(e=>e.test(o)))return e;let{state:s}=e,a=-1,l=[];for(let{head:e}of s.selection.ranges){let t=s.doc.lineAt(e);if(t.from==a)continue;a=t.from;let n=rT(s,t.from);if(null==n)continue;let r=/^\s*/.exec(t.text)[0],i=nT(s,n);r!=i&&l.push({from:t.from,to:t.from+r.length,insert:i})}return l.length?[e,{changes:l,sequential:!0}]:e}),WT(jT,{fallback:!0}),eE(),[QP,PP],UP(),TO(),DO(),kO,tD(),HS.of([...FP,...WM,...ID,...zE,...BT,...GP,...cR])])();var kR,SR,OR=Object.freeze({autofocus:!1,disabled:!1,indentWithTab:!0,tabSize:2,placeholder:"",autoDestroy:!0,extensions:[CR]}),BR=Symbol("vue-codemirror-global-config"),_R=function(e){var t=new Cy;return{compartment:t,run:function(n){t.get(e.state)?e.dispatch({effects:t.reconfigure(n)}):e.dispatch({effects:Qy.appendConfig.of(t.of(n))})}}},TR=function(e,t){var n=_R(e),r=n.compartment,i=n.run;return function(n){var o=r.get(e.state);i((null!=n?n:o!==t)?t:[])}},ER={type:Boolean,default:void 0},MR={autofocus:ER,disabled:ER,indentWithTab:ER,tabSize:Number,placeholder:String,style:Object,autoDestroy:ER,phrases:Object,root:Object,extensions:Array,selection:Object},DR={modelValue:{type:String,default:""}},PR=Object.assign(Object.assign({},MR),DR);(SR=kR||(kR={})).Change="change",SR.Update="update",SR.Focus="focus",SR.Blur="blur",SR.Ready="ready",SR.ModelUpdate="update:modelValue";var RR={};RR[kR.Change]=function(e,t){return!0},RR[kR.Update]=function(e){return!0},RR[kR.Focus]=function(e){return!0},RR[kR.Blur]=function(e){return!0},RR[kR.Ready]=function(e){return!0};var IR={};IR[kR.ModelUpdate]=RR[kR.Change];var NR=Object.assign(Object.assign({},RR),IR),LR=$r({name:"VueCodemirror",props:Object.assign({},PR),emits:Object.assign({},NR),setup:function(e,t){var n=Yt(),r=Yt(),i=Yt(),o=Object.assign(Object.assign({},OR),or(BR,{})),s=_a(function(){var t={};return Object.keys($t(e)).forEach(function(n){var r;"modelValue"!==n&&(t[n]=null!==(r=e[n])&&void 0!==r?r:o[n])}),t});return Ei(function(){var a;r.value=function(e){var t=e.onUpdate,n=e.onChange,r=e.onFocus,i=e.onBlur,o=function(e,t){var n={};for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&t.indexOf(r)<0&&(n[r]=e[r]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var i=0;for(r=Object.getOwnPropertySymbols(e);i<r.length;i++)t.indexOf(r[i])<0&&Object.prototype.propertyIsEnumerable.call(e,r[i])&&(n[r[i]]=e[r[i]])}return n}(e,["onUpdate","onChange","onFocus","onBlur"]);return Xy.create({doc:o.doc,selection:o.selection,extensions:(Array.isArray(o.extensions)?o.extensions:[o.extensions]).concat([NS.updateListener.of(function(e){t(e),e.docChanged&&n(e.state.doc.toString(),e),e.focusChanged&&(e.view.hasFocus?r(e):i(e))})])})}({doc:e.modelValue,selection:s.value.selection,extensions:null!==(a=o.extensions)&&void 0!==a?a:[],onFocus:function(e){return t.emit(kR.Focus,e)},onBlur:function(e){return t.emit(kR.Blur,e)},onUpdate:function(e){return t.emit(kR.Update,e)},onChange:function(n,r){n!==e.modelValue&&(t.emit(kR.Change,n,r),t.emit(kR.ModelUpdate,n,r))}}),i.value=function(e){return new NS(Object.assign({},e))}({state:r.value,parent:n.value,root:s.value.root});var l=function(e){var t=function(){return e.state.doc.toString()},n=_R(e).run,r=TR(e,[NS.editable.of(!1),Xy.readOnly.of(!0)]),i=TR(e,HS.of([$M])),o=_R(e).run,s=_R(e).run,a=_R(e).run,l=_R(e).run;return{focus:function(){return e.focus()},getDoc:t,setDoc:function(n){n!==t()&&e.dispatch({changes:{from:0,to:e.state.doc.length,insert:n}})},reExtensions:n,toggleDisabled:r,toggleIndentWithTab:i,setTabSize:function(e){o([Xy.tabSize.of(e),eT.of(" ".repeat(e))])},setPhrases:function(e){s([Xy.phrases.of(e)])},setPlaceholder:function(e){a(function(e){let t=dC.fromClass(class{constructor(t){this.view=t,this.placeholder=e?Xx.set([Xx.widget({widget:new SO(e),side:1}).range(0)]):Xx.none}get decorations(){return this.view.state.doc.length?Xx.none:this.placeholder}},{decorations:e=>e.decorations});return"string"==typeof e?[t,NS.contentAttributes.of({"aria-placeholder":e})]:t}(e))},setStyle:function(e){void 0===e&&(e={}),l(NS.theme({"&":Object.assign({},e)}))}}}(i.value);ur(function(){return e.modelValue},function(e){e!==l.getDoc()&&l.setDoc(e)}),ur(function(){return e.extensions},function(e){return l.reExtensions(e||[])},{immediate:!0}),ur(function(){return s.value.disabled},function(e){return l.toggleDisabled(e)},{immediate:!0}),ur(function(){return s.value.indentWithTab},function(e){return l.toggleIndentWithTab(e)},{immediate:!0}),ur(function(){return s.value.tabSize},function(e){return l.setTabSize(e)},{immediate:!0}),ur(function(){return s.value.phrases},function(e){return l.setPhrases(e||{})},{immediate:!0}),ur(function(){return s.value.placeholder},function(e){return l.setPlaceholder(e)},{immediate:!0}),ur(function(){return s.value.style},function(e){return l.setStyle(e)},{immediate:!0}),s.value.autofocus&&l.focus(),t.emit(kR.Ready,{state:r.value,view:i.value,container:n.value})}),Pi(function(){s.value.autoDestroy&&i.value&&function(e){e.destroy()}(i.value)}),function(){return Ta("div",{class:"v-codemirror",style:{display:"contents"},ref:n})}}}),QR=LR,FR=n(606);class VR{constructor(e,t,n,r,i,o,s,a,l,c=0,d){this.p=e,this.stack=t,this.state=n,this.reducePos=r,this.pos=i,this.score=o,this.buffer=s,this.bufferBase=a,this.curContext=l,this.lookAhead=c,this.parent=d}toString(){return`[${this.stack.filter((e,t)=>t%3==0).concat(this.state)}]@${this.pos}${this.score?"!"+this.score:""}`}static start(e,t,n=0){let r=e.parser.context;return new VR(e,[],t,n,n,0,[],0,r?new zR(r,r.start):null,0,null)}get context(){return this.curContext?this.curContext.context:null}pushState(e,t){this.stack.push(this.state,t,this.bufferBase+this.buffer.length),this.state=e}reduce(e){var t;let n=e>>19,r=65535&e,{parser:i}=this.p,o=this.reducePos<this.pos-25&&this.setLookAhead(this.pos),s=i.dynamicPrecedence(r);if(s&&(this.score+=s),0==n)return this.pushState(i.getGoto(this.state,r,!0),this.reducePos),r<i.minRepeatTerm&&this.storeNode(r,this.reducePos,this.reducePos,o?8:4,!0),void this.reduceContext(r,this.reducePos);let a=this.stack.length-3*(n-1)-(262144&e?6:0),l=a?this.stack[a-2]:this.p.ranges[0].from,c=this.reducePos-l;c>=2e3&&!(null===(t=this.p.parser.nodeSet.types[r])||void 0===t?void 0:t.isAnonymous)&&(l==this.p.lastBigReductionStart?(this.p.bigReductionCount++,this.p.lastBigReductionSize=c):this.p.lastBigReductionSize<c&&(this.p.bigReductionCount=1,this.p.lastBigReductionStart=l,this.p.lastBigReductionSize=c));let d=a?this.stack[a-1]:0,h=this.bufferBase+this.buffer.length-d;if(r<i.minRepeatTerm||131072&e){let e=i.stateFlag(this.state,1)?this.pos:this.reducePos;this.storeNode(r,l,e,h+4,!0)}if(262144&e)this.state=this.stack[a];else{let e=this.stack[a-3];this.state=i.getGoto(e,r,!0)}for(;this.stack.length>a;)this.stack.pop();this.reduceContext(r,l)}storeNode(e,t,n,r=4,i=!1){if(0==e&&(!this.stack.length||this.stack[this.stack.length-1]<this.buffer.length+this.bufferBase)){let e=this,r=this.buffer.length;if(0==r&&e.parent&&(r=e.bufferBase-e.parent.bufferBase,e=e.parent),r>0&&0==e.buffer[r-4]&&e.buffer[r-1]>-1){if(t==n)return;if(e.buffer[r-2]>=t)return void(e.buffer[r-2]=n)}}if(i&&this.pos!=n){let i=this.buffer.length;if(i>0&&(0!=this.buffer[i-4]||this.buffer[i-1]<0)){let e=!1;for(let t=i;t>0&&this.buffer[t-2]>n;t-=4)if(this.buffer[t-1]>=0){e=!0;break}if(e)for(;i>0&&this.buffer[i-2]>n;)this.buffer[i]=this.buffer[i-4],this.buffer[i+1]=this.buffer[i-3],this.buffer[i+2]=this.buffer[i-2],this.buffer[i+3]=this.buffer[i-1],i-=4,r>4&&(r-=4)}this.buffer[i]=e,this.buffer[i+1]=t,this.buffer[i+2]=n,this.buffer[i+3]=r}else this.buffer.push(e,t,n,r)}shift(e,t,n,r){if(131072&e)this.pushState(65535&e,this.pos);else if(262144&e)this.pos=r,this.shiftContext(t,n),t<=this.p.parser.maxNode&&this.buffer.push(t,n,r,4);else{let i=e,{parser:o}=this.p;this.pos=r;let s=o.stateFlag(i,1);!s&&(r>n||t<=o.maxNode)&&(this.reducePos=r),this.pushState(i,s?n:Math.min(n,this.reducePos)),this.shiftContext(t,n),t<=o.maxNode&&this.buffer.push(t,n,r,4)}}apply(e,t,n,r){65536&e?this.reduce(e):this.shift(e,t,n,r)}useNode(e,t){let n=this.p.reused.length-1;(n<0||this.p.reused[n]!=e)&&(this.p.reused.push(e),n++);let r=this.pos;this.reducePos=this.pos=r+e.length,this.pushState(t,r),this.buffer.push(n,r,this.reducePos,-1),this.curContext&&this.updateContext(this.curContext.tracker.reuse(this.curContext.context,e,this,this.p.stream.reset(this.pos-e.length)))}split(){let e=this,t=e.buffer.length;for(;t>0&&e.buffer[t-2]>e.reducePos;)t-=4;let n=e.buffer.slice(t),r=e.bufferBase+t;for(;e&&r==e.bufferBase;)e=e.parent;return new VR(this.p,this.stack.slice(),this.state,this.reducePos,this.pos,this.score,n,r,this.curContext,this.lookAhead,e)}recoverByDelete(e,t){let n=e<=this.p.parser.maxNode;n&&this.storeNode(e,this.pos,t,4),this.storeNode(0,this.pos,t,n?8:4),this.pos=this.reducePos=t,this.score-=190}canShift(e){for(let t=new WR(this);;){let n=this.p.parser.stateSlot(t.state,4)||this.p.parser.hasAction(t.state,e);if(0==n)return!1;if(!(65536&n))return!0;t.reduce(n)}}recoverByInsert(e){if(this.stack.length>=300)return[];let t=this.p.parser.nextStates(this.state);if(t.length>8||this.stack.length>=120){let n=[];for(let r,i=0;i<t.length;i+=2)(r=t[i+1])!=this.state&&this.p.parser.hasAction(r,e)&&n.push(t[i],r);if(this.stack.length<120)for(let e=0;n.length<8&&e<t.length;e+=2){let r=t[e+1];n.some((e,t)=>1&t&&e==r)||n.push(t[e],r)}t=n}let n=[];for(let e=0;e<t.length&&n.length<4;e+=2){let r=t[e+1];if(r==this.state)continue;let i=this.split();i.pushState(r,this.pos),i.storeNode(0,i.pos,i.pos,4,!0),i.shiftContext(t[e],this.pos),i.reducePos=this.pos,i.score-=200,n.push(i)}return n}forceReduce(){let{parser:e}=this.p,t=e.stateSlot(this.state,5);if(!(65536&t))return!1;if(!e.validAction(this.state,t)){let n=t>>19,r=65535&t,i=this.stack.length-3*n;if(i<0||e.getGoto(this.stack[i],r,!1)<0){let e=this.findForcedReduction();if(null==e)return!1;t=e}this.storeNode(0,this.pos,this.pos,4,!0),this.score-=100}return this.reducePos=this.pos,this.reduce(t),!0}findForcedReduction(){let{parser:e}=this.p,t=[],n=(r,i)=>{if(!t.includes(r))return t.push(r),e.allActions(r,t=>{if(393216&t);else if(65536&t){let n=(t>>19)-i;if(n>1){let r=65535&t,i=this.stack.length-3*n;if(i>=0&&e.getGoto(this.stack[i],r,!1)>=0)return n<<19|65536|r}}else{let e=n(t,i+1);if(null!=e)return e}})};return n(this.state,0)}forceAll(){for(;!this.p.parser.stateFlag(this.state,2);)if(!this.forceReduce()){this.storeNode(0,this.pos,this.pos,4,!0);break}return this}get deadEnd(){if(3!=this.stack.length)return!1;let{parser:e}=this.p;return 65535==e.data[e.stateSlot(this.state,1)]&&!e.stateSlot(this.state,4)}restart(){this.storeNode(0,this.pos,this.pos,4,!0),this.state=this.stack[0],this.stack.length=0}sameState(e){if(this.state!=e.state||this.stack.length!=e.stack.length)return!1;for(let t=0;t<this.stack.length;t+=3)if(this.stack[t]!=e.stack[t])return!1;return!0}get parser(){return this.p.parser}dialectEnabled(e){return this.p.parser.dialect.flags[e]}shiftContext(e,t){this.curContext&&this.updateContext(this.curContext.tracker.shift(this.curContext.context,e,this,this.p.stream.reset(t)))}reduceContext(e,t){this.curContext&&this.updateContext(this.curContext.tracker.reduce(this.curContext.context,e,this,this.p.stream.reset(t)))}emitContext(){let e=this.buffer.length-1;(e<0||-3!=this.buffer[e])&&this.buffer.push(this.curContext.hash,this.pos,this.pos,-3)}emitLookAhead(){let e=this.buffer.length-1;(e<0||-4!=this.buffer[e])&&this.buffer.push(this.lookAhead,this.pos,this.pos,-4)}updateContext(e){if(e!=this.curContext.context){let t=new zR(this.curContext.tracker,e);t.hash!=this.curContext.hash&&this.emitContext(),this.curContext=t}}setLookAhead(e){return!(e<=this.lookAhead)&&(this.emitLookAhead(),this.lookAhead=e,!0)}close(){this.curContext&&this.curContext.tracker.strict&&this.emitContext(),this.lookAhead>0&&this.emitLookAhead()}}class zR{constructor(e,t){this.tracker=e,this.context=t,this.hash=e.strict?e.hash(t):0}}class WR{constructor(e){this.start=e,this.state=e.state,this.stack=e.stack,this.base=this.stack.length}reduce(e){let t=65535&e,n=e>>19;0==n?(this.stack==this.start.stack&&(this.stack=this.stack.slice()),this.stack.push(this.state,0,0),this.base+=3):this.base-=3*(n-1);let r=this.start.p.parser.getGoto(this.stack[this.base-3],t,!0);this.state=r}}class $R{constructor(e,t,n){this.stack=e,this.pos=t,this.index=n,this.buffer=e.buffer,0==this.index&&this.maybeNext()}static create(e,t=e.bufferBase+e.buffer.length){return new $R(e,t,t-e.bufferBase)}maybeNext(){let e=this.stack.parent;null!=e&&(this.index=this.stack.bufferBase-e.bufferBase,this.stack=e,this.buffer=e.buffer)}get id(){return this.buffer[this.index-4]}get start(){return this.buffer[this.index-3]}get end(){return this.buffer[this.index-2]}get size(){return this.buffer[this.index-1]}next(){this.index-=4,this.pos-=4,0==this.index&&this.maybeNext()}fork(){return new $R(this.stack,this.pos,this.index)}}function HR(e,t=Uint16Array){if("string"!=typeof e)return e;let n=null;for(let r=0,i=0;r<e.length;){let o=0;for(;;){let t=e.charCodeAt(r++),n=!1;if(126==t){o=65535;break}t>=92&&t--,t>=34&&t--;let i=t-32;if(i>=46&&(i-=46,n=!0),o+=i,n)break;o*=46}n?n[i++]=o:n=new t(o)}return n}class jR{constructor(){this.start=-1,this.value=-1,this.end=-1,this.extended=-1,this.lookAhead=0,this.mask=0,this.context=0}}const qR=new jR;class UR{constructor(e,t){this.input=e,this.ranges=t,this.chunk="",this.chunkOff=0,this.chunk2="",this.chunk2Pos=0,this.next=-1,this.token=qR,this.rangeIndex=0,this.pos=this.chunkPos=t[0].from,this.range=t[0],this.end=t[t.length-1].to,this.readNext()}resolveOffset(e,t){let n=this.range,r=this.rangeIndex,i=this.pos+e;for(;i<n.from;){if(!r)return null;let e=this.ranges[--r];i-=n.from-e.to,n=e}for(;t<0?i>n.to:i>=n.to;){if(r==this.ranges.length-1)return null;let e=this.ranges[++r];i+=e.from-n.to,n=e}return i}clipPos(e){if(e>=this.range.from&&e<this.range.to)return e;for(let t of this.ranges)if(t.to>e)return Math.max(e,t.from);return this.end}peek(e){let t,n,r=this.chunkOff+e;if(r>=0&&r<this.chunk.length)t=this.pos+e,n=this.chunk.charCodeAt(r);else{let r=this.resolveOffset(e,1);if(null==r)return-1;if(t=r,t>=this.chunk2Pos&&t<this.chunk2Pos+this.chunk2.length)n=this.chunk2.charCodeAt(t-this.chunk2Pos);else{let e=this.rangeIndex,r=this.range;for(;r.to<=t;)r=this.ranges[++e];this.chunk2=this.input.chunk(this.chunk2Pos=t),t+this.chunk2.length>r.to&&(this.chunk2=this.chunk2.slice(0,r.to-t)),n=this.chunk2.charCodeAt(0)}}return t>=this.token.lookAhead&&(this.token.lookAhead=t+1),n}acceptToken(e,t=0){let n=t?this.resolveOffset(t,-1):this.pos;if(null==n||n<this.token.start)throw new RangeError("Token end out of bounds");this.token.value=e,this.token.end=n}acceptTokenTo(e,t){this.token.value=e,this.token.end=t}getChunk(){if(this.pos>=this.chunk2Pos&&this.pos<this.chunk2Pos+this.chunk2.length){let{chunk:e,chunkPos:t}=this;this.chunk=this.chunk2,this.chunkPos=this.chunk2Pos,this.chunk2=e,this.chunk2Pos=t,this.chunkOff=this.pos-this.chunkPos}else{this.chunk2=this.chunk,this.chunk2Pos=this.chunkPos;let e=this.input.chunk(this.pos),t=this.pos+e.length;this.chunk=t>this.range.to?e.slice(0,this.range.to-this.pos):e,this.chunkPos=this.pos,this.chunkOff=0}}readNext(){return this.chunkOff>=this.chunk.length&&(this.getChunk(),this.chunkOff==this.chunk.length)?this.next=-1:this.next=this.chunk.charCodeAt(this.chunkOff)}advance(e=1){for(this.chunkOff+=e;this.pos+e>=this.range.to;){if(this.rangeIndex==this.ranges.length-1)return this.setDone();e-=this.range.to-this.pos,this.range=this.ranges[++this.rangeIndex],this.pos=this.range.from}return this.pos+=e,this.pos>=this.token.lookAhead&&(this.token.lookAhead=this.pos+1),this.readNext()}setDone(){return this.pos=this.chunkPos=this.end,this.range=this.ranges[this.rangeIndex=this.ranges.length-1],this.chunk="",this.next=-1}reset(e,t){if(t?(this.token=t,t.start=e,t.lookAhead=e+1,t.value=t.extended=-1):this.token=qR,this.pos!=e){if(this.pos=e,e==this.end)return this.setDone(),this;for(;e<this.range.from;)this.range=this.ranges[--this.rangeIndex];for(;e>=this.range.to;)this.range=this.ranges[++this.rangeIndex];e>=this.chunkPos&&e<this.chunkPos+this.chunk.length?this.chunkOff=e-this.chunkPos:(this.chunk="",this.chunkOff=0),this.readNext()}return this}read(e,t){if(e>=this.chunkPos&&t<=this.chunkPos+this.chunk.length)return this.chunk.slice(e-this.chunkPos,t-this.chunkPos);if(e>=this.chunk2Pos&&t<=this.chunk2Pos+this.chunk2.length)return this.chunk2.slice(e-this.chunk2Pos,t-this.chunk2Pos);if(e>=this.range.from&&t<=this.range.to)return this.input.read(e,t);let n="";for(let r of this.ranges){if(r.from>=t)break;r.to>e&&(n+=this.input.read(Math.max(r.from,e),Math.min(r.to,t)))}return n}}class GR{constructor(e,t){this.data=e,this.id=t}token(e,t){let{parser:n}=t.p;JR(this.data,e,t,this.id,n.data,n.tokenPrecTable)}}GR.prototype.contextual=GR.prototype.fallback=GR.prototype.extend=!1;class YR{constructor(e,t,n){this.precTable=t,this.elseToken=n,this.data="string"==typeof e?HR(e):e}token(e,t){let n=e.pos,r=0;for(;;){let n=e.next<0,i=e.resolveOffset(1,1);if(JR(this.data,e,t,0,this.data,this.precTable),e.token.value>-1)break;if(null==this.elseToken)return;if(n||r++,null==i)break;e.reset(i,e.token)}r&&(e.reset(n,e.token),e.acceptToken(this.elseToken,r))}}YR.prototype.contextual=GR.prototype.fallback=GR.prototype.extend=!1;class XR{constructor(e,t={}){this.token=e,this.contextual=!!t.contextual,this.fallback=!!t.fallback,this.extend=!!t.extend}}function JR(e,t,n,r,i,o){let s=0,a=1<<r,{dialect:l}=n.p.parser;e:for(;0!=(a&e[s]);){let n=e[s+1];for(let r=s+3;r<n;r+=2)if((e[r+1]&a)>0){let n=e[r];if(l.allows(n)&&(-1==t.token.value||t.token.value==n||ZR(n,t.token.value,i,o))){t.acceptToken(n);break}}let r=t.next,c=0,d=e[s+2];if(!(t.next<0&&d>c&&65535==e[n+3*d-3])){for(;c<d;){let i=c+d>>1,o=n+i+(i<<1),a=e[o],l=e[o+1]||65536;if(r<a)d=i;else{if(!(r>=l)){s=e[o+2],t.advance();continue e}c=i+1}}break}s=e[n+3*d-1]}}function KR(e,t,n){for(let r,i=t;65535!=(r=e[i]);i++)if(r==n)return i-t;return-1}function ZR(e,t,n,r){let i=KR(n,r,t);return i<0||KR(n,r,e)<i}const eI=void 0!==FR&&FR.env&&/\bparse\b/.test(FR.env.LOG);let tI=null;function nI(e,t,n){let r=e.cursor(VB.IncludeAnonymous);for(r.moveTo(t);;)if(!(n<0?r.childBefore(t):r.childAfter(t)))for(;;){if((n<0?r.to<t:r.from>t)&&!r.type.isError)return n<0?Math.max(0,Math.min(r.to-1,t-25)):Math.min(e.length,Math.max(r.from+1,t+25));if(n<0?r.prevSibling():r.nextSibling())break;if(!r.parent())return n<0?0:e.length}}class rI{constructor(e,t){this.fragments=e,this.nodeSet=t,this.i=0,this.fragment=null,this.safeFrom=-1,this.safeTo=-1,this.trees=[],this.start=[],this.index=[],this.nextFragment()}nextFragment(){let e=this.fragment=this.i==this.fragments.length?null:this.fragments[this.i++];if(e){for(this.safeFrom=e.openStart?nI(e.tree,e.from+e.offset,1)-e.offset:e.from,this.safeTo=e.openEnd?nI(e.tree,e.to+e.offset,-1)-e.offset:e.to;this.trees.length;)this.trees.pop(),this.start.pop(),this.index.pop();this.trees.push(e.tree),this.start.push(-e.offset),this.index.push(0),this.nextStart=this.safeFrom}else this.nextStart=1e9}nodeAt(e){if(e<this.nextStart)return null;for(;this.fragment&&this.safeTo<=e;)this.nextFragment();if(!this.fragment)return null;for(;;){let t=this.trees.length-1;if(t<0)return this.nextFragment(),null;let n=this.trees[t],r=this.index[t];if(r==n.children.length){this.trees.pop(),this.start.pop(),this.index.pop();continue}let i=n.children[r],o=this.start[t]+n.positions[r];if(o>e)return this.nextStart=o,null;if(i instanceof zB){if(o==e){if(o<this.safeFrom)return null;let e=o+i.length;if(e<=this.safeTo){let t=i.prop(PB.lookAhead);if(!t||e+t<this.fragment.to)return i}}this.index[t]++,o+i.length>=Math.max(this.safeFrom,e)&&(this.trees.push(i),this.start.push(o),this.index.push(0))}else this.index[t]++,this.nextStart=o+i.length}}}class iI{constructor(e,t){this.stream=t,this.tokens=[],this.mainToken=null,this.actions=[],this.tokens=e.tokenizers.map(e=>new jR)}getActions(e){let t=0,n=null,{parser:r}=e.p,{tokenizers:i}=r,o=r.stateSlot(e.state,3),s=e.curContext?e.curContext.hash:0,a=0;for(let r=0;r<i.length;r++){if(!(1<<r&o))continue;let l=i[r],c=this.tokens[r];if((!n||l.fallback)&&((l.contextual||c.start!=e.pos||c.mask!=o||c.context!=s)&&(this.updateCachedToken(c,l,e),c.mask=o,c.context=s),c.lookAhead>c.end+25&&(a=Math.max(c.lookAhead,a)),0!=c.value)){let r=t;if(c.extended>-1&&(t=this.addActions(e,c.extended,c.end,t)),t=this.addActions(e,c.value,c.end,t),!l.extend&&(n=c,t>r))break}}for(;this.actions.length>t;)this.actions.pop();return a&&e.setLookAhead(a),n||e.pos!=this.stream.end||(n=new jR,n.value=e.p.parser.eofTerm,n.start=n.end=e.pos,t=this.addActions(e,n.value,n.end,t)),this.mainToken=n,this.actions}getMainToken(e){if(this.mainToken)return this.mainToken;let t=new jR,{pos:n,p:r}=e;return t.start=n,t.end=Math.min(n+1,r.stream.end),t.value=n==r.stream.end?r.parser.eofTerm:0,t}updateCachedToken(e,t,n){let r=this.stream.clipPos(n.pos);if(t.token(this.stream.reset(r,e),n),e.value>-1){let{parser:t}=n.p;for(let r=0;r<t.specialized.length;r++)if(t.specialized[r]==e.value){let i=t.specializers[r](this.stream.read(e.start,e.end),n);if(i>=0&&n.p.parser.dialect.allows(i>>1)){1&i?e.extended=i>>1:e.value=i>>1;break}}}else e.value=0,e.end=this.stream.clipPos(r+1)}putAction(e,t,n,r){for(let t=0;t<r;t+=3)if(this.actions[t]==e)return r;return this.actions[r++]=e,this.actions[r++]=t,this.actions[r++]=n,r}addActions(e,t,n,r){let{state:i}=e,{parser:o}=e.p,{data:s}=o;for(let e=0;e<2;e++)for(let a=o.stateSlot(i,e?2:1);;a+=3){if(65535==s[a]){if(1!=s[a+1]){0==r&&2==s[a+1]&&(r=this.putAction(cI(s,a+2),t,n,r));break}a=cI(s,a+2)}s[a]==t&&(r=this.putAction(cI(s,a+1),t,n,r))}return r}}class oI{constructor(e,t,n,r){this.parser=e,this.input=t,this.ranges=r,this.recovering=0,this.nextStackID=9812,this.minStackPos=0,this.reused=[],this.stoppedAt=null,this.lastBigReductionStart=-1,this.lastBigReductionSize=0,this.bigReductionCount=0,this.stream=new UR(t,r),this.tokens=new iI(e,this.stream),this.topTerm=e.top[1];let{from:i}=r[0];this.stacks=[VR.start(this,e.top[0],i)],this.fragments=n.length&&this.stream.end-i>4*e.bufferLength?new rI(n,e.nodeSet):null}get parsedPos(){return this.minStackPos}advance(){let e,t,n=this.stacks,r=this.minStackPos,i=this.stacks=[];if(this.bigReductionCount>300&&1==n.length){let[e]=n;for(;e.forceReduce()&&e.stack.length&&e.stack[e.stack.length-2]>=this.lastBigReductionStart;);this.bigReductionCount=this.lastBigReductionSize=0}for(let o=0;o<n.length;o++){let s=n[o];for(;;){if(this.tokens.mainToken=null,s.pos>r)i.push(s);else{if(this.advanceStack(s,i,n))continue;{e||(e=[],t=[]),e.push(s);let n=this.tokens.getMainToken(s);t.push(n.value,n.end)}}break}}if(!i.length){let t=e&&function(e){let t=null;for(let n of e){let e=n.p.stoppedAt;(n.pos==n.p.stream.end||null!=e&&n.pos>e)&&n.p.parser.stateFlag(n.state,2)&&(!t||t.score<n.score)&&(t=n)}return t}(e);if(t)return eI&&console.log("Finish with "+this.stackID(t)),this.stackToTree(t);if(this.parser.strict)throw eI&&e&&console.log("Stuck with token "+(this.tokens.mainToken?this.parser.getName(this.tokens.mainToken.value):"none")),new SyntaxError("No parse at "+r);this.recovering||(this.recovering=5)}if(this.recovering&&e){let n=null!=this.stoppedAt&&e[0].pos>this.stoppedAt?e[0]:this.runRecovery(e,t,i);if(n)return eI&&console.log("Force-finish "+this.stackID(n)),this.stackToTree(n.forceAll())}if(this.recovering){let e=1==this.recovering?1:3*this.recovering;if(i.length>e)for(i.sort((e,t)=>t.score-e.score);i.length>e;)i.pop();i.some(e=>e.reducePos>r)&&this.recovering--}else if(i.length>1){e:for(let e=0;e<i.length-1;e++){let t=i[e];for(let n=e+1;n<i.length;n++){let r=i[n];if(t.sameState(r)||t.buffer.length>500&&r.buffer.length>500){if(!((t.score-r.score||t.buffer.length-r.buffer.length)>0)){i.splice(e--,1);continue e}i.splice(n--,1)}}}i.length>12&&(i.sort((e,t)=>t.score-e.score),i.splice(12,i.length-12))}this.minStackPos=i[0].pos;for(let e=1;e<i.length;e++)i[e].pos<this.minStackPos&&(this.minStackPos=i[e].pos);return null}stopAt(e){if(null!=this.stoppedAt&&this.stoppedAt<e)throw new RangeError("Can't move stoppedAt forward");this.stoppedAt=e}advanceStack(e,t,n){let r=e.pos,{parser:i}=this,o=eI?this.stackID(e)+" -> ":"";if(null!=this.stoppedAt&&r>this.stoppedAt)return e.forceReduce()?e:null;if(this.fragments){let t=e.curContext&&e.curContext.tracker.strict,n=t?e.curContext.hash:0;for(let s=this.fragments.nodeAt(r);s;){let r=this.parser.nodeSet.types[s.type.id]==s.type?i.getGoto(e.state,s.type.id):-1;if(r>-1&&s.length&&(!t||(s.prop(PB.contextHash)||0)==n))return e.useNode(s,r),eI&&console.log(o+this.stackID(e)+` (via reuse of ${i.getName(s.type.id)})`),!0;if(!(s instanceof zB)||0==s.children.length||s.positions[0]>0)break;let a=s.children[0];if(!(a instanceof zB&&0==s.positions[0]))break;s=a}}let s=i.stateSlot(e.state,4);if(s>0)return e.reduce(s),eI&&console.log(o+this.stackID(e)+` (via always-reduce ${i.getName(65535&s)})`),!0;if(e.stack.length>=8400)for(;e.stack.length>6e3&&e.forceReduce(););let a=this.tokens.getActions(e);for(let s=0;s<a.length;){let l=a[s++],c=a[s++],d=a[s++],h=s==a.length||!n,u=h?e:e.split(),p=this.tokens.mainToken;if(u.apply(l,c,p?p.start:u.pos,d),eI&&console.log(o+this.stackID(u)+` (via ${65536&l?`reduce of ${i.getName(65535&l)}`:"shift"} for ${i.getName(c)} @ ${r}${u==e?"":", split"})`),h)return!0;u.pos>r?t.push(u):n.push(u)}return!1}advanceFully(e,t){let n=e.pos;for(;;){if(!this.advanceStack(e,null,null))return!1;if(e.pos>n)return sI(e,t),!0}}runRecovery(e,t,n){let r=null,i=!1;for(let o=0;o<e.length;o++){let s=e[o],a=t[o<<1],l=t[1+(o<<1)],c=eI?this.stackID(s)+" -> ":"";if(s.deadEnd){if(i)continue;if(i=!0,s.restart(),eI&&console.log(c+this.stackID(s)+" (restarted)"),this.advanceFully(s,n))continue}let d=s.split(),h=c;for(let e=0;e<10&&d.forceReduce();e++){if(eI&&console.log(h+this.stackID(d)+" (via force-reduce)"),this.advanceFully(d,n))break;eI&&(h=this.stackID(d)+" -> ")}for(let e of s.recoverByInsert(a))eI&&console.log(c+this.stackID(e)+" (via recover-insert)"),this.advanceFully(e,n);this.stream.end>s.pos?(l==s.pos&&(l++,a=0),s.recoverByDelete(a,l),eI&&console.log(c+this.stackID(s)+` (via recover-delete ${this.parser.getName(a)})`),sI(s,n)):(!r||r.score<d.score)&&(r=d)}return r}stackToTree(e){return e.close(),zB.build({buffer:$R.create(e),nodeSet:this.parser.nodeSet,topID:this.topTerm,maxBufferLength:this.parser.bufferLength,reused:this.reused,start:this.ranges[0].from,length:e.pos-this.ranges[0].from,minRepeatType:this.parser.minRepeatTerm})}stackID(e){let t=(tI||(tI=new WeakMap)).get(e);return t||tI.set(e,t=String.fromCodePoint(this.nextStackID++)),t+e}}function sI(e,t){for(let n=0;n<t.length;n++){let r=t[n];if(r.pos==e.pos&&r.sameState(e))return void(t[n].score<e.score&&(t[n]=e))}t.push(e)}class aI{constructor(e,t,n){this.source=e,this.flags=t,this.disabled=n}allows(e){return!this.disabled||0==this.disabled[e]}}class lI extends a_{constructor(e){if(super(),this.wrappers=[],14!=e.version)throw new RangeError(`Parser version (${e.version}) doesn't match runtime version (14)`);let t=e.nodeNames.split(" ");this.minRepeatTerm=t.length;for(let n=0;n<e.repeatNodeCount;n++)t.push("");let n=Object.keys(e.topRules).map(t=>e.topRules[t][1]),r=[];for(let e=0;e<t.length;e++)r.push([]);function i(e,t,n){r[e].push([t,t.deserialize(String(n))])}if(e.nodeProps)for(let t of e.nodeProps){let e=t[0];"string"==typeof e&&(e=PB[e]);for(let n=1;n<t.length;){let r=t[n++];if(r>=0)i(r,e,t[n++]);else{let o=t[n+-r];for(let s=-r;s>0;s--)i(t[n++],e,o);n++}}}this.nodeSet=new LB(t.map((t,i)=>NB.define({name:i>=this.minRepeatTerm?void 0:t,id:i,props:r[i],top:n.indexOf(i)>-1,error:0==i,skipped:e.skippedNodes&&e.skippedNodes.indexOf(i)>-1}))),e.propSources&&(this.nodeSet=this.nodeSet.extend(...e.propSources)),this.strict=!1,this.bufferLength=EB;let o=HR(e.tokenData);this.context=e.context,this.specializerSpecs=e.specialized||[],this.specialized=new Uint16Array(this.specializerSpecs.length);for(let e=0;e<this.specializerSpecs.length;e++)this.specialized[e]=this.specializerSpecs[e].term;this.specializers=this.specializerSpecs.map(dI),this.states=HR(e.states,Uint32Array),this.data=HR(e.stateData),this.goto=HR(e.goto),this.maxTerm=e.maxTerm,this.tokenizers=e.tokenizers.map(e=>"number"==typeof e?new GR(o,e):e),this.topRules=e.topRules,this.dialects=e.dialects||{},this.dynamicPrecedences=e.dynamicPrecedences||null,this.tokenPrecTable=e.tokenPrec,this.termNames=e.termNames||null,this.maxNode=this.nodeSet.types.length-1,this.dialect=this.parseDialect(),this.top=this.topRules[Object.keys(this.topRules)[0]]}createParse(e,t,n){let r=new oI(this,e,t,n);for(let i of this.wrappers)r=i(r,e,t,n);return r}getGoto(e,t,n=!1){let r=this.goto;if(t>=r[0])return-1;for(let i=r[t+1];;){let t=r[i++],o=1&t,s=r[i++];if(o&&n)return s;for(let n=i+(t>>1);i<n;i++)if(r[i]==e)return s;if(o)return-1}}hasAction(e,t){let n=this.data;for(let r=0;r<2;r++)for(let i,o=this.stateSlot(e,r?2:1);;o+=3){if(65535==(i=n[o])){if(1!=n[o+1]){if(2==n[o+1])return cI(n,o+2);break}i=n[o=cI(n,o+2)]}if(i==t||0==i)return cI(n,o+1)}return 0}stateSlot(e,t){return this.states[6*e+t]}stateFlag(e,t){return(this.stateSlot(e,0)&t)>0}validAction(e,t){return!!this.allActions(e,e=>e==t||null)}allActions(e,t){let n=this.stateSlot(e,4),r=n?t(n):void 0;for(let n=this.stateSlot(e,1);null==r;n+=3){if(65535==this.data[n]){if(1!=this.data[n+1])break;n=cI(this.data,n+2)}r=t(cI(this.data,n+1))}return r}nextStates(e){let t=[];for(let n=this.stateSlot(e,1);;n+=3){if(65535==this.data[n]){if(1!=this.data[n+1])break;n=cI(this.data,n+2)}if(!(1&this.data[n+2])){let e=this.data[n+1];t.some((t,n)=>1&n&&t==e)||t.push(this.data[n],e)}}return t}configure(e){let t=Object.assign(Object.create(lI.prototype),this);if(e.props&&(t.nodeSet=this.nodeSet.extend(...e.props)),e.top){let n=this.topRules[e.top];if(!n)throw new RangeError(`Invalid top rule name ${e.top}`);t.top=n}return e.tokenizers&&(t.tokenizers=this.tokenizers.map(t=>{let n=e.tokenizers.find(e=>e.from==t);return n?n.to:t})),e.specializers&&(t.specializers=this.specializers.slice(),t.specializerSpecs=this.specializerSpecs.map((n,r)=>{let i=e.specializers.find(e=>e.from==n.external);if(!i)return n;let o=Object.assign(Object.assign({},n),{external:i.to});return t.specializers[r]=dI(o),o})),e.contextTracker&&(t.context=e.contextTracker),e.dialect&&(t.dialect=this.parseDialect(e.dialect)),null!=e.strict&&(t.strict=e.strict),e.wrap&&(t.wrappers=t.wrappers.concat(e.wrap)),null!=e.bufferLength&&(t.bufferLength=e.bufferLength),t}hasWrappers(){return this.wrappers.length>0}getName(e){return this.termNames?this.termNames[e]:String(e<=this.maxNode&&this.nodeSet.types[e].name||e)}get eofTerm(){return this.maxNode+1}get topNode(){return this.nodeSet.types[this.top[1]]}dynamicPrecedence(e){let t=this.dynamicPrecedences;return null==t?0:t[e]||0}parseDialect(e){let t=Object.keys(this.dialects),n=t.map(()=>!1);if(e)for(let r of e.split(" ")){let e=t.indexOf(r);e>=0&&(n[e]=!0)}let r=null;for(let e=0;e<t.length;e++)if(!n[e])for(let n,i=this.dialects[t[e]];65535!=(n=this.data[i++]);)(r||(r=new Uint8Array(this.maxTerm+1)))[n]=1;return new aI(e,n,r)}static deserialize(e){return new lI(e)}}function cI(e,t){return e[t]|e[t+1]<<16}function dI(e){if(e.external){let t=e.extend?1:0;return(n,r)=>e.external(n,r)<<1|t}return e.get}const hI=[9,10,11,12,13,32,133,160,5760,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8232,8233,8239,8287,12288];function uI(e){return e>=65&&e<=90||e>=97&&e<=122||e>=161}function pI(e){return e>=48&&e<=57}function fI(e){return pI(e)||e>=97&&e<=102||e>=65&&e<=70}const gI=(e,t,n)=>(r,i)=>{for(let o=!1,s=0,a=0;;a++){let{next:l}=r;if(uI(l)||45==l||95==l||o&&pI(l))!o&&(45!=l||a>0)&&(o=!0),s===a&&45==l&&s++,r.advance();else{if(92!=l||10==r.peek(1)){o&&r.acceptToken(2==s&&i.canShift(2)?t:40==l?n:e);break}if(r.advance(),fI(r.next)){do{r.advance()}while(fI(r.next));32==r.next&&r.advance()}else r.next>-1&&r.advance();o=!0}}},mI=new XR(gI(123,2,124)),vI=new XR(gI(125,3,4)),AI=new XR(e=>{if(hI.includes(e.peek(-1))){let{next:t}=e;(uI(t)||95==t||35==t||46==t||42==t||91==t||58==t&&uI(e.peek(1))||45==t||38==t)&&e.acceptToken(122)}}),bI=new XR(e=>{if(!hI.includes(e.peek(-1))){let{next:t}=e;if(37==t&&(e.advance(),e.acceptToken(1)),uI(t)){do{e.advance()}while(uI(e.next)||pI(e.next));e.acceptToken(1)}}}),yI=p_({"AtKeyword import charset namespace keyframes media supports":R_.definitionKeyword,"from to selector":R_.keyword,NamespaceName:R_.namespace,KeyframeName:R_.labelName,KeyframeRangeName:R_.operatorKeyword,TagName:R_.tagName,ClassName:R_.className,PseudoClassName:R_.constant(R_.className),IdName:R_.labelName,"FeatureName PropertyName":R_.propertyName,AttributeName:R_.attributeName,NumberLiteral:R_.number,KeywordQuery:R_.keyword,UnaryQueryOp:R_.operatorKeyword,"CallTag ValueName":R_.atom,VariableName:R_.variableName,Callee:R_.operatorKeyword,Unit:R_.unit,"UniversalSelector NestingSelector":R_.definitionOperator,"MatchOp CompareOp":R_.compareOperator,"ChildOp SiblingOp, LogicOp":R_.logicOperator,BinOp:R_.arithmeticOperator,Important:R_.modifier,Comment:R_.blockComment,ColorLiteral:R_.color,"ParenthesizedContent StringLiteral":R_.string,":":R_.punctuation,"PseudoOp #":R_.derefOperator,"; ,":R_.separator,"( )":R_.paren,"[ ]":R_.squareBracket,"{ }":R_.brace}),xI={__proto__:null,lang:38,"nth-child":38,"nth-last-child":38,"nth-of-type":38,"nth-last-of-type":38,dir:38,"host-context":38,if:84,url:124,"url-prefix":124,domain:124,regexp:124},wI={__proto__:null,or:98,and:98,not:106,only:106,layer:170},CI={__proto__:null,selector:112,layer:166},kI={__proto__:null,"@import":162,"@media":174,"@charset":178,"@namespace":182,"@keyframes":188,"@supports":200,"@scope":204},SI={__proto__:null,to:207},OI=lI.deserialize({version:14,states:"EbQYQdOOO#qQdOOP#xO`OOOOQP'#Cf'#CfOOQP'#Ce'#CeO#}QdO'#ChO$nQaO'#CcO$xQdO'#CkO%TQdO'#DpO%YQdO'#DrO%_QdO'#DuO%_QdO'#DxOOQP'#FV'#FVO&eQhO'#EhOOQS'#FU'#FUOOQS'#Ek'#EkQYQdOOO&lQdO'#EOO&PQhO'#EUO&lQdO'#EWO'aQdO'#EYO'lQdO'#E]O'tQhO'#EcO(VQdO'#EeO(bQaO'#CfO)VQ`O'#D{O)[Q`O'#F`O)gQdO'#F`QOQ`OOP)qO&jO'#CaPOOO)C@t)C@tOOQP'#Cj'#CjOOQP,59S,59SO#}QdO,59SO)|QdO,59VO%TQdO,5:[O%YQdO,5:^O%_QdO,5:aO%_QdO,5:cO%_QdO,5:dO%_QdO'#ErO*XQ`O,58}O*aQdO'#DzOOQS,58},58}OOQP'#Cn'#CnOOQO'#Dn'#DnOOQP,59V,59VO*hQ`O,59VO*mQ`O,59VOOQP'#Dq'#DqOOQP,5:[,5:[OOQO'#Ds'#DsO*rQpO,5:^O+]QaO,5:aO+sQaO,5:dOOQW'#DZ'#DZO,ZQhO'#DdO,xQhO'#FaO'tQhO'#DbO-WQ`O'#DhOOQW'#F['#F[O-]Q`O,5;SO-eQ`O'#DeOOQS-E8i-E8iOOQ['#Cs'#CsO-jQdO'#CtO.QQdO'#CzO.hQdO'#C}O/OQ!pO'#DPO1RQ!jO,5:jOOQO'#DU'#DUO*mQ`O'#DTO1cQ!nO'#FXO3`Q`O'#DVO3eQ`O'#DkOOQ['#FX'#FXO-`Q`O,5:pO3jQ!bO,5:rOOQS'#E['#E[O3rQ`O,5:tO3wQdO,5:tOOQO'#E_'#E_O4PQ`O,5:wO4UQhO,5:}O%_QdO'#DgOOQS,5;P,5;PO-eQ`O,5;PO4^QdO,5;PO4fQdO,5:gO4vQdO'#EtO5TQ`O,5;zO5TQ`O,5;zPOOO'#Ej'#EjP5`O&jO,58{POOO,58{,58{OOQP1G.n1G.nOOQP1G.q1G.qO*hQ`O1G.qO*mQ`O1G.qOOQP1G/v1G/vO5kQpO1G/xO5sQaO1G/{O6ZQaO1G/}O6qQaO1G0OO7XQaO,5;^OOQO-E8p-E8pOOQS1G.i1G.iO7cQ`O,5:fO7hQdO'#DoO7oQdO'#CrOOQP1G/x1G/xO&lQdO1G/xO7vQ!jO'#DZO8UQ!bO,59vO8^QhO,5:OOOQO'#F]'#F]O8XQ!bO,59zO'tQhO,59xO8fQhO'#EvO8sQ`O,5;{O9OQhO,59|O9uQhO'#DiOOQW,5:S,5:SOOQS1G0n1G0nOOQW,5:P,5:PO9|Q!fO'#FYOOQS'#FY'#FYOOQS'#Em'#EmO;^QdO,59`OOQ[,59`,59`O;tQdO,59fOOQ[,59f,59fO<[QdO,59iOOQ[,59i,59iOOQ[,59k,59kO&lQdO,59mO<rQhO'#EQOOQW'#EQ'#EQO=WQ`O1G0UO1[QhO1G0UOOQ[,59o,59oO'tQhO'#DXOOQ[,59q,59qO=]Q#tO,5:VOOQS1G0[1G0[OOQS1G0^1G0^OOQS1G0`1G0`O=hQ`O1G0`O=mQdO'#E`OOQS1G0c1G0cOOQS1G0i1G0iO=xQaO,5:RO-`Q`O1G0kOOQS1G0k1G0kO-eQ`O1G0kO>PQ!fO1G0ROOQO1G0R1G0ROOQO,5;`,5;`O>gQdO,5;`OOQO-E8r-E8rO>tQ`O1G1fPOOO-E8h-E8hPOOO1G.g1G.gOOQP7+$]7+$]OOQP7+%d7+%dO&lQdO7+%dOOQS1G0Q1G0QO?PQaO'#F_O?ZQ`O,5:ZO?`Q!fO'#ElO@^QdO'#FWO@hQ`O,59^O@mQ!bO7+%dO&lQdO1G/bO@uQhO1G/fOOQW1G/j1G/jOOQW1G/d1G/dOAWQhO,5;bOOQO-E8t-E8tOAfQhO'#DZOAtQhO'#F^OBPQ`O'#F^OBUQ`O,5:TOOQS-E8k-E8kOOQ[1G.z1G.zOOQ[1G/Q1G/QOOQ[1G/T1G/TOOQ[1G/X1G/XOBZQdO,5:lOOQS7+%p7+%pOB`Q`O7+%pOBeQhO'#DYOBmQ`O,59sO'tQhO,59sOOQ[1G/q1G/qOBuQ`O1G/qOOQS7+%z7+%zOBzQbO'#DPOOQO'#Eb'#EbOCYQ`O'#EaOOQO'#Ea'#EaOCeQ`O'#EwOCmQdO,5:zOOQS,5:z,5:zOOQ[1G/m1G/mOOQS7+&V7+&VO-`Q`O7+&VOCxQ!fO'#EsO&lQdO'#EsOEPQdO7+%mOOQO7+%m7+%mOOQO1G0z1G0zOEdQ!bO<<IOOElQdO'#EqOEvQ`O,5;yOOQP1G/u1G/uOOQS-E8j-E8jOFOQdO'#EpOFYQ`O,5;rOOQ]1G.x1G.xOOQP<<IO<<IOOFbQdO7+$|OOQO'#D]'#D]OFiQ!bO7+%QOFqQhO'#EoOF{Q`O,5;xO&lQdO,5;xOOQW1G/o1G/oOOQO'#ES'#ESOGTQ`O1G0WOOQS<<I[<<I[O&lQdO,59tOGnQhO1G/_OOQ[1G/_1G/_OGuQ`O1G/_OOQW-E8l-E8lOOQ[7+%]7+%]OOQO,5:{,5:{O=pQdO'#ExOCeQ`O,5;cOOQS,5;c,5;cOOQS-E8u-E8uOOQS1G0f1G0fOOQS<<Iq<<IqOG}Q!fO,5;_OOQS-E8q-E8qOOQO<<IX<<IXOOQPAN>jAN>jOIUQaO,5;]OOQO-E8o-E8oOI`QdO,5;[OOQO-E8n-E8nOOQW<<Hh<<HhOOQW<<Hl<<HlOIjQhO<<HlOI{QhO,5;ZOJWQ`O,5;ZOOQO-E8m-E8mOJ]QdO1G1dOBZQdO'#EuOJgQ`O7+%rOOQW7+%r7+%rOJoQ!bO1G/`OOQ[7+$y7+$yOJzQhO7+$yPKRQ`O'#EnOOQO,5;d,5;dOOQO-E8v-E8vOOQS1G0}1G0}OKWQ`OAN>WO&lQdO1G0uOK]Q`O7+'OOOQO,5;a,5;aOOQO-E8s-E8sOOQW<<I^<<I^OOQ[<<He<<HePOQW,5;Y,5;YOOQWG23rG23rOKeQdO7+&a",stateData:"Kx~O#sOS#tQQ~OW[OZ[O]TO`VOaVOi]OjWOmXO!jYO!mZO!saO!ybO!{cO!}dO#QeO#WfO#YgO#oRO~OQiOW[OZ[O]TO`VOaVOi]OjWOmXO!jYO!mZO!saO!ybO!{cO!}dO#QeO#WfO#YgO#ohO~O#m$SP~P!dO#tmO~O#ooO~O]qO`rOarOjsOmtO!juO!mwO#nvO~OpzO!^xO~P$SOc!QO#o|O#p}O~O#o!RO~O#o!TO~OW[OZ[O]TO`VOaVOjWOmXO!jYO!mZO#oRO~OS!]Oe!YO!V![O!Y!`O#q!XOp$TP~Ok$TP~P&POQ!jOe!cOm!dOp!eOr!mOt!mOz!kO!`!lO#o!bO#p!hO#}!fO~Ot!qO!`!lO#o!pO~Ot!sO#o!sO~OS!]Oe!YO!V![O!Y!`O#q!XO~Oe!vOpzO#Z!xO~O]YX`YX`!pXaYXjYXmYXpYX!^YX!jYX!mYX#nYX~O`!zO~Ok!{O#m$SXo$SX~O#m$SXo$SX~P!dO#u#OO#v#OO#w#QO~Oc#UO#o|O#p}O~OpzO!^xO~Oo$SP~P!dOe#`O~Oe#aO~Ol#bO!h#cO~O]qO`rOarOjsOmtO~Op!ia!^!ia!j!ia!m!ia#n!iad!ia~P*zOp!la!^!la!j!la!m!la#n!lad!la~P*zOR#gOS!]Oe!YOr#gOt#gO!V![O!Y!`O#q#dO#}!fO~O!R#iO!^#jOk$TXp$TX~Oe#mO~Ok#oOpzO~Oe!vO~O]#rO`#rOd#uOi#rOj#rOk#rO~P&lO]#rO`#rOi#rOj#rOk#rOl#wO~P&lO]#rO`#rOi#rOj#rOk#rOo#yO~P&lOP#zOSsXesXksXvsX!VsX!YsX!usX!wsX#qsX!TsXQsX]sX`sXdsXisXjsXmsXpsXrsXtsXzsX!`sX#osX#psX#}sXlsXosX!^sX!qsX#msX~Ov#{O!u#|O!w#}Ok$TP~P'tOe#aOS#{Xk#{Xv#{X!V#{X!Y#{X!u#{X!w#{X#q#{XQ#{X]#{X`#{Xd#{Xi#{Xj#{Xm#{Xp#{Xr#{Xt#{Xz#{X!`#{X#o#{X#p#{X#}#{Xl#{Xo#{X!^#{X!q#{X#m#{X~Oe$RO~Oe$TO~Ok$VOv#{O~Ok$WO~Ot$XO!`!lO~Op$YO~OpzO!R#iO~OpzO#Z$`O~O!q$bOk!oa#m!oao!oa~P&lOk#hX#m#hXo#hX~P!dOk!{O#m$Sao$Sa~O#u#OO#v#OO#w$hO~Ol$jO!h$kO~Op!ii!^!ii!j!ii!m!ii#n!iid!ii~P*zOp!ki!^!ki!j!ki!m!ki#n!kid!ki~P*zOp!li!^!li!j!li!m!li#n!lid!li~P*zOp#fa!^#fa~P$SOo$lO~Od$RP~P%_Od#zP~P&lO`!PXd}X!R}X!T!PX~O`$sO!T$tO~Od$uO!R#iO~Ok#jXp#jX!^#jX~P'tO!^#jOk$Tap$Ta~O!R#iOk!Uap!Ua!^!Uad!Ua`!Ua~OS!]Oe!YO!V![O!Y!`O#q$yO~Od$QP~P9dOv#{OQ#|X]#|X`#|Xd#|Xe#|Xi#|Xj#|Xk#|Xm#|Xp#|Xr#|Xt#|Xz#|X!`#|X#o#|X#p#|X#}#|Xl#|Xo#|X~O]#rO`#rOd%OOi#rOj#rOk#rO~P&lO]#rO`#rOi#rOj#rOk#rOl%PO~P&lO]#rO`#rOi#rOj#rOk#rOo%QO~P&lOe%SOS!tXk!tX!V!tX!Y!tX#q!tX~Ok%TO~Od%YOt%ZO!a%ZO~Ok%[O~Oo%cO#o%^O#}%]O~Od%dO~P$SOv#{O!^%hO!q%jOk!oi#m!oio!oi~P&lOk#ha#m#hao#ha~P!dOk!{O#m$Sio$Si~O!^%mOd$RX~P$SOd%oO~Ov#{OQ#`Xd#`Xe#`Xm#`Xp#`Xr#`Xt#`Xz#`X!^#`X!`#`X#o#`X#p#`X#}#`X~O!^%qOd#zX~P&lOd%sO~Ol%tOv#{O~OR#gOr#gOt#gO#q%vO#}!fO~O!R#iOk#jap#ja!^#ja~O`!PXd}X!R}X!^}X~O!R#iO!^%xOd$QX~O`%zO~Od%{O~O#o%|O~Ok&OO~O`&PO!R#iO~Od&ROk&QO~Od&UO~OP#zOpsX!^sXdsX~O#}%]Op#TX!^#TX~OpzO!^&WO~Oo&[O#o%^O#}%]O~Ov#{OQ#gXe#gXk#gXm#gXp#gXr#gXt#gXz#gX!^#gX!`#gX!q#gX#m#gX#o#gX#p#gX#}#gXo#gX~O!^%hO!q&`Ok!oq#m!oqo!oq~P&lOl&aOv#{O~Od#eX!^#eX~P%_O!^%mOd$Ra~Od#dX!^#dX~P&lO!^%qOd#za~Od&fO~P&lOd&gO!T&hO~Od#cX!^#cX~P9dO!^%xOd$Qa~O]&mOd&oO~OS#bae#ba!V#ba!Y#ba#q#ba~Od&qO~PG]Od&qOk&rO~Ov#{OQ#gae#gak#gam#gap#gar#gat#gaz#ga!^#ga!`#ga!q#ga#m#ga#o#ga#p#ga#}#gao#ga~Od#ea!^#ea~P$SOd#da!^#da~P&lOR#gOr#gOt#gO#q%vO#}%]O~O!R#iOd#ca!^#ca~O`&xO~O!^%xOd$Qi~P&lO]&mOd&|O~Ov#{Od|ik|i~Od&}O~PG]Ok'OO~Od'PO~O!^%xOd$Qq~Od#cq!^#cq~P&lO#s!a#t#}]#}v!m~",goto:"2h$UPPPPP$VP$YP$c$uP$cP%X$cPP%_PPP%e%o%oPPPPP%oPP%oP&]P%oP%o'W%oP't'w'}'}(^'}P'}P'}P'}'}P(m'}(yP(|PP)p)v$c)|$c*SP$cP$c$cP*Y*{+YP$YP+aP+dP$YP$YP$YP+j$YP+m+p+s+z$YP$YPP$YP,P,V,f,|-[-b-l-r-x.O.U.`.f.l.rPPPPPPPPPPP.x/R/w/z0|P1U1u2O2R2U2[RnQ_^OP`kz!{$dq[OPYZ`kuvwxz!v!{#`$d%mqSOPYZ`kuvwxz!v!{#`$d%mQpTR#RqQ!OVR#SrQ#S!QS$Q!i!jR$i#U!V!mac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'Q!U!mac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'QU#g!Y$t&hU%`$Y%b&WR&V%_!V!iac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'QR$S!kQ%W$RR&S%Xk!^]bf!Y![!g#i#j#m$P$R%X%xQ#e!YQ${#mQ%w$tQ&j%xR&w&hQ!ygQ#p!`Q$^!xR%f$`R#n!]!U!mac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'QQ!qdR$X!rQ!PVR#TrQ#S!PR$i#TQ!SWR#VsQ!UXR#WtQ{UQ!wgQ#^yQ#o!_Q$U!nQ$[!uQ$_!yQ%e$^Q&Y%aQ&]%fR&v&XSjPzQ!}kQ$c!{R%k$dZiPkz!{$dR$P!gQ%}%SR&z&mR!rdR!teR$Z!tS%a$Y%bR&t&WV%_$Y%b&WQ#PmR$g#PQ`OSkPzU!a`k$dR$d!{Q$p#aY%p$p%u&d&l'QQ%u$sQ&d%qQ&l%zR'Q&xQ#t!cQ#v!dQ#x!eV$}#t#v#xQ%X$RR&T%XQ%y$zS&k%y&yR&y&lQ%r$pR&e%rQ%n$mR&c%nQyUR#]yQ%i$aR&_%iQ!|jS$e!|$fR$f!}Q&n%}R&{&nQ#k!ZR$x#kQ%b$YR&Z%bQ&X%aR&u&X__OP`kz!{$d^UOP`kz!{$dQ!VYQ!WZQ#XuQ#YvQ#ZwQ#[xQ$]!vQ$m#`R&b%mR$q#aQ!gaQ!oc[#q!c!d!e#t#v#xQ$a!zd$o#a$p$s%q%u%z&d&l&x'QQ$r#cQ%R#{S%g$a%iQ%l$kQ&^%hR&p&P]#s!c!d!e#t#v#xW!Z]b!g$PQ!ufQ#f!YQ#l![Q$v#iQ$w#jQ$z#mS%V$R%XR&i%xQ#h!YQ%w$tR&w&hR$|#mR$n#`QlPR#_zQ!_]Q!nbQ$O!gR%U$P",nodeNames:"⚠ Unit VariableName VariableName QueryCallee Comment StyleSheet RuleSet UniversalSelector TagSelector TagName NestingSelector ClassSelector . ClassName PseudoClassSelector : :: PseudoClassName PseudoClassName ) ( ArgList ValueName ParenthesizedValue AtKeyword # ; ] [ BracketedValue } { BracedValue ColorLiteral NumberLiteral StringLiteral BinaryExpression BinOp CallExpression Callee IfExpression if ArgList IfBranch KeywordQuery FeatureQuery FeatureName BinaryQuery LogicOp ComparisonQuery CompareOp UnaryQuery UnaryQueryOp ParenthesizedQuery SelectorQuery selector ParenthesizedSelector CallQuery ArgList , CallLiteral CallTag ParenthesizedContent PseudoClassName ArgList IdSelector IdName AttributeSelector AttributeName MatchOp ChildSelector ChildOp DescendantSelector SiblingSelector SiblingOp Block Declaration PropertyName Important ImportStatement import Layer layer LayerName layer MediaStatement media CharsetStatement charset NamespaceStatement namespace NamespaceName KeyframesStatement keyframes KeyframeName KeyframeList KeyframeSelector KeyframeRangeName SupportsStatement supports ScopeStatement scope to AtRule Styles",maxTerm:143,nodeProps:[["isolate",-2,5,36,""],["openedBy",20,"(",28,"[",31,"{"],["closedBy",21,")",29,"]",32,"}"]],propSources:[yI],skippedNodes:[0,5,106],repeatNodeCount:15,tokenData:"JQ~R!YOX$qX^%i^p$qpq%iqr({rs-ust/itu6Wuv$qvw7Qwx7cxy9Qyz9cz{9h{|:R|}>t}!O?V!O!P?t!P!Q@]!Q![AU![!]BP!]!^B{!^!_C^!_!`DY!`!aDm!a!b$q!b!cEn!c!}$q!}#OG{#O#P$q#P#QH^#Q#R6W#R#o$q#o#pHo#p#q6W#q#rIQ#r#sIc#s#y$q#y#z%i#z$f$q$f$g%i$g#BY$q#BY#BZ%i#BZ$IS$q$IS$I_%i$I_$I|$q$I|$JO%i$JO$JT$q$JT$JU%i$JU$KV$q$KV$KW%i$KW&FU$q&FU&FV%i&FV;'S$q;'S;=`Iz<%lO$q`$tSOy%Qz;'S%Q;'S;=`%c<%lO%Q`%VS!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Q`%fP;=`<%l%Q~%nh#s~OX%QX^'Y^p%Qpq'Yqy%Qz#y%Q#y#z'Y#z$f%Q$f$g'Y$g#BY%Q#BY#BZ'Y#BZ$IS%Q$IS$I_'Y$I_$I|%Q$I|$JO'Y$JO$JT%Q$JT$JU'Y$JU$KV%Q$KV$KW'Y$KW&FU%Q&FU&FV'Y&FV;'S%Q;'S;=`%c<%lO%Q~'ah#s~!a`OX%QX^'Y^p%Qpq'Yqy%Qz#y%Q#y#z'Y#z$f%Q$f$g'Y$g#BY%Q#BY#BZ'Y#BZ$IS%Q$IS$I_'Y$I_$I|%Q$I|$JO'Y$JO$JT%Q$JT$JU'Y$JU$KV%Q$KV$KW'Y$KW&FU%Q&FU&FV'Y&FV;'S%Q;'S;=`%c<%lO%Qj)OUOy%Qz#]%Q#]#^)b#^;'S%Q;'S;=`%c<%lO%Qj)gU!a`Oy%Qz#a%Q#a#b)y#b;'S%Q;'S;=`%c<%lO%Qj*OU!a`Oy%Qz#d%Q#d#e*b#e;'S%Q;'S;=`%c<%lO%Qj*gU!a`Oy%Qz#c%Q#c#d*y#d;'S%Q;'S;=`%c<%lO%Qj+OU!a`Oy%Qz#f%Q#f#g+b#g;'S%Q;'S;=`%c<%lO%Qj+gU!a`Oy%Qz#h%Q#h#i+y#i;'S%Q;'S;=`%c<%lO%Qj,OU!a`Oy%Qz#T%Q#T#U,b#U;'S%Q;'S;=`%c<%lO%Qj,gU!a`Oy%Qz#b%Q#b#c,y#c;'S%Q;'S;=`%c<%lO%Qj-OU!a`Oy%Qz#h%Q#h#i-b#i;'S%Q;'S;=`%c<%lO%Qj-iS!qY!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Q~-xWOY-uZr-urs.bs#O-u#O#P.g#P;'S-u;'S;=`/c<%lO-u~.gOt~~.jRO;'S-u;'S;=`.s;=`O-u~.vXOY-uZr-urs.bs#O-u#O#P.g#P;'S-u;'S;=`/c;=`<%l-u<%lO-u~/fP;=`<%l-uj/nYjYOy%Qz!Q%Q!Q![0^![!c%Q!c!i0^!i#T%Q#T#Z0^#Z;'S%Q;'S;=`%c<%lO%Qj0cY!a`Oy%Qz!Q%Q!Q![1R![!c%Q!c!i1R!i#T%Q#T#Z1R#Z;'S%Q;'S;=`%c<%lO%Qj1WY!a`Oy%Qz!Q%Q!Q![1v![!c%Q!c!i1v!i#T%Q#T#Z1v#Z;'S%Q;'S;=`%c<%lO%Qj1}YrY!a`Oy%Qz!Q%Q!Q![2m![!c%Q!c!i2m!i#T%Q#T#Z2m#Z;'S%Q;'S;=`%c<%lO%Qj2tYrY!a`Oy%Qz!Q%Q!Q![3d![!c%Q!c!i3d!i#T%Q#T#Z3d#Z;'S%Q;'S;=`%c<%lO%Qj3iY!a`Oy%Qz!Q%Q!Q![4X![!c%Q!c!i4X!i#T%Q#T#Z4X#Z;'S%Q;'S;=`%c<%lO%Qj4`YrY!a`Oy%Qz!Q%Q!Q![5O![!c%Q!c!i5O!i#T%Q#T#Z5O#Z;'S%Q;'S;=`%c<%lO%Qj5TY!a`Oy%Qz!Q%Q!Q![5s![!c%Q!c!i5s!i#T%Q#T#Z5s#Z;'S%Q;'S;=`%c<%lO%Qj5zSrY!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Qd6ZUOy%Qz!_%Q!_!`6m!`;'S%Q;'S;=`%c<%lO%Qd6tS!hS!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Qb7VSZQOy%Qz;'S%Q;'S;=`%c<%lO%Q~7fWOY7cZw7cwx.bx#O7c#O#P8O#P;'S7c;'S;=`8z<%lO7c~8RRO;'S7c;'S;=`8[;=`O7c~8_XOY7cZw7cwx.bx#O7c#O#P8O#P;'S7c;'S;=`8z;=`<%l7c<%lO7c~8}P;=`<%l7cj9VSeYOy%Qz;'S%Q;'S;=`%c<%lO%Q~9hOd~n9oUWQvWOy%Qz!_%Q!_!`6m!`;'S%Q;'S;=`%c<%lO%Qj:YWvW!mQOy%Qz!O%Q!O!P:r!P!Q%Q!Q![=w![;'S%Q;'S;=`%c<%lO%Qj:wU!a`Oy%Qz!Q%Q!Q![;Z![;'S%Q;'S;=`%c<%lO%Qj;bY!a`#}YOy%Qz!Q%Q!Q![;Z![!g%Q!g!h<Q!h#X%Q#X#Y<Q#Y;'S%Q;'S;=`%c<%lO%Qj<VY!a`Oy%Qz{%Q{|<u|}%Q}!O<u!O!Q%Q!Q![=^![;'S%Q;'S;=`%c<%lO%Qj<zU!a`Oy%Qz!Q%Q!Q![=^![;'S%Q;'S;=`%c<%lO%Qj=eU!a`#}YOy%Qz!Q%Q!Q![=^![;'S%Q;'S;=`%c<%lO%Qj>O[!a`#}YOy%Qz!O%Q!O!P;Z!P!Q%Q!Q![=w![!g%Q!g!h<Q!h#X%Q#X#Y<Q#Y;'S%Q;'S;=`%c<%lO%Qj>yS!^YOy%Qz;'S%Q;'S;=`%c<%lO%Qj?[WvWOy%Qz!O%Q!O!P:r!P!Q%Q!Q![=w![;'S%Q;'S;=`%c<%lO%Qj?yU]YOy%Qz!Q%Q!Q![;Z![;'S%Q;'S;=`%c<%lO%Q~@bTvWOy%Qz{@q{;'S%Q;'S;=`%c<%lO%Q~@xS!a`#t~Oy%Qz;'S%Q;'S;=`%c<%lO%QjAZ[#}YOy%Qz!O%Q!O!P;Z!P!Q%Q!Q![=w![!g%Q!g!h<Q!h#X%Q#X#Y<Q#Y;'S%Q;'S;=`%c<%lO%QjBUU`YOy%Qz![%Q![!]Bh!];'S%Q;'S;=`%c<%lO%QbBoSaQ!a`Oy%Qz;'S%Q;'S;=`%c<%lO%QjCQSkYOy%Qz;'S%Q;'S;=`%c<%lO%QhCcU!TWOy%Qz!_%Q!_!`Cu!`;'S%Q;'S;=`%c<%lO%QhC|S!TW!a`Oy%Qz;'S%Q;'S;=`%c<%lO%QlDaS!TW!hSOy%Qz;'S%Q;'S;=`%c<%lO%QjDtV!jQ!TWOy%Qz!_%Q!_!`Cu!`!aEZ!a;'S%Q;'S;=`%c<%lO%QbEbS!jQ!a`Oy%Qz;'S%Q;'S;=`%c<%lO%QjEqYOy%Qz}%Q}!OFa!O!c%Q!c!}GO!}#T%Q#T#oGO#o;'S%Q;'S;=`%c<%lO%QjFfW!a`Oy%Qz!c%Q!c!}GO!}#T%Q#T#oGO#o;'S%Q;'S;=`%c<%lO%QjGV[iY!a`Oy%Qz}%Q}!OGO!O!Q%Q!Q![GO![!c%Q!c!}GO!}#T%Q#T#oGO#o;'S%Q;'S;=`%c<%lO%QjHQSmYOy%Qz;'S%Q;'S;=`%c<%lO%QnHcSl^Oy%Qz;'S%Q;'S;=`%c<%lO%QjHtSpYOy%Qz;'S%Q;'S;=`%c<%lO%QjIVSoYOy%Qz;'S%Q;'S;=`%c<%lO%QfIhU!mQOy%Qz!_%Q!_!`6m!`;'S%Q;'S;=`%c<%lO%Q`I}P;=`<%l$q",tokenizers:[AI,bI,mI,vI,1,2,3,4,new YR("m~RRYZ[z{a~~g~aO#v~~dP!P!Qg~lO#w~~",28,129)],topRules:{StyleSheet:[0,6],Styles:[1,105]},specialized:[{term:124,get:e=>xI[e]||-1},{term:125,get:e=>wI[e]||-1},{term:4,get:e=>CI[e]||-1},{term:25,get:e=>kI[e]||-1},{term:123,get:e=>SI[e]||-1}],tokenPrec:1963});let BI=null;function _I(){if(!BI&&"object"==typeof document&&document.body){let{style:e}=document.body,t=[],n=new Set;for(let r in e)"cssText"!=r&&"cssFloat"!=r&&"string"==typeof e[r]&&(/[A-Z]/.test(r)&&(r=r.replace(/[A-Z]/g,e=>"-"+e.toLowerCase())),n.has(r)||(t.push(r),n.add(r)));BI=t.sort().map(e=>({type:"property",label:e,apply:e+": "}))}return BI||[]}const TI=["active","after","any-link","autofill","backdrop","before","checked","cue","default","defined","disabled","empty","enabled","file-selector-button","first","first-child","first-letter","first-line","first-of-type","focus","focus-visible","focus-within","fullscreen","has","host","host-context","hover","in-range","indeterminate","invalid","is","lang","last-child","last-of-type","left","link","marker","modal","not","nth-child","nth-last-child","nth-last-of-type","nth-of-type","only-child","only-of-type","optional","out-of-range","part","placeholder","placeholder-shown","read-only","read-write","required","right","root","scope","selection","slotted","target","target-text","valid","visited","where"].map(e=>({type:"class",label:e})),EI=["above","absolute","activeborder","additive","activecaption","after-white-space","ahead","alias","all","all-scroll","alphabetic","alternate","always","antialiased","appworkspace","asterisks","attr","auto","auto-flow","avoid","avoid-column","avoid-page","avoid-region","axis-pan","background","backwards","baseline","below","bidi-override","blink","block","block-axis","bold","bolder","border","border-box","both","bottom","break","break-all","break-word","bullets","button","button-bevel","buttonface","buttonhighlight","buttonshadow","buttontext","calc","capitalize","caps-lock-indicator","caption","captiontext","caret","cell","center","checkbox","circle","cjk-decimal","clear","clip","close-quote","col-resize","collapse","color","color-burn","color-dodge","column","column-reverse","compact","condensed","contain","content","contents","content-box","context-menu","continuous","copy","counter","counters","cover","crop","cross","crosshair","currentcolor","cursive","cyclic","darken","dashed","decimal","decimal-leading-zero","default","default-button","dense","destination-atop","destination-in","destination-out","destination-over","difference","disc","discard","disclosure-closed","disclosure-open","document","dot-dash","dot-dot-dash","dotted","double","down","e-resize","ease","ease-in","ease-in-out","ease-out","element","ellipse","ellipsis","embed","end","ethiopic-abegede-gez","ethiopic-halehame-aa-er","ethiopic-halehame-gez","ew-resize","exclusion","expanded","extends","extra-condensed","extra-expanded","fantasy","fast","fill","fill-box","fixed","flat","flex","flex-end","flex-start","footnotes","forwards","from","geometricPrecision","graytext","grid","groove","hand","hard-light","help","hidden","hide","higher","highlight","highlighttext","horizontal","hsl","hsla","hue","icon","ignore","inactiveborder","inactivecaption","inactivecaptiontext","infinite","infobackground","infotext","inherit","initial","inline","inline-axis","inline-block","inline-flex","inline-grid","inline-table","inset","inside","intrinsic","invert","italic","justify","keep-all","landscape","large","larger","left","level","lighter","lighten","line-through","linear","linear-gradient","lines","list-item","listbox","listitem","local","logical","loud","lower","lower-hexadecimal","lower-latin","lower-norwegian","lowercase","ltr","luminosity","manipulation","match","matrix","matrix3d","medium","menu","menutext","message-box","middle","min-intrinsic","mix","monospace","move","multiple","multiple_mask_images","multiply","n-resize","narrower","ne-resize","nesw-resize","no-close-quote","no-drop","no-open-quote","no-repeat","none","normal","not-allowed","nowrap","ns-resize","numbers","numeric","nw-resize","nwse-resize","oblique","opacity","open-quote","optimizeLegibility","optimizeSpeed","outset","outside","outside-shape","overlay","overline","padding","padding-box","painted","page","paused","perspective","pinch-zoom","plus-darker","plus-lighter","pointer","polygon","portrait","pre","pre-line","pre-wrap","preserve-3d","progress","push-button","radial-gradient","radio","read-only","read-write","read-write-plaintext-only","rectangle","region","relative","repeat","repeating-linear-gradient","repeating-radial-gradient","repeat-x","repeat-y","reset","reverse","rgb","rgba","ridge","right","rotate","rotate3d","rotateX","rotateY","rotateZ","round","row","row-resize","row-reverse","rtl","run-in","running","s-resize","sans-serif","saturation","scale","scale3d","scaleX","scaleY","scaleZ","screen","scroll","scrollbar","scroll-position","se-resize","self-start","self-end","semi-condensed","semi-expanded","separate","serif","show","single","skew","skewX","skewY","skip-white-space","slide","slider-horizontal","slider-vertical","sliderthumb-horizontal","sliderthumb-vertical","slow","small","small-caps","small-caption","smaller","soft-light","solid","source-atop","source-in","source-out","source-over","space","space-around","space-between","space-evenly","spell-out","square","start","static","status-bar","stretch","stroke","stroke-box","sub","subpixel-antialiased","svg_masks","super","sw-resize","symbolic","symbols","system-ui","table","table-caption","table-cell","table-column","table-column-group","table-footer-group","table-header-group","table-row","table-row-group","text","text-bottom","text-top","textarea","textfield","thick","thin","threeddarkshadow","threedface","threedhighlight","threedlightshadow","threedshadow","to","top","transform","translate","translate3d","translateX","translateY","translateZ","transparent","ultra-condensed","ultra-expanded","underline","unidirectional-pan","unset","up","upper-latin","uppercase","url","var","vertical","vertical-text","view-box","visible","visibleFill","visiblePainted","visibleStroke","visual","w-resize","wait","wave","wider","window","windowframe","windowtext","words","wrap","wrap-reverse","x-large","x-small","xor","xx-large","xx-small"].map(e=>({type:"keyword",label:e})).concat(["aliceblue","antiquewhite","aqua","aquamarine","azure","beige","bisque","black","blanchedalmond","blue","blueviolet","brown","burlywood","cadetblue","chartreuse","chocolate","coral","cornflowerblue","cornsilk","crimson","cyan","darkblue","darkcyan","darkgoldenrod","darkgray","darkgreen","darkkhaki","darkmagenta","darkolivegreen","darkorange","darkorchid","darkred","darksalmon","darkseagreen","darkslateblue","darkslategray","darkturquoise","darkviolet","deeppink","deepskyblue","dimgray","dodgerblue","firebrick","floralwhite","forestgreen","fuchsia","gainsboro","ghostwhite","gold","goldenrod","gray","grey","green","greenyellow","honeydew","hotpink","indianred","indigo","ivory","khaki","lavender","lavenderblush","lawngreen","lemonchiffon","lightblue","lightcoral","lightcyan","lightgoldenrodyellow","lightgray","lightgreen","lightpink","lightsalmon","lightseagreen","lightskyblue","lightslategray","lightsteelblue","lightyellow","lime","limegreen","linen","magenta","maroon","mediumaquamarine","mediumblue","mediumorchid","mediumpurple","mediumseagreen","mediumslateblue","mediumspringgreen","mediumturquoise","mediumvioletred","midnightblue","mintcream","mistyrose","moccasin","navajowhite","navy","oldlace","olive","olivedrab","orange","orangered","orchid","palegoldenrod","palegreen","paleturquoise","palevioletred","papayawhip","peachpuff","peru","pink","plum","powderblue","purple","rebeccapurple","red","rosybrown","royalblue","saddlebrown","salmon","sandybrown","seagreen","seashell","sienna","silver","skyblue","slateblue","slategray","snow","springgreen","steelblue","tan","teal","thistle","tomato","turquoise","violet","wheat","white","whitesmoke","yellow","yellowgreen"].map(e=>({type:"constant",label:e}))),MI=["a","abbr","address","article","aside","b","bdi","bdo","blockquote","body","br","button","canvas","caption","cite","code","col","colgroup","dd","del","details","dfn","dialog","div","dl","dt","em","figcaption","figure","footer","form","header","hgroup","h1","h2","h3","h4","h5","h6","hr","html","i","iframe","img","input","ins","kbd","label","legend","li","main","meter","nav","ol","output","p","pre","ruby","section","select","small","source","span","strong","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","tr","u","ul"].map(e=>({type:"type",label:e})),DI=["@charset","@color-profile","@container","@counter-style","@font-face","@font-feature-values","@font-palette-values","@import","@keyframes","@layer","@media","@namespace","@page","@position-try","@property","@scope","@starting-style","@supports","@view-transition"].map(e=>({type:"keyword",label:e})),PI=/^(\w[\w-]*|-\w[\w-]*|)$/,RI=/^-(-[\w-]*)?$/;const II=new o_,NI=["Declaration"];function LI(e){for(let t=e;;){if(t.type.isTop)return t;if(!(t=t.parent))return e}}function QI(e,t,n){if(t.to-t.from>4096){let r=II.get(t);if(r)return r;let i=[],o=new Set,s=t.cursor(VB.IncludeAnonymous);if(s.firstChild())do{for(let t of QI(e,s.node,n))o.has(t.label)||(o.add(t.label),i.push(t))}while(s.nextSibling());return II.set(t,i),i}{let r=[],i=new Set;return t.cursor().iterate(t=>{var o;if(n(t)&&t.matchContext(NI)&&":"==(null===(o=t.node.nextSibling)||void 0===o?void 0:o.name)){let n=e.sliceString(t.from,t.to);i.has(n)||(i.add(n),r.push({label:n,type:"variable"}))}}),r}}const FI=e=>t=>{let{state:n,pos:r}=t,i=W_(n).resolveInner(r,-1),o=i.type.isError&&i.from==i.to-1&&"-"==n.doc.sliceString(i.from,i.to);if("PropertyName"==i.name||(o||"TagName"==i.name)&&/^(Block|Styles)$/.test(i.resolve(i.to).name))return{from:i.from,options:_I(),validFor:PI};if("ValueName"==i.name)return{from:i.from,options:EI,validFor:PI};if("PseudoClassName"==i.name)return{from:i.from,options:TI,validFor:PI};if(e(i)||(t.explicit||o)&&function(e,t){var n;if(("("==e.name||e.type.isError)&&(e=e.parent||e),"ArgList"!=e.name)return!1;let r=null===(n=e.parent)||void 0===n?void 0:n.firstChild;return"Callee"==(null==r?void 0:r.name)&&"var"==t.sliceString(r.from,r.to)}(i,n.doc))return{from:e(i)||o?i.from:r,options:QI(n.doc,LI(i),e),validFor:RI};if("TagName"==i.name){for(let{parent:e}=i;e;e=e.parent)if("Block"==e.name)return{from:i.from,options:_I(),validFor:PI};return{from:i.from,options:MI,validFor:PI}}if("AtKeyword"==i.name)return{from:i.from,options:DI,validFor:PI};if(!t.explicit)return null;let s=i.resolve(r),a=s.childBefore(r);return a&&":"==a.name&&"PseudoClassSelector"==s.name?{from:r,options:TI,validFor:PI}:a&&":"==a.name&&"Declaration"==s.name||"ArgList"==s.name?{from:r,options:EI,validFor:PI}:"Block"==s.name||"Styles"==s.name?{from:r,options:_I(),validFor:PI}:null},VI=FI(e=>"VariableName"==e.name),zI=z_.define({name:"css",parser:OI.configure({props:[oT.add({Declaration:uT()}),fT.add({"Block KeyframeList":function(e){let t=e.firstChild,n=e.lastChild;return t&&t.to<n.from?{from:t.to,to:n.type.isError?e.to:n.from}:null}})]}),languageData:{commentTokens:{block:{open:"/*",close:"*/"}},indentOnInput:/^\s*\}$/,wordChars:"-"}});function WI(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(e){if("string"==typeof e)return $I(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?$I(e,t):void 0}}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,i=function(){};return{s:i,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:i}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,s=!0,a=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return s=e.done,e},e:function(e){a=!0,o=e},f:function(){try{s||null==n.return||n.return()}finally{if(a)throw o}}}}function $I(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var HI={class:"trp-custom-css-editor"},jI={key:0,class:"trp-field__label trp-primary-text-bold"};const qI={__name:"CustomCssAreaField",props:{label:{type:String,default:""},visible:{type:Boolean,default:!1},modelValue:{type:String,default:""}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o=Gt(r.modelValue),s=Gt(""),a=[new K_(zI,zI.data.of({autocomplete:VI}))],l=Yt(null),c=function(e){var t,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:300;return function(){for(var r=arguments.length,i=new Array(r),o=0;o<r;o++)i[o]=arguments[o];clearTimeout(t),t=setTimeout(function(){e.apply(void 0,i)},n)}}(function(e){var t=f(e);s.value=t,i("update:modelValue",t)},300);ur(function(){return r.modelValue},function(e){e!==s.value&&e!==o.value&&(o.value=e)}),ur(o,function(e){return c(e)}),ur(s,function(e){h&&(h.textContent=e)});var d=function(e){var t=e.view;return l.value=t},h=null,u=function(){!h&&r.visible&&((h=document.createElement("style")).dataset.customCss="",h.textContent=f(o.value),document.head.appendChild(h))},p=function(){h&&(h.remove(),h=null)},f=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:".trp-language-switcher",n=document.createElement("style");n.textContent=e,document.head.appendChild(n);var r=n.sheet;document.head.removeChild(n);var i,o=[],s=WI(r.cssRules);try{for(s.s();!(i=s.n()).done;){var a=i.value;if(a instanceof CSSStyleRule){var l=a.selectorText.split(",").map(function(e){return(e=e.trim()).startsWith(t)?e:"".concat(t," ").concat(e)}).join(", ");o.push("".concat(l," { ").concat(a.style.cssText," }"))}else if(a instanceof CSSMediaRule){var c,d=[],h=WI(a.cssRules);try{for(h.s();!(c=h.n()).done;){var u=c.value;if(u instanceof CSSStyleRule){var p=u.selectorText.split(",").map(function(e){return(e=e.trim()).startsWith(t)?e:"".concat(t," ").concat(e)}).join(", ");d.push("".concat(p," { ").concat(u.style.cssText," }"))}else d.push(u.cssText)}}catch(e){h.e(e)}finally{h.f()}o.push("@media ".concat(a.media.mediaText," {\n").concat(d.join("\n"),"\n}"))}else o.push(a.cssText)}}catch(e){s.e(e)}finally{s.f()}return o.join("\n")};return ur(function(){return r.visible},function(e){e?u():p()}),Ei(function(){r.visible&&u()}),Pi(p),function(t,n){return nr((Ms(),Ls("div",HI,[e.label?(Ms(),Ls("label",jI,pe(e.label),1)):Js("",!0),js(Zt(QR),{modelValue:o.value,"onUpdate:modelValue":n[0]||(n[0]=function(e){return o.value=e}),placeholder:"Write custom CSS here...",style:{height:"250px",width:"80%",fontSize:"14px",fontFamily:"monospace"},"indent-with-tab":!0,"tab-size":2,extensions:a,onReady:d},null,8,["modelValue"])],512)),[[ml,e.visible]])}}};var UI=n(793),GI={insert:"head",singleton:!1};Tg()(UI.A,GI);UI.A.locals;const YI=qI;var XI=Rt({floater:"desktop",shortcode:"desktop"});function JI(e){e&&XI.hasOwnProperty(e)||(console.warn("Attempted to use usePreviewViewport with unknown or missing scope: ".concat(e,". Defaulting to 'desktop'.")),XI[e]="desktop");return{selectedViewport:_a(function(){return XI[e]}),setViewport:function(t){XI.hasOwnProperty(e)?XI[e]=t:console.warn("Attempted to set viewport for unknown scope: ".concat(e))}}}function KI(e){return KI="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},KI(e)}function ZI(e){return function(e){if(Array.isArray(e))return eN(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return eN(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?eN(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function eN(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}function tN(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function nN(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?tN(Object(n),!0).forEach(function(t){rN(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):tN(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}function rN(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=KI(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=KI(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==KI(t)?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}var iN={class:"trp-layout-customizer-field trp-field trp-field--column"},oN={key:0,class:"trp-field__label trp-primary-text-bold"},sN={key:1,class:"trp-settings-separator"},aN={class:"trp-lc-mode-toggle"},lN={class:"trp-lc-settings-panel"},cN={key:0,class:"trp-lc-section"},dN={class:"trp-lc-subfield"},hN={class:"trp-lc-subfield"},uN={class:"trp-lc-subfield"},pN={class:"trp-lc-subfield"},fN={key:1,class:"trp-lc-subfield"},gN={class:"trp-lc-subfield"},mN={key:1,class:"trp-lc-section"},vN={class:"trp-lc-subfield"},AN={class:"trp-lc-subfield"},bN={class:"trp-lc-subfield"},yN={class:"trp-lc-subfield"},xN={key:1,class:"trp-lc-subfield"},wN={class:"trp-lc-subfield"};const CN={__name:"LayoutCustomizerField",props:{label:{type:String,default:""},modelValue:{type:Object,default:function(){return{desktop:{},mobile:{}}}},scope:{type:String,required:!0}},emits:["update:modelValue","update:customValue"],setup:function(e,t){var n=t.emit,r=[{value:"bottom-right",label:"Bottom Right"},{value:"bottom-left",label:"Bottom Left"},{value:"top-right",label:"Top Right"},{value:"top-left",label:"Top Left"}],i=[{value:"before",label:"Before Language"},{value:"after",label:"After Language"},{value:"hide",label:"Hide Icons"}],o=[{value:"rect",label:"Rectangle 4:3"},{value:"square",label:"Square 1:1"},{value:"rounded",label:"Rounded"}],s=[{value:"full",label:"Full Names"},{value:"short",label:"Short Names"},{value:"none",label:"No Names"}],a=e,l=n,c=Rt({desktop:nN({},a.modelValue.desktop),mobile:nN({},a.modelValue.mobile)});ur(function(){return c},function(e){l("update:modelValue",{desktop:nN({},e.desktop),mobile:nN({},e.mobile)})},{deep:!0}),ur(function(){return a.modelValue},function(e){e.desktop&&Object.assign(c.desktop,e.desktop),e.mobile&&Object.assign(c.mobile,e.mobile)});var d=JI(a.scope),h=d.selectedViewport,u=d.setViewport,p=(a.scope,"menu"===a.scope),f="floater"===a.scope;return function(t,n){return Ms(),Ls("div",iN,[e.label?(Ms(),Ls("span",oN,pe(e.label),1)):Js("",!0),"menu"===e.scope?(Ms(),Ls("div",sN)):Js("",!0),Hs("div",aN,[Hs("button",{class:X(["trp-lc-mode-button",{active:"desktop"===Zt(h)}]),onClick:n[0]||(n[0]=function(e){return Zt(u)("desktop")}),type:"button"},ZI(n[18]||(n[18]=[Hs("svg",{width:"20",height:"20",viewBox:"0 0 20 20",fill:"none",xmlns:"http://www.w3.org/2000/svg"},[Hs("path",{"fill-rule":"evenodd","clip-rule":"evenodd",d:"M3 2H17C17.55 2 18 2.45 18 3V13C18 13.55 17.55 14 17 14H12V16H14\r\n                   C14.55 16 15 16.45 15 17V18H5V17C5 16.45 5.45 16 6 16H8V14H3\r\n                   C2.45 14 2 13.55 2 13V3C2 2.45 2.45 2 3 2ZM16 11V4H4V11H16Z",fill:"#1D2327"})],-1),Hs("span",null,"Desktop",-1)])),2),Hs("button",{class:X(["trp-lc-mode-button",{active:"mobile"===Zt(h)}]),onClick:n[1]||(n[1]=function(e){return Zt(u)("mobile")}),type:"button"},ZI(n[19]||(n[19]=[Hs("svg",{width:"20",height:"20",viewBox:"0 0 20 20",fill:"none",xmlns:"http://www.w3.org/2000/svg"},[Hs("path",{"fill-rule":"evenodd","clip-rule":"evenodd",d:"M6 2H14C14.55 2 15 2.45 15 3V17C15 17.55 14.55 18 14 18H6\r\n                   C5.45 18 5 17.55 5 17V3C5 2.45 5.45 2 6 2ZM13 14V4H7V14H13Z",fill:"#1D2327"})],-1),Hs("span",null,"Mobile",-1)])),2)]),Hs("div",lN,["desktop"===Zt(h)?(Ms(),Ls("div",cN,[f?(Ms(),Ls(Ss,{key:0},[Hs("div",dN,[js(ub,{label:"Switcher Position",modelValue:c.desktop.position,"onUpdate:modelValue":n[2]||(n[2]=function(e){return c.desktop.position=e}),options:r},null,8,["modelValue"])]),Hs("div",hN,[js(ub,{label:"Switcher Width",modelValue:c.desktop.width,"onUpdate:modelValue":n[3]||(n[3]=function(e){return c.desktop.width=e}),customValue:c.desktop.customWidth,"onUpdate:customValue":n[4]||(n[4]=function(e){return c.desktop.customWidth=e}),options:[{value:"default",label:"Default"}]},null,8,["modelValue","customValue"])]),Hs("div",uN,[js(ub,{label:"Switcher Padding",modelValue:c.desktop.padding,"onUpdate:modelValue":n[5]||(n[5]=function(e){return c.desktop.padding=e}),customValue:c.desktop.customPadding,"onUpdate:customValue":n[6]||(n[6]=function(e){return c.desktop.customPadding=e}),options:[{value:"default",label:"Default"}]},null,8,["modelValue","customValue"])])],64)):Js("",!0),Hs("div",pN,[js(ub,{label:"Flag Icons Position",modelValue:c.desktop.flagIconPosition,"onUpdate:modelValue":n[7]||(n[7]=function(e){return c.desktop.flagIconPosition=e}),options:i},null,8,["modelValue"])]),p?(Ms(),Ls("div",fN,[js(ub,{label:"Flag icons",modelValue:c.desktop.flagShape,"onUpdate:modelValue":n[8]||(n[8]=function(e){return c.desktop.flagShape=e}),options:o},null,8,["modelValue"])])):Js("",!0),Hs("div",gN,[js(ub,{label:"Language Names",modelValue:c.desktop.languageNames,"onUpdate:modelValue":n[9]||(n[9]=function(e){return c.desktop.languageNames=e}),options:s},null,8,["modelValue"])])])):(Ms(),Ls("div",mN,[f?(Ms(),Ls(Ss,{key:0},[Hs("div",vN,[js(ub,{label:"Switcher Position",modelValue:c.mobile.position,"onUpdate:modelValue":n[10]||(n[10]=function(e){return c.mobile.position=e}),options:r},null,8,["modelValue"])]),Hs("div",AN,[js(ub,{label:"Switcher Width",modelValue:c.mobile.width,"onUpdate:modelValue":n[11]||(n[11]=function(e){return c.mobile.width=e}),customValue:c.mobile.customWidth,"onUpdate:customValue":n[12]||(n[12]=function(e){return c.mobile.customWidth=e}),options:[{value:"default",label:"Default"}]},null,8,["modelValue","customValue"])]),Hs("div",bN,[js(ub,{label:"Switcher Padding",modelValue:c.mobile.padding,"onUpdate:modelValue":n[13]||(n[13]=function(e){return c.mobile.padding=e}),customValue:c.mobile.customPadding,"onUpdate:customValue":n[14]||(n[14]=function(e){return c.mobile.customPadding=e}),options:[{value:"default",label:"Default"}]},null,8,["modelValue","customValue"])])],64)):Js("",!0),Hs("div",yN,[js(ub,{label:"Flag Icons Position",modelValue:c.mobile.flagIconPosition,"onUpdate:modelValue":n[15]||(n[15]=function(e){return c.mobile.flagIconPosition=e}),options:i},null,8,["modelValue"])]),p?(Ms(),Ls("div",xN,[js(ub,{label:"Flag icons",modelValue:c.desktop.flagShape,"onUpdate:modelValue":n[16]||(n[16]=function(e){return c.desktop.flagShape=e}),options:o},null,8,["modelValue"])])):Js("",!0),Hs("div",wN,[js(ub,{label:"Language Names",modelValue:c.mobile.languageNames,"onUpdate:modelValue":n[17]||(n[17]=function(e){return c.mobile.languageNames=e}),options:s},null,8,["modelValue"])])]))])])}}};var kN=n(85),SN={insert:"head",singleton:!1};Tg()(kN.A,SN);kN.A.locals;const ON=(0,PA.A)(CN,[["__scopeId","data-v-446a0a1f"]]);var BN=["title"],_N=["disabled"],TN={class:"trp-checkbox-content"},EN={key:0,class:"trp-primary-text-bold"},MN=["innerHTML"];const DN={__name:"CheckboxField",props:{modelValue:{type:Boolean,required:!0},label:{type:String,default:""},description:{type:String,default:""},disabled:{type:Boolean,default:!1},title:{type:String,default:""}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o="trp-checkbox-".concat(Math.random().toString(36).slice(2)),s=_a({get:function(){return!0===r.modelValue},set:function(e){return i("update:modelValue",e)}});return function(t,n){return Ms(),Ls("div",{class:"trp-settings-checkbox trp-settings-options-item",title:r.title},[nr(Hs("input",{type:"checkbox",id:o,"onUpdate:modelValue":n[0]||(n[0]=function(e){return s.value=e}),disabled:r.disabled},null,8,_N),[[lc,s.value]]),Hs("label",{for:o,class:"trp-checkbox-label"},[Hs("div",TN,[e.label?(Ms(),Ls("span",EN,pe(e.label),1)):Js("",!0),e.description?(Ms(),Ls("span",{key:1,class:"trp-description-text",innerHTML:e.description},null,8,MN)):Js("",!0)])])],8,BN)}}};var PN=n(482),RN={insert:"head",singleton:!1};Tg()(PN.A,RN);PN.A.locals;const IN=(0,PA.A)(DN,[["__scopeId","data-v-2e0e42ea"]]);function NN(e){return NN="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},NN(e)}function LN(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function QN(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?LN(Object(n),!0).forEach(function(t){FN(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):LN(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}function FN(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=NN(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=NN(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==NN(t)?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function VN(e){return function(e){if(Array.isArray(e))return zN(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return zN(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?zN(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function zN(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var WN={class:"trp-title"},$N={class:"trp-body"},HN={key:0,class:"trp-separator"};const jN={__name:"SettingsBox",props:{title:{type:String,required:!0},fields:{type:Array,required:!1,default:[]},collapsible:{type:Boolean,default:!1},scope:{type:String,required:!0}},setup:function(e){var t={color:RA,number:zA,toggle:GA,toggleStatus:eb,radio:ub,quadNumber:wb,customCss:YI,lCustomizer:ON,checkbox:IN},n=e,r=Og(n.scope),i=Gt(!n.collapsible),o=Rt({});return n.fields.forEach(function(e){"separator"===e.type||o[e.key]||(void 0===r[e.key]&&void 0!==e.default&&(r[e.key]=e.default),o[e.key]=_a({get:function(){return r[e.key]},set:function(t){return r[e.key]=t}}))}),function(s,a){return Ms(),Ls("div",{class:X(["trp-settings-box",{"trp-collapsible":n.collapsible}])},[Hs("header",{class:"trp-header",onClick:a[0]||(a[0]=function(e){return n.collapsible&&(i.value=!i.value)})},[Hs("span",WN,pe(n.title),1),n.collapsible?(Ms(),Ls("svg",{key:0,class:X(["trp-chevron",{open:i.value}]),viewBox:"0 0 20 20",width:"20",height:"20"},VN(a[1]||(a[1]=[Hs("path",{d:"M5 6L10 11L15 6L17 7L10 14L3 7L5 6Z",fill:"#9CA1A8"},null,-1)])),2)):Js("",!0)]),nr(Hs("section",$N,[s.$slots.default?Gi(s.$slots,"default",{key:0}):Js("",!0),(Ms(!0),Ls(Ss,null,qi(n.fields,function(n){return Ms(),Ls(Ss,{key:n.key||n.type},["separator"===n.type?(Ms(),Ls("div",HN)):(Ms(),Qs(Wi(t[n.type]),ta({key:1,modelValue:o[n.key],"onUpdate:modelValue":function(e){return o[n.key]=e}},{ref_for:!0},QN(QN({},n),{},{visible:!n.visible||n.visible(Zt(r))}),{scope:e.scope,class:["trp-field",n.hasOwnProperty("layout")?"trp-field--column":"trp-field--row"]}),null,16,["modelValue","onUpdate:modelValue","scope","class"]))],64)}),128)),Gi(s.$slots,"end")],512),[[ml,i.value]])],2)}}};var qN=n(751),UN={insert:"head",singleton:!1};Tg()(qN.A,UN);qN.A.locals;const GN=(0,PA.A)(jN,[["__scopeId","data-v-2daa727d"]]);function YN(e,t,n,r){var i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:function(e){return e},o=arguments.length>5&&void 0!==arguments[5]?arguments[5]:void 0;return _a(function(){var s=e.layoutCustomizer[t.value];if(o){var a=s[o],l=s[n];return i("custom"===a&&"number"==typeof l&&l>=0?l:r)}var c=null==s?void 0:s[n];return i(null==c||"default"===c||"number"==typeof c&&c<=0?r:c)})}function XN(e){return XN="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},XN(e)}var JN=["skip"];function KN(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function ZN(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=XN(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=XN(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==XN(t)?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function eL(e){var t=Og(e),n=JI(e).selectedViewport;if("menu"===e){var r=YN(t,n,"flagIconPosition","before"),i=YN(t,n,"flagShape","rect"),o=YN(t,n,"languageNames","full");return{positioning:_a(function(){return{flagPos:r.value,flagShape:i.value,languageNames:o.value}})}}var s="10px 0",a="bottom-right",l="full",c="before",d=YN(t,n,"customWidth","auto",function(e){return"number"==typeof e?"".concat(e,"px"):e},"width"),h=YN(t,n,"customPadding",s,function(e){return"number"==typeof e?"".concat(e,"px"):e},"padding"),u=YN(t,n,"position",a),p=YN(t,n,"flagIconPosition",c),f=YN(t,n,"languageNames",l),g=_a(function(){var e,n=h.value,r=null!==(e={"bottom-right":{"--bottom":"0px","--right":"14px",skip:"bottom"},"bottom-left":{"--bottom":"0px","--left":"14px",skip:"bottom"},"top-right":{"--top":"0px","--right":"14px",skip:"top"},"top-left":{"--top":"0px","--left":"14px",skip:"top"}}[u.value])&&void 0!==e?e:{},i=r.skip,o=function(e,t){if(null==e)return{};var n,r,i=function(e,t){if(null==e)return{};var n={};for(var r in e)if({}.hasOwnProperty.call(e,r)){if(-1!==t.indexOf(r))continue;n[r]=e[r]}return n}(e,t);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);for(r=0;r<o.length;r++)n=o[r],-1===t.indexOf(n)&&{}.propertyIsEnumerable.call(e,n)&&(i[n]=e[n])}return i}(r,JN),s=t.borderWidth||0,a=["top"===i?"0":"".concat(s,"px"),"".concat(s,"px"),"bottom"===i?"0":"".concat(s,"px"),"".concat(s,"px")].join(" ");return function(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?KN(Object(n),!0).forEach(function(t){ZN(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):KN(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}({"--switcher-width":d.value,"--switcher-padding":n,"--border-width":a},o)});return{styleVars:g,positioning:_a(function(){return{flagPos:p.value,languageNames:f.value}}),switcherPosition:u}}function tL(e){return tL="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},tL(e)}function nL(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function rL(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?nL(Object(n),!0).forEach(function(t){iL(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):nL(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}function iL(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=tL(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=tL(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==tL(t)?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function oL(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,i,o,s,a=[],l=!0,c=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(r=o.call(n)).done)&&(a.push(r.value),a.length!==t);l=!0);}catch(e){c=!0,i=e}finally{try{if(!l&&null!=n.return&&(s=n.return(),Object(s)!==s))return}finally{if(c)throw i}}return a}}(e,t)||function(e,t){if(e){if("string"==typeof e)return sL(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?sL(e,t):void 0}}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function sL(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}function aL(e){var t=Og(e),n=Bg().published,r=eL(e),i=r.styleVars,o=r.switcherPosition,s=Object.entries(n).map(function(e){var t=oL(e,2);return rL({code:t[0]},t[1])}),a=_a(function(){return"dropdown"===t.type}),l=_a(function(){return!0===t.oppositeLanguage}),c=_a(function(){return t.showPoweredBy}),d=_a(function(){if(!0===t.oppositeLanguage)return s.slice(1,2);var n=a.value||"floater"!==e?4:2;return s.slice(0,n)}),h=_a(function(){return"large"===t.size}),u=_a(function(){var n,r={"--bg":t.bgColor,"--bg-hover":t.bgHoverColor,"--text":t.textColor,"--text-hover":t.textHoverColor,"--border-color":t.borderColor,"--border-radius":lL(t.borderRadius),"--font-size":h.value?"16px":"14px","--flag-size":h.value?"20px":"18px","--flag-radius":"".concat(t.flagRadius,"px"),"--aspect-ratio":"rect"===t.flagShape?"4/3":"1","--transition-duration":t.enableTransitions?"0.2s":"0s"},o={shortcode:function(){return rL(rL({},r),{},{"--border-width":t.borderWidth+"px"})},floater:function(){return rL(rL({},r),i.value)}};return(null===(n=o[e])||void 0===n?void 0:n.call(o))||r}),p=_a(function(){return!0===t.clickLanguage});return{isDropdown:a,isOppositeMode:l,displayedList:d,switcherStyles:u,showPoweredBy:c,switcherPosition:o,openOnClick:p}}function lL(e){if(Array.isArray(e)){var t=oL(e,4),n=t[0],r=void 0===n?0:n,i=t[1],o=void 0===i?0:i,s=t[2],a=void 0===s?0:s,l=t[3],c=void 0===l?0:l;return"".concat(r,"px ").concat(o,"px ").concat(a,"px ").concat(c,"px")}return"number"==typeof e?"".concat(e,"px"):"0px"}var cL=["src"],dL={key:1,class:"trp-language-item-name"},hL=["src"];const uL={__name:"LanguageItem",props:{language:{type:Object,required:!0},dropdown:{type:Boolean,default:!1},flagPos:String,nameMode:String,flagAspectRatio:String},setup:function(e){var t,n=e,r=or("languageItemSettings"),i=(null===(t=window)||void 0===t||null===(t=t.tpLangSwitcherData)||void 0===t||null===(t=t.misc)||void 0===t?void 0:t.pluginUrl)||"",o=_a(function(){var e,t;return null!==(e=null!==(t=n.flagPos)&&void 0!==t?t:null==r?void 0:r.value.flagPos)&&void 0!==e?e:"before"}),s=_a(function(){var e,t;return null!==(e=null!==(t=n.nameMode)&&void 0!==t?t:null==r?void 0:r.value.nameMode)&&void 0!==e?e:"full"}),a=_a(function(){return"hide"!==o.value}),l=_a(function(){return"none"!==s.value}),c=_a(function(){return"before"===o.value}),d=_a(function(){return"after"===o.value}),h=_a(function(){var e,t;return"square"===(null!==(e=n.flagAspectRatio)&&void 0!==e?e:null==r||null===(t=r.value.flagRatio)||void 0===t?void 0:t.value)?"1x1":"4x3"}),u=_a(function(){var e,t,r;if(!a.value)return null;if(n.language.flagPath)return n.language.flagPath;var o=null!==(e=null!==(t=null!==(r=n.language.locale)&&void 0!==r?r:n.language.code)&&void 0!==t?t:n.language.slug)&&void 0!==e?e:"",s=String(o).trim();if(!s||!i)return null;var l=s.replace(/-/g,"_")+".svg";return"".concat(i,"assets/flags/").concat(h.value,"/").concat(encodeURIComponent(l))}),p=_a(function(){return"short"===s.value?n.language.shortName:n.language.name});return function(t,n){return Ms(),Ls("a",{class:X(["trp-language-item",{"trp-dropdown-item":e.dropdown}])},[c.value&&a.value?(Ms(),Ls(Ss,{key:0},[u.value?(Ms(),Ls("img",{key:0,src:u.value,class:"trp-flag-image","aria-hidden":"true",loading:"lazy",decoding:"async"},null,8,cL)):Js("",!0)],64)):Js("",!0),l.value?(Ms(),Ls("span",dL,pe(p.value),1)):Js("",!0),d.value&&a.value?(Ms(),Ls(Ss,{key:2},[u.value?(Ms(),Ls("img",{key:0,src:u.value,class:"trp-flag-image","aria-hidden":"true",loading:"lazy",decoding:"async"},null,8,hL)):Js("",!0)],64)):Js("",!0)],2)}}};var pL=n(846),fL={insert:"head",singleton:!1};Tg()(pL.A,fL);pL.A.locals;const gL=(0,PA.A)(uL,[["__scopeId","data-v-fa610bac"]]);var mL={key:0,class:"trp-switcher-preview trp-dropdown-preview"},vL={key:1,class:"trp-switcher-preview trp-preview-ls-inline"};const AL={__name:"PresetPreviewLanguageSwitcher",props:{scope:{type:String,required:!0,validator:function(e){return["floater","shortcode","menu"].includes(e)}}},setup:function(e){var t=aL(e.scope),n=t.displayedList,r=t.isDropdown;return function(e,t){return Zt(r)?(Ms(),Ls("div",mL,[(Ms(!0),Ls(Ss,null,qi(Zt(n),function(e){return Ms(),Qs(gL,{key:e.code,language:e,dropdown:!0},null,8,["language"])}),128))])):(Ms(),Ls("div",vL,[(Ms(!0),Ls(Ss,null,qi(Zt(n),function(e){return Ms(),Qs(gL,{key:e.code,language:e,dropdown:!1},null,8,["language"])}),128))]))}}};var bL=n(571),yL={insert:"head",singleton:!1};Tg()(bL.A,yL);bL.A.locals;const xL=(0,PA.A)(AL,[["__scopeId","data-v-2f8e6670"]]),wL=wp.i18n;function CL(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,i,o,s,a=[],l=!0,c=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(r=o.call(n)).done)&&(a.push(r.value),a.length!==t);l=!0);}catch(e){c=!0,i=e}finally{try{if(!l&&null!=n.return&&(s=n.return(),Object(s)!==s))return}finally{if(c)throw i}}return a}}(e,t)||function(e,t){if(e){if("string"==typeof e)return kL(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?kL(e,t):void 0}}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function kL(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var SL={class:"trp-preset-applier"},OL={key:0,class:"trp-confirmation-dialog"},BL=["innerHTML"],_L={class:"trp-primary-text trp-confirmation-overwrite-warning"},TL={class:"trp-dialog-actions"},EL=["onClick"];const ML={__name:"PresetApplier",props:{scope:{type:String,required:!0,validator:function(e){return["floater","shortcode","menu"].includes(e)}}},setup:function(e){var t=Og(e.scope),n={presetDefault:(0,wL.__)("Default","translatepress-multilingual"),presetDark:(0,wL.__)("Dark","translatepress-multilingual"),presetBorder:(0,wL.__)("Border","translatepress-multilingual"),presetTransparent:(0,wL.__)("Transparent","translatepress-multilingual"),confirmTitleHtml:(0,wL.__)("Are you sure you want to apply the <strong>%s</strong> preset?","translatepress-multilingual"),confirmOverwrite:(0,wL.__)("It will override your current settings.","translatepress-multilingual"),applyPreset:(0,wL.__)("Apply preset","translatepress-multilingual"),cancel:(0,wL.__)("Cancel","translatepress-multilingual"),applyPresetWithName:(0,wL.__)("Apply %s preset","translatepress-multilingual")},r=[{id:"default",name:n.presetDefault,settings:{bgColor:"#ffffff",bgHoverColor:"#0000000D",textColor:"#143852",textHoverColor:"#1D2327",borderColor:"#1438521A"}},{id:"dark",name:n.presetDark,settings:{bgColor:"#000000",bgHoverColor:"#444444",textColor:"#ffffff",textHoverColor:"#eeeeee",borderColor:"transparent"}},{id:"border",name:n.presetBorder,settings:{bgColor:"#FFFFFF",bgHoverColor:"#000000",textColor:"#143852",textHoverColor:"#ffffff",borderColor:"#143852"}},{id:"transparent",name:n.presetTransparent,settings:{bgColor:"#FFFFFFB2",bgHoverColor:"#0000000D",textColor:"#000000",textHoverColor:"#000000",borderColor:"transparent"}}];var i=Gt(null);function o(){i.value=null}function s(){i.value&&(Object.entries(i.value.settings).forEach(function(e){var n=CL(e,2),r=n[0],i=n[1];t[r]=i}),i.value=null)}return function(t,a){return Ms(),Ls("div",SL,[(Ms(),Ls(Ss,null,qi(r,function(t){return Hs("div",{key:t.id,class:"trp-preset-card",style:j((r=t.settings,{"--bg":r.bgColor,"--bg-hover":r.bgHoverColor,"--text":r.textColor,"--text-hover":r.textHoverColor,"--border-color":r.borderColor}))},[Hs("div",{class:"trp-preview-rect",style:j({background:"transparent"===t.id?"linear-gradient(145.41deg, #2271B1 20.41%, #D3B4DA 96.59%)":"#DBDBDB"})},[js(xL,{scope:e.scope},null,8,["scope"]),i.value&&i.value.id===t.id?(Ms(),Ls("div",OL,[Hs("p",{class:"trp-primary-text",innerHTML:Zt(wL.sprintf)(n.confirmTitleHtml,t.name)},null,8,BL),Hs("p",_L,pe(n.confirmOverwrite),1),Hs("div",TL,[Hs("button",{class:"trp-confirm-button",onClick:s},pe(n.applyPreset),1),Hs("span",{class:"trp-description-text trp-cancel-button",onClick:o},pe(n.cancel),1)])])):Js("",!0)],4),Hs("button",{class:"trp-apply-btn",onClick:function(e){return function(e){i.value=e}(t)}},pe(Zt(wL.sprintf)(n.applyPresetWithName,t.name)),9,EL)],4);var r}),64))])}}};var DL=n(854),PL={insert:"head",singleton:!1};Tg()(DL.A,PL);DL.A.locals;const RL=(0,PA.A)(ML,[["__scopeId","data-v-14cc9d4c"]]);var IL={id:"trp-floater-powered-by"},NL=["innerHTML"];const LL={__name:"PoweredBy",setup:function(e){return function(e,t){return Ms(),Ls("div",IL,[Hs("span",{innerHTML:Zt(wL.__)('Powered by <a href="https://translatepress.com/?utm_source=frontend-ls&utm_medium=client-site&utm_campaign=powered-by-tp" rel="nofollow" target="_blank" title="WordPress Translation Plugin">TranslatePress</a>',"translatepress-multilingual")},null,8,NL)])}}};var QL=n(616),FL={insert:"head",singleton:!1};Tg()(QL.A,FL);QL.A.locals;const VL=(0,PA.A)(LL,[["__scopeId","data-v-fe637818"]]);var zL={class:"trp-language-switcher-preview__container"},WL={class:"trp-language-switcher-preview-box"},$L={class:"trp-language-switcher-inner"},HL={class:"trp-switcher-dropdown-list"},jL={class:"trp-language-switcher-inner"},qL={class:"trp-language-switcher-inner"},UL={key:0,class:"trp-switcher-dropdown-list"},GL={class:"trp-language-switcher-preview-text trp-description-text"};const YL={__name:"LanguageSwitcherPreview",props:{scope:{type:String,default:"",validator:function(e){return["floater","shortcode","menu"].includes(e)}}},setup:function(e){bl(function(e){return{v21e78ad8:t}});var t="url(".concat(window.tpLangSwitcherData.misc.pluginUrl,"assets/images/switcher-preview-bg.png)"),n=e,r=Gt(!1),i=_a(function(){return"shortcode"===n.scope}),o=(0,wL.__)("Hover over the language switcher to see it in action!","translatepress-multilingual"),s=_a(function(){var e,t;return"floater"!==n.scope?null:null!==(e=p.value)&&void 0!==e&&e.startsWith("top")?"trp-switcher-position-top":null!==(t=p.value)&&void 0!==t&&t.startsWith("bottom")?"trp-switcher-position-bottom":null}),a=aL(n.scope),l=a.displayedList,c=a.isDropdown,d=a.switcherStyles,h=a.isOppositeMode,u=a.showPoweredBy,p=a.switcherPosition,f=a.openOnClick,g=_a(function(){return i.value&&!h.value&&f.value}),m=_a(function(){return i.value?[h.value?"trp-opposite-button":null,g.value?"trp-open-on-click":"trp-open-on-hover",{"trp-dropdown-open":r.value&&!h.value}]:[]}),v=function(){i.value&&!h.value&&f.value&&(r.value=!r.value)};return function(e,t){return Ms(),Ls("div",zL,[Hs("div",WL,[Zt(h)&&!i.value?(Ms(),Ls("div",{key:0,class:"trp-language-switcher trp-floating-switcher trp-opposite-button",style:j(Zt(d))},[Zt(l).length?(Ms(),Qs(gL,{key:Zt(l)[0].code,language:Zt(l)[0]},null,8,["language"])):Js("",!0),Zt(u)?(Ms(),Qs(VL,{key:1})):Js("",!0)],4)):i.value?(Ms(),Ls("div",{key:2,class:X(["trp-language-switcher trp-ls-dropdown trp-shortcode-switcher",m.value]),style:j(Zt(d)),onClick:v},[Hs("div",qL,[Hs("div",{class:X(["trp-current-language-item__wrapper",{"trp-hide-arrow":Zt(h)}])},[Zt(l).length?(Ms(),Qs(gL,{key:Zt(l)[0].code,language:Zt(l)[0],dropdown:!1,class:"trp-language-item__default"},null,8,["language"])):Js("",!0),t[0]||(t[0]=Hs("svg",{class:"trp-shortcode-arrow",width:"20",height:"20",viewBox:"0 0 20 21",fill:"none",xmlns:"http://www.w3.org/2000/svg"},[Hs("path",{d:"M5 8L10 13L15 8",stroke:"var(--text)","stroke-width":"2","stroke-linecap":"round","stroke-linejoin":"round"})],-1))],2),Zt(h)?Js("",!0):(Ms(),Ls("div",UL,[(Ms(!0),Ls(Ss,null,qi(Zt(l).slice(1),function(e){return Ms(),Qs(gL,{key:e.code,language:e,dropdown:!0},null,8,["language"])}),128))]))]),Zt(u)&&Zt(h)?(Ms(),Qs(VL,{key:0})):Js("",!0)],6)):(Ms(),Ls(Ss,{key:1},[Zt(c)?(Ms(),Ls("div",{key:0,class:X(["trp-language-switcher trp-floating-switcher trp-ls-dropdown",s.value]),style:j(Zt(d))},[Zt(u)?(Ms(),Qs(VL,{key:0})):Js("",!0),Hs("div",$L,[Zt(l).length?(Ms(),Qs(gL,{key:Zt(l)[0].code,language:Zt(l)[0],dropdown:!1,class:"trp-language-item__default"},null,8,["language"])):Js("",!0),Hs("div",HL,[(Ms(!0),Ls(Ss,null,qi(Zt(l).slice(1),function(e){return Ms(),Qs(gL,{key:e.code,language:e,dropdown:!0},null,8,["language"])}),128))])])],6)):(Ms(),Ls("div",{key:1,class:X(["trp-language-switcher trp-preview-ls-inline",s.value]),style:j(Zt(d))},[Zt(u)?(Ms(),Qs(VL,{key:0})):Js("",!0),Hs("div",jL,[(Ms(!0),Ls(Ss,null,qi(Zt(l),function(e){return Ms(),Qs(gL,{key:e.code,language:e},null,8,["language"])}),128))])],6))],64))]),Hs("span",GL,pe(Zt(o)),1)])}}};var XL=n(548),JL={insert:"head",singleton:!1};Tg()(XL.A,JL);XL.A.locals;const KL=(0,PA.A)(YL,[["__scopeId","data-v-40a042e8"]]);function ZL(e){return function(e){if(Array.isArray(e))return eQ(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return eQ(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?eQ(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function eQ(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var tQ={key:0,class:"trp-actions-overlay"},nQ={class:"trp-settings-actions"},rQ=["disabled"],iQ={key:1},oQ={key:2},sQ=["disabled","title"],aQ={width:"14",height:"14",viewBox:"0 0 14 14",fill:"none",xmlns:"http://www.w3.org/2000/svg",style:{"margin-right":"6px","vertical-align":"middle"}},lQ={key:0,class:"trp-save-ls-error"},cQ={key:0,class:"trp-revert-confirm"},dQ={class:"trp-revert-text trp-primary-text"},hQ={class:"trp-revert-actions"};const uQ={__name:"SettingsActions",props:{scope:{type:String,required:!0}},setup:function(e){var t=e,n=or("switcherPersistence"),r=n.save,i=n.revert,o=n.isDirty,s=n.saving,a=n.justSaved,l=n.errorMsg,c=Gt(!1);function d(){c.value=!0}function h(){c.value=!1}function u(){i(),c.value=!1}Og(t.scope);var p={saving:(0,wL.__)("Saving...","translatepress-multilingual"),saved:(0,wL.__)("Saved!","translatepress-multilingual"),saveChanges:(0,wL.__)("Save changes","translatepress-multilingual"),revertTitle:(0,wL.__)("Revert to last saved values","translatepress-multilingual"),revertChanges:(0,wL.__)("Revert changes","translatepress-multilingual"),revertConfirmText:(0,wL.__)("Restoring will revert to the last saved version and discard your current edits.","translatepress-multilingual"),revertBtn:(0,wL.__)("Revert","translatepress-multilingual"),cancelBtn:(0,wL.__)("Keep editing","translatepress-multilingual")};return function(e,t){return Ms(),Ls(Ss,null,[(Ms(),Qs(Sr,{to:"body"},[c.value?(Ms(),Ls("div",tQ)):Js("",!0)])),Hs("div",nQ,[Hs("button",{class:"trp-submit-btn",disabled:!Zt(o)||Zt(s),onClick:t[0]||(t[0]=function(){return Zt(r)&&Zt(r).apply(void 0,arguments)})},[Zt(s)?(Ms(),Ls(Ss,{key:0},[t[1]||(t[1]=Hs("span",{class:"trp-save-spinner"},null,-1)),Hs("span",null,pe(p.saving),1)],64)):Zt(a)?(Ms(),Ls("span",iQ,pe(p.saved),1)):(Ms(),Ls("span",oQ,pe(p.saveChanges),1))],8,rQ),Hs("button",{class:"trp-button-secondary",disabled:!Zt(o)||Zt(s),title:p.revertTitle,onClick:d},[(Ms(),Ls("svg",aQ,ZL(t[2]||(t[2]=[Hs("path",{d:"M7.1752 0.713867C10.7452 0.713867 13.3002 3.54187 13.3002 7.01387C13.3002 10.4859 10.7452 13.3139 7.1752 13.3139C4.9352 13.3139 2.9612 12.2009 1.7992 10.5209L3.6122 9.45687C4.3822 10.5069 5.6142 11.2139 7.0002 11.2139C9.3102 11.2139 11.2002 9.26087 11.2002 7.01387C11.2002 4.76687 9.3102 2.81387 7.0002 2.81387C5.6212 2.81387 4.3962 3.51387 3.6262 4.55687L4.9002 5.61387L0.700195 7.01387V2.11387L2.0232 3.21987C3.2062 1.70087 5.0752 0.713867 7.1752 0.713867Z",fill:"#2271B1"},null,-1)])))),Ys(" "+pe(p.revertChanges),1)],8,sQ),Zt(l)?(Ms(),Ls("span",lQ,pe(Zt(l)),1)):Js("",!0)]),(Ms(),Qs(Sr,{to:"body"},[js(el,{name:"fade"},{default:tr(function(){return[c.value?(Ms(),Ls("div",cQ,[Hs("p",dQ,pe(p.revertConfirmText),1),Hs("div",hQ,[Hs("button",{class:"trp-btn-revert trp-submit-btn",onClick:u},pe(p.revertBtn),1),Hs("span",{class:"trp-btn-cancel",onClick:h},pe(p.cancelBtn),1)])])):Js("",!0)]}),_:1})]))],64)}}};var pQ=n(887),fQ={insert:"head",singleton:!1};Tg()(pQ.A,fQ);pQ.A.locals;const gQ=(0,PA.A)(uQ,[["__scopeId","data-v-b0a14790"]]);function mQ(){var e,t,n="function"==typeof Symbol?Symbol:{},r=n.iterator||"@@iterator",i=n.toStringTag||"@@toStringTag";function o(n,r,i,o){var l=r&&r.prototype instanceof a?r:a,c=Object.create(l.prototype);return vQ(c,"_invoke",function(n,r,i){var o,a,l,c=0,d=i||[],h=!1,u={p:0,n:0,v:e,a:p,f:p.bind(e,4),d:function(t,n){return o=t,a=0,l=e,u.n=n,s}};function p(n,r){for(a=n,l=r,t=0;!h&&c&&!i&&t<d.length;t++){var i,o=d[t],p=u.p,f=o[2];n>3?(i=f===r)&&(l=o[(a=o[4])?5:(a=3,3)],o[4]=o[5]=e):o[0]<=p&&((i=n<2&&p<o[1])?(a=0,u.v=r,u.n=o[1]):p<f&&(i=n<3||o[0]>r||r>f)&&(o[4]=n,o[5]=r,u.n=f,a=0))}if(i||n>1)return s;throw h=!0,r}return function(i,d,f){if(c>1)throw TypeError("Generator is already running");for(h&&1===d&&p(d,f),a=d,l=f;(t=a<2?e:l)||!h;){o||(a?a<3?(a>1&&(u.n=-1),p(a,l)):u.n=l:u.v=l);try{if(c=2,o){if(a||(i="next"),t=o[i]){if(!(t=t.call(o,l)))throw TypeError("iterator result is not an object");if(!t.done)return t;l=t.value,a<2&&(a=0)}else 1===a&&(t=o.return)&&t.call(o),a<2&&(l=TypeError("The iterator does not provide a '"+i+"' method"),a=1);o=e}else if((t=(h=u.n<0)?l:n.call(r,u))!==s)break}catch(t){o=e,a=1,l=t}finally{c=1}}return{value:t,done:h}}}(n,i,o),!0),c}var s={};function a(){}function l(){}function c(){}t=Object.getPrototypeOf;var d=[][r]?t(t([][r]())):(vQ(t={},r,function(){return this}),t),h=c.prototype=a.prototype=Object.create(d);function u(e){return Object.setPrototypeOf?Object.setPrototypeOf(e,c):(e.__proto__=c,vQ(e,i,"GeneratorFunction")),e.prototype=Object.create(h),e}return l.prototype=c,vQ(h,"constructor",c),vQ(c,"constructor",l),l.displayName="GeneratorFunction",vQ(c,i,"GeneratorFunction"),vQ(h),vQ(h,i,"Generator"),vQ(h,r,function(){return this}),vQ(h,"toString",function(){return"[object Generator]"}),(mQ=function(){return{w:o,m:u}})()}function vQ(e,t,n,r){var i=Object.defineProperty;try{i({},"",{})}catch(e){i=0}vQ=function(e,t,n,r){function o(t,n){vQ(e,t,function(e){return this._invoke(t,n,e)})}t?i?i(e,t,{value:n,enumerable:!r,configurable:!r,writable:!r}):e[t]=n:(o("next",0),o("throw",1),o("return",2))},vQ(e,t,n,r)}function AQ(e,t,n,r,i,o,s){try{var a=e[o](s),l=a.value}catch(e){return void n(e)}a.done?t(l):Promise.resolve(l).then(r,i)}function bQ(e){return function(){var t=this,n=arguments;return new Promise(function(r,i){var o=e.apply(t,n);function s(e){AQ(o,r,i,s,a,"next",e)}function a(e){AQ(o,r,i,s,a,"throw",e)}s(void 0)})}}function yQ(e){var t=Og(e),n=Gt({});Ei(bQ(mQ().m(function e(){return mQ().w(function(e){for(;;)switch(e.n){case 0:return e.n=1,Qn();case 1:n.value=structuredClone($t(t));case 2:return e.a(2)}},e)})));var r=_a(function(){return JSON.stringify(t)!==JSON.stringify(n.value)}),i=Gt(!1),o=Gt(!1),s=Gt("");function a(e){r.value&&(e.preventDefault(),e.returnValue="")}function l(){return l=bQ(mQ().m(function r(){var a,l,c;return mQ().w(function(r){for(;;)switch(r.p=r.n){case 0:return i.value=!0,s.value="",r.p=1,(a=new FormData).append("action","trp_language_switcher_save"),a.append("nonce",tpLangSwitcherData.nonce),a.append("scope",e),a.append("config",JSON.stringify(t)),r.n=2,fetch(ajaxurl,{method:"POST",credentials:"same-origin",body:a});case 2:if((l=r.v).ok){r.n=3;break}throw new Error("HTTP ".concat(l.status));case 3:n.value=structuredClone($t(t)),o.value=!0,setTimeout(function(){o.value=!1},2e3),r.n=5;break;case 4:r.p=4,c=r.v,s.value=c.message||"Save failed";case 5:return r.p=5,i.value=!1,r.f(5);case 6:return r.a(2)}},r,null,[[1,4,5,6]])})),l.apply(this,arguments)}return ur(r,function(e){e?window.addEventListener("beforeunload",a):window.removeEventListener("beforeunload",a)},{immediate:!0}),{save:function(){return l.apply(this,arguments)},revert:function(){Object.assign(t,structuredClone($t(n.value)))},saving:i,justSaved:o,errorMsg:s,isDirty:r}}function xQ(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,i,o,s,a=[],l=!0,c=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(r=o.call(n)).done)&&(a.push(r.value),a.length!==t);l=!0);}catch(e){c=!0,i=e}finally{try{if(!l&&null!=n.return&&(s=n.return(),Object(s)!==s))return}finally{if(c)throw i}}return a}}(e,t)||function(e,t){if(e){if("string"==typeof e)return wQ(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?wQ(e,t):void 0}}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function wQ(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var CQ={class:"trp-floater-settings__wrapper"},kQ={class:"trp-floater-settings__left"},SQ={class:"trp-sticky-box"},OQ={class:"trp-floater-settings__right"},BQ="floater";const _Q={__name:"FloaterConfig",setup:function(e){var t=Og(BQ),n=yQ(BQ);ir("switcherPersistence",n);var r=n.isDirty,i=n.revert,o=eL(BQ),s=o.positioning,a=o.switcherPosition,l=_a(function(){return t.flagShape}),c=_a(function(){return{flagPos:s.value.flagPos,nameMode:s.value.languageNames,flagRatio:l}}),d=function(e){return"string"!=typeof e?null:e.startsWith("top")?"top":"bottom"};ur(function(){return a.value},function(e,n){var r=d(e),i=d(n);r&&i&&r!==i&&(t.borderRadius=function(e){if(!Array.isArray(e)||4!==e.length)return e;var t=xQ(e,4),n=t[0],r=t[1],i=t[2];return[t[3],i,r,n]}(t.borderRadius))});var h={switcherPreview:(0,wL.__)("Switcher Preview","translatepress-multilingual"),enableFloating:(0,wL.__)("Enable Floating Switcher","translatepress-multilingual"),switcherEnabled:(0,wL.__)("Switcher is enabled","translatepress-multilingual"),switcherDisabled:(0,wL.__)("Switcher is disabled","translatepress-multilingual"),switcherType:(0,wL.__)("Switcher Type","translatepress-multilingual"),showAsDropdown:(0,wL.__)("Show languages as dropdown","translatepress-multilingual"),showSideBySide:(0,wL.__)("Show languages side by side","translatepress-multilingual"),applyPreset:(0,wL.__)("Apply a preset","translatepress-multilingual"),customizeDesign:(0,wL.__)("Customize Design","translatepress-multilingual"),backgroundColor:(0,wL.__)("Background color","translatepress-multilingual"),backgroundHoverColor:(0,wL.__)("Background hover color","translatepress-multilingual"),textColor:(0,wL.__)("Text color","translatepress-multilingual"),textHoverColor:(0,wL.__)("Text hover color","translatepress-multilingual"),borderColor:(0,wL.__)("Switcher border color","translatepress-multilingual"),borderWidth:(0,wL.__)("Switcher border width","translatepress-multilingual"),borderRadius:(0,wL.__)("Switcher border radius","translatepress-multilingual"),flagTextSize:(0,wL.__)("Flag and text size","translatepress-multilingual"),normal:(0,wL.__)("Normal","translatepress-multilingual"),large:(0,wL.__)("Large","translatepress-multilingual"),flagIconsShape:(0,wL.__)("Flag icons shape","translatepress-multilingual"),rectangle:(0,wL.__)("Rectangle (4:3)","translatepress-multilingual"),square:(0,wL.__)("Square (1:1)","translatepress-multilingual"),flagRadius:(0,wL.__)("Flag icons border radius","translatepress-multilingual"),enableCustomCss:(0,wL.__)("Enable custom CSS","translatepress-multilingual"),customizeLayout:(0,wL.__)("Customize Layout","translatepress-multilingual"),showOppositeLanguage:(0,wL.__)("Show opposite language","translatepress-multilingual"),showPoweredBy:(0,wL.__)('Show "Powered by TranslatePress"',"translatepress-multilingual"),poweredByDesc:(0,wL.__)("Show the small Powered by TranslatePress label in the language switcher.","translatepress-multilingual"),leaveConfirm:(0,wL.__)("You have unsaved changes. Leave anyway?","translatepress-multilingual"),enableTransitions:(0,wL.__)("Switcher animations","translatepress-multilingual")},u=(0,wL.__)("Transforms the language switcher into a button showing the other available language, not the current one. <br> Only works when there are exactly two languages, the default one and a translation one.","translatepress-multilingual"),p=Bg().published,f=Object.keys(p).length>2,g=f?(0,wL.__)("This option only works when exactly two languages are published.","translatepress-multilingual"):"";return zf(function(e,t,n){if(!r.value)return n();window.confirm((0,wL.__)("You have unsaved changes. Leave anyway?","translatepress-multilingual"))?(i(),n()):n(!1)}),ir("languageItemSettings",c),function(e,t){return Ms(),Ls("div",CQ,[Hs("div",kQ,[Hs("div",SQ,[js(GN,{title:h.switcherPreview,scope:BQ},{default:tr(function(){return[js(KL,{scope:BQ})]}),_:1},8,["title"]),js(gQ,{scope:BQ})])]),Hs("div",OQ,[js(GN,{title:h.enableFloating,scope:BQ,style:{flexDirection:"row",gap:"75px"},fields:[{key:"enabled",type:"toggleStatus",onText:h.switcherEnabled,offText:h.switcherDisabled}]},null,8,["title","fields"]),js(GN,{title:h.switcherType,scope:BQ,fields:[{key:"type",type:"radio",default:"dropdown",options:[{value:"dropdown",label:h.showAsDropdown},{value:"side-by-side",label:h.showSideBySide,disabled:f,title:Zt(g)}]}]},null,8,["title","fields"]),js(GN,{title:h.applyPreset,scope:BQ},{default:tr(function(){return[js(RL,{scope:BQ})]}),_:1},8,["title"]),js(GN,{title:h.customizeDesign,scope:BQ,collapsible:"",style:{"--trp-field-label-width":"190px"},fields:[{key:"bgColor",type:"color",label:h.backgroundColor,default:"#ffffff"},{key:"bgHoverColor",type:"color",label:h.backgroundHoverColor,default:"#f5f5f5"},{key:"textColor",type:"color",label:h.textColor,default:"#000000"},{key:"textHoverColor",type:"color",label:h.textHoverColor,default:"#000000"},{key:"borderColor",type:"color",label:h.borderColor,default:"#e2e2e4"},{key:"borderWidth",type:"number",label:h.borderWidth,default:1},{key:"borderRadius",type:"quadNumber",label:h.borderRadius,default:[8,8,0,0],layout:"column"},{type:"separator"},{key:"enableTransitions",type:"toggle",label:h.enableTransitions,default:!0},{type:"separator"},{key:"size",type:"radio",label:h.flagTextSize,default:"normal",options:[{value:"normal",label:h.normal},{value:"large",label:h.large}],layout:"column"},{type:"separator"},{key:"flagShape",type:"radio",label:h.flagIconsShape,default:"rect",options:[{value:"rect",label:h.rectangle},{value:"square",label:h.square}],layout:"column"},{key:"flagRadius",type:"number",label:h.flagRadius,default:2},{type:"separator"},{key:"enableCustomCss",type:"toggle",label:h.enableCustomCss,default:!1},{key:"customCss",type:"customCss",label:"",visible:function(e){return!0===(null==e?void 0:e.enableCustomCss)}}]},null,8,["title","fields"]),js(GN,{title:h.customizeLayout,scope:BQ,collapsible:"",fields:[{key:"layoutCustomizer",type:"lCustomizer",label:""}]},null,8,["title"]),js(GN,{title:"Additional Settings",scope:BQ,collapsible:"",fields:[{key:"oppositeLanguage",type:"checkbox",default:!1,label:h.showOppositeLanguage,description:Zt(u),disabled:f,title:Zt(g)},{key:"showPoweredBy",type:"checkbox",default:!1,label:h.showPoweredBy,description:h.poweredByDesc}]},null,8,["fields"])])])}}};var TQ=n(392),EQ={insert:"head",singleton:!1};Tg()(TQ.A,EQ);TQ.A.locals;const MQ=(0,PA.A)(_Q,[["__scopeId","data-v-db97e920"]]);var DQ={class:"trp-shortcode-display"},PQ={class:"trp-description-text"},RQ="[language-switcher]";const IQ={__name:"ShortcodeCopy",setup:function(e){var t=Gt(!1),n=_a(function(){return t.value?(0,wL.__)("Copied!","translatepress-multilingual"):(0,wL.__)("Copy","translatepress-multilingual")});function r(){var e;null===(e=navigator.clipboard)||void 0===e||e.writeText(RQ).then(function(){t.value=!0,setTimeout(function(){return t.value=!1},2e3)}).catch(function(){var e=document.createElement("textarea");e.value=RQ,e.style.position="fixed",e.style.opacity="0",document.body.appendChild(e),e.select();try{document.execCommand("copy")}finally{document.body.removeChild(e),t.value=!0,setTimeout(function(){return t.value=!1},2e3)}})}var i=(0,wL.__)("Use shortcode on any page or widget. You can also add the Language Switcher Block in the WP Gutenberg Editor.","translatepress-multilingual");return function(e,t){return Ms(),Ls(Ss,null,[Hs("div",DQ,[Hs("input",{class:"trp-shortcode-input trp-primary-text",value:RQ,readonly:""}),Hs("button",{class:"trp-copy-btn trp-button-secondary",type:"button",onClick:r},[t[0]||(t[0]=Hs("svg",{width:"22",height:"22",viewBox:"0 0 22 22",fill:"none",xmlns:"http://www.w3.org/2000/svg"},[Hs("path",{d:"M14.666 7.33317V5.49984C14.666 5.01361 14.4729 4.54729 14.129 4.20347C13.7852 3.85966 13.3189 3.6665 12.8327 3.6665H5.49935C5.01312 3.6665 4.5468 3.85966 4.20299 4.20347C3.85917 4.54729 3.66602 5.01361 3.66602 5.49984V12.8332C3.66602 13.3194 3.85917 13.7857 4.20299 14.1295C4.5468 14.4733 5.01312 14.6665 5.49935 14.6665H7.33268M7.33268 9.1665C7.33268 8.68027 7.52584 8.21396 7.86965 7.87014C8.21347 7.52633 8.67979 7.33317 9.16602 7.33317H16.4993C16.9856 7.33317 17.4519 7.52633 17.7957 7.87014C18.1395 8.21396 18.3327 8.68027 18.3327 9.1665V16.4998C18.3327 16.9861 18.1395 17.4524 17.7957 17.7962C17.4519 18.14 16.9856 18.3332 16.4993 18.3332H9.16602C8.67979 18.3332 8.21347 18.14 7.86965 17.7962C7.52584 17.4524 7.33268 16.9861 7.33268 16.4998V9.1665Z",stroke:"#2271B1","stroke-width":"1.5","stroke-linecap":"round","stroke-linejoin":"round"})],-1)),Ys(" "+pe(n.value),1)])]),Hs("p",PQ,pe(Zt(i)),1)],64)}}};var NQ=n(427),LQ={insert:"head",singleton:!1};Tg()(NQ.A,LQ);NQ.A.locals;const QQ=(0,PA.A)(IQ,[["__scopeId","data-v-4d14b53c"]]);var FQ={class:"trp-floater-settings__wrapper"},VQ={class:"trp-floater-settings__left"},zQ={class:"trp-sticky-box"},WQ={class:"trp-floater-settings__right"},$Q="shortcode";const HQ={__name:"ShortcodeConfig",setup:function(e){var t=Og($Q),n=yQ($Q);ir("switcherPersistence",n);var r=n.isDirty,i=n.revert,o=eL($Q).positioning,s=_a(function(){return t.flagShape});ir("languageItemSettings",_a(function(){return{flagPos:o.value.flagPos,nameMode:o.value.languageNames,flagRatio:s}}));var a=(0,wL.__)("Transforms the language switcher into a button showing the other available language, not the current one. <br> Only works when there are exactly two languages, the default one and a translation one.","translatepress-multilingual"),l=Bg().published,c=Object.keys(l).length>2,d=c?(0,wL.__)("This option only works when exactly two languages are published.","translatepress-multilingual"):"",h={confirmLeave:(0,wL.__)("You have unsaved changes. Leave anyway?","translatepress-multilingual"),switcherPreview:(0,wL.__)("Switcher Preview","translatepress-multilingual"),shortcode:(0,wL.__)("Shortcode","translatepress-multilingual"),customizeDesign:(0,wL.__)("Customize Design","translatepress-multilingual"),backgroundColor:(0,wL.__)("Background color","translatepress-multilingual"),backgroundHoverColor:(0,wL.__)("Background hover color","translatepress-multilingual"),textColor:(0,wL.__)("Text color","translatepress-multilingual"),textHoverColor:(0,wL.__)("Text hover color","translatepress-multilingual"),switcherBorderColor:(0,wL.__)("Switcher border color","translatepress-multilingual"),switcherBorderWidth:(0,wL.__)("Switcher border width","translatepress-multilingual"),switcherBorderRadius:(0,wL.__)("Switcher border radius","translatepress-multilingual"),flagTextSize:(0,wL.__)("Flag and text size","translatepress-multilingual"),normal:(0,wL.__)("Normal","translatepress-multilingual"),large:(0,wL.__)("Large","translatepress-multilingual"),flagIconsShape:(0,wL.__)("Flag icons shape","translatepress-multilingual"),rectangle:(0,wL.__)("Rectangle (4:3)","translatepress-multilingual"),square:(0,wL.__)("Square (1:1)","translatepress-multilingual"),flagRadius:(0,wL.__)("Flag icons border radius","translatepress-multilingual"),enableCustomCss:(0,wL.__)("Enable custom CSS","translatepress-multilingual"),customizeLayout:(0,wL.__)("Customize Layout","translatepress-multilingual"),additionalSettings:(0,wL.__)("Additional Settings","translatepress-multilingual"),openOnClick:(0,wL.__)("Open language switcher only on click","translatepress-multilingual"),clickLangDesc:(0,wL.__)("Open the language switcher shortcode by clicking on it instead of hovering. <br> Close it by clicking on it, anywhere else on the screen or by pressing the escape key. <br> This will affect only the shortcode language switcher.","translatepress-multilingual"),enableTransitions:(0,wL.__)("Switcher animations","translatepress-multilingual"),showOppositeLanguage:(0,wL.__)("Show opposite language","translatepress-multilingual")};return zf(function(e,t,n){if(!r.value)return n();window.confirm(h.confirmLeave)?(i(),n()):n(!1)}),function(e,t){return Ms(),Ls("div",FQ,[Hs("div",VQ,[Hs("div",zQ,[js(GN,{title:h.switcherPreview,scope:$Q},{default:tr(function(){return[js(KL,{scope:$Q})]}),_:1},8,["title"]),js(gQ,{scope:$Q})])]),Hs("div",WQ,[js(GN,{title:h.shortcode,scope:$Q},{default:tr(function(){return[js(QQ)]}),_:1},8,["title"]),js(GN,{title:h.customizeDesign,scope:$Q,collapsible:"",style:{"--trp-field-label-width":"190px"},fields:[{key:"bgColor",type:"color",label:h.backgroundColor,default:"#ffffff"},{key:"bgHoverColor",type:"color",label:h.backgroundHoverColor,default:"#f5f5f5"},{key:"textColor",type:"color",label:h.textColor,default:"#1D2327"},{key:"textHoverColor",type:"color",label:h.textHoverColor,default:"#000000"},{key:"borderColor",type:"color",label:h.switcherBorderColor,default:"#1438521A"},{key:"borderWidth",type:"number",label:h.switcherBorderWidth,default:1},{key:"borderRadius",type:"number",label:h.switcherBorderRadius,default:5},{type:"separator"},{key:"enableTransitions",type:"toggle",label:h.enableTransitions,default:!0},{type:"separator"},{key:"size",type:"radio",label:h.flagTextSize,default:"normal",options:[{value:"normal",label:h.normal},{value:"large",label:h.large}],layout:"column"},{type:"separator"},{key:"flagShape",type:"radio",label:h.flagIconsShape,default:"rect",options:[{value:"rect",label:h.rectangle},{value:"square",label:h.square}],layout:"column"},{key:"flagRadius",type:"number",label:h.flagRadius,default:2},{type:"separator"},{key:"enableCustomCss",type:"toggle",label:h.enableCustomCss,default:!1},{key:"customCss",type:"customCss",label:"",visible:function(e){return!0===(null==e?void 0:e.enableCustomCss)}}]},null,8,["title","fields"]),js(GN,{title:h.customizeLayout,scope:$Q,collapsible:"",fields:[{key:"layoutCustomizer",type:"lCustomizer",label:""}]},null,8,["title"]),js(GN,{title:h.additionalSettings,scope:$Q,collapsible:"",fields:[{key:"clickLanguage",type:"checkbox",default:!1,label:h.openOnClick,description:h.clickLangDesc},{key:"oppositeLanguage",type:"checkbox",default:!1,label:h.showOppositeLanguage,description:Zt(a),disabled:c,title:Zt(d)}]},null,8,["title","fields"])])])}}};var jQ=n(451),qQ={insert:"head",singleton:!1};Tg()(jQ.A,qQ);jQ.A.locals;const UQ=(0,PA.A)(HQ,[["__scopeId","data-v-ab1eeb76"]]);function GQ(e){return function(e){if(Array.isArray(e))return YQ(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return YQ(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?YQ(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function YQ(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}function XQ(e){for(var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=(new DOMParser).parseFromString(e,"text/html"),r=n.createTreeWalker(n.body,NodeFilter.SHOW_ELEMENT),i=function(){var e=r.currentNode,i=e.tagName.toLowerCase();if(!t[i]){var o=n.createTextNode(e.textContent);return e.replaceWith(o),1}var s=t[i];(GQ(e.attributes).forEach(function(t){s.includes(t.name.toLowerCase())||e.removeAttribute(t.name)}),e.hasAttribute("href"))&&((e.getAttribute("href")||"").trim().toLowerCase().startsWith("javascript:")&&e.removeAttribute("href"));e.hasAttribute("src")&&((e.getAttribute("src")||"").trim().toLowerCase().startsWith("javascript:")&&e.removeAttribute("src"))};r.nextNode();)i();return n.body.innerHTML}var JQ={class:"trp-menu-settings__wrapper"},KQ=["innerHTML"],ZQ="menu";const eF={__name:"MenuConfig",setup:function(e){Og(ZQ);var t=yQ(ZQ);ir("switcherPersistence",t);var n=t.isDirty,r=t.revert,i={menuSwitcherLayout:(0,wL.__)("Menu Switcher Layout","translatepress-multilingual"),unsavedChangesAlert:(0,wL.__)("You have unsaved changes. Leave anyway?","translatepress-multilingual"),descriptionText:XQ((0,wL.__)('Go to <a href="/wp-admin/nav-menus.php">Appearance → Menus</a> to add languages to the Language Switcher in any menu.<br> <a href="https://translatepress.com/docs/settings/language-switcher/?utm_source=tp-language-switcher&utm_medium=client-site&utm_campaign=ls-menu-item#menu-switcher" target="_blank">Learn more in our documentation.</a>',"translatepress-multilingual"))};return zf(function(e,t,o){if(!n.value)return o();window.confirm(i.unsavedChangesAlert)?(r(),o()):o(!1)}),function(e,t){return Ms(),Ls("div",JQ,[js(GN,{title:i.menuSwitcherLayout,scope:ZQ,collapsible:!1,fields:[{key:"layoutCustomizer",type:"lCustomizer",label:""}]},{end:tr(function(){return[Hs("span",{class:"trp-description-text",innerHTML:i.descriptionText},null,8,KQ)]}),_:1},8,["title"]),js(gQ,{scope:ZQ})])}}};var tF=n(130),nF={insert:"head",singleton:!1};Tg()(tF.A,nF);tF.A.locals;const rF=(0,PA.A)(eF,[["__scopeId","data-v-2d8b1892"]]),iF=function(e){const t=ag(e.routes,e),n=e.parseQuery||Mf,r=e.stringifyQuery||Df,i=e.history,o=Ff(),s=Ff(),a=Ff(),l=Yt(gf);let c=gf;Pp&&e.scrollBehavior&&"scrollRestoration"in history&&(history.scrollRestoration="manual");const d=Lp.bind(null,e=>""+e),h=Lp.bind(null,sf),u=Lp.bind(null,af);function p(e,o){if(o=Np({},o||l.value),"string"==typeof e){const r=cf(n,e,o.path),s=t.resolve({path:r.path},o),a=i.createHref(r.fullPath);return Np(r,s,{params:u(s.params),hash:af(r.hash),redirectedFrom:void 0,href:a})}let s;if(null!=e.path)s=Np({},e,{path:cf(n,e.path,o.path).path});else{const t=Np({},e.params);for(const e in t)null==t[e]&&delete t[e];s=Np({},e,{params:h(t)}),o.params=h(o.params)}const a=t.resolve(s,o),c=e.hash||"";a.params=d(u(a.params));const p=function(e,t){const n=t.query?e(t.query):"";return t.path+(n&&"?")+n+(t.hash||"")}(r,Np({},e,{hash:nf(c),path:a.path})),f=i.createHref(p);return Np({fullPath:p,hash:c,query:r===Df?Pf(e.query):e.query||{}},a,{redirectedFrom:void 0,href:f})}function f(e){return"string"==typeof e?cf(n,e,l.value.path):Np({},e)}function g(e,t){if(c!==e)return _f(Of.NAVIGATION_CANCELLED,{from:t,to:e})}function m(e){return A(e)}function v(e,t){const n=e.matched[e.matched.length-1];if(n&&n.redirect){const{redirect:r}=n;let i="function"==typeof r?r(e,t):r;return"string"==typeof i&&(i=i.includes("?")||i.includes("#")?i=f(i):{path:i},i.params={}),Np({query:e.query,hash:e.hash,params:null!=i.path?{}:e.params},i)}}function A(e,t){const n=c=p(e),i=l.value,o=e.state,s=e.force,a=!0===e.replace,d=v(n,i);if(d)return A(Np(f(d),{state:"object"==typeof d?Np({},o,d.state):o,force:s,replace:a}),t||n);const h=n;let u;return h.redirectedFrom=t,!s&&function(e,t,n){const r=t.matched.length-1,i=n.matched.length-1;return r>-1&&r===i&&hf(t.matched[r],n.matched[i])&&uf(t.params,n.params)&&e(t.query)===e(n.query)&&t.hash===n.hash}(r,i,n)&&(u=_f(Of.NAVIGATION_DUPLICATED,{to:h,from:i}),M(i,i,!0,!1)),(u?Promise.resolve(u):x(h,i)).catch(e=>Tf(e)?Tf(e,Of.NAVIGATION_GUARD_REDIRECT)?e:E(e):T(e,h,i)).then(e=>{if(e){if(Tf(e,Of.NAVIGATION_GUARD_REDIRECT))return A(Np({replace:a},f(e.to),{state:"object"==typeof e.to?Np({},o,e.to.state):o,force:s}),t||h)}else e=C(h,i,!0,a,o);return w(h,i,e),e})}function b(e,t){const n=g(e,t);return n?Promise.reject(n):Promise.resolve()}function y(e){const t=R.values().next().value;return t&&"function"==typeof t.runWithContext?t.runWithContext(e):e()}function x(e,t){let n;const[r,i,a]=function(e,t){const n=[],r=[],i=[],o=Math.max(t.matched.length,e.matched.length);for(let s=0;s<o;s++){const o=t.matched[s];o&&(e.matched.find(e=>hf(e,o))?r.push(o):n.push(o));const a=e.matched[s];a&&(t.matched.find(e=>hf(e,a))||i.push(a))}return[n,r,i]}(e,t);n=$f(r.reverse(),"beforeRouteLeave",e,t);for(const i of r)i.leaveGuards.forEach(r=>{n.push(Wf(r,e,t))});const l=b.bind(null,e,t);return n.push(l),N(n).then(()=>{n=[];for(const r of o.list())n.push(Wf(r,e,t));return n.push(l),N(n)}).then(()=>{n=$f(i,"beforeRouteUpdate",e,t);for(const r of i)r.updateGuards.forEach(r=>{n.push(Wf(r,e,t))});return n.push(l),N(n)}).then(()=>{n=[];for(const r of a)if(r.beforeEnter)if(Fp(r.beforeEnter))for(const i of r.beforeEnter)n.push(Wf(i,e,t));else n.push(Wf(r.beforeEnter,e,t));return n.push(l),N(n)}).then(()=>(e.matched.forEach(e=>e.enterCallbacks={}),n=$f(a,"beforeRouteEnter",e,t,y),n.push(l),N(n))).then(()=>{n=[];for(const r of s.list())n.push(Wf(r,e,t));return n.push(l),N(n)}).catch(e=>Tf(e,Of.NAVIGATION_CANCELLED)?e:Promise.reject(e))}function w(e,t,n){a.list().forEach(r=>y(()=>r(e,t,n)))}function C(e,t,n,r,o){const s=g(e,t);if(s)return s;const a=t===gf,c=Pp?history.state:{};n&&(r||a?i.replace(e.fullPath,Np({scroll:a&&c&&c.scroll},o)):i.push(e.fullPath,o)),l.value=e,M(e,t,n,a),E()}let k;function S(){k||(k=i.listen((e,t,n)=>{if(!I.listening)return;const r=p(e),o=v(r,I.currentRoute.value);if(o)return void A(Np(o,{replace:!0,force:!0}),r).catch(Qp);c=r;const s=l.value;var a,d;Pp&&(a=Cf(s.fullPath,n.delta),d=xf(),kf.set(a,d)),x(r,s).catch(e=>Tf(e,Of.NAVIGATION_ABORTED|Of.NAVIGATION_CANCELLED)?e:Tf(e,Of.NAVIGATION_GUARD_REDIRECT)?(A(Np(f(e.to),{force:!0}),r).then(e=>{Tf(e,Of.NAVIGATION_ABORTED|Of.NAVIGATION_DUPLICATED)&&!n.delta&&n.type===mf.pop&&i.go(-1,!1)}).catch(Qp),Promise.reject()):(n.delta&&i.go(-n.delta,!1),T(e,r,s))).then(e=>{(e=e||C(r,s,!1))&&(n.delta&&!Tf(e,Of.NAVIGATION_CANCELLED)?i.go(-n.delta,!1):n.type===mf.pop&&Tf(e,Of.NAVIGATION_ABORTED|Of.NAVIGATION_DUPLICATED)&&i.go(-1,!1)),w(r,s,e)}).catch(Qp)}))}let O,B=Ff(),_=Ff();function T(e,t,n){E(e);const r=_.list();return r.length?r.forEach(r=>r(e,t,n)):console.error(e),Promise.reject(e)}function E(e){return O||(O=!e,S(),B.list().forEach(([t,n])=>e?n(e):t()),B.reset()),e}function M(t,n,r,i){const{scrollBehavior:o}=e;if(!Pp||!o)return Promise.resolve();const s=!r&&function(e){const t=kf.get(e);return kf.delete(e),t}(Cf(t.fullPath,0))||(i||!r)&&history.state&&history.state.scroll||null;return Qn().then(()=>o(t,n,s)).then(e=>e&&wf(e)).catch(e=>T(e,t,n))}const D=e=>i.go(e);let P;const R=new Set,I={currentRoute:l,listening:!0,addRoute:function(e,n){let r,i;return Sf(e)?(r=t.getRecordMatcher(e),i=n):i=e,t.addRoute(i,r)},removeRoute:function(e){const n=t.getRecordMatcher(e);n&&t.removeRoute(n)},clearRoutes:t.clearRoutes,hasRoute:function(e){return!!t.getRecordMatcher(e)},getRoutes:function(){return t.getRoutes().map(e=>e.record)},resolve:p,options:e,push:m,replace:function(e){return m(Np(f(e),{replace:!0}))},go:D,back:()=>D(-1),forward:()=>D(1),beforeEach:o.add,beforeResolve:s.add,afterEach:a.add,onError:_.add,isReady:function(){return O&&l.value!==gf?Promise.resolve():new Promise((e,t)=>{B.add([e,t])})},install(e){e.component("RouterLink",mg),e.component("RouterView",xg),e.config.globalProperties.$router=I,Object.defineProperty(e.config.globalProperties,"$route",{enumerable:!0,get:()=>Zt(l)}),Pp&&!P&&l.value===gf&&(P=!0,m(i.location).catch(e=>{0}));const t={};for(const e in gf)Object.defineProperty(t,e,{get:()=>l.value[e],enumerable:!0});e.provide(Nf,I),e.provide(Lf,It(t)),e.provide(Qf,l);const n=e.unmount;R.add(e),e.unmount=function(){R.delete(e),R.size<1&&(c=gf,k&&k(),k=null,l.value=gf,P=!1,O=!1),n()}}};function N(e){return e.reduce((e,t)=>e.then(()=>y(t)),Promise.resolve())}return I}({history:function(e){return(e=location.host?e||location.pathname+location.search:"").includes("#")||(e+="#"),Uf(e)}(),routes:[{path:"/",redirect:"/floater"},{path:"/floater",component:MQ},{path:"/shortcode",component:UQ},{path:"/menu-item",component:rF}]});var oF={class:"trp-submenu__wrapper"},sF={class:"trp-submenu"},aF=["onClick","onKeydown"];const lF={__name:"SubMenu",setup:function(e){var t=[{path:"/floater",label:"Floating"},{path:"/shortcode",label:"Shortcode"},{path:"/menu-item",label:"Menu Item"}];return function(e,n){var r=Vi("RouterLink");return Ms(),Ls("div",oF,[Hs("div",sF,[(Ms(),Ls(Ss,null,qi(t,function(e){return js(r,{key:e.path,to:e.path,custom:""},{default:tr(function(t){t.href;var n=t.navigate;return[Hs("span",{class:X(["trp-submenu-item",{"trp-nav-active":t.isActive}]),role:"link",tabindex:"0",onClick:n,onKeydown:wc(yc(n,["prevent"]),["enter","space"])},pe(e.label),43,aF)]}),_:2},1032,["to"])}),64))])])}}},cF=lF;var dF={class:"trp-ls-wrapper"},hF={class:"trp-ls-view"};const uF={__name:"App",setup:function(e){document.getElementById("tp-language-switcher-root");var t=window.tpLangSwitcherData;return function(e){var t=e.config,n=e.languages,r=Rt(t.floater||{}),i=Rt(t.shortcode||{}),o=Rt(t.menu||{}),s=Nt(n||{});ir(wg,r),ir(Cg,i),ir(kg,o),ir(Sg,s)}({config:t.lsConfig,languages:t.languages}),function(e,t){var n=Vi("router-view");return Ms(),Ls("div",dF,[js(cF),Hs("main",hF,[js(n)])])}}};var pF=n(700),fF={insert:"head",singleton:!1};Tg()(pF.A,fF);pF.A.locals;const gF=(0,PA.A)(uF,[["__scopeId","data-v-bf1beb8c"]]);var mF=document.getElementById("tp-language-switcher-root");Ec(gF).use(iF).mount(mF)},700(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-ls-wrapper[data-v-bf1beb8c]{display:flex;flex-direction:column}.trp-ls-view[data-v-bf1beb8c]{display:flex;justify-content:flex-start;padding:0 32px}","",{version:3,sources:["webpack://./assets/src/language-switcher/App.vue"],names:[],mappings:"AAuBA,iCACI,YAAa,CACb,qBACJ,CACA,8BAEI,YAAa,CACb,0BAA2B,CAF3B,cAGJ",sourcesContent:["<script setup>\r\n\r\nimport SubMenu from './components/SubMenu.vue'\r\nimport { provideSwitcherConfig } from './composables/useSwitcherConfig'\r\n\r\nconst el = document.getElementById('tp-language-switcher-root')\r\n/** tpLangSwitcherData comes from wp_localize_script */\r\nconst { lsConfig: config, languages } = window.tpLangSwitcherData\r\n\r\nprovideSwitcherConfig( { config, languages } )\r\n\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-ls-wrapper\">\r\n        <SubMenu />\r\n        <main class=\"trp-ls-view\">\r\n            <router-view />\r\n        </main>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-ls-wrapper {\r\n    display: flex;\r\n    flex-direction: column;\r\n}\r\n.trp-ls-view {\r\n    padding: 0 32px;\r\n    display: flex;\r\n    justify-content: flex-start;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},751(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-settings-box[data-v-2daa727d]{background:#fff;border:1px solid #e2e2e4;border-radius:2px;box-sizing:border-box;display:flex;flex-direction:column;gap:24px;padding:24px}.trp-header[data-v-2daa727d]{display:flex;justify-content:space-between}.trp-settings-box.trp-collapsible .trp-header[data-v-2daa727d]{cursor:pointer}.trp-title[data-v-2daa727d]{color:var(--trp-settings-primary-color);font-size:16px;font-weight:590}.trp-chevron[data-v-2daa727d]{transition:transform .2s ease}.trp-chevron.open[data-v-2daa727d]{transform:rotate(180deg)}.trp-body[data-v-2daa727d]{display:flex;flex-direction:column;gap:24px}.trp-separator[data-v-2daa727d]{background:var(--trp-settings-light-gray-border-color);height:1px;width:100%}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/SettingsBox.vue"],names:[],mappings:"AA8FA,mCAMI,eAAgB,CAChB,wBAAyB,CACzB,iBAAkB,CAPlB,qBAAsB,CACtB,YAAa,CACb,qBAAsB,CAEtB,QAAS,CADT,YAKJ,CAEA,6BACI,YAAa,CACb,6BACJ,CAEA,+DACI,cACJ,CAEA,4BAEI,uCAAwC,CACxC,cAAe,CAFf,eAGJ,CAEA,8BACI,6BACJ,CAEA,mCACI,wBACJ,CAEA,2BACI,YAAa,CACb,qBAAsB,CACtB,QACJ,CAEA,gCAGI,sDAAuD,CAFvD,UAAW,CACX,UAEJ",sourcesContent:['<script setup>\r\nimport { ref, computed, reactive } from \'vue\'\r\nimport { useSwitcherConfig } from \'../composables/useSwitcherConfig\'\r\n\r\nimport ColorField            from \'../components/fields/ColorField.vue\'\r\nimport NumberField           from \'../components/fields/NumberField.vue\'\r\nimport ToggleField           from \'../components/fields/ToggleField.vue\'\r\nimport ToggleStatusField     from \'../components/fields/ToggleStatusField.vue\'\r\nimport RadioGroupField       from \'../components/fields/RadioGroupField.vue\'\r\nimport QuadRadiusField       from \'../components/fields/QuadRadiusField.vue\'\r\nimport CustomCssAreaField    from \'../components/fields/CustomCssAreaField.vue\'\r\nimport LayoutCustomizerField from \'../components/fields/LayoutCustomizerField.vue\'\r\nimport CheckboxField         from \'../components/fields/CheckboxField.vue\'\r\n\r\nconst componentMap = {\r\n    color         : ColorField,\r\n    number        : NumberField,\r\n    toggle        : ToggleField,\r\n    toggleStatus  : ToggleStatusField,\r\n    radio         : RadioGroupField,\r\n    quadNumber    : QuadRadiusField,\r\n    customCss     : CustomCssAreaField,\r\n    lCustomizer   : LayoutCustomizerField,\r\n    checkbox      : CheckboxField,\r\n}\r\n\r\nconst props = defineProps( {\r\n    title       : { type: String, required: true },\r\n    fields      : { type: Array, required: false, default: [] }, // [{ fields:[{key,type,label,...}] }]\r\n    collapsible : { type: Boolean, default: false },\r\n    scope       : { type: String, required: true }\r\n})\r\n\r\nconst cfg = useSwitcherConfig( props.scope )\r\n\r\nconst open = ref( !props.collapsible )\r\n\r\nconst bindings = reactive({})\r\n\r\nprops.fields.forEach(field => {\r\n    if (field.type === \'separator\' || bindings[field.key]) return;\r\n\r\n    if (cfg[field.key] === undefined && field.default !== undefined)\r\n        cfg[field.key] = field.default\r\n\r\n    bindings[field.key] = computed({\r\n        get: () => cfg[field.key],\r\n        set: val => cfg[field.key] = val\r\n    })\r\n})\r\n<\/script>\r\n\r\n<template>\r\n    <div\r\n        class="trp-settings-box"\r\n        :class="{ \'trp-collapsible\': props.collapsible }"\r\n    >\r\n        <header class="trp-header" @click="props.collapsible && (open = !open)">\r\n            <span class="trp-title">{{ props.title }}</span>\r\n            <svg\r\n                v-if="props.collapsible"\r\n                class="trp-chevron"\r\n                :class="{ open }"\r\n                viewBox="0 0 20 20"\r\n                width="20" height="20"\r\n            >\r\n                <path d="M5 6L10 11L15 6L17 7L10 14L3 7L5 6Z" fill="#9CA1A8"/>\r\n            </svg>\r\n        </header>\r\n\r\n        <section v-show="open" class="trp-body">\r\n            <slot v-if="$slots.default" /> \x3c!-- In case a component is injected inside SettingsBox, it will be directly rendered - bypassing the routing system.  --\x3e\r\n\r\n            <template v-for="field in props.fields" :key="field.key || field.type">\r\n                <div v-if="field.type === \'separator\'" class="trp-separator" />\r\n                <component\r\n                    v-else\r\n                    :is="componentMap[field.type]"\r\n                    v-model="bindings[field.key]"\r\n                    v-bind="{ ...field, visible: field.visible ? field.visible(cfg) : true }"\r\n                    :scope="scope"\r\n                    :class="[\r\n                        \'trp-field\',\r\n                        field.hasOwnProperty(\'layout\') ? \'trp-field--column\' : \'trp-field--row\'\r\n                    ]"\r\n                />\r\n            </template>\r\n\r\n            <slot name="end" />\r\n        </section>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-settings-box {\r\n    box-sizing: border-box;\r\n    display: flex;\r\n    flex-direction: column;\r\n    padding: 24px;\r\n    gap: 24px;\r\n    background: #fff;\r\n    border: 1px solid #e2e2e4;\r\n    border-radius: 2px;\r\n}\r\n\r\n.trp-header {\r\n    display: flex;\r\n    justify-content: space-between;\r\n}\r\n\r\n.trp-settings-box.trp-collapsible .trp-header {\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-title {\r\n    font-weight: 590;\r\n    color: var(--trp-settings-primary-color);\r\n    font-size: 16px;\r\n}\r\n\r\n.trp-chevron {\r\n    transition: transform .2s ease;\r\n}\r\n\r\n.trp-chevron.open {\r\n    transform: rotate(180deg);\r\n}\r\n\r\n.trp-body {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 24px;\r\n}\r\n\r\n.trp-separator {\r\n    height: 1px;\r\n    width: 100%;\r\n    background: var(--trp-settings-light-gray-border-color);\r\n}\r\n\r\n</style>\r\n'],sourceRoot:""}]);const a=s},787(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,'.trp-toggle-wrapper[data-v-30d3f338]{align-items:center;display:flex}.trp-toggle-inner[data-v-30d3f338]{cursor:pointer;display:inline-block;height:19px;position:relative;width:36px}.trp-toggle-input[data-v-30d3f338]{height:0;opacity:0;position:absolute;width:0}.trp-toggle-slider[data-v-30d3f338]{border:1px solid #949494;border-radius:28px;cursor:pointer;display:inline-block;height:17px;position:relative;transition:background-color .3s ease;width:34px}.trp-toggle-slider[data-v-30d3f338]:before{background-color:#949494;border-radius:50%;content:"";height:13px;left:4px;position:absolute;top:2px;transition:transform .2s ease-in-out;width:13px}.trp-toggle-input:checked+.trp-toggle-slider[data-v-30d3f338]{background-color:var(--trp-settings-accent-color,#0073aa);border-color:var(--trp-settings-accent-color)}.trp-toggle-input:checked+.trp-toggle-slider[data-v-30d3f338]:before{background-color:#fff;transform:translateX(14px)}',"",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/ToggleField.vue"],names:[],mappings:"AA4BA,qCAEI,kBAAmB,CADnB,YAEJ,CAEA,mCAGI,cAAe,CADf,oBAAqB,CAGrB,WAAY,CAJZ,iBAAkB,CAGlB,UAEJ,CAEA,mCAII,QAAS,CAFT,SAAU,CADV,iBAAkB,CAElB,OAEJ,CAEA,oCAOI,wBAAyB,CAFzB,kBAAmB,CAGnB,cAAe,CAPf,oBAAqB,CAGrB,WAAY,CAFZ,iBAAkB,CAIlB,oCAAsC,CAHtC,UAMJ,CAEA,2CAOI,wBAAyB,CACzB,iBAAkB,CAPlB,UAAW,CAKX,WAAY,CAHZ,QAAS,CADT,iBAAkB,CAElB,OAAQ,CAKR,oCAAsC,CAJtC,UAKJ,CAEA,8DACI,yDAA2D,CAC3D,6CACJ,CAEA,qEAEI,qBAAuB,CADvB,0BAEJ",sourcesContent:['<script setup>\r\nconst props = defineProps({\r\n    modelValue: Boolean,\r\n    label: { type: String, default: \'\' }\r\n})\r\n\r\nconst emit = defineEmits([\'update:modelValue\'])\r\n<\/script>\r\n\r\n<template>\r\n    <div class="trp-toggle-wrapper">\r\n    <span v-if="label" class="trp-field__label trp-primary-text-bold">\r\n      {{ label }}\r\n    </span>\r\n\r\n        <div class="trp-toggle-inner" @click="emit(\'update:modelValue\', !modelValue)">\r\n            <input\r\n                type="checkbox"\r\n                class="trp-toggle-input"\r\n                :checked="modelValue"\r\n                readonly\r\n            />\r\n            <span class="trp-toggle-slider" />\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-toggle-wrapper {\r\n    display: flex;\r\n    align-items: center;\r\n}\r\n\r\n.trp-toggle-inner {\r\n    position: relative;\r\n    display: inline-block;\r\n    cursor: pointer;\r\n    width: 36px;\r\n    height: 19px;\r\n}\r\n\r\n.trp-toggle-input {\r\n    position: absolute;\r\n    opacity: 0;\r\n    width: 0;\r\n    height: 0;\r\n}\r\n\r\n.trp-toggle-slider {\r\n    display: inline-block;\r\n    position: relative;\r\n    width: 34px;\r\n    height: 17px;\r\n    border-radius: 28px;\r\n    transition: background-color 0.3s ease;\r\n    border: 1px solid #949494;\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-toggle-slider::before {\r\n    content: \'\';\r\n    position: absolute;\r\n    left: 4px;\r\n    top: 2px;\r\n    width: 13px;\r\n    height: 13px;\r\n    background-color: #949494;\r\n    border-radius: 50%;\r\n    transition: transform 0.2s ease-in-out;\r\n}\r\n\r\n.trp-toggle-input:checked + .trp-toggle-slider {\r\n    background-color: var(--trp-settings-accent-color, #0073aa);\r\n    border-color: var(--trp-settings-accent-color);\r\n}\r\n\r\n.trp-toggle-input:checked + .trp-toggle-slider::before {\r\n    transform: translateX(14px);\r\n    background-color: white;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},793(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".cm-focused{outline:none!important}.cm-editor{border:1px solid var(--trp-settings-light-gray-border-color,#ccc);border-radius:8px}.cm-gutters{border-radius:8px 0 0 8px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/CustomCssAreaField.vue"],names:[],mappings:"AAqJA,YACI,sBACJ,CAEA,WACI,iEAAmE,CACnE,iBACJ,CAEA,YACI,yBACJ",sourcesContent:["<script setup>\r\nimport { ref, watch, onMounted, onBeforeUnmount, shallowRef } from 'vue'\r\nimport { Codemirror } from 'vue-codemirror'\r\nimport { css } from '@codemirror/lang-css'\r\n\r\nimport debounce from '../../composables/utils/debounce'\r\n\r\nconst props = defineProps({\r\n    label: { type: String, default: '' },\r\n    visible: { type: Boolean, default: false },\r\n    modelValue: { type: String, default: '' }\r\n})\r\nconst emit = defineEmits(['update:modelValue'])\r\n\r\nconst rawCss     = ref(props.modelValue)\r\nconst scopedCss  = ref('')\r\nconst extensions = [css()]\r\nconst view       = shallowRef(null)\r\n\r\nconst debouncedEmit = debounce( ( v) => {\r\n    const scoped = scopeCustomCss(v)\r\n    scopedCss.value = scoped\r\n    emit('update:modelValue', scoped)\r\n}, 300)\r\n\r\nwatch(() => props.modelValue, v => {\r\n    if (v !== scopedCss.value && v !== rawCss.value) {\r\n        rawCss.value = v\r\n    }\r\n})\r\n\r\nwatch(rawCss, v => debouncedEmit(v))\r\n\r\nwatch(scopedCss, v => {\r\n    if (styleEl) {\r\n        styleEl.textContent = v\r\n    }\r\n})\r\n\r\nconst handleReady = ({ view: v }) => (view.value = v)\r\n\r\n/* Live <style> injection only when visible === true */\r\nlet styleEl = null\r\n\r\nconst injectStyle = () => {\r\n    if (styleEl || !props.visible) return\r\n    styleEl = document.createElement('style')\r\n    styleEl.dataset.customCss = ''\r\n    styleEl.textContent = scopeCustomCss(rawCss.value)\r\n    document.head.appendChild(styleEl)\r\n}\r\n\r\nconst removeStyle = () => {\r\n    if (styleEl) {\r\n        styleEl.remove()\r\n        styleEl = null\r\n    }\r\n}\r\n\r\nconst scopeCustomCss = (css, scopeSelector = '.trp-language-switcher') => {\r\n    // Parse into a temporary stylesheet via the browser’s CSSOM\r\n    const styleEl = document.createElement('style');\r\n    styleEl.textContent = css;\r\n    document.head.appendChild(styleEl);\r\n    const sheet = styleEl.sheet;\r\n    document.head.removeChild(styleEl);\r\n\r\n    const output = [];\r\n\r\n    for (const rule of sheet.cssRules) {\r\n        // Root-level style rules\r\n        if (rule instanceof CSSStyleRule) {\r\n            const scoped = rule.selectorText\r\n                               .split(',')\r\n                               .map(sel => {\r\n                                   sel = sel.trim();\r\n                                   // If already scoped, leave it\r\n                                   if (sel.startsWith(scopeSelector))\r\n                                       return sel;\r\n\r\n                                   // Otherwise prefix\r\n                                   return `${scopeSelector} ${sel}`\r\n                               })\r\n                               .join(', ')\r\n            output.push(`${scoped} { ${rule.style.cssText} }`)\r\n        }\r\n\r\n        // @media blocks\r\n        else if (rule instanceof CSSMediaRule) {\r\n            const inner = [];\r\n            for (const child of rule.cssRules) {\r\n                if (child instanceof CSSStyleRule) {\r\n                    const scoped = child.selectorText\r\n                                        .split(',')\r\n                                        .map(sel => {\r\n                                            sel = sel.trim()\r\n                                            return sel.startsWith(scopeSelector)\r\n                                                ? sel\r\n                                                : `${scopeSelector} ${sel}`\r\n                                        })\r\n                                        .join(', ')\r\n                    inner.push(`${scoped} { ${child.style.cssText} }`)\r\n                } else {\r\n                    // e.g. nested @supports, @keyframes inside @media\r\n                    inner.push(child.cssText)\r\n                }\r\n            }\r\n            output.push(`@media ${rule.media.mediaText} {\\n${inner.join('\\n')}\\n}`)\r\n        }\r\n\r\n        // Everything else (import, keyframes, supports)\r\n        else\r\n            output.push(rule.cssText)\r\n    }\r\n\r\n    return output.join('\\n')\r\n}\r\n\r\n// Track visibility changes\r\nwatch(() => props.visible, (visible) => {\r\n    if (visible) injectStyle()\r\n    else removeStyle()\r\n})\r\n\r\nonMounted(() => {\r\n    if (props.visible) injectStyle()\r\n})\r\nonBeforeUnmount(removeStyle)\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-custom-css-editor\" v-show=\"visible\">\r\n        <label v-if=\"label\" class=\"trp-field__label trp-primary-text-bold\">\r\n            {{ label }}\r\n        </label>\r\n\r\n        <Codemirror\r\n            v-model=\"rawCss\"\r\n            :placeholder=\"'Write custom CSS here...'\"\r\n            :style=\"{ height: '250px', width: '80%', fontSize: '14px', fontFamily: 'monospace' }\"\r\n            :indent-with-tab=\"true\"\r\n            :tab-size=\"2\"\r\n            :extensions=\"extensions\"\r\n            @ready=\"handleReady\"\r\n        />\r\n    </div>\r\n</template>\r\n\r\n<style >\r\n.cm-focused {\r\n    outline: none !important;\r\n}\r\n\r\n.cm-editor {\r\n    border: 1px solid var(--trp-settings-light-gray-border-color, #ccc);\r\n    border-radius: 8px;\r\n}\r\n\r\n.cm-gutters {\r\n    border-radius: 8px 0 0 8px;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},798(e){"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map(function(t){var n=e(t);return t[2]?"@media ".concat(t[2]," {").concat(n,"}"):n}).join("")},t.i=function(e,n,r){"string"==typeof e&&(e=[[null,e,""]]);var i={};if(r)for(var o=0;o<this.length;o++){var s=this[o][0];null!=s&&(i[s]=!0)}for(var a=0;a<e.length;a++){var l=[].concat(e[a]);r&&i[l[0]]||(n&&(l[2]?l[2]="".concat(n," and ").concat(l[2]):l[2]=n),t.push(l))}},t}},846(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-language-item[data-v-fa610bac]{align-items:center;color:var(--text);cursor:pointer;display:flex;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;font-size:var(--font-size,14px);gap:8px;line-height:1.2;min-height:19px;padding:5px 16px;width:100%}.trp-language-item__default[data-v-fa610bac]{pointer-events:none}.trp-language-item[data-v-fa610bac]:hover{background:var(--bg-hover);color:var(--text-hover)}.trp-flag-image[data-v-fa610bac]{aspect-ratio:var(--aspect-ratio,4/3);border-radius:var(--flag-radius,2px);height:auto;image-rendering:pixelated;width:var(--flag-size,18px)}.trp-language-item-name[data-v-fa610bac]{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/LanguageItem.vue"],names:[],mappings:"AAmGA,oCAEI,kBAAmB,CAMnB,iBAAkB,CAElB,cAAe,CATf,YAAa,CAIb,mHAAwH,CACxH,+BAAiC,CAHjC,OAAQ,CAIR,eAAgB,CAEhB,eAAgB,CALhB,gBAAiB,CAOjB,UACJ,CAEA,6CACI,mBACJ,CAEA,0CACI,0BAA2B,CAC3B,uBACJ,CAEA,iCAII,oCAAsC,CAHtC,oCAAsC,CACtC,WAAY,CACZ,yBAA0B,CAE1B,2BACJ,CAEA,yCAEI,eAAgB,CAChB,sBAAuB,CAFvB,kBAGJ",sourcesContent:['<script setup>\r\nimport { inject, computed } from \'vue\'\r\n\r\nconst props = defineProps( {\r\n    language : {\r\n       type     : Object,\r\n       required : true\r\n    },\r\n    dropdown : {\r\n       type    : Boolean,\r\n       default : false\r\n    },\r\n    flagPos         : String, // Inserted via injectedSettings\r\n    nameMode        : String, // Inserted via injectedSettings\r\n    flagAspectRatio : String  // Inserted via injectedSettings\r\n})\r\n\r\n// Injected global layout settings (optional override)\r\nconst injectedSettings = inject( \'languageItemSettings\' )\r\n\r\nconst pluginUrl = window?.tpLangSwitcherData?.misc?.pluginUrl || \'\'\r\n\r\nconst finalFlagPos = computed( () =>\r\n    props.flagPos ?? injectedSettings?.value.flagPos ?? \'before\'\r\n)\r\n\r\nconst finalNameMode = computed( () =>\r\n    props.nameMode ?? injectedSettings?.value.nameMode ?? \'full\'\r\n)\r\n\r\nconst showFlag = computed( () => finalFlagPos.value !== \'hide\' )\r\nconst showName = computed( () => finalNameMode.value !== \'none\' )\r\n\r\nconst isFlagBefore = computed( () => finalFlagPos.value === \'before\' )\r\nconst isFlagAfter  = computed( () => finalFlagPos.value === \'after\' )\r\n\r\nconst ratioFolder = computed(() => {\r\n    const ratioSetting = props.flagAspectRatio ?? injectedSettings?.value.flagRatio?.value\r\n\r\n    return ratioSetting === \'square\' ? \'1x1\' : \'4x3\'\r\n})\r\n\r\nconst flagUrl = computed(() => {\r\n    if (!showFlag.value) return null\r\n\r\n    // custom flag has priority\r\n    if (props.language.flagPath) return props.language.flagPath\r\n\r\n    const rawLocale =\r\n              props.language.locale ??\r\n              props.language.code ??\r\n              props.language.slug ??\r\n              \'\'\r\n    const locale = String(rawLocale).trim()\r\n    if (!locale || !pluginUrl) return null\r\n\r\n    const file = locale.replace(/-/g, \'_\') + \'.svg\'\r\n    return `${pluginUrl}assets/flags/${ratioFolder.value}/${encodeURIComponent(file)}`\r\n})\r\n\r\nconst displayName = computed( () =>\r\n    finalNameMode.value === \'short\' ? props.language.shortName : props.language.name\r\n)\r\n<\/script>\r\n\r\n<template>\r\n    <a\r\n        class="trp-language-item"\r\n        :class="{ \'trp-dropdown-item\': dropdown }"\r\n    >\r\n        <template v-if="isFlagBefore && showFlag">\r\n            <img\r\n                v-if="flagUrl"\r\n                :src="flagUrl"\r\n                class="trp-flag-image"\r\n                aria-hidden="true"\r\n                loading="lazy"\r\n                decoding="async"\r\n            />\r\n        </template>\r\n\r\n        <span v-if="showName" class="trp-language-item-name">\r\n            {{ displayName }}\r\n        </span>\r\n\r\n        <template v-if="isFlagAfter && showFlag">\r\n            <img\r\n                v-if="flagUrl"\r\n                :src="flagUrl"\r\n                class="trp-flag-image"\r\n                aria-hidden="true"\r\n                loading="lazy"\r\n                decoding="async"\r\n            />\r\n        </template>\r\n    </a>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-language-item {\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 8px;\r\n    padding: 5px 16px;\r\n    font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif;\r\n    font-size: var(--font-size, 14px);\r\n    line-height: 1.2;\r\n    color: var(--text);\r\n    min-height: 19px;\r\n    cursor: pointer;\r\n    width: 100%;\r\n}\r\n\r\n.trp-language-item__default {\r\n    pointer-events: none;\r\n}\r\n\r\n.trp-language-item:hover {\r\n    background: var(--bg-hover);\r\n    color: var(--text-hover);\r\n}\r\n\r\n.trp-flag-image {\r\n    border-radius: var(--flag-radius, 2px);\r\n    height: auto;\r\n    image-rendering: pixelated;\r\n    aspect-ratio: var(--aspect-ratio, 4/3);\r\n    width: var(--flag-size, 18px);\r\n}\r\n\r\n.trp-language-item-name {\r\n    white-space: nowrap;\r\n    overflow: hidden;\r\n    text-overflow: ellipsis;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},854(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-preset-applier[data-v-14cc9d4c],[data-v-14cc9d4c]:root{--bg:#fff;--bg-hover:#fff;--text:#000;--text-hover:#000;--border-color:#1438521a;--radius:0px}.trp-preset-applier[data-v-14cc9d4c]{display:grid;gap:16px}.trp-preset-card[data-v-14cc9d4c]{display:flex;flex-direction:column;gap:4px}@media (min-width:500px){.trp-preset-applier[data-v-14cc9d4c]{grid-template-columns:repeat(2,1fr)}}.trp-confirm-button[data-v-14cc9d4c]{background:var(--trp-settings-accent-color);border:1px solid var(--trp-settings-accent-color);border-radius:var(--trp-settings-radius-medium);color:#fff;cursor:pointer;padding:5px 10px}.trp-confirm-button[data-v-14cc9d4c]:hover{background:transparent;color:var(--trp-settings-accent-color)}.trp-preview-rect[data-v-14cc9d4c]{align-items:center;background:#dbdbdb;border-radius:var(--trp-settings-radius-high);display:flex;height:145px;justify-content:center;padding:16px 0;position:relative;width:100%}.trp-apply-btn[data-v-14cc9d4c]{all:unset;color:var(--trp-settings-accent-color);cursor:pointer;font-size:var(--trp-settings-primary-font-size);font-weight:500}.trp-apply-btn[data-v-14cc9d4c]:hover{opacity:.8}.trp-confirmation-dialog[data-v-14cc9d4c]{background:#fff;border:1px solid;border-radius:8px;bottom:0;left:0;padding:16px;position:absolute;right:0;text-align:center;top:0}.trp-dialog-actions[data-v-14cc9d4c]{align-items:center;display:flex;gap:8px;justify-content:center;margin-top:12px}.trp-confirmation-overwrite-warning[data-v-14cc9d4c]{color:#c94f2d}.trp-cancel-button[data-v-14cc9d4c]{cursor:pointer}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/PresetApplier.vue"],names:[],mappings:"AAgJA,4DACI,SAAuB,CACvB,eAAuB,CACvB,WAAuB,CACvB,iBAAuB,CACvB,wBAAyB,CACzB,YACJ,CAEA,qCACI,YAAa,CACb,QACJ,CAEA,kCACI,YAAa,CACb,qBAAsB,CACtB,OACJ,CAGA,yBACI,qCACI,mCACJ,CACJ,CAEA,qCAII,2CAA4C,CAC5C,iDAAkD,CAHlD,+CAAgD,CAChD,UAAc,CAFd,cAAe,CAKf,gBACJ,CAGA,2CACI,sBAAuB,CACvB,sCACJ,CAEA,mCAQI,kBAAmB,CALnB,kBAAmB,CAEnB,6CAA8C,CAC9C,YAAa,CAJb,YAAa,CAKb,sBAAuB,CAHvB,cAAe,CAKf,iBAAkB,CARlB,UASJ,CAEA,gCACI,SAAU,CACV,sCAAuC,CAGvC,cAAe,CAFf,+CAAgD,CAChD,eAEJ,CAEA,sCACI,UACJ,CAEA,0CACI,eAAgB,CAGhB,gBAAiB,CADjB,iBAAkB,CAMlB,QAAS,CACT,MAAO,CARP,YAAa,CAIb,iBAAkB,CAElB,OAAQ,CAHR,iBAAkB,CAElB,KAIJ,CAEA,qCAKI,kBAAmB,CAHnB,YAAa,CACb,OAAQ,CACR,sBAAuB,CAHvB,eAKJ,CAEA,qDACI,aACJ,CAEA,oCACI,cACJ",sourcesContent:["<script setup>\r\nimport { ref }    from 'vue'\r\nimport { useSwitcherConfig } from \"../composables/useSwitcherConfig\"\r\nimport PresetPreviewLanguageSwitcher from './PresetPreviewLanguageSwitcher.vue'\r\nimport { __, sprintf }               from \"@wordpress/i18n\"\n\r\nconst props = defineProps({\r\n    scope: {\r\n      type: String,\r\n      required: true,\r\n      validator: v => ['floater','shortcode','menu'].includes(v)\r\n    }\r\n})\r\n\r\nconst cfg = useSwitcherConfig(props.scope)\r\n\r\n/** Localized UI text */\r\nconst T = {\r\n    presetDefault: __('Default', 'translatepress-multilingual'),\n    presetDark: __('Dark', 'translatepress-multilingual'),\n    presetBorder: __('Border', 'translatepress-multilingual'),\n    presetTransparent: __('Transparent', 'translatepress-multilingual'),\n    confirmTitleHtml: __('Are you sure you want to apply the <strong>%s</strong> preset?', 'translatepress-multilingual'),\n    confirmOverwrite: __('It will override your current settings.', 'translatepress-multilingual'),\n    applyPreset: __('Apply preset', 'translatepress-multilingual'),\n    cancel: __('Cancel', 'translatepress-multilingual'),\n    applyPresetWithName: __('Apply %s preset', 'translatepress-multilingual'),\n}\r\n\r\nconst presets = [\r\n    {\r\n        id: 'default',\r\n        name: T.presetDefault,\r\n        settings: {\r\n            bgColor:        '#ffffff',\r\n            bgHoverColor:   '#0000000D',\r\n            textColor:      '#143852',\r\n            textHoverColor: '#1D2327',\r\n            borderColor:    '#1438521A'\r\n        }\r\n    },\r\n    {\r\n        id: 'dark',\r\n        name: T.presetDark,\r\n        settings: {\r\n            bgColor:        '#000000',\r\n            bgHoverColor:   '#444444',\r\n            textColor:      '#ffffff',\r\n            textHoverColor: '#eeeeee',\r\n            borderColor:    'transparent'\r\n        }\r\n    },\r\n    {\r\n        id: 'border',\r\n        name: T.presetBorder,\r\n        settings: {\r\n            bgColor:        '#FFFFFF',\r\n            bgHoverColor:   '#000000',\r\n            textColor:      '#143852',\r\n            textHoverColor: '#ffffff',\r\n            borderColor:    '#143852'\r\n        }\r\n    },\r\n    {\r\n        id: 'transparent',\r\n        name: T.presetTransparent,\r\n        settings: {\r\n            bgColor:        '#FFFFFFB2',\r\n            bgHoverColor:   '#0000000D',\r\n            textColor:      '#000000',\r\n            textHoverColor: '#000000',\r\n            borderColor:    'transparent'\r\n        }\r\n    },\r\n]\r\n\r\n// helper: map settings → CSS variables on the card\r\nfunction cssVars(s) {\r\n    return {\r\n        '--bg':           s.bgColor,\r\n        '--bg-hover':     s.bgHoverColor,\r\n        '--text':         s.textColor,\r\n        '--text-hover':   s.textHoverColor,\r\n        '--border-color': s.borderColor\r\n    }\r\n}\r\n\r\nconst confirmPreset = ref(null)\r\n\r\nfunction requestApply(preset) {\r\n    confirmPreset.value = preset\r\n}\r\n\r\nfunction cancelApply() {\r\n    confirmPreset.value = null\r\n}\r\n\r\nfunction applyPreset() {\r\n    if (!confirmPreset.value) return\r\n\r\n    Object.entries(confirmPreset.value.settings).forEach(([key, val]) => {\r\n        cfg[key] = val\r\n    })\r\n\r\n    confirmPreset.value = null\r\n}\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-preset-applier\">\r\n        <div\r\n            v-for=\"preset in presets\"\r\n            :key=\"preset.id\"\r\n            class=\"trp-preset-card\"\r\n            :style=\"cssVars(preset.settings)\"\r\n        >\r\n            <div class=\"trp-preview-rect\"\r\n                 :style=\"{ background: preset.id === 'transparent' ? 'linear-gradient(145.41deg, #2271B1 20.41%, #D3B4DA 96.59%)' : '#DBDBDB' }\"\r\n            >\r\n                <PresetPreviewLanguageSwitcher :scope=\"scope\" />\r\n                <div\r\n                    v-if=\"confirmPreset && confirmPreset.id === preset.id\"\r\n                    class=\"trp-confirmation-dialog\"\r\n                >\r\n                    \x3c!-- translators: %s is the preset name --\x3e\r\n                    <p class=\"trp-primary-text\" v-html=\"sprintf(T.confirmTitleHtml, preset.name)\"></p>\r\n                    <p class=\"trp-primary-text trp-confirmation-overwrite-warning\">{{ T.confirmOverwrite }}</p>\r\n                    <div class=\"trp-dialog-actions\">\r\n                        <button class=\"trp-confirm-button\" @click=\"applyPreset\">{{ T.applyPreset }}</button>\r\n                        <span class=\"trp-description-text trp-cancel-button\" @click=\"cancelApply\">{{ T.cancel }}</span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <button class=\"trp-apply-btn\" @click=\"requestApply(preset)\">\r\n                \x3c!-- translators: %s is the preset name --\x3e\r\n                {{ sprintf(T.applyPresetWithName, preset.name) }}\r\n            </button>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n/* Add Fallback to vars */\r\n:root, .trp-preset-applier {\r\n    --bg:           #ffffff;\r\n    --bg-hover:     #ffffff;\r\n    --text:         #000000;\r\n    --text-hover:   #000000;\r\n    --border-color: #1438521A;\r\n    --radius:       0px;\r\n}\r\n\r\n.trp-preset-applier {\r\n    display: grid;\r\n    gap: 16px;\r\n}\r\n\r\n.trp-preset-card {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 4px;\r\n}\r\n\r\n/* ≥ 500 px -> 2 columns */\r\n@media (min-width: 500px) {\r\n    .trp-preset-applier {\r\n        grid-template-columns: repeat(2, 1fr);\r\n    }\r\n}\r\n\r\n.trp-confirm-button {\r\n    cursor: pointer;\r\n    border-radius: var(--trp-settings-radius-medium);\r\n    color: #ffffff;\r\n    background: var(--trp-settings-accent-color);\r\n    border: 1px solid var(--trp-settings-accent-color);\r\n    padding: 5px 10px;\r\n}\r\n\r\n\r\n.trp-confirm-button:hover {\r\n    background: transparent;\r\n    color: var(--trp-settings-accent-color);\r\n}\r\n\r\n.trp-preview-rect {\r\n    width: 100%;\r\n    height: 145px;\r\n    background: #DBDBDB;\r\n    padding: 16px 0;\r\n    border-radius: var(--trp-settings-radius-high);\r\n    display: flex;\r\n    justify-content: center;\r\n    align-items: center;\r\n    position: relative;\r\n}\r\n\r\n.trp-apply-btn {\r\n    all: unset;\r\n    color: var(--trp-settings-accent-color);\r\n    font-size: var(--trp-settings-primary-font-size);\r\n    font-weight: 500;\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-apply-btn:hover {\r\n    opacity: 0.8;\r\n}\r\n\r\n.trp-confirmation-dialog {\r\n    background: #fff;\r\n    padding: 16px;\r\n    border-radius: 8px;\r\n    border: 1px solid;\r\n    text-align: center;\r\n    position: absolute;\r\n    top: 0;\r\n    right: 0;\r\n    bottom: 0;\r\n    left: 0;\r\n}\r\n\r\n.trp-dialog-actions {\r\n    margin-top: 12px;\r\n    display: flex;\r\n    gap: 8px;\r\n    justify-content: center;\r\n    align-items: center;\r\n}\r\n\r\n.trp-confirmation-overwrite-warning {\r\n    color: #C94F2D;\r\n}\r\n\r\n.trp-cancel-button {\r\n    cursor: pointer;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},877(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,':root{--vc-picker-bg:#f8f8f8;--vc-body-bg:#fff;--vc-input-bg:#fff;--vc-input-text:#333;--vc-input-label:#969696;--vc-input-border:#dadada;--vc-chrome-toggle-btn-highlighted:#eee;--vc-ps-bg:#dcdcdc;--vc-ps-title-bg-gradient-start:#f0f0f0;--vc-ps-title-bg-gradient-end:#d4d4d4;--vc-ps-title-border:#b1b1b1;--vc-ps-title-color:#4d4d4d;--vc-ps-slider-border:#b3b3b3;--vc-ps-slider-border-bottom:#f0f0f0;--vs-ps-picker-border-dark:#555;--vs-ps-picker-border-white:#fff;--vc-ps-btn-gradient-start:#fff;--vc-ps-btn-gradient-end:#e6e6e6;--vc-ps-btn-border:#878787;--vc-ps-btn-shadow:#eaeaea;--vc-ps-btn-color:#000;--vc-ps-preview-border:#000;--vc-ps-label:#000;--vc-ps-input-border:#888;--vc-ps-input-shadow-dark:rgba(0,0,0,.1);--vc-ps-input-shadow-light:#ececec;--vc-sketch-input-label:#222;--vc-sketch-presets-border:#eee;--vc-twitter-input-bg:#fff;--vc-twitter-input-border:#f0f0f0;--vc-twitter-input-color:#666;--vc-twitter-hash-bg:#f0f0f0;--vc-twitter-hash-color:#98a1a4}:root.dark{--vc-body-bg:#424242;--vc-picker-bg:#d0d0d0;--vc-input-bg:#2c2c2c;--vc-input-text:#d0d0d0;--vc-input-label:#bbb;--vc-input-border:#555;--vc-chrome-toggle-btn-highlighted:#5c5c5c;--vc-sketch-input-label:#bbb;--vc-sketch-presets-border:#5a5a5a;--vc-twitter-input-border:#383838;--vc-twitter-input-color:#bbb;--vc-twitter-hash-bg:#383838;--vc-twitter-hash-color:#a0acaf;--vc-twitter-input-bg:#555;--vc-ps-bg:#424242;--vc-ps-title-bg-gradient-start:#4e4e4e;--vc-ps-title-bg-gradient-end:#3a3a3a;--vc-ps-title-border:#5a5a5a;--vc-ps-title-color:#bbb;--vc-ps-slider-border:#5c5c5c;--vc-ps-slider-border-bottom:#4a4a4a;--vs-ps-picker-border-dark:#b8b8b8;--vs-ps-picker-border-white:#bbb;--vc-ps-btn-gradient-start:#505050;--vc-ps-btn-gradient-end:#3a3a3a;--vc-ps-btn-border:#6a6a6a;--vc-ps-btn-shadow:#2a2a2a;--vc-ps-btn-color:#bbb;--vc-ps-preview-border:#3a3a3a;--vc-ps-label:#bbb;--vc-ps-input-border:#666;--vc-ps-input-shadow-dark:rgba(0,0,0,.45);--vc-ps-input-shadow-light:#2d2d2d}.bg[data-v-4d048d6e]{cursor:crosshair;inset:0;position:absolute;touch-action:none}.white[data-v-4d048d6e]{background:linear-gradient(90deg,#fff,#fff0)}.black[data-v-4d048d6e]{background:linear-gradient(0deg,#000,#0000)}.picker-wrap[data-v-4d048d6e]{cursor:pointer;outline:none;position:absolute}.picker[data-v-4d048d6e]{border-radius:50%;box-shadow:0 0 0 1.6px var(--vc-picker-bg),inset 0 0 1px 1px #0000004d,0 0 1px 2px #0006;cursor:move;height:4px;transform:translate(-2px,-2px);width:4px}.vc-base-slider[data-v-972b0fad]{height:100%;position:relative;touch-action:none;width:100%}.background[data-v-972b0fad],.slider[data-v-972b0fad]{inset:0;position:absolute}.background[data-v-972b0fad]{overflow:hidden}.slider[data-v-972b0fad]{cursor:pointer;z-index:2}.picker-wrap[data-v-972b0fad]{outline:none;position:absolute;z-index:2}.picker[data-v-972b0fad]{background:var(--vc-picker-bg);border-radius:1px;box-shadow:0 0 2px #0009;cursor:pointer;height:8px;margin-top:1px;transform:translate(-2px);width:4px}.vc-hue-slider[data-v-5367c985]{cursor:crosshair;touch-action:none}.gradient[data-v-5367c985]{background:var(--2f44f39d);border-radius:2px;height:100%;width:100%}.vc-checkerboard[data-v-37d61ccd]{background-size:contain;inset:0;position:absolute}.vc-alpha-slider[data-v-07dd346b] .vc-checkerboard{border-radius:2px}.gradient[data-v-07dd346b]{inset:0;position:absolute}.vc-editable-input[data-v-9c267b2b]{position:relative}.vc-input-input[data-v-9c267b2b]{border:0;outline:none;padding:0;width:100%}.vc-input-label[data-v-9c267b2b]{text-transform:capitalize}.vc-chrome-picker[data-v-dfdde7e0]{border-radius:2px;box-shadow:0 0 2px #0000004d,0 4px 8px #0000004d;box-sizing:initial;font-family:Menlo,Consolas,Courier New,monospace;width:225px}.controls[data-v-dfdde7e0]{display:flex}.color-wrap[data-v-dfdde7e0]{position:relative;width:36px}.active-color[data-v-dfdde7e0]{border-radius:15px;height:30px;overflow:hidden;position:relative;width:30px;z-index:1}.color-wrap[data-v-dfdde7e0] .vc-checkerboard{background-size:auto;border-radius:15px;height:30px;width:30px}.sliders[data-v-dfdde7e0]{flex:1}.fieldsWrap[data-v-dfdde7e0]{display:flex;padding-top:16px}.fields[data-v-dfdde7e0]{display:flex;flex:1;margin-left:-6px}.field[data-v-dfdde7e0]{padding-left:6px;width:100%}.toggle-btn[data-v-dfdde7e0]{position:relative;text-align:right;width:32px}.toggle-icon[data-v-dfdde7e0]{color:var(--vc-input-text);cursor:pointer;margin-right:-4px;margin-top:12px;position:relative;z-index:2}.toggle-icon_highlighted[data-v-dfdde7e0]{background:var(--vc-chrome-toggle-btn-highlighted);border-radius:4px;height:28px;left:12px;position:absolute;top:10px;width:24px}.hue-wrap[data-v-dfdde7e0]{margin-bottom:8px}.alpha-wrap[data-v-dfdde7e0],.hue-wrap[data-v-dfdde7e0]{height:10px;position:relative}.alpha-wrap[data-v-dfdde7e0] .gradient,.hue-wrap[data-v-dfdde7e0] .container{border-radius:2px}.alpha-wrap[data-v-dfdde7e0] .picker,.hue-wrap[data-v-dfdde7e0] .picker{border-radius:6px;box-shadow:0 1px 4px #0000005e;height:12px;transform:translate(-6px,-2px);width:12px}.body[data-v-dfdde7e0]{background-color:var(--vc-body-bg);padding:16px 16px 12px}.saturation[data-v-dfdde7e0]{border-radius:2px 2px 0 0;overflow:hidden;padding-bottom:55%;position:relative;width:100%}.saturation[data-v-dfdde7e0] .picker{height:12px;transform:translate(-6px,-6px);width:12px}.fields[data-v-dfdde7e0] .vc-input-input{background-color:var(--vc-input-bg);border:none;border-radius:2px;box-shadow:inset 0 0 0 1px var(--vc-input-border);color:var(--vc-input-text);font-size:11px;height:21px;text-align:center;width:100%}.fields[data-v-dfdde7e0] .vc-input-label{color:var(--vc-input-label);display:block;font-size:11px;line-height:11px;margin-top:12px;text-align:center;text-transform:uppercase}.alpha-disabled[data-v-dfdde7e0] .active-color{height:18px;width:18px}.alpha-disabled[data-v-dfdde7e0] .color-wrap{width:30px}.alpha-disabled[data-v-dfdde7e0] .hue-wrap{margin-bottom:4px;margin-top:4px}.vc-compact-picker[data-v-91d11fa7]{background-color:var(--vc-body-bg);border-radius:2px;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;box-sizing:border-box;padding-left:5px;padding-top:5px;width:245px}.colors[data-v-91d11fa7]{margin:0;overflow:hidden;padding:0}.color-item[data-v-91d11fa7]{cursor:pointer;float:left;height:15px;list-style:none;margin-bottom:5px;margin-right:5px;position:relative;width:15px}.color-item_white[data-v-91d11fa7]{box-shadow:inset 0 0 0 1px #ddd}.color-item_white .dot[data-v-91d11fa7]{background:#000}.dot[data-v-91d11fa7]{background:#fff;border-radius:50%;inset:5px;opacity:1;position:absolute}.vc-grayscale-picker[data-v-631223a5]{background-color:var(--vc-body-bg);border-radius:2px;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;box-sizing:border-box;padding-left:5px;padding-top:5px;width:245px}.colors[data-v-631223a5]{margin:0;overflow:hidden;padding:0}.color-item[data-v-631223a5]{cursor:pointer;float:left;height:15px;list-style:none;margin-bottom:5px;margin-right:5px;position:relative;width:15px}.color-item_white[data-v-631223a5]{box-shadow:inset 0 0 0 1px #ddd}.color-item_white .dot[data-v-631223a5]{background:#000}.dot[data-v-631223a5]{background:#fff;border-radius:50%;inset:5px;opacity:1;position:absolute}.vc-material-picker[data-v-8f86229c]{background-color:var(--vc-body-bg);border-radius:2px;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Helvetica Neue,Arial,sans-serif;height:98px;padding:16px;position:relative;width:98px}.vc-material-picker[data-v-8f86229c] .vc-input-input{background-color:var(--vc-body-bg);color:var(--vc-input-text);font-size:15px;height:30px;margin-top:12px;width:100%}.vc-material-picker[data-v-8f86229c] .vc-input-label{color:var(--vc-input-label);font-size:11px;left:0;position:absolute;top:0}.hex[data-v-8f86229c]{border-bottom-style:solid;border-bottom-width:2px}.rgb[data-v-8f86229c]{display:flex;margin-right:-10px;padding-top:11px}.color[data-v-8f86229c]{flex:1;padding-right:10px}.vc-photoshop-picker[data-v-b69df0e5]{background:var(--vc-ps-bg);border-radius:4px;box-shadow:0 0 0 1px #00000040,0 8px 16px #00000026;box-sizing:initial;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Helvetica Neue,Arial,sans-serif;width:513px}.fields_disabled[data-v-b69df0e5]{width:390px}.title[data-v-b69df0e5]{background-image:linear-gradient(-180deg,var(--vc-ps-title-bg-gradient-start) 0,var(--vc-ps-title-bg-gradient-end) 100%);border-bottom:1px solid var(--vc-ps-title-border);border-radius:4px 4px 0 0;box-shadow:inset 0 1px #fff3,inset 0 -1px #00000005;color:var(--vc-ps-title-color);font-size:13px;height:23px;line-height:24px;text-align:center}.body[data-v-b69df0e5]{display:flex;padding:15px}.saturation[data-v-b69df0e5]{border-bottom:2px solid var(--vc-ps-slider-border);border:2px solid var(--vc-ps-slider-border);border-bottom-color:var(--vc-ps-slider-border-bottom);height:256px;overflow:hidden;position:relative;width:256px}.saturation[data-v-b69df0e5] .picker{height:12px;transform:translate(-6px,-6px);width:12px}.hue[data-v-b69df0e5]{border-bottom:2px solid var(--vc-ps-slider-border);border:2px solid var(--vc-ps-slider-border);border-bottom-color:var(--vc-ps-slider-border-bottom);height:256px;margin-left:10px;width:19px}.hue-picker[data-v-b69df0e5]{position:relative}.hue-picker-left[data-v-b69df0e5],.hue-picker-right[data-v-b69df0e5]{border-color:transparent transparent transparent var(--vs-ps-picker-border-dark);border-style:solid;border-width:5px 0 5px 8px;cursor:pointer;height:0;position:absolute;width:0}.hue-picker-left[data-v-b69df0e5]:after,.hue-picker-right[data-v-b69df0e5]:after{border-color:transparent transparent transparent var(--vs-ps-picker-border-white);border-style:solid;border-width:4px 0 4px 6px;content:"";height:0;left:1px;position:absolute;top:1px;transform:translate(-8px,-5px);width:0}.hue-picker-left[data-v-b69df0e5]{transform:translate(-10px,-4px)}.hue-picker-right[data-v-b69df0e5]{transform:translate(21px,-4px) rotate(180deg)}.controls[data-v-b69df0e5]{display:flex;margin-left:10px;width:180px}.controls_fields_disabled[data-v-b69df0e5]{width:auto}.actions[data-v-b69df0e5]{flex:1;margin-left:20px}.action-btn[data-v-b69df0e5]{background-image:linear-gradient(-180deg,var(--vc-ps-btn-gradient-start) 0,var(--vc-ps-btn-gradient-end) 100%);border:1px solid var(--vc-ps-btn-border);border-radius:2px;box-shadow:0 1px 0 0 var(--vc-ps-btn-shadow);color:var(--vc-ps-btn-color);cursor:pointer;font-size:14px;height:20px;line-height:20px;margin-bottom:10px;text-align:center}.preview[data-v-b69df0e5]{width:60px}.preview-swatches[data-v-b69df0e5]{border-bottom:1px solid var(--vc-ps-slider-border);border:1px solid var(--vc-ps-slider-border);border-bottom-color:var(--vc-ps-slider-border-bottom);margin-bottom:2px;margin-top:1px}.preview-color[data-v-b69df0e5]{box-shadow:inset 1px 0 var(--vc-ps-preview-border),inset -1px 0 var(--vc-ps-preview-border),inset 0 1px var(--vc-ps-preview-border);height:34px}.preview-label[data-v-b69df0e5]{color:var(--vc-ps-label);font-size:14px;text-align:center}.fields[data-v-b69df0e5]{padding-bottom:9px;padding-top:5px;position:relative;width:80px}.fields[data-v-b69df0e5] .vc-input-input{background-color:var(--vc-input-bg);border:1px solid var(--vc-ps-input-border);box-shadow:inset 0 1px 1px var(--vc-ps-input-shadow-dark),0 1px 0 0 var(--vc-ps-input-shadow-light);color:var(--vc-ps-label);font-size:13px;height:18px;margin-bottom:5px;margin-left:40%;margin-right:10px;padding-left:3px;width:40%}.fields[data-v-b69df0e5] .vc-input-desc,.fields[data-v-b69df0e5] .vc-input-label{color:var(--vc-ps-label);font-size:13px;height:18px;line-height:22px;position:absolute;text-transform:uppercase;top:0}.fields[data-v-b69df0e5] .vc-input-label{left:0;width:34px}.fields[data-v-b69df0e5] .vc-input-desc{right:0;width:0}.fields-divider[data-v-b69df0e5]{height:5px}.hex[data-v-b69df0e5] .vc-input-input{border:1px solid var(--vc-ps-input-border);box-shadow:inset 0 1px 1px var(--vc-ps-input-shadow-dark),0 1px 0 0 var(--vc-ps-input-shadow-light);font-size:13px;height:18px;margin-bottom:6px;margin-left:20%;padding-left:3px;width:80%}.hex[data-v-b69df0e5] .vc-input-label{font-size:13px;height:18px;left:0;line-height:22px;position:absolute;text-transform:uppercase;top:0;width:14px}.vc-sketch-picker[data-v-fdb7d989]{background:var(--vc-body-bg);border-radius:4px;box-shadow:0 0 0 1px #00000026,0 8px 16px #00000026;box-sizing:initial;font-family:Menlo,Consolas,Courier New,monospace;padding:10px 10px 0;position:relative;width:200px}.saturation[data-v-fdb7d989]{overflow:hidden;padding-bottom:75%;position:relative;width:100%}.controls[data-v-fdb7d989]{display:flex}.sliders[data-v-fdb7d989]{flex:1;padding:4px 0}.alpha[data-v-fdb7d989] .gradient,.hue[data-v-fdb7d989] .container{border-radius:2px}.hue[data-v-fdb7d989]{height:10px;position:relative}.alpha[data-v-fdb7d989]{height:10px}.alpha[data-v-fdb7d989],.color[data-v-fdb7d989]{margin-top:4px;overflow:hidden;position:relative}.color[data-v-fdb7d989]{border-radius:2px;height:24px;margin-left:4px;width:24px}.active-color[data-v-fdb7d989]{box-shadow:inset 0 0 0 1px #00000026,inset 0 0 4px #00000040;inset:0;position:absolute;z-index:2}.color[data-v-fdb7d989] .vc-checkerboard{background-size:auto}.field[data-v-fdb7d989]{display:flex;padding-top:4px}.field[data-v-fdb7d989] .vc-input-input{background-color:var(--vc-input-bg);border:none;box-shadow:inset 0 0 0 1px var(--vc-input-border);color:var(--vc-input-text);font-size:10px;padding:4px 0 3px 10%;width:90%}.field[data-v-fdb7d989] .vc-input-label{color:var(--vc-sketch-input-label);display:block;font-size:11px;padding-bottom:4px;padding-top:3px;text-align:center}.field_single[data-v-fdb7d989]{flex:1;padding-left:6px}.field_double[data-v-fdb7d989]{flex:2}.presets[data-v-fdb7d989]{border-top:1px solid var(--vc-sketch-presets-border);margin-left:-10px;margin-right:-10px;padding-left:10px;padding-top:10px}.preset-color[data-v-fdb7d989]{cursor:pointer;display:inline-block;height:16px;margin:0 10px 10px 0;overflow:hidden;position:relative;vertical-align:top;width:16px}.preset-color[data-v-fdb7d989],.preset-color[data-v-fdb7d989] .vc-checkerboard{border-radius:3px;box-shadow:inset 0 0 0 1px #00000026}.alpha-disabled .color[data-v-fdb7d989]{height:10px}.vc-slider-picker[data-v-675d6988]{position:relative;width:410px}.hue[data-v-675d6988]{height:12px;position:relative}.alpha[data-v-675d6988] .picker,.hue[data-v-675d6988] .picker{border-radius:6px;box-shadow:0 1px 4px #0000005e;height:14px;transform:translate(-7px,-2px);width:14px}.alpha[data-v-675d6988]{height:12px;margin-top:20px;position:relative}.swatches[data-v-675d6988]{display:flex;margin-top:20px}.swatch[data-v-675d6988]{flex:1;margin-right:1px;width:20%}.swatch[data-v-675d6988]:first-child{margin-right:1px}.swatch:first-child .picker[data-v-675d6988]{border-radius:2px 0 0 2px}.swatch[data-v-675d6988]:last-child{margin-right:0}.swatch:last-child .picker[data-v-675d6988]{border-radius:0 2px 2px 0}.picker[data-v-675d6988]{cursor:pointer;height:12px}.swatch:nth-child(n) .picker_active[data-v-675d6988]{border-radius:3.6px/2px;transform:scaleY(1.8)}.picker_white[data-v-675d6988]{box-shadow:inset 0 0 0 1px #ddd}.picker_active.picker_white[data-v-675d6988]{box-shadow:inset 0 0 0 .6px #ddd}.vc-swatches-picker[data-v-3427cb2a]{background-color:var(--vc-body-bg);box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;height:240px;overflow-y:scroll;width:320px}.box[data-v-3427cb2a]{overflow:hidden;padding:16px 0 6px 16px}.colorGroup[data-v-3427cb2a]{float:left;margin-right:10px;padding-bottom:10px;width:40px}.color[data-v-3427cb2a]{border-radius:2px 2px 0 0;box-sizing:border-box;cursor:pointer;height:24px;margin-bottom:1px;overflow:hidden;width:40px}.color_white[data-v-3427cb2a]{border:1px solid #ddd}.picker[data-v-3427cb2a]{fill:#fff;display:block;margin-left:8px}.color_white .picker[data-v-3427cb2a]{fill:#333}.vc-twitter-picker[data-v-e74ac697]{background:var(--vc-body-bg);border:0 solid rgba(0,0,0,.25);border-radius:4px;box-shadow:0 1px 4px #00000040;position:relative}.triangle[data-v-e74ac697]{border-color:transparent transparent var(--vc-body-bg) transparent;border-style:solid;border-width:0 9px 10px;height:0;position:absolute;width:0}.triangle_shadow[data-v-e74ac697]{border-color:transparent transparent rgba(0,0,0,.1);border-style:solid;border-width:0 9px 10px;height:0;position:absolute;width:0}.body[data-v-e74ac697]{padding:15px 9px 9px 15px}.vc-twitter-picker[data-v-e74ac697] .vc-editable-input{position:relative}.vc-twitter-picker[data-v-e74ac697] .vc-input-input{background-color:var(--vc-twitter-input-bg);border:0;border-radius:0 4px 4px 0;box-shadow:inset 0 0 0 1px var(--vc-twitter-input-border);box-sizing:content-box;color:var(--vc-twitter-input-color);float:left;font-size:14px;height:28px;outline:none;padding:1px 1px 1px 8px;width:100px}.vc-twitter-picker[data-v-e74ac697] .vc-editable-input span{display:none}.hash[data-v-e74ac697]{align-items:center;background:var(--vc-twitter-hash-bg);border-radius:4px 0 0 4px;color:var(--vc-twitter-hash-color);display:flex;float:left;height:30px;justify-content:center;width:30px}.swatch[data-v-e74ac697]{border-radius:4px;cursor:pointer;float:left;height:30px;margin:0 6px 6px 0;outline:none;position:relative;width:30px}.clear[data-v-e74ac697]{clear:both}.tri_hide .triangle[data-v-e74ac697],.tri_hide .triangle_shadow[data-v-e74ac697]{display:none}.tri_top_left .triangle[data-v-e74ac697]{left:12px;top:-10px}.tri_top_left .triangle_shadow[data-v-e74ac697]{left:12px;top:-11px}.tri_top_right .triangle[data-v-e74ac697]{right:12px;top:-10px}.tri_top_right .triangle_shadow[data-v-e74ac697]{right:12px;top:-11px}.vc-hue-wrap[data-v-b3ac1ab2]{height:8px}.vc-hue-wrap[data-v-b3ac1ab2] .slider{border-radius:4px}.vc-hue-wrap[data-v-b3ac1ab2] .picker{background-color:var(--46ac36b6);border:2px solid #fff;border-radius:50%;box-shadow:none;height:20px;margin:0;transform:translate(-12px) translateY(-8px);width:20px}.vc-hsl-sliders[data-v-2e071f54]{font-family:Menlo,Consolas,Courier New,monospace;position:relative;width:100%}.slider-wrap[data-v-2e071f54]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-2e071f54]:last-of-type{margin-bottom:0}.label[data-v-2e071f54]{color:var(--vc-input-text);display:block;font-size:12px;height:24px;line-height:24px;text-align:center;text-transform:uppercase}.vc-hsl-sliders[data-v-2e071f54] .vc-base-slider{height:14px;margin-top:5px}.vc-hsl-sliders[data-v-2e071f54] .background{border:1px solid var(--vc-input-border);border-radius:4px}.gradient[data-v-2e071f54]{height:100%;width:100%}.vc-hsl-sliders[data-v-2e071f54] .picker{border:2px solid #fff;border-radius:50%;box-shadow:none;height:20px;margin:0;transform:translate(-12px) translateY(-5px);width:20px}.h-slider[data-v-2e071f54] .picker{background-color:var(--41b5b6d0)}.l-slider[data-v-2e071f54] .picker,.s-slider[data-v-2e071f54] .picker{background-color:var(--05fbe691)}.vc-hsl-sliders[data-v-2e071f54] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-hsl-sliders[data-v-2e071f54] .vc-input-input{background:none;color:var(--vc-input-text);font-size:12px;text-align:center;width:50px}.vc-hsv-sliders[data-v-d6cfe1d9]{font-family:Menlo,Consolas,Courier New,monospace;position:relative;width:100%}.slider-wrap[data-v-d6cfe1d9]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-d6cfe1d9]:last-of-type{margin-bottom:0}.label[data-v-d6cfe1d9]{color:var(--vc-input-text);display:block;font-size:12px;height:24px;line-height:24px;text-align:center;text-transform:uppercase}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-base-slider{height:14px;margin-top:5px}.vc-hsv-sliders[data-v-d6cfe1d9] .background{border:1px solid var(--vc-input-border);border-radius:4px}.gradient[data-v-d6cfe1d9]{height:100%;width:100%}.vc-hsv-sliders[data-v-d6cfe1d9] .picker{border:2px solid #fff;border-radius:50%;box-shadow:none;height:20px;margin:0;transform:translate(-12px) translateY(-5px);width:20px}.h-slider[data-v-d6cfe1d9] .picker{background-color:var(--f666f450)}.b-slider[data-v-d6cfe1d9] .picker,.s-slider[data-v-d6cfe1d9] .picker{background-color:var(--46b90cce)}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-input-input{background:none;color:var(--vc-input-text);font-size:12px;text-align:center;width:50px}.vc-rgb-sliders[data-v-98b3b212]{font-family:Menlo,Consolas,Courier New,monospace;position:relative;width:100%}.slider-wrap[data-v-98b3b212]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-98b3b212]:last-of-type{margin-bottom:0}.label[data-v-98b3b212]{color:var(--vc-input-text);display:block;font-size:12px;height:24px;line-height:24px;text-align:center;text-transform:uppercase}.vc-rgb-sliders[data-v-98b3b212] .vc-base-slider{height:14px;margin-top:5px}.vc-rgb-sliders[data-v-98b3b212] .background{border:1px solid var(--vc-input-border);border-radius:4px}.gradient[data-v-98b3b212]{height:100%;width:100%}.vc-rgb-sliders[data-v-98b3b212] .picker{border:2px solid #fff;border-radius:50%;box-shadow:none;height:20px;margin:0;transform:translate(-12px) translateY(-5px);width:20px}.slider-wrap[data-v-98b3b212]:not(.a-slider) .picker{background-color:var(--5f730604)}.vc-rgb-sliders[data-v-98b3b212] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-rgb-sliders[data-v-98b3b212] .vc-input-input{background:none;color:var(--vc-input-text);font-size:12px;text-align:center;width:50px}',"",{version:3,sources:["webpack://./node_modules/vue-color/dist/vue-color.css"],names:[],mappings:"AAAA,MAAM,sBAAuB,CAAC,iBAAkB,CAAC,kBAAmB,CAAC,oBAAqB,CAAC,wBAAyB,CAAC,yBAA0B,CAAC,uCAAwC,CAAC,kBAAmB,CAAC,uCAAwC,CAAC,qCAAsC,CAAC,4BAA6B,CAAC,2BAA4B,CAAC,6BAA8B,CAAC,oCAAqC,CAAC,+BAAgC,CAAC,gCAAiC,CAAC,+BAAgC,CAAC,gCAAiC,CAAC,0BAA2B,CAAC,0BAA2B,CAAC,sBAAuB,CAAC,2BAA4B,CAAC,kBAAmB,CAAC,yBAA0B,CAAC,wCAAyC,CAAC,kCAAmC,CAAC,4BAA6B,CAAC,+BAAgC,CAAC,0BAA2B,CAAC,iCAAkC,CAAC,6BAA8B,CAAC,4BAA6B,CAAC,+BAAgC,CAAC,WAAW,oBAAqB,CAAC,sBAAuB,CAAC,qBAAsB,CAAC,uBAAwB,CAAC,qBAAyB,CAAC,sBAA0B,CAAC,0CAA2C,CAAC,4BAAgC,CAAC,kCAAmC,CAAC,iCAAkC,CAAC,6BAAiC,CAAC,4BAA6B,CAAC,+BAAgC,CAAC,0BAA2B,CAAC,kBAAmB,CAAC,uCAAwC,CAAC,qCAAsC,CAAC,4BAA6B,CAAC,wBAA4B,CAAC,6BAA8B,CAAC,oCAAqC,CAAC,kCAAmC,CAAC,gCAAoC,CAAC,kCAAmC,CAAC,gCAAiC,CAAC,0BAA2B,CAAC,0BAA2B,CAAC,sBAA0B,CAAC,8BAA+B,CAAC,kBAAsB,CAAC,yBAA6B,CAAC,yCAA6C,CAAC,kCAAmC,CAAC,qBAAqB,gBAAgB,CAAmB,OAAO,CAAzB,iBAAiB,CAAS,iBAAiB,CAAC,wBAAwB,4CAA+C,CAAC,wBAAwB,2CAA6C,CAAC,8BAA8B,cAAc,CAAmB,YAAW,CAA7B,iBAA8B,CAAC,yBAAmJ,iBAAiB,CAA1G,wFAAwF,CAAzH,WAAW,CAAW,UAAU,CAA4G,8BAA6B,CAA7J,SAA8J,CAAC,iCAA8D,WAAW,CAAxC,iBAAiB,CAAwB,iBAAgB,CAAvC,UAAwC,CAAC,sDAAwE,OAAM,CAAxB,iBAAyB,CAAC,6BAA6B,eAAe,CAAC,yBAAyB,cAAc,CAAC,SAAS,CAAC,8BAA0D,YAAW,CAAvC,iBAAiB,CAAC,SAAsB,CAAC,yBAAwG,8BAA8B,CAAzE,iBAAiB,CAAC,wBAAwB,CAAgC,cAAc,CAAlH,UAAU,CAAC,cAAc,CAA0F,yBAAwB,CAArJ,SAAsJ,CAAC,gCAAgC,gBAAgB,CAAC,iBAAiB,CAAC,2BAAoE,0BAAyB,CAA3C,iBAAiB,CAA7B,WAAW,CAAtB,UAAmE,CAAC,kCAA4D,uBAAsB,CAA9B,OAAO,CAAzB,iBAAiD,CAAC,mDAAmD,iBAAiB,CAAC,2BAA6C,OAAM,CAAxB,iBAAyB,CAAC,oCAAoC,iBAAiB,CAAC,iCAAsD,QAAQ,CAAC,YAAW,CAA9B,SAAS,CAApB,UAA0C,CAAC,iCAAiC,yBAAyB,CAAC,mCAAkE,iBAAiB,CAAC,gDAAgD,CAArF,kBAAkB,CAAoE,gDAA+C,CAAjJ,WAAkJ,CAAC,2BAA2B,YAAY,CAAC,6BAA6B,iBAAiB,CAAC,UAAU,CAAC,+BAAwE,kBAAkB,CAA9B,WAAW,CAAoB,eAAe,CAA3E,iBAAiB,CAAC,UAAU,CAAgD,SAAS,CAAC,8CAAwF,oBAAmB,CAAtC,kBAAkB,CAA9B,WAAW,CAAtB,UAA8D,CAAC,0BAA0B,MAAM,CAAC,6BAA6B,YAAY,CAAC,gBAAgB,CAAC,yBAAyB,YAAY,CAAkB,MAAK,CAAtB,gBAAuB,CAAC,wBAAwB,gBAAgB,CAAC,UAAU,CAAC,6BAAyD,iBAAgB,CAAjC,gBAAgB,CAA3B,UAA6C,CAAC,8BAA2G,0BAAyB,CAAlD,cAAc,CAAhD,iBAAiB,CAAC,eAAe,CAAnD,iBAAiB,CAAkD,SAAoC,CAAC,0CAAsG,kDAAkD,CAAC,iBAAgB,CAAlG,WAAW,CAAU,SAAS,CAA3D,iBAAiB,CAAwB,QAAQ,CAA/B,UAA8G,CAAC,2BAAyD,iBAAiB,CAAC,wDAA9B,WAAW,CAA7B,iBAA0G,CAAC,6EAA6E,iBAAiB,CAAC,wEAA+F,iBAAiB,CAAgC,8BAA6B,CAA1F,WAAW,CAAmB,8BAA8B,CAAvE,UAAsG,CAAC,uBAA8C,kCAAiC,CAAxD,sBAAyD,CAAC,6BAA6E,yBAAyB,CAAC,eAAc,CAA7E,kBAAkB,CAAC,iBAAiB,CAA/C,UAAyF,CAAC,qCAAgD,WAAW,CAAC,8BAA6B,CAApD,UAAqD,CAAC,yCAAgJ,mCAAmC,CAAjG,WAAW,CAA7B,iBAAiB,CAAa,iDAAiD,CAAqC,0BAA0B,CAAC,cAAc,CAAzK,WAAW,CAA+J,iBAAgB,CAArM,UAAsM,CAAC,yCAAsF,2BAA2B,CAAxE,aAAa,CAAiB,cAAc,CAA6B,gBAAgB,CAA3E,eAAe,CAAsF,iBAAgB,CAAzC,wBAA0C,CAAC,+CAA0D,WAAU,CAArB,UAAsB,CAAC,6CAA6C,UAAU,CAAC,2CAA0D,iBAAgB,CAA/B,cAAgC,CAAC,oCAA6K,kCAAiC,CAA7H,iBAAiB,CAAuB,mDAAmD,CAAzE,qBAAqB,CAAxD,gBAAgB,CAAhC,eAAe,CAA3B,WAA2K,CAAC,yBAAmD,QAAO,CAAjC,eAAe,CAAC,SAAkB,CAAC,6BAAoI,cAAa,CAA7E,UAAU,CAAtB,WAAW,CAAtC,eAAe,CAAoD,iBAAiB,CAAlC,gBAAgB,CAAmB,iBAAiB,CAAtF,UAAqG,CAAC,mCAAmC,+BAA+B,CAAC,wCAAwC,eAAe,CAAC,sBAA8E,eAAc,CAA1C,iBAAiB,CAA3B,SAAS,CAAmB,SAAS,CAAvD,iBAAuE,CAAC,sCAA+K,kCAAiC,CAA7H,iBAAiB,CAAuB,mDAAmD,CAAzE,qBAAqB,CAApE,gBAAgB,CAAhC,eAAe,CAAkB,WAA0I,CAAC,yBAAmD,QAAO,CAAjC,eAAe,CAAC,SAAkB,CAAC,6BAAoI,cAAa,CAA7E,UAAU,CAAtB,WAAW,CAAtC,eAAe,CAAoD,iBAAiB,CAAlC,gBAAgB,CAAmB,iBAAiB,CAAtF,UAAqG,CAAC,mCAAmC,+BAA+B,CAAC,wCAAwC,eAAe,CAAC,sBAA8E,eAAc,CAA1C,iBAAiB,CAA3B,SAAS,CAAmB,SAAS,CAAvD,iBAAuE,CAAC,qCAAiK,kCAAkC,CAAxG,iBAAiB,CAAC,mDAAmD,CAAoC,qFAAoF,CAAtN,WAAW,CAAC,YAAY,CAArD,iBAAiB,CAAC,UAAkO,CAAC,qDAA4F,kCAAkC,CAAC,0BAA0B,CAAC,cAAa,CAAvG,WAAW,CAAC,eAAe,CAAtC,UAAmH,CAAC,qDAAmG,2BAA0B,CAAzC,cAAc,CAArB,MAAM,CAA9B,iBAAiB,CAAC,KAAuD,CAAC,sBAA8C,yBAAwB,CAAhD,uBAAiD,CAAC,sBAAsB,YAAY,CAAC,kBAAkB,CAAC,gBAAgB,CAAC,wBAAwB,MAAM,CAAC,kBAAkB,CAAC,sCAAkD,0BAA0B,CAAC,iBAAiB,CAAC,mDAAmD,CAAC,kBAAkB,CAAC,qFAAoF,CAApN,WAAqN,CAAC,kCAAkC,WAAW,CAAC,wBAAoC,wHAAyH,CAAC,iDAAiD,CAAC,yBAAyB,CAAC,mDAAmD,CAAC,8BAA8B,CAAC,cAAc,CAAnT,WAAW,CAAyS,gBAAgB,CAAC,iBAAiB,CAAC,uBAAoC,YAAW,CAAxB,YAAyB,CAAC,6BAAwE,kDAA2C,CAAC,2CAAyD,CAAzD,qDAAyD,CAApI,YAAY,CAAyH,eAAc,CAAtI,iBAAiB,CAA1C,WAAgK,CAAC,qCAAgD,WAAW,CAAC,8BAA6B,CAApD,UAAqD,CAAC,sBAA+D,kDAA2C,CAAC,2CAAwD,CAAxD,qDAAwD,CAA7I,YAAY,CAAY,gBAAgB,CAA3B,UAAiI,CAAC,6BAA6B,iBAAiB,CAAC,qEAAsJ,gFAAgF,CAA9H,kBAAkB,CAAC,0BAA0B,CAAkF,cAAa,CAArJ,QAAQ,CAAlC,iBAAiB,CAAC,OAA8J,CAAC,iFAA2J,iFAAiF,CAA/H,kBAAkB,CAAC,0BAA0B,CAAzE,UAAU,CAAS,QAAQ,CAA2J,QAAQ,CAAlC,iBAAiB,CAAC,OAAO,CAAU,8BAA6B,CAAjN,OAAkN,CAAC,kCAAkC,+BAA+B,CAAC,mCAAmC,6CAA6C,CAAC,2BAAwD,YAAW,CAA5B,gBAAgB,CAA5B,WAAyC,CAAC,2CAA2C,UAAU,CAAC,0BAA2C,MAAK,CAAtB,gBAAuB,CAAC,6BAA4D,8GAA+G,CAAC,wCAAwC,CAAC,iBAAiB,CAAC,4CAA4C,CAAgB,4BAA4B,CAA3C,cAAc,CAA8B,cAAc,CAAjT,WAAW,CAAuS,gBAAgB,CAAtT,kBAAkB,CAAqS,iBAAiB,CAAC,0BAA0B,UAAU,CAAC,mCAAmC,kDAA2C,CAAC,2CAAyD,CAAzD,qDAAyD,CAAC,iBAAiB,CAAC,cAAc,CAAC,gCAA4C,mIAAkI,CAA9I,WAA+I,CAAC,gCAAgC,wBAAwB,CAAC,cAAc,CAAC,iBAAiB,CAAC,yBAAyC,kBAAkB,CAAlC,eAAe,CAA+B,iBAAgB,CAA3B,UAA4B,CAAC,yCAAmR,mCAAmC,CAAlL,0CAA0C,CAAC,mGAAmG,CAAqC,wBAAwB,CAAC,cAAa,CAA1S,WAAW,CAAmC,iBAAiB,CAAnD,eAAe,CAAC,iBAAiB,CAAmB,gBAAgB,CAA1F,SAAqT,CAAC,iFAAqH,wBAAwB,CAAC,cAAc,CAAnD,WAAW,CAAyC,gBAAgB,CAA5F,iBAAiB,CAA4E,wBAAuB,CAAlG,KAAmG,CAAC,yCAAyC,MAAM,CAAC,UAAU,CAAC,wCAAwC,OAAO,CAAC,OAAO,CAAC,iCAAiC,UAAU,CAAC,sCAA+G,0CAA0C,CAAC,mGAAmG,CAAC,cAAa,CAA3N,WAAW,CAAiB,iBAAiB,CAAjC,eAAe,CAAmB,gBAAgB,CAAxE,SAAsO,CAAC,sCAAyG,cAAc,CAAC,WAAW,CAArE,MAAM,CAAgE,gBAAe,CAA7G,iBAAiB,CAAyB,wBAAwB,CAAhD,KAAK,CAAQ,UAA+E,CAAC,mCAAwG,4BAA4B,CAAC,iBAAiB,CAAC,mDAAmD,CAArH,kBAAkB,CAAoG,gDAA+C,CAAzL,mBAAmB,CAAjD,iBAAiB,CAAC,WAAsM,CAAC,6BAA6E,eAAc,CAAnD,kBAAkB,CAAC,iBAAiB,CAA/C,UAA+D,CAAC,2BAA2B,YAAY,CAAC,0BAAwC,MAAK,CAAnB,aAAoB,CAAC,mEAAmE,iBAAiB,CAAC,sBAAwC,WAAU,CAA5B,iBAA6B,CAAC,wBAA0C,WAA0C,CAAC,gDAA/B,cAAc,CAAC,eAAc,CAA3D,iBAA8L,CAAjI,wBAAgG,iBAAiB,CAA9E,WAAW,CAAkC,eAAe,CAAvE,UAAyG,CAAC,+BAAyD,4DAA4D,CAApE,OAAO,CAAzB,iBAAiB,CAAsE,SAAS,CAAC,yCAAyC,oBAAoB,CAAC,wBAAwB,YAAY,CAAC,eAAe,CAAC,wCAAsI,mCAAmC,CAAjG,WAAW,CAAC,iDAAiD,CAAqC,0BAA0B,CAAC,cAAa,CAAhK,qBAAqB,CAA/B,SAA2K,CAAC,wCAAyF,kCAAkC,CAAnF,aAAa,CAAuE,cAAc,CAApE,kBAAkB,CAAlC,eAAe,CAAsE,iBAAiB,CAAC,+BAA+B,MAAM,CAAC,gBAAgB,CAAC,+BAA+B,MAAM,CAAC,0BAAkG,oDAAmD,CAAxG,iBAAiB,CAApC,kBAAkB,CAAmB,iBAAiB,CAAC,gBAAqE,CAAC,+BAAgJ,cAAc,CAA3E,oBAAoB,CAAmE,WAAW,CAA7E,oBAAoB,CAA3E,eAAe,CAAC,iBAAiB,CAA2C,kBAAkB,CAAgB,UAA2D,CAAC,+EAA5L,iBAAiB,CAAsI,oCAA2I,CAAC,wCAAwC,WAAW,CAAC,mCAAmC,iBAAiB,CAAC,WAAW,CAAC,sBAAsB,WAAW,CAAC,iBAAiB,CAAC,8DAAqF,iBAAiB,CAAC,8BAA8B,CAA5D,WAAW,CAAkD,8BAA6B,CAArG,UAAsG,CAAC,wBAAwB,WAAW,CAAmB,eAAc,CAAhC,iBAAiC,CAAC,2BAA2B,YAAY,CAAC,eAAe,CAAC,yBAA0C,MAAM,CAAvB,gBAAgB,CAAQ,SAAS,CAAC,qCAAqC,gBAAgB,CAAC,6CAA6C,yBAAyB,CAAC,oCAAoC,cAAc,CAAC,4CAA4C,yBAAyB,CAAC,yBAAyB,cAAc,CAAC,WAAW,CAAC,qDAA2E,uBAAsB,CAA5C,qBAA6C,CAAC,+BAA+B,+BAA+B,CAAC,6CAA6C,gCAAgC,CAAC,qCAAgF,kCAAkC,CAAC,mDAAkD,CAApH,YAAY,CAAC,iBAAiB,CAA1C,WAAiI,CAAC,sBAA8C,eAAc,CAAtC,uBAAuC,CAAC,6BAA4D,UAAU,CAAC,iBAAgB,CAA1D,mBAAmB,CAAC,UAAuC,CAAC,wBAAkP,yBAAwB,CAAlP,qBAAqB,CAA0C,cAAc,CAA5C,WAAW,CAAC,iBAAiB,CAAgB,eAAe,CAAvE,UAA6N,CAAC,8BAA8B,qBAAqB,CAAC,yBAAuC,SAAS,CAAvB,aAAa,CAAW,eAAe,CAAC,sCAAsC,SAAS,CAAC,oCAAsD,4BAA4B,CAAC,8BAA8B,CAAgC,iBAAgB,CAA/C,8BAA8B,CAA5G,iBAA8H,CAAC,2BAAiH,kEAAiE,CAAhH,kBAAkB,CAAC,uBAA2B,CAAzD,QAAU,CAAtC,iBAAiB,CAAC,OAAsI,CAAC,kCAAsG,mDAA+D,CAA/D,kBAA+D,CAA/D,uBAA+D,CAAzH,QAAU,CAAgH,iBAAgB,CAApJ,OAAqJ,CAAC,uBAAuB,yBAAyB,CAAC,uDAAuD,iBAAiB,CAAC,oDAAkP,2CAA2C,CAAhF,QAAU,CAAC,yBAAyB,CAArH,yDAAyD,CAAC,sBAAsB,CAAkF,mCAAmC,CAA7Q,UAAU,CAAoQ,cAAa,CAApQ,WAAW,CAAyB,YAAY,CAApC,uBAAuB,CAA/C,WAAiR,CAAC,4DAA4D,YAAY,CAAC,uBAA+C,kBAAkB,CAAyE,oCAAoC,CAA9D,yBAAyB,CAAsC,kCAAiC,CAA9K,YAAY,CAAvB,UAAU,CAAwD,WAAW,CAAlC,sBAAsB,CAAa,UAA4G,CAAC,yBAA2D,iBAAiB,CAAoB,cAAc,CAA9D,UAAU,CAAtB,WAAW,CAA8B,kBAAkB,CAAkC,YAAW,CAA7B,iBAAiB,CAAvG,UAAoH,CAAC,wBAAwB,UAAU,CAAC,iFAAiF,YAAY,CAAC,yCAAmD,SAAQ,CAAlB,SAAmB,CAAC,gDAA0D,SAAQ,CAAlB,SAAmB,CAAC,0CAAoD,UAAS,CAAnB,SAAoB,CAAC,iDAA2D,UAAS,CAAnB,SAAoB,CAAC,8BAA8B,UAAU,CAAC,sCAAsC,iBAAiB,CAAC,sCAA+H,gCAAgC,CAAvD,qBAAsB,CAAxD,iBAAiB,CAAC,eAAe,CAAtD,WAAW,CAAC,QAAQ,CAA2F,2CAA0C,CAApK,UAAqK,CAAC,iCAA8D,gDAA+C,CAA5E,iBAAiB,CAAC,UAA2D,CAAC,8BAA8B,YAAY,CAAC,QAAQ,CAAC,WAAW,CAAC,kBAAkB,CAAC,2CAA2C,eAAe,CAAC,wBAAkD,0BAA0B,CAApD,aAAa,CAAwC,cAAc,CAArD,WAAW,CAA2C,gBAAgB,CAA0B,iBAAgB,CAAzC,wBAA0C,CAAC,iDAAgE,WAAU,CAAzB,cAA0B,CAAC,6CAA+D,uCAAsC,CAAxD,iBAAyD,CAAC,2BAAsC,WAAU,CAArB,UAAsB,CAAC,yCAA2G,qBAAsB,CAAxD,iBAAiB,CAAC,eAAe,CAAtD,WAAW,CAAC,QAAQ,CAA0D,2CAA0C,CAAnI,UAAoI,CAAC,mCAAmC,gCAAgC,CAAC,sEAAsE,gCAAgC,CAAC,oDAAoD,8CAA8C,CAAC,iDAA4D,eAAe,CAAC,0BAA0B,CAAC,cAAc,CAAC,iBAAgB,CAArF,UAAsF,CAAC,iCAA8D,gDAA+C,CAA5E,iBAAiB,CAAC,UAA2D,CAAC,8BAA8B,YAAY,CAAC,QAAQ,CAAC,WAAW,CAAC,kBAAkB,CAAC,2CAA2C,eAAe,CAAC,wBAAkD,0BAA0B,CAApD,aAAa,CAAwC,cAAc,CAArD,WAAW,CAA2C,gBAAgB,CAA0B,iBAAgB,CAAzC,wBAA0C,CAAC,iDAAgE,WAAU,CAAzB,cAA0B,CAAC,6CAA+D,uCAAsC,CAAxD,iBAAyD,CAAC,2BAAsC,WAAU,CAArB,UAAsB,CAAC,yCAA2G,qBAAsB,CAAxD,iBAAiB,CAAC,eAAe,CAAtD,WAAW,CAAC,QAAQ,CAA0D,2CAA0C,CAAnI,UAAoI,CAAC,mCAAmC,gCAAgC,CAAC,sEAAsE,gCAAgC,CAAC,oDAAoD,8CAA8C,CAAC,iDAA4D,eAAe,CAAC,0BAA0B,CAAC,cAAc,CAAC,iBAAgB,CAArF,UAAsF,CAAC,iCAA8D,gDAA+C,CAA5E,iBAAiB,CAAC,UAA2D,CAAC,8BAA8B,YAAY,CAAC,QAAQ,CAAC,WAAW,CAAC,kBAAkB,CAAC,2CAA2C,eAAe,CAAC,wBAAkD,0BAA0B,CAApD,aAAa,CAAwC,cAAc,CAArD,WAAW,CAA2C,gBAAgB,CAA0B,iBAAgB,CAAzC,wBAA0C,CAAC,iDAAgE,WAAU,CAAzB,cAA0B,CAAC,6CAA+D,uCAAsC,CAAxD,iBAAyD,CAAC,2BAAsC,WAAU,CAArB,UAAsB,CAAC,yCAA2G,qBAAsB,CAAxD,iBAAiB,CAAC,eAAe,CAAtD,WAAW,CAAC,QAAQ,CAA0D,2CAA0C,CAAnI,UAAoI,CAAC,qDAAqD,gCAAgC,CAAC,oDAAoD,8CAA8C,CAAC,iDAA4D,eAAe,CAAC,0BAA0B,CAAC,cAAc,CAAC,iBAAgB,CAArF,UAAsF",sourcesContent:[':root{--vc-picker-bg: #f8f8f8;--vc-body-bg: #fff;--vc-input-bg: #fff;--vc-input-text: #333;--vc-input-label: #969696;--vc-input-border: #dadada;--vc-chrome-toggle-btn-highlighted: #eee;--vc-ps-bg: #dcdcdc;--vc-ps-title-bg-gradient-start: #f0f0f0;--vc-ps-title-bg-gradient-end: #d4d4d4;--vc-ps-title-border: #B1B1B1;--vc-ps-title-color: #4d4d4d;--vc-ps-slider-border: #b3b3b3;--vc-ps-slider-border-bottom: #f0f0f0;--vs-ps-picker-border-dark: #555;--vs-ps-picker-border-white: #fff;--vc-ps-btn-gradient-start: #fff;--vc-ps-btn-gradient-end: #e6e6e6;--vc-ps-btn-border: #878787;--vc-ps-btn-shadow: #EAEAEA;--vc-ps-btn-color: #000;--vc-ps-preview-border: #000;--vc-ps-label: #000;--vc-ps-input-border: #888;--vc-ps-input-shadow-dark: rgba(0,0,0,.1);--vc-ps-input-shadow-light: #ececec;--vc-sketch-input-label: #222;--vc-sketch-presets-border: #eee;--vc-twitter-input-bg: #fff;--vc-twitter-input-border: #f0f0f0;--vc-twitter-input-color: #666;--vc-twitter-hash-bg: #f0f0f0;--vc-twitter-hash-color: #98A1A4}:root.dark{--vc-body-bg: #424242;--vc-picker-bg: #d0d0d0;--vc-input-bg: #2c2c2c;--vc-input-text: #d0d0d0;--vc-input-label: #bbbbbb;--vc-input-border: #555555;--vc-chrome-toggle-btn-highlighted: #5c5c5c;--vc-sketch-input-label: #bbbbbb;--vc-sketch-presets-border: #5a5a5a;--vc-twitter-input-border: #383838;--vc-twitter-input-color: #bbbbbb;--vc-twitter-hash-bg: #383838;--vc-twitter-hash-color: #a0acaf;--vc-twitter-input-bg: #555;--vc-ps-bg: #424242;--vc-ps-title-bg-gradient-start: #4e4e4e;--vc-ps-title-bg-gradient-end: #3a3a3a;--vc-ps-title-border: #5a5a5a;--vc-ps-title-color: #bbbbbb;--vc-ps-slider-border: #5c5c5c;--vc-ps-slider-border-bottom: #4a4a4a;--vs-ps-picker-border-dark: #b8b8b8;--vs-ps-picker-border-white: #bbbbbb;--vc-ps-btn-gradient-start: #505050;--vc-ps-btn-gradient-end: #3a3a3a;--vc-ps-btn-border: #6a6a6a;--vc-ps-btn-shadow: #2a2a2a;--vc-ps-btn-color: #bbbbbb;--vc-ps-preview-border: #3a3a3a;--vc-ps-label: #bbbbbb;--vc-ps-input-border: #666666;--vc-ps-input-shadow-dark: rgba(0, 0, 0, .45);--vc-ps-input-shadow-light: #2d2d2d}.bg[data-v-4d048d6e]{cursor:crosshair;position:absolute;inset:0;touch-action:none}.white[data-v-4d048d6e]{background:linear-gradient(to right,#fff,#fff0)}.black[data-v-4d048d6e]{background:linear-gradient(to top,#000,#0000)}.picker-wrap[data-v-4d048d6e]{cursor:pointer;position:absolute;outline:none}.picker[data-v-4d048d6e]{cursor:move;width:4px;height:4px;box-shadow:0 0 0 1.6px var(--vc-picker-bg),inset 0 0 1px 1px #0000004d,0 0 1px 2px #0006;border-radius:50%;transform:translate(-2px,-2px)}.vc-base-slider[data-v-972b0fad]{position:relative;width:100%;height:100%;touch-action:none}.background[data-v-972b0fad],.slider[data-v-972b0fad]{position:absolute;inset:0}.background[data-v-972b0fad]{overflow:hidden}.slider[data-v-972b0fad]{cursor:pointer;z-index:2}.picker-wrap[data-v-972b0fad]{position:absolute;z-index:2;outline:none}.picker[data-v-972b0fad]{width:4px;height:8px;margin-top:1px;border-radius:1px;box-shadow:0 0 2px #0009;background:var(--vc-picker-bg);cursor:pointer;transform:translate(-2px)}.vc-hue-slider[data-v-5367c985]{cursor:crosshair;touch-action:none}.gradient[data-v-5367c985]{width:100%;height:100%;border-radius:2px;background:var(--2f44f39d)}.vc-checkerboard[data-v-37d61ccd]{position:absolute;inset:0;background-size:contain}.vc-alpha-slider[data-v-07dd346b] .vc-checkerboard{border-radius:2px}.gradient[data-v-07dd346b]{position:absolute;inset:0}.vc-editable-input[data-v-9c267b2b]{position:relative}.vc-input-input[data-v-9c267b2b]{width:100%;padding:0;border:0;outline:none}.vc-input-label[data-v-9c267b2b]{text-transform:capitalize}.vc-chrome-picker[data-v-dfdde7e0]{width:225px;box-sizing:initial;border-radius:2px;box-shadow:0 0 2px #0000004d,0 4px 8px #0000004d;font-family:Menlo,Consolas,Courier New,monospace}.controls[data-v-dfdde7e0]{display:flex}.color-wrap[data-v-dfdde7e0]{position:relative;width:36px}.active-color[data-v-dfdde7e0]{position:relative;width:30px;height:30px;border-radius:15px;overflow:hidden;z-index:1}.color-wrap[data-v-dfdde7e0] .vc-checkerboard{width:30px;height:30px;border-radius:15px;background-size:auto}.sliders[data-v-dfdde7e0]{flex:1}.fieldsWrap[data-v-dfdde7e0]{display:flex;padding-top:16px}.fields[data-v-dfdde7e0]{display:flex;margin-left:-6px;flex:1}.field[data-v-dfdde7e0]{padding-left:6px;width:100%}.toggle-btn[data-v-dfdde7e0]{width:32px;text-align:right;position:relative}.toggle-icon[data-v-dfdde7e0]{position:relative;margin-right:-4px;margin-top:12px;cursor:pointer;z-index:2;color:var(--vc-input-text)}.toggle-icon_highlighted[data-v-dfdde7e0]{position:absolute;width:24px;height:28px;top:10px;left:12px;background:var(--vc-chrome-toggle-btn-highlighted);border-radius:4px}.hue-wrap[data-v-dfdde7e0]{position:relative;height:10px;margin-bottom:8px}.alpha-wrap[data-v-dfdde7e0]{position:relative;height:10px}.hue-wrap[data-v-dfdde7e0] .container,.alpha-wrap[data-v-dfdde7e0] .gradient{border-radius:2px}.hue-wrap[data-v-dfdde7e0] .picker,.alpha-wrap[data-v-dfdde7e0] .picker{width:12px;height:12px;border-radius:6px;transform:translate(-6px,-2px);box-shadow:0 1px 4px #0000005e}.body[data-v-dfdde7e0]{padding:16px 16px 12px;background-color:var(--vc-body-bg)}.saturation[data-v-dfdde7e0]{width:100%;padding-bottom:55%;position:relative;border-radius:2px 2px 0 0;overflow:hidden}.saturation[data-v-dfdde7e0] .picker{width:12px;height:12px;transform:translate(-6px,-6px)}.fields[data-v-dfdde7e0] .vc-input-input{width:100%;height:21px;border-radius:2px;border:none;box-shadow:inset 0 0 0 1px var(--vc-input-border);background-color:var(--vc-input-bg);color:var(--vc-input-text);font-size:11px;text-align:center}.fields[data-v-dfdde7e0] .vc-input-label{display:block;margin-top:12px;font-size:11px;color:var(--vc-input-label);line-height:11px;text-transform:uppercase;text-align:center}.alpha-disabled[data-v-dfdde7e0] .active-color{width:18px;height:18px}.alpha-disabled[data-v-dfdde7e0] .color-wrap{width:30px}.alpha-disabled[data-v-dfdde7e0] .hue-wrap{margin-top:4px;margin-bottom:4px}.vc-compact-picker[data-v-91d11fa7]{width:245px;padding-top:5px;padding-left:5px;border-radius:2px;box-sizing:border-box;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;background-color:var(--vc-body-bg)}.colors[data-v-91d11fa7]{overflow:hidden;padding:0;margin:0}.color-item[data-v-91d11fa7]{list-style:none;width:15px;height:15px;float:left;margin-right:5px;margin-bottom:5px;position:relative;cursor:pointer}.color-item_white[data-v-91d11fa7]{box-shadow:inset 0 0 0 1px #ddd}.color-item_white .dot[data-v-91d11fa7]{background:#000}.dot[data-v-91d11fa7]{position:absolute;inset:5px;border-radius:50%;opacity:1;background:#fff}.vc-grayscale-picker[data-v-631223a5]{padding-top:5px;padding-left:5px;width:245px;border-radius:2px;box-sizing:border-box;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;background-color:var(--vc-body-bg)}.colors[data-v-631223a5]{overflow:hidden;padding:0;margin:0}.color-item[data-v-631223a5]{list-style:none;width:15px;height:15px;float:left;margin-right:5px;margin-bottom:5px;position:relative;cursor:pointer}.color-item_white[data-v-631223a5]{box-shadow:inset 0 0 0 1px #ddd}.color-item_white .dot[data-v-631223a5]{background:#000}.dot[data-v-631223a5]{position:absolute;inset:5px;border-radius:50%;opacity:1;background:#fff}.vc-material-picker[data-v-8f86229c]{position:relative;width:98px;height:98px;padding:16px;border-radius:2px;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;background-color:var(--vc-body-bg);font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Helvetica Neue,Arial,sans-serif}.vc-material-picker[data-v-8f86229c] .vc-input-input{width:100%;height:30px;margin-top:12px;background-color:var(--vc-body-bg);color:var(--vc-input-text);font-size:15px}.vc-material-picker[data-v-8f86229c] .vc-input-label{position:absolute;top:0;left:0;font-size:11px;color:var(--vc-input-label)}.hex[data-v-8f86229c]{border-bottom-width:2px;border-bottom-style:solid}.rgb[data-v-8f86229c]{display:flex;margin-right:-10px;padding-top:11px}.color[data-v-8f86229c]{flex:1;padding-right:10px}.vc-photoshop-picker[data-v-b69df0e5]{width:513px;background:var(--vc-ps-bg);border-radius:4px;box-shadow:0 0 0 1px #00000040,0 8px 16px #00000026;box-sizing:initial;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Helvetica Neue,Arial,sans-serif}.fields_disabled[data-v-b69df0e5]{width:390px}.title[data-v-b69df0e5]{height:23px;background-image:linear-gradient(-180deg,var(--vc-ps-title-bg-gradient-start) 0%,var(--vc-ps-title-bg-gradient-end) 100%);border-bottom:1px solid var(--vc-ps-title-border);border-radius:4px 4px 0 0;box-shadow:inset 0 1px #fff3,inset 0 -1px #00000005;color:var(--vc-ps-title-color);font-size:13px;line-height:24px;text-align:center}.body[data-v-b69df0e5]{padding:15px;display:flex}.saturation[data-v-b69df0e5]{width:256px;height:256px;position:relative;border:2px solid var(--vc-ps-slider-border);border-bottom:2px solid var(--vc-ps-slider-border-bottom);overflow:hidden}.saturation[data-v-b69df0e5] .picker{width:12px;height:12px;transform:translate(-6px,-6px)}.hue[data-v-b69df0e5]{height:256px;width:19px;margin-left:10px;border:2px solid var(--vc-ps-slider-border);border-bottom:2px solid var(--vc-ps-slider-border-bottom)}.hue-picker[data-v-b69df0e5]{position:relative}.hue-picker-left[data-v-b69df0e5],.hue-picker-right[data-v-b69df0e5]{position:absolute;width:0;height:0;border-style:solid;border-width:5px 0 5px 8px;border-color:transparent transparent transparent var(--vs-ps-picker-border-dark);cursor:pointer}.hue-picker-left[data-v-b69df0e5]:after,.hue-picker-right[data-v-b69df0e5]:after{content:"";width:0;height:0;border-style:solid;border-width:4px 0 4px 6px;border-color:transparent transparent transparent var(--vs-ps-picker-border-white);position:absolute;top:1px;left:1px;transform:translate(-8px,-5px)}.hue-picker-left[data-v-b69df0e5]{transform:translate(-10px,-4px)}.hue-picker-right[data-v-b69df0e5]{transform:translate(21px,-4px) rotate(180deg)}.controls[data-v-b69df0e5]{width:180px;margin-left:10px;display:flex}.controls_fields_disabled[data-v-b69df0e5]{width:auto}.actions[data-v-b69df0e5]{margin-left:20px;flex:1}.action-btn[data-v-b69df0e5]{height:20px;margin-bottom:10px;background-image:linear-gradient(-180deg,var(--vc-ps-btn-gradient-start) 0%,var(--vc-ps-btn-gradient-end) 100%);border:1px solid var(--vc-ps-btn-border);border-radius:2px;box-shadow:0 1px 0 0 var(--vc-ps-btn-shadow);cursor:pointer;color:var(--vc-ps-btn-color);font-size:14px;line-height:20px;text-align:center}.preview[data-v-b69df0e5]{width:60px}.preview-swatches[data-v-b69df0e5]{border:1px solid var(--vc-ps-slider-border);border-bottom:1px solid var(--vc-ps-slider-border-bottom);margin-bottom:2px;margin-top:1px}.preview-color[data-v-b69df0e5]{height:34px;box-shadow:inset 1px 0 var(--vc-ps-preview-border),inset -1px 0 var(--vc-ps-preview-border),inset 0 1px var(--vc-ps-preview-border)}.preview-label[data-v-b69df0e5]{color:var(--vc-ps-label);font-size:14px;text-align:center}.fields[data-v-b69df0e5]{padding-top:5px;padding-bottom:9px;width:80px;position:relative}.fields[data-v-b69df0e5] .vc-input-input{width:40%;height:18px;margin-left:40%;margin-right:10px;margin-bottom:5px;padding-left:3px;border:1px solid var(--vc-ps-input-border);box-shadow:inset 0 1px 1px var(--vc-ps-input-shadow-dark),0 1px 0 0 var(--vc-ps-input-shadow-light);background-color:var(--vc-input-bg);color:var(--vc-ps-label);font-size:13px}.fields[data-v-b69df0e5] .vc-input-label,.fields[data-v-b69df0e5] .vc-input-desc{position:absolute;top:0;height:18px;color:var(--vc-ps-label);font-size:13px;line-height:22px;text-transform:uppercase}.fields[data-v-b69df0e5] .vc-input-label{left:0;width:34px}.fields[data-v-b69df0e5] .vc-input-desc{right:0;width:0}.fields-divider[data-v-b69df0e5]{height:5px}.hex[data-v-b69df0e5] .vc-input-input{width:80%;height:18px;margin-left:20%;margin-bottom:6px;padding-left:3px;border:1px solid var(--vc-ps-input-border);box-shadow:inset 0 1px 1px var(--vc-ps-input-shadow-dark),0 1px 0 0 var(--vc-ps-input-shadow-light);font-size:13px}.hex[data-v-b69df0e5] .vc-input-label{position:absolute;top:0;left:0;width:14px;text-transform:uppercase;font-size:13px;height:18px;line-height:22px}.vc-sketch-picker[data-v-fdb7d989]{position:relative;width:200px;padding:10px 10px 0;box-sizing:initial;background:var(--vc-body-bg);border-radius:4px;box-shadow:0 0 0 1px #00000026,0 8px 16px #00000026;font-family:Menlo,Consolas,Courier New,monospace}.saturation[data-v-fdb7d989]{width:100%;padding-bottom:75%;position:relative;overflow:hidden}.controls[data-v-fdb7d989]{display:flex}.sliders[data-v-fdb7d989]{padding:4px 0;flex:1}.hue[data-v-fdb7d989] .container,.alpha[data-v-fdb7d989] .gradient{border-radius:2px}.hue[data-v-fdb7d989]{position:relative;height:10px}.alpha[data-v-fdb7d989]{position:relative;height:10px;margin-top:4px;overflow:hidden}.color[data-v-fdb7d989]{width:24px;height:24px;position:relative;margin-top:4px;margin-left:4px;border-radius:2px;overflow:hidden}.active-color[data-v-fdb7d989]{position:absolute;inset:0;box-shadow:inset 0 0 0 1px #00000026,inset 0 0 4px #00000040;z-index:2}.color[data-v-fdb7d989] .vc-checkerboard{background-size:auto}.field[data-v-fdb7d989]{display:flex;padding-top:4px}.field[data-v-fdb7d989] .vc-input-input{width:90%;padding:4px 0 3px 10%;border:none;box-shadow:inset 0 0 0 1px var(--vc-input-border);background-color:var(--vc-input-bg);color:var(--vc-input-text);font-size:10px}.field[data-v-fdb7d989] .vc-input-label{display:block;padding-top:3px;padding-bottom:4px;color:var(--vc-sketch-input-label);font-size:11px;text-align:center}.field_single[data-v-fdb7d989]{flex:1;padding-left:6px}.field_double[data-v-fdb7d989]{flex:2}.presets[data-v-fdb7d989]{margin-right:-10px;margin-left:-10px;padding-left:10px;padding-top:10px;border-top:1px solid var(--vc-sketch-presets-border)}.preset-color[data-v-fdb7d989]{border-radius:3px;overflow:hidden;position:relative;display:inline-block;margin:0 10px 10px 0;vertical-align:top;cursor:pointer;width:16px;height:16px;box-shadow:inset 0 0 0 1px #00000026}.preset-color[data-v-fdb7d989] .vc-checkerboard{box-shadow:inset 0 0 0 1px #00000026;border-radius:3px}.alpha-disabled .color[data-v-fdb7d989]{height:10px}.vc-slider-picker[data-v-675d6988]{position:relative;width:410px}.hue[data-v-675d6988]{height:12px;position:relative}.hue[data-v-675d6988] .picker,.alpha[data-v-675d6988] .picker{width:14px;height:14px;border-radius:6px;box-shadow:0 1px 4px #0000005e;transform:translate(-7px,-2px)}.alpha[data-v-675d6988]{height:12px;position:relative;margin-top:20px}.swatches[data-v-675d6988]{display:flex;margin-top:20px}.swatch[data-v-675d6988]{margin-right:1px;flex:1;width:20%}.swatch[data-v-675d6988]:first-child{margin-right:1px}.swatch:first-child .picker[data-v-675d6988]{border-radius:2px 0 0 2px}.swatch[data-v-675d6988]:last-child{margin-right:0}.swatch:last-child .picker[data-v-675d6988]{border-radius:0 2px 2px 0}.picker[data-v-675d6988]{cursor:pointer;height:12px}.swatch:nth-child(n) .picker_active[data-v-675d6988]{transform:scaleY(1.8);border-radius:3.6px/2px}.picker_white[data-v-675d6988]{box-shadow:inset 0 0 0 1px #ddd}.picker_active.picker_white[data-v-675d6988]{box-shadow:inset 0 0 0 .6px #ddd}.vc-swatches-picker[data-v-3427cb2a]{width:320px;height:240px;overflow-y:scroll;background-color:var(--vc-body-bg);box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029}.box[data-v-3427cb2a]{padding:16px 0 6px 16px;overflow:hidden}.colorGroup[data-v-3427cb2a]{padding-bottom:10px;width:40px;float:left;margin-right:10px}.color[data-v-3427cb2a]{box-sizing:border-box;width:40px;height:24px;margin-bottom:1px;cursor:pointer;overflow:hidden;-ms-border-radius:2px 2px 0 0;-moz-border-radius:2px 2px 0 0;-o-border-radius:2px 2px 0 0;-webkit-border-radius:2px 2px 0 0;border-radius:2px 2px 0 0}.color_white[data-v-3427cb2a]{border:1px solid #ddd}.picker[data-v-3427cb2a]{display:block;fill:#fff;margin-left:8px}.color_white .picker[data-v-3427cb2a]{fill:#333}.vc-twitter-picker[data-v-e74ac697]{position:relative;background:var(--vc-body-bg);border:0 solid rgba(0,0,0,.25);box-shadow:0 1px 4px #00000040;border-radius:4px}.triangle[data-v-e74ac697]{position:absolute;width:0px;height:0px;border-style:solid;border-width:0 9px 10px 9px;border-color:transparent transparent var(--vc-body-bg) transparent}.triangle_shadow[data-v-e74ac697]{width:0px;height:0px;border-style:solid;border-width:0 9px 10px 9px;border-color:transparent transparent rgba(0,0,0,.1) transparent;position:absolute}.body[data-v-e74ac697]{padding:15px 9px 9px 15px}.vc-twitter-picker[data-v-e74ac697] .vc-editable-input{position:relative}.vc-twitter-picker[data-v-e74ac697] .vc-input-input{float:left;width:100px;height:28px;padding:1px 1px 1px 8px;outline:none;box-shadow:inset 0 0 0 1px var(--vc-twitter-input-border);box-sizing:content-box;border:0px;border-radius:0 4px 4px 0;background-color:var(--vc-twitter-input-bg);color:var(--vc-twitter-input-color);font-size:14px}.vc-twitter-picker[data-v-e74ac697] .vc-editable-input span{display:none}.hash[data-v-e74ac697]{float:left;display:flex;align-items:center;justify-content:center;height:30px;width:30px;border-radius:4px 0 0 4px;background:var(--vc-twitter-hash-bg);color:var(--vc-twitter-hash-color)}.swatch[data-v-e74ac697]{width:30px;height:30px;float:left;border-radius:4px;margin:0 6px 6px 0;cursor:pointer;position:relative;outline:none}.clear[data-v-e74ac697]{clear:both}.tri_hide .triangle[data-v-e74ac697],.tri_hide .triangle_shadow[data-v-e74ac697]{display:none}.tri_top_left .triangle[data-v-e74ac697]{top:-10px;left:12px}.tri_top_left .triangle_shadow[data-v-e74ac697]{top:-11px;left:12px}.tri_top_right .triangle[data-v-e74ac697]{top:-10px;right:12px}.tri_top_right .triangle_shadow[data-v-e74ac697]{top:-11px;right:12px}.vc-hue-wrap[data-v-b3ac1ab2]{height:8px}.vc-hue-wrap[data-v-b3ac1ab2] .slider{border-radius:4px}.vc-hue-wrap[data-v-b3ac1ab2] .picker{width:20px;height:20px;margin:0;border-radius:50%;box-shadow:none;border:2px white solid;background-color:var(--46ac36b6);transform:translate(-12px) translateY(-8px)}.vc-hsl-sliders[data-v-2e071f54]{position:relative;width:100%;font-family:Menlo,Consolas,Courier New,monospace}.slider-wrap[data-v-2e071f54]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-2e071f54]:last-of-type{margin-bottom:0}.label[data-v-2e071f54]{display:block;height:24px;color:var(--vc-input-text);font-size:12px;line-height:24px;text-transform:uppercase;text-align:center}.vc-hsl-sliders[data-v-2e071f54] .vc-base-slider{margin-top:5px;height:14px}.vc-hsl-sliders[data-v-2e071f54] .background{border-radius:4px;border:1px solid var(--vc-input-border)}.gradient[data-v-2e071f54]{width:100%;height:100%}.vc-hsl-sliders[data-v-2e071f54] .picker{width:20px;height:20px;margin:0;border-radius:50%;box-shadow:none;border:2px white solid;transform:translate(-12px) translateY(-5px)}.h-slider[data-v-2e071f54] .picker{background-color:var(--41b5b6d0)}.s-slider[data-v-2e071f54] .picker,.l-slider[data-v-2e071f54] .picker{background-color:var(--05fbe691)}.vc-hsl-sliders[data-v-2e071f54] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-hsl-sliders[data-v-2e071f54] .vc-input-input{width:50px;background:none;color:var(--vc-input-text);font-size:12px;text-align:center}.vc-hsv-sliders[data-v-d6cfe1d9]{position:relative;width:100%;font-family:Menlo,Consolas,Courier New,monospace}.slider-wrap[data-v-d6cfe1d9]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-d6cfe1d9]:last-of-type{margin-bottom:0}.label[data-v-d6cfe1d9]{display:block;height:24px;color:var(--vc-input-text);font-size:12px;line-height:24px;text-transform:uppercase;text-align:center}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-base-slider{margin-top:5px;height:14px}.vc-hsv-sliders[data-v-d6cfe1d9] .background{border-radius:4px;border:1px solid var(--vc-input-border)}.gradient[data-v-d6cfe1d9]{width:100%;height:100%}.vc-hsv-sliders[data-v-d6cfe1d9] .picker{width:20px;height:20px;margin:0;border-radius:50%;box-shadow:none;border:2px white solid;transform:translate(-12px) translateY(-5px)}.h-slider[data-v-d6cfe1d9] .picker{background-color:var(--f666f450)}.s-slider[data-v-d6cfe1d9] .picker,.b-slider[data-v-d6cfe1d9] .picker{background-color:var(--46b90cce)}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-input-input{width:50px;background:none;color:var(--vc-input-text);font-size:12px;text-align:center}.vc-rgb-sliders[data-v-98b3b212]{position:relative;width:100%;font-family:Menlo,Consolas,Courier New,monospace}.slider-wrap[data-v-98b3b212]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-98b3b212]:last-of-type{margin-bottom:0}.label[data-v-98b3b212]{display:block;height:24px;color:var(--vc-input-text);font-size:12px;line-height:24px;text-transform:uppercase;text-align:center}.vc-rgb-sliders[data-v-98b3b212] .vc-base-slider{margin-top:5px;height:14px}.vc-rgb-sliders[data-v-98b3b212] .background{border-radius:4px;border:1px solid var(--vc-input-border)}.gradient[data-v-98b3b212]{width:100%;height:100%}.vc-rgb-sliders[data-v-98b3b212] .picker{width:20px;height:20px;margin:0;border-radius:50%;box-shadow:none;border:2px white solid;transform:translate(-12px) translateY(-5px)}.slider-wrap[data-v-98b3b212]:not(.a-slider) .picker{background-color:var(--5f730604)}.vc-rgb-sliders[data-v-98b3b212] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-rgb-sliders[data-v-98b3b212] .vc-input-input{width:50px;background:none;color:var(--vc-input-text);font-size:12px;text-align:center}\n'],sourceRoot:""}]);const a=s},887(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-actions-overlay[data-v-b0a14790]{backdrop-filter:blur(2px);background:rgba(0,0,0,.35);inset:0;position:fixed;z-index:1000}.trp-revert-confirm[data-v-b0a14790]{background:#fff;border:1px solid #e2e2e4;border-radius:8px;left:50%;max-width:350px;padding:15px;position:fixed;top:50%;transform:translate(-50%,-50%);z-index:10001}.trp-revert-actions[data-v-b0a14790]{align-items:center;display:flex;justify-content:center}.trp-revert-text[data-v-b0a14790]{text-align:center}.trp-btn-revert[data-v-b0a14790]{margin-right:10px}.trp-btn-cancel[data-v-b0a14790]{cursor:pointer}.trp-btn-cancel[data-v-b0a14790]:hover{opacity:.8}.trp-settings-actions[data-v-b0a14790]{align-items:center;display:flex;gap:12px;margin-top:24px}.trp-button-secondary[data-v-b0a14790]{height:40px}.trp-button-secondary:hover svg path[data-v-b0a14790]{fill:#fff}.trp-submit-btn[data-v-b0a14790]{align-items:center;display:flex;gap:8px}.trp-button-secondary[data-v-b0a14790]:disabled,.trp-submit-btn[data-v-b0a14790]:disabled{opacity:.8;pointer-events:none}.trp-save-spinner[data-v-b0a14790]{animation:spin-b0a14790 .6s linear infinite;border:2px solid hsla(0,0%,100%,.3);border-radius:50%;border-top-color:#fff;display:inline-block;height:14px;width:14px}@keyframes spin-b0a14790{to{transform:rotate(1turn)}}.trp-save-ls-error[data-v-b0a14790]{color:#c00;font-size:13px;margin-left:12px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/SettingsActions.vue"],names:[],mappings:"AA+GA,sCAII,yBAAyB,CADzB,0BAA0B,CAD1B,OAAQ,CADR,cAAe,CAIf,YACJ,CAEA,qCAGI,eAAmB,CACnB,wBAAyB,CACzB,iBAAkB,CAGlB,QAAS,CAFT,eAAgB,CAIhB,YAAa,CATb,cAAe,CAMf,OAAQ,CAER,8BAAgC,CAPhC,aASJ,CAEA,qCAGI,kBAAmB,CAFnB,YAAa,CACb,sBAEJ,CAEA,kCACI,iBACJ,CAEA,iCACI,iBACJ,CAEA,iCACI,cACJ,CAEA,uCACI,UACJ,CAEA,uCAEI,kBAAmB,CADnB,YAAa,CAEb,QAAS,CACT,eACJ,CAEA,uCACI,WACJ,CAEA,sDACI,SACJ,CAEA,iCAEI,kBAAmB,CADnB,YAAa,CAEb,OACJ,CAEA,0FACI,UAAY,CACZ,mBACJ,CAEA,mCAQI,2CAAoC,CAFpC,mCAAyB,CACzB,iBAAkB,CADlB,qBAAyB,CAHzB,oBAAqB,CADrB,WAAY,CADZ,UAQJ,CAEA,yBACI,GAAK,uBAA2B,CACpC,CAEA,oCACI,UAAW,CACX,cAAe,CACf,gBACJ",sourcesContent:['<script setup>\r\nimport { useSwitcherConfig } from "../composables/useSwitcherConfig"\r\nimport { inject, ref } from "vue"\r\nimport { __ }          from "@wordpress/i18n"\n\r\nconst props = defineProps({\r\n    scope: { type: String, required: true }\r\n})\r\n\r\nconst { save, revert, isDirty, saving, justSaved, errorMsg } = inject(\'switcherPersistence\')\r\n\r\nconst confirmRevert = ref(false)\r\n\r\nfunction askRevert () {\r\n    confirmRevert.value = true\r\n}\r\nfunction cancelRevert () {\r\n    confirmRevert.value = false\r\n}\r\nfunction doRevert () {\r\n    revert()\r\n    confirmRevert.value = false\r\n}\r\n\r\nconst cfg = useSwitcherConfig(props.scope)\r\n\r\nconst T = {\r\n    saving: __(\'Saving...\', \'translatepress-multilingual\'),\n    saved: __(\'Saved!\', \'translatepress-multilingual\'),\n    saveChanges: __(\'Save changes\', \'translatepress-multilingual\'),\n    revertTitle: __(\'Revert to last saved values\', \'translatepress-multilingual\'),\n    revertChanges: __(\'Revert changes\', \'translatepress-multilingual\'),\n    revertConfirmText: __(\'Restoring will revert to the last saved version and discard your current edits.\', \'translatepress-multilingual\'),\n    revertBtn: __(\'Revert\', \'translatepress-multilingual\'),\n    cancelBtn: __(\'Keep editing\', \'translatepress-multilingual\'),\n}\r\n<\/script>\r\n\r\n<template>\r\n    <teleport to="body">\r\n        <div\r\n            v-if="confirmRevert"\r\n            class="trp-actions-overlay"\r\n        />\r\n    </teleport>\r\n\r\n    <div class="trp-settings-actions">\r\n        <button\r\n            class="trp-submit-btn"\r\n            :disabled="!isDirty || saving"\r\n            @click="save"\r\n        >\r\n            <template v-if="saving">\r\n                <span class="trp-save-spinner" />\r\n                <span>{{ T.saving }}</span>\r\n            </template>\r\n\r\n            <template v-else-if="justSaved">\r\n                <span>{{ T.saved }}</span>\r\n            </template>\r\n\r\n            <template v-else>\r\n                <span>{{ T.saveChanges }}</span>\r\n            </template>\r\n        </button>\r\n\r\n        <button\r\n            class="trp-button-secondary"\r\n            :disabled="!isDirty || saving"\r\n            :title="T.revertTitle"\r\n            @click="askRevert"\r\n        >\r\n            <svg\r\n                width="14" height="14"\r\n                viewBox="0 0 14 14"\r\n                fill="none"\r\n                xmlns="http://www.w3.org/2000/svg"\r\n                style="margin-right: 6px; vertical-align: middle;"\r\n            >\r\n                <path\r\n                    d="M7.1752 0.713867C10.7452 0.713867 13.3002 3.54187 13.3002 7.01387C13.3002 10.4859 10.7452 13.3139 7.1752 13.3139C4.9352 13.3139 2.9612 12.2009 1.7992 10.5209L3.6122 9.45687C4.3822 10.5069 5.6142 11.2139 7.0002 11.2139C9.3102 11.2139 11.2002 9.26087 11.2002 7.01387C11.2002 4.76687 9.3102 2.81387 7.0002 2.81387C5.6212 2.81387 4.3962 3.51387 3.6262 4.55687L4.9002 5.61387L0.700195 7.01387V2.11387L2.0232 3.21987C3.2062 1.70087 5.0752 0.713867 7.1752 0.713867Z"\r\n                    fill="#2271B1"\r\n                />\r\n            </svg>\r\n            {{ T.revertChanges }}\r\n        </button>\r\n\r\n        <span v-if="errorMsg" class="trp-save-ls-error">{{ errorMsg }}</span>\r\n    </div>\r\n\r\n    <teleport to="body">\r\n        <transition name="fade">\r\n            <div v-if="confirmRevert" class="trp-revert-confirm">\r\n                <p class="trp-revert-text trp-primary-text">\r\n                    {{ T.revertConfirmText }}\r\n                </p>\r\n\r\n                <div class="trp-revert-actions">\r\n                    <button class="trp-btn-revert trp-submit-btn" @click="doRevert">\r\n                        {{ T.revertBtn }}\r\n                    </button>\r\n                    <span class="trp-btn-cancel" @click="cancelRevert">\r\n                        {{ T.cancelBtn }}\r\n                    </span>\r\n                </div>\r\n            </div>\r\n        </transition>\r\n    </teleport>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-actions-overlay {\r\n    position: fixed;\r\n    inset: 0;\r\n    background:rgba(0,0,0,.35);\r\n    backdrop-filter:blur(2px);\r\n    z-index:1000\r\n}\r\n\r\n.trp-revert-confirm {\r\n    position: fixed;\r\n    z-index: 10001;\r\n    background: #FFFFFF;\r\n    border: 1px solid #e2e2e4;\r\n    border-radius: 8px;\r\n    max-width: 350px;\r\n    top: 50%;\r\n    left: 50%;\r\n    transform: translate(-50%, -50%);\r\n    padding: 15px;\r\n}\r\n\r\n.trp-revert-actions {\r\n    display: flex;\r\n    justify-content: center;\r\n    align-items: center;\r\n}\r\n\r\n.trp-revert-text {\r\n    text-align: center;\r\n}\r\n\r\n.trp-btn-revert {\r\n    margin-right: 10px;\r\n}\r\n\r\n.trp-btn-cancel {\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-btn-cancel:hover {\r\n    opacity: 0.8;\r\n}\r\n\r\n.trp-settings-actions {\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 12px;\r\n    margin-top: 24px;\r\n}\r\n\r\n.trp-button-secondary {\r\n    height: 40px;\r\n}\r\n\r\n.trp-button-secondary:hover svg path {\r\n    fill: white;\r\n}\r\n\r\n.trp-submit-btn {\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 8px;\r\n}\r\n\r\n.trp-submit-btn:disabled, .trp-button-secondary:disabled {\r\n    opacity: 0.8;\r\n    pointer-events: none;\r\n}\r\n\r\n.trp-save-spinner {\r\n    width: 14px;\r\n    height: 14px;\r\n    display: inline-block;\r\n\r\n    border: 2px solid rgba(255, 255, 255, 0.3); /* outer ring (faded) */\r\n    border-top-color: #ffffff;                 /* spinning top highlight */\r\n    border-radius: 50%;\r\n    animation: spin 0.6s linear infinite;\r\n}\r\n\r\n@keyframes spin {\r\n    to { transform: rotate(360deg); }\r\n}\r\n\r\n.trp-save-ls-error {\r\n    color: #c00;\r\n    font-size: 13px;\r\n    margin-left: 12px;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},941(){}},n={};function r(e){var i=n[e];if(void 0!==i)return i.exports;var o=n[e]={id:e,exports:{}};return t[e](o,o.exports,r),o.exports}r.m=t,e=[],r.O=(t,n,i,o)=>{if(!n){var s=1/0;for(d=0;d<e.length;d++){for(var[n,i,o]=e[d],a=!0,l=0;l<n.length;l++)(!1&o||s>=o)&&Object.keys(r.O).every(e=>r.O[e](n[l]))?n.splice(l--,1):(a=!1,o<s&&(s=o));if(a){e.splice(d--,1);var c=i();void 0!==c&&(t=c)}}return t}o=o||0;for(var d=e.length;d>0&&e[d-1][2]>o;d--)e[d]=e[d-1];e[d]=[n,i,o]},r.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return r.d(t,{a:t}),t},r.d=(e,t)=>{for(var n in t)r.o(t,n)&&!r.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},r.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),r.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),r.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},(()=>{var e={585:0,402:0};r.O.j=t=>0===e[t];var t=(t,n)=>{var i,o,[s,a,l]=n,c=0;if(s.some(t=>0!==e[t])){for(i in a)r.o(a,i)&&(r.m[i]=a[i]);if(l)var d=l(r)}for(t&&t(n);c<s.length;c++)o=s[c],r.o(e,o)&&e[o]&&e[o][0](),e[o]=0;return r.O(d)},n=self.webpackChunktranslatepress_multilingual=self.webpackChunktranslatepress_multilingual||[];n.forEach(t.bind(null,0)),n.push=t.bind(null,n.push.bind(n))})(),r.nc=void 0,r.O(void 0,[402],()=>r(693));var i=r.O(void 0,[402],()=>r(941));i=r.O(i)})();
//# sourceMappingURL=trp-lang-switcher-configurator.js.map