<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\PeopleService;

class DomainMembership extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * True if the person is in the viewer's Google Workspace domain.
     *
     * @var bool
     */
    public $inViewerDomain;
    /**
     * True if the person is in the viewer's Google Workspace domain.
     *
     * @param bool $inViewerDomain
     */
    public function setInViewerDomain($inViewerDomain)
    {
        $this->inViewerDomain = $inViewerDomain;
    }
    /**
     * @return bool
     */
    public function getInViewerDomain()
    {
        return $this->inViewerDomain;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\PeopleService\DomainMembership::class, 'Google\\Site_Kit_Dependencies\\Google_Service_PeopleService_DomainMembership');
